/*
 * Header of the proxy base class for communicating with a music player.
 *
 * Music Applet
 * Copyright (C) 2004-2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_PROXY_H
#define MA_PROXY_H

#include <glib-object.h>
#include <glade/glade-xml.h>

#include "ma-conf.h"


/*********************************************************************
 *
 * Proxy state enumeration
 *
 *********************************************************************/

#define MA_TYPE_PROXY_STATE	(ma_proxy_state_get_type ())

typedef enum
{
	MA_PROXY_STATE_DISABLED = 0,
	MA_PROXY_STATE_DISCONNECTED,
	MA_PROXY_STATE_CONNECTED,
} MaProxyState;

GType ma_proxy_state_get_type (void);


/*********************************************************************
 *
 * Proxy class
 *
 *********************************************************************/

#define MA_TYPE_PROXY		(ma_proxy_get_type ())
#define MA_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_PROXY, MaProxy))
#define MA_PROXY_CLASS(k) 	(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_PROXY, MaProxyClass))
#define MA_IS_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_PROXY))
#define MA_IS_PROXY_CLASS(k) 	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_PROXY))
#define MA_PROXY_GET_CLASS(o) 	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_PROXY, MaProxyClass))

typedef struct _MaProxy		MaProxy;
typedef struct _MaProxyClass	MaProxyClass;

struct _MaProxy
{
	GObject parent;
};

struct _MaProxyClass
{
	GObjectClass parent;

	/*< signals >*/

	void (*error_reported) (const gchar *primary, const gchar *secondary, gboolean important);

	/*< vtable >*/

	void (*toggle_playback) (MaProxy *proxy);
	void (*previous) (MaProxy *proxy);
	void (*next) (MaProxy *proxy);

	void (*rate_song) (MaProxy *proxy, gdouble rating);

	void (*prepare_prefs) (MaProxy *proxy, GladeXML *xml);

	void (*enable) (MaProxy *proxy);
	void (*disable) (MaProxy *proxy);

	void (*launch) (MaProxy *proxy);

	/* (optional overrides) */

	void (*poll_disconnected) (MaProxy *proxy);
	void (*poll_connected) (MaProxy *proxy);
};


GType		ma_proxy_get_type (void);

const gchar *	ma_proxy_get_title (MaProxy *proxy);

const gchar *	ma_proxy_get_artist (MaProxy *proxy);

const gchar *	ma_proxy_get_album (MaProxy *proxy);

glong		ma_proxy_get_duration (MaProxy *proxy);

gint		ma_proxy_get_elapsed (MaProxy *proxy);

gdouble		ma_proxy_get_rating (MaProxy *proxy);
void		ma_proxy_set_rating (MaProxy *proxy, gdouble rating);

MaProxyState	ma_proxy_get_state (MaProxy *proxy);

gboolean	ma_proxy_get_playing (MaProxy *proxy);

const gchar *	ma_proxy_get_name (MaProxy *proxy);

const gchar *	ma_proxy_get_icon_name (MaProxy *proxy);


void		ma_proxy_toggle_playback (MaProxy *proxy);
void		ma_proxy_previous (MaProxy *proxy);
void		ma_proxy_next (MaProxy *proxy);

void		ma_proxy_prepare_prefs (MaProxy *proxy, GladeXML *xml);

void		ma_proxy_enable (MaProxy *proxy);
void		ma_proxy_disable (MaProxy *proxy);

void		ma_proxy_launch (MaProxy *proxy);

/* The following functions are for subclasses' use only. */

void		_ma_proxy_set_connected (MaProxy *proxy, gboolean connected);
void		_ma_proxy_set_no_song (MaProxy *proxy);
void		_ma_proxy_set_title (MaProxy *proxy, const gchar *title);
void		_ma_proxy_set_artist (MaProxy *proxy, const gchar *artist);
void		_ma_proxy_set_album (MaProxy *proxy, const gchar *album);
void		_ma_proxy_set_duration (MaProxy *proxy, glong duration);
void		_ma_proxy_set_rating (MaProxy *proxy, gdouble rating);
void		_ma_proxy_set_playing (MaProxy *proxy, gboolean playing);
void		_ma_proxy_set_elapsed (MaProxy *proxy, gint elapsed);

MaConf *	_ma_proxy_get_conf (MaProxy *proxy);
void		_ma_proxy_set_icon_name (MaProxy *proxy, const gchar *icon_name);
void		_ma_proxy_launch_command (MaProxy *proxy, const gchar *key);
gboolean	_ma_proxy_should_refresh_stream_metadata (MaProxy *proxy);

void		_ma_proxy_report_error (MaProxy *proxy,
					const gchar *primary,
					const gchar *secondary,
					gboolean important);


#endif /* MA_PROXY_H */
