/*
// musixpss.c : MusiXTeX PostScript Slurs Extention Support Program
//
// Copyright (C) 2001 Kuuku (Hiroaki MORIMOTO)
//
// This is a part of `MusiXTeX PostScript Slurs Extention Package.'
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// Author:
//   Hiroaki MORIMOTO
//     Tokyo, Japan
//     E-mail: CQX05646@nifty.ne.jp
//
// based on musixtex.tex T.99, line 508-1233.
// MusiXTeX : (C) Daniel Taupin et al.
//
// June 1, 2002 version 0.41
//
*/

#define PROGDATE "June 1, 2002"
#define PROGVER "0.41"

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define PATH_DELIMITER '\\'    /* for MS-DOS, MS-Windows */
/* #define PATH_DELIMITER '/'    for unix */

int main(int argc, char *argv[])
{
	FILE *fsl;      /* .slu file */
	FILE *fmp;      /* this program's output == MetaPost input */
	char fname_sl[256], fname_mp[256];
	char slurlenstr[256];
	char buf[1024];
	char *wp;
	int slurid=0;
	int musicsize, slope;
	int height;
	int invert;    /* flag of \invertslur */
	int dotted;    /* flag of \dotted */
	double slurlen;
	char *init_code=
"path outline_outer, outline_inner, cutter_r, cutter_l;\n"
"\n"
"def drawslur =\n"
"\tif invert=0:\n"
"\t% normal slur\n"
"\t\tx1=0;      y1=0;\n"
"\t\tx2=0.12ux; y2=0.12sy+0.56uy;\n"
"\t\tx3=0.30ux; y3=0.30sy+0.9uy;\n"
"\t\tx4=0.50ux; y4=0.50sy+1.0uy;\n"
"\t\tx5=0.70ux; y5=0.70sy+0.9uy;\n"
"\t\tx6=0.88ux; y6=0.88sy+0.56uy;\n"
"\t\tx7=ux;     y7=sy;\n"
"\telse:\n"
"\t% inverted slur\n"
"\t\tx1=0;      y1=0;\n"
"\t\tx2=0.12ux; y2=0.12sy+0.56uy;\n"
"\t\tx3=0.30ux; y3=0.30sy+0.43uy;\n"
"\t\tx4=0.50ux; y4=0.50sy;\n"
"\t\tx5=0.70ux; y5=0.70sy-0.43uy;\n"
"\t\tx6=0.88ux; y6=0.88sy-0.56uy; \n"
"\t\tx7=ux;     y7=sy;\n"
"\tfi\n"
"\n"
"\tpenpos1(0.18thick, angle(z2-z1)+ 90);\n"
"\tpenpos2(0.25thick, angle(z3-z2)+ 90);\n"
"\tpenpos3(0.60thick, angle(z4-z3)+ 90);\n"
"\tpenpos4(    thick, angle(z5-z3)+ 90);\n"
"\tpenpos5(0.60thick, angle(z5-z4)+ 90);\n"
"\tpenpos6(0.25thick, angle(z6-z5)+ 90);\n"
"\tpenpos7(0.18thick, angle(z7-z6)+ 90);\n"
"\toutline_outer := z1r..z2r..z3r..z4r..z5r..z6r..z7r;\n"
"\toutline_inner := z1l..z2l..z3l..z4l..z5l..z6l..z7l;\n"
"\n"
"\tif makedotted=0:\n"
"\t\t% solid slur\n"
"\t\tfill outline_outer--reverse outline_inner--cycle;\n"
"\telse:\n"
"\t\t% dotted slur\n"
"\t\tslurlen:=abs(z2-z1)+abs(z3-z2)+abs(z4-z3)+abs(z5-z4)+abs(z6-z5)+abs(z7-z6);\n"
"\t\ttcount:=floor((slurlen+(dashunit*(1-dashduty)))/dashunit);\n"
"\t\tdashunit:=slurlen/(tcount*dashunit*dashduty+(tcount-1)*dashunit*(1-dashduty))*dashunit;\n"
"\t\t\n"
"\t\tfor kk=0 upto tcount-1:\n"
"\t\t\ttracerpoint:=kk*dashunit;\n"
"\t\t\ttt:=tracerpoint/slurlen*6;\n"
"\t\t\tif invert=0:\n"
"\t\t\t\tif uy>0:\n"
"\t\t\t\t\tx10:=0.5ux;\n"
"\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\ty10:=min(sy,0)-uy;\n"
"\t\t\t\t\ty11:=max(sy,0)+2uy;\n"
"\t\t\t\telse:\n"
"\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\tx11:=0.5ux;\n"
"\t\t\t\t\ty10:=min(sy,0)+2uy;\n"
"\t\t\t\t\ty11:=max(sy,0)-uy;\n"
"\t\t\t\tfi;\n"
"\t\t\telse:\n"
"\t\t\t\tif kk<(tcount-1)/2:\n"
"\t\t\t\t\tif uy>0:\n"
"\t\t\t\t\t\tx10:=0.25ux;\n"
"\t\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,0)-uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,0)+2uy;\n"
"\t\t\t\t\telse:\n"
"\t\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\tx11:=0.25ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,0)+2uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,0)-uy;\n"
"\t\t\t\t\tfi;\n"
"\t\t\t\telse:\n"
"\t\t\t\t\tif uy>0:\n"
"\t\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\tx11:=0.75ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,sy)-2uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,sy)+uy;\n"
"\t\t\t\t\telse:\n"
"\t\t\t\t\t\tx10:=0.75ux;\n"
"\t\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,sy)+uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,sy)-2uy;\n"
"\t\t\t\t\tfi;\n"
"\t\t\t\tfi;\n"
"\t\t\tfi;\n"
"\n"
"\t\t\tcutter_l:=\n"
"\t\t\t\tz10--(point tt of outline_inner)--(point tt of outline_outer)--z11;\n"
"\n"
"\t\t\ttracerpoint:=kk*dashunit+(dashunit*dashduty);\n"
"\t\t\ttt:=tracerpoint/slurlen*6;\n"
"\n"
"\t\t\tif invert=0:\n"
"\t\t\t\tif uy>0:\n"
"\t\t\t\t\tx10:=0.5ux;\n"
"\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\ty10:=min(sy,0)-uy;\n"
"\t\t\t\t\ty11:=max(sy,0)+2uy;\n"
"\t\t\t\telse:\n"
"\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\tx11:=0.5ux;\n"
"\t\t\t\t\ty10:=min(sy,0)+2uy;\n"
"\t\t\t\t\ty11:=max(sy,0)-uy;\n"
"\t\t\t\tfi;\n"
"\t\t\telse:\n"
"\t\t\t\tif kk<(tcount-1)/2:\n"
"\t\t\t\t\tif uy>0:\n"
"\t\t\t\t\t\tx10:=0.25ux;\n"
"\t\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,0)-uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,0)+2uy;\n"
"\t\t\t\t\telse:\n"
"\t\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\tx11:=0.25ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,0)+2uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,0)-uy;\n"
"\t\t\t\t\tfi;\n"
"\t\t\t\telse:\n"
"\t\t\t\t\tif uy>0:\n"
"\t\t\t\t\t\tx10:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\tx11:=0.75ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,sy)-2uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,sy)+uy;\n"
"\t\t\t\t\telse:\n"
"\t\t\t\t\t\tx10:=0.75ux;\n"
"\t\t\t\t\t\tx11:=kk/(tcount-1)*ux;\n"
"\t\t\t\t\t\ty10:=min(0.5sy,sy)+uy;\n"
"\t\t\t\t\t\ty11:=max(0.5sy,sy)-2uy;\n"
"\t\t\t\t\tfi;\n"
"\t\t\t\tfi;\n"
"\t\t\tfi;\n"
"\n"
"\t\t\tcutter_r:=\n"
"\t\t\t\tz10--(point tt of outline_inner)--(point tt of outline_outer)--z11;\n"
"\n"
"\t\t\tfill buildcycle (\n"
"\t\t\t\treverse outline_inner, cutter_l, outline_outer, cutter_r\n"
"\t\t\t);\n"
"\t\tendfor;\n"
"\tfi\n"
"enddef;\n"
"\n"
; /* end of char *init_code */
	
	printf("MusiXTeX PostScript Slurs Extention Support version "PROGVER" <"PROGDATE">\n");
	if(argc<2){
		printf(
			"\tusage: musixpss <filename>\n"
			"\tsee documentation for details.\n"
		);
		return(1);
	}
	

	/* perform filenames */
	strcpy(fname_sl, argv[1]);
	strcpy(fname_mp, argv[1]);
	if((wp=strrchr(fname_mp, '.'))!=NULL && wp>strrchr(fname_mp, PATH_DELIMITER)){
		/* There's filename extention */
		*wp='\0';
	}else{
		/* There's no filename extention ... ".slu" added */
		strcat(fname_sl, ".slu");
	}
	strcat(fname_mp, ".mp");
	
	if((fsl=fopen(fname_sl, "r"))==NULL){
		printf("Error: can't open file `%s'\n", fname_sl);
		return(1);
	}
	
	if((fmp=fopen(fname_mp, "w"))==NULL){
		printf("Error: can't create file `%s'\n", fname_mp);
		return(1);
	}
	
	printf("Now processing %s -> %s\n", fname_sl, fname_mp);
	
	fprintf(fmp, "%% generated by musixpss v"PROGVER" from %s\n", fname_sl);
	fprintf(fmp, "prologues:=1;\n");

	fprintf(fmp, "%s\n", init_code);
	
	while(fgets(buf, 1024, fsl)!=NULL){
		printf(".");
		
		if((wp=strtok(buf, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		musicsize=atoi(wp);
		if((wp=strtok(NULL, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		slope=atoi(wp);
		if((wp=strtok(NULL, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		strcpy(slurlenstr, wp);
		slurlen=atof(wp);
		if((wp=strtok(NULL, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		height=atoi(wp);
		if((wp=strtok(NULL, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		invert=atoi(wp);
		if((wp=strtok(NULL, ",\n"))==NULL){
			printf("slu file error, not enough parameters.\n");
			exit(1);
		}
		dotted=atoi(wp);
		
		slurid++;
		
		fprintf(fmp, "beginfig(%d)\n", slurid);
		fprintf(fmp, "\tux:=%s;\n", slurlenstr);
		fprintf(fmp, "\tuy:=%.5fpt;\n", musicsize/8.0*height);
		fprintf(fmp, "\tsy:=%.5fpt;\n", musicsize/8.0*slope);
		fprintf(fmp, "\tthick:=%.2fpt;\n", musicsize/20.0);
		fprintf(fmp, "\tdashunit:=%.2fpt;\n", musicsize/4.0);
		fprintf(fmp, "\tdashduty:=0.7;\n");
		fprintf(fmp, "\tinvert:=%d;\n", invert);
		fprintf(fmp, "\tmakedotted:=%d;\n", dotted);
		fprintf(fmp, "\tdrawslur;\n");
		fprintf(fmp, "endfig;\n\n");
	}
	fprintf(fmp, "end.\n");
	
	printf("\nCompleted. %d slur(s) performed.\n", slurid);
	return(0);
	
}

