/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

                          uilocalsocket.h  -  description
                             -------------------
    begin                : Wed Mar 26 2003
    copyright            : (C) 2003 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef UILOCALSOCKET_H
#define UILOCALSOCKET_H

class MUILSocketListen;
class MUILSocketCommunicate;
class MUILSockPriv;

class MUILocalSocket : public MUI  {
public: 
	MUILocalSocket();
	virtual ~MUILocalSocket();
	//
	virtual bool Attach(MController* pC);
	virtual bool Init();
	virtual void Detach();
	virtual void Do();
	virtual void Stop();
	virtual MMutex* GetMutex(){return &m_mutex;}
	//
	void AddSocket(MUILSocketCommunicate*);
	void RemoveSocket(MUILSocketCommunicate*);
	MUILSockPriv* GetInterpreter() { ASSERT(m_pPriv); return m_pPriv; }
	bool IsEnabled() { return m_bEnable; }
	bool IsExecEnabled() { return m_bEnableExec; }
	void StopUnlocked();
protected:
	MMutex m_mutex;
	MUILSockPriv* m_pPriv;

	MUILSocketListen*            m_pListen;
	list<MUILSocketCommunicate*> m_listCommunicate;
	MController* m_pCtrl;

	char m_szSocketPath[128];
	bool m_bEnable;
	bool m_bEnableExec;

	CString m_sListenSockPath;

	MWaitCondition m_waitStop;
};
                                   
#endif
