// analysisfun.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// AnalysisFunctions are DataModifiers which create an internal analysis data
// object of the correct type, and load the appropriate analysis into it.

#ifndef ANALYSISFUN_H
#ifdef __GNUG__
#pragma interface
#endif
#define ANALYSISFUN_H

#include "datamodifier.h"

class AnalysisFunction : public DataModifier {
	typedef DataModifier Super;
public:
	AnalysisFunction(Data* data) : DataModifier(data, false), myAnalysis(nil) {}
	virtual ~AnalysisFunction();
	redefined Modifier* createUndo();
	virtual Data* getAnalysis() { return myAnalysis; }
protected:
	virtual int analysisLength() = 0;	// for creating analysis object
	void setAnalysis(Data *);
private:
	Data* myAnalysis;
};

// these are not really a modifier of the data, but the interface is identical

class Requester;

class EnvelopeExtracter : public AnalysisFunction {
	typedef AnalysisFunction Super;
	friend class EnvelopeExtractRequester;
public:
	EnvelopeExtracter(Data* d);
	static Modifier* create(DataEditor *);
	redefined const char* message() { return "Extracting envelope..."; }
protected:
	redefined int analysisLength() { return envelopeLength; }
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int doApply(Data *);
private:
	ChoiceValue envelopeType;
	int envelopeLength;
private:
	static ChoiceValue _savedEnvelopeType;
	static int _savedEnvelopeLength;
};

class SlopeChangeDetecter : public AnalysisFunction {
	typedef AnalysisFunction Super;
	friend class SlopeChangeDetectRequester;
protected:
	enum SearchMode { Positive = 1, Negative = 2, Either = 4 };
public:
	SlopeChangeDetecter(Data *);
	SlopeChangeDetecter(Data *, double slopeFactor,
			    int framesize, ChoiceValue mode=Either);
	static Modifier* create(DataEditor *);
	redefined const char* message() { return "Searching for slope change..."; }
protected:
	redefined int analysisLength();
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int doApply(Data *);
private:
	double slopeFactor;
	int frameSize;
	ChoiceValue searchMode;
	
	static double _savedSlopeFactor;
	static int _savedFrameSize;
	static ChoiceValue _savedSearchMode;
};

#endif

