// pvocrequester.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef PVOC_REQUESTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define PVOC_REQUESTER_H

#include "requester.h"
#include "phasevocoder.h"

class PvocRequester : public TitledRequester {
public:
	PvocRequester(const char* title, PhaseVocoder::Info &info)
		: TitledRequester(title),
		  _pvocInfo(info), _windowType(info.K ? Kaiser : Hanning) {}
protected:
	redefined void configureRequest(Request *);
	redefined boolean confirmValues();
protected:
	enum WindowType { Hanning = 0x1, Kaiser = 0x2 };
	PhaseVocoder::Info& _pvocInfo;
	ChoiceValue _windowType;
};

#endif
