<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["folderid"]) || !is_numeric($_GET["folderid"]) || intval($_GET["folderid"])<1) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}
$folderid = $_GET["folderid"];
$folder = getFolder($folderid);
if (!is_object($folder)) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}

$folderPathHTML = getFolderPathHTML($folder, true);
UI::htmlStartPage(getMLText("folder_title", array("foldername" => $folder->getName())));
UI::globalNavigation($folder);

if ($folderid == $settings->_rootFolderID || !$folder->getParent()) {
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainer(getMLText("cannot_move_root"));
	UI::htmlEndPage();
	exit;
}

if (!isset($_GET["targetid"]) || !is_numeric($_GET["targetid"]) || intval($_GET["targetid"])<1) {
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainer(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}
$targetid = $_GET["targetid"];
$targetFolder = getFolder($targetid);
if (!is_object($targetFolder)) {
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainer(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}

if ($folder->getAccessMode($user) < M_READWRITE || $targetFolder->getAccessMode($user) < M_READWRITE) {
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

if ($folder->setParent($targetFolder)) {
	$folderPathHTML = getFolderPathHTML($folder, true);
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainerStart();
	printMLText("moving_folder");
	printMLText("op_finished");
}
else {
	UI::pageNavigation($folderPathHTML, "view_folder", $folder);
	UI::contentHeading(getMLText("move_folder"));
	UI::contentContainerStart();
	printMLText("moving_folder");
	printMLText("error_occured");
}
UI::contentContainerEnd();
UI::htmlEndPage();
?>
