# Stubs for redis.connection (Python 2)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any

ssl_available = ...  # type: Any
hiredis_version = ...  # type: Any
HIREDIS_SUPPORTS_CALLABLE_ERRORS = ...  # type: Any
HIREDIS_SUPPORTS_BYTE_BUFFER = ...  # type: Any
msg = ...  # type: Any
HIREDIS_USE_BYTE_BUFFER = ...  # type: Any
SYM_STAR = ...  # type: Any
SYM_DOLLAR = ...  # type: Any
SYM_CRLF = ...  # type: Any
SYM_EMPTY = ...  # type: Any
SERVER_CLOSED_CONNECTION_ERROR = ...  # type: Any

class Token:
    value = ...  # type: Any
    def __init__(self, value) -> None: ...

class BaseParser:
    EXCEPTION_CLASSES = ...  # type: Any
    def parse_error(self, response): ...

class SocketBuffer:
    socket_read_size = ...  # type: Any
    bytes_written = ...  # type: Any
    bytes_read = ...  # type: Any
    def __init__(self, socket, socket_read_size) -> None: ...
    @property
    def length(self): ...
    def read(self, length): ...
    def readline(self): ...
    def purge(self): ...
    def close(self): ...

class PythonParser(BaseParser):
    encoding = ...  # type: Any
    socket_read_size = ...  # type: Any
    def __init__(self, socket_read_size) -> None: ...
    def __del__(self): ...
    def on_connect(self, connection): ...
    def on_disconnect(self): ...
    def can_read(self): ...
    def read_response(self): ...

class HiredisParser(BaseParser):
    socket_read_size = ...  # type: Any
    def __init__(self, socket_read_size) -> None: ...
    def __del__(self): ...
    def on_connect(self, connection): ...
    def on_disconnect(self): ...
    def can_read(self): ...
    def read_response(self): ...

DefaultParser = ...  # type: Any

class Connection:
    description_format = ...  # type: Any
    pid = ...  # type: Any
    host = ...  # type: Any
    port = ...  # type: Any
    db = ...  # type: Any
    password = ...  # type: Any
    socket_timeout = ...  # type: Any
    socket_connect_timeout = ...  # type: Any
    socket_keepalive = ...  # type: Any
    socket_keepalive_options = ...  # type: Any
    retry_on_timeout = ...  # type: Any
    encoding = ...  # type: Any
    encoding_errors = ...  # type: Any
    decode_responses = ...  # type: Any
    def __init__(self, host=..., port=..., db=..., password=..., socket_timeout=..., socket_connect_timeout=..., socket_keepalive=..., socket_keepalive_options=..., retry_on_timeout=..., encoding=..., encoding_errors=..., decode_responses=..., parser_class=..., socket_read_size=...) -> None: ...
    def __del__(self): ...
    def register_connect_callback(self, callback): ...
    def clear_connect_callbacks(self): ...
    def connect(self): ...
    def on_connect(self): ...
    def disconnect(self): ...
    def send_packed_command(self, command): ...
    def send_command(self, *args): ...
    def can_read(self): ...
    def read_response(self): ...
    def encode(self, value): ...
    def pack_command(self, *args): ...
    def pack_commands(self, commands): ...

class SSLConnection(Connection):
    description_format = ...  # type: Any
    keyfile = ...  # type: Any
    certfile = ...  # type: Any
    cert_reqs = ...  # type: Any
    ca_certs = ...  # type: Any
    def __init__(self, ssl_keyfile=..., ssl_certfile=..., ssl_cert_reqs=..., ssl_ca_certs=..., **kwargs) -> None: ...

class UnixDomainSocketConnection(Connection):
    description_format = ...  # type: Any
    pid = ...  # type: Any
    path = ...  # type: Any
    db = ...  # type: Any
    password = ...  # type: Any
    socket_timeout = ...  # type: Any
    retry_on_timeout = ...  # type: Any
    encoding = ...  # type: Any
    encoding_errors = ...  # type: Any
    decode_responses = ...  # type: Any
    def __init__(self, path=..., db=..., password=..., socket_timeout=..., encoding=..., encoding_errors=..., decode_responses=..., retry_on_timeout=..., parser_class=..., socket_read_size=...) -> None: ...

class ConnectionPool:
    @classmethod
    def from_url(cls, url, db=..., **kwargs): ...
    connection_class = ...  # type: Any
    connection_kwargs = ...  # type: Any
    max_connections = ...  # type: Any
    def __init__(self, connection_class=..., max_connections=..., **connection_kwargs) -> None: ...
    pid = ...  # type: Any
    def reset(self): ...
    def get_connection(self, command_name, *keys, **options): ...
    def make_connection(self): ...
    def release(self, connection): ...
    def disconnect(self): ...

class BlockingConnectionPool(ConnectionPool):
    queue_class = ...  # type: Any
    timeout = ...  # type: Any
    def __init__(self, max_connections=..., timeout=..., connection_class=..., queue_class=..., **connection_kwargs) -> None: ...
    pid = ...  # type: Any
    pool = ...  # type: Any
    def reset(self): ...
    def make_connection(self): ...
    def get_connection(self, command_name, *keys, **options): ...
    def release(self, connection): ...
    def disconnect(self): ...
