//
//  mxUtils.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 9/20/04.
//  Copyright 2004 MySQL AB. All rights reserved.
//

#import "mxUtils.h"

#define N_(s) s


void MXRunAlertPanelWithError(NSString *title, NSString *message, MYX_LIB_ERROR error)
{
  static NSString *msgs[]= {
    @"",
    N_(@"Can't open file."),
    N_(@"Can't connect to server instance."),
    N_(@"Error parsing XML file."),
    N_(@"Error parsing XML file (bad document)."),
    N_(@"Error parsing XML file (empty document)."),
    N_(@"Error executing SQL command."),
    N_(@"Executing stopped."),
    N_(@"Internal error in libxml (could not change memory allocators)."),
    N_(@"The object was not found in the database."),
    N_(@"Cannot read from file."),
    N_(@"Error during character set conversion."),
    N_(@"Invalid character set specified.")
  };
  
  NSRunAlertPanel(title, @"%@\n%@", nil, nil, nil, message, 
                  NSLocalizedString(msgs[error],nil));
}

void MXRunAlertPanelWithMySQLError(NSString *title, NSString *message, MYSQL *mysql)
{
  char *tmp;
  NSRunAlertPanel(title, @"%@\n%s (error %i)", nil, nil, nil, message, 
                  tmp= myx_mysql_error(mysql), myx_mysql_errno(mysql));
  g_free(tmp);
}
