function run_test(connection_file,draft_file,charset,
                  backup_profile_file,target_schema,
                  progress_log_file,warnings_file)
{
  var cmd_line= "Debug\\test_restore_backup.exe"
  cmd_line+= " " + connection_file
  cmd_line+= " " + draft_file
  cmd_line+= " " + charset
  cmd_line+= " " + backup_profile_file
  cmd_line+= " " + target_schema
  cmd_line+= " 5"
  cmd_line+= " " + progress_log_file
  cmd_line+= " x"
  cmd_line+= " " + warnings_file
  cmd_line+= " y"
    
  exec_to_stdout(cmd_line)
}

function check(server,file_name,charset,target_schema,test_prompt)
{
  if (!server.enabled)
  {
    print_test_skipped(test_prompt)
  }
  else
  {
    var connection_file=      "t\\" + file_name + ".test.connection.xml"
    var prepared_connection=  "t\\" + file_name + ".test.connection.prepared.xml"
    var backup_file_src=      "t\\" + file_name + ".test.backup.sql"
    var backup_profile_file=  "t\\" + file_name + ".test.backup_profile.xml"
    var draft_file=           "r\\" + file_name + ".mysqldump.draft.sql"

    var progress_log_file=    "r\\" + file_name + ".progress.log"
    var progress_log_etalon=  "r\\" + file_name + ".progress.etalon.log"
    var progress_log_diff=    "r\\" + file_name + ".progress.log.diff"

    var warnings_file=        "r\\" + file_name + ".warnings.log"
    var warnings_etalon=      "r\\" + file_name + ".warnings.etalon.log"
    var warnings_diff=        "r\\" + file_name + ".warnings.diff"

    var backup_file=          "r\\" + file_name + ".mysqldump.sql"
    var backup_etalon=        "r\\" + file_name + ".mysqldump.etalon.sql"
    var backup_diff=          "r\\" + file_name + ".mysqldump.diff"

    server.prepare_connection_file(connection_file,prepared_connection)
    run_test(prepared_connection,backup_file_src,charset,
             backup_profile_file,target_schema,
             progress_log_file,warnings_file)
    fso.GetFile(prepared_connection).Delete()
  
    server.mysqldump("--databases test", draft_file)
    server.execute_script("t\\" + file_name + ".test.clean.sql")
    discard_volatile_results(draft_file,backup_file)

    var fc_result1= compare_results(progress_log_etalon, progress_log_file,  progress_log_diff)
    var fc_result2= compare_results(    warnings_etalon,     warnings_file,      warnings_diff)
    var fc_result3= compare_results(      backup_etalon,       backup_file,        backup_diff)

    print_test_res(test_prompt,fc_result1+fc_result2+fc_result3)
  }
}

try
{
  print_title("test restore backup")
  server_40.safe_start()
  server_41.safe_start()
  server_50.safe_start()
  copy_dlls()

  check(server_40, "mysql_40_simple", "latin1", "0", "simple backup of mysql-4.0")
  check(server_41, "mysql_41_simple", "latin1", "0", "simple backup of mysql-4.1")
  check(server_41, "mysql_41_cp1251", "cp1251", "0", "simple backup of mysql-4.1 with cp1251 charset")

  //server_50.enabled= false
  check(server_50, "mysql_50_simple", "latin1", "0", "simple backup of mysql-5.0")
  check(server_50, "mysql_50_cp1251", "cp1251", "0", "simple backup of mysql-5.0 with cp1251 charset")
}
finally
{
  server_40.safe_stop()
  server_41.safe_stop()
  server_50.safe_stop()
  clear_dlls()
  print_footer()
}
