//
//  MQResultSetDataSource.m
//  MySQL QueryBrowser
//
//  Created by Alfredo Kojima on 3/6/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MQResultSetDataSource.h"
#include "MYXResultSet.h"

@implementation MQResultSetDataSource

static MYXResultSetCallbacks callbacks= {
  NULL,
  NULL,
  NULL
};

- (id)initWithResultSet:(MYX_RESULTSET*)rs
{
  self= [super init];
  if (self)
  {
	_resultSet= new MYXResultSet(rs, callbacks);
	_zone= NSCreateZone(256*1024, 64*1024, NO);
  }
  return self;
}

- (MYX_RESULTSET*)resultset
{
  return _resultSet->get_resultset();
}

- (void)dealloc
{
  NSRecycleZone(_zone);
  delete _resultSet;
  [super dealloc];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  return _resultSet->get_row_count();
}

- (id)tableView:(NSTableView *)aTableView
 objectValueForTableColumn:(NSTableColumn *)aTableColumn
			row:(int)rowIndex
{
  int column= [[aTableColumn identifier] intValue];
  char *value;
  size_t length;
  
  if (_resultSet->get(rowIndex, column, value, length))
  {
    if (_resultSet->get_column_type(column) == MYX_RSCT_BLOB)
      return @"";
    else
      return [[NSString allocWithZone:_zone] initWithBytesNoCopy:value
                                                          length:length
                                                        encoding:NSUTF8StringEncoding
                                                    freeWhenDone:NO];
  }
  else
    return nil;
}


- (void)tableView:(NSTableView *)aTableView 
   setObjectValue:(id)anObject 
   forTableColumn:(NSTableColumn *)aTableColumn 
			  row:(int)rowIndex
{
  int column= [[aTableColumn identifier] intValue];
  id ovalue= [self tableView:aTableView
   objectValueForTableColumn:aTableColumn
						 row:rowIndex];
  unsigned int nr;
  if (ovalue && [ovalue isEqualTo:anObject])
	return;

  nr= _resultSet->get_row_count();
  if ([anObject isKindOfClass:[NSString class]])
    _resultSet->set(rowIndex, column, (const char*)[anObject cString], [anObject length]);
  else
    _resultSet->set(rowIndex, column, (const char*)[anObject bytes], [anObject length]);

  if (_resultSet->get_row_count() != nr)
    [aTableView noteNumberOfRowsChanged];
}


- (void)addRow
{
  _resultSet->add_row();
}


- (void)deleteRow:(int)rowIndex
{
  _resultSet->delete_row(rowIndex);
}


- (BOOL)isEditable
{
  return _resultSet->get_resultset()->editable;
}

- (BOOL)editing
{
  return _editEnabled;
}

- (void)setEditing:(BOOL)flag
{
  _resultSet->set_placeholder_enabled(flag);
  _editEnabled= flag;
}


- (MYXRSEditStatus)statusOfRow:(int)row
				   column:(int)column
{
  return _resultSet->get_edit_status(row, column);
}

- (void)preCommit
{
  _resultSet->pre_commit();
}

- (void)postCommit:(BOOL)failed
{
  _resultSet->post_commit(failed);
}

- (void)discardChanges
{
  _resultSet->discard_changes();
}

@end
