/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.AsciiProcedurePutval;
import com.sap.dbtech.jdbc.translators.BinaryProcedurePutval;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Getval;
import com.sap.dbtech.jdbc.translators.GetvalLob;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.RawByteReader;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class ProcedureStreamTranslator
extends DBTechTranslator {
    ProcedureStreamTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        super(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public int getColumnDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (this.isBinary()) {
            if (inputStream == null) {
                return null;
            }
            return new BinaryProcedurePutval(this, inputStream, n);
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.bytes"));
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        if (this.isAscii()) {
            return new AsciiProcedurePutval(this, StringUtil.bytes_iso8859_1(string));
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        if (this.isAscii()) {
            if (reader == null) {
                return null;
            }
            return new AsciiProcedurePutval(this, new ReaderInputStream(reader, false), n);
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return this.transBinaryStreamForInput(null, -1);
        }
        return this.transBinaryStreamForInput(new ByteArrayInputStream(byArray), -1);
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        AbstractProcedurePutval abstractProcedurePutval = (AbstractProcedurePutval)object;
        abstractProcedurePutval.putDescriptor(dataPart);
    }

    protected Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof InputStream) {
            object2 = this.transAsciiStreamForInput((InputStream)object, -1);
        }
        return object2;
    }

    public Object transAsciiStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (this.isAscii()) {
            if (inputStream == null) {
                return null;
            }
            return new AsciiProcedurePutval(this, inputStream, n);
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    private boolean isAscii() {
        return this.dataType == 6 || this.dataType == 19;
    }

    private boolean isBinary() {
        return this.dataType == 8 || this.dataType == 21;
    }

    private InputStream getStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        InputStream inputStream = null;
        Getval getval = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
            if (this.descriptorIsNull(byArray)) {
                return null;
            }
            getval = DriverSapDB.isJDBC20 ? new GetvalLob(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType) : new Getval(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType);
            inputStream = ((AbstractGetval)getval).getAsciiStream();
        }
        return inputStream;
    }

    public InputStream getAsciiStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getStream(sQLParamController, structuredMem, structuredMem2);
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        if (this.isBinary()) {
            return this.getStream(sQLParamController, structuredMem, structuredMem2);
        }
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.binaryreadfromlong"));
    }

    private GetvalLob getLob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        GetvalLob getvalLob = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
            if (this.descriptorIsNull(byArray)) {
                return null;
            }
            getvalLob = new GetvalLob(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType);
        }
        return getvalLob;
    }

    public Blob getBlob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getLob(sQLParamController, structuredMem, structuredMem2);
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (this.isNull(sQLParamController, structuredMem)) {
            return 0;
        }
        byArray = this.getBytes(sQLParamController, structuredMem);
        return byArray[0];
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = this.getBinaryStream(sQLParamController, structuredMem, sQLParamController.getReplyData());
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[4096];
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                if (n >= 4096) {
                    n = inputStream.read(byArray);
                    continue;
                }
                break;
            }
        }
        catch (StreamIOException streamIOException) {
            throw streamIOException.getSqlException();
        }
        catch (IOException iOException) {
            throw new JDBCDriverException(iOException.getMessage(), sQLParamController);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Reader getCharacterStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        InputStream inputStream = this.getAsciiStream(sQLParamController, structuredMem, structuredMem2);
        if (inputStream == null) {
            return null;
        }
        return new RawByteReader(inputStream);
    }

    public Clob getClob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getLob(sQLParamController, structuredMem, structuredMem2);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader = this.getCharacterStream(sQLParamController, structuredMem, sQLParamController.getReplyData());
        if (reader == null) {
            return null;
        }
        try {
            int n;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) > 0) {
                stringBuffer.append(new String(cArray, 0, n));
                if (n >= 4096) continue;
                break;
            }
        }
        catch (StreamIOException streamIOException) {
            throw streamIOException.getSqlException();
        }
        catch (IOException iOException) {
            throw new JDBCDriverException(iOException.getMessage(), sQLParamController);
        }
        return stringBuffer.toString();
    }

    protected boolean descriptorIsNull(byte[] byArray) {
        return byArray[25] == 1;
    }
}

