unit AdminUsers;
 
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, TntForms,
  TntDialogs, ExtCtrls, ComCtrls, TntStdCtrls, StrUtils,
  Buttons, Menus, Contnrs, ApplicationDataModule,
  AuxFuncs, myx_public_interface, myx_admin_public_interface,
  MySQLConnection, AdvancedEdit, Grids, ValEdit, SchemataTreeView,
  Sections, InstanceSections, PNGImage, Options, MyxError,
  VirtualTrees, TntMenus, TntExtCtrls, TntComCtrls, Forms, StdCtrls,
  TntButtons, gnugettext;

type
  TAdminUsersForm = class(TInstanceSectionForm)
    UserPnl: TTntPanel;
    UserPageControl: TTntPageControl;
    SchemataPrivSheet: TTabSheet;
    Label7: TTntLabel;
    Label6: TTntLabel;
    Panel2: TTntPanel;
    DBBevel: TTntBevel;
    SchemaPrivNameLbl: TTntLabel;
    Header3Img: TTntImage;
    AssignSchemaPrivBtn: TTntBitBtn;
    RemoveSchemaPrivBtn: TTntBitBtn;
    SchemaPrivAvailListView: TTntListView;
    SchemaPrivAssignedListView: TTntListView;
    TablePrivSheet: TTabSheet;
    Panel5: TTntPanel;
    TableBevel: TTntBevel;
    TableColumnPrivNameLbl: TTntLabel;
    Header4Img: TTntImage;
    SubTreePnl: TTntPanel;
    UserTreeView: TTntTreeView;
    Splitter1: TTntSplitter ;
    UserInfoSheet: TTabSheet;
    Panel1: TTntPanel;
    UserInfoBevel: TTntBevel;
    UserInfoNameLbl: TTntLabel;
    HeaderImg: TTntImage;
    UserInfoScrollBox: TTntScrollBox;
    UserInfoLoginGBox: TTntGroupBox;
    Label27: TTntLabel;
    Label28: TTntLabel;
    Label3: TTntLabel;
    Label11: TTntLabel;
    Label12: TTntLabel;
    Label13: TTntLabel;
    UserNameEd: TTntEdit;
    PasswordEd: TTntEdit;
    PasswordConfirmationEd: TTntEdit;
    UserInfoAdditionalGBox: TTntGroupBox;
    Label23: TTntLabel;
    Label25: TTntLabel;
    Label24: TTntLabel;
    Label26: TTntLabel;
    Label29: TTntLabel;
    Label30: TTntLabel;
    FullNameEd: TTntEdit;
    DescriptionEd: TTntEdit;
    LoadImgBtn: TTntBitBtn;
    Panel7: TTntPanel;
    UserIcon: TTntImage;
    UserSubTreePopupMenu: TTntPopupMenu;
    CloneUserMI: TTntMenuItem;
    AddHosttotheUserMI: TTntMenuItem;
    N1: TTntMenuItem;
    AddnewUserMI: TTntMenuItem;
    N2: TTntMenuItem;
    DeleteUserMI: TTntMenuItem;
    GlobalPrivSheet: TTabSheet;
    Panel9: TTntPanel;
    GlobalBevel: TTntBevel;
    GlobalPrivNameLbl: TTntLabel;
    Header2Img: TTntImage;
    Label15: TTntLabel;
    AssignGlobalPrivBtn: TTntBitBtn;
    RemoveGlobalPrivBtn: TTntBitBtn;
    GlobalPrivListView: TTntListView;
    GlobalAssignedPrivListView: TTntListView;
    Label16: TTntLabel;
    Panel3: TTntPanel;
    BottomBtnPnl: TTntPanel;
    DiscardChangesBtn: TTntButton;
    NewUserBtn: TTntButton;
    SubTreeSearchPnl: TTntPanel;
    Label1: TTntLabel;
    Label5: TTntLabel;
    Label18: TTntLabel;
    Label19: TTntLabel;
    EmailEd: TTntEdit;
    Label20: TTntLabel;
    ContactInfoMemo: TTntMemo;
    UserInfoLbl: TTntLabel;
    GlobalPrivInfoLbl: TTntLabel;
    SchemaPrivInfoLbl: TTntLabel;
    TableColumnPrivInfoLbl: TTntLabel;
    N3: TTntMenuItem;
    RefreshUserListMI: TTntMenuItem;
    ApplyChangesBtn: TTntButton;
    AdvancedEdit: TAdvancedEditFrame;
    Panel4: TTntPanel;
    SchemaPrivSchemataFrame: TSchemataFrame;
    ResourceSheet: TTabSheet;
    Panel6: TTntPanel;
    ResourceBevel: TTntBevel;
    ResourceNameLbl: TTntLabel;
    Header5Img: TTntImage;
    ResourcesInfoLbl: TTntLabel;
    ScrollBox2: TTntScrollBox;
    UserResourceLimitGBox: TTntGroupBox;
    RemoveHostfromUserMI: TTntMenuItem;
    Label2: TTntLabel;
    Label4: TTntLabel;
    AssignTblColPrivBtn: TTntBitBtn;
    RemoveTblColPrivBtn: TTntBitBtn;
    TablePrivAvailListView: TTntListView;
    TablePrivAssignedListView: TTntListView;
    TblColSchemataFrame: TSchemataFrame;
    AssignAllGlobalPrivBtn: TTntBitBtn;
    RemoveAllGlobalPrivBtn: TTntBitBtn;
    AssignAllSchemaPrivBtn: TTntBitBtn;
    RemoveAllSchemaPrivBtn: TTntBitBtn;
    AssignAllTblColPrivBtn: TTntBitBtn;
    RemoveAllTblColPrivBtn: TTntBitBtn;
    ClearUserImg: TTntBitBtn;
    CatalogTreePopup: TTntPopupMenu;
    RefreshCatalogTreeMI: TTntMenuItem;
    N4: TTntMenuItem;
    AddSchemawithWidcardsMI: TTntMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure InitializeControls; override;

    procedure RefreshUserTree(searchStr: WideString = ''; RestoreSelection: Boolean = True);

    procedure UserPageControlChange(Sender: TObject);
    procedure UserPnlResize(Sender: TObject);

    procedure AssignGlobalPrivBtnClick(Sender: TObject);
    procedure MovePriv(SourceListView: TTntListView;
      DestListView: TTntListView;
      priv_object_name: WideString; AssignPrivilege: Boolean);
    procedure RemoveGlobalPrivBtnClick(Sender: TObject);
    procedure AdvancedSchemaEditSearchEdChange(Sender: TObject);

    procedure NewUserBtnClick(Sender: TObject);
    procedure NewUser(Clone: TMYX_USER = nil);
    procedure RefreshSchemaPrivileges(Schema: TMYX_SCHEMA);
    procedure AssignSchemaPrivBtnClick(Sender: TObject);
    procedure RemoveSchemaPrivBtnClick(Sender: TObject);
    procedure SchemataFrameSchemaTreeViewExpanding(Sender: TObject;
      Node: TTntTreeNode; var AllowExpansion: Boolean);
    procedure UserNameEdChange(Sender: TObject);
    procedure ApplyChangesBtnClick(Sender: TObject);
    procedure DiscardChangesBtnClick(Sender: TObject);
    procedure RefreshUserListMIClick(Sender: TObject);
    procedure UserTreeViewChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure LoadImgBtnClick(Sender: TObject);
    procedure DeleteUserMIClick(Sender: TObject);

    procedure CurrentUserChanged;

    procedure FetchAndDisplayUser(Node: TTntTreeNode; NewCurrentHost: WideString = '');

    procedure UserTreeViewChange(Sender: TObject; Node: TTreeNode);

    procedure FetchUserData(Sender: TObject);
    procedure UserDataFetched(Sender: TObject);

    procedure ApplyChanges;

    function DiscardChanges(AskToSaveChanges: Boolean; RefreshTheDisplayedUser: Boolean = True): integer;

    procedure RefreshUserData(user_name: WideString; userdata: TMYX_USER);

    procedure ClearUsers;

    procedure ClearUserControls;

    procedure DeleteUser(UserName: WideString);

    procedure DisableEnableUserPageControl(Enable: Boolean);

    procedure OnResourceEditChange(Sender: TObject);
    procedure AddHosttotheUserMIClick(Sender: TObject);
    procedure UserSubTreePopupMenuPopup(Sender: TObject);
    procedure RemoveHostfromUserMIClick(Sender: TObject);
    procedure AdvancedEditSearchEdChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure GetUserNameList(Sender: TObject);
    procedure RefreshUserNameList(Sender: TObject);

    procedure GetSchemaTables(Sender: TObject);
    procedure SchemaTablesFetched(Sender: TObject);
    procedure RefreshTableNames(schema: TMYX_SCHEMA);
    procedure TblColSchemataFrameSchemaTreeViewExpanding(Sender: TObject;
      Node: TTntTreeNode; var AllowExpansion: Boolean);

    procedure RefreshTablePrivileges(Schema: TMYX_SCHEMA;
      SchemaTable: TMYX_SCHEMA_TABLE;
      SchemaTableColumn: TMYX_SCHEMA_TABLE_COLUMN);
    procedure RefreshProcPrivileges(Schema: TMYX_SCHEMA;
      SchemaProc: TMYX_SCHEMA_STORED_PROCEDURE);
    procedure AssignTblColPrivBtnClick(Sender: TObject);
    procedure RemoveTblColPrivBtnClick(Sender: TObject);

    procedure ClearGlobalPrivListViews;
    procedure ClearSchemaPrivListViews;
    procedure ClearTableColumnPrivListViews;

    procedure ApplyOptionSettings;
    procedure OptionsChanged(var Message: TMessage); message WM_OptionsChanged;
    procedure CloneUserMIClick(Sender: TObject);
    procedure AssignAllGlobalPrivBtnClick(Sender: TObject);
    procedure RemoveAllGlobalPrivBtnClick(Sender: TObject);
    procedure AssignAllSchemaPrivBtnClick(Sender: TObject);
    procedure RemoveAllSchemaPrivBtnClick(Sender: TObject);
    procedure AssignAllTblColPrivBtnClick(Sender: TObject);
    procedure RemoveAllTblColPrivBtnClick(Sender: TObject);

    procedure Disconnected(var Message: TMessage); message WM_Disconnected;
    procedure Reconnected(var Message: TMessage); message WM_Reconnected;
    procedure SchemaListChanged(var Message: TMessage); message WM_SchemaListChanged;
    procedure ClearUserImgClick(Sender: TObject);
    procedure SchemaPrivSchemataFrameSchemaTreeViewDblClick(
      Sender: TObject);
    procedure TblColSchemataFrameSchemaTreeViewDblClick(Sender: TObject);
    procedure SchemaPrivSchemataFrameCatalogVSTChange(
      Sender: TBaseVirtualTree; Node: PVirtualNode);
    procedure TblColSchemataFrameCatalogVSTChange(Sender: TBaseVirtualTree;
      Node: PVirtualNode);
    procedure AddSchemawithWidcardsMIClick(Sender: TObject);
    procedure RefreshCatalogTreeMIClick(Sender: TObject);

    function GetCurrentUserSchema: TMYX_SCHEMA;
    function GetCurrentUserTblColSchema: TMYX_SCHEMA;
    function GetCurrentUserTable: TMYX_SCHEMA_TABLE;
    function GetCurrentUserProc: TMYX_SCHEMA_STORED_PROCEDURE;
    function GetCurrentUserColumn: TMYX_SCHEMA_TABLE_COLUMN;
    procedure UserTreeViewDeletion(Sender: TObject; Node: TTreeNode);
    procedure MenuDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; State: TOwnerDrawState);
    procedure MenuMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
  private
    { Private declarations }
    CurrentUser: TMYX_USER;
    CurrentUserHost: WideString;
    CurrentUserNewHost: WideString; //used for updating the userdata

    ClearingUsers,
    InitUserControls,
    CurrentUserIsChanged: Boolean;

    UserIconPNGImage: TPNGObject;

    HeaderPNGImg: TPNGObject;

    CreatingNewUser: Boolean;
  public
    UserNameList: TMYX_USER_NAMES;
  protected
    {procedure UserNamesListChanged(var Message: TMessage); message UserNamesListChangedMsg;
    procedure FillSchemaTree(var Message: TMessage); message CatalogSchemaListChangedMsg;}
  end;

  PPrivilege = ^TPrivilege;
  TPrivilege = record
    id: WideString;
  end;

var
  AdminUsersForm: TAdminUsersForm;

implementation

{$R *.dfm}

uses
  Main, PNGTools;

procedure TAdminUsersForm.FormCreate(Sender: TObject);
begin
  InitForm(self);

  SchemaPrivSchemataFrame.MySQLConnection := MySQLConn;
  SchemaPrivSchemataFrame.ShowSchemaAssets:=False;

  TblColSchemataFrame.MySQLConnection := MySQLConn;
  TblColSchemataFrame.ShowAssetsOnSchemaExpansion:=True;
  TblColSchemataFrame.PopupMenuEditEntries:=False;

  DockedPanel:=UserPnl;
  SubTreePanel:=SubTreePnl;

  UserPageControl.ActivePageIndex:=0;

  GlobalPrivSheet.TabVisible:=False;
  TablePrivSheet.TabVisible:=False;
  ResourceSheet.TabVisible:=False;

  UserPnlResize(self);

  UserNameList:=nil;
  UserIconPNGImage:=nil;

  CurrentUser:=nil;
  CurrentUserHost:='';

  CreatingNewUser:=False;
  ClearingUsers:=False;
  InitUserControls:=False;

  UserTreeView.Items.Clear;

  ClearUserControls;
  DisableEnableUserPageControl(False);
  NewUserBtn.Enabled:=MySQLConn.Connected;

  CurrentUserIsChanged:=False;

  HeaderPNGImg:=LoadPNGImageFromResource('user_admin', HeaderImg);
  Header2Img.Picture.Assign(HeaderPNGImg);
  Header3Img.Picture.Assign(HeaderPNGImg);
  Header4Img.Picture.Assign(HeaderPNGImg);
  Header5Img.Picture.Assign(HeaderPNGImg);

  ApplyOptionSettings;
end;

procedure TAdminUsersForm.FormDestroy(Sender: TObject);
begin
  ClearUsers;

  if(UserNameList<>nil)then
    UserNameList.Free;

  HeaderPNGImg.Free;
end;

procedure TAdminUsersForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //
end;

procedure TAdminUsersForm.InitializeControls;
begin
  RefreshUserTree('', False);
end;

procedure TAdminUsersForm.GetUserNameList(Sender: TObject);
var usernames: PMYX_USER_NAMES;
begin
  usernames:=myx_get_user_names(TFetchDataThread(Sender).Connection.MySQL);
  if(usernames=nil)then
    raise EMyxSQLError.Create('Could not fetch Usernames.',
      myx_mysql_errno(TFetchDataThread(Sender).Connection.MySQL),
      myx_mysql_error(TFetchDataThread(Sender).Connection.MySQL));


  UserNameList:=TMYX_USER_NAMES.create(usernames);
  myx_free_user_names(usernames);
end;

procedure TAdminUsersForm.RefreshUserNameList(Sender: TObject);
begin
  RefreshUserTree(AdvancedEdit.SearchEd.Text, (TFetchDataThread(Sender).Target<>nil));

  InitControls:=False;
end;

procedure TAdminUsersForm.RefreshUserTree(searchStr: WideString; RestoreSelection: Boolean);
var i: integer;
  username,
  LastUserName,
  LastHostName: WideString;
  Node: TTntTreeNode;
begin
  if(Not(MySQLConn.Connected))then
    Exit;

  if(UsernameList=nil)then
  begin
    if(RestoreSelection)then
      Node:=UserTreeView.Selected
    else
      Node:=nil;

    MySQLConn.FetchData(KindOfData_UserNames,
      GetUserNameList, RefreshUserNameList,
      Node, 'Fetching Usernames ...');
  end
  else
  begin
    //Store current values to restore selected node after refresh
    if(CurrentUser<>nil)then
    begin
      LastUserName:=CurrentUser.user_name;
      LastHostName:=CurrentUserHost;
    end;

    ClearUsers;
    Node:=nil;

    for i:=0 to UserNameList.user_names.Count-1 do
    begin
      username:=UserNameList.user_names[i];

      if(searchStr<>'')then

        if(myx_match_pattern(username, searchStr, 0, 1)=0)then
          continue;

        {if(Copy(UpperCase(username), 1, Length(searchStr))<>
          UpperCase(searchStr))then
          continue;}

      if(LastUserName=username)then
        Node:=AddTreeViewChildNode(UserTreeView, nil,
          username, 14)
      else
        AddTreeViewChildNode(UserTreeView, nil,
          username, 14)

    end;

    //restore previous selected node after refresh
    if(Node<>nil)and(RestoreSelection)then
    begin
      UserTreeView.Selected:=Node;
      for i:=0 to Node.Count-1 do
        if(LastHostName=Node.Item[i].Text)then
        begin
          UserTreeView.Selected:=Node.Item[i];
          break;
        end;
    end
    else
      DisableEnableUserPageControl(False);

    UserTreeView.Invalidate;
  end;
end;

procedure TAdminUsersForm.UserPageControlChange(Sender: TObject);
begin
  UserPnlResize(self);

  //Fetch Catalogs when Sheet becomes visible
  if(UserPageControl.ActivePage=SchemataPrivSheet)and
    ((SchemaPrivSchemataFrame.CatalogList=nil)or
    (SchemaPrivSchemataFrame.CatalogVST.RootNodeCount=0))then
    SchemaPrivSchemataFrame.FillSchemaTree;

  //Fetch Catalogs when Sheet becomes visible
  if(UserPageControl.ActivePage=TablePrivSheet)and
    ((TblColSchemataFrame.CatalogList=nil)or
    (TblColSchemataFrame.CatalogVST.RootNodeCount=0))then
    TblColSchemataFrame.FillSchemaTree;
end;

procedure TAdminUsersForm.UserPnlResize(Sender: TObject);
var InitSheetWidth, InitSheetHeight: integer;
begin
  InitSheetWidth:=563;
  InitSheetHeight:=439;

  //Adjust Page Control
  UserPageControl.Width:=UserPnl.Width-20;
  UserPageControl.Height:=UserPnl.Height-55;

  //Adjust User Information page
  UserInfoBevel.Width:=UserInfoSheet.Width-(InitSheetWidth-535);

  //Adjust Global Priv Page
  GlobalBevel.Width:=GlobalPrivSheet.Width-(InitSheetWidth-535);

  GlobalAssignedPrivListView.Height:=GlobalPrivSheet.Height-(InitSheetHeight-359);

  GlobalPrivListView.Width:=GlobalPrivSheet.Width-(InitSheetWidth-327);
  GlobalPrivListView.Height:=GlobalPrivSheet.Height-(InitSheetHeight-359);

  //Adjust Schema Level Sheet
  DBBevel.Width:=SchemataPrivSheet.Width-(InitSheetWidth-535);

  SchemaPrivSchemataFrame.Height:=SchemataPrivSheet.Height-(InitSheetHeight-376);

  SchemaPrivAssignedListView.Height:=SchemataPrivSheet.Height-(InitSheetHeight-359);

  SchemaPrivAvailListView.Width:=SchemataPrivSheet.Width-(InitSheetWidth-187);
  SchemaPrivAvailListView.Height:=SchemataPrivSheet.Height-(InitSheetHeight-359);

  //Adjust Table/Column Level Sheet
  TableBevel.Width:=TablePrivSheet.Width-(InitSheetWidth-535);

  TblColSchemataFrame.Height:=TablePrivSheet.Height-(InitSheetHeight-376);

  TablePrivAssignedListView.Height:=TablePrivSheet.Height-(InitSheetHeight-359);

  TablePrivAvailListView.Width:=TablePrivSheet.Width-(InitSheetWidth-143);
  TablePrivAvailListView.Height:=TablePrivSheet.Height-(InitSheetHeight-359);

  //Adjust Resource Sheet
  ResourceBevel.Width:=SchemataPrivSheet.Width-(InitSheetWidth-535);
end;

procedure TAdminUsersForm.ApplyChanges;
var previous_user_name: WideString;
  i: integer;
  NewUser: Boolean;
begin
  if(CurrentUser<>nil)and(CurrentUserIsChanged)then
  begin
    if(Length(UserNameEd.Text)>16)then
    begin
      UserPageControl.ActivePageIndex:=0;
      ShowModalDialog('Username too long',
        'The user name must not be longer that 16 characters.',
        myx_mtConfirmation, 'OK');
      Abort;
    end;

    if(PasswordEd.Text<>PasswordConfirmationEd.Text)then
    begin
      UserPageControl.ActivePageIndex:=0;
      PasswordConfirmationEd.Text:='';
      PasswordConfirmationEd.SetFocus;

      ShowModalDialog('Password not confirmed',
        'The password was not confirmed correctly. Please enter it again.',
        myx_mtConfirmation, 'OK');
      Abort;
    end;

    if CurrentUser.user_name = 'New User' then begin  // if a new user
      // check if a user with such name already exists
      for i:=0 to UserTreeView.Items.Count-1 do
      begin
        if UserTreeView.Items[i].Text=UserNameEd.Text then
        begin
          ShowModalDialog('Duplicate user name',
            'User with such name already exists. Please enter another name.',
            myx_mtConfirmation, 'OK');
          Exit;
        end;
      end;
    end;

    NewUser:=False;
    previous_user_name:=CurrentUser.user_name;
    //Check if a new user is created
    if(previous_user_name='New User')then
    begin
      //Replace 'New User' caption in UserTreeView with real username
      for i:=0 to UserTreeView.Items.Count-1 do
        if(UserTreeView.Items[i].Level=0)and
          (UserTreeView.Items[i].Data=CurrentUser)then
        begin
          UserTreeView.Items[i].Text:=UserNameEd.Text;
          break;
        end;

      UserNameList.user_names.Delete(
        UserNameList.user_names.IndexOf(previous_user_name));
      UserNameList.user_names.Add(UserNameEd.Text);

      previous_user_name:='';
      NewUser:=True;
    end
    else
      //Apply changes to username list
      UserNameList.user_names[
        UserNameList.user_names.IndexOf(CurrentUser.user_name)]:=
        UserNameEd.Text;

    CurrentUser.user_name:=UserNameEd.Text;
    CurrentUser.password:=PasswordEd.Text;
    CurrentUser.full_name:=FullNameEd.Text;
    CurrentUser.description:=DescriptionEd.Text;
    CurrentUser.email:=EmailEd.Text;
    CurrentUser.contact_information:=ContactInfoMemo.Text;


    //Store Changes in DB
    if(myx_set_user(MySQLConn.MySQL, CurrentUser.get_record_pointer,
      previous_user_name, Ord(NewUser))<>0)then
    begin
      if(myx_mysql_errno(MySQLConn.MySQL)=0)then
        raise EMyxError.Create('Error while storing the user information.'+
          'The user might have been deleted.'#13#10+
          'Please refresh the user list.')
      else
        raise EMyxSQLError.Create('Error while storing the user information.',
          myx_mysql_errno(MySQLConn.MySQL),
          myx_mysql_error(MySQLConn.MySQL));
    end;

    CurrentUserIsChanged:=False;

    //Refresh Data
    if(previous_user_name='')then
      //New user
      RefreshUserData(CurrentUser.user_name, CurrentUser)
    else
      //Old user
      RefreshUserData(previous_user_name, CurrentUser);
  end;

  CreatingNewUser:=False;
end;

function TAdminUsersForm.DiscardChanges(AskToSaveChanges: Boolean;
  RefreshTheDisplayedUser: Boolean): integer;
var res: integer;
begin
  if(CurrentUser<>nil)and(CurrentUserIsChanged)then
  begin
    if(AskToSaveChanges)then
    begin
      res:=ShowModalDialog('Store Changes?',
        'The user '+CurrentUser.user_name+' has been modified. '+
        'Do you want to store the changes?', myx_mtConfirmation,
        'Yes'#13#10'No'#13#10'Abort');

      if(res=1)then
      begin
        ApplyChanges;
        // if changes are successfully applied then
        // CurrentUserIsChanged flag should be false
        // otherwise there was a problem and we don't switch
        if CurrentUserIsChanged then
        begin
          Result:=-1;
        end
        else
        begin
          Result:=1;
        end;
        Exit;
      end
      else if(res=3)then
      begin
        Result:=-1;
        Exit;
      end;
    end;

    //If the creation of a new User is canceled
    if(CurrentUser.user_name='New User')then
    begin
      UserNameList.user_names.Delete(
        UserNameList.user_names.IndexOf(CurrentUser.user_name));

      RefreshUserTree(AdvancedEdit.SearchEd.Text);

      CurrentUser:=nil;
      Result:=-1;

      CurrentUserIsChanged:=False;
      CreatingNewUser:=False;
      ApplyChangesBtn.Enabled:=False;
      DiscardChangesBtn.Enabled:=False;
      Exit;
    end
    else
    //If an existing user has been modified
    begin
      if(UserTreeView.Selected<>nil)then
        if(UserTreeView.Selected.Data=CurrentUser)then
          if(Not(ApplicationDM.ApplicationIsTerminating))and
            (RefreshTheDisplayedUser)then
          begin
            CurrentUserIsChanged:=False;
            RefreshUserData(CurrentUser.user_name, CurrentUser);

            Result:=0;
            Exit;
          end;

      ClearUserControls;
    end;

    CurrentUserIsChanged:=False;
    CreatingNewUser:=False;

    CurrentUserIsChanged:=False;
    ApplyChangesBtn.Enabled:=False;
    DiscardChangesBtn.Enabled:=False;
  end;

  Result:=0;
end;

procedure TAdminUsersForm.RefreshUserData(user_name: WideString; userdata: TMYX_USER);
var i: integer;
  Node: TTntTreeNode;
  UserToRefreshIsSelected: Boolean;
  Last_hostname: WideString;
begin
  if(UserTreeView.Selected<>nil)then
    UserToRefreshIsSelected:=(UserTreeView.Selected.Data=userdata)
  else
    UserToRefreshIsSelected:=False;

  try
    //Find node of current user and remove data and childnodes
    for i:=0 to UserTreeView.Items.Count-1 do
      if(UserTreeView.Items[i].Level=0)and
        (UserTreeView.Items[i].Text=user_name)then
        //(UserTreeView.Items[i].Data=userdata)then
      begin
        Node:=UserTreeView.Items[i];

        Last_hostname:='';
        if(UserToRefreshIsSelected)then
          if(UserTreeView.Selected.Level=0)then
          begin
            if(TMYX_USER(UserTreeView.Selected.Data).hosts.IndexOf('%')<>-1)then
              Last_hostname:='%'
            else
              if(TMYX_USER(UserTreeView.Selected.Data).hosts.Count>0)then
                Last_hostname:=TMYX_USER(UserTreeView.Selected.Data).hosts[0];
          end
          else
            Last_hostname:=UserTreeView.Selected.Text;

        Node.Data:=nil;
        UserTreeView.Items[i].DeleteChildren;

        Node.Text:=userdata.user_name;

        FetchAndDisplayUser(Node, Last_hostname);

        break;
      end;
  finally
    //Free old user data
    userdata.Free;
  end;
end;


procedure TAdminUsersForm.ClearUserControls;
begin
  UserInfoNameLbl.Caption:='No user selected';
  GlobalPrivNameLbl.Caption:=UserInfoNameLbl.Caption;
  SchemaPrivNameLbl.Caption:=UserInfoNameLbl.Caption;
  TableColumnPrivNameLbl.Caption:=UserInfoNameLbl.Caption;
  ResourceNameLbl.Caption:=UserInfoNameLbl.Caption;

  UserNameEd.Text:='';
  PasswordEd.Text:='';
  PasswordConfirmationEd.Text:='';
  FullNameEd.Text:='';
  DescriptionEd.Text:='';
  EmailEd.Text:='';
  ContactInfoMemo.Text:='';

  CurrentUser:=nil;
  CurrentUserHost:='';
  CurrentUserNewHost:='';

  ClearGlobalPrivListViews;
  ClearSchemaPrivListViews;
  ClearTableColumnPrivListViews;
end;

procedure TAdminUsersForm.DisableEnableUserPageControl(Enable: Boolean);
var i: integer;
begin
  for i:=0 to UserPageControl.PageCount-1 do
    DisableEnableControls(UserPageControl.Pages[i], Enable);

  NewUserBtn.Enabled:=True;
end;

procedure TAdminUsersForm.UserTreeViewChanging(Sender: TObject;
  Node: TTreeNode; var AllowChange: Boolean);
begin
  if(ClearingUsers)then
    Exit;

  //If a different user is selected, ask if changes should be applied
  //before switching to a new user
  if(Node<>nil)then
    if(Node.Data<>CurrentUser)and(CurrentUserIsChanged)then
      AllowChange:=Not(DiscardChanges(True, False)=-1);
end;

procedure TAdminUsersForm.UserTreeViewChange(Sender: TObject;
  Node: TTreeNode);
begin
  if(not(InitControls))then
    FetchAndDisplayUser(TTntTreeNode(Node));
end;

procedure TAdminUsersForm.FetchUserData(Sender: TObject);

var
  Puser: PMYX_USER;

begin
  PUser:=myx_get_user_with_privileges(MySQLConn.MySQL,
    TTntTreeNode(TFetchDataThread(Sender).Target).Text);
  if(PUser=nil)then
    if(myx_mysql_errno(MySQLConn.MySQL)=0)then
      raise EMyxError.Create('Error while fetching user information.'+
        'The user might have been deleted.')
    else
      raise EMyxSQLError.Create('Error while fetching user information.',
        myx_mysql_errno(MySQLConn.MySQL),
        myx_mysql_error(MySQLConn.MySQL));
  try
    TTntTreeNode(TFetchDataThread(Sender).Target).Data := TMYX_USER.create(Puser);
  finally
    myx_free_user(PUser);
  end;
end;

procedure TAdminUsersForm.UserDataFetched(Sender: TObject);

var
  Node: TTntTreeNode;
  i: integer;

begin
  try
    Node:=TTntTreeNode(TFetchDataThread(Sender).Target);

    if(TMYX_USER(Node.Data).hosts.Count>1)then
      for i:=0 to TMYX_USER(Node.Data).hosts.Count-1 do
        if TMYX_USER(Node.Data).hosts[i] <> '%' then
          AddTreeViewChildNode(UserTreeView, Node, TMYX_USER(Node.Data).hosts[i], 22, TMYX_USER(Node.Data));

    if(Node.HasChildren)then
      Node.Expand(False);

    FetchAndDisplayUser(Node, CurrentUserNewHost);
  except
    DisableEnableUserPageControl(False);
    raise;
  end;
end;

procedure TAdminUsersForm.FetchAndDisplayUser(Node: TTntTreeNode;
                                              NewCurrentHost: WideString = '');
var
  i, j: integer;
  ypos: integer;
  s: WideString;
  Item: TListItem;
  PrivNode: PPrivilege;
  MemStream: TMemoryStream;
  aLabel: TTntLabel;
  aEdit: TTntEdit;
begin
  if(ClearingUsers)then
    Exit;

  InitUserControls:=True;
  try
    //If no user is selected, clear controls
    if(Node=nil)then
    begin
      CurrentUser:=nil;
      //CurrentUserSchema:=nil;
      CurrentUserHost:='';

      ClearUserControls;
      DisableEnableUserPageControl(False);

      Exit;
    end;

    //If there is no user data assigned to the node yet,
    //fetch the data and create childnodes for the user's hosts
    if(Node.Data=nil)then
    begin
      myx_compact_privs(MySQLConn.MySQL);
      SchemaPrivSchemataFrame.SchemasToAdd.Clear;

      CurrentUserNewHost:=NewCurrentHost;
      MySQLConn.FetchData(KindOfData_UserData,
        FetchUserData, UserDataFetched,
        Node, 'Fetching User Data ...');

      Exit;
    end;

    if(Node.Data<>nil)then
    begin
      DisableEnableUserPageControl(True);

      if(CurrentUser<>Node.Data)then
      begin
        {//Ask if changes should be saved
        DiscardChanges(True);}

        //Then get new user data
        CurrentUser:=TMYX_USER(Node.Data);

        UserNameEd.Text:=CurrentUser.user_name;
        PasswordEd.Text:='________';
        PasswordConfirmationEd.Text:='________';
        FullNameEd.Text:=CurrentUser.full_name;
        DescriptionEd.Text:=CurrentUser.description;
        EmailEd.Text:=CurrentUser.email;
        ContactInfoMemo.Text:=CurrentUser.contact_information;

        //Get Icon
        if(CurrentUser.icon_length=0)then
        begin
          if(UserIconPNGImage<>nil)then
            UserIconPNGImage.Free;

          UserIconPNGImage:=LoadPNGImageFromResource('user_icon', UserIcon);
        end
        else
        begin
          MemStream:=TMemoryStream.Create;
          try
            MemStream.WriteBuffer(CurrentUser.icon[1], CurrentUser.icon_length);

            MemStream.Position:=0;
            if(UserIconPNGImage=nil)then
              UserIconPNGImage:=TPNGObject.Create;

            try
              UserIconPNGImage.LoadFromStream(MemStream);
              UserIcon.Picture.Graphic:=UserIconPNGImage;
            except
              ShowModalDialog('Icon image corrupted.',
                'The User icon image file is corrupted.',
                myx_mtError, 'Ok');
            end;
            UserIcon.Invalidate;
          finally
            MemStream.Free;
          end;
        end;


        CurrentUserIsChanged:=False;
        ApplyChangesBtn.Enabled:=False;
        DiscardChangesBtn.Enabled:=False;
      end;

      //If a new Host has to be selected
      if(NewCurrentHost<>'')then
      begin
        UserTreeView.OnChange:=nil;
        try
          CurrentUserHost:='';

          if(NewCurrentHost='%')and(CurrentUser.hosts.IndexOf('%')<>-1)then
          begin
            UserTreeView.Selected:=Node;
            CurrentUserHost:=NewCurrentHost;
          end
          else
          begin
            //Try to find requested new host in the host nodes of the user
            for i:=0 to Node.Count-1 do
              if(Node.Item[i].Text=NewCurrentHost)then
              begin
                UserTreeView.Selected:=Node.Item[i];
                CurrentUserHost:=NewCurrentHost;
                break;
              end;

            //If the requested new host is not found, make the user's root node
            //the current node
            if(CurrentUserHost<>NewCurrentHost)then
            begin
              UserTreeView.Selected:=Node;
              CurrentUserHost:=NewCurrentHost;
            end;
          end;

        finally
          UserTreeView.OnChange:=UserTreeViewChange;
        end;
      end
      else
      begin
        //Get CurrentUserHost
        if(Node.Level>0)then
          CurrentUserHost:=Node.Text
        else
        begin
          if(CurrentUser.hosts.IndexOf('%')<>-1)then
            CurrentUserHost:='%'
          else
            if(CurrentUser.hosts.Count>0)then
              CurrentUserHost:=CurrentUser.hosts[0]
            else
              CurrentUserHost:='';
        end;
      end;

      //Set Page Header Texts
      if(CurrentUserHost='%')then
        s:=CurrentUser.user_name
      else
        s:=CurrentUser.user_name+'@'+CurrentUserHost;
      if(CurrentUser.full_name<>'')then
        s:=s+', ('+CurrentUser.full_name+')';

      if(CurrentUser.user_name='')then
        s:='anonymous'+s;

      UserInfoNameLbl.Caption:=s;
      GlobalPrivNameLbl.Caption:=s;
      SchemaPrivNameLbl.Caption:=s;
      TableColumnPrivNameLbl.Caption:=s;
      ResourceNameLbl.Caption:=s;

      //Start at y26
      ypos:=26;

      ClearGlobalPrivListViews;
      ClearSchemaPrivListViews;
      ClearTableColumnPrivListViews;

      //Get User Privileges
      for i:=0 to CurrentUser.user_object_privileges.Count-1 do
      begin
        //if object_name is '', these are the global privileges
        if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
          (CurrentUser.user_object_privileges[i].object_name='')then
        begin
          for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
          begin
            //Separate _priv from max_
            if(Copy(CurrentUser.user_object_privileges[i].user_privileges.Names[j],
              Length(CurrentUser.user_object_privileges[i].user_privileges.Names[j])-4, 5)=
                '_priv')then
            begin
              PrivNode:=New(PPrivilege);
              PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

              if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                Item:=AddListViewItem(GlobalAssignedPrivListView, nil,
                  Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                  15, PrivNode)
              else
                Item:=AddListViewItem(GlobalPrivListView, nil,
                  Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                  15, PrivNode);

              Item.SubItems.Add('Grants the '+
                Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                ' privilege to the user');
            end
            else
            begin
              //Update ResourceSheet
              if(Not(ResourceSheet.TabVisible))then
                ResourceSheet.TabVisible:=True;

              aEdit:=TTntEdit(FindComponent(CurrentUser.user_object_privileges[i].user_privileges.Names[j]+'Ed'));
              if aEdit = nil then
              begin
                aLabel:=TTntLabel.Create(self);
                aLabel.Parent:=UserResourceLimitGBox;
                aLabel.Name:=CurrentUser.user_object_privileges[i].user_privileges.Names[j]+'TitleLbl';
                aLabel.Left:=14;
                aLabel.Top:=ypos;
                aLabel.Caption:=CurrentUser.user_object_privileges[i].user_privileges.Names[j]+':';

                aEdit:=TTntEdit.Create(self);
                aEdit.Parent:=UserResourceLimitGBox;
                aEdit.Name:=CurrentUser.user_object_privileges[i].user_privileges.Names[j]+'Ed';
                aEdit.Left:=160;
                aEdit.Top:=ypos-4;
                aEdit.Width:=61;
                aEdit.Text:=CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j];
                aEdit.OnChange:=OnResourceEditChange;

                aLabel:=TTntLabel.Create(self);
                aLabel.Parent:=UserResourceLimitGBox;
                aLabel.Name:=CurrentUser.user_object_privileges[i].user_privileges.Names[j]+'InfoLbl';
                aLabel.Left:=236;
                aLabel.Top:=ypos;
                aLabel.Width:=285;
                aLabel.AutoSize:=False;
                aLabel.WordWrap:=True;

                if(CurrentUser.user_object_privileges[i].user_privileges.Names[j]='max_connections')then
                    s:='Number of connections to the server the user can open within a hour.'
                else if(CurrentUser.user_object_privileges[i].user_privileges.Names[j]='max_questions')then
                    s:='Number of queries the user can execute within one hour.'
                else if(CurrentUser.user_object_privileges[i].user_privileges.Names[j]='max_updates')then
                    s:='Number of update the user can execute within one hour.';

                aLabel.Height:=13*(Canvas.TextWidth(s) div aLabel.Width+1);
                aLabel.Caption:=s;
              end
              else
              begin
                aEdit.Text:= CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j];
                aLabel := FindComponent(CurrentUser.user_object_privileges[i].user_privileges.Names[j] + 'InfoLbl') as TTntLabel;
              end;

              Inc(ypos, 30 + aLabel.Height - 13);
            end;
          end;
        end
        else
        begin
          //Check if there are any schemas with wildcards
          if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
            (Pos('.', CurrentUser.user_object_privileges[i].object_name)=0)then
          begin
            //Add the schema to the catalog if it is not found
            //For version 4 databases, add schemas to catalog def
            if(CompareText(
              CurrentUser.user_object_privileges[i].object_name,
              'mysql')<>0)then
              if(SchemaPrivSchemataFrame.SchemasToAdd.IndexOf('def/'+
                CurrentUser.user_object_privileges[i].object_name)=-1)then
              begin
                SchemaPrivSchemataFrame.SchemasToAdd.Add(
                  'def/'+CurrentUser.user_object_privileges[i].object_name);

                SchemaPrivSchemataFrame.FillSchemaTree(
                  SchemaPrivSchemataFrame.AdvancedEdit.SearchEd.Text);
              end;
          end;

          //Set schema privileges
          if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
            (GetCurrentUserSchema<>nil)then
          begin
            if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
              (CurrentUser.user_object_privileges[i].object_name=GetCurrentUserSchema.schema_name)then
            begin
              for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
              begin
                PrivNode:=New(PPrivilege);
                PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

                if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                  Item:=AddListViewItem(SchemaPrivAssignedListView, nil,
                    Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                    15, PrivNode)
                else
                  Item:=AddListViewItem(SchemaPrivAvailListView, nil,
                    Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                    15, PrivNode);

                Item.SubItems.Add('Grants the '+
                  Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                  ' privilege to the user');
              end;
            end;
          end;

          //Set table/column privileges
          if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
            (GetCurrentUserTblColSchema<>nil)then
          begin
            if(GetCurrentUserTable=nil)and(GetCurrentUserColumn=nil)then
            begin
              if(GetCurrentUserProc<>nil)then
              begin
              if(CurrentUser.user_object_privileges[i].object_name=
                  GetCurrentUserTblColSchema.schema_name+'.'+
                  GetCurrentUserProc.name)then
              begin
                for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
                begin
                  PrivNode:=New(PPrivilege);
                  PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

                  if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                    Item:=AddListViewItem(TablePrivAssignedListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode)
                  else
                    Item:=AddListViewItem(TablePrivAvailListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode);

                  Item.SubItems.Add('Grants the '+
                    Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                    ' privilege to the user');
                end;
              end;
              end
              else
              begin
                if(CurrentUser.user_object_privileges[i].object_name=
                    GetCurrentUserTblColSchema.schema_name)then
                begin
                  for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
                  begin
                    PrivNode:=New(PPrivilege);
                    PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

                    if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                      Item:=AddListViewItem(TablePrivAssignedListView, nil,
                        Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                        15, PrivNode)
                    else
                      Item:=AddListViewItem(TablePrivAvailListView, nil,
                        Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                        15, PrivNode);

                    Item.SubItems.Add('Grants the '+
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                      ' privilege to the user');
                  end;
                end;
              end
            end
            else if(GetCurrentUserTable<>nil)and(GetCurrentUserColumn=nil)then
            begin
              if(CurrentUser.user_object_privileges[i].object_name=
                  GetCurrentUserTblColSchema.schema_name+'.'+
                  GetCurrentUserTable.table_name)then
              begin
                for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
                begin
                  PrivNode:=New(PPrivilege);
                  PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

                  if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                    Item:=AddListViewItem(TablePrivAssignedListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode)
                  else
                    Item:=AddListViewItem(TablePrivAvailListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode);

                  Item.SubItems.Add('Grants the '+
                    Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                    ' privilege to the user');
                end;
              end;
            end
            //CurrentUserColumn not nil
            else if(GetCurrentUserTable<>nil)and(GetCurrentUserColumn<>nil)then
            begin
              if(CurrentUser.user_object_privileges[i].object_name=
                GetCurrentUserTblColSchema.schema_name+'.'+
                GetCurrentUserTable.table_name+'.'+
                GetCurrentUserColumn.column_name)then
              begin
                for j:=0 to CurrentUser.user_object_privileges[i].user_privileges.Count-1 do
                begin
                  PrivNode:=New(PPrivilege);
                  PrivNode.id:=CurrentUser.user_object_privileges[i].user_privileges.Names[j];

                  if(CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]='Y')then
                    Item:=AddListViewItem(TablePrivAssignedListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode)
                  else
                    Item:=AddListViewItem(TablePrivAvailListView, nil,
                      Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', '')),
                      15, PrivNode);

                  Item.SubItems.Add('Grants the '+
                    Uppercase(AnsiReplaceStr(CurrentUser.user_object_privileges[i].user_privileges.Names[j], '_priv', ''))+
                    ' privilege to the user');
                end;
              end;
            end;
          end;
        end;
      end;

      UserResourceLimitGBox.Height := ypos;
      
      // if you're going to uncomment the code below -
      // then check if SP privilige asignment GUI code will work
      {if(GetCurrentUserSchema<>nil)then
        RefreshSchemaPrivileges(GetCurrentUserSchema);

      if(GetCurrentUserTblColSchema<>nil)then
        RefreshTablePrivileges(GetCurrentUserTblColSchema,
          GetCurrentUserTable, GetCurrentUserColumn);
      }
    end
    else if(Not(ClearingUsers))then
    begin
      ClearUserControls;
    end;
  finally
    InitUserControls:=False;
  end;
end;

procedure TAdminUsersForm.OnResourceEditChange(Sender: TObject);
var i, j: integer;
begin
  if(CurrentUser<>nil)and(Not(InitUserControls))then
  begin
    //Get User Privileges
    for i:=0 to CurrentUser.user_object_privileges.Count-1 do
    begin
      //if object_name is '', these are the global privileges
      if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
        (CurrentUser.user_object_privileges[i].object_name='')then
      begin
        j:=CurrentUser.user_object_privileges[i].user_privileges.IndexOfName(
          Copy(TTntEdit(Sender).Name, 1, Length(TTntEdit(Sender).Name)-2));
        if(j>-1)then
          CurrentUser.user_object_privileges[i].user_privileges.ValueFromIndex[j]:=
            IntToStr(StrToIntDef(TTntEdit(Sender).Text, 0));

        CurrentUserChanged;
        break;
      end;
    end;
  end;
end;

procedure TAdminUsersForm.ClearUsers;
var i: integer;
begin
  if(UserTreeView=nil)then
    Exit;
    
  ClearingUsers:=True;
  try
    for i:=0 to UserTreeView.Items.Count-1 do
      if(UserTreeView.Items[i].Data<>nil)then
      begin
        if(CurrentUser=UserTreeView.Items[i].Data)then
          CurrentUser:=nil;

        if(UserTreeView.Items[i].Level=0)then
          TMYX_USER(UserTreeView.Items[i].Data).Free;

        UserTreeView.Items[i].Data:=nil;
      end;

    UserTreeView.Items.Clear;
    ClearUserControls;
  finally
    ClearingUsers:=False;
  end;
end;

{procedure TAdminUsersForm.UserNamesListChanged(var Message: TMessage);
begin
  RefreshUserTree;
end;}

procedure TAdminUsersForm.MovePriv(SourceListView: TTntListView;
  DestListView: TTntListView;
  priv_object_name: WideString; AssignPrivilege: Boolean);
var i, j: integer;
  Item: TListItem;
  UserPriv: TMYX_USER_OBJECT_PRIVILEGES;
  //PUserPriv: PMYX_USER_OBJECT_PRIVILEGES;
begin
  if(CurrentUser<>nil)and(SourceListView.SelCount>0)then
  begin
    //Find privileges by priv_object_name
    UserPriv:=nil;
    for i:=0 to CurrentUser.user_object_privileges.Count-1 do
    begin
      if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
        (CurrentUser.user_object_privileges[i].object_name=priv_object_name)then
      begin
        UserPriv:=CurrentUser.user_object_privileges[i];
        break;
      end;
    end;

    {if(UserPriv=nil)and(AssignPrivilege)then
    begin
      PUserPriv:=myx_get_privilege_struct(MySQLConn.PMySQL,
        priv_object_name);
      try
        UserPriv:=TMYX_USER_OBJECT_PRIVILEGES.create(PUserPriv);
        UserPriv.host:=CurrentUserHost;
        UserPriv.object_name:=priv_object_name;

        CurrentUser.user_object_privileges.Add(UserPriv);
      finally
        myx_free_user_priv(PUserPriv);
      end;
    end;}

    if(UserPriv<>nil)then
    begin
      i:=SourceListView.Items.IndexOf(SourceListView.Selected);
      while(i<SourceListView.Items.Count)do
      begin
        if(SourceListView.Items[i].Selected)and
          (SourceListView.Items[i].Data<>nil)then
        begin
          for j:=0 to UserPriv.user_privileges.Count-1 do
            if(UserPriv.user_privileges.Names[j]=PPrivilege(SourceListView.Items[i].Data).id)then
            begin
              if(AssignPrivilege)then
                UserPriv.user_privileges.ValueFromIndex[j]:='Y'
              else
                UserPriv.user_privileges.ValueFromIndex[j]:='N';

              Item:=AddListViewItem(DestListView, nil,
                SourceListView.Items[i].Caption,
                15, SourceListView.Items[i].Data);

              Item.SubItems.Assign(SourceListView.Items[i].SubItems);

              SourceListView.Items.Delete(i);

              break;
            end;
        end
        else
          inc(i);
      end;
    end;
  end;
end;

procedure TAdminUsersForm.AssignGlobalPrivBtnClick(Sender: TObject);
begin
  if(GlobalPrivListView.SelCount>0)then
  begin
    MovePriv(GlobalPrivListView, GlobalAssignedPrivListView,
      '', True);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.RemoveGlobalPrivBtnClick(Sender: TObject);
begin
  if(GlobalAssignedPrivListView.SelCount>0)then
  begin
    MovePriv(GlobalAssignedPrivListView, GlobalPrivListView,
      '', False);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.AdvancedSchemaEditSearchEdChange(Sender: TObject);
begin
  SchemaPrivSchemataFrame.AdvancedEditSearchEdChange(Sender);

  RefreshSchemaPrivileges(nil);
end;

procedure TAdminUsersForm.NewUserBtnClick(Sender: TObject);
begin
  NewUser;
end;

procedure TAdminUsersForm.NewUser(Clone: TMYX_USER);
var i: integer;
  UserPriv: TMYX_USER_OBJECT_PRIVILEGES;
  PUserPriv: PMYX_USER_OBJECT_PRIVILEGES;
  GotAnyHost: Boolean;
  TreeNode: TTntTreeNode;
  NewMyxUser: TMYX_USER;
begin
  if(UserNameList=nil)then
  begin
    ShowModalDialog(_('User List Not Fetched'),
      _('Before a new user account can be created the list of '+
        'current user accounts needs to be retreived. Please select '+
        'Refresh User List from the popup menu of the User Account list.'),
        myx_mtError, _('OK'));
    Exit;
  end;

  DiscardChanges(True);

  UserTreeView.Selected:=nil;

  //DisableEnableUserPageControl(True);

  CurrentUserHost:='';

  if(Clone=nil)then
  begin
    CurrentUser:=TMYX_USER.create('New User',
      '', '', '', '', '', 0, '');

    //Add % host
    CurrentUser.hosts.Add('%');

    //Add privileges for %
    PUserPriv:=myx_get_privilege_struct(MySQLConn.MySQL, '');
    UserPriv:=TMYX_USER_OBJECT_PRIVILEGES.create(PUserPriv);
    myx_free_user_priv(PUserPriv);
    UserPriv.host:='%';
    UserPriv.object_name:='';

    //Add privileges to user
    CurrentUser.user_object_privileges.Add(UserPriv);

    NewMyxUser:=CurrentUser;
  end
  else
  begin
    CurrentUser:=TMYX_USER.create(Clone.get_record_pointer);
    CurrentUser.user_name:='New User';
    CurrentUser.password:='';
    CurrentUser.full_name:='';
    CurrentUser.email:='';
    CurrentUser.contact_information:='';

    NewMyxUser:=CurrentUser;
  end;

  //Add username to username list
  UserNameList.user_names.Add(CurrentUser.user_name);

  //Rebuild username tree
  RefreshUserTree(AdvancedEdit.SearchEd.Text, False);

  CurrentUser:=NewMyxUser;

  //Attach userdata to user node and select it
  TreeNode:=nil;
  for i:=0 to UserTreeView.Items.Count-1 do
    if(UserTreeView.Items[i].Level=0)then
      if(UserTreeView.Items[i].Text=CurrentUser.user_name)then
      begin
        TreeNode:=UserTreeView.Items[i];
        break;
      end;

  InitControls:=True;
  try
    if(TreeNode<>nil)then
    begin
      //add the clone's hosts
      if(Clone<>nil)then
      begin
        GotAnyHost:=False;
        for i:=0 to CurrentUser.hosts.Count-1 do
          if(CurrentUser.hosts[i]='%')then
          begin
            GotAnyHost:=True;
            break;
          end;

        if(CurrentUser.hosts.Count>1)then
        begin
          for i:=0 to CurrentUser.hosts.Count-1 do
          begin
            if(GotAnyHost)and(CurrentUser.hosts[i]='%')then
              continue;

            if(Not(GotAnyHost))and(i=0)then
              continue;

            AddTreeViewChildNode(UserTreeView, TreeNode,
              CurrentUser.hosts[i], 22, CurrentUser);
          end;
        end;
      end;
    end;
  finally
    InitControls:=False;
  end;

  //Now select new node
  TreeNode.Data:=CurrentUser;
  TreeNode.Expand(False);
  CurrentUser:=nil;
  UserTreeView.Selected:=TreeNode;

  UserNameEd.Text:='';
  PasswordEd.Text:='';
  PasswordConfirmationEd.Text:='';

  UserPageControl.ActivePage:=UserInfoSheet;

  UserNameEd.SetFocus;

  NewUserBtn.Enabled:=False;

  CreatingNewUser:=True;

  CurrentUserChanged;
end;

procedure TAdminUsersForm.RefreshSchemaPrivileges(Schema: TMYX_SCHEMA);
var i: integer;
  UserPriv: TMYX_USER_OBJECT_PRIVILEGES;
  PUserPriv: PMYX_USER_OBJECT_PRIVILEGES;
  Item: TListItem;
  PrivNode: PPrivilege;
begin
  ClearSchemaPrivListViews;

  if(Schema=nil)then
    Exit;

  //Find schema privileges
  UserPriv:=nil;
  for i:=0 to CurrentUser.user_object_privileges.Count-1 do
  begin
    //if object_name is 'xxxx', these are the schema privileges
    if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
      (CurrentUser.user_object_privileges[i].object_name=Schema.schema_name)then
    begin
      UserPriv:=CurrentUser.user_object_privileges[i];
      break;
    end;
  end;

  if(UserPriv=nil)then
  begin
    PUserPriv:=myx_get_privilege_struct(MySQLConn.MySQL,
      Schema.schema_name);
    UserPriv:=TMYX_USER_OBJECT_PRIVILEGES.create(PUserPriv);
    myx_free_user_priv(PUserPriv);

    UserPriv.host:=CurrentUserHost;
    UserPriv.object_name:=Schema.schema_name;

    CurrentUser.user_object_privileges.Add(UserPriv);
  end;

  if(UserPriv<>nil)then
  begin
    for i:=0 to UserPriv.user_privileges.Count-1 do
    begin
      if(Copy(UserPriv.user_privileges.Names[i],
        Length(UserPriv.user_privileges.Names[i])-4, 5)=
          '_priv')then
      begin
        PrivNode:=New(PPrivilege);
        PrivNode.id:=UserPriv.user_privileges.Names[i];

        if(UserPriv.user_privileges.ValueFromIndex[i]='Y')then
          Item:=AddListViewItem(SchemaPrivAssignedListView, nil,
            Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
            15, PrivNode)
        else
          Item:=AddListViewItem(SchemaPrivAvailListView, nil,
            Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
            15, PrivNode);

        Item.SubItems.Add('Grants the '+
          Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', ''))+
          ' privilege to the user');
      end;
    end;
  end;
end;

procedure TAdminUsersForm.AssignSchemaPrivBtnClick(Sender: TObject);
begin
  if(GetCurrentUserSchema<>nil)then
  begin
    MovePriv(SchemaPrivAvailListView, SchemaPrivAssignedListView,
      GetCurrentUserSchema.schema_name, True);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.RemoveSchemaPrivBtnClick(Sender: TObject);
begin
  if(GetCurrentUserSchema<>nil)then
  begin
    MovePriv(SchemaPrivAssignedListView, SchemaPrivAvailListView,
      GetCurrentUserSchema.schema_name, False);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.SchemataFrameSchemaTreeViewExpanding(
  Sender: TObject; Node: TTntTreeNode; var AllowExpansion: Boolean);
begin
  if(Node.Data<>nil)then
    if(TObject(Node.Data) is TMYX_SCHEMA)then
      AllowExpansion:=False;
end;

procedure TAdminUsersForm.CurrentUserChanged;
begin
  if(Not(ClearingUsers))and(Not(InitUserControls))then
  begin
    CurrentUserIsChanged:=True;

    ApplyChangesBtn.Enabled:=True;
    DiscardChangesBtn.Enabled:=True;
  end;
end;

procedure TAdminUsersForm.UserNameEdChange(Sender: TObject);
begin
  CurrentUserChanged;
end;

procedure TAdminUsersForm.ApplyChangesBtnClick(Sender: TObject);
begin
  ApplyChanges;

  NewUserBtn.Enabled:=True;
  ApplyChangesBtn.Enabled:=False;
  DiscardChangesBtn.Enabled:=False;
end;

procedure TAdminUsersForm.DiscardChangesBtnClick(Sender: TObject);
begin
  DiscardChanges(False);

  {InstanceDM.UserNameList.Free;
  InstanceDM.UserNameList:=nil;

  RefreshUserTree(AdvancedEdit.SearchEd.Text);}

  NewUserBtn.Enabled:=True;
  ApplyChangesBtn.Enabled:=False;
  DiscardChangesBtn.Enabled:=False;
end;

procedure TAdminUsersForm.RefreshUserListMIClick(Sender: TObject);
begin
  ClearUsers;

  if(UserNameList<>nil)then
    UserNameList.Free;
  UserNameList:=nil;

  RefreshUserTree(AdvancedEdit.SearchEd.Text);
end;

procedure TAdminUsersForm.LoadImgBtnClick(Sender: TObject);
var OpenDlg: TTntOpenDialog;
  MemStream: TMemoryStream;
begin
  if(CurrentUser<>nil)then
  begin
    OpenDlg:=TTntOpenDialog.Create(nil);
    try
      OpenDlg.InitialDir:='';
      OpenDlg.Filter:='PNG Files|*.png';

      if(OpenDlg.Execute)then
      begin
        CurrentUser.icon:=LoadAnsiTextFromFile(OpenDlg.FileName);
        CurrentUser.icon_length:=Length(CurrentUser.icon);

        MemStream:=TMemoryStream.Create;
        try
          MemStream.WriteBuffer(CurrentUser.icon[1], CurrentUser.icon_length);

          MemStream.Position:=0;
          UserIconPNGImage.LoadFromStream(MemStream);
          UserIcon.Picture.Graphic:=UserIconPNGImage;
          if(UserIcon.Picture.Width>48)or
            (UserIcon.Picture.Height>48)then
          begin
            UserIconPNGImage:=
              LoadPNGImageFromResource('user_icon', UserIcon);

            ShowModalDialog('User icon too large',
              'Please note that the user icon must not be '+
              'larger than 48x48 pixels',
              myx_mtError, 'OK');

            CurrentUser.icon_length:=0;
            CurrentUser.icon:='';
          end;
          UserIcon.Invalidate;
        finally
          MemStream.Free;
        end;
      end;

      CurrentUserChanged;
    finally
      OpenDlg.Free;
    end;
  end;
end;

procedure TAdminUsersForm.ClearUserImgClick(Sender: TObject);
begin
  UserIconPNGImage:=LoadPNGImageFromResource('user_icon', UserIcon);
  CurrentUser.icon_length:=0;

  CurrentUserChanged;
end;

procedure TAdminUsersForm.DeleteUser(UserName: WideString);
var i: integer;
  Node: TTntTreeNode;
begin
  for i:=0 to UserTreeView.Items.Count-1 do
    if(UserTreeView.Items[i].Level=0)and
      (UserTreeView.Items[i].Text=UserName)then
    begin
      Node:=UserTreeView.Items[i];

      if(Node.Data<>nil)then
        TMYX_USER(Node.Data).Free;

      UserTreeView.Items.Delete(Node);
      break;
    end;
end;


procedure TAdminUsersForm.DeleteUserMIClick(Sender: TObject);
var UserName: WideString;
begin
  if(CurrentUser<>nil)then
  begin
    UserName:=CurrentUser.user_name;

    if(CompareText(UserName, 'root')=0)then
      raise EMyxError.Create('You cannot delete the root user.');

    if(ShowModalDialog('Delete user?', 'Are you sure you want to delete '+
      'the user '+CurrentUser.user_name+'?',
      myx_mtConfirmation,
      'Yes'#13#10'No')=1)then
    begin
      myx_del_user(MySQLConn.MySQL, UserName);

      if(UserNameList<>nil)then
        UserNameList.Free;
      UserNameList:=nil;

      {UserTreeView.Selected:=nil;

      ClearUserControls;
      DeleteUser(UserName);}

      CurrentUserIsChanged:=False;
      ApplyChangesBtn.Enabled:=False;
      DiscardChangesBtn.Enabled:=False;

      RefreshUserTree(AdvancedEdit.SearchEd.Text, False);
    end;
  end;
end;

procedure TAdminUsersForm.AddHosttotheUserMIClick(Sender: TObject);
var i: integer;
  host: WideString;
  user_priv: TMYX_USER_OBJECT_PRIVILEGES;
  puser_priv: PMYX_USER_OBJECT_PRIVILEGES;
begin
  if(CurrentUser<>nil)then
    if(ShowModalEditDialog('Add Host', 'Enter a new Host the User can connect from.',
      myx_mtEdit,
      'OK'#13#10'Abort',
      True, 'Host:', host)=1)then
    begin
      puser_priv:=myx_get_privilege_struct(MySQLConn.MySQL, '');
      try
        user_priv:=TMYX_USER_OBJECT_PRIVILEGES.create(puser_priv);
      finally
        myx_free_user_priv(puser_priv);
      end;
      user_priv.host:=host;

      CurrentUser.hosts.Add(host);

      CurrentUser.user_object_privileges.Add(user_priv);

      for i:=0 to UserTreeView.Items.Count-1 do
        if(UserTreeView.Items[i].Level=0)and
          (UserTreeView.Items[i].Data=CurrentUser)then
        begin
          AddTreeViewChildNode(UserTreeView, UserTreeView.Items[i],
            host, 22, CurrentUser);

          UserTreeView.Items[i].Expand(False);
          break;
        end;

      CurrentUserChanged;
    end;
end;

procedure TAdminUsersForm.UserSubTreePopupMenuPopup(Sender: TObject);

var
  Node: TTntTreeNode;
  MPos: TPoint;

begin
  MPos := UserTreeView.ScreenToClient(Mouse.CursorPos);

  Node := UserTreeView.GetNodeAt(MPos.X, MPos.Y);

  if (Node <> nil) then
    UserTreeView.Selected := Node;

  if(UserTreeView.Selected<>nil)then
  begin
    RemoveHostfromUserMI.Enabled:=True;
      //(UserTreeView.Selected.Level>0);

    AddHosttotheUserMI.Enabled:=
      (UserTreeView.Selected.Level=0);
  end
  else
  begin
    AddHosttotheUserMI.Enabled:=False;
    RemoveHostfromUserMI.Enabled:=False;
  end;
end;

procedure TAdminUsersForm.RemoveHostfromUserMIClick(Sender: TObject);
var i: integer;
  Host: WideString;
  Node: TTntTreeNode;
begin
  if(UserTreeView.Selected<>nil)and
    (CurrentUser<>nil)then
  begin
    if(CurrentUser.hosts.Count=1)then
    begin
      DeleteUserMIClick(self);
      Exit;
    end;

    if(UserTreeView.Selected.Level>0)then
      Host:=UserTreeView.Selected.Text
    else
    begin
        if(CurrentUser.hosts.IndexOf('%')<>-1)then
          Host:='%'
        else
          if(CurrentUser.hosts.Count>0)then
            Host:=CurrentUser.hosts[0]
          else
            Host:='';
    end;

    CurrentUser.hosts.Delete(
      CurrentUser.hosts.IndexOf(Host));

    i:=0;
    while(i<CurrentUser.user_object_privileges.Count)do
    begin
      if(CurrentUser.user_object_privileges[i].host=Host)then
        CurrentUser.user_object_privileges.Delete(i)
      else
        inc(i);
    end;

    if(UserTreeView.Selected.Level>0)then
    begin
      Node:=UserTreeView.Selected;
      UserTreeView.Selected:=UserTreeView.Selected.Parent;

      UserTreeView.Items.Delete(Node);
    end
    else
    begin
      FetchAndDisplayUser(UserTreeView.Selected, CurrentUser.hosts[0]);
    end;

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.AdvancedEditSearchEdChange(Sender: TObject);
begin
  AdvancedEdit.SearchEdChange(self);

  DiscardChanges(True);
  RefreshUserTree(AdvancedEdit.SearchEd.Text);
  NewUserBtn.Enabled := (length(AdvancedEdit.SearchEd.Text) = 0);
end;

procedure TAdminUsersForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:=Not(DiscardChanges(True)=-1);
end;

procedure TAdminUsersForm.GetSchemaTables(Sender: TObject);
var SchemaTables: PMYX_SCHEMA_TABLES;
begin
  SchemaTables:=myx_get_schema_tables(TFetchDataThread(Sender).Connection.MySQL,'',
    TMYX_SCHEMA(TFetchDataThread(Sender).Target).schema_name);
  if(SchemaTables=nil)then
    raise EMyxSQLError.Create(_('Could not fetch Schema Tables.'),
      myx_mysql_errno(TFetchDataThread(Sender).Connection.MySQL),
      myx_mysql_error(TFetchDataThread(Sender).Connection.MySQL));

  TMYX_SCHEMA(TFetchDataThread(Sender).Target).schema_tables:=
    TMYX_SCHEMA_TABLES.create(SchemaTables);
  myx_free_schema_tables(SchemaTables);
end;

procedure TAdminUsersForm.SchemaTablesFetched(Sender: TObject);
begin
  RefreshTableNames(TMYX_SCHEMA(TFetchDataThread(Sender).Target));
end;

procedure TAdminUsersForm.RefreshTableNames(schema: TMYX_SCHEMA);
{var i, j: integer;
  SchemaNode, TableNode: TTntTreeNode;}
begin
  {if(schema.schema_tables=nil)then
    MySQLConn.FetchData(KindOfData_SchemaTables,
      GetSchemaTables, SchemaTablesFetched,
      schema, 'Fetching Tables ...')
  else
  begin
    TblColSchemataFrame.SchemaTreeView.Items.BeginUpdate;
    try
      //Find schema node
      SchemaNode:=nil;
      for i:=0 to TblColSchemataFrame.SchemaTreeView.Items.Count-1 do
        if(TblColSchemataFrame.SchemaTreeView.Items[i].Data=
          schema)then
          SchemaNode:=TblColSchemataFrame.SchemaTreeView.Items[i];

      //Attach tables to schema node
      if(SchemaNode<>nil)then
      begin
        SchemaNode.DeleteChildren;
        for i:=0 to schema.schema_tables.schema_tables.Count-1 do
        begin
          TableNode:=AddTreeViewChildNode(TblColSchemataFrame.SchemaTreeView,
            SchemaNode,
            schema.schema_tables.schema_tables[i].table_name, 10,
            schema.schema_tables.schema_tables[i]);

          for j:=0 to schema.schema_tables.schema_tables[i].columns.Count-1 do
          begin
            AddTreeViewChildNode(TblColSchemataFrame.SchemaTreeView,
              TableNode,
              schema.schema_tables.schema_tables[i].columns[j].column_name,
              11+(schema.schema_tables.schema_tables[i].columns[j].primary_key*13),
              schema.schema_tables.schema_tables[i].columns[j]);
          end;

          SchemaNode.Expand(False);
        end;
      end;
    finally
      TblColSchemataFrame.SchemaTreeView.Items.EndUpdate;
    end;
  end;}
end;


procedure TAdminUsersForm.TblColSchemataFrameSchemaTreeViewExpanding(
  Sender: TObject; Node: TTntTreeNode; var AllowExpansion: Boolean);
begin
  {TblColSchemataFrame.SchemaTreeViewExpanding(Sender, Node,
    AllowExpansion);}

  if(Node.Data<>nil)then
    if(TObject(Node.Data) is TMYX_SCHEMA)then
      if(TMYX_SCHEMA(Node.Data).schema_tables=nil)then
      begin
        Node.DeleteChildren;
        RefreshTableNames(TMYX_SCHEMA(Node.Data));
      end;
end;

procedure TAdminUsersForm.RefreshTablePrivileges(Schema: TMYX_SCHEMA;
  SchemaTable: TMYX_SCHEMA_TABLE;
  SchemaTableColumn: TMYX_SCHEMA_TABLE_COLUMN);
var i: integer;
  UserPriv: TMYX_USER_OBJECT_PRIVILEGES;
  PUserPriv: PMYX_USER_OBJECT_PRIVILEGES;
  ObjName: WideString;
  Item: TListItem;
  PrivNode: PPrivilege;
begin
  ClearTableColumnPrivListViews;

  if(Schema=nil)then
    Exit;

  if(SchemaTable=nil)and(SchemaTableColumn=nil)then
    ObjName:=Schema.schema_name
  else if(SchemaTableColumn=nil)then
    ObjName:=Schema.schema_name+'.'+SchemaTable.table_name
  else
    ObjName:=Schema.schema_name+'.'+SchemaTable.table_name+'.'+
      SchemaTableColumn.column_name;

  //Find schema privileges
  UserPriv:=nil;
  for i:=0 to CurrentUser.user_object_privileges.Count-1 do
  begin
    //if object_name is 'xxxx', these are the schema privileges
    if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
      (CurrentUser.user_object_privileges[i].object_name=ObjName)then
    begin
      UserPriv:=CurrentUser.user_object_privileges[i];
      break;
    end;
  end;

  if(UserPriv=nil)then
  begin
    PUserPriv:=myx_get_privilege_struct(MySQLConn.MySQL,
      ObjName);
    try
      UserPriv:=TMYX_USER_OBJECT_PRIVILEGES.create(PUserPriv);
    finally
      myx_free_user_priv(PUserPriv);
    end;

    UserPriv.host:=CurrentUserHost;
    UserPriv.object_name:=ObjName;

    CurrentUser.user_object_privileges.Add(UserPriv);
  end;

  if(UserPriv<>nil)then
  begin
    for i:=0 to UserPriv.user_privileges.Count-1 do
    begin
      PrivNode:=New(PPrivilege);
      PrivNode.id:=UserPriv.user_privileges.Names[i];

      if(UserPriv.user_privileges.ValueFromIndex[i]='Y')then
        Item:=AddListViewItem(TablePrivAssignedListView, nil,
          Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
          15, PrivNode)
      else
        Item:=AddListViewItem(TablePrivAvailListView, nil,
          Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
          15, PrivNode);

      Item.SubItems.Add('Grants the '+
        Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', ''))+
        ' privilege to the user');
    end;
  end;
end;

procedure TAdminUsersForm.RefreshProcPrivileges(Schema: TMYX_SCHEMA;
  SchemaProc: TMYX_SCHEMA_STORED_PROCEDURE);
var i: integer;
  UserPriv: TMYX_USER_OBJECT_PRIVILEGES;
  PUserPriv: PMYX_USER_OBJECT_PRIVILEGES;
  ObjName: WideString;
  Item: TListItem;
  PrivNode: PPrivilege;
begin
  ClearTableColumnPrivListViews;

  if(Schema=nil)then
    Exit;

  if(SchemaProc=nil)then
    ObjName:=Schema.schema_name
  else
    ObjName:=Schema.schema_name+'.'+SchemaProc.name;

  //Find schema privileges
  UserPriv:=nil;
  for i:=0 to CurrentUser.user_object_privileges.Count-1 do
  begin
    //if object_name is 'xxxx', these are the schema privileges
    if(CurrentUser.user_object_privileges[i].host=CurrentUserHost)and
      (CurrentUser.user_object_privileges[i].object_name=ObjName)then
    begin
      UserPriv:=CurrentUser.user_object_privileges[i];
      break;
    end;
  end;

  if(UserPriv=nil)then
  begin
    PUserPriv:=myx_get_privilege_struct(MySQLConn.MySQL,
      ObjName);
    try
      UserPriv:=TMYX_USER_OBJECT_PRIVILEGES.create(PUserPriv);
    finally
      myx_free_user_priv(PUserPriv);
    end;

    UserPriv.host:=CurrentUserHost;
    UserPriv.object_name:=ObjName;

    CurrentUser.user_object_privileges.Add(UserPriv);
  end;

  if(UserPriv<>nil)then
  begin
    for i:=0 to UserPriv.user_privileges.Count-1 do
    begin
      PrivNode:=New(PPrivilege);
      PrivNode.id:=UserPriv.user_privileges.Names[i];

      if(UserPriv.user_privileges.ValueFromIndex[i]='Y')then
        Item:=AddListViewItem(TablePrivAssignedListView, nil,
          Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
          15, PrivNode)
      else
        Item:=AddListViewItem(TablePrivAvailListView, nil,
          Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', '')),
          15, PrivNode);

      Item.SubItems.Add('Grants the '+
        Uppercase(AnsiReplaceStr(UserPriv.user_privileges.Names[i], '_priv', ''))+
        ' privilege to the user');
    end;
  end;
end;


procedure TAdminUsersForm.AssignTblColPrivBtnClick(Sender: TObject);
begin
  if(GetCurrentUserTblColSchema<>nil)then
  begin
    if(GetCurrentUserColumn=nil)and(GetCurrentUserTable=nil)and(GetCurrentUserProc=nil)then
      MovePriv(TablePrivAvailListView, TablePrivAssignedListView,
        GetCurrentUserTblColSchema.schema_name, True)
    else if(GetCurrentUserColumn=nil)then
      if(GetCurrentUserProc <> nil) then
      begin
        MovePriv(TablePrivAvailListView, TablePrivAssignedListView,
          GetCurrentUserTblColSchema.schema_name+'.'+GetCurrentUserProc.name, True)
      end
      else
      begin
        MovePriv(TablePrivAvailListView, TablePrivAssignedListView,
          GetCurrentUserTblColSchema.schema_name+'.'+GetCurrentUserTable.table_name, True)
      end
    else
      MovePriv(TablePrivAvailListView, TablePrivAssignedListView,
        GetCurrentUserTblColSchema.schema_name+'.'+GetCurrentUserTable.table_name+'.'+
        GetCurrentUserColumn.column_name, True);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.RemoveTblColPrivBtnClick(Sender: TObject);
begin
  if(GetCurrentUserTblColSchema<>nil)then
  begin
    if(GetCurrentUserColumn=nil)and(GetCurrentUserTable=nil)then
      MovePriv(TablePrivAssignedListView, TablePrivAvailListView,
        GetCurrentUserTblColSchema.schema_name, False)
    else if(GetCurrentUserColumn=nil)then
      MovePriv(TablePrivAssignedListView, TablePrivAvailListView,
        GetCurrentUserTblColSchema.schema_name+'.'+GetCurrentUserTable.table_name, False)
    else
      MovePriv(TablePrivAssignedListView, TablePrivAvailListView,
        GetCurrentUserTblColSchema.schema_name+'.'+GetCurrentUserTable.table_name+'.'+
        GetCurrentUserColumn.column_name, False);

    CurrentUserChanged;
  end;
end;

procedure TAdminUsersForm.ClearGlobalPrivListViews;
var i: integer;
begin
  for i:=0 to GlobalAssignedPrivListView.Items.Count-1 do
    if(GlobalAssignedPrivListView.Items[i].Data<>nil)then
      Dispose(GlobalAssignedPrivListView.Items[i].Data);
  GlobalAssignedPrivListView.Clear;

  for i:=0 to GlobalPrivListView.Items.Count-1 do
    if(GlobalPrivListView.Items[i].Data<>nil)then
      Dispose(GlobalPrivListView.Items[i].Data);
  GlobalPrivListView.Clear;
end;

procedure TAdminUsersForm.ClearSchemaPrivListViews;
var i: integer;
begin
  for i:=0 to SchemaPrivAssignedListView.Items.Count-1 do
    if(SchemaPrivAssignedListView.Items[i].Data<>nil)then
      Dispose(SchemaPrivAssignedListView.Items[i].Data);
  SchemaPrivAssignedListView.Clear;

  for i:=0 to SchemaPrivAssignedListView.Items.Count-1 do
    if(SchemaPrivAssignedListView.Items[i].Data<>nil)then
      Dispose(SchemaPrivAssignedListView.Items[i].Data);
  SchemaPrivAvailListView.Clear;
end;

procedure TAdminUsersForm.ClearTableColumnPrivListViews;
var i: integer;
begin
  for i:=0 to TablePrivAvailListView.Items.Count-1 do
    if(TablePrivAvailListView.Items[i].Data<>nil)then
      Dispose(TablePrivAvailListView.Items[i].Data);
  TablePrivAvailListView.Clear;

  for i:=0 to TablePrivAssignedListView.Items.Count-1 do
    if(TablePrivAssignedListView.Items[i].Data<>nil)then
      Dispose(TablePrivAssignedListView.Items[i].Data);
  TablePrivAssignedListView.Clear;
end;

procedure TAdminUsersForm.ApplyOptionSettings;
begin
  GlobalPrivSheet.TabVisible:=ApplicationDM.Options.ShowUserGlobalPrivileges;
  TablePrivSheet.TabVisible:=ApplicationDM.Options.ShowUserTableColumnPrivileges;

  SetDataFont([UserInfoNameLbl, GlobalPrivNameLbl,
    SchemaPrivNameLbl, TableColumnPrivNameLbl, ResourceNameLbl,
    UserNameEd, PasswordEd, PasswordConfirmationEd, FullNameEd, DescriptionEd,
    EmailEd, ContactInfoMemo,
    UserTreeView, AdvancedEdit.SearchEd]);
end;

procedure TAdminUsersForm.OptionsChanged(var Message: TMessage);
begin
  ApplyOptionSettings;
end;

procedure TAdminUsersForm.CloneUserMIClick(Sender: TObject);
begin
  if(CurrentUser<>nil)then
  begin
    NewUser(CurrentUser);
  end;
end;

procedure TAdminUsersForm.AssignAllGlobalPrivBtnClick(Sender: TObject);
begin
  GlobalPrivListView.SelectAll;

  AssignGlobalPrivBtnClick(self);
end;

procedure TAdminUsersForm.RemoveAllGlobalPrivBtnClick(Sender: TObject);
begin
  GlobalAssignedPrivListView.SelectAll;

  RemoveGlobalPrivBtnClick(self);
end;

procedure TAdminUsersForm.AssignAllSchemaPrivBtnClick(Sender: TObject);
begin
  SchemaPrivAvailListView.SelectAll;
  
  AssignSchemaPrivBtnClick(self);
end;

procedure TAdminUsersForm.RemoveAllSchemaPrivBtnClick(Sender: TObject);
begin
  SchemaPrivAssignedListView.SelectAll;

  RemoveSchemaPrivBtnClick(self);
end;

procedure TAdminUsersForm.AssignAllTblColPrivBtnClick(Sender: TObject);
begin
  TablePrivAvailListView.SelectAll;

  AssignTblColPrivBtnClick(self);
end;

procedure TAdminUsersForm.RemoveAllTblColPrivBtnClick(Sender: TObject);
begin
  TablePrivAssignedListView.SelectAll;

  RemoveTblColPrivBtnClick(self);
end;

procedure TAdminUsersForm.Disconnected(var Message: TMessage);
begin
  DiscardChanges(False, False);

  ClearUsers;
  ClearUserControls;
  DisableEnableUserPageControl(False);

  NewUserBtn.Enabled:=False;
  ApplyChangesBtn.Enabled:=False;
  DiscardChangesBtn.Enabled:=False;
end;

procedure TAdminUsersForm.Reconnected(var Message: TMessage);
begin
  //DisableEnableUserPageControl(True);

  RefreshUserTree('', False);
end;

procedure TAdminUsersForm.SchemaListChanged(var Message: TMessage);
begin
  SchemaPrivSchemataFrame.ReloadSchemaTree;

  TblColSchemataFrame.ReloadSchemaTree;
end;

procedure TAdminUsersForm.SchemaPrivSchemataFrameSchemaTreeViewDblClick(
  Sender: TObject);
begin
  //Disable doubleclick
  //SchemaPrivSchemataFrame.SchemaTreeViewDblClick(Sender);
end;

procedure TAdminUsersForm.TblColSchemataFrameSchemaTreeViewDblClick(
  Sender: TObject);
begin
  //Disable doubleclick
  //TblColSchemataFrame.SchemaTreeViewDblClick(Sender);

end;

function TAdminUsersForm.GetCurrentUserSchema: TMYX_SCHEMA;
var NodeData: ^TObject;
begin
  Result:=nil;

  NodeData:=SchemaPrivSchemataFrame.CatalogVST.GetNodeData(
    SchemaPrivSchemataFrame.CatalogVST.FocusedNode);
  if(NodeData<>nil)then
    if(NodeData^ is TMYX_SCHEMA)then
      Result:=TMYX_SCHEMA(NodeData^);
end;

procedure TAdminUsersForm.SchemaPrivSchemataFrameCatalogVSTChange(
  Sender: TBaseVirtualTree; Node: PVirtualNode);
var NodeData: ^TObject;
begin
  SchemaPrivSchemataFrame.CatalogVSTChange(Sender, Node);

  NodeData:=Sender.GetNodeData(Node);
  if(NodeData<>nil)then
    if(NodeData^ is TMYX_SCHEMA)then
    begin
      RefreshSchemaPrivileges(TMYX_SCHEMA(NodeData^));
    end;
end;

function TAdminUsersForm.GetCurrentUserTblColSchema: TMYX_SCHEMA;
var NodeData, ParentNodeData, ParentParentNodeData: ^TObject;
begin
  Result:=nil;

  NodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
    TblColSchemataFrame.CatalogVST.FocusedNode);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
      if(NodeData^ is TMYX_SCHEMA)then
      begin
        Result:=TMYX_SCHEMA(NodeData^)
      end
      else if((NodeData^ is TMYX_SCHEMA_TABLE) or (NodeData^ is TMYX_SCHEMA_STORED_PROCEDURE))and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
          TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.FocusedNode]);

        if(ParentNodeData<>nil)then
          if(ParentNodeData^<>nil)then
            Result:=TMYX_SCHEMA(ParentNodeData^);
      end
      else if(NodeData^ is TMYX_SCHEMA_TABLE_COLUMN)and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
          TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.FocusedNode]);

        if(ParentNodeData<>nil)and
          (TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.NodeParent[
              TblColSchemataFrame.CatalogVST.FocusedNode]]<>nil)then
        begin
          ParentParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
            TblColSchemataFrame.CatalogVST.NodeParent[
              TblColSchemataFrame.CatalogVST.NodeParent[
                TblColSchemataFrame.CatalogVST.FocusedNode]]);

          if(ParentNodeData^<>nil)and
            (ParentParentNodeData<>nil)then
            if(ParentParentNodeData^<>nil)then
              Result:=TMYX_SCHEMA(ParentParentNodeData^);
        end;
      end;
end;

function TAdminUsersForm.GetCurrentUserTable: TMYX_SCHEMA_TABLE;
var NodeData, ParentNodeData: ^TObject;
begin
  Result:=nil;

  NodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
    TblColSchemataFrame.CatalogVST.FocusedNode);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
      if(NodeData^ is TMYX_SCHEMA_TABLE)and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        Result:=TMYX_SCHEMA_TABLE(NodeData^);
      end
      else if(NodeData^ is TMYX_SCHEMA_TABLE_COLUMN)and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
          TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.FocusedNode]);

        if(ParentNodeData<>nil)then
          if(ParentNodeData^<>nil)then
            Result:=TMYX_SCHEMA_TABLE(ParentNodeData^);
      end;
end;

function TAdminUsersForm.GetCurrentUserProc: TMYX_SCHEMA_STORED_PROCEDURE;
var NodeData: ^TObject;
begin
  Result:=nil;

  NodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
    TblColSchemataFrame.CatalogVST.FocusedNode);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
      if(NodeData^ is TMYX_SCHEMA_STORED_PROCEDURE)and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        Result:=TMYX_SCHEMA_STORED_PROCEDURE(NodeData^);
      end
end;


function TAdminUsersForm.GetCurrentUserColumn: TMYX_SCHEMA_TABLE_COLUMN;
var NodeData: ^TObject;
begin
  Result:=nil;

  NodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
    TblColSchemataFrame.CatalogVST.FocusedNode);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
      if(NodeData^ is TMYX_SCHEMA_TABLE_COLUMN)and
        (TblColSchemataFrame.CatalogVST.NodeParent[
          TblColSchemataFrame.CatalogVST.FocusedNode]<>nil)and
        (CurrentUser<>nil)then
      begin
        Result:=TMYX_SCHEMA_TABLE_COLUMN(NodeData^);
        
        {ParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
          TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.FocusedNode]);

        if(ParentNodeData<>nil)and
          (TblColSchemataFrame.CatalogVST.NodeParent[
            TblColSchemataFrame.CatalogVST.NodeParent[
              TblColSchemataFrame.CatalogVST.FocusedNode]]<>nil)then
        begin
          ParentParentNodeData:=TblColSchemataFrame.CatalogVST.GetNodeData(
            TblColSchemataFrame.CatalogVST.NodeParent[
              TblColSchemataFrame.CatalogVST.NodeParent[
                TblColSchemataFrame.CatalogVST.FocusedNode]]);

          if(ParentNodeData^<>nil)and
            (ParentParentNodeData<>nil)then
            if(ParentParentNodeData^<>nil)then
              Result:=TMYX_SCHEMA_TABLE_COLUMN(NodeData^);
        end;}
      end;

end;

procedure TAdminUsersForm.TblColSchemataFrameCatalogVSTChange(
  Sender: TBaseVirtualTree; Node: PVirtualNode);
var NodeData, ParentNodeData, ParentParentNodeData: ^TObject;
  CurrentUserTblColSchema: TMYX_SCHEMA;
  CurrentUserTable: TMYX_SCHEMA_TABLE;
  CurrentUserProc: TMYX_SCHEMA_STORED_PROCEDURE;
  CurrentUserColumn: TMYX_SCHEMA_TABLE_COLUMN;
begin
  TblColSchemataFrame.CatalogVSTChange(Sender, Node);

  NodeData:=Sender.GetNodeData(Node);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
    begin
      if(NodeData^ is TMYX_SCHEMA)then
      begin
        CurrentUserTblColSchema:=TMYX_SCHEMA(NodeData^);

        RefreshTablePrivileges(CurrentUserTblColSchema, nil, nil);
        RefreshTableNames(CurrentUserTblColSchema);
      end;

      if(NodeData^ is TMYX_SCHEMA_TABLE)and
        (Sender.NodeParent[Node]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=Sender.GetNodeData(Sender.NodeParent[Node]);

        if(ParentNodeData<>nil)then
          if(ParentNodeData^<>nil)then
          begin
            CurrentUserTblColSchema:=TMYX_SCHEMA(ParentNodeData^);
            CurrentUserTable:=TMYX_SCHEMA_TABLE(NodeData^);

            RefreshTablePrivileges(CurrentUserTblColSchema,
              CurrentUserTable, nil);
          end;
      end;

      if(NodeData^ is TMYX_SCHEMA_STORED_PROCEDURE)and
        (Sender.NodeParent[Node]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=Sender.GetNodeData(Sender.NodeParent[Node]);

        if(ParentNodeData<>nil)then
          if(ParentNodeData^<>nil)then
          begin
            CurrentUserTblColSchema:=TMYX_SCHEMA(ParentNodeData^);
            CurrentUserProc:=TMYX_SCHEMA_STORED_PROCEDURE(NodeData^);

            RefreshProcPrivileges(CurrentUserTblColSchema,
              CurrentUserProc);
          end;
      end;

      if(NodeData^ is TMYX_SCHEMA_TABLE_COLUMN)and
        (Sender.NodeParent[Node]<>nil)and
        (CurrentUser<>nil)then
      begin
        ParentNodeData:=Sender.GetNodeData(Sender.NodeParent[Node]);

        if(ParentNodeData<>nil)and
          (Sender.NodeParent[Sender.NodeParent[Node]]<>nil)then
        begin
          ParentParentNodeData:=Sender.GetNodeData(Sender.NodeParent[Sender.NodeParent[Node]]);

          if(ParentNodeData^<>nil)and
            (ParentParentNodeData<>nil)then
          begin
            if(ParentParentNodeData^<>nil)then
            begin
              CurrentUserTblColSchema:=TMYX_SCHEMA(ParentParentNodeData^);
              CurrentUserTable:=TMYX_SCHEMA_TABLE(ParentNodeData^);
              CurrentUserColumn:=TMYX_SCHEMA_TABLE_COLUMN(NodeData^);

              RefreshTablePrivileges(CurrentUserTblColSchema,
                CurrentUserTable, CurrentUserColumn);
            end;
          end;
        end;
      end;
    end;
end;

procedure TAdminUsersForm.AddSchemawithWidcardsMIClick(Sender: TObject);
var catalog_name, schema_name: WideString;
  //catalog: TMYX_CATALOG;
  res: integer;
begin
  {if(SchemaPrivSchemataFrame.SchemaTreeView.Selected<>nil)then
    if(TObject(SchemaPrivSchemataFrame.SchemaTreeView.Selected.Data) is
      TMYX_CATALOG)then
    begin
      catalog:=TMYX_CATALOG(
        SchemaPrivSchemataFrame.SchemaTreeView.Selected.Data);}

      catalog_name:='def';
      schema_name:='';

      res:=ShowModalEditDialog('Add schema',
        'Please enter the name of a new schema '+
        'including wildcards like % and _, e.g. test%'#13#10#13#10,
        myx_mtEdit, 'Store'#13#10'Cancel',
        True, 'Schema name:', schema_name,
        1, False);

      if(res=1)and(schema_name<>'')then
      begin
        SchemaPrivSchemataFrame.SchemasToAdd.Add(catalog_name+'/'+
          schema_name);

        SchemaPrivSchemataFrame.FillSchemaTree(
          SchemaPrivSchemataFrame.AdvancedEdit.SearchEd.Text);
      end;
    {end;}
end;

procedure TAdminUsersForm.RefreshCatalogTreeMIClick(Sender: TObject);
begin
  SchemaPrivSchemataFrame.ReloadSchemaTree;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminUsersForm.UserTreeViewDeletion(Sender: TObject; Node: TTreeNode);

begin
  // TODO: Improve user data handling.
  // Due to the way user data objects are handled here it is not simply possible the delete them.
  // Without the Free class, though, memory leaks remain. This must be further investigated but is too involved for the moment.
  // TMYX_USER(Node.Data).Free;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminUsersForm.MenuMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);

var
  Size: TSize;
  Item: TTntMenuItem;

begin
  if Sender is TTntMenuItem then
  begin
    Item := Sender as TTntMenuItem;
    ACanvas.Font := Font;

    if Item.IsLine then
    begin
      Width := 10; // This will actually have no effect, because other entries are much wider.
      Height := 6;
    end
    else
    begin
      GetTextExtentPoint32W(ACanvas.Handle, PWideChar(Item.Caption), Length(Item.Caption), Size);

      // Border around each entry.
      Width := Size.cx + 4;
      Height := Size.cy + 6;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TAdminUsersForm.MenuDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; State: TOwnerDrawState);

var
  Item: TTntMenuItem;

begin
  if Sender is TTntMenuItem then
  begin
    Item := Sender as TTntMenuItem;
    ACanvas.Font := Font;

    if Item.IsLine then
    begin
      // A menu separator.
      ACanvas.Pen.Color := clBtnShadow;
      ACanvas.MoveTo(ARect.Left + 2, (ARect.Bottom + ARect.Top) div 2);
      ACanvas.LineTo(ARect.Right - 2, (ARect.Bottom + ARect.Top) div 2);
    end
    else
    begin
      // Top level items have an invisible parent, so have to check the parent of the parent.
      if (Item.Parent.Parent = nil) and not (Item.GetParentMenu is TPopupMenu) then
      begin
        if [odHotLight, odSelected] * State <> [] then
          ACanvas.Brush.Color := clHighlight
        else
          ACanvas.Brush.Color := clBtnFace;
      end;
      ACanvas.FillRect(ARect);
      Inc(ARect.Left, 8);
      SetBKMode(ACanvas.Handle, TRANSPARENT);
      Windows.DrawTextW(ACanvas.Handle, PWideChar(Item.Caption), Length(Item.Caption), ARect, DT_LEFT + DT_SINGLELINE +
        DT_HIDEPREFIX + DT_VCENTER);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

end.
