-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.11-beta


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema sakila
--

CREATE DATABASE IF NOT EXISTS sakila;
USE sakila;

--
-- Temporary table structure for view `sakila`.`actor_info`
--
DROP TABLE IF EXISTS `sakila`.`actor_info`;
DROP VIEW IF EXISTS `sakila`.`actor_info`;
CREATE TABLE `sakila`.`actor_info` (
  `actor_id` smallint(5) unsigned,
  `first_name` varchar(45),
  `last_name` varchar(45),
  `film_info` varchar(341)
);

--
-- Temporary table structure for view `sakila`.`customer_list`
--
DROP TABLE IF EXISTS `sakila`.`customer_list`;
DROP VIEW IF EXISTS `sakila`.`customer_list`;
CREATE TABLE `sakila`.`customer_list` (
  `ID` smallint(5) unsigned,
  `name` varchar(91),
  `address` varchar(50),
  `zip code` varchar(10),
  `phone` varchar(20),
  `city` varchar(50),
  `country` varchar(50),
  `notes` varchar(6),
  `SID` tinyint(3) unsigned
);

--
-- Temporary table structure for view `sakila`.`film_list`
--
DROP TABLE IF EXISTS `sakila`.`film_list`;
DROP VIEW IF EXISTS `sakila`.`film_list`;
CREATE TABLE `sakila`.`film_list` (
  `FID` smallint(5) unsigned,
  `title` varchar(255),
  `description` text,
  `category` varchar(25),
  `price` decimal(4,2),
  `length` smallint(5) unsigned,
  `rating` enum('G','PG','PG-13','R','NC-17'),
  `actors` varchar(341)
);

--
-- Temporary table structure for view `sakila`.`nicer_but_slower_film_list`
--
DROP TABLE IF EXISTS `sakila`.`nicer_but_slower_film_list`;
DROP VIEW IF EXISTS `sakila`.`nicer_but_slower_film_list`;
CREATE TABLE `sakila`.`nicer_but_slower_film_list` (
  `FID` smallint(5) unsigned,
  `title` varchar(255),
  `description` text,
  `category` varchar(25),
  `price` decimal(4,2),
  `length` smallint(5) unsigned,
  `rating` enum('G','PG','PG-13','R','NC-17'),
  `actors` varchar(341)
);

--
-- Temporary table structure for view `sakila`.`sales_by_film_category`
--
DROP TABLE IF EXISTS `sakila`.`sales_by_film_category`;
DROP VIEW IF EXISTS `sakila`.`sales_by_film_category`;
CREATE TABLE `sakila`.`sales_by_film_category` (
  `category` varchar(25),
  `total_sales` decimal(27,2)
);

--
-- Temporary table structure for view `sakila`.`sales_by_store`
--
DROP TABLE IF EXISTS `sakila`.`sales_by_store`;
DROP VIEW IF EXISTS `sakila`.`sales_by_store`;
CREATE TABLE `sakila`.`sales_by_store` (
  `store` varchar(101),
  `manager` varchar(91),
  `total_sales` decimal(27,2)
);

--
-- Temporary table structure for view `sakila`.`staff_list`
--
DROP TABLE IF EXISTS `sakila`.`staff_list`;
DROP VIEW IF EXISTS `sakila`.`staff_list`;
CREATE TABLE `sakila`.`staff_list` (
  `ID` tinyint(3) unsigned,
  `name` varchar(91),
  `address` varchar(50),
  `zip code` varchar(10),
  `phone` varchar(20),
  `city` varchar(50),
  `country` varchar(50),
  `SID` tinyint(3) unsigned
);

--
-- Definition of table `sakila`.`actor`
--

DROP TABLE IF EXISTS `sakila`.`actor`;
CREATE TABLE  `sakila`.`actor` (
  `actor_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(45) NOT NULL,
  `last_name` varchar(45) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`),
  KEY `idx_actor_last_name` (`last_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`actor`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`actor` VALUES  (1,'PENELOPE','GUINESS','2006-02-15 04:34:33'),
 (2,'NICK','WAHLBERG','2006-02-15 04:34:33'),
 (3,'ED','CHASE','2006-02-15 04:34:33'),
 (4,'JENNIFER','DAVIS','2006-02-15 04:34:33'),
 (5,'JOHNNY','LOLLOBRIGIDA','2006-02-15 04:34:33'),
 (6,'BETTE','NICHOLSON','2006-02-15 04:34:33'),
 (7,'GRACE','MOSTEL','2006-02-15 04:34:33'),
 (8,'MATTHEW','JOHANSSON','2006-02-15 04:34:33'),
 (9,'JOE','SWANK','2006-02-15 04:34:33'),
 (10,'CHRISTIAN','GABLE','2006-02-15 04:34:33'),
 (11,'ZERO','CAGE','2006-02-15 04:34:33'),
 (12,'KARL','BERRY','2006-02-15 04:34:33'),
 (13,'UMA','WOOD','2006-02-15 04:34:33'),
 (14,'VIVIEN','BERGEN','2006-02-15 04:34:33'),
 (15,'CUBA','OLIVIER','2006-02-15 04:34:33'),
 (16,'FRED','COSTNER','2006-02-15 04:34:33'),
 (17,'HELEN','VOIGHT','2006-02-15 04:34:33'),
 (18,'DAN','TORN','2006-02-15 04:34:33'),
 (19,'BOB','FAWCETT','2006-02-15 04:34:33'),
 (20,'LUCILLE','TRACY','2006-02-15 04:34:33'),
 (21,'KIRSTEN','PALTROW','2006-02-15 04:34:33'),
 (22,'ELVIS','MARX','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (23,'SANDRA','KILMER','2006-02-15 04:34:33'),
 (24,'CAMERON','STREEP','2006-02-15 04:34:33'),
 (25,'KEVIN','BLOOM','2006-02-15 04:34:33'),
 (26,'RIP','CRAWFORD','2006-02-15 04:34:33'),
 (27,'JULIA','MCQUEEN','2006-02-15 04:34:33'),
 (28,'WOODY','HOFFMAN','2006-02-15 04:34:33'),
 (29,'ALEC','WAYNE','2006-02-15 04:34:33'),
 (30,'SANDRA','PECK','2006-02-15 04:34:33'),
 (31,'SISSY','SOBIESKI','2006-02-15 04:34:33'),
 (32,'TIM','HACKMAN','2006-02-15 04:34:33'),
 (33,'MILLA','PECK','2006-02-15 04:34:33'),
 (34,'AUDREY','OLIVIER','2006-02-15 04:34:33'),
 (35,'JUDY','DEAN','2006-02-15 04:34:33'),
 (36,'BURT','DUKAKIS','2006-02-15 04:34:33'),
 (37,'VAL','BOLGER','2006-02-15 04:34:33'),
 (38,'TOM','MCKELLEN','2006-02-15 04:34:33'),
 (39,'GOLDIE','BRODY','2006-02-15 04:34:33'),
 (40,'JOHNNY','CAGE','2006-02-15 04:34:33'),
 (41,'JODIE','DEGENERES','2006-02-15 04:34:33'),
 (42,'TOM','MIRANDA','2006-02-15 04:34:33'),
 (43,'KIRK','JOVOVICH','2006-02-15 04:34:33'),
 (44,'NICK','STALLONE','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (45,'REESE','KILMER','2006-02-15 04:34:33'),
 (46,'PARKER','GOLDBERG','2006-02-15 04:34:33'),
 (47,'JULIA','BARRYMORE','2006-02-15 04:34:33'),
 (48,'FRANCES','DAY-LEWIS','2006-02-15 04:34:33'),
 (49,'ANNE','CRONYN','2006-02-15 04:34:33'),
 (50,'NATALIE','HOPKINS','2006-02-15 04:34:33'),
 (51,'GARY','PHOENIX','2006-02-15 04:34:33'),
 (52,'CARMEN','HUNT','2006-02-15 04:34:33'),
 (53,'MENA','TEMPLE','2006-02-15 04:34:33'),
 (54,'PENELOPE','PINKETT','2006-02-15 04:34:33'),
 (55,'FAY','KILMER','2006-02-15 04:34:33'),
 (56,'DAN','HARRIS','2006-02-15 04:34:33'),
 (57,'JUDE','CRUISE','2006-02-15 04:34:33'),
 (58,'CHRISTIAN','AKROYD','2006-02-15 04:34:33'),
 (59,'DUSTIN','TAUTOU','2006-02-15 04:34:33'),
 (60,'HENRY','BERRY','2006-02-15 04:34:33'),
 (61,'CHRISTIAN','NEESON','2006-02-15 04:34:33'),
 (62,'JAYNE','NEESON','2006-02-15 04:34:33'),
 (63,'CAMERON','WRAY','2006-02-15 04:34:33'),
 (64,'RAY','JOHANSSON','2006-02-15 04:34:33'),
 (65,'ANGELA','HUDSON','2006-02-15 04:34:33'),
 (66,'MARY','TANDY','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (67,'JESSICA','BAILEY','2006-02-15 04:34:33'),
 (68,'RIP','WINSLET','2006-02-15 04:34:33'),
 (69,'KENNETH','PALTROW','2006-02-15 04:34:33'),
 (70,'MICHELLE','MCCONAUGHEY','2006-02-15 04:34:33'),
 (71,'ADAM','GRANT','2006-02-15 04:34:33'),
 (72,'SEAN','WILLIAMS','2006-02-15 04:34:33'),
 (73,'GARY','PENN','2006-02-15 04:34:33'),
 (74,'MILLA','KEITEL','2006-02-15 04:34:33'),
 (75,'BURT','POSEY','2006-02-15 04:34:33'),
 (76,'ANGELINA','ASTAIRE','2006-02-15 04:34:33'),
 (77,'CARY','MCCONAUGHEY','2006-02-15 04:34:33'),
 (78,'GROUCHO','SINATRA','2006-02-15 04:34:33'),
 (79,'MAE','HOFFMAN','2006-02-15 04:34:33'),
 (80,'RALPH','CRUZ','2006-02-15 04:34:33'),
 (81,'SCARLETT','DAMON','2006-02-15 04:34:33'),
 (82,'WOODY','JOLIE','2006-02-15 04:34:33'),
 (83,'BEN','WILLIS','2006-02-15 04:34:33'),
 (84,'JAMES','PITT','2006-02-15 04:34:33'),
 (85,'MINNIE','ZELLWEGER','2006-02-15 04:34:33'),
 (86,'GREG','CHAPLIN','2006-02-15 04:34:33'),
 (87,'SPENCER','PECK','2006-02-15 04:34:33'),
 (88,'KENNETH','PESCI','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (89,'CHARLIZE','DENCH','2006-02-15 04:34:33'),
 (90,'SEAN','GUINESS','2006-02-15 04:34:33'),
 (91,'CHRISTOPHER','BERRY','2006-02-15 04:34:33'),
 (92,'KIRSTEN','AKROYD','2006-02-15 04:34:33'),
 (93,'ELLEN','PRESLEY','2006-02-15 04:34:33'),
 (94,'KENNETH','TORN','2006-02-15 04:34:33'),
 (95,'DARYL','WAHLBERG','2006-02-15 04:34:33'),
 (96,'GENE','WILLIS','2006-02-15 04:34:33'),
 (97,'MEG','HAWKE','2006-02-15 04:34:33'),
 (98,'CHRIS','BRIDGES','2006-02-15 04:34:33'),
 (99,'JIM','MOSTEL','2006-02-15 04:34:33'),
 (100,'SPENCER','DEPP','2006-02-15 04:34:33'),
 (101,'SUSAN','DAVIS','2006-02-15 04:34:33'),
 (102,'WALTER','TORN','2006-02-15 04:34:33'),
 (103,'MATTHEW','LEIGH','2006-02-15 04:34:33'),
 (104,'PENELOPE','CRONYN','2006-02-15 04:34:33'),
 (105,'SIDNEY','CROWE','2006-02-15 04:34:33'),
 (106,'GROUCHO','DUNST','2006-02-15 04:34:33'),
 (107,'GINA','DEGENERES','2006-02-15 04:34:33'),
 (108,'WARREN','NOLTE','2006-02-15 04:34:33'),
 (109,'SYLVESTER','DERN','2006-02-15 04:34:33'),
 (110,'SUSAN','DAVIS','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (111,'CAMERON','ZELLWEGER','2006-02-15 04:34:33'),
 (112,'RUSSELL','BACALL','2006-02-15 04:34:33'),
 (113,'MORGAN','HOPKINS','2006-02-15 04:34:33'),
 (114,'MORGAN','MCDORMAND','2006-02-15 04:34:33'),
 (115,'HARRISON','BALE','2006-02-15 04:34:33'),
 (116,'DAN','STREEP','2006-02-15 04:34:33'),
 (117,'RENEE','TRACY','2006-02-15 04:34:33'),
 (118,'CUBA','ALLEN','2006-02-15 04:34:33'),
 (119,'WARREN','JACKMAN','2006-02-15 04:34:33'),
 (120,'PENELOPE','MONROE','2006-02-15 04:34:33'),
 (121,'LIZA','BERGMAN','2006-02-15 04:34:33'),
 (122,'SALMA','NOLTE','2006-02-15 04:34:33'),
 (123,'JULIANNE','DENCH','2006-02-15 04:34:33'),
 (124,'SCARLETT','BENING','2006-02-15 04:34:33'),
 (125,'ALBERT','NOLTE','2006-02-15 04:34:33'),
 (126,'FRANCES','TOMEI','2006-02-15 04:34:33'),
 (127,'KEVIN','GARLAND','2006-02-15 04:34:33'),
 (128,'CATE','MCQUEEN','2006-02-15 04:34:33'),
 (129,'DARYL','CRAWFORD','2006-02-15 04:34:33'),
 (130,'GRETA','KEITEL','2006-02-15 04:34:33'),
 (131,'JANE','JACKMAN','2006-02-15 04:34:33'),
 (132,'ADAM','HOPPER','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (133,'RICHARD','PENN','2006-02-15 04:34:33'),
 (134,'GENE','HOPKINS','2006-02-15 04:34:33'),
 (135,'RITA','REYNOLDS','2006-02-15 04:34:33'),
 (136,'ED','MANSFIELD','2006-02-15 04:34:33'),
 (137,'MORGAN','WILLIAMS','2006-02-15 04:34:33'),
 (138,'LUCILLE','DEE','2006-02-15 04:34:33'),
 (139,'EWAN','GOODING','2006-02-15 04:34:33'),
 (140,'WHOOPI','HURT','2006-02-15 04:34:33'),
 (141,'CATE','HARRIS','2006-02-15 04:34:33'),
 (142,'JADA','RYDER','2006-02-15 04:34:33'),
 (143,'RIVER','DEAN','2006-02-15 04:34:33'),
 (144,'ANGELA','WITHERSPOON','2006-02-15 04:34:33'),
 (145,'KIM','ALLEN','2006-02-15 04:34:33'),
 (146,'ALBERT','JOHANSSON','2006-02-15 04:34:33'),
 (147,'FAY','WINSLET','2006-02-15 04:34:33'),
 (148,'EMILY','DEE','2006-02-15 04:34:33'),
 (149,'RUSSELL','TEMPLE','2006-02-15 04:34:33'),
 (150,'JAYNE','NOLTE','2006-02-15 04:34:33'),
 (151,'GEOFFREY','HESTON','2006-02-15 04:34:33'),
 (152,'BEN','HARRIS','2006-02-15 04:34:33'),
 (153,'MINNIE','KILMER','2006-02-15 04:34:33'),
 (154,'MERYL','GIBSON','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (155,'IAN','TANDY','2006-02-15 04:34:33'),
 (156,'FAY','WOOD','2006-02-15 04:34:33'),
 (157,'GRETA','MALDEN','2006-02-15 04:34:33'),
 (158,'VIVIEN','BASINGER','2006-02-15 04:34:33'),
 (159,'LAURA','BRODY','2006-02-15 04:34:33'),
 (160,'CHRIS','DEPP','2006-02-15 04:34:33'),
 (161,'HARVEY','HOPE','2006-02-15 04:34:33'),
 (162,'OPRAH','KILMER','2006-02-15 04:34:33'),
 (163,'CHRISTOPHER','WEST','2006-02-15 04:34:33'),
 (164,'HUMPHREY','WILLIS','2006-02-15 04:34:33'),
 (165,'AL','GARLAND','2006-02-15 04:34:33'),
 (166,'NICK','DEGENERES','2006-02-15 04:34:33'),
 (167,'LAURENCE','BULLOCK','2006-02-15 04:34:33'),
 (168,'WILL','WILSON','2006-02-15 04:34:33'),
 (169,'KENNETH','HOFFMAN','2006-02-15 04:34:33'),
 (170,'MENA','HOPPER','2006-02-15 04:34:33'),
 (171,'OLYMPIA','PFEIFFER','2006-02-15 04:34:33'),
 (172,'GROUCHO','WILLIAMS','2006-02-15 04:34:33'),
 (173,'ALAN','DREYFUSS','2006-02-15 04:34:33'),
 (174,'MICHAEL','BENING','2006-02-15 04:34:33'),
 (175,'WILLIAM','HACKMAN','2006-02-15 04:34:33'),
 (176,'JON','CHASE','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (177,'GENE','MCKELLEN','2006-02-15 04:34:33'),
 (178,'LISA','MONROE','2006-02-15 04:34:33'),
 (179,'ED','GUINESS','2006-02-15 04:34:33'),
 (180,'JEFF','SILVERSTONE','2006-02-15 04:34:33'),
 (181,'MATTHEW','CARREY','2006-02-15 04:34:33'),
 (182,'DEBBIE','AKROYD','2006-02-15 04:34:33'),
 (183,'RUSSELL','CLOSE','2006-02-15 04:34:33'),
 (184,'HUMPHREY','GARLAND','2006-02-15 04:34:33'),
 (185,'MICHAEL','BOLGER','2006-02-15 04:34:33'),
 (186,'JULIA','ZELLWEGER','2006-02-15 04:34:33'),
 (187,'RENEE','BALL','2006-02-15 04:34:33'),
 (188,'ROCK','DUKAKIS','2006-02-15 04:34:33'),
 (189,'CUBA','BIRCH','2006-02-15 04:34:33'),
 (190,'AUDREY','BAILEY','2006-02-15 04:34:33'),
 (191,'GREGORY','GOODING','2006-02-15 04:34:33'),
 (192,'JOHN','SUVARI','2006-02-15 04:34:33'),
 (193,'BURT','TEMPLE','2006-02-15 04:34:33'),
 (194,'MERYL','ALLEN','2006-02-15 04:34:33'),
 (195,'JAYNE','SILVERSTONE','2006-02-15 04:34:33'),
 (196,'BELA','WALKEN','2006-02-15 04:34:33'),
 (197,'REESE','WEST','2006-02-15 04:34:33'),
 (198,'MARY','KEITEL','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (199,'JULIA','FAWCETT','2006-02-15 04:34:33'),
 (200,'THORA','TEMPLE','2006-02-15 04:34:33');
COMMIT;

--
-- Definition of table `sakila`.`address`
--

DROP TABLE IF EXISTS `sakila`.`address`;
CREATE TABLE  `sakila`.`address` (
  `address_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `address` varchar(50) NOT NULL,
  `address2` varchar(50) DEFAULT NULL,
  `district` varchar(20) NOT NULL,
  `city_id` smallint(5) unsigned NOT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  `phone` varchar(20) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`address_id`),
  KEY `idx_fk_city_id` (`city_id`),
  CONSTRAINT `fk_address_city` FOREIGN KEY (`city_id`) REFERENCES `city` (`city_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`address`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`address` VALUES  (1,'47 MySakila Drive',NULL,'Alberta',300,'','','2006-02-15 04:45:30'),
 (2,'28 MySQL Boulevard',NULL,'QLD',576,'','','2006-02-15 04:45:30'),
 (3,'23 Workhaven Lane',NULL,'Alberta',300,'','14033335568','2006-02-15 04:45:30'),
 (4,'1411 Lillydale Drive',NULL,'QLD',576,'','6172235589','2006-02-15 04:45:30'),
 (5,'1913 Hanoi Way','','Nagasaki',463,'35200','28303384290','2006-02-15 04:45:30'),
 (6,'1121 Loja Avenue','','California',449,'17886','838635286649','2006-02-15 04:45:30'),
 (7,'692 Joliet Street','','Attika',38,'83579','448477190408','2006-02-15 04:45:30'),
 (8,'1566 Inegl Manor','','Mandalay',349,'53561','705814003527','2006-02-15 04:45:30'),
 (9,'53 Idfu Parkway','','Nantou',361,'42399','10655648674','2006-02-15 04:45:30'),
 (10,'1795 Santiago de Compostela Way','','Texas',295,'18743','860452626434','2006-02-15 04:45:30'),
 (11,'900 Santiago de Compostela Parkway','','Central Serbia',280,'93896','716571220373','2006-02-15 04:45:30'),
 (12,'478 Joliet Way','','Hamilton',200,'77948','657282285970','2006-02-15 04:45:30'),
 (13,'613 Korolev Drive','','Masqat',329,'45844','380657522649','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (14,'1531 Sal Drive','','Esfahan',162,'53628','648856936185','2006-02-15 04:45:30'),
 (15,'1542 Tarlac Parkway','','Kanagawa',440,'1027','635297277345','2006-02-15 04:45:30'),
 (16,'808 Bhopal Manor','','Haryana',582,'10672','465887807014','2006-02-15 04:45:30'),
 (17,'270 Amroha Parkway','','Osmaniye',384,'29610','695479687538','2006-02-15 04:45:30'),
 (18,'770 Bydgoszcz Avenue','','California',120,'16266','517338314235','2006-02-15 04:45:30'),
 (19,'419 Iligan Lane','','Madhya Pradesh',76,'72878','990911107354','2006-02-15 04:45:30'),
 (20,'360 Toulouse Parkway','','England',495,'54308','949312333307','2006-02-15 04:45:30'),
 (21,'270 Toulon Boulevard','','Kalmykia',156,'81766','407752414682','2006-02-15 04:45:30'),
 (22,'320 Brest Avenue','','Kaduna',252,'43331','747791594069','2006-02-15 04:45:30'),
 (23,'1417 Lancaster Avenue','','Northern Cape',267,'72192','272572357893','2006-02-15 04:45:30'),
 (24,'1688 Okara Way','','Nothwest Border Prov',327,'21954','144453869132','2006-02-15 04:45:30'),
 (25,'262 A Corua (La Corua) Parkway','','Dhaka',525,'34418','892775750063','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (26,'28 Charlotte Amalie Street','','Rabat-Sal-Zammour-Z',443,'37551','161968374323','2006-02-15 04:45:30'),
 (27,'1780 Hino Boulevard','','Liepaja',303,'7716','902731229323','2006-02-15 04:45:30'),
 (28,'96 Tafuna Way','','Crdoba',128,'99865','934730187245','2006-02-15 04:45:30'),
 (29,'934 San Felipe de Puerto Plata Street','','Sind',472,'99780','196495945706','2006-02-15 04:45:30'),
 (30,'18 Duisburg Boulevard','','',121,'58327','998009777982','2006-02-15 04:45:30'),
 (31,'217 Botshabelo Place','','Southern Mindanao',138,'49521','665356572025','2006-02-15 04:45:30'),
 (32,'1425 Shikarpur Manor','','Bihar',346,'65599','678220867005','2006-02-15 04:45:30'),
 (33,'786 Aurora Avenue','','Yamaguchi',474,'65750','18461860151','2006-02-15 04:45:30'),
 (34,'1668 Anpolis Street','','Taipei',316,'50199','525255540978','2006-02-15 04:45:30'),
 (35,'33 Gorontalo Way','','West Bengali',257,'30348','745994947458','2006-02-15 04:45:30'),
 (36,'176 Mandaluyong Place','','Uttar Pradesh',239,'65213','627705991774','2006-02-15 04:45:30'),
 (37,'127 Purnea (Purnia) Manor','','Piemonte',17,'79388','911872220378','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (38,'61 Tama Street','','Okayama',284,'94065','708403338270','2006-02-15 04:45:30'),
 (39,'391 Callao Drive','','Midi-Pyrnes',544,'34021','440512153169','2006-02-15 04:45:30'),
 (40,'334 Munger (Monghyr) Lane','','Markazi',31,'38145','481183273622','2006-02-15 04:45:30'),
 (41,'1440 Fukuyama Loop','','Henan',362,'47929','912257250465','2006-02-15 04:45:30'),
 (42,'269 Cam Ranh Parkway','','Chisinau',115,'34689','489783829737','2006-02-15 04:45:30'),
 (43,'306 Antofagasta Place','','Esprito Santo',569,'3989','378318851631','2006-02-15 04:45:30'),
 (44,'671 Graz Street','','Oriental',353,'94399','680768868518','2006-02-15 04:45:30'),
 (45,'42 Brindisi Place','','Yerevan',586,'16744','42384721397','2006-02-15 04:45:30'),
 (46,'1632 Bislig Avenue','','Nonthaburi',394,'61117','471675840679','2006-02-15 04:45:30'),
 (47,'1447 Imus Way','','Tahiti',167,'48942','539758313890','2006-02-15 04:45:30'),
 (48,'1998 Halifax Drive','','Lipetsk',308,'76022','177727722820','2006-02-15 04:45:30'),
 (49,'1718 Valencia Street','','Antofagasta',27,'37359','675292816413','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (50,'46 Pjatigorsk Lane','','Moscow (City)',343,'23616','262076994845','2006-02-15 04:45:30'),
 (51,'686 Garland Manor','','Cear',247,'52535','69493378813','2006-02-15 04:45:30'),
 (52,'909 Garland Manor','','Tatarstan',367,'69367','705800322606','2006-02-15 04:45:30'),
 (53,'725 Isesaki Place','','Mekka',237,'74428','876295323994','2006-02-15 04:45:30'),
 (54,'115 Hidalgo Parkway','','Khartum',379,'80168','307703950263','2006-02-15 04:45:30'),
 (55,'1135 Izumisano Parkway','','California',171,'48150','171822533480','2006-02-15 04:45:30'),
 (56,'939 Probolinggo Loop','','Galicia',1,'4166','680428310138','2006-02-15 04:45:30'),
 (57,'17 Kabul Boulevard','','Chiba',355,'38594','697760867968','2006-02-15 04:45:30'),
 (58,'1964 Allappuzha (Alleppey) Street','','Yamaguchi',227,'48980','920811325222','2006-02-15 04:45:30'),
 (59,'1697 Kowloon and New Kowloon Loop','','Moskova',49,'57807','499352017190','2006-02-15 04:45:30'),
 (60,'1668 Saint Louis Place','','Tahiti',397,'39072','347487831378','2006-02-15 04:45:30'),
 (61,'943 Tokat Street','','Vaduz',560,'45428','889318963672','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (62,'1114 Liepaja Street','','Sarawak',282,'69226','212869228936','2006-02-15 04:45:30'),
 (63,'1213 Ranchi Parkway','','Karnataka',350,'94352','800024380485','2006-02-15 04:45:30'),
 (64,'81 Hodeida Way','','Rajasthan',231,'55561','250767749542','2006-02-15 04:45:30'),
 (65,'915 Ponce Place','','Basel-Stadt',56,'83980','1395251317','2006-02-15 04:45:30'),
 (66,'1717 Guadalajara Lane','','Missouri',441,'85505','914090181665','2006-02-15 04:45:30'),
 (67,'1214 Hanoi Way','','Nebraska',306,'67055','491001136577','2006-02-15 04:45:30'),
 (68,'1966 Amroha Avenue','','Sichuan',139,'70385','333489324603','2006-02-15 04:45:30'),
 (69,'698 Otsu Street','','Cayenne',105,'71110','409983924481','2006-02-15 04:45:30'),
 (70,'1150 Kimchon Manor','','Skne ln',321,'96109','663449333709','2006-02-15 04:45:30'),
 (71,'1586 Guaruj Place','','Hunan',579,'5135','947233365992','2006-02-15 04:45:30'),
 (72,'57 Arlington Manor','','Madhya Pradesh',475,'48960','990214419142','2006-02-15 04:45:30'),
 (73,'1031 Daugavpils Parkway','','Bchar',63,'59025','107137400143','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (74,'1124 Buenaventura Drive','','Mekka',13,'6856','407733804223','2006-02-15 04:45:30'),
 (75,'492 Cam Ranh Street','','Eastern Visayas',61,'50805','565018274456','2006-02-15 04:45:30'),
 (76,'89 Allappuzha (Alleppey) Manor','','National Capital Reg',517,'75444','255800440636','2006-02-15 04:45:30'),
 (77,'1947 Poos de Caldas Boulevard','','Chiayi',114,'60951','427454485876','2006-02-15 04:45:30'),
 (78,'1206 Dos Quebradas Place','','So Paulo',431,'20207','241832790687','2006-02-15 04:45:30'),
 (79,'1551 Rampur Lane','','Changhwa',108,'72394','251164340471','2006-02-15 04:45:30'),
 (80,'602 Paarl Street','','Pavlodar',402,'98889','896314772871','2006-02-15 04:45:30'),
 (81,'1692 Ede Loop','','So Paulo',30,'9223','918711376618','2006-02-15 04:45:30'),
 (82,'936 Salzburg Lane','','Uttar Pradesh',425,'96709','875756771675','2006-02-15 04:45:30'),
 (83,'586 Tete Way','','Kanagawa',256,'1079','18581624103','2006-02-15 04:45:30'),
 (84,'1888 Kabul Drive','','Oyo & Osun',217,'20936','701457319790','2006-02-15 04:45:30'),
 (85,'320 Baiyin Parkway','','Mahajanga',319,'37307','223664661973','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (86,'927 Baha Blanca Parkway','','Krim',479,'9495','821972242086','2006-02-15 04:45:30'),
 (87,'929 Tallahassee Loop','','Gauteng',497,'74671','800716535041','2006-02-15 04:45:30'),
 (88,'125 Citt del Vaticano Boulevard','','Puebla',40,'67912','48417642933','2006-02-15 04:45:30'),
 (89,'1557 Ktahya Boulevard','','England',88,'88002','720998247660','2006-02-15 04:45:30'),
 (90,'870 Ashqelon Loop','','Songkhla',489,'84931','135117278909','2006-02-15 04:45:30'),
 (91,'1740 Portoviejo Avenue','','Sucre',480,'29932','198123170793','2006-02-15 04:45:30'),
 (92,'1942 Ciparay Parkway','','Cheju',113,'82624','978987363654','2006-02-15 04:45:30'),
 (93,'1926 El Alto Avenue','','Buenos Aires',289,'75543','846225459260','2006-02-15 04:45:30'),
 (94,'1952 Chatsworth Drive','','Guangdong',332,'25958','991562402283','2006-02-15 04:45:30'),
 (95,'1370 Le Mans Avenue','','Brunei and Muara',53,'52163','345679835036','2006-02-15 04:45:30'),
 (96,'984 Effon-Alaiye Avenue','','Gois',183,'17119','132986892228','2006-02-15 04:45:30'),
 (97,'832 Nakhon Sawan Manor','','Inner Mongolia',592,'49021','275595571388','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (98,'152 Kitwe Parkway','','Caraga',82,'53182','835433605312','2006-02-15 04:45:30'),
 (99,'1697 Tanauan Lane','','Punjab',399,'22870','4764773857','2006-02-15 04:45:30'),
 (100,'1308 Arecibo Way','','Georgia',41,'30695','6171054059','2006-02-15 04:45:30'),
 (101,'1599 Plock Drive','','Tete',534,'71986','817248913162','2006-02-15 04:45:30'),
 (102,'669 Firozabad Loop','','Abu Dhabi',12,'92265','412903167998','2006-02-15 04:45:30'),
 (103,'588 Vila Velha Manor','','Kyongsangbuk',268,'51540','333339908719','2006-02-15 04:45:30'),
 (104,'1913 Kamakura Place','','Lipetsk',238,'97287','942570536750','2006-02-15 04:45:30'),
 (105,'733 Mandaluyong Place','','Asir',2,'77459','196568435814','2006-02-15 04:45:30'),
 (106,'659 Vaduz Drive','','Ha Darom',34,'49708','709935135487','2006-02-15 04:45:30'),
 (107,'1177 Jelets Way','','Kwara & Kogi',220,'3305','484292626944','2006-02-15 04:45:30'),
 (108,'1386 Yangor Avenue','','Provence-Alpes-Cte',543,'80720','449216226468','2006-02-15 04:45:30'),
 (109,'454 Nakhon Sawan Boulevard','','Funafuti',173,'76383','963887147572','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (110,'1867 San Juan Bautista Tuxtepec Avenue','','Ivanovo',225,'78311','547003310357','2006-02-15 04:45:30'),
 (111,'1532 Dzerzinsk Way','','Buenos Aires',334,'9599','330838016880','2006-02-15 04:45:30'),
 (112,'1002 Ahmadnagar Manor','','Mxico',213,'93026','371490777743','2006-02-15 04:45:30'),
 (113,'682 Junan Way','','North West',273,'30418','622255216127','2006-02-15 04:45:30'),
 (114,'804 Elista Drive','','Hubei',159,'61069','379804592943','2006-02-15 04:45:30'),
 (115,'1378 Alvorada Avenue','','Distrito Federal',102,'75834','272234298332','2006-02-15 04:45:30'),
 (116,'793 Cam Ranh Avenue','','California',292,'87057','824370924746','2006-02-15 04:45:30'),
 (117,'1079 Tel Aviv-Jaffa Boulevard','','Sucre',132,'10885','358178933857','2006-02-15 04:45:30'),
 (118,'442 Rae Bareli Place','','Nordrhein-Westfalen',148,'24321','886636413768','2006-02-15 04:45:30'),
 (119,'1107 Nakhon Sawan Avenue','','Mxico',365,'75149','867546627903','2006-02-15 04:45:30'),
 (120,'544 Malm Parkway','','Central Java',403,'63502','386759646229','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (121,'1967 Sincelejo Place','','Gujarat',176,'73644','577812616052','2006-02-15 04:45:30'),
 (122,'333 Goinia Way','','Texas',185,'78625','909029256431','2006-02-15 04:45:30'),
 (123,'1987 Coacalco de Berriozbal Loop','','al-Qalyubiya',476,'96065','787654415858','2006-02-15 04:45:30'),
 (124,'241 Mosul Lane','','Risaralda',147,'76157','765345144779','2006-02-15 04:45:30'),
 (125,'211 Chiayi Drive','','Uttar Pradesh',164,'58186','665993880048','2006-02-15 04:45:30'),
 (126,'1175 Tanauan Way','','Lima',305,'64615','937222955822','2006-02-15 04:45:30'),
 (127,'117 Boa Vista Way','','Uttar Pradesh',566,'6804','677976133614','2006-02-15 04:45:30'),
 (128,'848 Tafuna Manor','','Ktahya',281,'45142','614935229095','2006-02-15 04:45:30'),
 (129,'569 Baicheng Lane','','Gauteng',85,'60304','490211944645','2006-02-15 04:45:30'),
 (130,'1666 Qomsheh Drive','','So Paulo',410,'66255','582835362905','2006-02-15 04:45:30'),
 (131,'801 Hagonoy Drive','','Smolensk',484,'8439','237426099212','2006-02-15 04:45:30'),
 (132,'1050 Garden Grove Avenue','','Slaskie',236,'4999','973047364353','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (133,'1854 Tieli Street','','Shandong',302,'15819','509492324775','2006-02-15 04:45:30'),
 (134,'758 Junan Lane','','Gois',190,'82639','935448624185','2006-02-15 04:45:30'),
 (135,'1752 So Leopoldo Parkway','','Taka-Karpatia',345,'14014','252265130067','2006-02-15 04:45:30'),
 (136,'898 Belm Manor','','Free State',87,'49757','707169393853','2006-02-15 04:45:30'),
 (137,'261 Saint Louis Way','','Coahuila de Zaragoza',541,'83401','321944036800','2006-02-15 04:45:30'),
 (138,'765 Southampton Drive','','al-Qalyubiya',421,'4285','23712411567','2006-02-15 04:45:30'),
 (139,'943 Johannesburg Avenue','','Maharashtra',417,'5892','90921003005','2006-02-15 04:45:30'),
 (140,'788 Atinsk Street','','Karnataka',211,'81691','146497509724','2006-02-15 04:45:30'),
 (141,'1749 Daxian Place','','Gelderland',29,'11044','963369996279','2006-02-15 04:45:30'),
 (142,'1587 Sullana Lane','','Inner Mongolia',207,'85769','468060467018','2006-02-15 04:45:30'),
 (143,'1029 Dzerzinsk Manor','','Ynlin',542,'57519','33173584456','2006-02-15 04:45:30'),
 (144,'1666 Beni-Mellal Place','','Tennessee',123,'13377','9099941466','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (145,'928 Jaffna Loop','','Hiroshima',172,'93762','581852137991','2006-02-15 04:45:30'),
 (146,'483 Ljubertsy Parkway','','Scotland',149,'60562','581174211853','2006-02-15 04:45:30'),
 (147,'374 Bat Yam Boulevard','','Kilis',266,'97700','923261616249','2006-02-15 04:45:30'),
 (148,'1027 Songkhla Manor','','Minsk',340,'30861','563660187896','2006-02-15 04:45:30'),
 (149,'999 Sanaa Loop','','Gauteng',491,'3439','918032330119','2006-02-15 04:45:30'),
 (150,'879 Newcastle Way','','Michigan',499,'90732','206841104594','2006-02-15 04:45:30'),
 (151,'1337 Lincoln Parkway','','Saitama',555,'99457','597815221267','2006-02-15 04:45:30'),
 (152,'1952 Pune Lane','','Saint-Denis',442,'92150','354615066969','2006-02-15 04:45:30'),
 (153,'782 Mosul Street','','Massachusetts',94,'25545','885899703621','2006-02-15 04:45:30'),
 (154,'781 Shimonoseki Drive','','Michoacn de Ocampo',202,'95444','632316273199','2006-02-15 04:45:30'),
 (155,'1560 Jelets Boulevard','','Shandong',291,'77777','189446090264','2006-02-15 04:45:30'),
 (156,'1963 Moscow Place','','Assam',354,'64863','761379480249','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (157,'456 Escobar Way','','Jakarta Raya',232,'36061','719202533520','2006-02-15 04:45:30'),
 (158,'798 Cianjur Avenue','','Shanxi',590,'76990','499408708580','2006-02-15 04:45:30'),
 (159,'185 Novi Sad Place','','Bern',72,'41778','904253967161','2006-02-15 04:45:30'),
 (160,'1367 Yantai Manor','','Ondo & Ekiti',381,'21294','889538496300','2006-02-15 04:45:30'),
 (161,'1386 Nakhon Sawan Boulevard','','Pyongyang-si',420,'53502','368899174225','2006-02-15 04:45:30'),
 (162,'369 Papeete Way','','North Carolina',187,'66639','170117068815','2006-02-15 04:45:30'),
 (163,'1440 Compton Place','','North Austria',307,'81037','931059836497','2006-02-15 04:45:30'),
 (164,'1623 Baha Blanca Manor','','Moskova',310,'81511','149981248346','2006-02-15 04:45:30'),
 (165,'97 Shimoga Avenue','','Tel Aviv',533,'44660','177167004331','2006-02-15 04:45:30'),
 (166,'1740 Le Mans Loop','','Pays de la Loire',297,'22853','168476538960','2006-02-15 04:45:30'),
 (167,'1287 Xiangfan Boulevard','','Gifu',253,'57844','819416131190','2006-02-15 04:45:30'),
 (168,'842 Salzburg Lane','','Adana',529,'3313','697151428760','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (169,'154 Tallahassee Loop','','Xinxiang',199,'62250','935508855935','2006-02-15 04:45:30'),
 (170,'710 San Felipe del Progreso Avenue','','Lilongwe',304,'76901','843801144113','2006-02-15 04:45:30'),
 (171,'1540 Wroclaw Drive','','Maharashtra',107,'62686','182363341674','2006-02-15 04:45:30'),
 (172,'475 Atinsk Way','','Gansu',240,'59571','201705577290','2006-02-15 04:45:30'),
 (173,'1294 Firozabad Drive','','Jiangxi',407,'70618','161801569569','2006-02-15 04:45:30'),
 (174,'1877 Ezhou Lane','','Rajasthan',550,'63337','264541743403','2006-02-15 04:45:30'),
 (175,'316 Uruapan Street','','Perak',223,'58194','275788967899','2006-02-15 04:45:30'),
 (176,'29 Pyongyang Loop','','Batman',58,'47753','734780743462','2006-02-15 04:45:30'),
 (177,'1010 Klerksdorp Way','','Steiermark',186,'6802','493008546874','2006-02-15 04:45:30'),
 (178,'1848 Salala Boulevard','','Miranda',373,'25220','48265851133','2006-02-15 04:45:30'),
 (179,'431 Xiangtan Avenue','','Kerala',18,'4854','230250973122','2006-02-15 04:45:30'),
 (180,'757 Rustenburg Avenue','','Skikda',483,'89668','506134035434','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (181,'146 Johannesburg Way','','Tamaulipas',330,'54132','953689007081','2006-02-15 04:45:30'),
 (182,'1891 Rizhao Boulevard','','So Paulo',456,'47288','391065549876','2006-02-15 04:45:30'),
 (183,'1089 Iwatsuki Avenue','','Kirov',270,'35109','866092335135','2006-02-15 04:45:30'),
 (184,'1410 Benin City Parkway','','Risaralda',405,'29747','104150372603','2006-02-15 04:45:30'),
 (185,'682 Garden Grove Place','','Tennessee',333,'67497','72136330362','2006-02-15 04:45:30'),
 (186,'533 al-Ayn Boulevard','','California',126,'8862','662227486184','2006-02-15 04:45:30'),
 (187,'1839 Szkesfehrvr Parkway','','Gois',317,'55709','947468818183','2006-02-15 04:45:30'),
 (188,'741 Ambattur Manor','','Noord-Brabant',438,'43310','302590383819','2006-02-15 04:45:30'),
 (189,'927 Barcelona Street','','Chaharmahal va Bakht',467,'65121','951486492670','2006-02-15 04:45:30'),
 (190,'435 0 Way','','West Bengali',195,'74750','760171523969','2006-02-15 04:45:30'),
 (191,'140 Chiayi Parkway','','Sumy',506,'38982','855863906434','2006-02-15 04:45:30'),
 (192,'1166 Changhwa Street','','Caraga',62,'58852','650752094490','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (193,'891 Novi Sad Manor','','Ontario',383,'5379','247646995453','2006-02-15 04:45:30'),
 (194,'605 Rio Claro Parkway','','Tabora',513,'49348','352469351088','2006-02-15 04:45:30'),
 (195,'1077 San Felipe de Puerto Plata Place','','Rostov-na-Donu',369,'65387','812824036424','2006-02-15 04:45:30'),
 (196,'9 San Miguel de Tucumn Manor','','Uttar Pradesh',169,'90845','956188728558','2006-02-15 04:45:30'),
 (197,'447 Surakarta Loop','','Nyanza',271,'10428','940830176580','2006-02-15 04:45:30'),
 (198,'345 Oshawa Boulevard','','Tokyo-to',204,'32114','104491201771','2006-02-15 04:45:30'),
 (199,'1792 Valle de la Pascua Place','','Nordrhein-Westfalen',477,'15540','419419591240','2006-02-15 04:45:30'),
 (200,'1074 Binzhou Manor','','Baden-Wrttemberg',325,'36490','331132568928','2006-02-15 04:45:30'),
 (201,'817 Bradford Loop','','Jiangsu',109,'89459','264286442804','2006-02-15 04:45:30'),
 (202,'955 Bamenda Way','','Ondo & Ekiti',218,'1545','768481779568','2006-02-15 04:45:30'),
 (203,'1149 A Corua (La Corua) Boulevard','','Haiphong',194,'95824','470884141195','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (204,'387 Mwene-Ditu Drive','','Ahal',35,'8073','764477681869','2006-02-15 04:45:30'),
 (205,'68 Molodetno Manor','','Nordrhein-Westfalen',575,'4662','146640639760','2006-02-15 04:45:30'),
 (206,'642 Nador Drive','','Maharashtra',77,'3924','369050085652','2006-02-15 04:45:30'),
 (207,'1688 Nador Lane','','Sulawesi Utara',184,'61613','652218196731','2006-02-15 04:45:30'),
 (208,'1215 Pyongyang Parkway','','Usak',557,'25238','646237101779','2006-02-15 04:45:30'),
 (209,'1679 Antofagasta Street','','Alto Paran',122,'86599','905903574913','2006-02-15 04:45:30'),
 (210,'1304 s-Hertogenbosch Way','','Santa Catarina',83,'10925','90336226227','2006-02-15 04:45:30'),
 (211,'850 Salala Loop','','Kitaa',371,'10800','403404780639','2006-02-15 04:45:30'),
 (212,'624 Oshawa Boulevard','','West Bengali',51,'89959','49677664184','2006-02-15 04:45:30'),
 (213,'43 Dadu Avenue','','Rajasthan',74,'4855','95666951770','2006-02-15 04:45:30'),
 (214,'751 Lima Loop','','Aden',7,'99405','756460337785','2006-02-15 04:45:30'),
 (215,'1333 Haldia Street','','Jilin',174,'82161','408304391718','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (216,'660 Jedda Boulevard','','Washington',65,'25053','168758068397','2006-02-15 04:45:30'),
 (217,'1001 Miyakonojo Lane','','Taizz',518,'67924','584316724815','2006-02-15 04:45:30'),
 (218,'226 Brest Manor','','California',508,'2299','785881412500','2006-02-15 04:45:30'),
 (219,'1229 Valencia Parkway','','Haskovo',498,'99124','352679173732','2006-02-15 04:45:30'),
 (220,'1201 Qomsheh Manor','','Gois',28,'21464','873492228462','2006-02-15 04:45:30'),
 (221,'866 Shivapuri Manor','','Uttar Pradesh',448,'22474','778502731092','2006-02-15 04:45:30'),
 (222,'1168 Najafabad Parkway','','Kabol',251,'40301','886649065861','2006-02-15 04:45:30'),
 (223,'1244 Allappuzha (Alleppey) Place','','Buenos Aires',567,'20657','991802825778','2006-02-15 04:45:30'),
 (224,'1842 Luzinia Boulevard','','Zanzibar West',593,'94420','706878974831','2006-02-15 04:45:30'),
 (225,'1926 Gingoog Street','','Sisilia',511,'22824','469738825391','2006-02-15 04:45:30'),
 (226,'810 Palghat (Palakkad) Boulevard','','Jaroslavl',235,'73431','516331171356','2006-02-15 04:45:30'),
 (227,'1820 Maring Parkway','','Punjab',324,'88307','99760893676','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (228,'60 Poos de Caldas Street','','Rajasthan',243,'82338','963063788669','2006-02-15 04:45:30'),
 (229,'1014 Loja Manor','','Tamil Nadu',22,'66851','460795526514','2006-02-15 04:45:30'),
 (230,'201 Effon-Alaiye Way','','Asuncin',37,'64344','684192903087','2006-02-15 04:45:30'),
 (231,'430 Alessandria Loop','','Saarland',439,'47446','669828224459','2006-02-15 04:45:30'),
 (232,'754 Valencia Place','','Phnom Penh',406,'87911','594319417514','2006-02-15 04:45:30'),
 (233,'356 Olomouc Manor','','Gois',26,'93323','22326410776','2006-02-15 04:45:30'),
 (234,'1256 Bislig Boulevard','','Botosani',86,'50598','479007229460','2006-02-15 04:45:30'),
 (235,'954 Kimchon Place','','West Bengali',559,'42420','541327526474','2006-02-15 04:45:30'),
 (236,'885 Yingkou Manor','','Kaduna',596,'31390','588964509072','2006-02-15 04:45:30'),
 (237,'1736 Cavite Place','','Qina',216,'98775','431770603551','2006-02-15 04:45:30'),
 (238,'346 Skikda Parkway','','Hawalli',233,'90628','630424482919','2006-02-15 04:45:30'),
 (239,'98 Stara Zagora Boulevard','','Valle',96,'76448','610173756082','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (240,'1479 Rustenburg Boulevard','','Southern Tagalog',527,'18727','727785483194','2006-02-15 04:45:30'),
 (241,'647 A Corua (La Corua) Street','','Chollanam',357,'36971','792557457753','2006-02-15 04:45:30'),
 (242,'1964 Gijn Manor','','Karnataka',473,'14408','918119601885','2006-02-15 04:45:30'),
 (243,'47 Syktyvkar Lane','','West Java',118,'22236','63937119031','2006-02-15 04:45:30'),
 (244,'1148 Saarbrcken Parkway','','Fukushima',226,'1921','137773001988','2006-02-15 04:45:30'),
 (245,'1103 Bilbays Parkway','','Hubei',578,'87660','279979529227','2006-02-15 04:45:30'),
 (246,'1246 Boksburg Parkway','','Hebei',422,'28349','890283544295','2006-02-15 04:45:30'),
 (247,'1483 Pathankot Street','','Tucumn',454,'37288','686015532180','2006-02-15 04:45:30'),
 (248,'582 Papeete Loop','','Central Visayas',294,'27722','569868543137','2006-02-15 04:45:30'),
 (249,'300 Junan Street','','Kyonggi',553,'81314','890289150158','2006-02-15 04:45:30'),
 (250,'829 Grand Prairie Way','','Paran',328,'6461','741070712873','2006-02-15 04:45:30'),
 (251,'1473 Changhwa Parkway','','Mxico',124,'75933','266798132374','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (252,'1309 Weifang Street','','Florida',520,'57338','435785045362','2006-02-15 04:45:30'),
 (253,'1760 Oshawa Manor','','Tianjin',535,'38140','56257502250','2006-02-15 04:45:30'),
 (254,'786 Stara Zagora Way','','Oyo & Osun',390,'98332','716256596301','2006-02-15 04:45:30'),
 (255,'1966 Tonghae Street','','Anhalt Sachsen',198,'36481','567359279425','2006-02-15 04:45:30'),
 (256,'1497 Yuzhou Drive','','England',312,'3433','246810237916','2006-02-15 04:45:30'),
 (258,'752 Ondo Loop','','Miyazaki',338,'32474','134673576619','2006-02-15 04:45:30'),
 (259,'1338 Zalantun Lane','','Minas Gerais',413,'45403','840522972766','2006-02-15 04:45:30'),
 (260,'127 Iwakuni Boulevard','','Central Luzon',192,'20777','987442542471','2006-02-15 04:45:30'),
 (261,'51 Laredo Avenue','','Sagaing',342,'68146','884536620568','2006-02-15 04:45:30'),
 (262,'771 Yaound Manor','','Sofala',64,'86768','245477603573','2006-02-15 04:45:30'),
 (263,'532 Toulon Street','','Santiago',460,'69517','46871694740','2006-02-15 04:45:30'),
 (264,'1027 Banjul Place','','West Bengali',197,'50390','538241037443','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (265,'1158 Mandi Bahauddin Parkway','','Shanxi',136,'98484','276555730211','2006-02-15 04:45:30'),
 (266,'862 Xintai Lane','','Cagayan Valley',548,'30065','265153400632','2006-02-15 04:45:30'),
 (267,'816 Cayenne Parkway','','Manab',414,'93629','282874611748','2006-02-15 04:45:30'),
 (268,'1831 Nam Dinh Loop','','National Capital Reg',323,'51990','322888976727','2006-02-15 04:45:30'),
 (269,'446 Kirovo-Tepetsk Lane','','Osaka',203,'19428','303967439816','2006-02-15 04:45:30'),
 (270,'682 Halisahar Place','','Severn Morava',378,'20536','475553436330','2006-02-15 04:45:30'),
 (271,'1587 Loja Manor','','Salzburg',447,'5410','621625204422','2006-02-15 04:45:30'),
 (272,'1762 Paarl Parkway','','Hunan',298,'53928','192459639410','2006-02-15 04:45:30'),
 (273,'1519 Ilorin Place','','Kerala',395,'49298','357445645426','2006-02-15 04:45:30'),
 (274,'920 Kumbakonam Loop','','California',446,'75090','685010736240','2006-02-15 04:45:30'),
 (275,'906 Goinia Way','','Wielkopolskie',255,'83565','701767622697','2006-02-15 04:45:30'),
 (276,'1675 Xiangfan Manor','','Tamil Nadu',283,'11763','271149517630','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (277,'85 San Felipe de Puerto Plata Drive','','Shandong',584,'46063','170739645687','2006-02-15 04:45:30'),
 (278,'144 South Hill Loop','','Guanajuato',445,'2012','45387294817','2006-02-15 04:45:30'),
 (279,'1884 Shikarpur Avenue','','Haryana',263,'85548','959949395183','2006-02-15 04:45:30'),
 (280,'1980 Kamjanets-Podilskyi Street','','Illinois',404,'89502','874337098891','2006-02-15 04:45:30'),
 (281,'1944 Bamenda Way','','Michigan',573,'24645','75975221996','2006-02-15 04:45:30'),
 (282,'556 Baybay Manor','','Oyo & Osun',374,'55802','363982224739','2006-02-15 04:45:30'),
 (283,'457 Tongliao Loop','','Bursa',222,'56254','880756161823','2006-02-15 04:45:30'),
 (284,'600 Bradford Street','','East Azerbaidzan',514,'96204','117592274996','2006-02-15 04:45:30'),
 (285,'1006 Santa Brbara dOeste Manor','','Ondo & Ekiti',389,'36229','85059738746','2006-02-15 04:45:30'),
 (286,'1308 Sumy Loop','','Fujian',175,'30657','583021225407','2006-02-15 04:45:30'),
 (287,'1405 Chisinau Place','','Ponce',411,'8160','62781725285','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (288,'226 Halifax Street','','Xinxiang',277,'58492','790651020929','2006-02-15 04:45:30'),
 (289,'1279 Udine Parkway','','Edo & Delta',69,'75860','195003555232','2006-02-15 04:45:30'),
 (290,'1336 Benin City Drive','','Shiga',386,'46044','341242939532','2006-02-15 04:45:30'),
 (291,'1155 Liaocheng Place','','Oyo & Osun',152,'22650','558236142492','2006-02-15 04:45:30'),
 (292,'1993 Tabuk Lane','','Tamil Nadu',522,'64221','648482415405','2006-02-15 04:45:30'),
 (293,'86 Higashiosaka Lane','','Guanajuato',563,'33768','957128697225','2006-02-15 04:45:30'),
 (294,'1912 Allende Manor','','Kowloon and New Kowl',279,'58124','172262454487','2006-02-15 04:45:30'),
 (295,'544 Tarsus Boulevard','','Gurico',562,'53145','892523334','2006-02-15 04:45:30'),
 (296,'1936 Cuman Avenue','','Virginia',433,'61195','976798660411','2006-02-15 04:45:30'),
 (297,'1192 Tongliao Street','','Sharja',470,'19065','350970907017','2006-02-15 04:45:30'),
 (298,'44 Najafabad Way','','Baskimaa',146,'61391','96604821070','2006-02-15 04:45:30'),
 (299,'32 Pudukkottai Lane','','Ohio',140,'38834','967274728547','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (300,'661 Chisinau Lane','','Pietari',274,'8856','816436065431','2006-02-15 04:45:30'),
 (301,'951 Stara Zagora Manor','','Punjab',400,'98573','429925609431','2006-02-15 04:45:30'),
 (302,'922 Vila Velha Loop','','Maharashtra',9,'4085','510737228015','2006-02-15 04:45:30'),
 (303,'898 Jining Lane','','Pohjois-Pohjanmaa',387,'40070','161643343536','2006-02-15 04:45:30'),
 (304,'1635 Kuwana Boulevard','','Hiroshima',205,'52137','710603868323','2006-02-15 04:45:30'),
 (305,'41 El Alto Parkway','','Maharashtra',398,'56883','51917807050','2006-02-15 04:45:30'),
 (306,'1883 Maikop Lane','','Kaliningrad',254,'68469','96110042435','2006-02-15 04:45:30'),
 (307,'1908 Gaziantep Place','','Liaoning',536,'58979','108053751300','2006-02-15 04:45:30'),
 (308,'687 Alessandria Parkway','','Sanaa',455,'57587','407218522294','2006-02-15 04:45:30'),
 (309,'827 Yuncheng Drive','','Callao',99,'79047','504434452842','2006-02-15 04:45:30'),
 (310,'913 Coacalco de Berriozbal Loop','','Texas',33,'42141','262088367001','2006-02-15 04:45:30'),
 (311,'715 So Bernardo do Campo Lane','','Kedah',507,'84804','181179321332','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (312,'1354 Siegen Street','','Rio de Janeiro',25,'80184','573441801529','2006-02-15 04:45:30'),
 (313,'1191 Sungai Petani Boulevard','','Missouri',262,'9668','983259819766','2006-02-15 04:45:30'),
 (314,'1224 Huejutla de Reyes Boulevard','','Lombardia',91,'70923','806016930576','2006-02-15 04:45:30'),
 (315,'543 Bergamo Avenue','','Minas Gerais',215,'59686','103602195112','2006-02-15 04:45:30'),
 (316,'746 Joliet Lane','','Kursk',286,'94878','688485191923','2006-02-15 04:45:30'),
 (317,'780 Kimberley Way','','Tabuk',515,'17032','824396883951','2006-02-15 04:45:30'),
 (318,'1774 Yaound Place','','Hubei',166,'91400','613124286867','2006-02-15 04:45:30'),
 (319,'1957 Yantai Lane','','So Paulo',490,'59255','704948322302','2006-02-15 04:45:30'),
 (320,'1542 Lubumbashi Boulevard','','Tel Aviv',57,'62472','508800331065','2006-02-15 04:45:30'),
 (321,'651 Pathankot Loop','','Maharashtra',336,'59811','139378397418','2006-02-15 04:45:30'),
 (322,'1359 Zhoushan Parkway','','Streymoyar',545,'29763','46568045367','2006-02-15 04:45:30'),
 (323,'1769 Iwaki Lane','','Kujawsko-Pomorskie',97,'25787','556100547674','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (324,'1145 Vilnius Manor','','Mxico',451,'73170','674805712553','2006-02-15 04:45:30'),
 (325,'1892 Nabereznyje Telny Lane','','Tutuila',516,'28396','478229987054','2006-02-15 04:45:30'),
 (326,'470 Boksburg Street','','Central',81,'97960','908029859266','2006-02-15 04:45:30'),
 (327,'1427 A Corua (La Corua) Place','','Buenos Aires',45,'85799','972574862516','2006-02-15 04:45:30'),
 (328,'479 San Felipe del Progreso Avenue','','Morelos',130,'54949','869051782691','2006-02-15 04:45:30'),
 (329,'867 Benin City Avenue','','Henan',591,'78543','168884817145','2006-02-15 04:45:30'),
 (330,'981 Kumbakonam Place','','Distrito Federal',89,'87611','829116184079','2006-02-15 04:45:30'),
 (331,'1016 Iwakuni Street','','St George',269,'49833','961370847344','2006-02-15 04:45:30'),
 (332,'663 Baha Blanca Parkway','','Adana',5,'33463','834418779292','2006-02-15 04:45:30'),
 (333,'1860 Taguig Loop','','West Java',119,'59550','38158430589','2006-02-15 04:45:30'),
 (334,'1816 Bydgoszcz Loop','','Dhaka',234,'64308','965273813662','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (335,'587 Benguela Manor','','Illinois',42,'91590','165450987037','2006-02-15 04:45:30'),
 (336,'430 Kumbakonam Drive','','Santa F',457,'28814','105470691550','2006-02-15 04:45:30'),
 (337,'1838 Tabriz Lane','','Dhaka',143,'1195','38988715447','2006-02-15 04:45:30'),
 (338,'431 Szkesfehrvr Avenue','','Baki',48,'57828','119501405123','2006-02-15 04:45:30'),
 (339,'503 Sogamoso Loop','','Sumqayit',505,'49812','834626715837','2006-02-15 04:45:30'),
 (340,'507 Smolensk Loop','','Sousse',492,'22971','80303246192','2006-02-15 04:45:30'),
 (341,'1920 Weifang Avenue','','Uttar Pradesh',427,'15643','869507847714','2006-02-15 04:45:30'),
 (342,'124 al-Manama Way','','Hiroshima',382,'52368','647899404952','2006-02-15 04:45:30'),
 (343,'1443 Mardan Street','','Western Cape',392,'31483','231383037471','2006-02-15 04:45:30'),
 (344,'1909 Benguela Lane','','Henan',581,'19913','624138001031','2006-02-15 04:45:30'),
 (345,'68 Ponce Parkway','','Hanoi',201,'85926','870635127812','2006-02-15 04:45:30'),
 (346,'1217 Konotop Avenue','','Gelderland',151,'504','718917251754','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (347,'1293 Nam Dinh Way','','Roraima',84,'71583','697656479977','2006-02-15 04:45:30'),
 (348,'785 Vaduz Street','','Baja California',335,'36170','895616862749','2006-02-15 04:45:30'),
 (349,'1516 Escobar Drive','','Tongatapu',370,'46069','64536069371','2006-02-15 04:45:30'),
 (350,'1628 Nagareyama Lane','','Central',453,'60079','20064292617','2006-02-15 04:45:30'),
 (351,'1157 Nyeri Loop','','Adygea',320,'56380','262744791493','2006-02-15 04:45:30'),
 (352,'1673 Tangail Drive','','Daugavpils',137,'26857','627924259271','2006-02-15 04:45:30'),
 (353,'381 Kabul Way','','Taipei',209,'87272','55477302294','2006-02-15 04:45:30'),
 (354,'953 Hodeida Street','','Southern Tagalog',221,'18841','53912826864','2006-02-15 04:45:30'),
 (355,'469 Nakhon Sawan Street','','Tuvassia',531,'58866','689199636560','2006-02-15 04:45:30'),
 (356,'1378 Beira Loop','','Krasnojarsk',597,'40792','840957664136','2006-02-15 04:45:30'),
 (357,'1641 Changhwa Place','','Nord-Ouest',52,'37636','256546485220','2006-02-15 04:45:30'),
 (358,'1698 Southport Loop','','Hidalgo',393,'49009','754358349853','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (359,'519 Nyeri Manor','','So Paulo',461,'37650','764680915323','2006-02-15 04:45:30'),
 (360,'619 Hunuco Avenue','','Shimane',331,'81508','142596392389','2006-02-15 04:45:30'),
 (361,'45 Aparecida de Goinia Place','','Madhya Pradesh',464,'7431','650496654258','2006-02-15 04:45:30'),
 (362,'482 Kowloon and New Kowloon Manor','','Bratislava',90,'97056','738968474939','2006-02-15 04:45:30'),
 (363,'604 Bern Place','','Jharkhand',429,'5373','620719383725','2006-02-15 04:45:30'),
 (364,'1623 Kingstown Drive','','Buenos Aires',20,'91299','296394569728','2006-02-15 04:45:30'),
 (365,'1009 Zanzibar Lane','','Arecibo',32,'64875','102396298916','2006-02-15 04:45:30'),
 (366,'114 Jalib al-Shuyukh Manor','','Centre',585,'60440','845378657301','2006-02-15 04:45:30'),
 (367,'1163 London Parkway','','Par',66,'6066','675120358494','2006-02-15 04:45:30'),
 (368,'1658 Jastrzebie-Zdrj Loop','','Central',372,'96584','568367775448','2006-02-15 04:45:30'),
 (369,'817 Laredo Avenue','','Jalisco',188,'77449','151249681135','2006-02-15 04:45:30'),
 (370,'1565 Tangail Manor','','Okinawa',377,'45750','634445428822','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (371,'1912 Emeishan Drive','','Balikesir',50,'33050','99883471275','2006-02-15 04:45:30'),
 (372,'230 Urawa Drive','','Andhra Pradesh',8,'2738','166898395731','2006-02-15 04:45:30'),
 (373,'1922 Miraj Way','','Esfahan',356,'13203','320471479776','2006-02-15 04:45:30'),
 (374,'433 Florencia Street','','Chihuahua',250,'91330','561729882725','2006-02-15 04:45:30'),
 (375,'1049 Matamoros Parkway','','Karnataka',191,'69640','960505250340','2006-02-15 04:45:30'),
 (376,'1061 Ede Avenue','','Southern Tagalog',98,'57810','333390595558','2006-02-15 04:45:30'),
 (377,'154 Oshawa Manor','','East Java',415,'72771','440365973660','2006-02-15 04:45:30'),
 (378,'1191 Tandil Drive','','Southern Tagalog',523,'6362','45554316010','2006-02-15 04:45:30'),
 (379,'1133 Rizhao Avenue','','Pernambuco',572,'2800','600264533987','2006-02-15 04:45:30'),
 (380,'1519 Santiago de los Caballeros Loop','','East Kasai',348,'22025','409315295763','2006-02-15 04:45:30'),
 (381,'1618 Olomouc Manor','','Kurgan',285,'26385','96846695220','2006-02-15 04:45:30'),
 (382,'220 Hidalgo Drive','','Kermanshah',265,'45298','342720754566','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (383,'686 Donostia-San Sebastin Lane','','Guangdong',471,'97390','71857599858','2006-02-15 04:45:30'),
 (384,'97 Mogiljov Lane','','Gujarat',73,'89294','924815207181','2006-02-15 04:45:30'),
 (385,'1642 Charlotte Amalie Drive','','Slaskie',549,'75442','821476736117','2006-02-15 04:45:30'),
 (386,'1368 Maracabo Boulevard','','',493,'32716','934352415130','2006-02-15 04:45:30'),
 (387,'401 Sucre Boulevard','','New Hampshire',322,'25007','486395999608','2006-02-15 04:45:30'),
 (388,'368 Hunuco Boulevard','','Namibe',360,'17165','106439158941','2006-02-15 04:45:30'),
 (389,'500 Lincoln Parkway','','Jiangsu',210,'95509','550306965159','2006-02-15 04:45:30'),
 (390,'102 Chapra Drive','','Ibaragi',521,'14073','776031833752','2006-02-15 04:45:30'),
 (391,'1793 Meixian Place','','Hmelnytskyi',258,'33535','619966287415','2006-02-15 04:45:30'),
 (392,'514 Ife Way','','Shaba',315,'69973','900235712074','2006-02-15 04:45:30'),
 (393,'717 Changzhou Lane','','Southern Tagalog',104,'21615','426255288071','2006-02-15 04:45:30'),
 (394,'753 Ilorin Avenue','','Sichuan',157,'3656','464511145118','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (395,'1337 Mit Ghamr Avenue','','Nakhon Sawan',358,'29810','175283210378','2006-02-15 04:45:30'),
 (396,'767 Pyongyang Drive','','Osaka',229,'83536','667736124769','2006-02-15 04:45:30'),
 (397,'614 Pak Kret Street','','Addis Abeba',6,'27796','47808359842','2006-02-15 04:45:30'),
 (398,'954 Lapu-Lapu Way','','Moskova',278,'8816','737229003916','2006-02-15 04:45:30'),
 (399,'331 Bydgoszcz Parkway','','Asturia',181,'966','537374465982','2006-02-15 04:45:30'),
 (400,'1152 Citrus Heights Manor','','al-Qadarif',15,'5239','765957414528','2006-02-15 04:45:30'),
 (401,'168 Cianjur Manor','','Saitama',228,'73824','679095087143','2006-02-15 04:45:30'),
 (402,'616 Hagonoy Avenue','','Krasnojarsk',39,'46043','604177838256','2006-02-15 04:45:30'),
 (403,'1190 0 Place','','Rio Grande do Sul',44,'10417','841876514789','2006-02-15 04:45:30'),
 (404,'734 Bchar Place','','Punjab',375,'30586','280578750435','2006-02-15 04:45:30'),
 (405,'530 Lausanne Lane','','Texas',135,'11067','775235029633','2006-02-15 04:45:30'),
 (406,'454 Patiala Lane','','Fukushima',276,'13496','794553031307','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (407,'1346 Mysore Drive','','Bretagne',92,'61507','516647474029','2006-02-15 04:45:30'),
 (408,'990 Etawah Loop','','Tamil Nadu',564,'79940','206169448769','2006-02-15 04:45:30'),
 (409,'1266 Laredo Parkway','','Saitama',380,'7664','1483365694','2006-02-15 04:45:30'),
 (410,'88 Nagaon Manor','','Buenos Aires',524,'86868','779461480495','2006-02-15 04:45:30'),
 (411,'264 Bhimavaram Manor','','St Thomas',111,'54749','302526949177','2006-02-15 04:45:30'),
 (412,'1639 Saarbrcken Drive','','North West',437,'9827','328494873422','2006-02-15 04:45:30'),
 (413,'692 Amroha Drive','','Northern',230,'35575','359478883004','2006-02-15 04:45:30'),
 (414,'1936 Lapu-Lapu Parkway','','Bauchi & Gombe',141,'7122','653436985797','2006-02-15 04:45:30'),
 (415,'432 Garden Grove Street','','Ontario',430,'65630','615964523510','2006-02-15 04:45:30'),
 (416,'1445 Carmen Parkway','','West Java',117,'70809','598912394463','2006-02-15 04:45:30'),
 (417,'791 Salinas Street','','Punjab',208,'40509','129953030512','2006-02-15 04:45:30'),
 (418,'126 Acua Parkway','','West Bengali',71,'58888','480039662421','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (419,'397 Sunnyvale Avenue','','Guanajuato',19,'55566','680851640676','2006-02-15 04:45:30'),
 (420,'992 Klerksdorp Loop','','Utrecht',23,'33711','855290087237','2006-02-15 04:45:30'),
 (421,'966 Arecibo Loop','','Sind',134,'94018','15273765306','2006-02-15 04:45:30'),
 (422,'289 Santo Andr Manor','','al-Sharqiya',16,'72410','214976066017','2006-02-15 04:45:30'),
 (423,'437 Chungho Drive','','Puerto Plata',450,'59489','491271355190','2006-02-15 04:45:30'),
 (424,'1948 Bayugan Parkway','','Bihar',264,'60622','987306329957','2006-02-15 04:45:30'),
 (425,'1866 al-Qatif Avenue','','California',155,'89420','546793516940','2006-02-15 04:45:30'),
 (426,'1661 Abha Drive','','Tamil Nadu',416,'14400','270456873752','2006-02-15 04:45:30'),
 (427,'1557 Cape Coral Parkway','','Hubei',293,'46875','368284120423','2006-02-15 04:45:30'),
 (428,'1727 Matamoros Place','','Sawhaj',465,'78813','129673677866','2006-02-15 04:45:30'),
 (429,'1269 Botosani Manor','','Guangdong',468,'47394','736517327853','2006-02-15 04:45:30'),
 (430,'355 Vitria de Santo Anto Way','','Oaxaca',452,'81758','548003849552','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (431,'1596 Acua Parkway','','Jharkhand',418,'70425','157133457169','2006-02-15 04:45:30'),
 (432,'259 Ipoh Drive','','So Paulo',189,'64964','419009857119','2006-02-15 04:45:30'),
 (433,'1823 Hoshiarpur Lane','','Komi',510,'33191','307133768620','2006-02-15 04:45:30'),
 (434,'1404 Taguig Drive','','Okayama',547,'87212','572068624538','2006-02-15 04:45:30'),
 (435,'740 Udaipur Lane','','Nizni Novgorod',150,'33505','497288595103','2006-02-15 04:45:30'),
 (436,'287 Cuautla Boulevard','','Chuquisaca',501,'72736','82619513349','2006-02-15 04:45:30'),
 (437,'1766 Almirante Brown Street','','KwaZulu-Natal',364,'63104','617567598243','2006-02-15 04:45:30'),
 (438,'596 Huixquilucan Place','','Nampula',351,'65892','342709348083','2006-02-15 04:45:30'),
 (439,'1351 Aparecida de Goinia Parkway','','Northern Mindanao',391,'41775','959834530529','2006-02-15 04:45:30'),
 (440,'722 Bradford Lane','','Shandong',249,'90920','746251338300','2006-02-15 04:45:30'),
 (441,'983 Santa F Way','','British Colombia',565,'47472','145720452260','2006-02-15 04:45:30'),
 (442,'1245 Ibirit Way','','La Romana',290,'40926','331888642162','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (443,'1836 Korla Parkway','','Copperbelt',272,'55405','689681677428','2006-02-15 04:45:30'),
 (444,'231 Kaliningrad Place','','Lombardia',70,'57833','575081026569','2006-02-15 04:45:30'),
 (445,'495 Bhimavaram Lane','','Maharashtra',144,'3','82088937724','2006-02-15 04:45:30'),
 (446,'1924 Shimonoseki Drive','','Batna',59,'52625','406784385440','2006-02-15 04:45:30'),
 (447,'105 Dzerzinsk Manor','','Inner Mongolia',540,'48570','240776414296','2006-02-15 04:45:30'),
 (448,'614 Denizli Parkway','','Rio Grande do Sul',486,'29444','876491807547','2006-02-15 04:45:30'),
 (449,'1289 Belm Boulevard','','Tartumaa',530,'88306','237368926031','2006-02-15 04:45:30'),
 (450,'203 Tambaram Street','','Buenos Aires',161,'73942','411549550611','2006-02-15 04:45:30'),
 (451,'1704 Tambaram Manor','','West Bengali',554,'2834','39463554936','2006-02-15 04:45:30'),
 (452,'207 Cuernavaca Loop','','Tatarstan',352,'52671','782900030287','2006-02-15 04:45:30'),
 (453,'319 Springs Loop','','Baijeri',160,'99552','72524459905','2006-02-15 04:45:30'),
 (454,'956 Nam Dinh Manor','','Kerman',481,'21872','474047727727','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (455,'1947 Paarl Way','','Central Java',509,'23636','834061016202','2006-02-15 04:45:30'),
 (456,'814 Simferopol Loop','','Sinaloa',154,'48745','524567129902','2006-02-15 04:45:30'),
 (457,'535 Ahmadnagar Manor','','Abu Dhabi',3,'41136','985109775584','2006-02-15 04:45:30'),
 (458,'138 Caracas Boulevard','','Zulia',326,'16790','974433019532','2006-02-15 04:45:30'),
 (459,'251 Florencia Drive','','Michoacn de Ocampo',556,'16119','118011831565','2006-02-15 04:45:30'),
 (460,'659 Gatineau Boulevard','','La Paz',153,'28587','205524798287','2006-02-15 04:45:30'),
 (461,'1889 Valparai Way','','Ziguinchor',600,'75559','670370974122','2006-02-15 04:45:30'),
 (462,'1485 Bratislava Place','','Illinois',435,'83183','924663855568','2006-02-15 04:45:30'),
 (463,'935 Aden Boulevard','','Central Java',532,'64709','335052544020','2006-02-15 04:45:30'),
 (464,'76 Kermanshah Manor','','Esfahan',423,'23343','762361821578','2006-02-15 04:45:30'),
 (465,'734 Tanshui Avenue','','Caquet',170,'70664','366776723320','2006-02-15 04:45:30'),
 (466,'118 Jaffna Loop','','Northern Mindanao',182,'10447','325526730021','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (467,'1621 Tongliao Avenue','','Irkutsk',558,'22173','209342540247','2006-02-15 04:45:30'),
 (468,'1844 Usak Avenue','','Nova Scotia',196,'84461','164414772677','2006-02-15 04:45:30'),
 (469,'1872 Toulon Loop','','OHiggins',428,'7939','928809465153','2006-02-15 04:45:30'),
 (470,'1088 Ibirit Place','','Jalisco',595,'88502','49084281333','2006-02-15 04:45:30'),
 (471,'1322 Mosul Parkway','','Shandong',145,'95400','268053970382','2006-02-15 04:45:30'),
 (472,'1447 Chatsworth Place','','Chihuahua',129,'41545','769370126331','2006-02-15 04:45:30'),
 (473,'1257 Guadalajara Street','','Karnataka',78,'33599','195337700615','2006-02-15 04:45:30'),
 (474,'1469 Plock Lane','','Galicia',388,'95835','622884741180','2006-02-15 04:45:30'),
 (475,'434 Ourense (Orense) Manor','','Hodeida',206,'14122','562370137426','2006-02-15 04:45:30'),
 (476,'270 Tambaram Parkway','','Gauteng',244,'9668','248446668735','2006-02-15 04:45:30'),
 (477,'1786 Salinas Place','','Nam Ha',359,'66546','206060652238','2006-02-15 04:45:30'),
 (478,'1078 Stara Zagora Drive','','Aceh',301,'69221','932992626595','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (479,'1854 Okara Boulevard','','Drenthe',158,'42123','131912793873','2006-02-15 04:45:30'),
 (480,'421 Yaound Street','','Sumy',385,'11363','726875628268','2006-02-15 04:45:30'),
 (481,'1153 Allende Way','','Qubec',179,'20336','856872225376','2006-02-15 04:45:30'),
 (482,'808 Naala-Porto Parkway','','England',500,'41060','553452430707','2006-02-15 04:45:30'),
 (483,'632 Usolje-Sibirskoje Parkway','','Ha Darom',36,'73085','667648979883','2006-02-15 04:45:30'),
 (484,'98 Pyongyang Boulevard','','Ohio',11,'88749','191958435142','2006-02-15 04:45:30'),
 (485,'984 Novoterkassk Loop','','Gaziantep',180,'28165','435118527255','2006-02-15 04:45:30'),
 (486,'64 Korla Street','','Mwanza',347,'25145','510383179153','2006-02-15 04:45:30'),
 (487,'1785 So Bernardo do Campo Street','','Veracruz',125,'71182','684529463244','2006-02-15 04:45:30'),
 (488,'698 Jelets Boulevard','','Denizli',142,'2596','975185523021','2006-02-15 04:45:30'),
 (489,'1297 Alvorada Parkway','','Ningxia',587,'11839','508348602835','2006-02-15 04:45:30'),
 (490,'1909 Dayton Avenue','','Guangdong',469,'88513','702955450528','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (491,'1789 Saint-Denis Parkway','','Coahuila de Zaragoza',4,'8268','936806643983','2006-02-15 04:45:30'),
 (492,'185 Mannheim Lane','','Stavropol',408,'23661','589377568313','2006-02-15 04:45:30'),
 (493,'184 Mandaluyong Street','','Baja California Sur',288,'94239','488425406814','2006-02-15 04:45:30'),
 (494,'591 Sungai Petani Drive','','Okayama',376,'46400','37247325001','2006-02-15 04:45:30'),
 (495,'656 Matamoros Drive','','Boyac',487,'19489','17305839123','2006-02-15 04:45:30'),
 (496,'775 ostka Drive','','al-Daqahliya',337,'22358','171973024401','2006-02-15 04:45:30'),
 (497,'1013 Tabuk Boulevard','','West Bengali',261,'96203','158399646978','2006-02-15 04:45:30'),
 (498,'319 Plock Parkway','','Istanbul',504,'26101','854259976812','2006-02-15 04:45:30'),
 (499,'1954 Kowloon and New Kowloon Way','','Chimborazo',434,'63667','898559280434','2006-02-15 04:45:30'),
 (500,'362 Rajkot Lane','','Gansu',47,'98030','962020153680','2006-02-15 04:45:30'),
 (501,'1060 Tandil Lane','','Shandong',432,'72349','211256301880','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (502,'1515 Korla Way','','England',589,'57197','959467760895','2006-02-15 04:45:30'),
 (503,'1416 San Juan Bautista Tuxtepec Avenue','','Zufar',444,'50592','144206758053','2006-02-15 04:45:30'),
 (504,'1 Valle de Santiago Avenue','','Apulia',93,'86208','465897838272','2006-02-15 04:45:30'),
 (505,'519 Brescia Parkway','','East Java',318,'69504','793996678771','2006-02-15 04:45:30'),
 (506,'414 Mandaluyong Street','','Lubelskie',314,'16370','52709222667','2006-02-15 04:45:30'),
 (507,'1197 Sokoto Boulevard','','West Bengali',478,'87687','868602816371','2006-02-15 04:45:30'),
 (508,'496 Celaya Drive','','Nagano',552,'90797','759586584889','2006-02-15 04:45:30'),
 (509,'786 Matsue Way','','Illinois',245,'37469','111177206479','2006-02-15 04:45:30'),
 (510,'48 Maracabo Place','','Central Luzon',519,'1570','82671830126','2006-02-15 04:45:30'),
 (511,'1152 al-Qatif Lane','','Kalimantan Barat',412,'44816','131370665218','2006-02-15 04:45:30'),
 (512,'1269 Ipoh Avenue','','Eskisehir',163,'54674','402630109080','2006-02-15 04:45:30'),
 (513,'758 Korolev Parkway','','Andhra Pradesh',568,'75474','441628280920','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (514,'1747 Rustenburg Place','','Bihar',110,'51369','442673923363','2006-02-15 04:45:30'),
 (515,'886 Tonghae Place','','Volgograd',259,'19450','711928348157','2006-02-15 04:45:30'),
 (516,'1574 Goinia Boulevard','','Heilongjiang',502,'39529','59634255214','2006-02-15 04:45:30'),
 (517,'548 Uruapan Street','','Ontario',312,'35653','879347453467','2006-02-15 04:45:30'),
 (519,'962 Tama Loop','','',583,'65952','282667506728','2006-02-15 04:45:30'),
 (520,'1778 Gijn Manor','','Hubei',594,'35156','288910576761','2006-02-15 04:45:30'),
 (521,'568 Dhule (Dhulia) Loop','','Coquimbo',127,'92568','602101369463','2006-02-15 04:45:30'),
 (522,'1768 Udine Loop','','Battambang',60,'32347','448876499197','2006-02-15 04:45:30'),
 (523,'608 Birgunj Parkway','','Taipei',116,'400','627425618482','2006-02-15 04:45:30'),
 (524,'680 A Corua (La Corua) Manor','','Sivas',482,'49806','158326114853','2006-02-15 04:45:30'),
 (525,'1949 Sanya Street','','Gumma',224,'61244','132100972047','2006-02-15 04:45:30'),
 (526,'617 Klerksdorp Place','','Khanh Hoa',366,'94707','574973479129','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (527,'1993 0 Loop','','Liaoning',588,'41214','25865528181','2006-02-15 04:45:30'),
 (528,'1176 Southend-on-Sea Manor','','Southern Tagalog',458,'81651','236679267178','2006-02-15 04:45:30'),
 (529,'600 Purnea (Purnia) Avenue','','Nghe An',571,'18043','638409958875','2006-02-15 04:45:30'),
 (530,'1003 Qinhuangdao Street','','West Java',419,'25972','35533115997','2006-02-15 04:45:30'),
 (531,'1986 Sivas Place','','Friuli-Venezia Giuli',551,'95775','182059202712','2006-02-15 04:45:30'),
 (532,'1427 Tabuk Place','','Florida',101,'31342','214756839122','2006-02-15 04:45:30'),
 (533,'556 Asuncin Way','','Mogiljov',339,'35364','338244023543','2006-02-15 04:45:30'),
 (534,'486 Ondo Parkway','','Benguela',67,'35202','105882218332','2006-02-15 04:45:30'),
 (535,'635 Brest Manor','','Andhra Pradesh',75,'40899','80593242951','2006-02-15 04:45:30'),
 (536,'166 Jinchang Street','','Buenos Aires',165,'86760','717566026669','2006-02-15 04:45:30'),
 (537,'958 Sagamihara Lane','','Mie',287,'88408','427274926505','2006-02-15 04:45:30'),
 (538,'1817 Livorno Way','','Khanh Hoa',100,'79401','478380208348','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (539,'1332 Gaziantep Lane','','Shandong',80,'22813','383353187467','2006-02-15 04:45:30'),
 (540,'949 Allende Lane','','Uttar Pradesh',24,'67521','122981120653','2006-02-15 04:45:30'),
 (541,'195 Ilorin Street','','Chari-Baguirmi',363,'49250','8912935608','2006-02-15 04:45:30'),
 (542,'193 Bhusawal Place','','Kang-won',539,'9750','745267607502','2006-02-15 04:45:30'),
 (543,'43 Vilnius Manor','','Colorado',42,'79814','484500282381','2006-02-15 04:45:30'),
 (544,'183 Haiphong Street','','Jilin',46,'69953','488600270038','2006-02-15 04:45:30'),
 (545,'163 Augusta-Richmond County Loop','','Carabobo',561,'33030','754579047924','2006-02-15 04:45:30'),
 (546,'191 Jos Azueta Parkway','','Ruse',436,'13629','932156667696','2006-02-15 04:45:30'),
 (547,'379 Lublin Parkway','','Toscana',309,'74568','921960450089','2006-02-15 04:45:30'),
 (548,'1658 Cuman Loop','','Sumatera Selatan',396,'51309','784907335610','2006-02-15 04:45:30'),
 (549,'454 Qinhuangdao Drive','','Tadla-Azilal',68,'25866','786270036240','2006-02-15 04:45:30'),
 (550,'1715 Okayama Street','','So Paulo',485,'55676','169352919175','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (551,'182 Nukualofa Drive','','Sumy',275,'15414','426346224043','2006-02-15 04:45:30'),
 (552,'390 Wroclaw Way','','Hainan',462,'5753','357593328658','2006-02-15 04:45:30'),
 (553,'1421 Quilmes Lane','','Ishikawa',260,'19151','135407755975','2006-02-15 04:45:30'),
 (554,'947 Trshavn Place','','Central Luzon',528,'841','50898428626','2006-02-15 04:45:30'),
 (555,'1764 Jalib al-Shuyukh Parkway','','Galicia',459,'77642','84794532510','2006-02-15 04:45:30'),
 (556,'346 Cam Ranh Avenue','','Zhejiang',599,'39976','978430786151','2006-02-15 04:45:30'),
 (557,'1407 Pachuca de Soto Place','','Rio Grande do Sul',21,'26284','380077794770','2006-02-15 04:45:30'),
 (558,'904 Clarksville Drive','','Zhejiang',193,'52234','955349440539','2006-02-15 04:45:30'),
 (559,'1917 Kumbakonam Parkway','','Vojvodina',368,'11892','698182547686','2006-02-15 04:45:30'),
 (560,'1447 Imus Place','','Gujarat',426,'12905','62127829280','2006-02-15 04:45:30'),
 (561,'1497 Fengshan Drive','','KwaZulu-Natal',112,'63022','368738360376','2006-02-15 04:45:30'),
 (562,'869 Shikarpur Way','','England',496,'57380','590764256785','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (563,'1059 Yuncheng Avenue','','Vilna',570,'47498','107092893983','2006-02-15 04:45:30'),
 (564,'505 Madiun Boulevard','','Dolnoslaskie',577,'97271','970638808606','2006-02-15 04:45:30'),
 (565,'1741 Hoshiarpur Boulevard','','al-Sharqiya',79,'22372','855066328617','2006-02-15 04:45:30'),
 (566,'1229 Varanasi (Benares) Manor','','Buenos Aires',43,'40195','817740355461','2006-02-15 04:45:30'),
 (567,'1894 Boa Vista Way','','Texas',178,'77464','239357986667','2006-02-15 04:45:30'),
 (568,'1342 Sharja Way','','Sokoto & Kebbi & Zam',488,'93655','946114054231','2006-02-15 04:45:30'),
 (569,'1342 Abha Boulevard','','Bukarest',95,'10714','997453607116','2006-02-15 04:45:30'),
 (570,'415 Pune Avenue','','Shandong',580,'44274','203202500108','2006-02-15 04:45:30'),
 (571,'1746 Faaa Way','','Huanuco',214,'32515','863080561151','2006-02-15 04:45:30'),
 (572,'539 Hami Way','','Tokat',538,'52196','525518075499','2006-02-15 04:45:30'),
 (573,'1407 Surakarta Manor','','Moskova',466,'33224','324346485054','2006-02-15 04:45:30'),
 (574,'502 Mandi Bahauddin Parkway','','Anzotegui',55,'15992','618156722572','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (575,'1052 Pathankot Avenue','','Sichuan',299,'77397','128499386727','2006-02-15 04:45:30'),
 (576,'1351 Sousse Lane','','Coahuila de Zaragoza',341,'37815','203804046132','2006-02-15 04:45:30'),
 (577,'1501 Pangkal Pinang Avenue','','Mazowieckie',409,'943','770864062795','2006-02-15 04:45:30'),
 (578,'1405 Hagonoy Avenue','','Slaskie',133,'86587','867287719310','2006-02-15 04:45:30'),
 (579,'521 San Juan Bautista Tuxtepec Place','','Qaraghandy',598,'95093','844018348565','2006-02-15 04:45:30'),
 (580,'923 Tangail Boulevard','','Tokyo-to',10,'33384','315528269898','2006-02-15 04:45:30'),
 (581,'186 Skikda Lane','','Morelos',131,'89422','14465669789','2006-02-15 04:45:30'),
 (582,'1568 Celaya Parkway','','Kaohsiung',168,'34750','278669994384','2006-02-15 04:45:30'),
 (583,'1489 Kakamigahara Lane','','Taipei',526,'98883','29341849811','2006-02-15 04:45:30'),
 (584,'1819 Alessandria Loop','','Campeche',103,'53829','377633994405','2006-02-15 04:45:30'),
 (585,'1208 Tama Loop','','Ninawa',344,'73605','954786054144','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (586,'951 Springs Lane','','Central Mindanao',219,'96115','165164761435','2006-02-15 04:45:30'),
 (587,'760 Miyakonojo Drive','','Guerrero',246,'64682','294449058179','2006-02-15 04:45:30'),
 (588,'966 Asuncin Way','','Hidalgo',212,'62703','995527378381','2006-02-15 04:45:30'),
 (589,'1584 Ljubertsy Lane','','England',494,'22954','285710089439','2006-02-15 04:45:30'),
 (590,'247 Jining Parkway','','Banjul',54,'53446','170115379190','2006-02-15 04:45:30'),
 (591,'773 Dallas Manor','','Buenos Aires',424,'12664','914466027044','2006-02-15 04:45:30'),
 (592,'1923 Stara Zagora Lane','','Nantou',546,'95179','182178609211','2006-02-15 04:45:30'),
 (593,'1402 Zanzibar Boulevard','','Guanajuato',106,'71102','387448063440','2006-02-15 04:45:30'),
 (594,'1464 Kursk Parkway','','Shandong',574,'17381','338758048786','2006-02-15 04:45:30'),
 (595,'1074 Sanaa Parkway','','Loja',311,'22474','154124128457','2006-02-15 04:45:30'),
 (596,'1759 Niznekamsk Avenue','','al-Manama',14,'39414','864392582257','2006-02-15 04:45:30'),
 (597,'32 Liaocheng Way','','Minas Gerais',248,'1944','410877354933','2006-02-15 04:45:30');
INSERT INTO `sakila`.`address` VALUES  (598,'42 Fontana Avenue','','Fejr',512,'14684','437829801725','2006-02-15 04:45:30'),
 (599,'1895 Zhezqazghan Drive','','California',177,'36693','137809746111','2006-02-15 04:45:30'),
 (600,'1837 Kaduna Parkway','','Inner Mongolia',241,'82580','640843562301','2006-02-15 04:45:30'),
 (601,'844 Bucuresti Place','','Liaoning',242,'36603','935952366111','2006-02-15 04:45:30'),
 (602,'1101 Bucuresti Boulevard','','West Greece',401,'97661','199514580428','2006-02-15 04:45:30'),
 (603,'1103 Quilmes Boulevard','','Piura',503,'52137','644021380889','2006-02-15 04:45:30'),
 (604,'1331 Usak Boulevard','','Vaud',296,'61960','145308717464','2006-02-15 04:45:30'),
 (605,'1325 Fukuyama Street','','Heilongjiang',537,'27107','288241215394','2006-02-15 04:45:30');
COMMIT;

--
-- Definition of table `sakila`.`category`
--

DROP TABLE IF EXISTS `sakila`.`category`;
CREATE TABLE  `sakila`.`category` (
  `category_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`category`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`category` VALUES  (1,'Action','2006-02-15 04:46:27'),
 (2,'Animation','2006-02-15 04:46:27'),
 (3,'Children','2006-02-15 04:46:27'),
 (4,'Classics','2006-02-15 04:46:27'),
 (5,'Comedy','2006-02-15 04:46:27'),
 (6,'Documentary','2006-02-15 04:46:27'),
 (7,'Drama','2006-02-15 04:46:27'),
 (8,'Family','2006-02-15 04:46:27'),
 (9,'Foreign','2006-02-15 04:46:27'),
 (10,'Games','2006-02-15 04:46:27'),
 (11,'Horror','2006-02-15 04:46:27'),
 (12,'Music','2006-02-15 04:46:27'),
 (13,'New','2006-02-15 04:46:27'),
 (14,'Sci-Fi','2006-02-15 04:46:27'),
 (15,'Sports','2006-02-15 04:46:27'),
 (16,'Travel','2006-02-15 04:46:27');
COMMIT;

--
-- Definition of table `sakila`.`city`
--

DROP TABLE IF EXISTS `sakila`.`city`;
CREATE TABLE  `sakila`.`city` (
  `city_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `city` varchar(50) NOT NULL,
  `country_id` smallint(5) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`city_id`),
  KEY `idx_fk_country_id` (`country_id`),
  CONSTRAINT `fk_city_country` FOREIGN KEY (`country_id`) REFERENCES `country` (`country_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`city`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`city` VALUES  (1,'A Corua (La Corua)',87,'2006-02-15 04:45:25'),
 (2,'Abha',82,'2006-02-15 04:45:25'),
 (3,'Abu Dhabi',101,'2006-02-15 04:45:25'),
 (4,'Acua',60,'2006-02-15 04:45:25'),
 (5,'Adana',97,'2006-02-15 04:45:25'),
 (6,'Addis Abeba',31,'2006-02-15 04:45:25'),
 (7,'Aden',107,'2006-02-15 04:45:25'),
 (8,'Adoni',44,'2006-02-15 04:45:25'),
 (9,'Ahmadnagar',44,'2006-02-15 04:45:25'),
 (10,'Akishima',50,'2006-02-15 04:45:25'),
 (11,'Akron',103,'2006-02-15 04:45:25'),
 (12,'al-Ayn',101,'2006-02-15 04:45:25'),
 (13,'al-Hawiya',82,'2006-02-15 04:45:25'),
 (14,'al-Manama',11,'2006-02-15 04:45:25'),
 (15,'al-Qadarif',89,'2006-02-15 04:45:25'),
 (16,'al-Qatif',82,'2006-02-15 04:45:25'),
 (17,'Alessandria',49,'2006-02-15 04:45:25'),
 (18,'Allappuzha (Alleppey)',44,'2006-02-15 04:45:25'),
 (19,'Allende',60,'2006-02-15 04:45:25'),
 (20,'Almirante Brown',6,'2006-02-15 04:45:25'),
 (21,'Alvorada',15,'2006-02-15 04:45:25'),
 (22,'Ambattur',44,'2006-02-15 04:45:25'),
 (23,'Amersfoort',67,'2006-02-15 04:45:25'),
 (24,'Amroha',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (25,'Angra dos Reis',15,'2006-02-15 04:45:25'),
 (26,'Anpolis',15,'2006-02-15 04:45:25'),
 (27,'Antofagasta',22,'2006-02-15 04:45:25'),
 (28,'Aparecida de Goinia',15,'2006-02-15 04:45:25'),
 (29,'Apeldoorn',67,'2006-02-15 04:45:25'),
 (30,'Araatuba',15,'2006-02-15 04:45:25'),
 (31,'Arak',46,'2006-02-15 04:45:25'),
 (32,'Arecibo',77,'2006-02-15 04:45:25'),
 (33,'Arlington',103,'2006-02-15 04:45:25'),
 (34,'Ashdod',48,'2006-02-15 04:45:25'),
 (35,'Ashgabat',98,'2006-02-15 04:45:25'),
 (36,'Ashqelon',48,'2006-02-15 04:45:25'),
 (37,'Asuncin',73,'2006-02-15 04:45:25'),
 (38,'Athenai',39,'2006-02-15 04:45:25'),
 (39,'Atinsk',80,'2006-02-15 04:45:25'),
 (40,'Atlixco',60,'2006-02-15 04:45:25'),
 (41,'Augusta-Richmond County',103,'2006-02-15 04:45:25'),
 (42,'Aurora',103,'2006-02-15 04:45:25'),
 (43,'Avellaneda',6,'2006-02-15 04:45:25'),
 (44,'Bag',15,'2006-02-15 04:45:25'),
 (45,'Baha Blanca',6,'2006-02-15 04:45:25'),
 (46,'Baicheng',23,'2006-02-15 04:45:25'),
 (47,'Baiyin',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (48,'Baku',10,'2006-02-15 04:45:25'),
 (49,'Balaiha',80,'2006-02-15 04:45:25'),
 (50,'Balikesir',97,'2006-02-15 04:45:25'),
 (51,'Balurghat',44,'2006-02-15 04:45:25'),
 (52,'Bamenda',19,'2006-02-15 04:45:25'),
 (53,'Bandar Seri Begawan',16,'2006-02-15 04:45:25'),
 (54,'Banjul',37,'2006-02-15 04:45:25'),
 (55,'Barcelona',104,'2006-02-15 04:45:25'),
 (56,'Basel',91,'2006-02-15 04:45:25'),
 (57,'Bat Yam',48,'2006-02-15 04:45:25'),
 (58,'Batman',97,'2006-02-15 04:45:25'),
 (59,'Batna',2,'2006-02-15 04:45:25'),
 (60,'Battambang',18,'2006-02-15 04:45:25'),
 (61,'Baybay',75,'2006-02-15 04:45:25'),
 (62,'Bayugan',75,'2006-02-15 04:45:25'),
 (63,'Bchar',2,'2006-02-15 04:45:25'),
 (64,'Beira',63,'2006-02-15 04:45:25'),
 (65,'Bellevue',103,'2006-02-15 04:45:25'),
 (66,'Belm',15,'2006-02-15 04:45:25'),
 (67,'Benguela',4,'2006-02-15 04:45:25'),
 (68,'Beni-Mellal',62,'2006-02-15 04:45:25'),
 (69,'Benin City',69,'2006-02-15 04:45:25'),
 (70,'Bergamo',49,'2006-02-15 04:45:25'),
 (71,'Berhampore (Baharampur)',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (72,'Bern',91,'2006-02-15 04:45:25'),
 (73,'Bhavnagar',44,'2006-02-15 04:45:25'),
 (74,'Bhilwara',44,'2006-02-15 04:45:25'),
 (75,'Bhimavaram',44,'2006-02-15 04:45:25'),
 (76,'Bhopal',44,'2006-02-15 04:45:25'),
 (77,'Bhusawal',44,'2006-02-15 04:45:25'),
 (78,'Bijapur',44,'2006-02-15 04:45:25'),
 (79,'Bilbays',29,'2006-02-15 04:45:25'),
 (80,'Binzhou',23,'2006-02-15 04:45:25'),
 (81,'Birgunj',66,'2006-02-15 04:45:25'),
 (82,'Bislig',75,'2006-02-15 04:45:25'),
 (83,'Blumenau',15,'2006-02-15 04:45:25'),
 (84,'Boa Vista',15,'2006-02-15 04:45:25'),
 (85,'Boksburg',85,'2006-02-15 04:45:25'),
 (86,'Botosani',78,'2006-02-15 04:45:25'),
 (87,'Botshabelo',85,'2006-02-15 04:45:25'),
 (88,'Bradford',102,'2006-02-15 04:45:25'),
 (89,'Braslia',15,'2006-02-15 04:45:25'),
 (90,'Bratislava',84,'2006-02-15 04:45:25'),
 (91,'Brescia',49,'2006-02-15 04:45:25'),
 (92,'Brest',34,'2006-02-15 04:45:25'),
 (93,'Brindisi',49,'2006-02-15 04:45:25'),
 (94,'Brockton',103,'2006-02-15 04:45:25'),
 (95,'Bucuresti',78,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (96,'Buenaventura',24,'2006-02-15 04:45:25'),
 (97,'Bydgoszcz',76,'2006-02-15 04:45:25'),
 (98,'Cabuyao',75,'2006-02-15 04:45:25'),
 (99,'Callao',74,'2006-02-15 04:45:25'),
 (100,'Cam Ranh',105,'2006-02-15 04:45:25'),
 (101,'Cape Coral',103,'2006-02-15 04:45:25'),
 (102,'Caracas',104,'2006-02-15 04:45:25'),
 (103,'Carmen',60,'2006-02-15 04:45:25'),
 (104,'Cavite',75,'2006-02-15 04:45:25'),
 (105,'Cayenne',35,'2006-02-15 04:45:25'),
 (106,'Celaya',60,'2006-02-15 04:45:25'),
 (107,'Chandrapur',44,'2006-02-15 04:45:25'),
 (108,'Changhwa',92,'2006-02-15 04:45:25'),
 (109,'Changzhou',23,'2006-02-15 04:45:25'),
 (110,'Chapra',44,'2006-02-15 04:45:25'),
 (111,'Charlotte Amalie',106,'2006-02-15 04:45:25'),
 (112,'Chatsworth',85,'2006-02-15 04:45:25'),
 (113,'Cheju',86,'2006-02-15 04:45:25'),
 (114,'Chiayi',92,'2006-02-15 04:45:25'),
 (115,'Chisinau',61,'2006-02-15 04:45:25'),
 (116,'Chungho',92,'2006-02-15 04:45:25'),
 (117,'Cianjur',45,'2006-02-15 04:45:25'),
 (118,'Ciomas',45,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (119,'Ciparay',45,'2006-02-15 04:45:25'),
 (120,'Citrus Heights',103,'2006-02-15 04:45:25'),
 (121,'Citt del Vaticano',41,'2006-02-15 04:45:25'),
 (122,'Ciudad del Este',73,'2006-02-15 04:45:25'),
 (123,'Clarksville',103,'2006-02-15 04:45:25'),
 (124,'Coacalco de Berriozbal',60,'2006-02-15 04:45:25'),
 (125,'Coatzacoalcos',60,'2006-02-15 04:45:25'),
 (126,'Compton',103,'2006-02-15 04:45:25'),
 (127,'Coquimbo',22,'2006-02-15 04:45:25'),
 (128,'Crdoba',6,'2006-02-15 04:45:25'),
 (129,'Cuauhtmoc',60,'2006-02-15 04:45:25'),
 (130,'Cuautla',60,'2006-02-15 04:45:25'),
 (131,'Cuernavaca',60,'2006-02-15 04:45:25'),
 (132,'Cuman',104,'2006-02-15 04:45:25'),
 (133,'Czestochowa',76,'2006-02-15 04:45:25'),
 (134,'Dadu',72,'2006-02-15 04:45:25'),
 (135,'Dallas',103,'2006-02-15 04:45:25'),
 (136,'Datong',23,'2006-02-15 04:45:25'),
 (137,'Daugavpils',54,'2006-02-15 04:45:25'),
 (138,'Davao',75,'2006-02-15 04:45:25'),
 (139,'Daxian',23,'2006-02-15 04:45:25'),
 (140,'Dayton',103,'2006-02-15 04:45:25'),
 (141,'Deba Habe',69,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (142,'Denizli',97,'2006-02-15 04:45:25'),
 (143,'Dhaka',12,'2006-02-15 04:45:25'),
 (144,'Dhule (Dhulia)',44,'2006-02-15 04:45:25'),
 (145,'Dongying',23,'2006-02-15 04:45:25'),
 (146,'Donostia-San Sebastin',87,'2006-02-15 04:45:25'),
 (147,'Dos Quebradas',24,'2006-02-15 04:45:25'),
 (148,'Duisburg',38,'2006-02-15 04:45:25'),
 (149,'Dundee',102,'2006-02-15 04:45:25'),
 (150,'Dzerzinsk',80,'2006-02-15 04:45:25'),
 (151,'Ede',67,'2006-02-15 04:45:25'),
 (152,'Effon-Alaiye',69,'2006-02-15 04:45:25'),
 (153,'El Alto',14,'2006-02-15 04:45:25'),
 (154,'El Fuerte',60,'2006-02-15 04:45:25'),
 (155,'El Monte',103,'2006-02-15 04:45:25'),
 (156,'Elista',80,'2006-02-15 04:45:25'),
 (157,'Emeishan',23,'2006-02-15 04:45:25'),
 (158,'Emmen',67,'2006-02-15 04:45:25'),
 (159,'Enshi',23,'2006-02-15 04:45:25'),
 (160,'Erlangen',38,'2006-02-15 04:45:25'),
 (161,'Escobar',6,'2006-02-15 04:45:25'),
 (162,'Esfahan',46,'2006-02-15 04:45:25'),
 (163,'Eskisehir',97,'2006-02-15 04:45:25'),
 (164,'Etawah',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (165,'Ezeiza',6,'2006-02-15 04:45:25'),
 (166,'Ezhou',23,'2006-02-15 04:45:25'),
 (167,'Faaa',36,'2006-02-15 04:45:25'),
 (168,'Fengshan',92,'2006-02-15 04:45:25'),
 (169,'Firozabad',44,'2006-02-15 04:45:25'),
 (170,'Florencia',24,'2006-02-15 04:45:25'),
 (171,'Fontana',103,'2006-02-15 04:45:25'),
 (172,'Fukuyama',50,'2006-02-15 04:45:25'),
 (173,'Funafuti',99,'2006-02-15 04:45:25'),
 (174,'Fuyu',23,'2006-02-15 04:45:25'),
 (175,'Fuzhou',23,'2006-02-15 04:45:25'),
 (176,'Gandhinagar',44,'2006-02-15 04:45:25'),
 (177,'Garden Grove',103,'2006-02-15 04:45:25'),
 (178,'Garland',103,'2006-02-15 04:45:25'),
 (179,'Gatineau',20,'2006-02-15 04:45:25'),
 (180,'Gaziantep',97,'2006-02-15 04:45:25'),
 (181,'Gijn',87,'2006-02-15 04:45:25'),
 (182,'Gingoog',75,'2006-02-15 04:45:25'),
 (183,'Goinia',15,'2006-02-15 04:45:25'),
 (184,'Gorontalo',45,'2006-02-15 04:45:25'),
 (185,'Grand Prairie',103,'2006-02-15 04:45:25'),
 (186,'Graz',9,'2006-02-15 04:45:25'),
 (187,'Greensboro',103,'2006-02-15 04:45:25'),
 (188,'Guadalajara',60,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (189,'Guaruj',15,'2006-02-15 04:45:25'),
 (190,'guas Lindas de Gois',15,'2006-02-15 04:45:25'),
 (191,'Gulbarga',44,'2006-02-15 04:45:25'),
 (192,'Hagonoy',75,'2006-02-15 04:45:25'),
 (193,'Haining',23,'2006-02-15 04:45:25'),
 (194,'Haiphong',105,'2006-02-15 04:45:25'),
 (195,'Haldia',44,'2006-02-15 04:45:25'),
 (196,'Halifax',20,'2006-02-15 04:45:25'),
 (197,'Halisahar',44,'2006-02-15 04:45:25'),
 (198,'Halle/Saale',38,'2006-02-15 04:45:25'),
 (199,'Hami',23,'2006-02-15 04:45:25'),
 (200,'Hamilton',68,'2006-02-15 04:45:25'),
 (201,'Hanoi',105,'2006-02-15 04:45:25'),
 (202,'Hidalgo',60,'2006-02-15 04:45:25'),
 (203,'Higashiosaka',50,'2006-02-15 04:45:25'),
 (204,'Hino',50,'2006-02-15 04:45:25'),
 (205,'Hiroshima',50,'2006-02-15 04:45:25'),
 (206,'Hodeida',107,'2006-02-15 04:45:25'),
 (207,'Hohhot',23,'2006-02-15 04:45:25'),
 (208,'Hoshiarpur',44,'2006-02-15 04:45:25'),
 (209,'Hsichuh',92,'2006-02-15 04:45:25'),
 (210,'Huaian',23,'2006-02-15 04:45:25'),
 (211,'Hubli-Dharwad',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (212,'Huejutla de Reyes',60,'2006-02-15 04:45:25'),
 (213,'Huixquilucan',60,'2006-02-15 04:45:25'),
 (214,'Hunuco',74,'2006-02-15 04:45:25'),
 (215,'Ibirit',15,'2006-02-15 04:45:25'),
 (216,'Idfu',29,'2006-02-15 04:45:25'),
 (217,'Ife',69,'2006-02-15 04:45:25'),
 (218,'Ikerre',69,'2006-02-15 04:45:25'),
 (219,'Iligan',75,'2006-02-15 04:45:25'),
 (220,'Ilorin',69,'2006-02-15 04:45:25'),
 (221,'Imus',75,'2006-02-15 04:45:25'),
 (222,'Inegl',97,'2006-02-15 04:45:25'),
 (223,'Ipoh',59,'2006-02-15 04:45:25'),
 (224,'Isesaki',50,'2006-02-15 04:45:25'),
 (225,'Ivanovo',80,'2006-02-15 04:45:25'),
 (226,'Iwaki',50,'2006-02-15 04:45:25'),
 (227,'Iwakuni',50,'2006-02-15 04:45:25'),
 (228,'Iwatsuki',50,'2006-02-15 04:45:25'),
 (229,'Izumisano',50,'2006-02-15 04:45:25'),
 (230,'Jaffna',88,'2006-02-15 04:45:25'),
 (231,'Jaipur',44,'2006-02-15 04:45:25'),
 (232,'Jakarta',45,'2006-02-15 04:45:25'),
 (233,'Jalib al-Shuyukh',53,'2006-02-15 04:45:25'),
 (234,'Jamalpur',12,'2006-02-15 04:45:25'),
 (235,'Jaroslavl',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (236,'Jastrzebie-Zdrj',76,'2006-02-15 04:45:25'),
 (237,'Jedda',82,'2006-02-15 04:45:25'),
 (238,'Jelets',80,'2006-02-15 04:45:25'),
 (239,'Jhansi',44,'2006-02-15 04:45:25'),
 (240,'Jinchang',23,'2006-02-15 04:45:25'),
 (241,'Jining',23,'2006-02-15 04:45:25'),
 (242,'Jinzhou',23,'2006-02-15 04:45:25'),
 (243,'Jodhpur',44,'2006-02-15 04:45:25'),
 (244,'Johannesburg',85,'2006-02-15 04:45:25'),
 (245,'Joliet',103,'2006-02-15 04:45:25'),
 (246,'Jos Azueta',60,'2006-02-15 04:45:25'),
 (247,'Juazeiro do Norte',15,'2006-02-15 04:45:25'),
 (248,'Juiz de Fora',15,'2006-02-15 04:45:25'),
 (249,'Junan',23,'2006-02-15 04:45:25'),
 (250,'Jurez',60,'2006-02-15 04:45:25'),
 (251,'Kabul',1,'2006-02-15 04:45:25'),
 (252,'Kaduna',69,'2006-02-15 04:45:25'),
 (253,'Kakamigahara',50,'2006-02-15 04:45:25'),
 (254,'Kaliningrad',80,'2006-02-15 04:45:25'),
 (255,'Kalisz',76,'2006-02-15 04:45:25'),
 (256,'Kamakura',50,'2006-02-15 04:45:25'),
 (257,'Kamarhati',44,'2006-02-15 04:45:25'),
 (258,'Kamjanets-Podilskyi',100,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (259,'Kamyin',80,'2006-02-15 04:45:25'),
 (260,'Kanazawa',50,'2006-02-15 04:45:25'),
 (261,'Kanchrapara',44,'2006-02-15 04:45:25'),
 (262,'Kansas City',103,'2006-02-15 04:45:25'),
 (263,'Karnal',44,'2006-02-15 04:45:25'),
 (264,'Katihar',44,'2006-02-15 04:45:25'),
 (265,'Kermanshah',46,'2006-02-15 04:45:25'),
 (266,'Kilis',97,'2006-02-15 04:45:25'),
 (267,'Kimberley',85,'2006-02-15 04:45:25'),
 (268,'Kimchon',86,'2006-02-15 04:45:25'),
 (269,'Kingstown',81,'2006-02-15 04:45:25'),
 (270,'Kirovo-Tepetsk',80,'2006-02-15 04:45:25'),
 (271,'Kisumu',52,'2006-02-15 04:45:25'),
 (272,'Kitwe',109,'2006-02-15 04:45:25'),
 (273,'Klerksdorp',85,'2006-02-15 04:45:25'),
 (274,'Kolpino',80,'2006-02-15 04:45:25'),
 (275,'Konotop',100,'2006-02-15 04:45:25'),
 (276,'Koriyama',50,'2006-02-15 04:45:25'),
 (277,'Korla',23,'2006-02-15 04:45:25'),
 (278,'Korolev',80,'2006-02-15 04:45:25'),
 (279,'Kowloon and New Kowloon',42,'2006-02-15 04:45:25'),
 (280,'Kragujevac',108,'2006-02-15 04:45:25'),
 (281,'Ktahya',97,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (282,'Kuching',59,'2006-02-15 04:45:25'),
 (283,'Kumbakonam',44,'2006-02-15 04:45:25'),
 (284,'Kurashiki',50,'2006-02-15 04:45:25'),
 (285,'Kurgan',80,'2006-02-15 04:45:25'),
 (286,'Kursk',80,'2006-02-15 04:45:25'),
 (287,'Kuwana',50,'2006-02-15 04:45:25'),
 (288,'La Paz',60,'2006-02-15 04:45:25'),
 (289,'La Plata',6,'2006-02-15 04:45:25'),
 (290,'La Romana',27,'2006-02-15 04:45:25'),
 (291,'Laiwu',23,'2006-02-15 04:45:25'),
 (292,'Lancaster',103,'2006-02-15 04:45:25'),
 (293,'Laohekou',23,'2006-02-15 04:45:25'),
 (294,'Lapu-Lapu',75,'2006-02-15 04:45:25'),
 (295,'Laredo',103,'2006-02-15 04:45:25'),
 (296,'Lausanne',91,'2006-02-15 04:45:25'),
 (297,'Le Mans',34,'2006-02-15 04:45:25'),
 (298,'Lengshuijiang',23,'2006-02-15 04:45:25'),
 (299,'Leshan',23,'2006-02-15 04:45:25'),
 (300,'Lethbridge',20,'2006-02-15 04:45:25'),
 (301,'Lhokseumawe',45,'2006-02-15 04:45:25'),
 (302,'Liaocheng',23,'2006-02-15 04:45:25'),
 (303,'Liepaja',54,'2006-02-15 04:45:25'),
 (304,'Lilongwe',58,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (305,'Lima',74,'2006-02-15 04:45:25'),
 (306,'Lincoln',103,'2006-02-15 04:45:25'),
 (307,'Linz',9,'2006-02-15 04:45:25'),
 (308,'Lipetsk',80,'2006-02-15 04:45:25'),
 (309,'Livorno',49,'2006-02-15 04:45:25'),
 (310,'Ljubertsy',80,'2006-02-15 04:45:25'),
 (311,'Loja',28,'2006-02-15 04:45:25'),
 (312,'London',102,'2006-02-15 04:45:25'),
 (313,'London',20,'2006-02-15 04:45:25'),
 (314,'Lublin',76,'2006-02-15 04:45:25'),
 (315,'Lubumbashi',25,'2006-02-15 04:45:25'),
 (316,'Lungtan',92,'2006-02-15 04:45:25'),
 (317,'Luzinia',15,'2006-02-15 04:45:25'),
 (318,'Madiun',45,'2006-02-15 04:45:25'),
 (319,'Mahajanga',57,'2006-02-15 04:45:25'),
 (320,'Maikop',80,'2006-02-15 04:45:25'),
 (321,'Malm',90,'2006-02-15 04:45:25'),
 (322,'Manchester',103,'2006-02-15 04:45:25'),
 (323,'Mandaluyong',75,'2006-02-15 04:45:25'),
 (324,'Mandi Bahauddin',72,'2006-02-15 04:45:25'),
 (325,'Mannheim',38,'2006-02-15 04:45:25'),
 (326,'Maracabo',104,'2006-02-15 04:45:25'),
 (327,'Mardan',72,'2006-02-15 04:45:25'),
 (328,'Maring',15,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (329,'Masqat',71,'2006-02-15 04:45:25'),
 (330,'Matamoros',60,'2006-02-15 04:45:25'),
 (331,'Matsue',50,'2006-02-15 04:45:25'),
 (332,'Meixian',23,'2006-02-15 04:45:25'),
 (333,'Memphis',103,'2006-02-15 04:45:25'),
 (334,'Merlo',6,'2006-02-15 04:45:25'),
 (335,'Mexicali',60,'2006-02-15 04:45:25'),
 (336,'Miraj',44,'2006-02-15 04:45:25'),
 (337,'Mit Ghamr',29,'2006-02-15 04:45:25'),
 (338,'Miyakonojo',50,'2006-02-15 04:45:25'),
 (339,'Mogiljov',13,'2006-02-15 04:45:25'),
 (340,'Molodetno',13,'2006-02-15 04:45:25'),
 (341,'Monclova',60,'2006-02-15 04:45:25'),
 (342,'Monywa',64,'2006-02-15 04:45:25'),
 (343,'Moscow',80,'2006-02-15 04:45:25'),
 (344,'Mosul',47,'2006-02-15 04:45:25'),
 (345,'Mukateve',100,'2006-02-15 04:45:25'),
 (346,'Munger (Monghyr)',44,'2006-02-15 04:45:25'),
 (347,'Mwanza',93,'2006-02-15 04:45:25'),
 (348,'Mwene-Ditu',25,'2006-02-15 04:45:25'),
 (349,'Myingyan',64,'2006-02-15 04:45:25'),
 (350,'Mysore',44,'2006-02-15 04:45:25'),
 (351,'Naala-Porto',63,'2006-02-15 04:45:25'),
 (352,'Nabereznyje Telny',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (353,'Nador',62,'2006-02-15 04:45:25'),
 (354,'Nagaon',44,'2006-02-15 04:45:25'),
 (355,'Nagareyama',50,'2006-02-15 04:45:25'),
 (356,'Najafabad',46,'2006-02-15 04:45:25'),
 (357,'Naju',86,'2006-02-15 04:45:25'),
 (358,'Nakhon Sawan',94,'2006-02-15 04:45:25'),
 (359,'Nam Dinh',105,'2006-02-15 04:45:25'),
 (360,'Namibe',4,'2006-02-15 04:45:25'),
 (361,'Nantou',92,'2006-02-15 04:45:25'),
 (362,'Nanyang',23,'2006-02-15 04:45:25'),
 (363,'NDjamna',21,'2006-02-15 04:45:25'),
 (364,'Newcastle',85,'2006-02-15 04:45:25'),
 (365,'Nezahualcyotl',60,'2006-02-15 04:45:25'),
 (366,'Nha Trang',105,'2006-02-15 04:45:25'),
 (367,'Niznekamsk',80,'2006-02-15 04:45:25'),
 (368,'Novi Sad',108,'2006-02-15 04:45:25'),
 (369,'Novoterkassk',80,'2006-02-15 04:45:25'),
 (370,'Nukualofa',95,'2006-02-15 04:45:25'),
 (371,'Nuuk',40,'2006-02-15 04:45:25'),
 (372,'Nyeri',52,'2006-02-15 04:45:25'),
 (373,'Ocumare del Tuy',104,'2006-02-15 04:45:25'),
 (374,'Ogbomosho',69,'2006-02-15 04:45:25'),
 (375,'Okara',72,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (376,'Okayama',50,'2006-02-15 04:45:25'),
 (377,'Okinawa',50,'2006-02-15 04:45:25'),
 (378,'Olomouc',26,'2006-02-15 04:45:25'),
 (379,'Omdurman',89,'2006-02-15 04:45:25'),
 (380,'Omiya',50,'2006-02-15 04:45:25'),
 (381,'Ondo',69,'2006-02-15 04:45:25'),
 (382,'Onomichi',50,'2006-02-15 04:45:25'),
 (383,'Oshawa',20,'2006-02-15 04:45:25'),
 (384,'Osmaniye',97,'2006-02-15 04:45:25'),
 (385,'ostka',100,'2006-02-15 04:45:25'),
 (386,'Otsu',50,'2006-02-15 04:45:25'),
 (387,'Oulu',33,'2006-02-15 04:45:25'),
 (388,'Ourense (Orense)',87,'2006-02-15 04:45:25'),
 (389,'Owo',69,'2006-02-15 04:45:25'),
 (390,'Oyo',69,'2006-02-15 04:45:25'),
 (391,'Ozamis',75,'2006-02-15 04:45:25'),
 (392,'Paarl',85,'2006-02-15 04:45:25'),
 (393,'Pachuca de Soto',60,'2006-02-15 04:45:25'),
 (394,'Pak Kret',94,'2006-02-15 04:45:25'),
 (395,'Palghat (Palakkad)',44,'2006-02-15 04:45:25'),
 (396,'Pangkal Pinang',45,'2006-02-15 04:45:25'),
 (397,'Papeete',36,'2006-02-15 04:45:25'),
 (398,'Parbhani',44,'2006-02-15 04:45:25'),
 (399,'Pathankot',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (400,'Patiala',44,'2006-02-15 04:45:25'),
 (401,'Patras',39,'2006-02-15 04:45:25'),
 (402,'Pavlodar',51,'2006-02-15 04:45:25'),
 (403,'Pemalang',45,'2006-02-15 04:45:25'),
 (404,'Peoria',103,'2006-02-15 04:45:25'),
 (405,'Pereira',24,'2006-02-15 04:45:25'),
 (406,'Phnom Penh',18,'2006-02-15 04:45:25'),
 (407,'Pingxiang',23,'2006-02-15 04:45:25'),
 (408,'Pjatigorsk',80,'2006-02-15 04:45:25'),
 (409,'Plock',76,'2006-02-15 04:45:25'),
 (410,'Po',15,'2006-02-15 04:45:25'),
 (411,'Ponce',77,'2006-02-15 04:45:25'),
 (412,'Pontianak',45,'2006-02-15 04:45:25'),
 (413,'Poos de Caldas',15,'2006-02-15 04:45:25'),
 (414,'Portoviejo',28,'2006-02-15 04:45:25'),
 (415,'Probolinggo',45,'2006-02-15 04:45:25'),
 (416,'Pudukkottai',44,'2006-02-15 04:45:25'),
 (417,'Pune',44,'2006-02-15 04:45:25'),
 (418,'Purnea (Purnia)',44,'2006-02-15 04:45:25'),
 (419,'Purwakarta',45,'2006-02-15 04:45:25'),
 (420,'Pyongyang',70,'2006-02-15 04:45:25'),
 (421,'Qalyub',29,'2006-02-15 04:45:25'),
 (422,'Qinhuangdao',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (423,'Qomsheh',46,'2006-02-15 04:45:25'),
 (424,'Quilmes',6,'2006-02-15 04:45:25'),
 (425,'Rae Bareli',44,'2006-02-15 04:45:25'),
 (426,'Rajkot',44,'2006-02-15 04:45:25'),
 (427,'Rampur',44,'2006-02-15 04:45:25'),
 (428,'Rancagua',22,'2006-02-15 04:45:25'),
 (429,'Ranchi',44,'2006-02-15 04:45:25'),
 (430,'Richmond Hill',20,'2006-02-15 04:45:25'),
 (431,'Rio Claro',15,'2006-02-15 04:45:25'),
 (432,'Rizhao',23,'2006-02-15 04:45:25'),
 (433,'Roanoke',103,'2006-02-15 04:45:25'),
 (434,'Robamba',28,'2006-02-15 04:45:25'),
 (435,'Rockford',103,'2006-02-15 04:45:25'),
 (436,'Ruse',17,'2006-02-15 04:45:25'),
 (437,'Rustenburg',85,'2006-02-15 04:45:25'),
 (438,'s-Hertogenbosch',67,'2006-02-15 04:45:25'),
 (439,'Saarbrcken',38,'2006-02-15 04:45:25'),
 (440,'Sagamihara',50,'2006-02-15 04:45:25'),
 (441,'Saint Louis',103,'2006-02-15 04:45:25'),
 (442,'Saint-Denis',79,'2006-02-15 04:45:25'),
 (443,'Sal',62,'2006-02-15 04:45:25'),
 (444,'Salala',71,'2006-02-15 04:45:25'),
 (445,'Salamanca',60,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (446,'Salinas',103,'2006-02-15 04:45:25'),
 (447,'Salzburg',9,'2006-02-15 04:45:25'),
 (448,'Sambhal',44,'2006-02-15 04:45:25'),
 (449,'San Bernardino',103,'2006-02-15 04:45:25'),
 (450,'San Felipe de Puerto Plata',27,'2006-02-15 04:45:25'),
 (451,'San Felipe del Progreso',60,'2006-02-15 04:45:25'),
 (452,'San Juan Bautista Tuxtepec',60,'2006-02-15 04:45:25'),
 (453,'San Lorenzo',73,'2006-02-15 04:45:25'),
 (454,'San Miguel de Tucumn',6,'2006-02-15 04:45:25'),
 (455,'Sanaa',107,'2006-02-15 04:45:25'),
 (456,'Santa Brbara dOeste',15,'2006-02-15 04:45:25'),
 (457,'Santa F',6,'2006-02-15 04:45:25'),
 (458,'Santa Rosa',75,'2006-02-15 04:45:25'),
 (459,'Santiago de Compostela',87,'2006-02-15 04:45:25'),
 (460,'Santiago de los Caballeros',27,'2006-02-15 04:45:25'),
 (461,'Santo Andr',15,'2006-02-15 04:45:25'),
 (462,'Sanya',23,'2006-02-15 04:45:25'),
 (463,'Sasebo',50,'2006-02-15 04:45:25'),
 (464,'Satna',44,'2006-02-15 04:45:25'),
 (465,'Sawhaj',29,'2006-02-15 04:45:25'),
 (466,'Serpuhov',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (467,'Shahr-e Kord',46,'2006-02-15 04:45:25'),
 (468,'Shanwei',23,'2006-02-15 04:45:25'),
 (469,'Shaoguan',23,'2006-02-15 04:45:25'),
 (470,'Sharja',101,'2006-02-15 04:45:25'),
 (471,'Shenzhen',23,'2006-02-15 04:45:25'),
 (472,'Shikarpur',72,'2006-02-15 04:45:25'),
 (473,'Shimoga',44,'2006-02-15 04:45:25'),
 (474,'Shimonoseki',50,'2006-02-15 04:45:25'),
 (475,'Shivapuri',44,'2006-02-15 04:45:25'),
 (476,'Shubra al-Khayma',29,'2006-02-15 04:45:25'),
 (477,'Siegen',38,'2006-02-15 04:45:25'),
 (478,'Siliguri (Shiliguri)',44,'2006-02-15 04:45:25'),
 (479,'Simferopol',100,'2006-02-15 04:45:25'),
 (480,'Sincelejo',24,'2006-02-15 04:45:25'),
 (481,'Sirjan',46,'2006-02-15 04:45:25'),
 (482,'Sivas',97,'2006-02-15 04:45:25'),
 (483,'Skikda',2,'2006-02-15 04:45:25'),
 (484,'Smolensk',80,'2006-02-15 04:45:25'),
 (485,'So Bernardo do Campo',15,'2006-02-15 04:45:25'),
 (486,'So Leopoldo',15,'2006-02-15 04:45:25'),
 (487,'Sogamoso',24,'2006-02-15 04:45:25'),
 (488,'Sokoto',69,'2006-02-15 04:45:25'),
 (489,'Songkhla',94,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (490,'Sorocaba',15,'2006-02-15 04:45:25'),
 (491,'Soshanguve',85,'2006-02-15 04:45:25'),
 (492,'Sousse',96,'2006-02-15 04:45:25'),
 (493,'South Hill',5,'2006-02-15 04:45:25'),
 (494,'Southampton',102,'2006-02-15 04:45:25'),
 (495,'Southend-on-Sea',102,'2006-02-15 04:45:25'),
 (496,'Southport',102,'2006-02-15 04:45:25'),
 (497,'Springs',85,'2006-02-15 04:45:25'),
 (498,'Stara Zagora',17,'2006-02-15 04:45:25'),
 (499,'Sterling Heights',103,'2006-02-15 04:45:25'),
 (500,'Stockport',102,'2006-02-15 04:45:25'),
 (501,'Sucre',14,'2006-02-15 04:45:25'),
 (502,'Suihua',23,'2006-02-15 04:45:25'),
 (503,'Sullana',74,'2006-02-15 04:45:25'),
 (504,'Sultanbeyli',97,'2006-02-15 04:45:25'),
 (505,'Sumqayit',10,'2006-02-15 04:45:25'),
 (506,'Sumy',100,'2006-02-15 04:45:25'),
 (507,'Sungai Petani',59,'2006-02-15 04:45:25'),
 (508,'Sunnyvale',103,'2006-02-15 04:45:25'),
 (509,'Surakarta',45,'2006-02-15 04:45:25'),
 (510,'Syktyvkar',80,'2006-02-15 04:45:25'),
 (511,'Syrakusa',49,'2006-02-15 04:45:25'),
 (512,'Szkesfehrvr',43,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (513,'Tabora',93,'2006-02-15 04:45:25'),
 (514,'Tabriz',46,'2006-02-15 04:45:25'),
 (515,'Tabuk',82,'2006-02-15 04:45:25'),
 (516,'Tafuna',3,'2006-02-15 04:45:25'),
 (517,'Taguig',75,'2006-02-15 04:45:25'),
 (518,'Taizz',107,'2006-02-15 04:45:25'),
 (519,'Talavera',75,'2006-02-15 04:45:25'),
 (520,'Tallahassee',103,'2006-02-15 04:45:25'),
 (521,'Tama',50,'2006-02-15 04:45:25'),
 (522,'Tambaram',44,'2006-02-15 04:45:25'),
 (523,'Tanauan',75,'2006-02-15 04:45:25'),
 (524,'Tandil',6,'2006-02-15 04:45:25'),
 (525,'Tangail',12,'2006-02-15 04:45:25'),
 (526,'Tanshui',92,'2006-02-15 04:45:25'),
 (527,'Tanza',75,'2006-02-15 04:45:25'),
 (528,'Tarlac',75,'2006-02-15 04:45:25'),
 (529,'Tarsus',97,'2006-02-15 04:45:25'),
 (530,'Tartu',30,'2006-02-15 04:45:25'),
 (531,'Teboksary',80,'2006-02-15 04:45:25'),
 (532,'Tegal',45,'2006-02-15 04:45:25'),
 (533,'Tel Aviv-Jaffa',48,'2006-02-15 04:45:25'),
 (534,'Tete',63,'2006-02-15 04:45:25'),
 (535,'Tianjin',23,'2006-02-15 04:45:25'),
 (536,'Tiefa',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (537,'Tieli',23,'2006-02-15 04:45:25'),
 (538,'Tokat',97,'2006-02-15 04:45:25'),
 (539,'Tonghae',86,'2006-02-15 04:45:25'),
 (540,'Tongliao',23,'2006-02-15 04:45:25'),
 (541,'Torren',60,'2006-02-15 04:45:25'),
 (542,'Touliu',92,'2006-02-15 04:45:25'),
 (543,'Toulon',34,'2006-02-15 04:45:25'),
 (544,'Toulouse',34,'2006-02-15 04:45:25'),
 (545,'Trshavn',32,'2006-02-15 04:45:25'),
 (546,'Tsaotun',92,'2006-02-15 04:45:25'),
 (547,'Tsuyama',50,'2006-02-15 04:45:25'),
 (548,'Tuguegarao',75,'2006-02-15 04:45:25'),
 (549,'Tychy',76,'2006-02-15 04:45:25'),
 (550,'Udaipur',44,'2006-02-15 04:45:25'),
 (551,'Udine',49,'2006-02-15 04:45:25'),
 (552,'Ueda',50,'2006-02-15 04:45:25'),
 (553,'Uijongbu',86,'2006-02-15 04:45:25'),
 (554,'Uluberia',44,'2006-02-15 04:45:25'),
 (555,'Urawa',50,'2006-02-15 04:45:25'),
 (556,'Uruapan',60,'2006-02-15 04:45:25'),
 (557,'Usak',97,'2006-02-15 04:45:25'),
 (558,'Usolje-Sibirskoje',80,'2006-02-15 04:45:25'),
 (559,'Uttarpara-Kotrung',44,'2006-02-15 04:45:25'),
 (560,'Vaduz',55,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (561,'Valencia',104,'2006-02-15 04:45:25'),
 (562,'Valle de la Pascua',104,'2006-02-15 04:45:25'),
 (563,'Valle de Santiago',60,'2006-02-15 04:45:25'),
 (564,'Valparai',44,'2006-02-15 04:45:25'),
 (565,'Vancouver',20,'2006-02-15 04:45:25'),
 (566,'Varanasi (Benares)',44,'2006-02-15 04:45:25'),
 (567,'Vicente Lpez',6,'2006-02-15 04:45:25'),
 (568,'Vijayawada',44,'2006-02-15 04:45:25'),
 (569,'Vila Velha',15,'2006-02-15 04:45:25'),
 (570,'Vilnius',56,'2006-02-15 04:45:25'),
 (571,'Vinh',105,'2006-02-15 04:45:25'),
 (572,'Vitria de Santo Anto',15,'2006-02-15 04:45:25'),
 (573,'Warren',103,'2006-02-15 04:45:25'),
 (574,'Weifang',23,'2006-02-15 04:45:25'),
 (575,'Witten',38,'2006-02-15 04:45:25'),
 (576,'Woodridge',8,'2006-02-15 04:45:25'),
 (577,'Wroclaw',76,'2006-02-15 04:45:25'),
 (578,'Xiangfan',23,'2006-02-15 04:45:25'),
 (579,'Xiangtan',23,'2006-02-15 04:45:25'),
 (580,'Xintai',23,'2006-02-15 04:45:25'),
 (581,'Xinxiang',23,'2006-02-15 04:45:25'),
 (582,'Yamuna Nagar',44,'2006-02-15 04:45:25'),
 (583,'Yangor',65,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (584,'Yantai',23,'2006-02-15 04:45:25'),
 (585,'Yaound',19,'2006-02-15 04:45:25'),
 (586,'Yerevan',7,'2006-02-15 04:45:25'),
 (587,'Yinchuan',23,'2006-02-15 04:45:25'),
 (588,'Yingkou',23,'2006-02-15 04:45:25'),
 (589,'York',102,'2006-02-15 04:45:25'),
 (590,'Yuncheng',23,'2006-02-15 04:45:25'),
 (591,'Yuzhou',23,'2006-02-15 04:45:25'),
 (592,'Zalantun',23,'2006-02-15 04:45:25'),
 (593,'Zanzibar',93,'2006-02-15 04:45:25'),
 (594,'Zaoyang',23,'2006-02-15 04:45:25'),
 (595,'Zapopan',60,'2006-02-15 04:45:25'),
 (596,'Zaria',69,'2006-02-15 04:45:25'),
 (597,'Zeleznogorsk',80,'2006-02-15 04:45:25'),
 (598,'Zhezqazghan',51,'2006-02-15 04:45:25'),
 (599,'Zhoushan',23,'2006-02-15 04:45:25'),
 (600,'Ziguinchor',83,'2006-02-15 04:45:25');
COMMIT;

--
-- Definition of table `sakila`.`country`
--

DROP TABLE IF EXISTS `sakila`.`country`;
CREATE TABLE  `sakila`.`country` (
  `country_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(50) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`country`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`country` VALUES  (1,'Afghanistan','2006-02-15 04:44:00'),
 (2,'Algeria','2006-02-15 04:44:00'),
 (3,'American Samoa','2006-02-15 04:44:00'),
 (4,'Angola','2006-02-15 04:44:00'),
 (5,'Anguilla','2006-02-15 04:44:00'),
 (6,'Argentina','2006-02-15 04:44:00'),
 (7,'Armenia','2006-02-15 04:44:00'),
 (8,'Australia','2006-02-15 04:44:00'),
 (9,'Austria','2006-02-15 04:44:00'),
 (10,'Azerbaijan','2006-02-15 04:44:00'),
 (11,'Bahrain','2006-02-15 04:44:00'),
 (12,'Bangladesh','2006-02-15 04:44:00'),
 (13,'Belarus','2006-02-15 04:44:00'),
 (14,'Bolivia','2006-02-15 04:44:00'),
 (15,'Brazil','2006-02-15 04:44:00'),
 (16,'Brunei','2006-02-15 04:44:00'),
 (17,'Bulgaria','2006-02-15 04:44:00'),
 (18,'Cambodia','2006-02-15 04:44:00'),
 (19,'Cameroon','2006-02-15 04:44:00'),
 (20,'Canada','2006-02-15 04:44:00'),
 (21,'Chad','2006-02-15 04:44:00'),
 (22,'Chile','2006-02-15 04:44:00'),
 (23,'China','2006-02-15 04:44:00'),
 (24,'Colombia','2006-02-15 04:44:00'),
 (25,'Congo, The Democratic Republic of the','2006-02-15 04:44:00'),
 (26,'Czech Republic','2006-02-15 04:44:00');
INSERT INTO `sakila`.`country` VALUES  (27,'Dominican Republic','2006-02-15 04:44:00'),
 (28,'Ecuador','2006-02-15 04:44:00'),
 (29,'Egypt','2006-02-15 04:44:00'),
 (30,'Estonia','2006-02-15 04:44:00'),
 (31,'Ethiopia','2006-02-15 04:44:00'),
 (32,'Faroe Islands','2006-02-15 04:44:00'),
 (33,'Finland','2006-02-15 04:44:00'),
 (34,'France','2006-02-15 04:44:00'),
 (35,'French Guiana','2006-02-15 04:44:00'),
 (36,'French Polynesia','2006-02-15 04:44:00'),
 (37,'Gambia','2006-02-15 04:44:00'),
 (38,'Germany','2006-02-15 04:44:00'),
 (39,'Greece','2006-02-15 04:44:00'),
 (40,'Greenland','2006-02-15 04:44:00'),
 (41,'Holy See (Vatican City State)','2006-02-15 04:44:00'),
 (42,'Hong Kong','2006-02-15 04:44:00'),
 (43,'Hungary','2006-02-15 04:44:00'),
 (44,'India','2006-02-15 04:44:00'),
 (45,'Indonesia','2006-02-15 04:44:00'),
 (46,'Iran','2006-02-15 04:44:00'),
 (47,'Iraq','2006-02-15 04:44:00'),
 (48,'Israel','2006-02-15 04:44:00'),
 (49,'Italy','2006-02-15 04:44:00'),
 (50,'Japan','2006-02-15 04:44:00'),
 (51,'Kazakstan','2006-02-15 04:44:00');
INSERT INTO `sakila`.`country` VALUES  (52,'Kenya','2006-02-15 04:44:00'),
 (53,'Kuwait','2006-02-15 04:44:00'),
 (54,'Latvia','2006-02-15 04:44:00'),
 (55,'Liechtenstein','2006-02-15 04:44:00'),
 (56,'Lithuania','2006-02-15 04:44:00'),
 (57,'Madagascar','2006-02-15 04:44:00'),
 (58,'Malawi','2006-02-15 04:44:00'),
 (59,'Malaysia','2006-02-15 04:44:00'),
 (60,'Mexico','2006-02-15 04:44:00'),
 (61,'Moldova','2006-02-15 04:44:00'),
 (62,'Morocco','2006-02-15 04:44:00'),
 (63,'Mozambique','2006-02-15 04:44:00'),
 (64,'Myanmar','2006-02-15 04:44:00'),
 (65,'Nauru','2006-02-15 04:44:00'),
 (66,'Nepal','2006-02-15 04:44:00'),
 (67,'Netherlands','2006-02-15 04:44:00'),
 (68,'New Zealand','2006-02-15 04:44:00'),
 (69,'Nigeria','2006-02-15 04:44:00'),
 (70,'North Korea','2006-02-15 04:44:00'),
 (71,'Oman','2006-02-15 04:44:00'),
 (72,'Pakistan','2006-02-15 04:44:00'),
 (73,'Paraguay','2006-02-15 04:44:00'),
 (74,'Peru','2006-02-15 04:44:00'),
 (75,'Philippines','2006-02-15 04:44:00'),
 (76,'Poland','2006-02-15 04:44:00'),
 (77,'Puerto Rico','2006-02-15 04:44:00');
INSERT INTO `sakila`.`country` VALUES  (78,'Romania','2006-02-15 04:44:00'),
 (79,'Runion','2006-02-15 04:44:00'),
 (80,'Russian Federation','2006-02-15 04:44:00'),
 (81,'Saint Vincent and the Grenadines','2006-02-15 04:44:00'),
 (82,'Saudi Arabia','2006-02-15 04:44:00'),
 (83,'Senegal','2006-02-15 04:44:00'),
 (84,'Slovakia','2006-02-15 04:44:00'),
 (85,'South Africa','2006-02-15 04:44:00'),
 (86,'South Korea','2006-02-15 04:44:00'),
 (87,'Spain','2006-02-15 04:44:00'),
 (88,'Sri Lanka','2006-02-15 04:44:00'),
 (89,'Sudan','2006-02-15 04:44:00'),
 (90,'Sweden','2006-02-15 04:44:00'),
 (91,'Switzerland','2006-02-15 04:44:00'),
 (92,'Taiwan','2006-02-15 04:44:00'),
 (93,'Tanzania','2006-02-15 04:44:00'),
 (94,'Thailand','2006-02-15 04:44:00'),
 (95,'Tonga','2006-02-15 04:44:00'),
 (96,'Tunisia','2006-02-15 04:44:00'),
 (97,'Turkey','2006-02-15 04:44:00'),
 (98,'Turkmenistan','2006-02-15 04:44:00'),
 (99,'Tuvalu','2006-02-15 04:44:00'),
 (100,'Ukraine','2006-02-15 04:44:00'),
 (101,'United Arab Emirates','2006-02-15 04:44:00'),
 (102,'United Kingdom','2006-02-15 04:44:00');
INSERT INTO `sakila`.`country` VALUES  (103,'United States','2006-02-15 04:44:00'),
 (104,'Venezuela','2006-02-15 04:44:00'),
 (105,'Vietnam','2006-02-15 04:44:00'),
 (106,'Virgin Islands, U.S.','2006-02-15 04:44:00'),
 (107,'Yemen','2006-02-15 04:44:00'),
 (108,'Yugoslavia','2006-02-15 04:44:00'),
 (109,'Zambia','2006-02-15 04:44:00');
COMMIT;

--
-- Definition of table `sakila`.`customer`
--

DROP TABLE IF EXISTS `sakila`.`customer`;
CREATE TABLE  `sakila`.`customer` (
  `customer_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `store_id` tinyint(3) unsigned NOT NULL,
  `first_name` varchar(45) NOT NULL,
  `last_name` varchar(45) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `address_id` smallint(5) unsigned NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `create_date` datetime NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`customer_id`),
  KEY `idx_fk_store_id` (`store_id`),
  KEY `idx_fk_address_id` (`address_id`),
  KEY `idx_last_name` (`last_name`),
  CONSTRAINT `fk_customer_address` FOREIGN KEY (`address_id`) REFERENCES `address` (`address_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_customer_store` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`customer`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`customer` VALUES  (1,1,'MARY','SMITH','MARY.SMITH@sakilacustomer.org',5,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (2,1,'PATRICIA','JOHNSON','PATRICIA.JOHNSON@sakilacustomer.org',6,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (3,1,'LINDA','WILLIAMS','LINDA.WILLIAMS@sakilacustomer.org',7,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (4,2,'BARBARA','JONES','BARBARA.JONES@sakilacustomer.org',8,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (5,1,'ELIZABETH','BROWN','ELIZABETH.BROWN@sakilacustomer.org',9,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (6,2,'JENNIFER','DAVIS','JENNIFER.DAVIS@sakilacustomer.org',10,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (7,1,'MARIA','MILLER','MARIA.MILLER@sakilacustomer.org',11,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (8,2,'SUSAN','WILSON','SUSAN.WILSON@sakilacustomer.org',12,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (9,2,'MARGARET','MOORE','MARGARET.MOORE@sakilacustomer.org',13,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (10,1,'DOROTHY','TAYLOR','DOROTHY.TAYLOR@sakilacustomer.org',14,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (11,2,'LISA','ANDERSON','LISA.ANDERSON@sakilacustomer.org',15,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (12,1,'NANCY','THOMAS','NANCY.THOMAS@sakilacustomer.org',16,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (13,2,'KAREN','JACKSON','KAREN.JACKSON@sakilacustomer.org',17,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (14,2,'BETTY','WHITE','BETTY.WHITE@sakilacustomer.org',18,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (15,1,'HELEN','HARRIS','HELEN.HARRIS@sakilacustomer.org',19,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (16,2,'SANDRA','MARTIN','SANDRA.MARTIN@sakilacustomer.org',20,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (17,1,'DONNA','THOMPSON','DONNA.THOMPSON@sakilacustomer.org',21,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (18,2,'CAROL','GARCIA','CAROL.GARCIA@sakilacustomer.org',22,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (19,1,'RUTH','MARTINEZ','RUTH.MARTINEZ@sakilacustomer.org',23,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (20,2,'SHARON','ROBINSON','SHARON.ROBINSON@sakilacustomer.org',24,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (21,1,'MICHELLE','CLARK','MICHELLE.CLARK@sakilacustomer.org',25,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (22,1,'LAURA','RODRIGUEZ','LAURA.RODRIGUEZ@sakilacustomer.org',26,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (23,2,'SARAH','LEWIS','SARAH.LEWIS@sakilacustomer.org',27,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (24,2,'KIMBERLY','LEE','KIMBERLY.LEE@sakilacustomer.org',28,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (25,1,'DEBORAH','WALKER','DEBORAH.WALKER@sakilacustomer.org',29,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (26,2,'JESSICA','HALL','JESSICA.HALL@sakilacustomer.org',30,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (27,2,'SHIRLEY','ALLEN','SHIRLEY.ALLEN@sakilacustomer.org',31,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (28,1,'CYNTHIA','YOUNG','CYNTHIA.YOUNG@sakilacustomer.org',32,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (29,2,'ANGELA','HERNANDEZ','ANGELA.HERNANDEZ@sakilacustomer.org',33,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (30,1,'MELISSA','KING','MELISSA.KING@sakilacustomer.org',34,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (31,2,'BRENDA','WRIGHT','BRENDA.WRIGHT@sakilacustomer.org',35,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (32,1,'AMY','LOPEZ','AMY.LOPEZ@sakilacustomer.org',36,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (33,2,'ANNA','HILL','ANNA.HILL@sakilacustomer.org',37,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (34,2,'REBECCA','SCOTT','REBECCA.SCOTT@sakilacustomer.org',38,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (35,2,'VIRGINIA','GREEN','VIRGINIA.GREEN@sakilacustomer.org',39,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (36,2,'KATHLEEN','ADAMS','KATHLEEN.ADAMS@sakilacustomer.org',40,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (37,1,'PAMELA','BAKER','PAMELA.BAKER@sakilacustomer.org',41,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (38,1,'MARTHA','GONZALEZ','MARTHA.GONZALEZ@sakilacustomer.org',42,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (39,1,'DEBRA','NELSON','DEBRA.NELSON@sakilacustomer.org',43,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (40,2,'AMANDA','CARTER','AMANDA.CARTER@sakilacustomer.org',44,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (41,1,'STEPHANIE','MITCHELL','STEPHANIE.MITCHELL@sakilacustomer.org',45,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (42,2,'CAROLYN','PEREZ','CAROLYN.PEREZ@sakilacustomer.org',46,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (43,2,'CHRISTINE','ROBERTS','CHRISTINE.ROBERTS@sakilacustomer.org',47,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (44,1,'MARIE','TURNER','MARIE.TURNER@sakilacustomer.org',48,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (45,1,'JANET','PHILLIPS','JANET.PHILLIPS@sakilacustomer.org',49,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (46,2,'CATHERINE','CAMPBELL','CATHERINE.CAMPBELL@sakilacustomer.org',50,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (47,1,'FRANCES','PARKER','FRANCES.PARKER@sakilacustomer.org',51,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (48,1,'ANN','EVANS','ANN.EVANS@sakilacustomer.org',52,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (49,2,'JOYCE','EDWARDS','JOYCE.EDWARDS@sakilacustomer.org',53,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (50,1,'DIANE','COLLINS','DIANE.COLLINS@sakilacustomer.org',54,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (51,1,'ALICE','STEWART','ALICE.STEWART@sakilacustomer.org',55,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (52,1,'JULIE','SANCHEZ','JULIE.SANCHEZ@sakilacustomer.org',56,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (53,1,'HEATHER','MORRIS','HEATHER.MORRIS@sakilacustomer.org',57,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (54,1,'TERESA','ROGERS','TERESA.ROGERS@sakilacustomer.org',58,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (55,2,'DORIS','REED','DORIS.REED@sakilacustomer.org',59,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (56,1,'GLORIA','COOK','GLORIA.COOK@sakilacustomer.org',60,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (57,2,'EVELYN','MORGAN','EVELYN.MORGAN@sakilacustomer.org',61,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (58,1,'JEAN','BELL','JEAN.BELL@sakilacustomer.org',62,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (59,1,'CHERYL','MURPHY','CHERYL.MURPHY@sakilacustomer.org',63,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (60,1,'MILDRED','BAILEY','MILDRED.BAILEY@sakilacustomer.org',64,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (61,2,'KATHERINE','RIVERA','KATHERINE.RIVERA@sakilacustomer.org',65,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (62,1,'JOAN','COOPER','JOAN.COOPER@sakilacustomer.org',66,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (63,1,'ASHLEY','RICHARDSON','ASHLEY.RICHARDSON@sakilacustomer.org',67,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (64,2,'JUDITH','COX','JUDITH.COX@sakilacustomer.org',68,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (65,2,'ROSE','HOWARD','ROSE.HOWARD@sakilacustomer.org',69,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (66,2,'JANICE','WARD','JANICE.WARD@sakilacustomer.org',70,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (67,1,'KELLY','TORRES','KELLY.TORRES@sakilacustomer.org',71,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (68,1,'NICOLE','PETERSON','NICOLE.PETERSON@sakilacustomer.org',72,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (69,2,'JUDY','GRAY','JUDY.GRAY@sakilacustomer.org',73,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (70,2,'CHRISTINA','RAMIREZ','CHRISTINA.RAMIREZ@sakilacustomer.org',74,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (71,1,'KATHY','JAMES','KATHY.JAMES@sakilacustomer.org',75,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (72,2,'THERESA','WATSON','THERESA.WATSON@sakilacustomer.org',76,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (73,2,'BEVERLY','BROOKS','BEVERLY.BROOKS@sakilacustomer.org',77,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (74,1,'DENISE','KELLY','DENISE.KELLY@sakilacustomer.org',78,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (75,2,'TAMMY','SANDERS','TAMMY.SANDERS@sakilacustomer.org',79,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (76,2,'IRENE','PRICE','IRENE.PRICE@sakilacustomer.org',80,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (77,2,'JANE','BENNETT','JANE.BENNETT@sakilacustomer.org',81,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (78,1,'LORI','WOOD','LORI.WOOD@sakilacustomer.org',82,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (79,1,'RACHEL','BARNES','RACHEL.BARNES@sakilacustomer.org',83,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (80,1,'MARILYN','ROSS','MARILYN.ROSS@sakilacustomer.org',84,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (81,1,'ANDREA','HENDERSON','ANDREA.HENDERSON@sakilacustomer.org',85,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (82,1,'KATHRYN','COLEMAN','KATHRYN.COLEMAN@sakilacustomer.org',86,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (83,1,'LOUISE','JENKINS','LOUISE.JENKINS@sakilacustomer.org',87,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (84,2,'SARA','PERRY','SARA.PERRY@sakilacustomer.org',88,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (85,2,'ANNE','POWELL','ANNE.POWELL@sakilacustomer.org',89,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (86,2,'JACQUELINE','LONG','JACQUELINE.LONG@sakilacustomer.org',90,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (87,1,'WANDA','PATTERSON','WANDA.PATTERSON@sakilacustomer.org',91,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (88,2,'BONNIE','HUGHES','BONNIE.HUGHES@sakilacustomer.org',92,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (89,1,'JULIA','FLORES','JULIA.FLORES@sakilacustomer.org',93,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (90,2,'RUBY','WASHINGTON','RUBY.WASHINGTON@sakilacustomer.org',94,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (91,2,'LOIS','BUTLER','LOIS.BUTLER@sakilacustomer.org',95,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (92,2,'TINA','SIMMONS','TINA.SIMMONS@sakilacustomer.org',96,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (93,1,'PHYLLIS','FOSTER','PHYLLIS.FOSTER@sakilacustomer.org',97,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (94,1,'NORMA','GONZALES','NORMA.GONZALES@sakilacustomer.org',98,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (95,2,'PAULA','BRYANT','PAULA.BRYANT@sakilacustomer.org',99,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (96,1,'DIANA','ALEXANDER','DIANA.ALEXANDER@sakilacustomer.org',100,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (97,2,'ANNIE','RUSSELL','ANNIE.RUSSELL@sakilacustomer.org',101,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (98,1,'LILLIAN','GRIFFIN','LILLIAN.GRIFFIN@sakilacustomer.org',102,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (99,2,'EMILY','DIAZ','EMILY.DIAZ@sakilacustomer.org',103,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (100,1,'ROBIN','HAYES','ROBIN.HAYES@sakilacustomer.org',104,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (101,1,'PEGGY','MYERS','PEGGY.MYERS@sakilacustomer.org',105,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (102,1,'CRYSTAL','FORD','CRYSTAL.FORD@sakilacustomer.org',106,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (103,1,'GLADYS','HAMILTON','GLADYS.HAMILTON@sakilacustomer.org',107,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (104,1,'RITA','GRAHAM','RITA.GRAHAM@sakilacustomer.org',108,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (105,1,'DAWN','SULLIVAN','DAWN.SULLIVAN@sakilacustomer.org',109,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (106,1,'CONNIE','WALLACE','CONNIE.WALLACE@sakilacustomer.org',110,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (107,1,'FLORENCE','WOODS','FLORENCE.WOODS@sakilacustomer.org',111,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (108,1,'TRACY','COLE','TRACY.COLE@sakilacustomer.org',112,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (109,2,'EDNA','WEST','EDNA.WEST@sakilacustomer.org',113,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (110,2,'TIFFANY','JORDAN','TIFFANY.JORDAN@sakilacustomer.org',114,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (111,1,'CARMEN','OWENS','CARMEN.OWENS@sakilacustomer.org',115,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (112,2,'ROSA','REYNOLDS','ROSA.REYNOLDS@sakilacustomer.org',116,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (113,2,'CINDY','FISHER','CINDY.FISHER@sakilacustomer.org',117,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (114,2,'GRACE','ELLIS','GRACE.ELLIS@sakilacustomer.org',118,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (115,1,'WENDY','HARRISON','WENDY.HARRISON@sakilacustomer.org',119,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (116,1,'VICTORIA','GIBSON','VICTORIA.GIBSON@sakilacustomer.org',120,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (117,1,'EDITH','MCDONALD','EDITH.MCDONALD@sakilacustomer.org',121,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (118,1,'KIM','CRUZ','KIM.CRUZ@sakilacustomer.org',122,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (119,1,'SHERRY','MARSHALL','SHERRY.MARSHALL@sakilacustomer.org',123,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (120,2,'SYLVIA','ORTIZ','SYLVIA.ORTIZ@sakilacustomer.org',124,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (121,1,'JOSEPHINE','GOMEZ','JOSEPHINE.GOMEZ@sakilacustomer.org',125,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (122,1,'THELMA','MURRAY','THELMA.MURRAY@sakilacustomer.org',126,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (123,2,'SHANNON','FREEMAN','SHANNON.FREEMAN@sakilacustomer.org',127,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (124,1,'SHEILA','WELLS','SHEILA.WELLS@sakilacustomer.org',128,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (125,1,'ETHEL','WEBB','ETHEL.WEBB@sakilacustomer.org',129,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (126,1,'ELLEN','SIMPSON','ELLEN.SIMPSON@sakilacustomer.org',130,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (127,2,'ELAINE','STEVENS','ELAINE.STEVENS@sakilacustomer.org',131,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (128,1,'MARJORIE','TUCKER','MARJORIE.TUCKER@sakilacustomer.org',132,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (129,1,'CARRIE','PORTER','CARRIE.PORTER@sakilacustomer.org',133,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (130,1,'CHARLOTTE','HUNTER','CHARLOTTE.HUNTER@sakilacustomer.org',134,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (131,2,'MONICA','HICKS','MONICA.HICKS@sakilacustomer.org',135,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (132,2,'ESTHER','CRAWFORD','ESTHER.CRAWFORD@sakilacustomer.org',136,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (133,1,'PAULINE','HENRY','PAULINE.HENRY@sakilacustomer.org',137,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (134,1,'EMMA','BOYD','EMMA.BOYD@sakilacustomer.org',138,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (135,2,'JUANITA','MASON','JUANITA.MASON@sakilacustomer.org',139,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (136,2,'ANITA','MORALES','ANITA.MORALES@sakilacustomer.org',140,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (137,2,'RHONDA','KENNEDY','RHONDA.KENNEDY@sakilacustomer.org',141,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (138,1,'HAZEL','WARREN','HAZEL.WARREN@sakilacustomer.org',142,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (139,1,'AMBER','DIXON','AMBER.DIXON@sakilacustomer.org',143,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (140,1,'EVA','RAMOS','EVA.RAMOS@sakilacustomer.org',144,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (141,1,'DEBBIE','REYES','DEBBIE.REYES@sakilacustomer.org',145,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (142,1,'APRIL','BURNS','APRIL.BURNS@sakilacustomer.org',146,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (143,1,'LESLIE','GORDON','LESLIE.GORDON@sakilacustomer.org',147,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (144,1,'CLARA','SHAW','CLARA.SHAW@sakilacustomer.org',148,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (145,1,'LUCILLE','HOLMES','LUCILLE.HOLMES@sakilacustomer.org',149,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (146,1,'JAMIE','RICE','JAMIE.RICE@sakilacustomer.org',150,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (147,2,'JOANNE','ROBERTSON','JOANNE.ROBERTSON@sakilacustomer.org',151,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (148,1,'ELEANOR','HUNT','ELEANOR.HUNT@sakilacustomer.org',152,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (149,1,'VALERIE','BLACK','VALERIE.BLACK@sakilacustomer.org',153,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (150,2,'DANIELLE','DANIELS','DANIELLE.DANIELS@sakilacustomer.org',154,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (151,2,'MEGAN','PALMER','MEGAN.PALMER@sakilacustomer.org',155,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (152,1,'ALICIA','MILLS','ALICIA.MILLS@sakilacustomer.org',156,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (153,2,'SUZANNE','NICHOLS','SUZANNE.NICHOLS@sakilacustomer.org',157,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (154,2,'MICHELE','GRANT','MICHELE.GRANT@sakilacustomer.org',158,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (155,1,'GAIL','KNIGHT','GAIL.KNIGHT@sakilacustomer.org',159,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (156,1,'BERTHA','FERGUSON','BERTHA.FERGUSON@sakilacustomer.org',160,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (157,2,'DARLENE','ROSE','DARLENE.ROSE@sakilacustomer.org',161,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (158,1,'VERONICA','STONE','VERONICA.STONE@sakilacustomer.org',162,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (159,1,'JILL','HAWKINS','JILL.HAWKINS@sakilacustomer.org',163,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (160,2,'ERIN','DUNN','ERIN.DUNN@sakilacustomer.org',164,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (161,1,'GERALDINE','PERKINS','GERALDINE.PERKINS@sakilacustomer.org',165,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (162,2,'LAUREN','HUDSON','LAUREN.HUDSON@sakilacustomer.org',166,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (163,1,'CATHY','SPENCER','CATHY.SPENCER@sakilacustomer.org',167,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (164,2,'JOANN','GARDNER','JOANN.GARDNER@sakilacustomer.org',168,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (165,2,'LORRAINE','STEPHENS','LORRAINE.STEPHENS@sakilacustomer.org',169,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (166,1,'LYNN','PAYNE','LYNN.PAYNE@sakilacustomer.org',170,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (167,2,'SALLY','PIERCE','SALLY.PIERCE@sakilacustomer.org',171,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (168,1,'REGINA','BERRY','REGINA.BERRY@sakilacustomer.org',172,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (169,2,'ERICA','MATTHEWS','ERICA.MATTHEWS@sakilacustomer.org',173,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (170,1,'BEATRICE','ARNOLD','BEATRICE.ARNOLD@sakilacustomer.org',174,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (171,2,'DOLORES','WAGNER','DOLORES.WAGNER@sakilacustomer.org',175,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (172,1,'BERNICE','WILLIS','BERNICE.WILLIS@sakilacustomer.org',176,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (173,1,'AUDREY','RAY','AUDREY.RAY@sakilacustomer.org',177,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (174,2,'YVONNE','WATKINS','YVONNE.WATKINS@sakilacustomer.org',178,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (175,1,'ANNETTE','OLSON','ANNETTE.OLSON@sakilacustomer.org',179,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (176,1,'JUNE','CARROLL','JUNE.CARROLL@sakilacustomer.org',180,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (177,2,'SAMANTHA','DUNCAN','SAMANTHA.DUNCAN@sakilacustomer.org',181,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (178,2,'MARION','SNYDER','MARION.SNYDER@sakilacustomer.org',182,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (179,1,'DANA','HART','DANA.HART@sakilacustomer.org',183,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (180,2,'STACY','CUNNINGHAM','STACY.CUNNINGHAM@sakilacustomer.org',184,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (181,2,'ANA','BRADLEY','ANA.BRADLEY@sakilacustomer.org',185,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (182,1,'RENEE','LANE','RENEE.LANE@sakilacustomer.org',186,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (183,2,'IDA','ANDREWS','IDA.ANDREWS@sakilacustomer.org',187,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (184,1,'VIVIAN','RUIZ','VIVIAN.RUIZ@sakilacustomer.org',188,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (185,1,'ROBERTA','HARPER','ROBERTA.HARPER@sakilacustomer.org',189,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (186,2,'HOLLY','FOX','HOLLY.FOX@sakilacustomer.org',190,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (187,2,'BRITTANY','RILEY','BRITTANY.RILEY@sakilacustomer.org',191,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (188,1,'MELANIE','ARMSTRONG','MELANIE.ARMSTRONG@sakilacustomer.org',192,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (189,1,'LORETTA','CARPENTER','LORETTA.CARPENTER@sakilacustomer.org',193,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (190,2,'YOLANDA','WEAVER','YOLANDA.WEAVER@sakilacustomer.org',194,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (191,1,'JEANETTE','GREENE','JEANETTE.GREENE@sakilacustomer.org',195,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (192,1,'LAURIE','LAWRENCE','LAURIE.LAWRENCE@sakilacustomer.org',196,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (193,2,'KATIE','ELLIOTT','KATIE.ELLIOTT@sakilacustomer.org',197,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (194,2,'KRISTEN','CHAVEZ','KRISTEN.CHAVEZ@sakilacustomer.org',198,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (195,1,'VANESSA','SIMS','VANESSA.SIMS@sakilacustomer.org',199,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (196,1,'ALMA','AUSTIN','ALMA.AUSTIN@sakilacustomer.org',200,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (197,2,'SUE','PETERS','SUE.PETERS@sakilacustomer.org',201,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (198,2,'ELSIE','KELLEY','ELSIE.KELLEY@sakilacustomer.org',202,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (199,2,'BETH','FRANKLIN','BETH.FRANKLIN@sakilacustomer.org',203,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (200,2,'JEANNE','LAWSON','JEANNE.LAWSON@sakilacustomer.org',204,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (201,1,'VICKI','FIELDS','VICKI.FIELDS@sakilacustomer.org',205,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (202,2,'CARLA','GUTIERREZ','CARLA.GUTIERREZ@sakilacustomer.org',206,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (203,1,'TARA','RYAN','TARA.RYAN@sakilacustomer.org',207,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (204,1,'ROSEMARY','SCHMIDT','ROSEMARY.SCHMIDT@sakilacustomer.org',208,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (205,2,'EILEEN','CARR','EILEEN.CARR@sakilacustomer.org',209,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (206,1,'TERRI','VASQUEZ','TERRI.VASQUEZ@sakilacustomer.org',210,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (207,1,'GERTRUDE','CASTILLO','GERTRUDE.CASTILLO@sakilacustomer.org',211,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (208,1,'LUCY','WHEELER','LUCY.WHEELER@sakilacustomer.org',212,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (209,2,'TONYA','CHAPMAN','TONYA.CHAPMAN@sakilacustomer.org',213,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (210,2,'ELLA','OLIVER','ELLA.OLIVER@sakilacustomer.org',214,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (211,1,'STACEY','MONTGOMERY','STACEY.MONTGOMERY@sakilacustomer.org',215,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (212,2,'WILMA','RICHARDS','WILMA.RICHARDS@sakilacustomer.org',216,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (213,1,'GINA','WILLIAMSON','GINA.WILLIAMSON@sakilacustomer.org',217,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (214,1,'KRISTIN','JOHNSTON','KRISTIN.JOHNSTON@sakilacustomer.org',218,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (215,2,'JESSIE','BANKS','JESSIE.BANKS@sakilacustomer.org',219,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (216,1,'NATALIE','MEYER','NATALIE.MEYER@sakilacustomer.org',220,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (217,2,'AGNES','BISHOP','AGNES.BISHOP@sakilacustomer.org',221,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (218,1,'VERA','MCCOY','VERA.MCCOY@sakilacustomer.org',222,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (219,2,'WILLIE','HOWELL','WILLIE.HOWELL@sakilacustomer.org',223,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (220,2,'CHARLENE','ALVAREZ','CHARLENE.ALVAREZ@sakilacustomer.org',224,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (221,1,'BESSIE','MORRISON','BESSIE.MORRISON@sakilacustomer.org',225,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (222,2,'DELORES','HANSEN','DELORES.HANSEN@sakilacustomer.org',226,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (223,1,'MELINDA','FERNANDEZ','MELINDA.FERNANDEZ@sakilacustomer.org',227,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (224,2,'PEARL','GARZA','PEARL.GARZA@sakilacustomer.org',228,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (225,1,'ARLENE','HARVEY','ARLENE.HARVEY@sakilacustomer.org',229,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (226,2,'MAUREEN','LITTLE','MAUREEN.LITTLE@sakilacustomer.org',230,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (227,1,'COLLEEN','BURTON','COLLEEN.BURTON@sakilacustomer.org',231,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (228,2,'ALLISON','STANLEY','ALLISON.STANLEY@sakilacustomer.org',232,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (229,1,'TAMARA','NGUYEN','TAMARA.NGUYEN@sakilacustomer.org',233,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (230,2,'JOY','GEORGE','JOY.GEORGE@sakilacustomer.org',234,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (231,1,'GEORGIA','JACOBS','GEORGIA.JACOBS@sakilacustomer.org',235,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (232,2,'CONSTANCE','REID','CONSTANCE.REID@sakilacustomer.org',236,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (233,2,'LILLIE','KIM','LILLIE.KIM@sakilacustomer.org',237,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (234,1,'CLAUDIA','FULLER','CLAUDIA.FULLER@sakilacustomer.org',238,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (235,1,'JACKIE','LYNCH','JACKIE.LYNCH@sakilacustomer.org',239,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (236,1,'MARCIA','DEAN','MARCIA.DEAN@sakilacustomer.org',240,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (237,1,'TANYA','GILBERT','TANYA.GILBERT@sakilacustomer.org',241,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (238,1,'NELLIE','GARRETT','NELLIE.GARRETT@sakilacustomer.org',242,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (239,2,'MINNIE','ROMERO','MINNIE.ROMERO@sakilacustomer.org',243,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (240,1,'MARLENE','WELCH','MARLENE.WELCH@sakilacustomer.org',244,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (241,2,'HEIDI','LARSON','HEIDI.LARSON@sakilacustomer.org',245,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (242,1,'GLENDA','FRAZIER','GLENDA.FRAZIER@sakilacustomer.org',246,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (243,1,'LYDIA','BURKE','LYDIA.BURKE@sakilacustomer.org',247,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (244,2,'VIOLA','HANSON','VIOLA.HANSON@sakilacustomer.org',248,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (245,1,'COURTNEY','DAY','COURTNEY.DAY@sakilacustomer.org',249,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (246,1,'MARIAN','MENDOZA','MARIAN.MENDOZA@sakilacustomer.org',250,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (247,1,'STELLA','MORENO','STELLA.MORENO@sakilacustomer.org',251,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (248,1,'CAROLINE','BOWMAN','CAROLINE.BOWMAN@sakilacustomer.org',252,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (249,2,'DORA','MEDINA','DORA.MEDINA@sakilacustomer.org',253,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (250,2,'JO','FOWLER','JO.FOWLER@sakilacustomer.org',254,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (251,2,'VICKIE','BREWER','VICKIE.BREWER@sakilacustomer.org',255,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (252,2,'MATTIE','HOFFMAN','MATTIE.HOFFMAN@sakilacustomer.org',256,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (253,1,'TERRY','CARLSON','TERRY.CARLSON@sakilacustomer.org',258,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (254,2,'MAXINE','SILVA','MAXINE.SILVA@sakilacustomer.org',259,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (255,2,'IRMA','PEARSON','IRMA.PEARSON@sakilacustomer.org',260,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (256,2,'MABEL','HOLLAND','MABEL.HOLLAND@sakilacustomer.org',261,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (257,2,'MARSHA','DOUGLAS','MARSHA.DOUGLAS@sakilacustomer.org',262,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (258,1,'MYRTLE','FLEMING','MYRTLE.FLEMING@sakilacustomer.org',263,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (259,2,'LENA','JENSEN','LENA.JENSEN@sakilacustomer.org',264,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (260,1,'CHRISTY','VARGAS','CHRISTY.VARGAS@sakilacustomer.org',265,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (261,1,'DEANNA','BYRD','DEANNA.BYRD@sakilacustomer.org',266,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (262,2,'PATSY','DAVIDSON','PATSY.DAVIDSON@sakilacustomer.org',267,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (263,1,'HILDA','HOPKINS','HILDA.HOPKINS@sakilacustomer.org',268,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (264,1,'GWENDOLYN','MAY','GWENDOLYN.MAY@sakilacustomer.org',269,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (265,2,'JENNIE','TERRY','JENNIE.TERRY@sakilacustomer.org',270,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (266,2,'NORA','HERRERA','NORA.HERRERA@sakilacustomer.org',271,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (267,1,'MARGIE','WADE','MARGIE.WADE@sakilacustomer.org',272,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (268,1,'NINA','SOTO','NINA.SOTO@sakilacustomer.org',273,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (269,1,'CASSANDRA','WALTERS','CASSANDRA.WALTERS@sakilacustomer.org',274,1,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (270,1,'LEAH','CURTIS','LEAH.CURTIS@sakilacustomer.org',275,1,'2006-02-14 22:04:36','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (271,1,'PENNY','NEAL','PENNY.NEAL@sakilacustomer.org',276,0,'2006-02-14 22:04:36','2006-02-15 04:57:20'),
 (272,1,'KAY','CALDWELL','KAY.CALDWELL@sakilacustomer.org',277,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (273,2,'PRISCILLA','LOWE','PRISCILLA.LOWE@sakilacustomer.org',278,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (274,1,'NAOMI','JENNINGS','NAOMI.JENNINGS@sakilacustomer.org',279,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (275,2,'CAROLE','BARNETT','CAROLE.BARNETT@sakilacustomer.org',280,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (276,1,'BRANDY','GRAVES','BRANDY.GRAVES@sakilacustomer.org',281,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (277,2,'OLGA','JIMENEZ','OLGA.JIMENEZ@sakilacustomer.org',282,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (278,2,'BILLIE','HORTON','BILLIE.HORTON@sakilacustomer.org',283,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (279,2,'DIANNE','SHELTON','DIANNE.SHELTON@sakilacustomer.org',284,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (280,2,'TRACEY','BARRETT','TRACEY.BARRETT@sakilacustomer.org',285,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (281,2,'LEONA','OBRIEN','LEONA.OBRIEN@sakilacustomer.org',286,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (282,2,'JENNY','CASTRO','JENNY.CASTRO@sakilacustomer.org',287,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (283,1,'FELICIA','SUTTON','FELICIA.SUTTON@sakilacustomer.org',288,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (284,1,'SONIA','GREGORY','SONIA.GREGORY@sakilacustomer.org',289,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (285,1,'MIRIAM','MCKINNEY','MIRIAM.MCKINNEY@sakilacustomer.org',290,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (286,1,'VELMA','LUCAS','VELMA.LUCAS@sakilacustomer.org',291,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (287,2,'BECKY','MILES','BECKY.MILES@sakilacustomer.org',292,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (288,1,'BOBBIE','CRAIG','BOBBIE.CRAIG@sakilacustomer.org',293,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (289,1,'VIOLET','RODRIQUEZ','VIOLET.RODRIQUEZ@sakilacustomer.org',294,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (290,1,'KRISTINA','CHAMBERS','KRISTINA.CHAMBERS@sakilacustomer.org',295,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (291,1,'TONI','HOLT','TONI.HOLT@sakilacustomer.org',296,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (292,2,'MISTY','LAMBERT','MISTY.LAMBERT@sakilacustomer.org',297,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (293,2,'MAE','FLETCHER','MAE.FLETCHER@sakilacustomer.org',298,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (294,2,'SHELLY','WATTS','SHELLY.WATTS@sakilacustomer.org',299,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (295,1,'DAISY','BATES','DAISY.BATES@sakilacustomer.org',300,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (296,2,'RAMONA','HALE','RAMONA.HALE@sakilacustomer.org',301,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (297,1,'SHERRI','RHODES','SHERRI.RHODES@sakilacustomer.org',302,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (298,1,'ERIKA','PENA','ERIKA.PENA@sakilacustomer.org',303,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (299,2,'JAMES','GANNON','JAMES.GANNON@sakilacustomer.org',304,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (300,1,'JOHN','FARNSWORTH','JOHN.FARNSWORTH@sakilacustomer.org',305,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (301,2,'ROBERT','BAUGHMAN','ROBERT.BAUGHMAN@sakilacustomer.org',306,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (302,1,'MICHAEL','SILVERMAN','MICHAEL.SILVERMAN@sakilacustomer.org',307,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (303,2,'WILLIAM','SATTERFIELD','WILLIAM.SATTERFIELD@sakilacustomer.org',308,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (304,2,'DAVID','ROYAL','DAVID.ROYAL@sakilacustomer.org',309,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (305,1,'RICHARD','MCCRARY','RICHARD.MCCRARY@sakilacustomer.org',310,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (306,1,'CHARLES','KOWALSKI','CHARLES.KOWALSKI@sakilacustomer.org',311,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (307,2,'JOSEPH','JOY','JOSEPH.JOY@sakilacustomer.org',312,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (308,1,'THOMAS','GRIGSBY','THOMAS.GRIGSBY@sakilacustomer.org',313,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (309,1,'CHRISTOPHER','GRECO','CHRISTOPHER.GRECO@sakilacustomer.org',314,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (310,2,'DANIEL','CABRAL','DANIEL.CABRAL@sakilacustomer.org',315,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (311,2,'PAUL','TROUT','PAUL.TROUT@sakilacustomer.org',316,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (312,2,'MARK','RINEHART','MARK.RINEHART@sakilacustomer.org',317,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (313,2,'DONALD','MAHON','DONALD.MAHON@sakilacustomer.org',318,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (314,1,'GEORGE','LINTON','GEORGE.LINTON@sakilacustomer.org',319,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (315,2,'KENNETH','GOODEN','KENNETH.GOODEN@sakilacustomer.org',320,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (316,1,'STEVEN','CURLEY','STEVEN.CURLEY@sakilacustomer.org',321,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (317,2,'EDWARD','BAUGH','EDWARD.BAUGH@sakilacustomer.org',322,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (318,1,'BRIAN','WYMAN','BRIAN.WYMAN@sakilacustomer.org',323,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (319,2,'RONALD','WEINER','RONALD.WEINER@sakilacustomer.org',324,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (320,2,'ANTHONY','SCHWAB','ANTHONY.SCHWAB@sakilacustomer.org',325,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (321,1,'KEVIN','SCHULER','KEVIN.SCHULER@sakilacustomer.org',326,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (322,1,'JASON','MORRISSEY','JASON.MORRISSEY@sakilacustomer.org',327,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (323,2,'MATTHEW','MAHAN','MATTHEW.MAHAN@sakilacustomer.org',328,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (324,2,'GARY','COY','GARY.COY@sakilacustomer.org',329,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (325,1,'TIMOTHY','BUNN','TIMOTHY.BUNN@sakilacustomer.org',330,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (326,1,'JOSE','ANDREW','JOSE.ANDREW@sakilacustomer.org',331,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (327,2,'LARRY','THRASHER','LARRY.THRASHER@sakilacustomer.org',332,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (328,2,'JEFFREY','SPEAR','JEFFREY.SPEAR@sakilacustomer.org',333,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (329,2,'FRANK','WAGGONER','FRANK.WAGGONER@sakilacustomer.org',334,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (330,1,'SCOTT','SHELLEY','SCOTT.SHELLEY@sakilacustomer.org',335,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (331,1,'ERIC','ROBERT','ERIC.ROBERT@sakilacustomer.org',336,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (332,1,'STEPHEN','QUALLS','STEPHEN.QUALLS@sakilacustomer.org',337,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (333,2,'ANDREW','PURDY','ANDREW.PURDY@sakilacustomer.org',338,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (334,2,'RAYMOND','MCWHORTER','RAYMOND.MCWHORTER@sakilacustomer.org',339,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (335,1,'GREGORY','MAULDIN','GREGORY.MAULDIN@sakilacustomer.org',340,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (336,1,'JOSHUA','MARK','JOSHUA.MARK@sakilacustomer.org',341,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (337,1,'JERRY','JORDON','JERRY.JORDON@sakilacustomer.org',342,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (338,1,'DENNIS','GILMAN','DENNIS.GILMAN@sakilacustomer.org',343,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (339,2,'WALTER','PERRYMAN','WALTER.PERRYMAN@sakilacustomer.org',344,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (340,1,'PATRICK','NEWSOM','PATRICK.NEWSOM@sakilacustomer.org',345,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (341,1,'PETER','MENARD','PETER.MENARD@sakilacustomer.org',346,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (342,1,'HAROLD','MARTINO','HAROLD.MARTINO@sakilacustomer.org',347,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (343,1,'DOUGLAS','GRAF','DOUGLAS.GRAF@sakilacustomer.org',348,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (344,1,'HENRY','BILLINGSLEY','HENRY.BILLINGSLEY@sakilacustomer.org',349,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (345,1,'CARL','ARTIS','CARL.ARTIS@sakilacustomer.org',350,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (346,1,'ARTHUR','SIMPKINS','ARTHUR.SIMPKINS@sakilacustomer.org',351,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (347,2,'RYAN','SALISBURY','RYAN.SALISBURY@sakilacustomer.org',352,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (348,2,'ROGER','QUINTANILLA','ROGER.QUINTANILLA@sakilacustomer.org',353,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (349,2,'JOE','GILLILAND','JOE.GILLILAND@sakilacustomer.org',354,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (350,1,'JUAN','FRALEY','JUAN.FRALEY@sakilacustomer.org',355,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (351,1,'JACK','FOUST','JACK.FOUST@sakilacustomer.org',356,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (352,1,'ALBERT','CROUSE','ALBERT.CROUSE@sakilacustomer.org',357,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (353,1,'JONATHAN','SCARBOROUGH','JONATHAN.SCARBOROUGH@sakilacustomer.org',358,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (354,2,'JUSTIN','NGO','JUSTIN.NGO@sakilacustomer.org',359,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (355,2,'TERRY','GRISSOM','TERRY.GRISSOM@sakilacustomer.org',360,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (356,2,'GERALD','FULTZ','GERALD.FULTZ@sakilacustomer.org',361,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (357,1,'KEITH','RICO','KEITH.RICO@sakilacustomer.org',362,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (358,2,'SAMUEL','MARLOW','SAMUEL.MARLOW@sakilacustomer.org',363,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (359,2,'WILLIE','MARKHAM','WILLIE.MARKHAM@sakilacustomer.org',364,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (360,2,'RALPH','MADRIGAL','RALPH.MADRIGAL@sakilacustomer.org',365,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (361,2,'LAWRENCE','LAWTON','LAWRENCE.LAWTON@sakilacustomer.org',366,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (362,1,'NICHOLAS','BARFIELD','NICHOLAS.BARFIELD@sakilacustomer.org',367,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (363,2,'ROY','WHITING','ROY.WHITING@sakilacustomer.org',368,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (364,1,'BENJAMIN','VARNEY','BENJAMIN.VARNEY@sakilacustomer.org',369,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (365,2,'BRUCE','SCHWARZ','BRUCE.SCHWARZ@sakilacustomer.org',370,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (366,1,'BRANDON','HUEY','BRANDON.HUEY@sakilacustomer.org',371,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (367,1,'ADAM','GOOCH','ADAM.GOOCH@sakilacustomer.org',372,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (368,1,'HARRY','ARCE','HARRY.ARCE@sakilacustomer.org',373,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (369,2,'FRED','WHEAT','FRED.WHEAT@sakilacustomer.org',374,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (370,2,'WAYNE','TRUONG','WAYNE.TRUONG@sakilacustomer.org',375,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (371,1,'BILLY','POULIN','BILLY.POULIN@sakilacustomer.org',376,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (372,2,'STEVE','MACKENZIE','STEVE.MACKENZIE@sakilacustomer.org',377,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (373,1,'LOUIS','LEONE','LOUIS.LEONE@sakilacustomer.org',378,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (374,2,'JEREMY','HURTADO','JEREMY.HURTADO@sakilacustomer.org',379,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (375,2,'AARON','SELBY','AARON.SELBY@sakilacustomer.org',380,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (376,1,'RANDY','GAITHER','RANDY.GAITHER@sakilacustomer.org',381,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (377,1,'HOWARD','FORTNER','HOWARD.FORTNER@sakilacustomer.org',382,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (378,1,'EUGENE','CULPEPPER','EUGENE.CULPEPPER@sakilacustomer.org',383,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (379,1,'CARLOS','COUGHLIN','CARLOS.COUGHLIN@sakilacustomer.org',384,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (380,1,'RUSSELL','BRINSON','RUSSELL.BRINSON@sakilacustomer.org',385,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (381,2,'BOBBY','BOUDREAU','BOBBY.BOUDREAU@sakilacustomer.org',386,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (382,2,'VICTOR','BARKLEY','VICTOR.BARKLEY@sakilacustomer.org',387,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (383,1,'MARTIN','BALES','MARTIN.BALES@sakilacustomer.org',388,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (384,2,'ERNEST','STEPP','ERNEST.STEPP@sakilacustomer.org',389,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (385,1,'PHILLIP','HOLM','PHILLIP.HOLM@sakilacustomer.org',390,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (386,1,'TODD','TAN','TODD.TAN@sakilacustomer.org',391,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (387,2,'JESSE','SCHILLING','JESSE.SCHILLING@sakilacustomer.org',392,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (388,2,'CRAIG','MORRELL','CRAIG.MORRELL@sakilacustomer.org',393,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (389,1,'ALAN','KAHN','ALAN.KAHN@sakilacustomer.org',394,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (390,1,'SHAWN','HEATON','SHAWN.HEATON@sakilacustomer.org',395,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (391,1,'CLARENCE','GAMEZ','CLARENCE.GAMEZ@sakilacustomer.org',396,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (392,2,'SEAN','DOUGLASS','SEAN.DOUGLASS@sakilacustomer.org',397,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (393,1,'PHILIP','CAUSEY','PHILIP.CAUSEY@sakilacustomer.org',398,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (394,2,'CHRIS','BROTHERS','CHRIS.BROTHERS@sakilacustomer.org',399,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (395,2,'JOHNNY','TURPIN','JOHNNY.TURPIN@sakilacustomer.org',400,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (396,1,'EARL','SHANKS','EARL.SHANKS@sakilacustomer.org',401,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (397,1,'JIMMY','SCHRADER','JIMMY.SCHRADER@sakilacustomer.org',402,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (398,1,'ANTONIO','MEEK','ANTONIO.MEEK@sakilacustomer.org',403,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (399,1,'DANNY','ISOM','DANNY.ISOM@sakilacustomer.org',404,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (400,2,'BRYAN','HARDISON','BRYAN.HARDISON@sakilacustomer.org',405,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (401,2,'TONY','CARRANZA','TONY.CARRANZA@sakilacustomer.org',406,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (402,1,'LUIS','YANEZ','LUIS.YANEZ@sakilacustomer.org',407,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (403,1,'MIKE','WAY','MIKE.WAY@sakilacustomer.org',408,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (404,2,'STANLEY','SCROGGINS','STANLEY.SCROGGINS@sakilacustomer.org',409,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (405,1,'LEONARD','SCHOFIELD','LEONARD.SCHOFIELD@sakilacustomer.org',410,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (406,1,'NATHAN','RUNYON','NATHAN.RUNYON@sakilacustomer.org',411,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (407,1,'DALE','RATCLIFF','DALE.RATCLIFF@sakilacustomer.org',412,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (408,1,'MANUEL','MURRELL','MANUEL.MURRELL@sakilacustomer.org',413,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (409,2,'RODNEY','MOELLER','RODNEY.MOELLER@sakilacustomer.org',414,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (410,2,'CURTIS','IRBY','CURTIS.IRBY@sakilacustomer.org',415,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (411,1,'NORMAN','CURRIER','NORMAN.CURRIER@sakilacustomer.org',416,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (412,2,'ALLEN','BUTTERFIELD','ALLEN.BUTTERFIELD@sakilacustomer.org',417,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (413,2,'MARVIN','YEE','MARVIN.YEE@sakilacustomer.org',418,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (414,1,'VINCENT','RALSTON','VINCENT.RALSTON@sakilacustomer.org',419,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (415,1,'GLENN','PULLEN','GLENN.PULLEN@sakilacustomer.org',420,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (416,2,'JEFFERY','PINSON','JEFFERY.PINSON@sakilacustomer.org',421,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (417,1,'TRAVIS','ESTEP','TRAVIS.ESTEP@sakilacustomer.org',422,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (418,2,'JEFF','EAST','JEFF.EAST@sakilacustomer.org',423,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (419,1,'CHAD','CARBONE','CHAD.CARBONE@sakilacustomer.org',424,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (420,1,'JACOB','LANCE','JACOB.LANCE@sakilacustomer.org',425,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (421,1,'LEE','HAWKS','LEE.HAWKS@sakilacustomer.org',426,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (422,1,'MELVIN','ELLINGTON','MELVIN.ELLINGTON@sakilacustomer.org',427,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (423,2,'ALFRED','CASILLAS','ALFRED.CASILLAS@sakilacustomer.org',428,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (424,2,'KYLE','SPURLOCK','KYLE.SPURLOCK@sakilacustomer.org',429,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (425,2,'FRANCIS','SIKES','FRANCIS.SIKES@sakilacustomer.org',430,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (426,1,'BRADLEY','MOTLEY','BRADLEY.MOTLEY@sakilacustomer.org',431,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (427,2,'JESUS','MCCARTNEY','JESUS.MCCARTNEY@sakilacustomer.org',432,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (428,2,'HERBERT','KRUGER','HERBERT.KRUGER@sakilacustomer.org',433,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (429,2,'FREDERICK','ISBELL','FREDERICK.ISBELL@sakilacustomer.org',434,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (430,1,'RAY','HOULE','RAY.HOULE@sakilacustomer.org',435,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (431,2,'JOEL','FRANCISCO','JOEL.FRANCISCO@sakilacustomer.org',436,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (432,1,'EDWIN','BURK','EDWIN.BURK@sakilacustomer.org',437,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (433,1,'DON','BONE','DON.BONE@sakilacustomer.org',438,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (434,1,'EDDIE','TOMLIN','EDDIE.TOMLIN@sakilacustomer.org',439,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (435,2,'RICKY','SHELBY','RICKY.SHELBY@sakilacustomer.org',440,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (436,1,'TROY','QUIGLEY','TROY.QUIGLEY@sakilacustomer.org',441,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (437,2,'RANDALL','NEUMANN','RANDALL.NEUMANN@sakilacustomer.org',442,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (438,1,'BARRY','LOVELACE','BARRY.LOVELACE@sakilacustomer.org',443,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (439,2,'ALEXANDER','FENNELL','ALEXANDER.FENNELL@sakilacustomer.org',444,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (440,1,'BERNARD','COLBY','BERNARD.COLBY@sakilacustomer.org',445,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (441,1,'MARIO','CHEATHAM','MARIO.CHEATHAM@sakilacustomer.org',446,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (442,1,'LEROY','BUSTAMANTE','LEROY.BUSTAMANTE@sakilacustomer.org',447,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (443,2,'FRANCISCO','SKIDMORE','FRANCISCO.SKIDMORE@sakilacustomer.org',448,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (444,2,'MARCUS','HIDALGO','MARCUS.HIDALGO@sakilacustomer.org',449,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (445,1,'MICHEAL','FORMAN','MICHEAL.FORMAN@sakilacustomer.org',450,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (446,2,'THEODORE','CULP','THEODORE.CULP@sakilacustomer.org',451,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (447,1,'CLIFFORD','BOWENS','CLIFFORD.BOWENS@sakilacustomer.org',452,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (448,1,'MIGUEL','BETANCOURT','MIGUEL.BETANCOURT@sakilacustomer.org',453,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (449,2,'OSCAR','AQUINO','OSCAR.AQUINO@sakilacustomer.org',454,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (450,1,'JAY','ROBB','JAY.ROBB@sakilacustomer.org',455,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (451,1,'JIM','REA','JIM.REA@sakilacustomer.org',456,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (452,1,'TOM','MILNER','TOM.MILNER@sakilacustomer.org',457,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (453,1,'CALVIN','MARTEL','CALVIN.MARTEL@sakilacustomer.org',458,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (454,2,'ALEX','GRESHAM','ALEX.GRESHAM@sakilacustomer.org',459,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (455,2,'JON','WILES','JON.WILES@sakilacustomer.org',460,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (456,2,'RONNIE','RICKETTS','RONNIE.RICKETTS@sakilacustomer.org',461,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (457,2,'BILL','GAVIN','BILL.GAVIN@sakilacustomer.org',462,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (458,1,'LLOYD','DOWD','LLOYD.DOWD@sakilacustomer.org',463,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (459,1,'TOMMY','COLLAZO','TOMMY.COLLAZO@sakilacustomer.org',464,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (460,1,'LEON','BOSTIC','LEON.BOSTIC@sakilacustomer.org',465,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (461,1,'DEREK','BLAKELY','DEREK.BLAKELY@sakilacustomer.org',466,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (462,2,'WARREN','SHERROD','WARREN.SHERROD@sakilacustomer.org',467,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (463,2,'DARRELL','POWER','DARRELL.POWER@sakilacustomer.org',468,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (464,1,'JEROME','KENYON','JEROME.KENYON@sakilacustomer.org',469,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (465,1,'FLOYD','GANDY','FLOYD.GANDY@sakilacustomer.org',470,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (466,1,'LEO','EBERT','LEO.EBERT@sakilacustomer.org',471,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (467,2,'ALVIN','DELOACH','ALVIN.DELOACH@sakilacustomer.org',472,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (468,1,'TIM','CARY','TIM.CARY@sakilacustomer.org',473,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (469,2,'WESLEY','BULL','WESLEY.BULL@sakilacustomer.org',474,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (470,1,'GORDON','ALLARD','GORDON.ALLARD@sakilacustomer.org',475,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (471,1,'DEAN','SAUER','DEAN.SAUER@sakilacustomer.org',476,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (472,1,'GREG','ROBINS','GREG.ROBINS@sakilacustomer.org',477,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (473,2,'JORGE','OLIVARES','JORGE.OLIVARES@sakilacustomer.org',478,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (474,2,'DUSTIN','GILLETTE','DUSTIN.GILLETTE@sakilacustomer.org',479,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (475,2,'PEDRO','CHESTNUT','PEDRO.CHESTNUT@sakilacustomer.org',480,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (476,1,'DERRICK','BOURQUE','DERRICK.BOURQUE@sakilacustomer.org',481,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (477,1,'DAN','PAINE','DAN.PAINE@sakilacustomer.org',482,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (478,1,'LEWIS','LYMAN','LEWIS.LYMAN@sakilacustomer.org',483,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (479,1,'ZACHARY','HITE','ZACHARY.HITE@sakilacustomer.org',484,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (480,1,'COREY','HAUSER','COREY.HAUSER@sakilacustomer.org',485,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (481,1,'HERMAN','DEVORE','HERMAN.DEVORE@sakilacustomer.org',486,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (482,1,'MAURICE','CRAWLEY','MAURICE.CRAWLEY@sakilacustomer.org',487,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (483,2,'VERNON','CHAPA','VERNON.CHAPA@sakilacustomer.org',488,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (484,1,'ROBERTO','VU','ROBERTO.VU@sakilacustomer.org',489,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (485,1,'CLYDE','TOBIAS','CLYDE.TOBIAS@sakilacustomer.org',490,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (486,1,'GLEN','TALBERT','GLEN.TALBERT@sakilacustomer.org',491,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (487,2,'HECTOR','POINDEXTER','HECTOR.POINDEXTER@sakilacustomer.org',492,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (488,2,'SHANE','MILLARD','SHANE.MILLARD@sakilacustomer.org',493,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (489,1,'RICARDO','MEADOR','RICARDO.MEADOR@sakilacustomer.org',494,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (490,1,'SAM','MCDUFFIE','SAM.MCDUFFIE@sakilacustomer.org',495,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (491,2,'RICK','MATTOX','RICK.MATTOX@sakilacustomer.org',496,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (492,2,'LESTER','KRAUS','LESTER.KRAUS@sakilacustomer.org',497,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (493,1,'BRENT','HARKINS','BRENT.HARKINS@sakilacustomer.org',498,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (494,2,'RAMON','CHOATE','RAMON.CHOATE@sakilacustomer.org',499,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (495,2,'CHARLIE','BESS','CHARLIE.BESS@sakilacustomer.org',500,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (496,2,'TYLER','WREN','TYLER.WREN@sakilacustomer.org',501,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (497,2,'GILBERT','SLEDGE','GILBERT.SLEDGE@sakilacustomer.org',502,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (498,1,'GENE','SANBORN','GENE.SANBORN@sakilacustomer.org',503,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (499,2,'MARC','OUTLAW','MARC.OUTLAW@sakilacustomer.org',504,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (500,1,'REGINALD','KINDER','REGINALD.KINDER@sakilacustomer.org',505,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (501,1,'RUBEN','GEARY','RUBEN.GEARY@sakilacustomer.org',506,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (502,1,'BRETT','CORNWELL','BRETT.CORNWELL@sakilacustomer.org',507,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (503,1,'ANGEL','BARCLAY','ANGEL.BARCLAY@sakilacustomer.org',508,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (504,1,'NATHANIEL','ADAM','NATHANIEL.ADAM@sakilacustomer.org',509,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (505,1,'RAFAEL','ABNEY','RAFAEL.ABNEY@sakilacustomer.org',510,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (506,2,'LESLIE','SEWARD','LESLIE.SEWARD@sakilacustomer.org',511,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (507,2,'EDGAR','RHOADS','EDGAR.RHOADS@sakilacustomer.org',512,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (508,2,'MILTON','HOWLAND','MILTON.HOWLAND@sakilacustomer.org',513,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (509,1,'RAUL','FORTIER','RAUL.FORTIER@sakilacustomer.org',514,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (510,2,'BEN','EASTER','BEN.EASTER@sakilacustomer.org',515,0,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (511,1,'CHESTER','BENNER','CHESTER.BENNER@sakilacustomer.org',516,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (512,1,'CECIL','VINES','CECIL.VINES@sakilacustomer.org',517,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (513,2,'DUANE','TUBBS','DUANE.TUBBS@sakilacustomer.org',519,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (514,2,'FRANKLIN','TROUTMAN','FRANKLIN.TROUTMAN@sakilacustomer.org',520,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (515,1,'ANDRE','RAPP','ANDRE.RAPP@sakilacustomer.org',521,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (516,2,'ELMER','NOE','ELMER.NOE@sakilacustomer.org',522,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (517,2,'BRAD','MCCURDY','BRAD.MCCURDY@sakilacustomer.org',523,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (518,1,'GABRIEL','HARDER','GABRIEL.HARDER@sakilacustomer.org',524,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (519,2,'RON','DELUCA','RON.DELUCA@sakilacustomer.org',525,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (520,2,'MITCHELL','WESTMORELAND','MITCHELL.WESTMORELAND@sakilacustomer.org',526,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (521,2,'ROLAND','SOUTH','ROLAND.SOUTH@sakilacustomer.org',527,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (522,2,'ARNOLD','HAVENS','ARNOLD.HAVENS@sakilacustomer.org',528,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (523,1,'HARVEY','GUAJARDO','HARVEY.GUAJARDO@sakilacustomer.org',529,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (524,1,'JARED','ELY','JARED.ELY@sakilacustomer.org',530,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (525,2,'ADRIAN','CLARY','ADRIAN.CLARY@sakilacustomer.org',531,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (526,2,'KARL','SEAL','KARL.SEAL@sakilacustomer.org',532,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (527,1,'CORY','MEEHAN','CORY.MEEHAN@sakilacustomer.org',533,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (528,1,'CLAUDE','HERZOG','CLAUDE.HERZOG@sakilacustomer.org',534,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (529,2,'ERIK','GUILLEN','ERIK.GUILLEN@sakilacustomer.org',535,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (530,2,'DARRYL','ASHCRAFT','DARRYL.ASHCRAFT@sakilacustomer.org',536,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (531,2,'JAMIE','WAUGH','JAMIE.WAUGH@sakilacustomer.org',537,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (532,2,'NEIL','RENNER','NEIL.RENNER@sakilacustomer.org',538,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (533,1,'JESSIE','MILAM','JESSIE.MILAM@sakilacustomer.org',539,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (534,1,'CHRISTIAN','JUNG','CHRISTIAN.JUNG@sakilacustomer.org',540,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (535,1,'JAVIER','ELROD','JAVIER.ELROD@sakilacustomer.org',541,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (536,2,'FERNANDO','CHURCHILL','FERNANDO.CHURCHILL@sakilacustomer.org',542,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (537,2,'CLINTON','BUFORD','CLINTON.BUFORD@sakilacustomer.org',543,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (538,2,'TED','BREAUX','TED.BREAUX@sakilacustomer.org',544,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (539,1,'MATHEW','BOLIN','MATHEW.BOLIN@sakilacustomer.org',545,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (540,1,'TYRONE','ASHER','TYRONE.ASHER@sakilacustomer.org',546,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (541,2,'DARREN','WINDHAM','DARREN.WINDHAM@sakilacustomer.org',547,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (542,2,'LONNIE','TIRADO','LONNIE.TIRADO@sakilacustomer.org',548,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (543,1,'LANCE','PEMBERTON','LANCE.PEMBERTON@sakilacustomer.org',549,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (544,2,'CODY','NOLEN','CODY.NOLEN@sakilacustomer.org',550,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (545,2,'JULIO','NOLAND','JULIO.NOLAND@sakilacustomer.org',551,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (546,1,'KELLY','KNOTT','KELLY.KNOTT@sakilacustomer.org',552,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (547,1,'KURT','EMMONS','KURT.EMMONS@sakilacustomer.org',553,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (548,1,'ALLAN','CORNISH','ALLAN.CORNISH@sakilacustomer.org',554,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (549,1,'NELSON','CHRISTENSON','NELSON.CHRISTENSON@sakilacustomer.org',555,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (550,2,'GUY','BROWNLEE','GUY.BROWNLEE@sakilacustomer.org',556,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (551,2,'CLAYTON','BARBEE','CLAYTON.BARBEE@sakilacustomer.org',557,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (552,2,'HUGH','WALDROP','HUGH.WALDROP@sakilacustomer.org',558,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (553,1,'MAX','PITT','MAX.PITT@sakilacustomer.org',559,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (554,1,'DWAYNE','OLVERA','DWAYNE.OLVERA@sakilacustomer.org',560,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (555,1,'DWIGHT','LOMBARDI','DWIGHT.LOMBARDI@sakilacustomer.org',561,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (556,2,'ARMANDO','GRUBER','ARMANDO.GRUBER@sakilacustomer.org',562,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (557,1,'FELIX','GAFFNEY','FELIX.GAFFNEY@sakilacustomer.org',563,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (558,1,'JIMMIE','EGGLESTON','JIMMIE.EGGLESTON@sakilacustomer.org',564,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (559,2,'EVERETT','BANDA','EVERETT.BANDA@sakilacustomer.org',565,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (560,1,'JORDAN','ARCHULETA','JORDAN.ARCHULETA@sakilacustomer.org',566,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (561,2,'IAN','STILL','IAN.STILL@sakilacustomer.org',567,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (562,1,'WALLACE','SLONE','WALLACE.SLONE@sakilacustomer.org',568,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (563,2,'KEN','PREWITT','KEN.PREWITT@sakilacustomer.org',569,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (564,2,'BOB','PFEIFFER','BOB.PFEIFFER@sakilacustomer.org',570,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (565,2,'JAIME','NETTLES','JAIME.NETTLES@sakilacustomer.org',571,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (566,1,'CASEY','MENA','CASEY.MENA@sakilacustomer.org',572,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (567,2,'ALFREDO','MCADAMS','ALFREDO.MCADAMS@sakilacustomer.org',573,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (568,2,'ALBERTO','HENNING','ALBERTO.HENNING@sakilacustomer.org',574,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (569,2,'DAVE','GARDINER','DAVE.GARDINER@sakilacustomer.org',575,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (570,2,'IVAN','CROMWELL','IVAN.CROMWELL@sakilacustomer.org',576,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (571,2,'JOHNNIE','CHISHOLM','JOHNNIE.CHISHOLM@sakilacustomer.org',577,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (572,1,'SIDNEY','BURLESON','SIDNEY.BURLESON@sakilacustomer.org',578,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (573,1,'BYRON','BOX','BYRON.BOX@sakilacustomer.org',579,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (574,2,'JULIAN','VEST','JULIAN.VEST@sakilacustomer.org',580,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (575,2,'ISAAC','OGLESBY','ISAAC.OGLESBY@sakilacustomer.org',581,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (576,2,'MORRIS','MCCARTER','MORRIS.MCCARTER@sakilacustomer.org',582,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (577,2,'CLIFTON','MALCOLM','CLIFTON.MALCOLM@sakilacustomer.org',583,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (578,2,'WILLARD','LUMPKIN','WILLARD.LUMPKIN@sakilacustomer.org',584,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (579,2,'DARYL','LARUE','DARYL.LARUE@sakilacustomer.org',585,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (580,1,'ROSS','GREY','ROSS.GREY@sakilacustomer.org',586,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (581,1,'VIRGIL','WOFFORD','VIRGIL.WOFFORD@sakilacustomer.org',587,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (582,2,'ANDY','VANHORN','ANDY.VANHORN@sakilacustomer.org',588,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (583,1,'MARSHALL','THORN','MARSHALL.THORN@sakilacustomer.org',589,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (584,2,'SALVADOR','TEEL','SALVADOR.TEEL@sakilacustomer.org',590,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (585,1,'PERRY','SWAFFORD','PERRY.SWAFFORD@sakilacustomer.org',591,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (586,1,'KIRK','STCLAIR','KIRK.STCLAIR@sakilacustomer.org',592,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (587,1,'SERGIO','STANFIELD','SERGIO.STANFIELD@sakilacustomer.org',593,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (588,1,'MARION','OCAMPO','MARION.OCAMPO@sakilacustomer.org',594,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (589,1,'TRACY','HERRMANN','TRACY.HERRMANN@sakilacustomer.org',595,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (590,2,'SETH','HANNON','SETH.HANNON@sakilacustomer.org',596,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
INSERT INTO `sakila`.`customer` VALUES  (591,1,'KENT','ARSENAULT','KENT.ARSENAULT@sakilacustomer.org',597,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (592,1,'TERRANCE','ROUSH','TERRANCE.ROUSH@sakilacustomer.org',598,0,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (593,2,'RENE','MCALISTER','RENE.MCALISTER@sakilacustomer.org',599,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (594,1,'EDUARDO','HIATT','EDUARDO.HIATT@sakilacustomer.org',600,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (595,1,'TERRENCE','GUNDERSON','TERRENCE.GUNDERSON@sakilacustomer.org',601,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (596,1,'ENRIQUE','FORSYTHE','ENRIQUE.FORSYTHE@sakilacustomer.org',602,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (597,1,'FREDDIE','DUGGAN','FREDDIE.DUGGAN@sakilacustomer.org',603,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (598,1,'WADE','DELVALLE','WADE.DELVALLE@sakilacustomer.org',604,1,'2006-02-14 22:04:37','2006-02-15 04:57:20'),
 (599,2,'AUSTIN','CINTRON','AUSTIN.CINTRON@sakilacustomer.org',605,1,'2006-02-14 22:04:37','2006-02-15 04:57:20');
COMMIT;

--
-- Definition of trigger `sakila`.`customer`
--

DROP TRIGGER IF EXISTS `sakila`.`customer`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`customer_create_date` BEFORE INSERT ON `customer` FOR EACH ROW SET NEW.create_date = NOW() $$

DELIMITER ;

--
-- Definition of table `sakila`.`film`
--

DROP TABLE IF EXISTS `sakila`.`film`;
CREATE TABLE  `sakila`.`film` (
  `film_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text,
  `release_year` year(4) DEFAULT NULL,
  `language_id` tinyint(3) unsigned NOT NULL,
  `original_language_id` tinyint(3) unsigned DEFAULT NULL,
  `rental_duration` tinyint(3) unsigned NOT NULL DEFAULT '3',
  `rental_rate` decimal(4,2) NOT NULL DEFAULT '4.99',
  `length` smallint(5) unsigned DEFAULT NULL,
  `replacement_cost` decimal(5,2) NOT NULL DEFAULT '19.99',
  `rating` enum('G','PG','PG-13','R','NC-17') DEFAULT 'G',
  `special_features` set('Trailers','Commentaries','Deleted Scenes','Behind the Scenes') DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`film_id`),
  KEY `idx_title` (`title`),
  KEY `idx_fk_language_id` (`language_id`),
  KEY `idx_fk_original_language_id` (`original_language_id`),
  CONSTRAINT `fk_film_language` FOREIGN KEY (`language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_film_language_original` FOREIGN KEY (`original_language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`film`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`film` VALUES  (1,'ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,1,NULL,6,'0.99',86,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (2,'ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China',2006,1,NULL,3,'4.99',48,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (3,'ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory',2006,1,NULL,7,'2.99',50,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (4,'AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank',2006,1,NULL,5,'2.99',117,'26.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (5,'AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',130,'22.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (6,'AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China',2006,1,NULL,3,'2.99',169,'17.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (7,'AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat',2006,1,NULL,6,'4.99',62,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (8,'AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India',2006,1,NULL,6,'4.99',54,'15.99','R','Trailers','2006-02-15 05:03:42'),
 (9,'ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat',2006,1,NULL,3,'2.99',114,'21.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (10,'ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China',2006,1,NULL,6,'4.99',63,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (11,'ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention',2006,1,NULL,6,'0.99',126,'16.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (12,'ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia',2006,1,NULL,6,'0.99',136,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (13,'ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies',2006,1,NULL,4,'4.99',150,'21.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (14,'ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia',2006,1,NULL,6,'0.99',94,'23.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (15,'ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention',2006,1,NULL,5,'2.99',46,'10.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (16,'ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans',2006,1,NULL,6,'2.99',180,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (17,'ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House',2006,1,NULL,3,'0.99',82,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (18,'ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies',2006,1,NULL,6,'0.99',57,'27.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (19,'AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon',2006,1,NULL,6,'0.99',113,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (20,'AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon',2006,1,NULL,4,'4.99',79,'23.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (21,'AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank',2006,1,NULL,3,'4.99',129,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (22,'AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California',2006,1,NULL,6,'2.99',85,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (23,'ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia',2006,1,NULL,3,'0.99',92,'9.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (24,'ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert',2006,1,NULL,6,'2.99',181,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (25,'ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin',2006,1,NULL,3,'2.99',74,'15.99','G','Trailers','2006-02-15 05:03:42'),
 (26,'ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',86,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (27,'ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank',2006,1,NULL,7,'0.99',179,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (28,'ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park',2006,1,NULL,5,'4.99',91,'16.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (29,'ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India',2006,1,NULL,5,'2.99',168,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (30,'ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House',2006,1,NULL,4,'2.99',82,'27.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (31,'APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat',2006,1,NULL,5,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (32,'APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',119,'11.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (33,'APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',153,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (34,'ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria',2006,1,NULL,6,'0.99',62,'29.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (35,'ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',147,'24.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (36,'ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',127,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (37,'ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery',2006,1,NULL,3,'2.99',121,'28.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (38,'ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert',2006,1,NULL,6,'0.99',68,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (39,'ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,5,'0.99',99,'10.99','G','Trailers','2006-02-15 05:03:42'),
 (40,'ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria',2006,1,NULL,4,'0.99',148,'22.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (41,'ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin',2006,1,NULL,4,'0.99',137,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (42,'ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California',2006,1,NULL,5,'2.99',170,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (43,'ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank',2006,1,NULL,6,'2.99',170,'15.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (44,'ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',113,'21.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (45,'ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan',2006,1,NULL,5,'4.99',83,'14.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (46,'AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert',2006,1,NULL,3,'4.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (47,'BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',153,'23.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (48,'BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery',2006,1,NULL,3,'4.99',118,'24.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (49,'BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,6,'2.99',162,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (50,'BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery',2006,1,NULL,3,'2.99',182,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (51,'BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station',2006,1,NULL,5,'2.99',75,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (52,'BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California',2006,1,NULL,6,'0.99',173,'29.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (53,'BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',87,'25.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (54,'BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station',2006,1,NULL,5,'0.99',113,'15.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (55,'BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery',2006,1,NULL,6,'2.99',65,'27.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (56,'BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',129,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (57,'BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat',2006,1,NULL,4,'2.99',90,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (58,'BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia',2006,1,NULL,6,'2.99',122,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (59,'BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station',2006,1,NULL,4,'2.99',160,'20.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (60,'BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China',2006,1,NULL,3,'4.99',89,'22.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (61,'BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',175,'28.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (62,'BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House',2006,1,NULL,5,'2.99',106,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (63,'BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House',2006,1,NULL,6,'0.99',73,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (64,'BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico',2006,1,NULL,6,'0.99',151,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (65,'BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'4.99',100,'20.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (66,'BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station',2006,1,NULL,6,'0.99',53,'27.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (67,'BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China',2006,1,NULL,5,'2.99',77,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (68,'BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank',2006,1,NULL,5,'4.99',122,'26.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (69,'BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station',2006,1,NULL,3,'2.99',85,'21.99','R','Trailers','2006-02-15 05:03:42'),
 (70,'BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station',2006,1,NULL,7,'4.99',142,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (71,'BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station',2006,1,NULL,3,'4.99',100,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (72,'BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention',2006,1,NULL,6,'2.99',93,'12.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (73,'BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria',2006,1,NULL,5,'2.99',150,'22.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (74,'BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon',2006,1,NULL,4,'4.99',162,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (75,'BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies',2006,1,NULL,6,'4.99',163,'14.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (76,'BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India',2006,1,NULL,4,'0.99',103,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (77,'BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California',2006,1,NULL,5,'4.99',61,'15.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (78,'BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan',2006,1,NULL,7,'2.99',85,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (79,'BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station',2006,1,NULL,5,'0.99',114,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (80,'BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria',2006,1,NULL,7,'2.99',148,'21.99','G','Trailers','2006-02-15 05:03:42'),
 (81,'BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat',2006,1,NULL,6,'4.99',103,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (82,'BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse',2006,1,NULL,3,'0.99',71,'13.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (83,'BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House',2006,1,NULL,5,'2.99',50,'18.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (84,'BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan',2006,1,NULL,7,'4.99',102,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (85,'BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan',2006,1,NULL,4,'0.99',63,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (86,'BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico',2006,1,NULL,6,'4.99',121,'11.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (87,'BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico',2006,1,NULL,7,'0.99',76,'14.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (88,'BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria',2006,1,NULL,7,'4.99',179,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (89,'BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House',2006,1,NULL,7,'0.99',63,'22.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (90,'BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China',2006,1,NULL,3,'0.99',63,'11.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (91,'BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon',2006,1,NULL,5,'0.99',98,'17.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (92,'BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California',2006,1,NULL,7,'4.99',72,'19.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (93,'BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin',2006,1,NULL,4,'4.99',121,'27.99','PG','Trailers','2006-02-15 05:03:42'),
 (94,'BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin',2006,1,NULL,7,'2.99',176,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (95,'BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin',2006,1,NULL,5,'4.99',123,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (96,'BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',169,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (97,'BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans',2006,1,NULL,7,'0.99',56,'24.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (98,'BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat',2006,1,NULL,4,'4.99',73,'12.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (99,'BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat',2006,1,NULL,7,'2.99',136,'14.99','PG','Trailers','2006-02-15 05:03:42'),
 (100,'BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'4.99',161,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (101,'BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan',2006,1,NULL,3,'0.99',73,'26.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (102,'BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon',2006,1,NULL,4,'4.99',60,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (103,'BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory',2006,1,NULL,7,'4.99',133,'27.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (104,'BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station',2006,1,NULL,4,'2.99',119,'17.99','G','Commentaries','2006-02-15 05:03:42'),
 (105,'BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies',2006,1,NULL,6,'0.99',125,'21.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (106,'BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback',2006,1,NULL,4,'2.99',61,'14.99','G','Trailers','2006-02-15 05:03:42'),
 (107,'BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention',2006,1,NULL,4,'2.99',63,'13.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (108,'BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans',2006,1,NULL,6,'0.99',67,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (109,'BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank',2006,1,NULL,3,'0.99',89,'17.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (110,'CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory',2006,1,NULL,4,'0.99',53,'25.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (111,'CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia',2006,1,NULL,3,'0.99',52,'17.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (112,'CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria',2006,1,NULL,4,'4.99',120,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (113,'CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India',2006,1,NULL,4,'4.99',75,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (114,'CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',61,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (115,'CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat',2006,1,NULL,5,'2.99',167,'27.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (116,'CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',70,'10.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (117,'CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House',2006,1,NULL,6,'4.99',135,'15.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (118,'CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse',2006,1,NULL,7,'0.99',85,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (119,'CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention',2006,1,NULL,6,'0.99',176,'22.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (120,'CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank',2006,1,NULL,3,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (121,'CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery',2006,1,NULL,4,'2.99',151,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (122,'CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies',2006,1,NULL,7,'0.99',114,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (123,'CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station',2006,1,NULL,6,'4.99',85,'22.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (124,'CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',163,'16.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (125,'CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans',2006,1,NULL,5,'2.99',61,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (126,'CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery',2006,1,NULL,3,'4.99',179,'16.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (127,'CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India',2006,1,NULL,5,'4.99',112,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (128,'CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria',2006,1,NULL,7,'0.99',183,'10.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (129,'CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention',2006,1,NULL,3,'2.99',179,'16.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (130,'CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank',2006,1,NULL,7,'0.99',110,'24.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (131,'CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California',2006,1,NULL,5,'4.99',152,'12.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (132,'CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia',2006,1,NULL,6,'0.99',114,'25.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (133,'CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria',2006,1,NULL,7,'4.99',117,'14.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (134,'CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery',2006,1,NULL,4,'4.99',51,'21.99','PG','Trailers','2006-02-15 05:03:42'),
 (135,'CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China',2006,1,NULL,3,'2.99',70,'22.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (136,'CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India',2006,1,NULL,7,'2.99',146,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (137,'CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention',2006,1,NULL,3,'2.99',66,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (138,'CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station',2006,1,NULL,5,'2.99',71,'29.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (139,'CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank',2006,1,NULL,7,'4.99',114,'21.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (140,'CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan',2006,1,NULL,6,'0.99',87,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (141,'CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California',2006,1,NULL,6,'4.99',185,'11.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (142,'CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia',2006,1,NULL,3,'0.99',122,'24.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (143,'CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies',2006,1,NULL,6,'0.99',142,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (144,'CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India',2006,1,NULL,7,'4.99',61,'24.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (145,'CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India',2006,1,NULL,5,'4.99',124,'25.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (146,'CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,6,'2.99',107,'24.99','G','Commentaries','2006-02-15 05:03:42'),
 (147,'CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan',2006,1,NULL,5,'0.99',101,'16.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (148,'CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China',2006,1,NULL,3,'2.99',132,'13.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (149,'CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse',2006,1,NULL,7,'0.99',150,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (150,'CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia',2006,1,NULL,7,'2.99',101,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (151,'CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin',2006,1,NULL,5,'4.99',143,'26.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (152,'CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon',2006,1,NULL,5,'2.99',90,'13.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (153,'CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback',2006,1,NULL,7,'0.99',165,'18.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (154,'CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia',2006,1,NULL,6,'2.99',81,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (155,'CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon',2006,1,NULL,6,'0.99',150,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (156,'CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon',2006,1,NULL,3,'4.99',164,'15.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (157,'CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon',2006,1,NULL,7,'0.99',143,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (158,'CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans',2006,1,NULL,6,'2.99',124,'16.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (159,'CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India',2006,1,NULL,5,'4.99',58,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (160,'CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat',2006,1,NULL,4,'0.99',65,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (161,'CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China',2006,1,NULL,6,'4.99',70,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (162,'CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'2.99',95,'13.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (163,'CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat',2006,1,NULL,4,'0.99',139,'29.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (164,'COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert',2006,1,NULL,4,'0.99',55,'20.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (165,'COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',70,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (166,'COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert',2006,1,NULL,6,'2.99',149,'19.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (167,'COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California',2006,1,NULL,6,'4.99',109,'10.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (168,'COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico',2006,1,NULL,5,'0.99',67,'23.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (169,'COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft',2006,1,NULL,3,'2.99',76,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (170,'COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan',2006,1,NULL,5,'4.99',120,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (171,'COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',59,'13.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (172,'CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria',2006,1,NULL,7,'4.99',112,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (173,'CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon',2006,1,NULL,7,'4.99',65,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (174,'CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan',2006,1,NULL,6,'4.99',180,'13.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (175,'CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon',2006,1,NULL,3,'2.99',122,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (176,'CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon',2006,1,NULL,6,'0.99',87,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (177,'CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank',2006,1,NULL,4,'4.99',172,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (178,'CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station',2006,1,NULL,6,'0.99',115,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (179,'CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',173,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (180,'CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',184,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (181,'CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India',2006,1,NULL,7,'2.99',166,'10.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (182,'CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery',2006,1,NULL,7,'4.99',185,'9.99','G','Commentaries','2006-02-15 05:03:42'),
 (183,'CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention',2006,1,NULL,4,'4.99',112,'14.99','R','Commentaries','2006-02-15 05:03:42'),
 (184,'CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse',2006,1,NULL,3,'2.99',92,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (185,'COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon',2006,1,NULL,3,'2.99',146,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (186,'CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory',2006,1,NULL,6,'0.99',64,'17.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (187,'CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory',2006,1,NULL,5,'2.99',57,'12.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (188,'CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback',2006,1,NULL,7,'2.99',136,'24.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (189,'CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India',2006,1,NULL,3,'0.99',139,'23.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (190,'CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat',2006,1,NULL,5,'4.99',172,'23.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (191,'CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',143,'27.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (192,'CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin',2006,1,NULL,4,'4.99',50,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (193,'CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback',2006,1,NULL,5,'2.99',153,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (194,'CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station',2006,1,NULL,6,'0.99',104,'22.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (195,'CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',112,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (196,'CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria',2006,1,NULL,7,'0.99',69,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (197,'CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',112,'27.99','R','Commentaries','2006-02-15 05:03:42'),
 (198,'CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan',2006,1,NULL,6,'2.99',184,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (199,'CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',56,'29.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (200,'CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank',2006,1,NULL,7,'0.99',133,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (201,'CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention',2006,1,NULL,7,'2.99',176,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (202,'DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico',2006,1,NULL,5,'4.99',161,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (203,'DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India',2006,1,NULL,5,'4.99',84,'9.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (204,'DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse',2006,1,NULL,4,'0.99',106,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (205,'DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',58,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (206,'DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank',2006,1,NULL,6,'0.99',144,'25.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (207,'DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California',2006,1,NULL,7,'4.99',121,'26.99','PG','Commentaries','2006-02-15 05:03:42'),
 (208,'DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans',2006,1,NULL,7,'2.99',89,'16.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (209,'DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert',2006,1,NULL,6,'2.99',99,'24.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (210,'DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans',2006,1,NULL,3,'4.99',130,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (211,'DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',165,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (212,'DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat',2006,1,NULL,7,'4.99',185,'14.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (213,'DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention',2006,1,NULL,4,'0.99',104,'19.99','R','Commentaries','2006-02-15 05:03:42'),
 (214,'DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station',2006,1,NULL,3,'4.99',59,'13.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (215,'DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin',2006,1,NULL,4,'4.99',57,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (216,'DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat',2006,1,NULL,3,'4.99',113,'16.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (217,'DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',120,'20.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (218,'DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India',2006,1,NULL,7,'0.99',122,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (219,'DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia',2006,1,NULL,6,'4.99',51,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (220,'DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia',2006,1,NULL,7,'2.99',106,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (221,'DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank',2006,1,NULL,4,'0.99',100,'9.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (222,'DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans',2006,1,NULL,4,'4.99',64,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (223,'DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station',2006,1,NULL,7,'2.99',76,'24.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (224,'DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California',2006,1,NULL,7,'4.99',81,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (225,'DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat',2006,1,NULL,3,'0.99',76,'19.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (226,'DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia',2006,1,NULL,4,'4.99',56,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (227,'DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat',2006,1,NULL,4,'4.99',88,'17.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (228,'DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan',2006,1,NULL,4,'0.99',143,'16.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (229,'DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan',2006,1,NULL,6,'4.99',87,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (230,'DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India',2006,1,NULL,7,'2.99',107,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (231,'DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies',2006,1,NULL,7,'2.99',63,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (232,'DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback',2006,1,NULL,7,'2.99',147,'29.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (233,'DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank',2006,1,NULL,3,'0.99',141,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (234,'DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat',2006,1,NULL,6,'2.99',94,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (235,'DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery',2006,1,NULL,6,'2.99',68,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (236,'DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',100,'19.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (237,'DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India',2006,1,NULL,3,'2.99',47,'21.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (238,'DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback',2006,1,NULL,4,'2.99',57,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (239,'DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans',2006,1,NULL,5,'4.99',122,'16.99','G','Commentaries','2006-02-15 05:03:42'),
 (240,'DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback',2006,1,NULL,7,'2.99',120,'10.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (241,'DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan',2006,1,NULL,4,'0.99',125,'20.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (242,'DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention',2006,1,NULL,4,'0.99',68,'13.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (243,'DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,3,'4.99',49,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (244,'DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California',2006,1,NULL,5,'4.99',139,'26.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (245,'DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'0.99',177,'28.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (246,'DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert',2006,1,NULL,5,'4.99',154,'16.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (247,'DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert',2006,1,NULL,3,'0.99',47,'19.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (248,'DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',177,'20.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (249,'DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,7,'0.99',176,'26.99','G','Commentaries','2006-02-15 05:03:42'),
 (250,'DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China',2006,1,NULL,4,'0.99',170,'26.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (251,'DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria',2006,1,NULL,6,'4.99',133,'19.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (252,'DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',135,'18.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (253,'DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat',2006,1,NULL,5,'4.99',61,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (254,'DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House',2006,1,NULL,4,'2.99',159,'11.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (255,'DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',175,'21.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (256,'DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China',2006,1,NULL,6,'4.99',178,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (257,'DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies',2006,1,NULL,3,'0.99',110,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (258,'DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',96,'11.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (259,'DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank',2006,1,NULL,4,'2.99',116,'15.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (260,'DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',132,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (261,'DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention',2006,1,NULL,5,'0.99',171,'13.99','G','Commentaries','2006-02-15 05:03:42'),
 (262,'DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico',2006,1,NULL,5,'0.99',119,'17.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (263,'DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',154,'14.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (264,'DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan',2006,1,NULL,6,'2.99',101,'13.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (265,'DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California',2006,1,NULL,5,'4.99',168,'28.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (266,'DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat',2006,1,NULL,4,'0.99',141,'27.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (267,'EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert',2006,1,NULL,4,'4.99',140,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (268,'EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback',2006,1,NULL,6,'4.99',96,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (269,'EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria',2006,1,NULL,3,'0.99',98,'22.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (270,'EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India',2006,1,NULL,7,'0.99',85,'29.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (271,'EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India',2006,1,NULL,5,'4.99',148,'12.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (272,'EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat',2006,1,NULL,5,'4.99',153,'9.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (273,'EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',107,'14.99','PG','Commentaries','2006-02-15 05:03:42'),
 (274,'EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station',2006,1,NULL,4,'2.99',67,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (275,'EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',85,'11.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (276,'ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat',2006,1,NULL,6,'4.99',115,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (277,'ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon',2006,1,NULL,4,'4.99',126,'24.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (278,'ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',155,'19.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (279,'ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan',2006,1,NULL,7,'4.99',152,'11.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (280,'EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House',2006,1,NULL,7,'0.99',177,'26.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (281,'ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon',2006,1,NULL,6,'0.99',143,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (282,'ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans',2006,1,NULL,5,'0.99',92,'20.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (283,'ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin',2006,1,NULL,6,'0.99',85,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (284,'ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India',2006,1,NULL,5,'4.99',77,'23.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (285,'ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China',2006,1,NULL,3,'0.99',51,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (286,'ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert',2006,1,NULL,7,'2.99',158,'16.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (287,'ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat',2006,1,NULL,5,'0.99',176,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (288,'ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans',2006,1,NULL,7,'2.99',167,'20.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (289,'EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon',2006,1,NULL,5,'4.99',66,'25.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (290,'EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria',2006,1,NULL,4,'0.99',163,'29.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (291,'EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory',2006,1,NULL,5,'0.99',174,'10.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (292,'EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank',2006,1,NULL,3,'0.99',51,'20.99','G','Commentaries','2006-02-15 05:03:42'),
 (293,'EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin',2006,1,NULL,6,'2.99',167,'17.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (294,'EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat',2006,1,NULL,5,'4.99',138,'26.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (295,'EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat',2006,1,NULL,3,'0.99',97,'14.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (296,'EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California',2006,1,NULL,5,'2.99',178,'23.99','R','Trailers','2006-02-15 05:03:42'),
 (297,'EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin',2006,1,NULL,6,'2.99',122,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (298,'EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback',2006,1,NULL,4,'2.99',172,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (299,'FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert',2006,1,NULL,4,'0.99',144,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (300,'FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans',2006,1,NULL,5,'4.99',102,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (301,'FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin',2006,1,NULL,4,'0.99',155,'24.99','R','Trailers','2006-02-15 05:03:42'),
 (302,'FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia',2006,1,NULL,5,'2.99',131,'29.99','G','Commentaries','2006-02-15 05:03:42'),
 (303,'FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention',2006,1,NULL,6,'0.99',58,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (304,'FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback',2006,1,NULL,3,'2.99',130,'28.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (305,'FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan',2006,1,NULL,6,'2.99',91,'24.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (306,'FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia',2006,1,NULL,3,'0.99',104,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (307,'FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon',2006,1,NULL,6,'4.99',77,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (308,'FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico',2006,1,NULL,3,'2.99',142,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (309,'FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies',2006,1,NULL,6,'0.99',98,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (310,'FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico',2006,1,NULL,5,'4.99',158,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (311,'FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',72,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (312,'FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'4.99',75,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (313,'FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat',2006,1,NULL,5,'4.99',118,'11.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (314,'FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse',2006,1,NULL,3,'0.99',91,'13.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (315,'FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans',2006,1,NULL,4,'0.99',156,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (316,'FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria',2006,1,NULL,5,'4.99',173,'18.99','R','Trailers','2006-02-15 05:03:42'),
 (317,'FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',148,'25.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (318,'FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert',2006,1,NULL,7,'0.99',103,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (319,'FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia',2006,1,NULL,4,'2.99',125,'22.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (320,'FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert',2006,1,NULL,4,'4.99',80,'28.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (321,'FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico',2006,1,NULL,3,'4.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (322,'FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',100,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (323,'FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans',2006,1,NULL,7,'4.99',179,'22.99','R','Trailers','2006-02-15 05:03:42'),
 (324,'FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California',2006,1,NULL,3,'4.99',148,'11.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (325,'FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan',2006,1,NULL,6,'2.99',145,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (326,'FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria',2006,1,NULL,6,'2.99',69,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (327,'FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat',2006,1,NULL,3,'4.99',158,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (328,'FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat',2006,1,NULL,7,'2.99',131,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (329,'FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat',2006,1,NULL,4,'2.99',63,'15.99','R','Commentaries','2006-02-15 05:03:42'),
 (330,'FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria',2006,1,NULL,7,'4.99',112,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (331,'FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans',2006,1,NULL,6,'2.99',90,'25.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (332,'FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria',2006,1,NULL,7,'0.99',159,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (333,'FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico',2006,1,NULL,7,'2.99',126,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (334,'FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback',2006,1,NULL,6,'4.99',65,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (335,'FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon',2006,1,NULL,5,'0.99',133,'23.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (336,'FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin',2006,1,NULL,5,'4.99',99,'22.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (337,'FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',73,'11.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (338,'FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank',2006,1,NULL,6,'4.99',51,'23.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (339,'FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia',2006,1,NULL,5,'0.99',111,'17.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (340,'FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House',2006,1,NULL,6,'4.99',183,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (341,'FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention',2006,1,NULL,5,'0.99',82,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (342,'FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia',2006,1,NULL,7,'4.99',83,'28.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (343,'FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank',2006,1,NULL,6,'2.99',94,'14.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (344,'FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery',2006,1,NULL,3,'0.99',178,'28.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (345,'GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'0.99',161,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (346,'GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin',2006,1,NULL,4,'4.99',128,'13.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (347,'GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery',2006,1,NULL,7,'4.99',119,'17.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (348,'GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin',2006,1,NULL,7,'0.99',86,'9.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (349,'GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin',2006,1,NULL,4,'2.99',185,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (350,'GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback',2006,1,NULL,3,'4.99',80,'21.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (351,'GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico',2006,1,NULL,4,'2.99',106,'10.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (352,'GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention',2006,1,NULL,4,'0.99',176,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (353,'GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station',2006,1,NULL,6,'2.99',125,'22.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (354,'GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India',2006,1,NULL,6,'4.99',85,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (355,'GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin',2006,1,NULL,7,'0.99',101,'18.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (356,'GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies',2006,1,NULL,5,'2.99',102,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (357,'GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse',2006,1,NULL,7,'0.99',114,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (358,'GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat',2006,1,NULL,5,'0.99',163,'29.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (359,'GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan',2006,1,NULL,6,'4.99',173,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (360,'GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan',2006,1,NULL,4,'0.99',103,'24.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (361,'GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies',2006,1,NULL,5,'2.99',89,'25.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (362,'GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station',2006,1,NULL,7,'2.99',115,'13.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (363,'GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon',2006,1,NULL,3,'0.99',54,'12.99','R','Trailers','2006-02-15 05:03:42'),
 (364,'GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback',2006,1,NULL,3,'2.99',73,'14.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (365,'GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory',2006,1,NULL,4,'4.99',154,'21.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (366,'GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans',2006,1,NULL,3,'0.99',93,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (367,'GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback',2006,1,NULL,6,'0.99',153,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (368,'GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse',2006,1,NULL,7,'2.99',84,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (369,'GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory',2006,1,NULL,4,'4.99',56,'22.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (370,'GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory',2006,1,NULL,4,'2.99',108,'26.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (371,'GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin',2006,1,NULL,5,'4.99',129,'17.99','G','Commentaries','2006-02-15 05:03:42'),
 (372,'GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans',2006,1,NULL,5,'4.99',140,'26.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (373,'GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China',2006,1,NULL,7,'2.99',156,'14.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (374,'GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin',2006,1,NULL,3,'0.99',117,'29.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (375,'GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',85,'17.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (376,'GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia',2006,1,NULL,4,'0.99',155,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (377,'GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia',2006,1,NULL,7,'0.99',135,'20.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (378,'GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin',2006,1,NULL,5,'2.99',93,'24.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (379,'GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies',2006,1,NULL,7,'0.99',166,'14.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (380,'GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station',2006,1,NULL,7,'2.99',176,'11.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (381,'GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station',2006,1,NULL,7,'4.99',150,'25.99','R','Trailers','2006-02-15 05:03:42'),
 (382,'GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',137,'21.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (383,'GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (384,'GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia',2006,1,NULL,5,'4.99',49,'19.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (385,'GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse',2006,1,NULL,6,'4.99',139,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (386,'GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',53,'12.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (387,'GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico',2006,1,NULL,7,'0.99',100,'27.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (388,'GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert',2006,1,NULL,5,'0.99',70,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (389,'GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan',2006,1,NULL,3,'2.99',127,'9.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (390,'GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat',2006,1,NULL,4,'4.99',84,'20.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (391,'HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat',2006,1,NULL,6,'2.99',146,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (392,'HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia',2006,1,NULL,5,'4.99',51,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (393,'HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat',2006,1,NULL,6,'2.99',47,'19.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (394,'HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback',2006,1,NULL,7,'2.99',146,'21.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (395,'HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia',2006,1,NULL,4,'0.99',108,'28.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (396,'HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin',2006,1,NULL,5,'4.99',62,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (397,'HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia',2006,1,NULL,5,'2.99',107,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (398,'HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention',2006,1,NULL,5,'4.99',47,'21.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (399,'HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan',2006,1,NULL,6,'2.99',100,'23.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (400,'HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin',2006,1,NULL,7,'2.99',72,'15.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (401,'HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert',2006,1,NULL,6,'0.99',168,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (402,'HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert',2006,1,NULL,3,'0.99',52,'15.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (403,'HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California',2006,1,NULL,5,'4.99',121,'18.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (404,'HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station',2006,1,NULL,4,'0.99',107,'26.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (405,'HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India',2006,1,NULL,6,'4.99',76,'13.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (406,'HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',181,'22.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (407,'HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia',2006,1,NULL,5,'0.99',47,'12.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (408,'HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico',2006,1,NULL,4,'4.99',69,'28.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (409,'HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies',2006,1,NULL,3,'4.99',59,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (410,'HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans',2006,1,NULL,7,'2.99',48,'19.99','PG','Commentaries','2006-02-15 05:03:42'),
 (411,'HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat',2006,1,NULL,5,'4.99',49,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (412,'HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',102,'25.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (413,'HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery',2006,1,NULL,7,'2.99',169,'16.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (414,'HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia',2006,1,NULL,3,'2.99',75,'23.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (415,'HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia',2006,1,NULL,3,'2.99',84,'23.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (416,'HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert',2006,1,NULL,6,'0.99',110,'10.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (417,'HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat',2006,1,NULL,5,'0.99',93,'29.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (418,'HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station',2006,1,NULL,5,'0.99',157,'27.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (419,'HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank',2006,1,NULL,4,'2.99',141,'19.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (420,'HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies',2006,1,NULL,7,'4.99',128,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (421,'HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan',2006,1,NULL,7,'4.99',78,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (422,'HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery',2006,1,NULL,7,'4.99',136,'25.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (423,'HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat',2006,1,NULL,7,'0.99',69,'29.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (424,'HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia',2006,1,NULL,6,'0.99',149,'12.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (425,'HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory',2006,1,NULL,6,'0.99',88,'20.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (426,'HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention',2006,1,NULL,7,'4.99',185,'15.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (427,'HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse',2006,1,NULL,5,'0.99',103,'19.99','R','Trailers','2006-02-15 05:03:42'),
 (428,'HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',141,'21.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (429,'HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (430,'HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia',2006,1,NULL,7,'0.99',49,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (431,'HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station',2006,1,NULL,3,'2.99',176,'12.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (432,'HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank',2006,1,NULL,4,'2.99',139,'22.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (433,'HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank',2006,1,NULL,4,'2.99',95,'23.99','PG','Trailers','2006-02-15 05:03:42'),
 (434,'HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria',2006,1,NULL,3,'0.99',139,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (435,'HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback',2006,1,NULL,6,'4.99',181,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (436,'HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia',2006,1,NULL,4,'0.99',122,'14.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (437,'HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia',2006,1,NULL,7,'2.99',109,'13.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (438,'HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico',2006,1,NULL,3,'2.99',68,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (439,'HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan',2006,1,NULL,4,'4.99',151,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (440,'HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',105,'21.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (441,'HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank',2006,1,NULL,5,'2.99',125,'21.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (442,'HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',65,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (443,'HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',49,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (444,'HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',83,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (445,'HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat',2006,1,NULL,5,'2.99',100,'11.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (446,'HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse',2006,1,NULL,5,'4.99',150,'19.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (447,'ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'28.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (448,'IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback',2006,1,NULL,3,'2.99',172,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (449,'IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback',2006,1,NULL,4,'2.99',119,'12.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (450,'IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery',2006,1,NULL,5,'2.99',84,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (451,'IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory',2006,1,NULL,7,'4.99',160,'12.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (452,'ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',122,'15.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (453,'IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies',2006,1,NULL,3,'2.99',178,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (454,'IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank',2006,1,NULL,6,'0.99',180,'20.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (455,'IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China',2006,1,NULL,7,'4.99',103,'11.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (456,'INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery',2006,1,NULL,6,'4.99',167,'18.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (457,'INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery',2006,1,NULL,5,'0.99',157,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (458,'INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House',2006,1,NULL,4,'0.99',135,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (459,'INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies',2006,1,NULL,4,'4.99',74,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (460,'INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback',2006,1,NULL,3,'4.99',178,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (461,'INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'0.99',123,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (462,'INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory',2006,1,NULL,5,'2.99',78,'17.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (463,'INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse',2006,1,NULL,4,'2.99',116,'21.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (464,'INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat',2006,1,NULL,3,'2.99',107,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (465,'INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',59,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (466,'INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention',2006,1,NULL,6,'4.99',63,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (467,'INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat',2006,1,NULL,6,'0.99',181,'10.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (468,'INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery',2006,1,NULL,5,'2.99',97,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (469,'IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon',2006,1,NULL,7,'4.99',46,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (470,'ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House',2006,1,NULL,4,'4.99',79,'24.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (471,'ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House',2006,1,NULL,7,'2.99',84,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (472,'ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat',2006,1,NULL,3,'4.99',174,'24.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (473,'JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon',2006,1,NULL,5,'2.99',181,'16.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (474,'JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station',2006,1,NULL,6,'2.99',174,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (475,'JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback',2006,1,NULL,6,'0.99',135,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (476,'JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery',2006,1,NULL,5,'2.99',130,'9.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (477,'JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat',2006,1,NULL,5,'0.99',118,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (478,'JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House',2006,1,NULL,4,'2.99',112,'10.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (479,'JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria',2006,1,NULL,7,'0.99',128,'12.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (480,'JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia',2006,1,NULL,3,'2.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (481,'JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank',2006,1,NULL,4,'2.99',58,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (482,'JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India',2006,1,NULL,3,'0.99',102,'12.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (483,'JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat',2006,1,NULL,3,'2.99',171,'29.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (484,'JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan',2006,1,NULL,3,'2.99',172,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (485,'JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan',2006,1,NULL,6,'4.99',60,'16.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (486,'JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat',2006,1,NULL,7,'4.99',59,'14.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (487,'JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon',2006,1,NULL,6,'4.99',124,'29.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (488,'JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank',2006,1,NULL,3,'0.99',105,'23.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (489,'JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California',2006,1,NULL,4,'0.99',54,'14.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (490,'JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans',2006,1,NULL,4,'2.99',121,'13.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (491,'JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin',2006,1,NULL,4,'0.99',74,'18.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (492,'JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia',2006,1,NULL,6,'0.99',134,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (493,'KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin',2006,1,NULL,5,'0.99',92,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (494,'KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention',2006,1,NULL,4,'0.99',120,'21.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (495,'KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat',2006,1,NULL,5,'2.99',169,'10.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (496,'KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans',2006,1,NULL,3,'0.99',179,'10.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (497,'KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback',2006,1,NULL,4,'0.99',54,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (498,'KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',161,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (499,'KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon',2006,1,NULL,3,'4.99',184,'24.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (500,'KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies',2006,1,NULL,5,'4.99',163,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (501,'KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station',2006,1,NULL,3,'4.99',141,'9.99','R','Trailers','2006-02-15 05:03:42'),
 (502,'KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon',2006,1,NULL,4,'2.99',71,'21.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (503,'KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback',2006,1,NULL,3,'2.99',171,'24.99','R','Trailers','2006-02-15 05:03:42'),
 (504,'KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia',2006,1,NULL,5,'0.99',46,'25.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (505,'LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert',2006,1,NULL,6,'2.99',46,'24.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (506,'LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat',2006,1,NULL,4,'4.99',67,'14.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (507,'LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans',2006,1,NULL,4,'0.99',113,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (508,'LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia',2006,1,NULL,6,'4.99',144,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (509,'LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',78,'26.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (510,'LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback',2006,1,NULL,6,'4.99',181,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (511,'LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin',2006,1,NULL,7,'0.99',175,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (512,'LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China',2006,1,NULL,5,'4.99',110,'25.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (513,'LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',153,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (514,'LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China',2006,1,NULL,6,'2.99',69,'17.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (515,'LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert',2006,1,NULL,7,'4.99',113,'14.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (516,'LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback',2006,1,NULL,7,'0.99',59,'18.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (517,'LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse',2006,1,NULL,3,'0.99',167,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (518,'LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies',2006,1,NULL,5,'4.99',140,'15.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (519,'LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon',2006,1,NULL,3,'2.99',138,'27.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (520,'LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery',2006,1,NULL,7,'2.99',91,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (521,'LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station',2006,1,NULL,7,'4.99',147,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (522,'LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station',2006,1,NULL,4,'2.99',137,'9.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (523,'LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico',2006,1,NULL,7,'0.99',174,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (524,'LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China',2006,1,NULL,6,'0.99',50,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (525,'LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico',2006,1,NULL,4,'0.99',140,'29.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (526,'LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan',2006,1,NULL,7,'2.99',120,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (527,'LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan',2006,1,NULL,4,'4.99',85,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (528,'LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',155,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (529,'LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia',2006,1,NULL,3,'2.99',67,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (530,'LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat',2006,1,NULL,5,'2.99',108,'27.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (531,'LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station',2006,1,NULL,3,'0.99',137,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (532,'LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria',2006,1,NULL,5,'4.99',80,'28.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (533,'LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse',2006,1,NULL,4,'2.99',98,'21.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (534,'LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank',2006,1,NULL,5,'0.99',70,'18.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (535,'LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'21.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (536,'LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback',2006,1,NULL,3,'2.99',65,'18.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (537,'LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat',2006,1,NULL,3,'2.99',75,'29.99','G','Trailers','2006-02-15 05:03:42'),
 (538,'LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia',2006,1,NULL,7,'0.99',162,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (539,'LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank',2006,1,NULL,7,'2.99',152,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (540,'LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat',2006,1,NULL,7,'2.99',97,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (541,'LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India',2006,1,NULL,5,'2.99',74,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (542,'LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',52,'28.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (543,'MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback',2006,1,NULL,5,'4.99',116,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (544,'MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat',2006,1,NULL,4,'2.99',147,'11.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (545,'MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico',2006,1,NULL,4,'0.99',178,'14.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (546,'MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station',2006,1,NULL,7,'2.99',98,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (547,'MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California',2006,1,NULL,3,'0.99',117,'19.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (548,'MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California',2006,1,NULL,3,'2.99',53,'27.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (549,'MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans',2006,1,NULL,4,'0.99',171,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (550,'MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon',2006,1,NULL,6,'2.99',74,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (551,'MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention',2006,1,NULL,3,'4.99',138,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (552,'MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station',2006,1,NULL,5,'0.99',130,'15.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (553,'MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat',2006,1,NULL,4,'0.99',136,'12.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (554,'MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback',2006,1,NULL,6,'2.99',159,'22.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (555,'MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery',2006,1,NULL,4,'0.99',133,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (556,'MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California',2006,1,NULL,6,'4.99',127,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (557,'MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin',2006,1,NULL,5,'2.99',177,'27.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (558,'MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India',2006,1,NULL,3,'2.99',71,'18.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (559,'MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert',2006,1,NULL,7,'2.99',114,'22.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (560,'MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia',2006,1,NULL,6,'0.99',62,'21.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (561,'MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California',2006,1,NULL,6,'2.99',123,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (562,'MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',151,'12.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (563,'MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California',2006,1,NULL,6,'4.99',165,'16.99','R','Commentaries','2006-02-15 05:03:42'),
 (564,'MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station',2006,1,NULL,4,'2.99',161,'11.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (565,'MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California',2006,1,NULL,6,'4.99',56,'9.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (566,'MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria',2006,1,NULL,6,'0.99',72,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (567,'MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention',2006,1,NULL,3,'2.99',80,'26.99','G','Trailers','2006-02-15 05:03:42'),
 (568,'MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert',2006,1,NULL,4,'4.99',77,'11.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (569,'MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station',2006,1,NULL,7,'2.99',147,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (570,'MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California',2006,1,NULL,5,'4.99',104,'20.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (571,'METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory',2006,1,NULL,6,'2.99',161,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (572,'METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory',2006,1,NULL,4,'2.99',64,'9.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (573,'MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria',2006,1,NULL,6,'2.99',105,'22.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (574,'MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery',2006,1,NULL,3,'0.99',86,'19.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (575,'MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan',2006,1,NULL,3,'4.99',48,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (576,'MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention',2006,1,NULL,7,'2.99',122,'13.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (577,'MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention',2006,1,NULL,4,'0.99',64,'10.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (578,'MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',142,'16.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (579,'MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery',2006,1,NULL,3,'4.99',149,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (580,'MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin',2006,1,NULL,3,'4.99',166,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (581,'MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback',2006,1,NULL,4,'0.99',59,'16.99','G','Trailers','2006-02-15 05:03:42'),
 (582,'MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert',2006,1,NULL,3,'2.99',162,'19.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (583,'MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House',2006,1,NULL,3,'4.99',164,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (584,'MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India',2006,1,NULL,6,'2.99',180,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (585,'MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies',2006,1,NULL,4,'0.99',105,'25.99','G','Trailers','2006-02-15 05:03:42'),
 (586,'MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin',2006,1,NULL,4,'0.99',60,'27.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (587,'MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans',2006,1,NULL,6,'4.99',77,'20.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (588,'MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia',2006,1,NULL,4,'4.99',175,'11.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (589,'MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans',2006,1,NULL,3,'0.99',74,'20.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (590,'MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia',2006,1,NULL,3,'2.99',135,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (591,'MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat',2006,1,NULL,6,'4.99',182,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (592,'MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia',2006,1,NULL,6,'2.99',107,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (593,'MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat',2006,1,NULL,6,'0.99',158,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (594,'MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat',2006,1,NULL,6,'0.99',126,'22.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (595,'MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory',2006,1,NULL,7,'0.99',83,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (596,'MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat',2006,1,NULL,4,'4.99',171,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (597,'MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans',2006,1,NULL,5,'4.99',184,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (598,'MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan',2006,1,NULL,6,'0.99',57,'22.99','G','Trailers','2006-02-15 05:03:42'),
 (599,'MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China',2006,1,NULL,3,'0.99',103,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (600,'MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House',2006,1,NULL,5,'0.99',166,'16.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (601,'MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',79,'20.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (602,'MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans',2006,1,NULL,5,'0.99',146,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (603,'MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin',2006,1,NULL,6,'4.99',53,'27.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (604,'MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon',2006,1,NULL,4,'0.99',160,'10.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (605,'MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat',2006,1,NULL,7,'2.99',157,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (606,'MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia',2006,1,NULL,3,'0.99',160,'15.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (607,'MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico',2006,1,NULL,5,'4.99',50,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (608,'MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',166,'11.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (609,'MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India',2006,1,NULL,7,'2.99',185,'23.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (610,'MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station',2006,1,NULL,7,'0.99',129,'17.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (611,'MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia',2006,1,NULL,7,'4.99',73,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (612,'MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China',2006,1,NULL,6,'2.99',180,'10.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (613,'MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia',2006,1,NULL,5,'0.99',92,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (614,'NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria',2006,1,NULL,5,'4.99',178,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (615,'NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',180,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (616,'NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California',2006,1,NULL,4,'2.99',92,'19.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (617,'NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory',2006,1,NULL,4,'0.99',50,'24.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (618,'NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California',2006,1,NULL,3,'0.99',132,'21.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (619,'NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',161,'20.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (620,'NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'23.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (621,'NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California',2006,1,NULL,5,'2.99',75,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (622,'NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico',2006,1,NULL,4,'0.99',159,'25.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (623,'NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India',2006,1,NULL,4,'0.99',75,'9.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (624,'NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',149,'25.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (625,'NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse',2006,1,NULL,3,'0.99',83,'18.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (626,'NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',57,'12.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (627,'NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans',2006,1,NULL,4,'4.99',67,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (628,'NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback',2006,1,NULL,5,'2.99',172,'24.99','PG','Trailers','2006-02-15 05:03:42'),
 (629,'NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon',2006,1,NULL,7,'0.99',128,'9.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (630,'NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies',2006,1,NULL,7,'0.99',48,'19.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (631,'NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria',2006,1,NULL,4,'0.99',64,'11.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (632,'NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California',2006,1,NULL,5,'4.99',145,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (633,'OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat',2006,1,NULL,6,'4.99',54,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (634,'ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin',2006,1,NULL,6,'0.99',48,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (635,'OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert',2006,1,NULL,7,'0.99',58,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (636,'OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat',2006,1,NULL,5,'0.99',161,'12.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (637,'OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat',2006,1,NULL,7,'4.99',131,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (638,'OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China',2006,1,NULL,7,'2.99',156,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (639,'OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria',2006,1,NULL,7,'4.99',92,'9.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (640,'OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert',2006,1,NULL,5,'4.99',102,'21.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (641,'ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat',2006,1,NULL,4,'0.99',76,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (642,'ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert',2006,1,NULL,7,'2.99',120,'13.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (643,'ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert',2006,1,NULL,3,'2.99',118,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (644,'OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia',2006,1,NULL,7,'2.99',115,'29.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (645,'OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico',2006,1,NULL,7,'2.99',118,'18.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (646,'OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat',2006,1,NULL,6,'0.99',169,'12.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (647,'OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India',2006,1,NULL,4,'0.99',129,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (648,'OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert',2006,1,NULL,7,'4.99',148,'17.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (649,'OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory',2006,1,NULL,4,'2.99',85,'14.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (650,'PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse',2006,1,NULL,3,'0.99',144,'27.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (651,'PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',84,'20.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (652,'PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California',2006,1,NULL,3,'0.99',126,'14.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (653,'PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon',2006,1,NULL,3,'4.99',102,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (654,'PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,4,'4.99',93,'19.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (655,'PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico',2006,1,NULL,5,'4.99',109,'22.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (656,'PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan',2006,1,NULL,3,'0.99',128,'9.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (657,'PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse',2006,1,NULL,5,'2.99',48,'12.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (658,'PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback',2006,1,NULL,7,'2.99',121,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (659,'PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan',2006,1,NULL,3,'4.99',109,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (660,'PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',107,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (661,'PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery',2006,1,NULL,5,'4.99',157,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (662,'PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China',2006,1,NULL,3,'4.99',118,'9.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (663,'PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia',2006,1,NULL,7,'0.99',99,'29.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (664,'PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California',2006,1,NULL,6,'2.99',65,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (665,'PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin',2006,1,NULL,4,'2.99',175,'22.99','PG','Commentaries','2006-02-15 05:03:42'),
 (666,'PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert',2006,1,NULL,4,'4.99',145,'27.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (667,'PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin',2006,1,NULL,3,'2.99',160,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (668,'PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft',2006,1,NULL,7,'4.99',80,'25.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (669,'PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat',2006,1,NULL,3,'2.99',74,'10.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (670,'PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin',2006,1,NULL,4,'4.99',48,'17.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (671,'PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin',2006,1,NULL,7,'4.99',99,'27.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (672,'PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon',2006,1,NULL,7,'2.99',82,'17.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (673,'PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan',2006,1,NULL,3,'0.99',118,'19.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (674,'PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California',2006,1,NULL,3,'0.99',99,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (675,'PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery',2006,1,NULL,6,'2.99',60,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (676,'PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert',2006,1,NULL,7,'4.99',137,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (677,'PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery',2006,1,NULL,6,'0.99',136,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (678,'PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'2.99',77,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (679,'PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',50,'17.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (680,'PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California',2006,1,NULL,4,'4.99',103,'21.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (681,'PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies',2006,1,NULL,4,'0.99',100,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (682,'PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia',2006,1,NULL,4,'4.99',134,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (683,'PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria',2006,1,NULL,5,'4.99',60,'19.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (684,'PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat',2006,1,NULL,4,'2.99',173,'11.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (685,'PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia',2006,1,NULL,6,'4.99',132,'10.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (686,'PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank',2006,1,NULL,5,'4.99',84,'9.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (687,'POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory',2006,1,NULL,6,'0.99',138,'15.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (688,'POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback',2006,1,NULL,6,'0.99',61,'12.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (689,'POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert',2006,1,NULL,5,'2.99',137,'14.99','PG','Commentaries','2006-02-15 05:03:42'),
 (690,'POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China',2006,1,NULL,7,'2.99',185,'25.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (691,'POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery',2006,1,NULL,6,'4.99',159,'29.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (692,'POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon',2006,1,NULL,3,'2.99',179,'10.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (693,'POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin',2006,1,NULL,5,'2.99',115,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (694,'PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat',2006,1,NULL,6,'4.99',98,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (695,'PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia',2006,1,NULL,6,'4.99',144,'12.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (696,'PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India',2006,1,NULL,6,'0.99',114,'20.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (697,'PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies',2006,1,NULL,7,'0.99',53,'16.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (698,'PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank',2006,1,NULL,3,'2.99',71,'29.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (699,'PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon',2006,1,NULL,7,'4.99',106,'26.99','PG','Trailers','2006-02-15 05:03:42'),
 (700,'PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China',2006,1,NULL,4,'2.99',115,'13.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (701,'PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria',2006,1,NULL,5,'2.99',155,'11.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (702,'PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria',2006,1,NULL,4,'2.99',89,'12.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (703,'PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',100,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (704,'PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse',2006,1,NULL,3,'2.99',121,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (705,'PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',88,'9.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (706,'QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans',2006,1,NULL,5,'4.99',163,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (707,'QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory',2006,1,NULL,5,'2.99',177,'29.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (708,'QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia',2006,1,NULL,4,'4.99',112,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (709,'RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California',2006,1,NULL,7,'2.99',147,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (710,'RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',120,'18.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (711,'RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,4,'4.99',154,'18.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (712,'RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station',2006,1,NULL,4,'0.99',82,'11.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (713,'RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India',2006,1,NULL,3,'4.99',74,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (714,'RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank',2006,1,NULL,6,'2.99',73,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (715,'RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon',2006,1,NULL,3,'4.99',147,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (716,'REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',136,'26.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (717,'REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia',2006,1,NULL,6,'0.99',97,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (718,'REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India',2006,1,NULL,7,'0.99',73,'24.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (719,'RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback',2006,1,NULL,7,'4.99',182,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (720,'REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China',2006,1,NULL,3,'2.99',179,'20.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (721,'REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia',2006,1,NULL,7,'4.99',182,'23.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (722,'REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon',2006,1,NULL,5,'0.99',123,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (723,'REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico',2006,1,NULL,3,'2.99',82,'29.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (724,'REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India',2006,1,NULL,5,'2.99',110,'15.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (725,'REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery',2006,1,NULL,6,'4.99',167,'25.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (726,'RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California',2006,1,NULL,7,'2.99',61,'29.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (727,'RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention',2006,1,NULL,6,'0.99',117,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (728,'REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory',2006,1,NULL,3,'0.99',63,'26.99','R','Commentaries','2006-02-15 05:03:42'),
 (729,'RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria',2006,1,NULL,5,'2.99',177,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (730,'RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan',2006,1,NULL,3,'0.99',46,'28.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (731,'RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat',2006,1,NULL,7,'4.99',153,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (732,'RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans',2006,1,NULL,5,'0.99',58,'17.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (733,'RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention',2006,1,NULL,4,'0.99',149,'29.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (734,'ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan',2006,1,NULL,4,'4.99',158,'12.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (735,'ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia',2006,1,NULL,7,'2.99',102,'26.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (736,'ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan',2006,1,NULL,4,'0.99',134,'21.99','R','Trailers','2006-02-15 05:03:42'),
 (737,'ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India',2006,1,NULL,4,'0.99',102,'28.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (738,'ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank',2006,1,NULL,3,'0.99',178,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (739,'ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria',2006,1,NULL,4,'4.99',145,'17.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (740,'ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank',2006,1,NULL,5,'2.99',153,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (741,'ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin',2006,1,NULL,7,'0.99',81,'28.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (742,'ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon',2006,1,NULL,7,'0.99',101,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (743,'ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank',2006,1,NULL,7,'0.99',60,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (744,'ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin',2006,1,NULL,4,'0.99',89,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (745,'ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station',2006,1,NULL,5,'4.99',162,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (746,'ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia',2006,1,NULL,3,'0.99',118,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (747,'ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback',2006,1,NULL,5,'0.99',171,'9.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (748,'RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria',2006,1,NULL,4,'0.99',109,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (749,'RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House',2006,1,NULL,6,'4.99',153,'19.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (750,'RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',145,'25.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (751,'RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'17.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (752,'RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback',2006,1,NULL,6,'0.99',101,'27.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (753,'RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia',2006,1,NULL,3,'0.99',48,'20.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (754,'RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank',2006,1,NULL,6,'2.99',150,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (755,'SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert',2006,1,NULL,5,'4.99',99,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (756,'SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House',2006,1,NULL,7,'2.99',80,'10.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (757,'SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan',2006,1,NULL,4,'2.99',106,'28.99','G','Trailers','2006-02-15 05:03:42'),
 (758,'SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico',2006,1,NULL,5,'2.99',125,'11.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (759,'SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China',2006,1,NULL,4,'2.99',73,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (760,'SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon',2006,1,NULL,5,'2.99',110,'21.99','G','Commentaries','2006-02-15 05:03:42'),
 (761,'SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory',2006,1,NULL,7,'2.99',154,'23.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (762,'SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse',2006,1,NULL,6,'0.99',154,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (763,'SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China',2006,1,NULL,3,'4.99',75,'26.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (764,'SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon',2006,1,NULL,3,'4.99',150,'28.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (765,'SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin',2006,1,NULL,7,'4.99',182,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (766,'SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico',2006,1,NULL,5,'0.99',84,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (767,'SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery',2006,1,NULL,6,'4.99',183,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (768,'SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory',2006,1,NULL,3,'4.99',102,'11.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (769,'SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse',2006,1,NULL,5,'4.99',151,'21.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (770,'SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'2.99',147,'13.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (771,'SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House',2006,1,NULL,3,'4.99',137,'23.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (772,'SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat',2006,1,NULL,4,'2.99',80,'24.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (773,'SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',112,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (774,'SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan',2006,1,NULL,3,'2.99',182,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (775,'SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',110,'18.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (776,'SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans',2006,1,NULL,6,'4.99',90,'11.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (777,'SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory',2006,1,NULL,5,'4.99',158,'10.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (778,'SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse',2006,1,NULL,3,'4.99',109,'24.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (779,'SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'4.99',54,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (780,'SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory',2006,1,NULL,7,'4.99',98,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (781,'SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin',2006,1,NULL,4,'4.99',127,'15.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (782,'SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention',2006,1,NULL,6,'2.99',60,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (783,'SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin',2006,1,NULL,5,'2.99',93,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (784,'SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House',2006,1,NULL,7,'2.99',47,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (785,'SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',80,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (786,'SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon',2006,1,NULL,7,'0.99',113,'14.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (787,'SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India',2006,1,NULL,4,'0.99',125,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (788,'SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback',2006,1,NULL,5,'2.99',104,'15.99','R','Commentaries','2006-02-15 05:03:42'),
 (789,'SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans',2006,1,NULL,7,'2.99',79,'15.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (790,'SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin',2006,1,NULL,6,'0.99',67,'22.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (791,'SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan',2006,1,NULL,3,'4.99',167,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (792,'SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat',2006,1,NULL,7,'2.99',154,'15.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (793,'SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon',2006,1,NULL,6,'2.99',139,'14.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (794,'SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'0.99',52,'28.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (795,'SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',111,'23.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (796,'SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California',2006,1,NULL,3,'0.99',135,'12.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (797,'SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon',2006,1,NULL,7,'0.99',67,'23.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (798,'SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India',2006,1,NULL,4,'4.99',74,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (799,'SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank',2006,1,NULL,3,'0.99',51,'26.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (800,'SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',126,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (801,'SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia',2006,1,NULL,5,'4.99',152,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (802,'SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House',2006,1,NULL,7,'2.99',132,'15.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (803,'SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China',2006,1,NULL,7,'4.99',179,'29.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (804,'SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention',2006,1,NULL,7,'4.99',129,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (805,'SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia',2006,1,NULL,5,'4.99',64,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (806,'SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback',2006,1,NULL,4,'2.99',137,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (807,'SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India',2006,1,NULL,4,'0.99',87,'25.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (808,'SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',84,'10.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (809,'SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention',2006,1,NULL,5,'0.99',156,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (810,'SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat',2006,1,NULL,5,'0.99',147,'21.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (811,'SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin',2006,1,NULL,4,'2.99',60,'29.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (812,'SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention',2006,1,NULL,7,'0.99',50,'13.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (813,'SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China',2006,1,NULL,7,'0.99',184,'18.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (814,'SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin',2006,1,NULL,6,'4.99',110,'15.99','PG','Commentaries','2006-02-15 05:03:42'),
 (815,'SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies',2006,1,NULL,4,'2.99',74,'14.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (816,'SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse',2006,1,NULL,3,'0.99',62,'27.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (817,'SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station',2006,1,NULL,7,'4.99',185,'27.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (818,'SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station',2006,1,NULL,4,'4.99',180,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (819,'SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention',2006,1,NULL,3,'0.99',165,'29.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (820,'SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China',2006,1,NULL,3,'2.99',184,'11.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (821,'SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat',2006,1,NULL,6,'0.99',184,'17.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (822,'SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention',2006,1,NULL,6,'0.99',169,'12.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (823,'SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',143,'21.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (824,'SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse',2006,1,NULL,4,'4.99',52,'19.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (825,'SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse',2006,1,NULL,6,'2.99',165,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (826,'SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China',2006,1,NULL,7,'4.99',124,'19.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (827,'SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',141,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (828,'SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery',2006,1,NULL,7,'2.99',79,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (829,'SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California',2006,1,NULL,7,'2.99',138,'12.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (830,'SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan',2006,1,NULL,7,'0.99',149,'23.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (831,'SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory',2006,1,NULL,5,'0.99',138,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (832,'SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank',2006,1,NULL,5,'0.99',175,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (833,'SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin',2006,1,NULL,5,'0.99',134,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (834,'SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico',2006,1,NULL,4,'0.99',151,'26.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (835,'SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon',2006,1,NULL,6,'2.99',112,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (836,'SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin',2006,1,NULL,3,'2.99',136,'14.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (837,'STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat',2006,1,NULL,4,'2.99',85,'19.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (838,'STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California',2006,1,NULL,5,'4.99',112,'25.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (839,'STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia',2006,1,NULL,5,'0.99',130,'23.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (840,'STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat',2006,1,NULL,5,'0.99',75,'26.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (841,'STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank',2006,1,NULL,5,'2.99',181,'9.99','PG','Commentaries','2006-02-15 05:03:42'),
 (842,'STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat',2006,1,NULL,4,'2.99',113,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (843,'STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria',2006,1,NULL,4,'4.99',143,'15.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (844,'STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention',2006,1,NULL,6,'4.99',140,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (845,'STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention',2006,1,NULL,7,'4.99',48,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (846,'STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat',2006,1,NULL,3,'4.99',93,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (847,'STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China',2006,1,NULL,7,'2.99',160,'10.99','PG','Commentaries','2006-02-15 05:03:42'),
 (848,'STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia',2006,1,NULL,3,'0.99',94,'19.99','G','Trailers','2006-02-15 05:03:42'),
 (849,'STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank',2006,1,NULL,6,'0.99',57,'28.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (850,'STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',163,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (851,'STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback',2006,1,NULL,3,'0.99',151,'19.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (852,'STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park',2006,1,NULL,4,'0.99',103,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (853,'STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station',2006,1,NULL,3,'4.99',139,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (854,'STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico',2006,1,NULL,4,'4.99',119,'22.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (855,'STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans',2006,1,NULL,7,'0.99',132,'28.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (856,'STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico',2006,1,NULL,5,'4.99',73,'11.99','R','Commentaries','2006-02-15 05:03:42'),
 (857,'STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House',2006,1,NULL,3,'2.99',144,'24.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (858,'SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia',2006,1,NULL,5,'4.99',127,'21.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (859,'SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',114,'20.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (860,'SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat',2006,1,NULL,4,'4.99',93,'13.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (861,'SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia',2006,1,NULL,3,'4.99',111,'12.99','R','Commentaries','2006-02-15 05:03:42'),
 (862,'SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank',2006,1,NULL,5,'0.99',53,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (863,'SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',141,'9.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (864,'SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory',2006,1,NULL,5,'0.99',92,'21.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (865,'SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'4.99',135,'19.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (866,'SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California',2006,1,NULL,6,'0.99',48,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (867,'SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback',2006,1,NULL,5,'4.99',58,'10.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (868,'SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House',2006,1,NULL,5,'0.99',114,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (869,'SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse',2006,1,NULL,4,'2.99',47,'22.99','PG','Trailers','2006-02-15 05:03:42'),
 (870,'SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'0.99',123,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (871,'SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies',2006,1,NULL,6,'4.99',176,'19.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (872,'SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon',2006,1,NULL,3,'2.99',185,'27.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (873,'SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico',2006,1,NULL,3,'0.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (874,'TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',155,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (875,'TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat',2006,1,NULL,6,'0.99',173,'9.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (876,'TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert',2006,1,NULL,3,'2.99',91,'11.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (877,'TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia',2006,1,NULL,4,'0.99',64,'23.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (878,'TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank',2006,1,NULL,3,'4.99',74,'25.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (879,'TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat',2006,1,NULL,3,'4.99',148,'20.99','PG','Commentaries','2006-02-15 05:03:42'),
 (880,'TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'2.99',152,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (881,'TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia',2006,1,NULL,5,'4.99',71,'13.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (882,'TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico',2006,1,NULL,4,'0.99',99,'24.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (883,'TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria',2006,1,NULL,6,'4.99',53,'17.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (884,'TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico',2006,1,NULL,5,'4.99',88,'11.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (885,'TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park',2006,1,NULL,7,'0.99',179,'22.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (886,'THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station',2006,1,NULL,5,'0.99',184,'9.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (887,'THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',135,'28.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (888,'THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India',2006,1,NULL,5,'4.99',53,'9.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (889,'TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat',2006,1,NULL,3,'4.99',111,'28.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (890,'TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon',2006,1,NULL,5,'0.99',172,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (891,'TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat',2006,1,NULL,3,'0.99',69,'13.99','G','Commentaries','2006-02-15 05:03:42'),
 (892,'TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory',2006,1,NULL,3,'4.99',104,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (893,'TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China',2006,1,NULL,4,'4.99',91,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (894,'TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank',2006,1,NULL,6,'0.99',68,'23.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (895,'TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',142,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (896,'TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin',2006,1,NULL,3,'0.99',157,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (897,'TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan',2006,1,NULL,3,'4.99',179,'27.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (898,'TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia',2006,1,NULL,4,'4.99',152,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (899,'TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention',2006,1,NULL,7,'0.99',144,'14.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (900,'TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',136,'17.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (901,'TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria',2006,1,NULL,3,'0.99',142,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (902,'TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station',2006,1,NULL,6,'4.99',170,'22.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (903,'TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat',2006,1,NULL,5,'4.99',139,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (904,'TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India',2006,1,NULL,3,'4.99',71,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (905,'TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan',2006,1,NULL,7,'4.99',132,'10.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (906,'TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India',2006,1,NULL,4,'0.99',171,'27.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (907,'TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention',2006,1,NULL,4,'0.99',168,'10.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (908,'TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert',2006,1,NULL,3,'4.99',110,'11.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (909,'TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California',2006,1,NULL,3,'0.99',102,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (910,'TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',87,'19.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (911,'TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',64,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (912,'TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India',2006,1,NULL,3,'2.99',52,'9.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (913,'TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin',2006,1,NULL,3,'0.99',115,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (914,'TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan',2006,1,NULL,6,'2.99',61,'13.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (915,'TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery',2006,1,NULL,7,'4.99',92,'9.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (916,'TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans',2006,1,NULL,3,'2.99',80,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (917,'TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India',2006,1,NULL,3,'2.99',152,'24.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (918,'TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention',2006,1,NULL,4,'4.99',152,'23.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (919,'TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse',2006,1,NULL,3,'4.99',82,'17.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (920,'UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia',2006,1,NULL,3,'0.99',62,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (921,'UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat',2006,1,NULL,7,'2.99',172,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (922,'UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',107,'22.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (923,'UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans',2006,1,NULL,7,'2.99',78,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (924,'UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory',2006,1,NULL,7,'0.99',129,'15.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (925,'UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert',2006,1,NULL,3,'0.99',164,'27.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (926,'UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House',2006,1,NULL,5,'2.99',120,'11.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (927,'UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin',2006,1,NULL,6,'2.99',174,'16.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (928,'UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',84,'16.99','PG','Commentaries','2006-02-15 05:03:42'),
 (929,'USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank',2006,1,NULL,5,'4.99',128,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (930,'VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia',2006,1,NULL,4,'2.99',145,'23.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (931,'VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California',2006,1,NULL,7,'0.99',48,'9.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (932,'VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'0.99',73,'21.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (933,'VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention',2006,1,NULL,4,'4.99',126,'11.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (934,'VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria',2006,1,NULL,7,'4.99',122,'20.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (935,'VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California',2006,1,NULL,5,'0.99',142,'17.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (936,'VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (937,'VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention',2006,1,NULL,7,'2.99',85,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (938,'VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',173,'14.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (939,'VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan',2006,1,NULL,4,'2.99',90,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (940,'VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert',2006,1,NULL,6,'0.99',64,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (941,'VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia',2006,1,NULL,4,'4.99',145,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (942,'VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia',2006,1,NULL,7,'0.99',174,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (943,'VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',76,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (944,'VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank',2006,1,NULL,6,'4.99',179,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (945,'VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin',2006,1,NULL,5,'0.99',164,'22.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (946,'VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia',2006,1,NULL,3,'4.99',144,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (947,'VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank',2006,1,NULL,5,'0.99',59,'16.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (948,'VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',139,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (949,'VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback',2006,1,NULL,6,'0.99',157,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (950,'VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California',2006,1,NULL,7,'4.99',132,'12.99','PG','Commentaries','2006-02-15 05:03:42'),
 (951,'VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',78,'28.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (952,'WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse',2006,1,NULL,7,'2.99',152,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (953,'WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse',2006,1,NULL,3,'0.99',112,'9.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (954,'WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin',2006,1,NULL,7,'4.99',73,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (955,'WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House',2006,1,NULL,7,'4.99',135,'19.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (956,'WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback',2006,1,NULL,7,'4.99',107,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (957,'WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies',2006,1,NULL,7,'4.99',80,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (958,'WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India',2006,1,NULL,6,'2.99',178,'19.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (959,'WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback',2006,1,NULL,6,'2.99',83,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (960,'WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert',2006,1,NULL,5,'2.99',128,'15.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (961,'WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China',2006,1,NULL,7,'4.99',161,'22.99','R','Commentaries','2006-02-15 05:03:42'),
 (962,'WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China',2006,1,NULL,7,'2.99',85,'18.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (963,'WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria',2006,1,NULL,5,'0.99',78,'12.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (964,'WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria',2006,1,NULL,4,'4.99',61,'17.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (965,'WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia',2006,1,NULL,6,'0.99',112,'28.99','G','Commentaries','2006-02-15 05:03:42'),
 (966,'WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',70,'14.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (967,'WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat',2006,1,NULL,5,'2.99',134,'26.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (968,'WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery',2006,1,NULL,6,'4.99',79,'19.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (969,'WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',159,'29.99','G','Trailers','2006-02-15 05:03:42'),
 (970,'WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China',2006,1,NULL,7,'0.99',52,'11.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (971,'WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention',2006,1,NULL,4,'4.99',109,'11.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (972,'WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan',2006,1,NULL,4,'4.99',59,'24.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (973,'WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan',2006,1,NULL,3,'4.99',183,'27.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (974,'WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention',2006,1,NULL,4,'0.99',181,'24.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (975,'WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse',2006,1,NULL,6,'2.99',137,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (976,'WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (977,'WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery',2006,1,NULL,3,'2.99',85,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (978,'WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station',2006,1,NULL,3,'0.99',98,'12.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (979,'WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria',2006,1,NULL,6,'4.99',100,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (980,'WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'4.99',75,'12.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (981,'WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse',2006,1,NULL,7,'0.99',55,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (982,'WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia',2006,1,NULL,4,'0.99',126,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (983,'WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat',2006,1,NULL,7,'2.99',105,'18.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (984,'WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat',2006,1,NULL,3,'2.99',126,'20.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (985,'WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'4.99',111,'19.99','PG','Commentaries','2006-02-15 05:03:42'),
 (986,'WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India',2006,1,NULL,6,'2.99',85,'24.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (987,'WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',116,'13.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (988,'WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'2.99',139,'26.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (989,'WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China',2006,1,NULL,4,'4.99',74,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (990,'WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',171,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (991,'WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback',2006,1,NULL,4,'2.99',185,'26.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (992,'WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery',2006,1,NULL,5,'0.99',176,'17.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (993,'WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans',2006,1,NULL,6,'2.99',178,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (994,'WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat',2006,1,NULL,6,'4.99',100,'29.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (995,'YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin',2006,1,NULL,5,'4.99',86,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (996,'YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station',2006,1,NULL,6,'0.99',183,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (997,'YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat',2006,1,NULL,4,'0.99',179,'14.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (998,'ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies',2006,1,NULL,6,'0.99',105,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (999,'ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China',2006,1,NULL,5,'2.99',101,'28.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (1000,'ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery',2006,1,NULL,3,'4.99',50,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
COMMIT;

--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`ins_film` AFTER INSERT ON `film` FOR EACH ROW BEGIN
    INSERT INTO film_text (film_id, title, description)
        VALUES (new.film_id, new.title, new.description);
  END $$

DELIMITER ;

--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`upd_film` AFTER UPDATE ON `film` FOR EACH ROW BEGIN
    IF (old.title != new.title) or (old.description != new.description)
    THEN
        UPDATE film_text
            SET title=new.title,
                description=new.description,
                film_id=new.film_id
        WHERE film_id=old.film_id;
    END IF;
  END $$

DELIMITER ;

--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`del_film` AFTER DELETE ON `film` FOR EACH ROW BEGIN
    DELETE FROM film_text WHERE film_id = old.film_id;
  END $$

DELIMITER ;

--
-- Definition of table `sakila`.`film_actor`
--

DROP TABLE IF EXISTS `sakila`.`film_actor`;
CREATE TABLE  `sakila`.`film_actor` (
  `actor_id` smallint(5) unsigned NOT NULL,
  `film_id` smallint(5) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`,`film_id`),
  KEY `idx_fk_film_id` (`film_id`),
  CONSTRAINT `fk_film_actor_actor` FOREIGN KEY (`actor_id`) REFERENCES `actor` (`actor_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_film_actor_film` FOREIGN KEY (`film_id`) REFERENCES `film` (`film_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`film_actor`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`film_actor` VALUES  (1,1,'2006-02-15 05:05:03'),
 (1,23,'2006-02-15 05:05:03'),
 (1,25,'2006-02-15 05:05:03'),
 (1,106,'2006-02-15 05:05:03'),
 (1,140,'2006-02-15 05:05:03'),
 (1,166,'2006-02-15 05:05:03'),
 (1,277,'2006-02-15 05:05:03'),
 (1,361,'2006-02-15 05:05:03'),
 (1,438,'2006-02-15 05:05:03'),
 (1,499,'2006-02-15 05:05:03'),
 (1,506,'2006-02-15 05:05:03'),
 (1,509,'2006-02-15 05:05:03'),
 (1,605,'2006-02-15 05:05:03'),
 (1,635,'2006-02-15 05:05:03'),
 (1,749,'2006-02-15 05:05:03'),
 (1,832,'2006-02-15 05:05:03'),
 (1,939,'2006-02-15 05:05:03'),
 (1,970,'2006-02-15 05:05:03'),
 (1,980,'2006-02-15 05:05:03'),
 (2,3,'2006-02-15 05:05:03'),
 (2,31,'2006-02-15 05:05:03'),
 (2,47,'2006-02-15 05:05:03'),
 (2,105,'2006-02-15 05:05:03'),
 (2,132,'2006-02-15 05:05:03'),
 (2,145,'2006-02-15 05:05:03'),
 (2,226,'2006-02-15 05:05:03'),
 (2,249,'2006-02-15 05:05:03'),
 (2,314,'2006-02-15 05:05:03'),
 (2,321,'2006-02-15 05:05:03'),
 (2,357,'2006-02-15 05:05:03'),
 (2,369,'2006-02-15 05:05:03'),
 (2,399,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (2,458,'2006-02-15 05:05:03'),
 (2,481,'2006-02-15 05:05:03'),
 (2,485,'2006-02-15 05:05:03'),
 (2,518,'2006-02-15 05:05:03'),
 (2,540,'2006-02-15 05:05:03'),
 (2,550,'2006-02-15 05:05:03'),
 (2,555,'2006-02-15 05:05:03'),
 (2,561,'2006-02-15 05:05:03'),
 (2,742,'2006-02-15 05:05:03'),
 (2,754,'2006-02-15 05:05:03'),
 (2,811,'2006-02-15 05:05:03'),
 (2,958,'2006-02-15 05:05:03'),
 (3,17,'2006-02-15 05:05:03'),
 (3,40,'2006-02-15 05:05:03'),
 (3,42,'2006-02-15 05:05:03'),
 (3,87,'2006-02-15 05:05:03'),
 (3,111,'2006-02-15 05:05:03'),
 (3,185,'2006-02-15 05:05:03'),
 (3,289,'2006-02-15 05:05:03'),
 (3,329,'2006-02-15 05:05:03'),
 (3,336,'2006-02-15 05:05:03'),
 (3,341,'2006-02-15 05:05:03'),
 (3,393,'2006-02-15 05:05:03'),
 (3,441,'2006-02-15 05:05:03'),
 (3,453,'2006-02-15 05:05:03'),
 (3,480,'2006-02-15 05:05:03'),
 (3,539,'2006-02-15 05:05:03'),
 (3,618,'2006-02-15 05:05:03'),
 (3,685,'2006-02-15 05:05:03'),
 (3,827,'2006-02-15 05:05:03'),
 (3,966,'2006-02-15 05:05:03'),
 (3,967,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (3,971,'2006-02-15 05:05:03'),
 (3,996,'2006-02-15 05:05:03'),
 (4,23,'2006-02-15 05:05:03'),
 (4,25,'2006-02-15 05:05:03'),
 (4,56,'2006-02-15 05:05:03'),
 (4,62,'2006-02-15 05:05:03'),
 (4,79,'2006-02-15 05:05:03'),
 (4,87,'2006-02-15 05:05:03'),
 (4,355,'2006-02-15 05:05:03'),
 (4,379,'2006-02-15 05:05:03'),
 (4,398,'2006-02-15 05:05:03'),
 (4,463,'2006-02-15 05:05:03'),
 (4,490,'2006-02-15 05:05:03'),
 (4,616,'2006-02-15 05:05:03'),
 (4,635,'2006-02-15 05:05:03'),
 (4,691,'2006-02-15 05:05:03'),
 (4,712,'2006-02-15 05:05:03'),
 (4,714,'2006-02-15 05:05:03'),
 (4,721,'2006-02-15 05:05:03'),
 (4,798,'2006-02-15 05:05:03'),
 (4,832,'2006-02-15 05:05:03'),
 (4,858,'2006-02-15 05:05:03'),
 (4,909,'2006-02-15 05:05:03'),
 (4,924,'2006-02-15 05:05:03'),
 (5,19,'2006-02-15 05:05:03'),
 (5,54,'2006-02-15 05:05:03'),
 (5,85,'2006-02-15 05:05:03'),
 (5,146,'2006-02-15 05:05:03'),
 (5,171,'2006-02-15 05:05:03'),
 (5,172,'2006-02-15 05:05:03'),
 (5,202,'2006-02-15 05:05:03'),
 (5,203,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (5,286,'2006-02-15 05:05:03'),
 (5,288,'2006-02-15 05:05:03'),
 (5,316,'2006-02-15 05:05:03'),
 (5,340,'2006-02-15 05:05:03'),
 (5,369,'2006-02-15 05:05:03'),
 (5,375,'2006-02-15 05:05:03'),
 (5,383,'2006-02-15 05:05:03'),
 (5,392,'2006-02-15 05:05:03'),
 (5,411,'2006-02-15 05:05:03'),
 (5,503,'2006-02-15 05:05:03'),
 (5,535,'2006-02-15 05:05:03'),
 (5,571,'2006-02-15 05:05:03'),
 (5,650,'2006-02-15 05:05:03'),
 (5,665,'2006-02-15 05:05:03'),
 (5,687,'2006-02-15 05:05:03'),
 (5,730,'2006-02-15 05:05:03'),
 (5,732,'2006-02-15 05:05:03'),
 (5,811,'2006-02-15 05:05:03'),
 (5,817,'2006-02-15 05:05:03'),
 (5,841,'2006-02-15 05:05:03'),
 (5,865,'2006-02-15 05:05:03'),
 (6,29,'2006-02-15 05:05:03'),
 (6,53,'2006-02-15 05:05:03'),
 (6,60,'2006-02-15 05:05:03'),
 (6,70,'2006-02-15 05:05:03'),
 (6,112,'2006-02-15 05:05:03'),
 (6,164,'2006-02-15 05:05:03'),
 (6,165,'2006-02-15 05:05:03'),
 (6,193,'2006-02-15 05:05:03'),
 (6,256,'2006-02-15 05:05:03'),
 (6,451,'2006-02-15 05:05:03'),
 (6,503,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (6,509,'2006-02-15 05:05:03'),
 (6,517,'2006-02-15 05:05:03'),
 (6,519,'2006-02-15 05:05:03'),
 (6,605,'2006-02-15 05:05:03'),
 (6,692,'2006-02-15 05:05:03'),
 (6,826,'2006-02-15 05:05:03'),
 (6,892,'2006-02-15 05:05:03'),
 (6,902,'2006-02-15 05:05:03'),
 (6,994,'2006-02-15 05:05:03'),
 (7,25,'2006-02-15 05:05:03'),
 (7,27,'2006-02-15 05:05:03'),
 (7,35,'2006-02-15 05:05:03'),
 (7,67,'2006-02-15 05:05:03'),
 (7,96,'2006-02-15 05:05:03'),
 (7,170,'2006-02-15 05:05:03'),
 (7,173,'2006-02-15 05:05:03'),
 (7,217,'2006-02-15 05:05:03'),
 (7,218,'2006-02-15 05:05:03'),
 (7,225,'2006-02-15 05:05:03'),
 (7,292,'2006-02-15 05:05:03'),
 (7,351,'2006-02-15 05:05:03'),
 (7,414,'2006-02-15 05:05:03'),
 (7,463,'2006-02-15 05:05:03'),
 (7,554,'2006-02-15 05:05:03'),
 (7,618,'2006-02-15 05:05:03'),
 (7,633,'2006-02-15 05:05:03'),
 (7,637,'2006-02-15 05:05:03'),
 (7,691,'2006-02-15 05:05:03'),
 (7,758,'2006-02-15 05:05:03'),
 (7,766,'2006-02-15 05:05:03'),
 (7,770,'2006-02-15 05:05:03'),
 (7,805,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (7,806,'2006-02-15 05:05:03'),
 (7,846,'2006-02-15 05:05:03'),
 (7,900,'2006-02-15 05:05:03'),
 (7,901,'2006-02-15 05:05:03'),
 (7,910,'2006-02-15 05:05:03'),
 (7,957,'2006-02-15 05:05:03'),
 (7,959,'2006-02-15 05:05:03'),
 (8,47,'2006-02-15 05:05:03'),
 (8,115,'2006-02-15 05:05:03'),
 (8,158,'2006-02-15 05:05:03'),
 (8,179,'2006-02-15 05:05:03'),
 (8,195,'2006-02-15 05:05:03'),
 (8,205,'2006-02-15 05:05:03'),
 (8,255,'2006-02-15 05:05:03'),
 (8,263,'2006-02-15 05:05:03'),
 (8,321,'2006-02-15 05:05:03'),
 (8,396,'2006-02-15 05:05:03'),
 (8,458,'2006-02-15 05:05:03'),
 (8,523,'2006-02-15 05:05:03'),
 (8,532,'2006-02-15 05:05:03'),
 (8,554,'2006-02-15 05:05:03'),
 (8,752,'2006-02-15 05:05:03'),
 (8,769,'2006-02-15 05:05:03'),
 (8,771,'2006-02-15 05:05:03'),
 (8,859,'2006-02-15 05:05:03'),
 (8,895,'2006-02-15 05:05:03'),
 (8,936,'2006-02-15 05:05:03'),
 (9,30,'2006-02-15 05:05:03'),
 (9,74,'2006-02-15 05:05:03'),
 (9,147,'2006-02-15 05:05:03'),
 (9,148,'2006-02-15 05:05:03'),
 (9,191,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (9,200,'2006-02-15 05:05:03'),
 (9,204,'2006-02-15 05:05:03'),
 (9,434,'2006-02-15 05:05:03'),
 (9,510,'2006-02-15 05:05:03'),
 (9,514,'2006-02-15 05:05:03'),
 (9,552,'2006-02-15 05:05:03'),
 (9,650,'2006-02-15 05:05:03'),
 (9,671,'2006-02-15 05:05:03'),
 (9,697,'2006-02-15 05:05:03'),
 (9,722,'2006-02-15 05:05:03'),
 (9,752,'2006-02-15 05:05:03'),
 (9,811,'2006-02-15 05:05:03'),
 (9,815,'2006-02-15 05:05:03'),
 (9,865,'2006-02-15 05:05:03'),
 (9,873,'2006-02-15 05:05:03'),
 (9,889,'2006-02-15 05:05:03'),
 (9,903,'2006-02-15 05:05:03'),
 (9,926,'2006-02-15 05:05:03'),
 (9,964,'2006-02-15 05:05:03'),
 (9,974,'2006-02-15 05:05:03'),
 (10,1,'2006-02-15 05:05:03'),
 (10,9,'2006-02-15 05:05:03'),
 (10,191,'2006-02-15 05:05:03'),
 (10,236,'2006-02-15 05:05:03'),
 (10,251,'2006-02-15 05:05:03'),
 (10,366,'2006-02-15 05:05:03'),
 (10,477,'2006-02-15 05:05:03'),
 (10,480,'2006-02-15 05:05:03'),
 (10,522,'2006-02-15 05:05:03'),
 (10,530,'2006-02-15 05:05:03'),
 (10,587,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (10,694,'2006-02-15 05:05:03'),
 (10,703,'2006-02-15 05:05:03'),
 (10,716,'2006-02-15 05:05:03'),
 (10,782,'2006-02-15 05:05:03'),
 (10,914,'2006-02-15 05:05:03'),
 (10,929,'2006-02-15 05:05:03'),
 (10,930,'2006-02-15 05:05:03'),
 (10,964,'2006-02-15 05:05:03'),
 (10,966,'2006-02-15 05:05:03'),
 (10,980,'2006-02-15 05:05:03'),
 (10,983,'2006-02-15 05:05:03'),
 (11,118,'2006-02-15 05:05:03'),
 (11,205,'2006-02-15 05:05:03'),
 (11,281,'2006-02-15 05:05:03'),
 (11,283,'2006-02-15 05:05:03'),
 (11,348,'2006-02-15 05:05:03'),
 (11,364,'2006-02-15 05:05:03'),
 (11,395,'2006-02-15 05:05:03'),
 (11,429,'2006-02-15 05:05:03'),
 (11,433,'2006-02-15 05:05:03'),
 (11,453,'2006-02-15 05:05:03'),
 (11,485,'2006-02-15 05:05:03'),
 (11,532,'2006-02-15 05:05:03'),
 (11,567,'2006-02-15 05:05:03'),
 (11,587,'2006-02-15 05:05:03'),
 (11,597,'2006-02-15 05:05:03'),
 (11,636,'2006-02-15 05:05:03'),
 (11,709,'2006-02-15 05:05:03'),
 (11,850,'2006-02-15 05:05:03'),
 (11,854,'2006-02-15 05:05:03'),
 (11,888,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (11,896,'2006-02-15 05:05:03'),
 (11,928,'2006-02-15 05:05:03'),
 (11,938,'2006-02-15 05:05:03'),
 (11,969,'2006-02-15 05:05:03'),
 (11,988,'2006-02-15 05:05:03'),
 (12,16,'2006-02-15 05:05:03'),
 (12,17,'2006-02-15 05:05:03'),
 (12,34,'2006-02-15 05:05:03'),
 (12,37,'2006-02-15 05:05:03'),
 (12,91,'2006-02-15 05:05:03'),
 (12,92,'2006-02-15 05:05:03'),
 (12,107,'2006-02-15 05:05:03'),
 (12,155,'2006-02-15 05:05:03'),
 (12,177,'2006-02-15 05:05:03'),
 (12,208,'2006-02-15 05:05:03'),
 (12,213,'2006-02-15 05:05:03'),
 (12,216,'2006-02-15 05:05:03'),
 (12,243,'2006-02-15 05:05:03'),
 (12,344,'2006-02-15 05:05:03'),
 (12,400,'2006-02-15 05:05:03'),
 (12,416,'2006-02-15 05:05:03'),
 (12,420,'2006-02-15 05:05:03'),
 (12,457,'2006-02-15 05:05:03'),
 (12,513,'2006-02-15 05:05:03'),
 (12,540,'2006-02-15 05:05:03'),
 (12,593,'2006-02-15 05:05:03'),
 (12,631,'2006-02-15 05:05:03'),
 (12,635,'2006-02-15 05:05:03'),
 (12,672,'2006-02-15 05:05:03'),
 (12,716,'2006-02-15 05:05:03'),
 (12,728,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (12,812,'2006-02-15 05:05:03'),
 (12,838,'2006-02-15 05:05:03'),
 (12,871,'2006-02-15 05:05:03'),
 (12,880,'2006-02-15 05:05:03'),
 (12,945,'2006-02-15 05:05:03'),
 (13,17,'2006-02-15 05:05:03'),
 (13,29,'2006-02-15 05:05:03'),
 (13,45,'2006-02-15 05:05:03'),
 (13,87,'2006-02-15 05:05:03'),
 (13,110,'2006-02-15 05:05:03'),
 (13,144,'2006-02-15 05:05:03'),
 (13,154,'2006-02-15 05:05:03'),
 (13,162,'2006-02-15 05:05:03'),
 (13,203,'2006-02-15 05:05:03'),
 (13,254,'2006-02-15 05:05:03'),
 (13,337,'2006-02-15 05:05:03'),
 (13,346,'2006-02-15 05:05:03'),
 (13,381,'2006-02-15 05:05:03'),
 (13,385,'2006-02-15 05:05:03'),
 (13,427,'2006-02-15 05:05:03'),
 (13,456,'2006-02-15 05:05:03'),
 (13,513,'2006-02-15 05:05:03'),
 (13,515,'2006-02-15 05:05:03'),
 (13,522,'2006-02-15 05:05:03'),
 (13,524,'2006-02-15 05:05:03'),
 (13,528,'2006-02-15 05:05:03'),
 (13,571,'2006-02-15 05:05:03'),
 (13,588,'2006-02-15 05:05:03'),
 (13,597,'2006-02-15 05:05:03'),
 (13,600,'2006-02-15 05:05:03'),
 (13,718,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (13,729,'2006-02-15 05:05:03'),
 (13,816,'2006-02-15 05:05:03'),
 (13,817,'2006-02-15 05:05:03'),
 (13,832,'2006-02-15 05:05:03'),
 (13,833,'2006-02-15 05:05:03'),
 (13,843,'2006-02-15 05:05:03'),
 (13,897,'2006-02-15 05:05:03'),
 (13,966,'2006-02-15 05:05:03'),
 (13,998,'2006-02-15 05:05:03'),
 (14,154,'2006-02-15 05:05:03'),
 (14,187,'2006-02-15 05:05:03'),
 (14,232,'2006-02-15 05:05:03'),
 (14,241,'2006-02-15 05:05:03'),
 (14,253,'2006-02-15 05:05:03'),
 (14,255,'2006-02-15 05:05:03'),
 (14,258,'2006-02-15 05:05:03'),
 (14,284,'2006-02-15 05:05:03'),
 (14,292,'2006-02-15 05:05:03'),
 (14,370,'2006-02-15 05:05:03'),
 (14,415,'2006-02-15 05:05:03'),
 (14,417,'2006-02-15 05:05:03'),
 (14,418,'2006-02-15 05:05:03'),
 (14,454,'2006-02-15 05:05:03'),
 (14,472,'2006-02-15 05:05:03'),
 (14,475,'2006-02-15 05:05:03'),
 (14,495,'2006-02-15 05:05:03'),
 (14,536,'2006-02-15 05:05:03'),
 (14,537,'2006-02-15 05:05:03'),
 (14,612,'2006-02-15 05:05:03'),
 (14,688,'2006-02-15 05:05:03'),
 (14,759,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (14,764,'2006-02-15 05:05:03'),
 (14,847,'2006-02-15 05:05:03'),
 (14,856,'2006-02-15 05:05:03'),
 (14,890,'2006-02-15 05:05:03'),
 (14,908,'2006-02-15 05:05:03'),
 (14,919,'2006-02-15 05:05:03'),
 (14,948,'2006-02-15 05:05:03'),
 (14,970,'2006-02-15 05:05:03'),
 (15,31,'2006-02-15 05:05:03'),
 (15,89,'2006-02-15 05:05:03'),
 (15,91,'2006-02-15 05:05:03'),
 (15,108,'2006-02-15 05:05:03'),
 (15,125,'2006-02-15 05:05:03'),
 (15,236,'2006-02-15 05:05:03'),
 (15,275,'2006-02-15 05:05:03'),
 (15,280,'2006-02-15 05:05:03'),
 (15,326,'2006-02-15 05:05:03'),
 (15,342,'2006-02-15 05:05:03'),
 (15,414,'2006-02-15 05:05:03'),
 (15,445,'2006-02-15 05:05:03'),
 (15,500,'2006-02-15 05:05:03'),
 (15,502,'2006-02-15 05:05:03'),
 (15,541,'2006-02-15 05:05:03'),
 (15,553,'2006-02-15 05:05:03'),
 (15,594,'2006-02-15 05:05:03'),
 (15,626,'2006-02-15 05:05:03'),
 (15,635,'2006-02-15 05:05:03'),
 (15,745,'2006-02-15 05:05:03'),
 (15,783,'2006-02-15 05:05:03'),
 (15,795,'2006-02-15 05:05:03'),
 (15,817,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (15,886,'2006-02-15 05:05:03'),
 (15,924,'2006-02-15 05:05:03'),
 (15,949,'2006-02-15 05:05:03'),
 (15,968,'2006-02-15 05:05:03'),
 (15,985,'2006-02-15 05:05:03'),
 (16,80,'2006-02-15 05:05:03'),
 (16,87,'2006-02-15 05:05:03'),
 (16,101,'2006-02-15 05:05:03'),
 (16,121,'2006-02-15 05:05:03'),
 (16,155,'2006-02-15 05:05:03'),
 (16,177,'2006-02-15 05:05:03'),
 (16,218,'2006-02-15 05:05:03'),
 (16,221,'2006-02-15 05:05:03'),
 (16,267,'2006-02-15 05:05:03'),
 (16,269,'2006-02-15 05:05:03'),
 (16,271,'2006-02-15 05:05:03'),
 (16,280,'2006-02-15 05:05:03'),
 (16,287,'2006-02-15 05:05:03'),
 (16,345,'2006-02-15 05:05:03'),
 (16,438,'2006-02-15 05:05:03'),
 (16,453,'2006-02-15 05:05:03'),
 (16,455,'2006-02-15 05:05:03'),
 (16,456,'2006-02-15 05:05:03'),
 (16,503,'2006-02-15 05:05:03'),
 (16,548,'2006-02-15 05:05:03'),
 (16,582,'2006-02-15 05:05:03'),
 (16,583,'2006-02-15 05:05:03'),
 (16,717,'2006-02-15 05:05:03'),
 (16,758,'2006-02-15 05:05:03'),
 (16,779,'2006-02-15 05:05:03'),
 (16,886,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (16,967,'2006-02-15 05:05:03'),
 (17,96,'2006-02-15 05:05:03'),
 (17,119,'2006-02-15 05:05:03'),
 (17,124,'2006-02-15 05:05:03'),
 (17,127,'2006-02-15 05:05:03'),
 (17,154,'2006-02-15 05:05:03'),
 (17,199,'2006-02-15 05:05:03'),
 (17,201,'2006-02-15 05:05:03'),
 (17,236,'2006-02-15 05:05:03'),
 (17,280,'2006-02-15 05:05:03'),
 (17,310,'2006-02-15 05:05:03'),
 (17,313,'2006-02-15 05:05:03'),
 (17,378,'2006-02-15 05:05:03'),
 (17,457,'2006-02-15 05:05:03'),
 (17,469,'2006-02-15 05:05:03'),
 (17,478,'2006-02-15 05:05:03'),
 (17,500,'2006-02-15 05:05:03'),
 (17,515,'2006-02-15 05:05:03'),
 (17,521,'2006-02-15 05:05:03'),
 (17,573,'2006-02-15 05:05:03'),
 (17,603,'2006-02-15 05:05:03'),
 (17,606,'2006-02-15 05:05:03'),
 (17,734,'2006-02-15 05:05:03'),
 (17,770,'2006-02-15 05:05:03'),
 (17,794,'2006-02-15 05:05:03'),
 (17,800,'2006-02-15 05:05:03'),
 (17,853,'2006-02-15 05:05:03'),
 (17,873,'2006-02-15 05:05:03'),
 (17,874,'2006-02-15 05:05:03'),
 (17,880,'2006-02-15 05:05:03'),
 (17,948,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (17,957,'2006-02-15 05:05:03'),
 (17,959,'2006-02-15 05:05:03'),
 (18,44,'2006-02-15 05:05:03'),
 (18,84,'2006-02-15 05:05:03'),
 (18,144,'2006-02-15 05:05:03'),
 (18,172,'2006-02-15 05:05:03'),
 (18,268,'2006-02-15 05:05:03'),
 (18,279,'2006-02-15 05:05:03'),
 (18,280,'2006-02-15 05:05:03'),
 (18,321,'2006-02-15 05:05:03'),
 (18,386,'2006-02-15 05:05:03'),
 (18,460,'2006-02-15 05:05:03'),
 (18,462,'2006-02-15 05:05:03'),
 (18,484,'2006-02-15 05:05:03'),
 (18,536,'2006-02-15 05:05:03'),
 (18,561,'2006-02-15 05:05:03'),
 (18,612,'2006-02-15 05:05:03'),
 (18,717,'2006-02-15 05:05:03'),
 (18,808,'2006-02-15 05:05:03'),
 (18,842,'2006-02-15 05:05:03'),
 (18,863,'2006-02-15 05:05:03'),
 (18,883,'2006-02-15 05:05:03'),
 (18,917,'2006-02-15 05:05:03'),
 (18,944,'2006-02-15 05:05:03'),
 (19,2,'2006-02-15 05:05:03'),
 (19,3,'2006-02-15 05:05:03'),
 (19,144,'2006-02-15 05:05:03'),
 (19,152,'2006-02-15 05:05:03'),
 (19,182,'2006-02-15 05:05:03'),
 (19,208,'2006-02-15 05:05:03'),
 (19,212,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (19,217,'2006-02-15 05:05:03'),
 (19,266,'2006-02-15 05:05:03'),
 (19,404,'2006-02-15 05:05:03'),
 (19,428,'2006-02-15 05:05:03'),
 (19,473,'2006-02-15 05:05:03'),
 (19,490,'2006-02-15 05:05:03'),
 (19,510,'2006-02-15 05:05:03'),
 (19,513,'2006-02-15 05:05:03'),
 (19,644,'2006-02-15 05:05:03'),
 (19,670,'2006-02-15 05:05:03'),
 (19,673,'2006-02-15 05:05:03'),
 (19,711,'2006-02-15 05:05:03'),
 (19,750,'2006-02-15 05:05:03'),
 (19,752,'2006-02-15 05:05:03'),
 (19,756,'2006-02-15 05:05:03'),
 (19,771,'2006-02-15 05:05:03'),
 (19,785,'2006-02-15 05:05:03'),
 (19,877,'2006-02-15 05:05:03'),
 (20,1,'2006-02-15 05:05:03'),
 (20,54,'2006-02-15 05:05:03'),
 (20,63,'2006-02-15 05:05:03'),
 (20,140,'2006-02-15 05:05:03'),
 (20,146,'2006-02-15 05:05:03'),
 (20,165,'2006-02-15 05:05:03'),
 (20,231,'2006-02-15 05:05:03'),
 (20,243,'2006-02-15 05:05:03'),
 (20,269,'2006-02-15 05:05:03'),
 (20,274,'2006-02-15 05:05:03'),
 (20,348,'2006-02-15 05:05:03'),
 (20,366,'2006-02-15 05:05:03'),
 (20,445,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (20,478,'2006-02-15 05:05:03'),
 (20,492,'2006-02-15 05:05:03'),
 (20,499,'2006-02-15 05:05:03'),
 (20,527,'2006-02-15 05:05:03'),
 (20,531,'2006-02-15 05:05:03'),
 (20,538,'2006-02-15 05:05:03'),
 (20,589,'2006-02-15 05:05:03'),
 (20,643,'2006-02-15 05:05:03'),
 (20,652,'2006-02-15 05:05:03'),
 (20,663,'2006-02-15 05:05:03'),
 (20,714,'2006-02-15 05:05:03'),
 (20,717,'2006-02-15 05:05:03'),
 (20,757,'2006-02-15 05:05:03'),
 (20,784,'2006-02-15 05:05:03'),
 (20,863,'2006-02-15 05:05:03'),
 (20,962,'2006-02-15 05:05:03'),
 (20,977,'2006-02-15 05:05:03'),
 (21,6,'2006-02-15 05:05:03'),
 (21,87,'2006-02-15 05:05:03'),
 (21,88,'2006-02-15 05:05:03'),
 (21,142,'2006-02-15 05:05:03'),
 (21,159,'2006-02-15 05:05:03'),
 (21,179,'2006-02-15 05:05:03'),
 (21,253,'2006-02-15 05:05:03'),
 (21,281,'2006-02-15 05:05:03'),
 (21,321,'2006-02-15 05:05:03'),
 (21,398,'2006-02-15 05:05:03'),
 (21,426,'2006-02-15 05:05:03'),
 (21,429,'2006-02-15 05:05:03'),
 (21,497,'2006-02-15 05:05:03'),
 (21,507,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (21,530,'2006-02-15 05:05:03'),
 (21,680,'2006-02-15 05:05:03'),
 (21,686,'2006-02-15 05:05:03'),
 (21,700,'2006-02-15 05:05:03'),
 (21,702,'2006-02-15 05:05:03'),
 (21,733,'2006-02-15 05:05:03'),
 (21,734,'2006-02-15 05:05:03'),
 (21,798,'2006-02-15 05:05:03'),
 (21,804,'2006-02-15 05:05:03'),
 (21,887,'2006-02-15 05:05:03'),
 (21,893,'2006-02-15 05:05:03'),
 (21,920,'2006-02-15 05:05:03'),
 (21,983,'2006-02-15 05:05:03'),
 (22,9,'2006-02-15 05:05:03'),
 (22,23,'2006-02-15 05:05:03'),
 (22,56,'2006-02-15 05:05:03'),
 (22,89,'2006-02-15 05:05:03'),
 (22,111,'2006-02-15 05:05:03'),
 (22,146,'2006-02-15 05:05:03'),
 (22,291,'2006-02-15 05:05:03'),
 (22,294,'2006-02-15 05:05:03'),
 (22,349,'2006-02-15 05:05:03'),
 (22,369,'2006-02-15 05:05:03'),
 (22,418,'2006-02-15 05:05:03'),
 (22,430,'2006-02-15 05:05:03'),
 (22,483,'2006-02-15 05:05:03'),
 (22,491,'2006-02-15 05:05:03'),
 (22,495,'2006-02-15 05:05:03'),
 (22,536,'2006-02-15 05:05:03'),
 (22,600,'2006-02-15 05:05:03'),
 (22,634,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (22,648,'2006-02-15 05:05:03'),
 (22,688,'2006-02-15 05:05:03'),
 (22,731,'2006-02-15 05:05:03'),
 (22,742,'2006-02-15 05:05:03'),
 (22,775,'2006-02-15 05:05:03'),
 (22,802,'2006-02-15 05:05:03'),
 (22,912,'2006-02-15 05:05:03'),
 (22,964,'2006-02-15 05:05:03'),
 (23,6,'2006-02-15 05:05:03'),
 (23,42,'2006-02-15 05:05:03'),
 (23,78,'2006-02-15 05:05:03'),
 (23,105,'2006-02-15 05:05:03'),
 (23,116,'2006-02-15 05:05:03'),
 (23,117,'2006-02-15 05:05:03'),
 (23,125,'2006-02-15 05:05:03'),
 (23,212,'2006-02-15 05:05:03'),
 (23,226,'2006-02-15 05:05:03'),
 (23,235,'2006-02-15 05:05:03'),
 (23,254,'2006-02-15 05:05:03'),
 (23,367,'2006-02-15 05:05:03'),
 (23,370,'2006-02-15 05:05:03'),
 (23,414,'2006-02-15 05:05:03'),
 (23,419,'2006-02-15 05:05:03'),
 (23,435,'2006-02-15 05:05:03'),
 (23,449,'2006-02-15 05:05:03'),
 (23,491,'2006-02-15 05:05:03'),
 (23,536,'2006-02-15 05:05:03'),
 (23,549,'2006-02-15 05:05:03'),
 (23,636,'2006-02-15 05:05:03'),
 (23,649,'2006-02-15 05:05:03'),
 (23,673,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (23,691,'2006-02-15 05:05:03'),
 (23,766,'2006-02-15 05:05:03'),
 (23,782,'2006-02-15 05:05:03'),
 (23,804,'2006-02-15 05:05:03'),
 (23,820,'2006-02-15 05:05:03'),
 (23,826,'2006-02-15 05:05:03'),
 (23,833,'2006-02-15 05:05:03'),
 (23,842,'2006-02-15 05:05:03'),
 (23,853,'2006-02-15 05:05:03'),
 (23,855,'2006-02-15 05:05:03'),
 (23,856,'2006-02-15 05:05:03'),
 (23,935,'2006-02-15 05:05:03'),
 (23,981,'2006-02-15 05:05:03'),
 (23,997,'2006-02-15 05:05:03'),
 (24,3,'2006-02-15 05:05:03'),
 (24,83,'2006-02-15 05:05:03'),
 (24,112,'2006-02-15 05:05:03'),
 (24,126,'2006-02-15 05:05:03'),
 (24,148,'2006-02-15 05:05:03'),
 (24,164,'2006-02-15 05:05:03'),
 (24,178,'2006-02-15 05:05:03'),
 (24,194,'2006-02-15 05:05:03'),
 (24,199,'2006-02-15 05:05:03'),
 (24,242,'2006-02-15 05:05:03'),
 (24,256,'2006-02-15 05:05:03'),
 (24,277,'2006-02-15 05:05:03'),
 (24,335,'2006-02-15 05:05:03'),
 (24,405,'2006-02-15 05:05:03'),
 (24,463,'2006-02-15 05:05:03'),
 (24,515,'2006-02-15 05:05:03'),
 (24,585,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (24,603,'2006-02-15 05:05:03'),
 (24,653,'2006-02-15 05:05:03'),
 (24,704,'2006-02-15 05:05:03'),
 (24,781,'2006-02-15 05:05:03'),
 (24,829,'2006-02-15 05:05:03'),
 (24,832,'2006-02-15 05:05:03'),
 (24,969,'2006-02-15 05:05:03'),
 (25,21,'2006-02-15 05:05:03'),
 (25,86,'2006-02-15 05:05:03'),
 (25,153,'2006-02-15 05:05:03'),
 (25,179,'2006-02-15 05:05:03'),
 (25,204,'2006-02-15 05:05:03'),
 (25,213,'2006-02-15 05:05:03'),
 (25,226,'2006-02-15 05:05:03'),
 (25,245,'2006-02-15 05:05:03'),
 (25,311,'2006-02-15 05:05:03'),
 (25,404,'2006-02-15 05:05:03'),
 (25,411,'2006-02-15 05:05:03'),
 (25,420,'2006-02-15 05:05:03'),
 (25,538,'2006-02-15 05:05:03'),
 (25,564,'2006-02-15 05:05:03'),
 (25,583,'2006-02-15 05:05:03'),
 (25,606,'2006-02-15 05:05:03'),
 (25,688,'2006-02-15 05:05:03'),
 (25,697,'2006-02-15 05:05:03'),
 (25,755,'2006-02-15 05:05:03'),
 (25,871,'2006-02-15 05:05:03'),
 (25,914,'2006-02-15 05:05:03'),
 (26,9,'2006-02-15 05:05:03'),
 (26,21,'2006-02-15 05:05:03'),
 (26,34,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (26,90,'2006-02-15 05:05:03'),
 (26,93,'2006-02-15 05:05:03'),
 (26,103,'2006-02-15 05:05:03'),
 (26,147,'2006-02-15 05:05:03'),
 (26,186,'2006-02-15 05:05:03'),
 (26,201,'2006-02-15 05:05:03'),
 (26,225,'2006-02-15 05:05:03'),
 (26,241,'2006-02-15 05:05:03'),
 (26,327,'2006-02-15 05:05:03'),
 (26,329,'2006-02-15 05:05:03'),
 (26,340,'2006-02-15 05:05:03'),
 (26,345,'2006-02-15 05:05:03'),
 (26,390,'2006-02-15 05:05:03'),
 (26,392,'2006-02-15 05:05:03'),
 (26,529,'2006-02-15 05:05:03'),
 (26,544,'2006-02-15 05:05:03'),
 (26,564,'2006-02-15 05:05:03'),
 (26,635,'2006-02-15 05:05:03'),
 (26,644,'2006-02-15 05:05:03'),
 (26,682,'2006-02-15 05:05:03'),
 (26,688,'2006-02-15 05:05:03'),
 (26,715,'2006-02-15 05:05:03'),
 (26,732,'2006-02-15 05:05:03'),
 (26,758,'2006-02-15 05:05:03'),
 (26,764,'2006-02-15 05:05:03'),
 (26,795,'2006-02-15 05:05:03'),
 (26,821,'2006-02-15 05:05:03'),
 (26,885,'2006-02-15 05:05:03'),
 (26,904,'2006-02-15 05:05:03'),
 (26,906,'2006-02-15 05:05:03'),
 (27,19,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (27,34,'2006-02-15 05:05:03'),
 (27,85,'2006-02-15 05:05:03'),
 (27,150,'2006-02-15 05:05:03'),
 (27,172,'2006-02-15 05:05:03'),
 (27,273,'2006-02-15 05:05:03'),
 (27,334,'2006-02-15 05:05:03'),
 (27,347,'2006-02-15 05:05:03'),
 (27,359,'2006-02-15 05:05:03'),
 (27,398,'2006-02-15 05:05:03'),
 (27,415,'2006-02-15 05:05:03'),
 (27,462,'2006-02-15 05:05:03'),
 (27,477,'2006-02-15 05:05:03'),
 (27,500,'2006-02-15 05:05:03'),
 (27,503,'2006-02-15 05:05:03'),
 (27,540,'2006-02-15 05:05:03'),
 (27,586,'2006-02-15 05:05:03'),
 (27,593,'2006-02-15 05:05:03'),
 (27,637,'2006-02-15 05:05:03'),
 (27,679,'2006-02-15 05:05:03'),
 (27,682,'2006-02-15 05:05:03'),
 (27,695,'2006-02-15 05:05:03'),
 (27,771,'2006-02-15 05:05:03'),
 (27,805,'2006-02-15 05:05:03'),
 (27,830,'2006-02-15 05:05:03'),
 (27,854,'2006-02-15 05:05:03'),
 (27,873,'2006-02-15 05:05:03'),
 (27,880,'2006-02-15 05:05:03'),
 (27,889,'2006-02-15 05:05:03'),
 (27,904,'2006-02-15 05:05:03'),
 (27,967,'2006-02-15 05:05:03'),
 (27,986,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (27,996,'2006-02-15 05:05:03'),
 (28,14,'2006-02-15 05:05:03'),
 (28,43,'2006-02-15 05:05:03'),
 (28,58,'2006-02-15 05:05:03'),
 (28,74,'2006-02-15 05:05:03'),
 (28,96,'2006-02-15 05:05:03'),
 (28,107,'2006-02-15 05:05:03'),
 (28,259,'2006-02-15 05:05:03'),
 (28,263,'2006-02-15 05:05:03'),
 (28,287,'2006-02-15 05:05:03'),
 (28,358,'2006-02-15 05:05:03'),
 (28,502,'2006-02-15 05:05:03'),
 (28,508,'2006-02-15 05:05:03'),
 (28,532,'2006-02-15 05:05:03'),
 (28,551,'2006-02-15 05:05:03'),
 (28,574,'2006-02-15 05:05:03'),
 (28,597,'2006-02-15 05:05:03'),
 (28,619,'2006-02-15 05:05:03'),
 (28,625,'2006-02-15 05:05:03'),
 (28,652,'2006-02-15 05:05:03'),
 (28,679,'2006-02-15 05:05:03'),
 (28,743,'2006-02-15 05:05:03'),
 (28,790,'2006-02-15 05:05:03'),
 (28,793,'2006-02-15 05:05:03'),
 (28,816,'2006-02-15 05:05:03'),
 (28,827,'2006-02-15 05:05:03'),
 (28,835,'2006-02-15 05:05:03'),
 (28,879,'2006-02-15 05:05:03'),
 (28,908,'2006-02-15 05:05:03'),
 (28,953,'2006-02-15 05:05:03'),
 (28,973,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (28,994,'2006-02-15 05:05:03'),
 (29,10,'2006-02-15 05:05:03'),
 (29,79,'2006-02-15 05:05:03'),
 (29,105,'2006-02-15 05:05:03'),
 (29,110,'2006-02-15 05:05:03'),
 (29,131,'2006-02-15 05:05:03'),
 (29,133,'2006-02-15 05:05:03'),
 (29,172,'2006-02-15 05:05:03'),
 (29,226,'2006-02-15 05:05:03'),
 (29,273,'2006-02-15 05:05:03'),
 (29,282,'2006-02-15 05:05:03'),
 (29,296,'2006-02-15 05:05:03'),
 (29,311,'2006-02-15 05:05:03'),
 (29,335,'2006-02-15 05:05:03'),
 (29,342,'2006-02-15 05:05:03'),
 (29,436,'2006-02-15 05:05:03'),
 (29,444,'2006-02-15 05:05:03'),
 (29,449,'2006-02-15 05:05:03'),
 (29,462,'2006-02-15 05:05:03'),
 (29,482,'2006-02-15 05:05:03'),
 (29,488,'2006-02-15 05:05:03'),
 (29,519,'2006-02-15 05:05:03'),
 (29,547,'2006-02-15 05:05:03'),
 (29,590,'2006-02-15 05:05:03'),
 (29,646,'2006-02-15 05:05:03'),
 (29,723,'2006-02-15 05:05:03'),
 (29,812,'2006-02-15 05:05:03'),
 (29,862,'2006-02-15 05:05:03'),
 (29,928,'2006-02-15 05:05:03'),
 (29,944,'2006-02-15 05:05:03'),
 (30,1,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (30,53,'2006-02-15 05:05:03'),
 (30,64,'2006-02-15 05:05:03'),
 (30,69,'2006-02-15 05:05:03'),
 (30,77,'2006-02-15 05:05:03'),
 (30,87,'2006-02-15 05:05:03'),
 (30,260,'2006-02-15 05:05:03'),
 (30,262,'2006-02-15 05:05:03'),
 (30,286,'2006-02-15 05:05:03'),
 (30,292,'2006-02-15 05:05:03'),
 (30,301,'2006-02-15 05:05:03'),
 (30,318,'2006-02-15 05:05:03'),
 (30,321,'2006-02-15 05:05:03'),
 (30,357,'2006-02-15 05:05:03'),
 (30,565,'2006-02-15 05:05:03'),
 (30,732,'2006-02-15 05:05:03'),
 (30,797,'2006-02-15 05:05:03'),
 (30,838,'2006-02-15 05:05:03'),
 (30,945,'2006-02-15 05:05:03'),
 (31,88,'2006-02-15 05:05:03'),
 (31,146,'2006-02-15 05:05:03'),
 (31,163,'2006-02-15 05:05:03'),
 (31,164,'2006-02-15 05:05:03'),
 (31,188,'2006-02-15 05:05:03'),
 (31,299,'2006-02-15 05:05:03'),
 (31,308,'2006-02-15 05:05:03'),
 (31,368,'2006-02-15 05:05:03'),
 (31,380,'2006-02-15 05:05:03'),
 (31,431,'2006-02-15 05:05:03'),
 (31,585,'2006-02-15 05:05:03'),
 (31,637,'2006-02-15 05:05:03'),
 (31,700,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (31,739,'2006-02-15 05:05:03'),
 (31,793,'2006-02-15 05:05:03'),
 (31,802,'2006-02-15 05:05:03'),
 (31,880,'2006-02-15 05:05:03'),
 (31,978,'2006-02-15 05:05:03'),
 (32,65,'2006-02-15 05:05:03'),
 (32,84,'2006-02-15 05:05:03'),
 (32,103,'2006-02-15 05:05:03'),
 (32,112,'2006-02-15 05:05:03'),
 (32,136,'2006-02-15 05:05:03'),
 (32,197,'2006-02-15 05:05:03'),
 (32,199,'2006-02-15 05:05:03'),
 (32,219,'2006-02-15 05:05:03'),
 (32,309,'2006-02-15 05:05:03'),
 (32,312,'2006-02-15 05:05:03'),
 (32,401,'2006-02-15 05:05:03'),
 (32,427,'2006-02-15 05:05:03'),
 (32,431,'2006-02-15 05:05:03'),
 (32,523,'2006-02-15 05:05:03'),
 (32,567,'2006-02-15 05:05:03'),
 (32,585,'2006-02-15 05:05:03'),
 (32,606,'2006-02-15 05:05:03'),
 (32,651,'2006-02-15 05:05:03'),
 (32,667,'2006-02-15 05:05:03'),
 (32,669,'2006-02-15 05:05:03'),
 (32,815,'2006-02-15 05:05:03'),
 (32,928,'2006-02-15 05:05:03'),
 (32,980,'2006-02-15 05:05:03'),
 (33,56,'2006-02-15 05:05:03'),
 (33,112,'2006-02-15 05:05:03'),
 (33,135,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (33,154,'2006-02-15 05:05:03'),
 (33,214,'2006-02-15 05:05:03'),
 (33,252,'2006-02-15 05:05:03'),
 (33,305,'2006-02-15 05:05:03'),
 (33,306,'2006-02-15 05:05:03'),
 (33,473,'2006-02-15 05:05:03'),
 (33,489,'2006-02-15 05:05:03'),
 (33,574,'2006-02-15 05:05:03'),
 (33,618,'2006-02-15 05:05:03'),
 (33,667,'2006-02-15 05:05:03'),
 (33,694,'2006-02-15 05:05:03'),
 (33,712,'2006-02-15 05:05:03'),
 (33,735,'2006-02-15 05:05:03'),
 (33,737,'2006-02-15 05:05:03'),
 (33,754,'2006-02-15 05:05:03'),
 (33,775,'2006-02-15 05:05:03'),
 (33,878,'2006-02-15 05:05:03'),
 (33,881,'2006-02-15 05:05:03'),
 (33,965,'2006-02-15 05:05:03'),
 (33,972,'2006-02-15 05:05:03'),
 (33,993,'2006-02-15 05:05:03'),
 (34,43,'2006-02-15 05:05:03'),
 (34,90,'2006-02-15 05:05:03'),
 (34,119,'2006-02-15 05:05:03'),
 (34,125,'2006-02-15 05:05:03'),
 (34,172,'2006-02-15 05:05:03'),
 (34,182,'2006-02-15 05:05:03'),
 (34,244,'2006-02-15 05:05:03'),
 (34,336,'2006-02-15 05:05:03'),
 (34,389,'2006-02-15 05:05:03'),
 (34,393,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (34,438,'2006-02-15 05:05:03'),
 (34,493,'2006-02-15 05:05:03'),
 (34,502,'2006-02-15 05:05:03'),
 (34,525,'2006-02-15 05:05:03'),
 (34,668,'2006-02-15 05:05:03'),
 (34,720,'2006-02-15 05:05:03'),
 (34,779,'2006-02-15 05:05:03'),
 (34,788,'2006-02-15 05:05:03'),
 (34,794,'2006-02-15 05:05:03'),
 (34,836,'2006-02-15 05:05:03'),
 (34,846,'2006-02-15 05:05:03'),
 (34,853,'2006-02-15 05:05:03'),
 (34,929,'2006-02-15 05:05:03'),
 (34,950,'2006-02-15 05:05:03'),
 (34,971,'2006-02-15 05:05:03'),
 (35,10,'2006-02-15 05:05:03'),
 (35,35,'2006-02-15 05:05:03'),
 (35,52,'2006-02-15 05:05:03'),
 (35,201,'2006-02-15 05:05:03'),
 (35,256,'2006-02-15 05:05:03'),
 (35,389,'2006-02-15 05:05:03'),
 (35,589,'2006-02-15 05:05:03'),
 (35,612,'2006-02-15 05:05:03'),
 (35,615,'2006-02-15 05:05:03'),
 (35,707,'2006-02-15 05:05:03'),
 (35,732,'2006-02-15 05:05:03'),
 (35,738,'2006-02-15 05:05:03'),
 (35,748,'2006-02-15 05:05:03'),
 (35,817,'2006-02-15 05:05:03'),
 (35,914,'2006-02-15 05:05:03'),
 (36,15,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (36,81,'2006-02-15 05:05:03'),
 (36,171,'2006-02-15 05:05:03'),
 (36,231,'2006-02-15 05:05:03'),
 (36,245,'2006-02-15 05:05:03'),
 (36,283,'2006-02-15 05:05:03'),
 (36,380,'2006-02-15 05:05:03'),
 (36,381,'2006-02-15 05:05:03'),
 (36,387,'2006-02-15 05:05:03'),
 (36,390,'2006-02-15 05:05:03'),
 (36,410,'2006-02-15 05:05:03'),
 (36,426,'2006-02-15 05:05:03'),
 (36,427,'2006-02-15 05:05:03'),
 (36,453,'2006-02-15 05:05:03'),
 (36,466,'2006-02-15 05:05:03'),
 (36,484,'2006-02-15 05:05:03'),
 (36,493,'2006-02-15 05:05:03'),
 (36,499,'2006-02-15 05:05:03'),
 (36,569,'2006-02-15 05:05:03'),
 (36,590,'2006-02-15 05:05:03'),
 (36,600,'2006-02-15 05:05:03'),
 (36,714,'2006-02-15 05:05:03'),
 (36,715,'2006-02-15 05:05:03'),
 (36,716,'2006-02-15 05:05:03'),
 (36,731,'2006-02-15 05:05:03'),
 (36,875,'2006-02-15 05:05:03'),
 (36,915,'2006-02-15 05:05:03'),
 (36,931,'2006-02-15 05:05:03'),
 (36,956,'2006-02-15 05:05:03'),
 (37,10,'2006-02-15 05:05:03'),
 (37,12,'2006-02-15 05:05:03'),
 (37,19,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (37,118,'2006-02-15 05:05:03'),
 (37,119,'2006-02-15 05:05:03'),
 (37,122,'2006-02-15 05:05:03'),
 (37,146,'2006-02-15 05:05:03'),
 (37,204,'2006-02-15 05:05:03'),
 (37,253,'2006-02-15 05:05:03'),
 (37,260,'2006-02-15 05:05:03'),
 (37,277,'2006-02-15 05:05:03'),
 (37,317,'2006-02-15 05:05:03'),
 (37,467,'2006-02-15 05:05:03'),
 (37,477,'2006-02-15 05:05:03'),
 (37,485,'2006-02-15 05:05:03'),
 (37,508,'2006-02-15 05:05:03'),
 (37,529,'2006-02-15 05:05:03'),
 (37,553,'2006-02-15 05:05:03'),
 (37,555,'2006-02-15 05:05:03'),
 (37,572,'2006-02-15 05:05:03'),
 (37,588,'2006-02-15 05:05:03'),
 (37,662,'2006-02-15 05:05:03'),
 (37,663,'2006-02-15 05:05:03'),
 (37,694,'2006-02-15 05:05:03'),
 (37,697,'2006-02-15 05:05:03'),
 (37,785,'2006-02-15 05:05:03'),
 (37,839,'2006-02-15 05:05:03'),
 (37,840,'2006-02-15 05:05:03'),
 (37,853,'2006-02-15 05:05:03'),
 (37,900,'2006-02-15 05:05:03'),
 (37,925,'2006-02-15 05:05:03'),
 (37,963,'2006-02-15 05:05:03'),
 (37,966,'2006-02-15 05:05:03'),
 (37,989,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (37,997,'2006-02-15 05:05:03'),
 (38,24,'2006-02-15 05:05:03'),
 (38,111,'2006-02-15 05:05:03'),
 (38,160,'2006-02-15 05:05:03'),
 (38,176,'2006-02-15 05:05:03'),
 (38,223,'2006-02-15 05:05:03'),
 (38,241,'2006-02-15 05:05:03'),
 (38,274,'2006-02-15 05:05:03'),
 (38,335,'2006-02-15 05:05:03'),
 (38,338,'2006-02-15 05:05:03'),
 (38,353,'2006-02-15 05:05:03'),
 (38,448,'2006-02-15 05:05:03'),
 (38,450,'2006-02-15 05:05:03'),
 (38,458,'2006-02-15 05:05:03'),
 (38,501,'2006-02-15 05:05:03'),
 (38,516,'2006-02-15 05:05:03'),
 (38,547,'2006-02-15 05:05:03'),
 (38,583,'2006-02-15 05:05:03'),
 (38,618,'2006-02-15 05:05:03'),
 (38,619,'2006-02-15 05:05:03'),
 (38,705,'2006-02-15 05:05:03'),
 (38,793,'2006-02-15 05:05:03'),
 (38,827,'2006-02-15 05:05:03'),
 (38,839,'2006-02-15 05:05:03'),
 (38,853,'2006-02-15 05:05:03'),
 (38,876,'2006-02-15 05:05:03'),
 (39,71,'2006-02-15 05:05:03'),
 (39,73,'2006-02-15 05:05:03'),
 (39,168,'2006-02-15 05:05:03'),
 (39,203,'2006-02-15 05:05:03'),
 (39,222,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (39,290,'2006-02-15 05:05:03'),
 (39,293,'2006-02-15 05:05:03'),
 (39,320,'2006-02-15 05:05:03'),
 (39,415,'2006-02-15 05:05:03'),
 (39,425,'2006-02-15 05:05:03'),
 (39,431,'2006-02-15 05:05:03'),
 (39,456,'2006-02-15 05:05:03'),
 (39,476,'2006-02-15 05:05:03'),
 (39,559,'2006-02-15 05:05:03'),
 (39,587,'2006-02-15 05:05:03'),
 (39,598,'2006-02-15 05:05:03'),
 (39,606,'2006-02-15 05:05:03'),
 (39,648,'2006-02-15 05:05:03'),
 (39,683,'2006-02-15 05:05:03'),
 (39,689,'2006-02-15 05:05:03'),
 (39,696,'2006-02-15 05:05:03'),
 (39,700,'2006-02-15 05:05:03'),
 (39,703,'2006-02-15 05:05:03'),
 (39,736,'2006-02-15 05:05:03'),
 (39,772,'2006-02-15 05:05:03'),
 (39,815,'2006-02-15 05:05:03'),
 (39,831,'2006-02-15 05:05:03'),
 (39,920,'2006-02-15 05:05:03'),
 (40,1,'2006-02-15 05:05:03'),
 (40,11,'2006-02-15 05:05:03'),
 (40,34,'2006-02-15 05:05:03'),
 (40,107,'2006-02-15 05:05:03'),
 (40,128,'2006-02-15 05:05:03'),
 (40,163,'2006-02-15 05:05:03'),
 (40,177,'2006-02-15 05:05:03'),
 (40,223,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (40,233,'2006-02-15 05:05:03'),
 (40,326,'2006-02-15 05:05:03'),
 (40,374,'2006-02-15 05:05:03'),
 (40,394,'2006-02-15 05:05:03'),
 (40,396,'2006-02-15 05:05:03'),
 (40,463,'2006-02-15 05:05:03'),
 (40,466,'2006-02-15 05:05:03'),
 (40,494,'2006-02-15 05:05:03'),
 (40,521,'2006-02-15 05:05:03'),
 (40,723,'2006-02-15 05:05:03'),
 (40,737,'2006-02-15 05:05:03'),
 (40,744,'2006-02-15 05:05:03'),
 (40,747,'2006-02-15 05:05:03'),
 (40,754,'2006-02-15 05:05:03'),
 (40,799,'2006-02-15 05:05:03'),
 (40,835,'2006-02-15 05:05:03'),
 (40,868,'2006-02-15 05:05:03'),
 (40,869,'2006-02-15 05:05:03'),
 (40,887,'2006-02-15 05:05:03'),
 (40,933,'2006-02-15 05:05:03'),
 (40,938,'2006-02-15 05:05:03'),
 (41,4,'2006-02-15 05:05:03'),
 (41,60,'2006-02-15 05:05:03'),
 (41,69,'2006-02-15 05:05:03'),
 (41,86,'2006-02-15 05:05:03'),
 (41,100,'2006-02-15 05:05:03'),
 (41,150,'2006-02-15 05:05:03'),
 (41,159,'2006-02-15 05:05:03'),
 (41,194,'2006-02-15 05:05:03'),
 (41,203,'2006-02-15 05:05:03'),
 (41,212,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (41,230,'2006-02-15 05:05:03'),
 (41,249,'2006-02-15 05:05:03'),
 (41,252,'2006-02-15 05:05:03'),
 (41,305,'2006-02-15 05:05:03'),
 (41,336,'2006-02-15 05:05:03'),
 (41,383,'2006-02-15 05:05:03'),
 (41,544,'2006-02-15 05:05:03'),
 (41,596,'2006-02-15 05:05:03'),
 (41,657,'2006-02-15 05:05:03'),
 (41,674,'2006-02-15 05:05:03'),
 (41,678,'2006-02-15 05:05:03'),
 (41,721,'2006-02-15 05:05:03'),
 (41,724,'2006-02-15 05:05:03'),
 (41,779,'2006-02-15 05:05:03'),
 (41,784,'2006-02-15 05:05:03'),
 (41,799,'2006-02-15 05:05:03'),
 (41,894,'2006-02-15 05:05:03'),
 (41,912,'2006-02-15 05:05:03'),
 (41,942,'2006-02-15 05:05:03'),
 (42,24,'2006-02-15 05:05:03'),
 (42,139,'2006-02-15 05:05:03'),
 (42,309,'2006-02-15 05:05:03'),
 (42,320,'2006-02-15 05:05:03'),
 (42,333,'2006-02-15 05:05:03'),
 (42,500,'2006-02-15 05:05:03'),
 (42,502,'2006-02-15 05:05:03'),
 (42,505,'2006-02-15 05:05:03'),
 (42,527,'2006-02-15 05:05:03'),
 (42,535,'2006-02-15 05:05:03'),
 (42,546,'2006-02-15 05:05:03'),
 (42,568,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (42,648,'2006-02-15 05:05:03'),
 (42,665,'2006-02-15 05:05:03'),
 (42,673,'2006-02-15 05:05:03'),
 (42,687,'2006-02-15 05:05:03'),
 (42,713,'2006-02-15 05:05:03'),
 (42,738,'2006-02-15 05:05:03'),
 (42,798,'2006-02-15 05:05:03'),
 (42,861,'2006-02-15 05:05:03'),
 (42,865,'2006-02-15 05:05:03'),
 (42,867,'2006-02-15 05:05:03'),
 (42,876,'2006-02-15 05:05:03'),
 (42,890,'2006-02-15 05:05:03'),
 (42,907,'2006-02-15 05:05:03'),
 (42,922,'2006-02-15 05:05:03'),
 (42,932,'2006-02-15 05:05:03'),
 (43,19,'2006-02-15 05:05:03'),
 (43,42,'2006-02-15 05:05:03'),
 (43,56,'2006-02-15 05:05:03'),
 (43,89,'2006-02-15 05:05:03'),
 (43,105,'2006-02-15 05:05:03'),
 (43,147,'2006-02-15 05:05:03'),
 (43,161,'2006-02-15 05:05:03'),
 (43,180,'2006-02-15 05:05:03'),
 (43,239,'2006-02-15 05:05:03'),
 (43,276,'2006-02-15 05:05:03'),
 (43,330,'2006-02-15 05:05:03'),
 (43,344,'2006-02-15 05:05:03'),
 (43,359,'2006-02-15 05:05:03'),
 (43,377,'2006-02-15 05:05:03'),
 (43,410,'2006-02-15 05:05:03'),
 (43,462,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (43,533,'2006-02-15 05:05:03'),
 (43,598,'2006-02-15 05:05:03'),
 (43,605,'2006-02-15 05:05:03'),
 (43,608,'2006-02-15 05:05:03'),
 (43,621,'2006-02-15 05:05:03'),
 (43,753,'2006-02-15 05:05:03'),
 (43,827,'2006-02-15 05:05:03'),
 (43,833,'2006-02-15 05:05:03'),
 (43,917,'2006-02-15 05:05:03'),
 (43,958,'2006-02-15 05:05:03'),
 (44,58,'2006-02-15 05:05:03'),
 (44,84,'2006-02-15 05:05:03'),
 (44,88,'2006-02-15 05:05:03'),
 (44,94,'2006-02-15 05:05:03'),
 (44,109,'2006-02-15 05:05:03'),
 (44,176,'2006-02-15 05:05:03'),
 (44,242,'2006-02-15 05:05:03'),
 (44,273,'2006-02-15 05:05:03'),
 (44,322,'2006-02-15 05:05:03'),
 (44,420,'2006-02-15 05:05:03'),
 (44,434,'2006-02-15 05:05:03'),
 (44,490,'2006-02-15 05:05:03'),
 (44,591,'2006-02-15 05:05:03'),
 (44,598,'2006-02-15 05:05:03'),
 (44,604,'2006-02-15 05:05:03'),
 (44,699,'2006-02-15 05:05:03'),
 (44,751,'2006-02-15 05:05:03'),
 (44,784,'2006-02-15 05:05:03'),
 (44,825,'2006-02-15 05:05:03'),
 (44,854,'2006-02-15 05:05:03'),
 (44,875,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (44,878,'2006-02-15 05:05:03'),
 (44,883,'2006-02-15 05:05:03'),
 (44,896,'2006-02-15 05:05:03'),
 (44,902,'2006-02-15 05:05:03'),
 (44,937,'2006-02-15 05:05:03'),
 (44,944,'2006-02-15 05:05:03'),
 (44,952,'2006-02-15 05:05:03'),
 (44,982,'2006-02-15 05:05:03'),
 (44,998,'2006-02-15 05:05:03'),
 (45,18,'2006-02-15 05:05:03'),
 (45,65,'2006-02-15 05:05:03'),
 (45,66,'2006-02-15 05:05:03'),
 (45,115,'2006-02-15 05:05:03'),
 (45,117,'2006-02-15 05:05:03'),
 (45,164,'2006-02-15 05:05:03'),
 (45,187,'2006-02-15 05:05:03'),
 (45,198,'2006-02-15 05:05:03'),
 (45,219,'2006-02-15 05:05:03'),
 (45,330,'2006-02-15 05:05:03'),
 (45,407,'2006-02-15 05:05:03'),
 (45,416,'2006-02-15 05:05:03'),
 (45,463,'2006-02-15 05:05:03'),
 (45,467,'2006-02-15 05:05:03'),
 (45,484,'2006-02-15 05:05:03'),
 (45,502,'2006-02-15 05:05:03'),
 (45,503,'2006-02-15 05:05:03'),
 (45,508,'2006-02-15 05:05:03'),
 (45,537,'2006-02-15 05:05:03'),
 (45,680,'2006-02-15 05:05:03'),
 (45,714,'2006-02-15 05:05:03'),
 (45,767,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (45,778,'2006-02-15 05:05:03'),
 (45,797,'2006-02-15 05:05:03'),
 (45,810,'2006-02-15 05:05:03'),
 (45,895,'2006-02-15 05:05:03'),
 (45,900,'2006-02-15 05:05:03'),
 (45,901,'2006-02-15 05:05:03'),
 (45,920,'2006-02-15 05:05:03'),
 (45,925,'2006-02-15 05:05:03'),
 (45,975,'2006-02-15 05:05:03'),
 (45,978,'2006-02-15 05:05:03'),
 (46,38,'2006-02-15 05:05:03'),
 (46,51,'2006-02-15 05:05:03'),
 (46,174,'2006-02-15 05:05:03'),
 (46,254,'2006-02-15 05:05:03'),
 (46,296,'2006-02-15 05:05:03'),
 (46,319,'2006-02-15 05:05:03'),
 (46,407,'2006-02-15 05:05:03'),
 (46,448,'2006-02-15 05:05:03'),
 (46,456,'2006-02-15 05:05:03'),
 (46,463,'2006-02-15 05:05:03'),
 (46,478,'2006-02-15 05:05:03'),
 (46,538,'2006-02-15 05:05:03'),
 (46,540,'2006-02-15 05:05:03'),
 (46,567,'2006-02-15 05:05:03'),
 (46,731,'2006-02-15 05:05:03'),
 (46,766,'2006-02-15 05:05:03'),
 (46,768,'2006-02-15 05:05:03'),
 (46,820,'2006-02-15 05:05:03'),
 (46,829,'2006-02-15 05:05:03'),
 (46,830,'2006-02-15 05:05:03'),
 (46,836,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (46,889,'2006-02-15 05:05:03'),
 (46,980,'2006-02-15 05:05:03'),
 (46,991,'2006-02-15 05:05:03'),
 (47,25,'2006-02-15 05:05:03'),
 (47,36,'2006-02-15 05:05:03'),
 (47,53,'2006-02-15 05:05:03'),
 (47,67,'2006-02-15 05:05:03'),
 (47,172,'2006-02-15 05:05:03'),
 (47,233,'2006-02-15 05:05:03'),
 (47,273,'2006-02-15 05:05:03'),
 (47,351,'2006-02-15 05:05:03'),
 (47,385,'2006-02-15 05:05:03'),
 (47,484,'2006-02-15 05:05:03'),
 (47,508,'2006-02-15 05:05:03'),
 (47,576,'2006-02-15 05:05:03'),
 (47,670,'2006-02-15 05:05:03'),
 (47,734,'2006-02-15 05:05:03'),
 (47,737,'2006-02-15 05:05:03'),
 (47,770,'2006-02-15 05:05:03'),
 (47,777,'2006-02-15 05:05:03'),
 (47,787,'2006-02-15 05:05:03'),
 (47,790,'2006-02-15 05:05:03'),
 (47,913,'2006-02-15 05:05:03'),
 (47,923,'2006-02-15 05:05:03'),
 (47,924,'2006-02-15 05:05:03'),
 (47,944,'2006-02-15 05:05:03'),
 (47,973,'2006-02-15 05:05:03'),
 (48,99,'2006-02-15 05:05:03'),
 (48,101,'2006-02-15 05:05:03'),
 (48,134,'2006-02-15 05:05:03'),
 (48,150,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (48,164,'2006-02-15 05:05:03'),
 (48,211,'2006-02-15 05:05:03'),
 (48,245,'2006-02-15 05:05:03'),
 (48,267,'2006-02-15 05:05:03'),
 (48,287,'2006-02-15 05:05:03'),
 (48,295,'2006-02-15 05:05:03'),
 (48,312,'2006-02-15 05:05:03'),
 (48,315,'2006-02-15 05:05:03'),
 (48,345,'2006-02-15 05:05:03'),
 (48,349,'2006-02-15 05:05:03'),
 (48,428,'2006-02-15 05:05:03'),
 (48,506,'2006-02-15 05:05:03'),
 (48,545,'2006-02-15 05:05:03'),
 (48,559,'2006-02-15 05:05:03'),
 (48,570,'2006-02-15 05:05:03'),
 (48,599,'2006-02-15 05:05:03'),
 (48,645,'2006-02-15 05:05:03'),
 (48,705,'2006-02-15 05:05:03'),
 (48,757,'2006-02-15 05:05:03'),
 (48,792,'2006-02-15 05:05:03'),
 (48,922,'2006-02-15 05:05:03'),
 (48,926,'2006-02-15 05:05:03'),
 (49,31,'2006-02-15 05:05:03'),
 (49,151,'2006-02-15 05:05:03'),
 (49,195,'2006-02-15 05:05:03'),
 (49,207,'2006-02-15 05:05:03'),
 (49,250,'2006-02-15 05:05:03'),
 (49,282,'2006-02-15 05:05:03'),
 (49,348,'2006-02-15 05:05:03'),
 (49,391,'2006-02-15 05:05:03'),
 (49,400,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (49,407,'2006-02-15 05:05:03'),
 (49,423,'2006-02-15 05:05:03'),
 (49,433,'2006-02-15 05:05:03'),
 (49,469,'2006-02-15 05:05:03'),
 (49,506,'2006-02-15 05:05:03'),
 (49,542,'2006-02-15 05:05:03'),
 (49,558,'2006-02-15 05:05:03'),
 (49,579,'2006-02-15 05:05:03'),
 (49,595,'2006-02-15 05:05:03'),
 (49,662,'2006-02-15 05:05:03'),
 (49,709,'2006-02-15 05:05:03'),
 (49,716,'2006-02-15 05:05:03'),
 (49,725,'2006-02-15 05:05:03'),
 (49,729,'2006-02-15 05:05:03'),
 (49,811,'2006-02-15 05:05:03'),
 (49,927,'2006-02-15 05:05:03'),
 (49,977,'2006-02-15 05:05:03'),
 (49,980,'2006-02-15 05:05:03'),
 (50,111,'2006-02-15 05:05:03'),
 (50,178,'2006-02-15 05:05:03'),
 (50,243,'2006-02-15 05:05:03'),
 (50,248,'2006-02-15 05:05:03'),
 (50,274,'2006-02-15 05:05:03'),
 (50,288,'2006-02-15 05:05:03'),
 (50,303,'2006-02-15 05:05:03'),
 (50,306,'2006-02-15 05:05:03'),
 (50,327,'2006-02-15 05:05:03'),
 (50,372,'2006-02-15 05:05:03'),
 (50,401,'2006-02-15 05:05:03'),
 (50,417,'2006-02-15 05:05:03'),
 (50,420,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (50,437,'2006-02-15 05:05:03'),
 (50,476,'2006-02-15 05:05:03'),
 (50,504,'2006-02-15 05:05:03'),
 (50,520,'2006-02-15 05:05:03'),
 (50,552,'2006-02-15 05:05:03'),
 (50,591,'2006-02-15 05:05:03'),
 (50,621,'2006-02-15 05:05:03'),
 (50,632,'2006-02-15 05:05:03'),
 (50,645,'2006-02-15 05:05:03'),
 (50,672,'2006-02-15 05:05:03'),
 (50,717,'2006-02-15 05:05:03'),
 (50,732,'2006-02-15 05:05:03'),
 (50,795,'2006-02-15 05:05:03'),
 (50,829,'2006-02-15 05:05:03'),
 (50,840,'2006-02-15 05:05:03'),
 (50,897,'2006-02-15 05:05:03'),
 (50,918,'2006-02-15 05:05:03'),
 (50,924,'2006-02-15 05:05:03'),
 (50,957,'2006-02-15 05:05:03'),
 (51,5,'2006-02-15 05:05:03'),
 (51,63,'2006-02-15 05:05:03'),
 (51,103,'2006-02-15 05:05:03'),
 (51,112,'2006-02-15 05:05:03'),
 (51,121,'2006-02-15 05:05:03'),
 (51,153,'2006-02-15 05:05:03'),
 (51,395,'2006-02-15 05:05:03'),
 (51,408,'2006-02-15 05:05:03'),
 (51,420,'2006-02-15 05:05:03'),
 (51,461,'2006-02-15 05:05:03'),
 (51,490,'2006-02-15 05:05:03'),
 (51,525,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (51,627,'2006-02-15 05:05:03'),
 (51,678,'2006-02-15 05:05:03'),
 (51,733,'2006-02-15 05:05:03'),
 (51,734,'2006-02-15 05:05:03'),
 (51,737,'2006-02-15 05:05:03'),
 (51,750,'2006-02-15 05:05:03'),
 (51,847,'2006-02-15 05:05:03'),
 (51,891,'2006-02-15 05:05:03'),
 (51,895,'2006-02-15 05:05:03'),
 (51,940,'2006-02-15 05:05:03'),
 (51,974,'2006-02-15 05:05:03'),
 (51,990,'2006-02-15 05:05:03'),
 (51,993,'2006-02-15 05:05:03'),
 (52,20,'2006-02-15 05:05:03'),
 (52,92,'2006-02-15 05:05:03'),
 (52,96,'2006-02-15 05:05:03'),
 (52,108,'2006-02-15 05:05:03'),
 (52,203,'2006-02-15 05:05:03'),
 (52,249,'2006-02-15 05:05:03'),
 (52,341,'2006-02-15 05:05:03'),
 (52,376,'2006-02-15 05:05:03'),
 (52,388,'2006-02-15 05:05:03'),
 (52,407,'2006-02-15 05:05:03'),
 (52,424,'2006-02-15 05:05:03'),
 (52,474,'2006-02-15 05:05:03'),
 (52,515,'2006-02-15 05:05:03'),
 (52,517,'2006-02-15 05:05:03'),
 (52,584,'2006-02-15 05:05:03'),
 (52,596,'2006-02-15 05:05:03'),
 (52,664,'2006-02-15 05:05:03'),
 (52,675,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (52,689,'2006-02-15 05:05:03'),
 (52,714,'2006-02-15 05:05:03'),
 (52,812,'2006-02-15 05:05:03'),
 (52,878,'2006-02-15 05:05:03'),
 (52,879,'2006-02-15 05:05:03'),
 (52,915,'2006-02-15 05:05:03'),
 (52,951,'2006-02-15 05:05:03'),
 (52,999,'2006-02-15 05:05:03'),
 (53,1,'2006-02-15 05:05:03'),
 (53,9,'2006-02-15 05:05:03'),
 (53,51,'2006-02-15 05:05:03'),
 (53,58,'2006-02-15 05:05:03'),
 (53,109,'2006-02-15 05:05:03'),
 (53,122,'2006-02-15 05:05:03'),
 (53,126,'2006-02-15 05:05:03'),
 (53,181,'2006-02-15 05:05:03'),
 (53,256,'2006-02-15 05:05:03'),
 (53,268,'2006-02-15 05:05:03'),
 (53,285,'2006-02-15 05:05:03'),
 (53,307,'2006-02-15 05:05:03'),
 (53,358,'2006-02-15 05:05:03'),
 (53,386,'2006-02-15 05:05:03'),
 (53,447,'2006-02-15 05:05:03'),
 (53,465,'2006-02-15 05:05:03'),
 (53,490,'2006-02-15 05:05:03'),
 (53,492,'2006-02-15 05:05:03'),
 (53,508,'2006-02-15 05:05:03'),
 (53,518,'2006-02-15 05:05:03'),
 (53,573,'2006-02-15 05:05:03'),
 (53,576,'2006-02-15 05:05:03'),
 (53,577,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (53,697,'2006-02-15 05:05:03'),
 (53,725,'2006-02-15 05:05:03'),
 (53,727,'2006-02-15 05:05:03'),
 (53,937,'2006-02-15 05:05:03'),
 (53,947,'2006-02-15 05:05:03'),
 (53,961,'2006-02-15 05:05:03'),
 (53,980,'2006-02-15 05:05:03'),
 (54,84,'2006-02-15 05:05:03'),
 (54,129,'2006-02-15 05:05:03'),
 (54,150,'2006-02-15 05:05:03'),
 (54,184,'2006-02-15 05:05:03'),
 (54,285,'2006-02-15 05:05:03'),
 (54,292,'2006-02-15 05:05:03'),
 (54,301,'2006-02-15 05:05:03'),
 (54,348,'2006-02-15 05:05:03'),
 (54,489,'2006-02-15 05:05:03'),
 (54,510,'2006-02-15 05:05:03'),
 (54,524,'2006-02-15 05:05:03'),
 (54,546,'2006-02-15 05:05:03'),
 (54,600,'2006-02-15 05:05:03'),
 (54,636,'2006-02-15 05:05:03'),
 (54,649,'2006-02-15 05:05:03'),
 (54,658,'2006-02-15 05:05:03'),
 (54,754,'2006-02-15 05:05:03'),
 (54,764,'2006-02-15 05:05:03'),
 (54,842,'2006-02-15 05:05:03'),
 (54,858,'2006-02-15 05:05:03'),
 (54,861,'2006-02-15 05:05:03'),
 (54,913,'2006-02-15 05:05:03'),
 (54,970,'2006-02-15 05:05:03'),
 (54,988,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (54,990,'2006-02-15 05:05:03'),
 (55,8,'2006-02-15 05:05:03'),
 (55,27,'2006-02-15 05:05:03'),
 (55,75,'2006-02-15 05:05:03'),
 (55,197,'2006-02-15 05:05:03'),
 (55,307,'2006-02-15 05:05:03'),
 (55,320,'2006-02-15 05:05:03'),
 (55,340,'2006-02-15 05:05:03'),
 (55,403,'2006-02-15 05:05:03'),
 (55,485,'2006-02-15 05:05:03'),
 (55,486,'2006-02-15 05:05:03'),
 (55,603,'2006-02-15 05:05:03'),
 (55,612,'2006-02-15 05:05:03'),
 (55,620,'2006-02-15 05:05:03'),
 (55,709,'2006-02-15 05:05:03'),
 (55,776,'2006-02-15 05:05:03'),
 (55,790,'2006-02-15 05:05:03'),
 (55,815,'2006-02-15 05:05:03'),
 (55,827,'2006-02-15 05:05:03'),
 (55,930,'2006-02-15 05:05:03'),
 (55,963,'2006-02-15 05:05:03'),
 (56,63,'2006-02-15 05:05:03'),
 (56,87,'2006-02-15 05:05:03'),
 (56,226,'2006-02-15 05:05:03'),
 (56,236,'2006-02-15 05:05:03'),
 (56,298,'2006-02-15 05:05:03'),
 (56,307,'2006-02-15 05:05:03'),
 (56,354,'2006-02-15 05:05:03'),
 (56,383,'2006-02-15 05:05:03'),
 (56,417,'2006-02-15 05:05:03'),
 (56,421,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (56,457,'2006-02-15 05:05:03'),
 (56,462,'2006-02-15 05:05:03'),
 (56,474,'2006-02-15 05:05:03'),
 (56,521,'2006-02-15 05:05:03'),
 (56,593,'2006-02-15 05:05:03'),
 (56,728,'2006-02-15 05:05:03'),
 (56,750,'2006-02-15 05:05:03'),
 (56,769,'2006-02-15 05:05:03'),
 (56,781,'2006-02-15 05:05:03'),
 (56,795,'2006-02-15 05:05:03'),
 (56,844,'2006-02-15 05:05:03'),
 (56,851,'2006-02-15 05:05:03'),
 (56,862,'2006-02-15 05:05:03'),
 (56,868,'2006-02-15 05:05:03'),
 (56,892,'2006-02-15 05:05:03'),
 (56,893,'2006-02-15 05:05:03'),
 (56,936,'2006-02-15 05:05:03'),
 (56,965,'2006-02-15 05:05:03'),
 (57,16,'2006-02-15 05:05:03'),
 (57,34,'2006-02-15 05:05:03'),
 (57,101,'2006-02-15 05:05:03'),
 (57,114,'2006-02-15 05:05:03'),
 (57,122,'2006-02-15 05:05:03'),
 (57,134,'2006-02-15 05:05:03'),
 (57,144,'2006-02-15 05:05:03'),
 (57,153,'2006-02-15 05:05:03'),
 (57,192,'2006-02-15 05:05:03'),
 (57,213,'2006-02-15 05:05:03'),
 (57,258,'2006-02-15 05:05:03'),
 (57,267,'2006-02-15 05:05:03'),
 (57,317,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (57,340,'2006-02-15 05:05:03'),
 (57,393,'2006-02-15 05:05:03'),
 (57,437,'2006-02-15 05:05:03'),
 (57,447,'2006-02-15 05:05:03'),
 (57,502,'2006-02-15 05:05:03'),
 (57,592,'2006-02-15 05:05:03'),
 (57,605,'2006-02-15 05:05:03'),
 (57,637,'2006-02-15 05:05:03'),
 (57,685,'2006-02-15 05:05:03'),
 (57,707,'2006-02-15 05:05:03'),
 (57,714,'2006-02-15 05:05:03'),
 (57,717,'2006-02-15 05:05:03'),
 (57,737,'2006-02-15 05:05:03'),
 (57,767,'2006-02-15 05:05:03'),
 (57,852,'2006-02-15 05:05:03'),
 (57,891,'2006-02-15 05:05:03'),
 (57,918,'2006-02-15 05:05:03'),
 (58,48,'2006-02-15 05:05:03'),
 (58,68,'2006-02-15 05:05:03'),
 (58,119,'2006-02-15 05:05:03'),
 (58,128,'2006-02-15 05:05:03'),
 (58,135,'2006-02-15 05:05:03'),
 (58,175,'2006-02-15 05:05:03'),
 (58,199,'2006-02-15 05:05:03'),
 (58,235,'2006-02-15 05:05:03'),
 (58,242,'2006-02-15 05:05:03'),
 (58,243,'2006-02-15 05:05:03'),
 (58,254,'2006-02-15 05:05:03'),
 (58,306,'2006-02-15 05:05:03'),
 (58,316,'2006-02-15 05:05:03'),
 (58,417,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (58,426,'2006-02-15 05:05:03'),
 (58,460,'2006-02-15 05:05:03'),
 (58,477,'2006-02-15 05:05:03'),
 (58,541,'2006-02-15 05:05:03'),
 (58,549,'2006-02-15 05:05:03'),
 (58,551,'2006-02-15 05:05:03'),
 (58,553,'2006-02-15 05:05:03'),
 (58,578,'2006-02-15 05:05:03'),
 (58,602,'2006-02-15 05:05:03'),
 (58,632,'2006-02-15 05:05:03'),
 (58,635,'2006-02-15 05:05:03'),
 (58,638,'2006-02-15 05:05:03'),
 (58,698,'2006-02-15 05:05:03'),
 (58,726,'2006-02-15 05:05:03'),
 (58,755,'2006-02-15 05:05:03'),
 (58,800,'2006-02-15 05:05:03'),
 (58,856,'2006-02-15 05:05:03'),
 (58,858,'2006-02-15 05:05:03'),
 (59,5,'2006-02-15 05:05:03'),
 (59,46,'2006-02-15 05:05:03'),
 (59,54,'2006-02-15 05:05:03'),
 (59,72,'2006-02-15 05:05:03'),
 (59,88,'2006-02-15 05:05:03'),
 (59,121,'2006-02-15 05:05:03'),
 (59,129,'2006-02-15 05:05:03'),
 (59,130,'2006-02-15 05:05:03'),
 (59,183,'2006-02-15 05:05:03'),
 (59,210,'2006-02-15 05:05:03'),
 (59,241,'2006-02-15 05:05:03'),
 (59,295,'2006-02-15 05:05:03'),
 (59,418,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (59,572,'2006-02-15 05:05:03'),
 (59,644,'2006-02-15 05:05:03'),
 (59,650,'2006-02-15 05:05:03'),
 (59,689,'2006-02-15 05:05:03'),
 (59,694,'2006-02-15 05:05:03'),
 (59,702,'2006-02-15 05:05:03'),
 (59,713,'2006-02-15 05:05:03'),
 (59,749,'2006-02-15 05:05:03'),
 (59,772,'2006-02-15 05:05:03'),
 (59,853,'2006-02-15 05:05:03'),
 (59,862,'2006-02-15 05:05:03'),
 (59,943,'2006-02-15 05:05:03'),
 (59,946,'2006-02-15 05:05:03'),
 (59,984,'2006-02-15 05:05:03'),
 (60,31,'2006-02-15 05:05:03'),
 (60,85,'2006-02-15 05:05:03'),
 (60,133,'2006-02-15 05:05:03'),
 (60,142,'2006-02-15 05:05:03'),
 (60,177,'2006-02-15 05:05:03'),
 (60,179,'2006-02-15 05:05:03'),
 (60,186,'2006-02-15 05:05:03'),
 (60,222,'2006-02-15 05:05:03'),
 (60,235,'2006-02-15 05:05:03'),
 (60,239,'2006-02-15 05:05:03'),
 (60,253,'2006-02-15 05:05:03'),
 (60,262,'2006-02-15 05:05:03'),
 (60,297,'2006-02-15 05:05:03'),
 (60,299,'2006-02-15 05:05:03'),
 (60,334,'2006-02-15 05:05:03'),
 (60,376,'2006-02-15 05:05:03'),
 (60,423,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (60,436,'2006-02-15 05:05:03'),
 (60,493,'2006-02-15 05:05:03'),
 (60,534,'2006-02-15 05:05:03'),
 (60,551,'2006-02-15 05:05:03'),
 (60,658,'2006-02-15 05:05:03'),
 (60,665,'2006-02-15 05:05:03'),
 (60,679,'2006-02-15 05:05:03'),
 (60,754,'2006-02-15 05:05:03'),
 (60,771,'2006-02-15 05:05:03'),
 (60,783,'2006-02-15 05:05:03'),
 (60,784,'2006-02-15 05:05:03'),
 (60,805,'2006-02-15 05:05:03'),
 (60,830,'2006-02-15 05:05:03'),
 (60,835,'2006-02-15 05:05:03'),
 (60,928,'2006-02-15 05:05:03'),
 (60,952,'2006-02-15 05:05:03'),
 (60,971,'2006-02-15 05:05:03'),
 (60,986,'2006-02-15 05:05:03'),
 (61,235,'2006-02-15 05:05:03'),
 (61,237,'2006-02-15 05:05:03'),
 (61,307,'2006-02-15 05:05:03'),
 (61,362,'2006-02-15 05:05:03'),
 (61,372,'2006-02-15 05:05:03'),
 (61,374,'2006-02-15 05:05:03'),
 (61,423,'2006-02-15 05:05:03'),
 (61,433,'2006-02-15 05:05:03'),
 (61,508,'2006-02-15 05:05:03'),
 (61,518,'2006-02-15 05:05:03'),
 (61,519,'2006-02-15 05:05:03'),
 (61,535,'2006-02-15 05:05:03'),
 (61,537,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (61,585,'2006-02-15 05:05:03'),
 (61,639,'2006-02-15 05:05:03'),
 (61,648,'2006-02-15 05:05:03'),
 (61,649,'2006-02-15 05:05:03'),
 (61,703,'2006-02-15 05:05:03'),
 (61,752,'2006-02-15 05:05:03'),
 (61,766,'2006-02-15 05:05:03'),
 (61,767,'2006-02-15 05:05:03'),
 (61,780,'2006-02-15 05:05:03'),
 (61,831,'2006-02-15 05:05:03'),
 (61,832,'2006-02-15 05:05:03'),
 (61,990,'2006-02-15 05:05:03'),
 (62,6,'2006-02-15 05:05:03'),
 (62,42,'2006-02-15 05:05:03'),
 (62,54,'2006-02-15 05:05:03'),
 (62,100,'2006-02-15 05:05:03'),
 (62,101,'2006-02-15 05:05:03'),
 (62,129,'2006-02-15 05:05:03'),
 (62,198,'2006-02-15 05:05:03'),
 (62,211,'2006-02-15 05:05:03'),
 (62,231,'2006-02-15 05:05:03'),
 (62,272,'2006-02-15 05:05:03'),
 (62,295,'2006-02-15 05:05:03'),
 (62,337,'2006-02-15 05:05:03'),
 (62,375,'2006-02-15 05:05:03'),
 (62,385,'2006-02-15 05:05:03'),
 (62,393,'2006-02-15 05:05:03'),
 (62,398,'2006-02-15 05:05:03'),
 (62,406,'2006-02-15 05:05:03'),
 (62,413,'2006-02-15 05:05:03'),
 (62,428,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (62,445,'2006-02-15 05:05:03'),
 (62,457,'2006-02-15 05:05:03'),
 (62,465,'2006-02-15 05:05:03'),
 (62,688,'2006-02-15 05:05:03'),
 (62,707,'2006-02-15 05:05:03'),
 (62,719,'2006-02-15 05:05:03'),
 (62,951,'2006-02-15 05:05:03'),
 (62,981,'2006-02-15 05:05:03'),
 (62,988,'2006-02-15 05:05:03'),
 (62,990,'2006-02-15 05:05:03'),
 (63,73,'2006-02-15 05:05:03'),
 (63,134,'2006-02-15 05:05:03'),
 (63,167,'2006-02-15 05:05:03'),
 (63,208,'2006-02-15 05:05:03'),
 (63,225,'2006-02-15 05:05:03'),
 (63,248,'2006-02-15 05:05:03'),
 (63,249,'2006-02-15 05:05:03'),
 (63,278,'2006-02-15 05:05:03'),
 (63,392,'2006-02-15 05:05:03'),
 (63,517,'2006-02-15 05:05:03'),
 (63,633,'2006-02-15 05:05:03'),
 (63,763,'2006-02-15 05:05:03'),
 (63,781,'2006-02-15 05:05:03'),
 (63,809,'2006-02-15 05:05:03'),
 (63,893,'2006-02-15 05:05:03'),
 (63,932,'2006-02-15 05:05:03'),
 (63,944,'2006-02-15 05:05:03'),
 (63,945,'2006-02-15 05:05:03'),
 (63,981,'2006-02-15 05:05:03'),
 (64,3,'2006-02-15 05:05:03'),
 (64,10,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (64,37,'2006-02-15 05:05:03'),
 (64,87,'2006-02-15 05:05:03'),
 (64,88,'2006-02-15 05:05:03'),
 (64,124,'2006-02-15 05:05:03'),
 (64,197,'2006-02-15 05:05:03'),
 (64,280,'2006-02-15 05:05:03'),
 (64,291,'2006-02-15 05:05:03'),
 (64,307,'2006-02-15 05:05:03'),
 (64,335,'2006-02-15 05:05:03'),
 (64,345,'2006-02-15 05:05:03'),
 (64,448,'2006-02-15 05:05:03'),
 (64,469,'2006-02-15 05:05:03'),
 (64,471,'2006-02-15 05:05:03'),
 (64,506,'2006-02-15 05:05:03'),
 (64,543,'2006-02-15 05:05:03'),
 (64,557,'2006-02-15 05:05:03'),
 (64,569,'2006-02-15 05:05:03'),
 (64,572,'2006-02-15 05:05:03'),
 (64,597,'2006-02-15 05:05:03'),
 (64,616,'2006-02-15 05:05:03'),
 (64,646,'2006-02-15 05:05:03'),
 (64,694,'2006-02-15 05:05:03'),
 (64,832,'2006-02-15 05:05:03'),
 (64,852,'2006-02-15 05:05:03'),
 (64,860,'2006-02-15 05:05:03'),
 (64,921,'2006-02-15 05:05:03'),
 (64,925,'2006-02-15 05:05:03'),
 (64,980,'2006-02-15 05:05:03'),
 (65,39,'2006-02-15 05:05:03'),
 (65,46,'2006-02-15 05:05:03'),
 (65,97,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (65,106,'2006-02-15 05:05:03'),
 (65,117,'2006-02-15 05:05:03'),
 (65,125,'2006-02-15 05:05:03'),
 (65,158,'2006-02-15 05:05:03'),
 (65,276,'2006-02-15 05:05:03'),
 (65,305,'2006-02-15 05:05:03'),
 (65,338,'2006-02-15 05:05:03'),
 (65,347,'2006-02-15 05:05:03'),
 (65,371,'2006-02-15 05:05:03'),
 (65,398,'2006-02-15 05:05:03'),
 (65,471,'2006-02-15 05:05:03'),
 (65,475,'2006-02-15 05:05:03'),
 (65,476,'2006-02-15 05:05:03'),
 (65,491,'2006-02-15 05:05:03'),
 (65,496,'2006-02-15 05:05:03'),
 (65,516,'2006-02-15 05:05:03'),
 (65,517,'2006-02-15 05:05:03'),
 (65,541,'2006-02-15 05:05:03'),
 (65,556,'2006-02-15 05:05:03'),
 (65,571,'2006-02-15 05:05:03'),
 (65,577,'2006-02-15 05:05:03'),
 (65,615,'2006-02-15 05:05:03'),
 (65,658,'2006-02-15 05:05:03'),
 (65,683,'2006-02-15 05:05:03'),
 (65,694,'2006-02-15 05:05:03'),
 (65,714,'2006-02-15 05:05:03'),
 (65,735,'2006-02-15 05:05:03'),
 (65,852,'2006-02-15 05:05:03'),
 (65,938,'2006-02-15 05:05:03'),
 (65,951,'2006-02-15 05:05:03'),
 (65,965,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (66,55,'2006-02-15 05:05:03'),
 (66,143,'2006-02-15 05:05:03'),
 (66,207,'2006-02-15 05:05:03'),
 (66,226,'2006-02-15 05:05:03'),
 (66,229,'2006-02-15 05:05:03'),
 (66,230,'2006-02-15 05:05:03'),
 (66,283,'2006-02-15 05:05:03'),
 (66,300,'2006-02-15 05:05:03'),
 (66,342,'2006-02-15 05:05:03'),
 (66,350,'2006-02-15 05:05:03'),
 (66,361,'2006-02-15 05:05:03'),
 (66,376,'2006-02-15 05:05:03'),
 (66,424,'2006-02-15 05:05:03'),
 (66,434,'2006-02-15 05:05:03'),
 (66,553,'2006-02-15 05:05:03'),
 (66,608,'2006-02-15 05:05:03'),
 (66,676,'2006-02-15 05:05:03'),
 (66,697,'2006-02-15 05:05:03'),
 (66,706,'2006-02-15 05:05:03'),
 (66,725,'2006-02-15 05:05:03'),
 (66,769,'2006-02-15 05:05:03'),
 (66,793,'2006-02-15 05:05:03'),
 (66,829,'2006-02-15 05:05:03'),
 (66,871,'2006-02-15 05:05:03'),
 (66,909,'2006-02-15 05:05:03'),
 (66,915,'2006-02-15 05:05:03'),
 (66,928,'2006-02-15 05:05:03'),
 (66,951,'2006-02-15 05:05:03'),
 (66,957,'2006-02-15 05:05:03'),
 (66,960,'2006-02-15 05:05:03'),
 (66,999,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (67,24,'2006-02-15 05:05:03'),
 (67,57,'2006-02-15 05:05:03'),
 (67,67,'2006-02-15 05:05:03'),
 (67,144,'2006-02-15 05:05:03'),
 (67,242,'2006-02-15 05:05:03'),
 (67,244,'2006-02-15 05:05:03'),
 (67,256,'2006-02-15 05:05:03'),
 (67,408,'2006-02-15 05:05:03'),
 (67,477,'2006-02-15 05:05:03'),
 (67,496,'2006-02-15 05:05:03'),
 (67,512,'2006-02-15 05:05:03'),
 (67,576,'2006-02-15 05:05:03'),
 (67,601,'2006-02-15 05:05:03'),
 (67,725,'2006-02-15 05:05:03'),
 (67,726,'2006-02-15 05:05:03'),
 (67,731,'2006-02-15 05:05:03'),
 (67,766,'2006-02-15 05:05:03'),
 (67,861,'2006-02-15 05:05:03'),
 (67,870,'2006-02-15 05:05:03'),
 (67,915,'2006-02-15 05:05:03'),
 (67,945,'2006-02-15 05:05:03'),
 (67,972,'2006-02-15 05:05:03'),
 (67,981,'2006-02-15 05:05:03'),
 (68,9,'2006-02-15 05:05:03'),
 (68,45,'2006-02-15 05:05:03'),
 (68,133,'2006-02-15 05:05:03'),
 (68,161,'2006-02-15 05:05:03'),
 (68,205,'2006-02-15 05:05:03'),
 (68,213,'2006-02-15 05:05:03'),
 (68,215,'2006-02-15 05:05:03'),
 (68,255,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (68,296,'2006-02-15 05:05:03'),
 (68,315,'2006-02-15 05:05:03'),
 (68,325,'2006-02-15 05:05:03'),
 (68,331,'2006-02-15 05:05:03'),
 (68,347,'2006-02-15 05:05:03'),
 (68,357,'2006-02-15 05:05:03'),
 (68,378,'2006-02-15 05:05:03'),
 (68,380,'2006-02-15 05:05:03'),
 (68,386,'2006-02-15 05:05:03'),
 (68,396,'2006-02-15 05:05:03'),
 (68,435,'2006-02-15 05:05:03'),
 (68,497,'2006-02-15 05:05:03'),
 (68,607,'2006-02-15 05:05:03'),
 (68,654,'2006-02-15 05:05:03'),
 (68,665,'2006-02-15 05:05:03'),
 (68,671,'2006-02-15 05:05:03'),
 (68,706,'2006-02-15 05:05:03'),
 (68,747,'2006-02-15 05:05:03'),
 (68,834,'2006-02-15 05:05:03'),
 (68,839,'2006-02-15 05:05:03'),
 (68,840,'2006-02-15 05:05:03'),
 (68,971,'2006-02-15 05:05:03'),
 (69,15,'2006-02-15 05:05:03'),
 (69,88,'2006-02-15 05:05:03'),
 (69,111,'2006-02-15 05:05:03'),
 (69,202,'2006-02-15 05:05:03'),
 (69,236,'2006-02-15 05:05:03'),
 (69,292,'2006-02-15 05:05:03'),
 (69,300,'2006-02-15 05:05:03'),
 (69,306,'2006-02-15 05:05:03'),
 (69,374,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (69,396,'2006-02-15 05:05:03'),
 (69,452,'2006-02-15 05:05:03'),
 (69,466,'2006-02-15 05:05:03'),
 (69,529,'2006-02-15 05:05:03'),
 (69,612,'2006-02-15 05:05:03'),
 (69,720,'2006-02-15 05:05:03'),
 (69,722,'2006-02-15 05:05:03'),
 (69,761,'2006-02-15 05:05:03'),
 (69,791,'2006-02-15 05:05:03'),
 (69,864,'2006-02-15 05:05:03'),
 (69,877,'2006-02-15 05:05:03'),
 (69,914,'2006-02-15 05:05:03'),
 (70,50,'2006-02-15 05:05:03'),
 (70,53,'2006-02-15 05:05:03'),
 (70,92,'2006-02-15 05:05:03'),
 (70,202,'2006-02-15 05:05:03'),
 (70,227,'2006-02-15 05:05:03'),
 (70,249,'2006-02-15 05:05:03'),
 (70,290,'2006-02-15 05:05:03'),
 (70,304,'2006-02-15 05:05:03'),
 (70,343,'2006-02-15 05:05:03'),
 (70,414,'2006-02-15 05:05:03'),
 (70,453,'2006-02-15 05:05:03'),
 (70,466,'2006-02-15 05:05:03'),
 (70,504,'2006-02-15 05:05:03'),
 (70,584,'2006-02-15 05:05:03'),
 (70,628,'2006-02-15 05:05:03'),
 (70,654,'2006-02-15 05:05:03'),
 (70,725,'2006-02-15 05:05:03'),
 (70,823,'2006-02-15 05:05:03'),
 (70,834,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (70,856,'2006-02-15 05:05:03'),
 (70,869,'2006-02-15 05:05:03'),
 (70,953,'2006-02-15 05:05:03'),
 (70,964,'2006-02-15 05:05:03'),
 (71,26,'2006-02-15 05:05:03'),
 (71,52,'2006-02-15 05:05:03'),
 (71,233,'2006-02-15 05:05:03'),
 (71,317,'2006-02-15 05:05:03'),
 (71,359,'2006-02-15 05:05:03'),
 (71,362,'2006-02-15 05:05:03'),
 (71,385,'2006-02-15 05:05:03'),
 (71,399,'2006-02-15 05:05:03'),
 (71,450,'2006-02-15 05:05:03'),
 (71,532,'2006-02-15 05:05:03'),
 (71,560,'2006-02-15 05:05:03'),
 (71,574,'2006-02-15 05:05:03'),
 (71,638,'2006-02-15 05:05:03'),
 (71,773,'2006-02-15 05:05:03'),
 (71,833,'2006-02-15 05:05:03'),
 (71,874,'2006-02-15 05:05:03'),
 (71,918,'2006-02-15 05:05:03'),
 (71,956,'2006-02-15 05:05:03'),
 (72,34,'2006-02-15 05:05:03'),
 (72,144,'2006-02-15 05:05:03'),
 (72,237,'2006-02-15 05:05:03'),
 (72,249,'2006-02-15 05:05:03'),
 (72,286,'2006-02-15 05:05:03'),
 (72,296,'2006-02-15 05:05:03'),
 (72,325,'2006-02-15 05:05:03'),
 (72,331,'2006-02-15 05:05:03'),
 (72,405,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (72,450,'2006-02-15 05:05:03'),
 (72,550,'2006-02-15 05:05:03'),
 (72,609,'2006-02-15 05:05:03'),
 (72,623,'2006-02-15 05:05:03'),
 (72,636,'2006-02-15 05:05:03'),
 (72,640,'2006-02-15 05:05:03'),
 (72,665,'2006-02-15 05:05:03'),
 (72,718,'2006-02-15 05:05:03'),
 (72,743,'2006-02-15 05:05:03'),
 (72,757,'2006-02-15 05:05:03'),
 (72,773,'2006-02-15 05:05:03'),
 (72,854,'2006-02-15 05:05:03'),
 (72,865,'2006-02-15 05:05:03'),
 (72,938,'2006-02-15 05:05:03'),
 (72,956,'2006-02-15 05:05:03'),
 (72,964,'2006-02-15 05:05:03'),
 (72,969,'2006-02-15 05:05:03'),
 (73,36,'2006-02-15 05:05:03'),
 (73,45,'2006-02-15 05:05:03'),
 (73,51,'2006-02-15 05:05:03'),
 (73,77,'2006-02-15 05:05:03'),
 (73,148,'2006-02-15 05:05:03'),
 (73,245,'2006-02-15 05:05:03'),
 (73,275,'2006-02-15 05:05:03'),
 (73,322,'2006-02-15 05:05:03'),
 (73,374,'2006-02-15 05:05:03'),
 (73,379,'2006-02-15 05:05:03'),
 (73,467,'2006-02-15 05:05:03'),
 (73,548,'2006-02-15 05:05:03'),
 (73,561,'2006-02-15 05:05:03'),
 (73,562,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (73,565,'2006-02-15 05:05:03'),
 (73,627,'2006-02-15 05:05:03'),
 (73,666,'2006-02-15 05:05:03'),
 (73,667,'2006-02-15 05:05:03'),
 (73,707,'2006-02-15 05:05:03'),
 (73,748,'2006-02-15 05:05:03'),
 (73,772,'2006-02-15 05:05:03'),
 (73,823,'2006-02-15 05:05:03'),
 (73,936,'2006-02-15 05:05:03'),
 (73,946,'2006-02-15 05:05:03'),
 (73,950,'2006-02-15 05:05:03'),
 (73,998,'2006-02-15 05:05:03'),
 (74,28,'2006-02-15 05:05:03'),
 (74,44,'2006-02-15 05:05:03'),
 (74,117,'2006-02-15 05:05:03'),
 (74,185,'2006-02-15 05:05:03'),
 (74,192,'2006-02-15 05:05:03'),
 (74,203,'2006-02-15 05:05:03'),
 (74,263,'2006-02-15 05:05:03'),
 (74,321,'2006-02-15 05:05:03'),
 (74,415,'2006-02-15 05:05:03'),
 (74,484,'2006-02-15 05:05:03'),
 (74,503,'2006-02-15 05:05:03'),
 (74,537,'2006-02-15 05:05:03'),
 (74,543,'2006-02-15 05:05:03'),
 (74,617,'2006-02-15 05:05:03'),
 (74,626,'2006-02-15 05:05:03'),
 (74,637,'2006-02-15 05:05:03'),
 (74,663,'2006-02-15 05:05:03'),
 (74,704,'2006-02-15 05:05:03'),
 (74,720,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (74,747,'2006-02-15 05:05:03'),
 (74,780,'2006-02-15 05:05:03'),
 (74,804,'2006-02-15 05:05:03'),
 (74,834,'2006-02-15 05:05:03'),
 (74,836,'2006-02-15 05:05:03'),
 (74,848,'2006-02-15 05:05:03'),
 (74,872,'2006-02-15 05:05:03'),
 (74,902,'2006-02-15 05:05:03'),
 (74,956,'2006-02-15 05:05:03'),
 (75,12,'2006-02-15 05:05:03'),
 (75,34,'2006-02-15 05:05:03'),
 (75,143,'2006-02-15 05:05:03'),
 (75,170,'2006-02-15 05:05:03'),
 (75,222,'2006-02-15 05:05:03'),
 (75,301,'2006-02-15 05:05:03'),
 (75,347,'2006-02-15 05:05:03'),
 (75,372,'2006-02-15 05:05:03'),
 (75,436,'2006-02-15 05:05:03'),
 (75,445,'2006-02-15 05:05:03'),
 (75,446,'2006-02-15 05:05:03'),
 (75,492,'2006-02-15 05:05:03'),
 (75,498,'2006-02-15 05:05:03'),
 (75,508,'2006-02-15 05:05:03'),
 (75,541,'2006-02-15 05:05:03'),
 (75,547,'2006-02-15 05:05:03'),
 (75,579,'2006-02-15 05:05:03'),
 (75,645,'2006-02-15 05:05:03'),
 (75,667,'2006-02-15 05:05:03'),
 (75,744,'2006-02-15 05:05:03'),
 (75,764,'2006-02-15 05:05:03'),
 (75,780,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (75,870,'2006-02-15 05:05:03'),
 (75,920,'2006-02-15 05:05:03'),
 (76,60,'2006-02-15 05:05:03'),
 (76,66,'2006-02-15 05:05:03'),
 (76,68,'2006-02-15 05:05:03'),
 (76,95,'2006-02-15 05:05:03'),
 (76,122,'2006-02-15 05:05:03'),
 (76,187,'2006-02-15 05:05:03'),
 (76,223,'2006-02-15 05:05:03'),
 (76,234,'2006-02-15 05:05:03'),
 (76,251,'2006-02-15 05:05:03'),
 (76,348,'2006-02-15 05:05:03'),
 (76,444,'2006-02-15 05:05:03'),
 (76,464,'2006-02-15 05:05:03'),
 (76,474,'2006-02-15 05:05:03'),
 (76,498,'2006-02-15 05:05:03'),
 (76,568,'2006-02-15 05:05:03'),
 (76,604,'2006-02-15 05:05:03'),
 (76,606,'2006-02-15 05:05:03'),
 (76,642,'2006-02-15 05:05:03'),
 (76,648,'2006-02-15 05:05:03'),
 (76,650,'2006-02-15 05:05:03'),
 (76,709,'2006-02-15 05:05:03'),
 (76,760,'2006-02-15 05:05:03'),
 (76,765,'2006-02-15 05:05:03'),
 (76,781,'2006-02-15 05:05:03'),
 (76,850,'2006-02-15 05:05:03'),
 (76,862,'2006-02-15 05:05:03'),
 (76,866,'2006-02-15 05:05:03'),
 (76,870,'2006-02-15 05:05:03'),
 (76,912,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (76,935,'2006-02-15 05:05:03'),
 (76,958,'2006-02-15 05:05:03'),
 (77,13,'2006-02-15 05:05:03'),
 (77,22,'2006-02-15 05:05:03'),
 (77,40,'2006-02-15 05:05:03'),
 (77,73,'2006-02-15 05:05:03'),
 (77,78,'2006-02-15 05:05:03'),
 (77,153,'2006-02-15 05:05:03'),
 (77,224,'2006-02-15 05:05:03'),
 (77,240,'2006-02-15 05:05:03'),
 (77,245,'2006-02-15 05:05:03'),
 (77,261,'2006-02-15 05:05:03'),
 (77,343,'2006-02-15 05:05:03'),
 (77,442,'2006-02-15 05:05:03'),
 (77,458,'2006-02-15 05:05:03'),
 (77,538,'2006-02-15 05:05:03'),
 (77,566,'2006-02-15 05:05:03'),
 (77,612,'2006-02-15 05:05:03'),
 (77,635,'2006-02-15 05:05:03'),
 (77,694,'2006-02-15 05:05:03'),
 (77,749,'2006-02-15 05:05:03'),
 (77,938,'2006-02-15 05:05:03'),
 (77,943,'2006-02-15 05:05:03'),
 (77,963,'2006-02-15 05:05:03'),
 (77,969,'2006-02-15 05:05:03'),
 (77,993,'2006-02-15 05:05:03'),
 (78,86,'2006-02-15 05:05:03'),
 (78,239,'2006-02-15 05:05:03'),
 (78,260,'2006-02-15 05:05:03'),
 (78,261,'2006-02-15 05:05:03'),
 (78,265,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (78,301,'2006-02-15 05:05:03'),
 (78,387,'2006-02-15 05:05:03'),
 (78,393,'2006-02-15 05:05:03'),
 (78,428,'2006-02-15 05:05:03'),
 (78,457,'2006-02-15 05:05:03'),
 (78,505,'2006-02-15 05:05:03'),
 (78,520,'2006-02-15 05:05:03'),
 (78,530,'2006-02-15 05:05:03'),
 (78,549,'2006-02-15 05:05:03'),
 (78,552,'2006-02-15 05:05:03'),
 (78,599,'2006-02-15 05:05:03'),
 (78,670,'2006-02-15 05:05:03'),
 (78,674,'2006-02-15 05:05:03'),
 (78,689,'2006-02-15 05:05:03'),
 (78,762,'2006-02-15 05:05:03'),
 (78,767,'2006-02-15 05:05:03'),
 (78,811,'2006-02-15 05:05:03'),
 (78,852,'2006-02-15 05:05:03'),
 (78,880,'2006-02-15 05:05:03'),
 (78,963,'2006-02-15 05:05:03'),
 (78,968,'2006-02-15 05:05:03'),
 (79,32,'2006-02-15 05:05:03'),
 (79,33,'2006-02-15 05:05:03'),
 (79,40,'2006-02-15 05:05:03'),
 (79,141,'2006-02-15 05:05:03'),
 (79,205,'2006-02-15 05:05:03'),
 (79,230,'2006-02-15 05:05:03'),
 (79,242,'2006-02-15 05:05:03'),
 (79,262,'2006-02-15 05:05:03'),
 (79,267,'2006-02-15 05:05:03'),
 (79,269,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (79,299,'2006-02-15 05:05:03'),
 (79,367,'2006-02-15 05:05:03'),
 (79,428,'2006-02-15 05:05:03'),
 (79,430,'2006-02-15 05:05:03'),
 (79,473,'2006-02-15 05:05:03'),
 (79,607,'2006-02-15 05:05:03'),
 (79,628,'2006-02-15 05:05:03'),
 (79,634,'2006-02-15 05:05:03'),
 (79,646,'2006-02-15 05:05:03'),
 (79,727,'2006-02-15 05:05:03'),
 (79,750,'2006-02-15 05:05:03'),
 (79,753,'2006-02-15 05:05:03'),
 (79,769,'2006-02-15 05:05:03'),
 (79,776,'2006-02-15 05:05:03'),
 (79,788,'2006-02-15 05:05:03'),
 (79,840,'2006-02-15 05:05:03'),
 (79,853,'2006-02-15 05:05:03'),
 (79,916,'2006-02-15 05:05:03'),
 (80,69,'2006-02-15 05:05:03'),
 (80,118,'2006-02-15 05:05:03'),
 (80,124,'2006-02-15 05:05:03'),
 (80,175,'2006-02-15 05:05:03'),
 (80,207,'2006-02-15 05:05:03'),
 (80,212,'2006-02-15 05:05:03'),
 (80,260,'2006-02-15 05:05:03'),
 (80,262,'2006-02-15 05:05:03'),
 (80,280,'2006-02-15 05:05:03'),
 (80,341,'2006-02-15 05:05:03'),
 (80,342,'2006-02-15 05:05:03'),
 (80,343,'2006-02-15 05:05:03'),
 (80,362,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (80,436,'2006-02-15 05:05:03'),
 (80,475,'2006-02-15 05:05:03'),
 (80,553,'2006-02-15 05:05:03'),
 (80,619,'2006-02-15 05:05:03'),
 (80,622,'2006-02-15 05:05:03'),
 (80,680,'2006-02-15 05:05:03'),
 (80,687,'2006-02-15 05:05:03'),
 (80,688,'2006-02-15 05:05:03'),
 (80,709,'2006-02-15 05:05:03'),
 (80,788,'2006-02-15 05:05:03'),
 (80,807,'2006-02-15 05:05:03'),
 (80,858,'2006-02-15 05:05:03'),
 (80,888,'2006-02-15 05:05:03'),
 (80,941,'2006-02-15 05:05:03'),
 (80,979,'2006-02-15 05:05:03'),
 (81,4,'2006-02-15 05:05:03'),
 (81,11,'2006-02-15 05:05:03'),
 (81,59,'2006-02-15 05:05:03'),
 (81,89,'2006-02-15 05:05:03'),
 (81,178,'2006-02-15 05:05:03'),
 (81,186,'2006-02-15 05:05:03'),
 (81,194,'2006-02-15 05:05:03'),
 (81,215,'2006-02-15 05:05:03'),
 (81,219,'2006-02-15 05:05:03'),
 (81,232,'2006-02-15 05:05:03'),
 (81,260,'2006-02-15 05:05:03'),
 (81,267,'2006-02-15 05:05:03'),
 (81,268,'2006-02-15 05:05:03'),
 (81,304,'2006-02-15 05:05:03'),
 (81,332,'2006-02-15 05:05:03'),
 (81,389,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (81,398,'2006-02-15 05:05:03'),
 (81,453,'2006-02-15 05:05:03'),
 (81,458,'2006-02-15 05:05:03'),
 (81,465,'2006-02-15 05:05:03'),
 (81,505,'2006-02-15 05:05:03'),
 (81,508,'2006-02-15 05:05:03'),
 (81,527,'2006-02-15 05:05:03'),
 (81,545,'2006-02-15 05:05:03'),
 (81,564,'2006-02-15 05:05:03'),
 (81,578,'2006-02-15 05:05:03'),
 (81,579,'2006-02-15 05:05:03'),
 (81,613,'2006-02-15 05:05:03'),
 (81,619,'2006-02-15 05:05:03'),
 (81,643,'2006-02-15 05:05:03'),
 (81,692,'2006-02-15 05:05:03'),
 (81,710,'2006-02-15 05:05:03'),
 (81,729,'2006-02-15 05:05:03'),
 (81,761,'2006-02-15 05:05:03'),
 (81,827,'2006-02-15 05:05:03'),
 (81,910,'2006-02-15 05:05:03'),
 (82,17,'2006-02-15 05:05:03'),
 (82,33,'2006-02-15 05:05:03'),
 (82,104,'2006-02-15 05:05:03'),
 (82,143,'2006-02-15 05:05:03'),
 (82,188,'2006-02-15 05:05:03'),
 (82,242,'2006-02-15 05:05:03'),
 (82,247,'2006-02-15 05:05:03'),
 (82,290,'2006-02-15 05:05:03'),
 (82,306,'2006-02-15 05:05:03'),
 (82,316,'2006-02-15 05:05:03'),
 (82,344,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (82,453,'2006-02-15 05:05:03'),
 (82,468,'2006-02-15 05:05:03'),
 (82,480,'2006-02-15 05:05:03'),
 (82,497,'2006-02-15 05:05:03'),
 (82,503,'2006-02-15 05:05:03'),
 (82,527,'2006-02-15 05:05:03'),
 (82,551,'2006-02-15 05:05:03'),
 (82,561,'2006-02-15 05:05:03'),
 (82,750,'2006-02-15 05:05:03'),
 (82,787,'2006-02-15 05:05:03'),
 (82,802,'2006-02-15 05:05:03'),
 (82,838,'2006-02-15 05:05:03'),
 (82,839,'2006-02-15 05:05:03'),
 (82,870,'2006-02-15 05:05:03'),
 (82,877,'2006-02-15 05:05:03'),
 (82,893,'2006-02-15 05:05:03'),
 (82,911,'2006-02-15 05:05:03'),
 (82,954,'2006-02-15 05:05:03'),
 (82,978,'2006-02-15 05:05:03'),
 (82,985,'2006-02-15 05:05:03'),
 (83,49,'2006-02-15 05:05:03'),
 (83,52,'2006-02-15 05:05:03'),
 (83,58,'2006-02-15 05:05:03'),
 (83,110,'2006-02-15 05:05:03'),
 (83,120,'2006-02-15 05:05:03'),
 (83,121,'2006-02-15 05:05:03'),
 (83,135,'2006-02-15 05:05:03'),
 (83,165,'2006-02-15 05:05:03'),
 (83,217,'2006-02-15 05:05:03'),
 (83,247,'2006-02-15 05:05:03'),
 (83,249,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (83,263,'2006-02-15 05:05:03'),
 (83,268,'2006-02-15 05:05:03'),
 (83,279,'2006-02-15 05:05:03'),
 (83,281,'2006-02-15 05:05:03'),
 (83,339,'2006-02-15 05:05:03'),
 (83,340,'2006-02-15 05:05:03'),
 (83,369,'2006-02-15 05:05:03'),
 (83,412,'2006-02-15 05:05:03'),
 (83,519,'2006-02-15 05:05:03'),
 (83,529,'2006-02-15 05:05:03'),
 (83,615,'2006-02-15 05:05:03'),
 (83,631,'2006-02-15 05:05:03'),
 (83,655,'2006-02-15 05:05:03'),
 (83,672,'2006-02-15 05:05:03'),
 (83,686,'2006-02-15 05:05:03'),
 (83,719,'2006-02-15 05:05:03'),
 (83,764,'2006-02-15 05:05:03'),
 (83,777,'2006-02-15 05:05:03'),
 (83,784,'2006-02-15 05:05:03'),
 (83,833,'2006-02-15 05:05:03'),
 (83,873,'2006-02-15 05:05:03'),
 (83,932,'2006-02-15 05:05:03'),
 (84,19,'2006-02-15 05:05:03'),
 (84,39,'2006-02-15 05:05:03'),
 (84,46,'2006-02-15 05:05:03'),
 (84,175,'2006-02-15 05:05:03'),
 (84,238,'2006-02-15 05:05:03'),
 (84,281,'2006-02-15 05:05:03'),
 (84,290,'2006-02-15 05:05:03'),
 (84,312,'2006-02-15 05:05:03'),
 (84,317,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (84,413,'2006-02-15 05:05:03'),
 (84,414,'2006-02-15 05:05:03'),
 (84,460,'2006-02-15 05:05:03'),
 (84,479,'2006-02-15 05:05:03'),
 (84,491,'2006-02-15 05:05:03'),
 (84,529,'2006-02-15 05:05:03'),
 (84,540,'2006-02-15 05:05:03'),
 (84,566,'2006-02-15 05:05:03'),
 (84,574,'2006-02-15 05:05:03'),
 (84,589,'2006-02-15 05:05:03'),
 (84,616,'2006-02-15 05:05:03'),
 (84,646,'2006-02-15 05:05:03'),
 (84,703,'2006-02-15 05:05:03'),
 (84,729,'2006-02-15 05:05:03'),
 (84,764,'2006-02-15 05:05:03'),
 (84,782,'2006-02-15 05:05:03'),
 (84,809,'2006-02-15 05:05:03'),
 (84,830,'2006-02-15 05:05:03'),
 (84,843,'2006-02-15 05:05:03'),
 (84,887,'2006-02-15 05:05:03'),
 (84,975,'2006-02-15 05:05:03'),
 (84,996,'2006-02-15 05:05:03'),
 (85,2,'2006-02-15 05:05:03'),
 (85,14,'2006-02-15 05:05:03'),
 (85,72,'2006-02-15 05:05:03'),
 (85,85,'2006-02-15 05:05:03'),
 (85,92,'2006-02-15 05:05:03'),
 (85,148,'2006-02-15 05:05:03'),
 (85,216,'2006-02-15 05:05:03'),
 (85,290,'2006-02-15 05:05:03'),
 (85,296,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (85,297,'2006-02-15 05:05:03'),
 (85,337,'2006-02-15 05:05:03'),
 (85,383,'2006-02-15 05:05:03'),
 (85,421,'2006-02-15 05:05:03'),
 (85,446,'2006-02-15 05:05:03'),
 (85,461,'2006-02-15 05:05:03'),
 (85,475,'2006-02-15 05:05:03'),
 (85,478,'2006-02-15 05:05:03'),
 (85,522,'2006-02-15 05:05:03'),
 (85,543,'2006-02-15 05:05:03'),
 (85,558,'2006-02-15 05:05:03'),
 (85,591,'2006-02-15 05:05:03'),
 (85,630,'2006-02-15 05:05:03'),
 (85,678,'2006-02-15 05:05:03'),
 (85,711,'2006-02-15 05:05:03'),
 (85,761,'2006-02-15 05:05:03'),
 (85,812,'2006-02-15 05:05:03'),
 (85,869,'2006-02-15 05:05:03'),
 (85,875,'2006-02-15 05:05:03'),
 (85,895,'2006-02-15 05:05:03'),
 (85,957,'2006-02-15 05:05:03'),
 (85,960,'2006-02-15 05:05:03'),
 (86,137,'2006-02-15 05:05:03'),
 (86,163,'2006-02-15 05:05:03'),
 (86,196,'2006-02-15 05:05:03'),
 (86,216,'2006-02-15 05:05:03'),
 (86,249,'2006-02-15 05:05:03'),
 (86,303,'2006-02-15 05:05:03'),
 (86,331,'2006-02-15 05:05:03'),
 (86,364,'2006-02-15 05:05:03'),
 (86,391,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (86,432,'2006-02-15 05:05:03'),
 (86,482,'2006-02-15 05:05:03'),
 (86,486,'2006-02-15 05:05:03'),
 (86,519,'2006-02-15 05:05:03'),
 (86,520,'2006-02-15 05:05:03'),
 (86,548,'2006-02-15 05:05:03'),
 (86,623,'2006-02-15 05:05:03'),
 (86,631,'2006-02-15 05:05:03'),
 (86,636,'2006-02-15 05:05:03'),
 (86,752,'2006-02-15 05:05:03'),
 (86,760,'2006-02-15 05:05:03'),
 (86,808,'2006-02-15 05:05:03'),
 (86,857,'2006-02-15 05:05:03'),
 (86,878,'2006-02-15 05:05:03'),
 (86,893,'2006-02-15 05:05:03'),
 (86,905,'2006-02-15 05:05:03'),
 (86,923,'2006-02-15 05:05:03'),
 (86,929,'2006-02-15 05:05:03'),
 (87,48,'2006-02-15 05:05:03'),
 (87,157,'2006-02-15 05:05:03'),
 (87,161,'2006-02-15 05:05:03'),
 (87,199,'2006-02-15 05:05:03'),
 (87,207,'2006-02-15 05:05:03'),
 (87,250,'2006-02-15 05:05:03'),
 (87,253,'2006-02-15 05:05:03'),
 (87,312,'2006-02-15 05:05:03'),
 (87,421,'2006-02-15 05:05:03'),
 (87,570,'2006-02-15 05:05:03'),
 (87,599,'2006-02-15 05:05:03'),
 (87,606,'2006-02-15 05:05:03'),
 (87,654,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (87,679,'2006-02-15 05:05:03'),
 (87,706,'2006-02-15 05:05:03'),
 (87,718,'2006-02-15 05:05:03'),
 (87,721,'2006-02-15 05:05:03'),
 (87,830,'2006-02-15 05:05:03'),
 (87,870,'2006-02-15 05:05:03'),
 (87,952,'2006-02-15 05:05:03'),
 (87,961,'2006-02-15 05:05:03'),
 (88,4,'2006-02-15 05:05:03'),
 (88,76,'2006-02-15 05:05:03'),
 (88,87,'2006-02-15 05:05:03'),
 (88,128,'2006-02-15 05:05:03'),
 (88,170,'2006-02-15 05:05:03'),
 (88,193,'2006-02-15 05:05:03'),
 (88,234,'2006-02-15 05:05:03'),
 (88,304,'2006-02-15 05:05:03'),
 (88,602,'2006-02-15 05:05:03'),
 (88,620,'2006-02-15 05:05:03'),
 (88,668,'2006-02-15 05:05:03'),
 (88,717,'2006-02-15 05:05:03'),
 (88,785,'2006-02-15 05:05:03'),
 (88,819,'2006-02-15 05:05:03'),
 (88,839,'2006-02-15 05:05:03'),
 (88,881,'2006-02-15 05:05:03'),
 (88,908,'2006-02-15 05:05:03'),
 (88,929,'2006-02-15 05:05:03'),
 (88,940,'2006-02-15 05:05:03'),
 (88,968,'2006-02-15 05:05:03'),
 (89,47,'2006-02-15 05:05:03'),
 (89,103,'2006-02-15 05:05:03'),
 (89,117,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (89,162,'2006-02-15 05:05:03'),
 (89,182,'2006-02-15 05:05:03'),
 (89,187,'2006-02-15 05:05:03'),
 (89,212,'2006-02-15 05:05:03'),
 (89,254,'2006-02-15 05:05:03'),
 (89,266,'2006-02-15 05:05:03'),
 (89,306,'2006-02-15 05:05:03'),
 (89,342,'2006-02-15 05:05:03'),
 (89,406,'2006-02-15 05:05:03'),
 (89,410,'2006-02-15 05:05:03'),
 (89,446,'2006-02-15 05:05:03'),
 (89,473,'2006-02-15 05:05:03'),
 (89,488,'2006-02-15 05:05:03'),
 (89,529,'2006-02-15 05:05:03'),
 (89,542,'2006-02-15 05:05:03'),
 (89,564,'2006-02-15 05:05:03'),
 (89,697,'2006-02-15 05:05:03'),
 (89,833,'2006-02-15 05:05:03'),
 (89,864,'2006-02-15 05:05:03'),
 (89,970,'2006-02-15 05:05:03'),
 (89,976,'2006-02-15 05:05:03'),
 (90,2,'2006-02-15 05:05:03'),
 (90,11,'2006-02-15 05:05:03'),
 (90,100,'2006-02-15 05:05:03'),
 (90,197,'2006-02-15 05:05:03'),
 (90,212,'2006-02-15 05:05:03'),
 (90,262,'2006-02-15 05:05:03'),
 (90,303,'2006-02-15 05:05:03'),
 (90,330,'2006-02-15 05:05:03'),
 (90,363,'2006-02-15 05:05:03'),
 (90,374,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (90,384,'2006-02-15 05:05:03'),
 (90,385,'2006-02-15 05:05:03'),
 (90,391,'2006-02-15 05:05:03'),
 (90,406,'2006-02-15 05:05:03'),
 (90,433,'2006-02-15 05:05:03'),
 (90,442,'2006-02-15 05:05:03'),
 (90,451,'2006-02-15 05:05:03'),
 (90,520,'2006-02-15 05:05:03'),
 (90,529,'2006-02-15 05:05:03'),
 (90,542,'2006-02-15 05:05:03'),
 (90,586,'2006-02-15 05:05:03'),
 (90,633,'2006-02-15 05:05:03'),
 (90,663,'2006-02-15 05:05:03'),
 (90,676,'2006-02-15 05:05:03'),
 (90,771,'2006-02-15 05:05:03'),
 (90,817,'2006-02-15 05:05:03'),
 (90,838,'2006-02-15 05:05:03'),
 (90,855,'2006-02-15 05:05:03'),
 (90,858,'2006-02-15 05:05:03'),
 (90,868,'2006-02-15 05:05:03'),
 (90,880,'2006-02-15 05:05:03'),
 (90,901,'2006-02-15 05:05:03'),
 (90,925,'2006-02-15 05:05:03'),
 (91,13,'2006-02-15 05:05:03'),
 (91,25,'2006-02-15 05:05:03'),
 (91,48,'2006-02-15 05:05:03'),
 (91,176,'2006-02-15 05:05:03'),
 (91,181,'2006-02-15 05:05:03'),
 (91,190,'2006-02-15 05:05:03'),
 (91,335,'2006-02-15 05:05:03'),
 (91,416,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (91,447,'2006-02-15 05:05:03'),
 (91,480,'2006-02-15 05:05:03'),
 (91,493,'2006-02-15 05:05:03'),
 (91,509,'2006-02-15 05:05:03'),
 (91,511,'2006-02-15 05:05:03'),
 (91,608,'2006-02-15 05:05:03'),
 (91,807,'2006-02-15 05:05:03'),
 (91,829,'2006-02-15 05:05:03'),
 (91,849,'2006-02-15 05:05:03'),
 (91,859,'2006-02-15 05:05:03'),
 (91,941,'2006-02-15 05:05:03'),
 (91,982,'2006-02-15 05:05:03'),
 (92,90,'2006-02-15 05:05:03'),
 (92,94,'2006-02-15 05:05:03'),
 (92,103,'2006-02-15 05:05:03'),
 (92,104,'2006-02-15 05:05:03'),
 (92,123,'2006-02-15 05:05:03'),
 (92,137,'2006-02-15 05:05:03'),
 (92,207,'2006-02-15 05:05:03'),
 (92,229,'2006-02-15 05:05:03'),
 (92,338,'2006-02-15 05:05:03'),
 (92,381,'2006-02-15 05:05:03'),
 (92,436,'2006-02-15 05:05:03'),
 (92,443,'2006-02-15 05:05:03'),
 (92,453,'2006-02-15 05:05:03'),
 (92,470,'2006-02-15 05:05:03'),
 (92,505,'2006-02-15 05:05:03'),
 (92,512,'2006-02-15 05:05:03'),
 (92,543,'2006-02-15 05:05:03'),
 (92,545,'2006-02-15 05:05:03'),
 (92,547,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (92,553,'2006-02-15 05:05:03'),
 (92,564,'2006-02-15 05:05:03'),
 (92,568,'2006-02-15 05:05:03'),
 (92,618,'2006-02-15 05:05:03'),
 (92,662,'2006-02-15 05:05:03'),
 (92,686,'2006-02-15 05:05:03'),
 (92,699,'2006-02-15 05:05:03'),
 (92,712,'2006-02-15 05:05:03'),
 (92,728,'2006-02-15 05:05:03'),
 (92,802,'2006-02-15 05:05:03'),
 (92,825,'2006-02-15 05:05:03'),
 (92,838,'2006-02-15 05:05:03'),
 (92,889,'2006-02-15 05:05:03'),
 (92,929,'2006-02-15 05:05:03'),
 (92,991,'2006-02-15 05:05:03'),
 (93,71,'2006-02-15 05:05:03'),
 (93,120,'2006-02-15 05:05:03'),
 (93,124,'2006-02-15 05:05:03'),
 (93,280,'2006-02-15 05:05:03'),
 (93,325,'2006-02-15 05:05:03'),
 (93,339,'2006-02-15 05:05:03'),
 (93,427,'2006-02-15 05:05:03'),
 (93,445,'2006-02-15 05:05:03'),
 (93,453,'2006-02-15 05:05:03'),
 (93,473,'2006-02-15 05:05:03'),
 (93,573,'2006-02-15 05:05:03'),
 (93,621,'2006-02-15 05:05:03'),
 (93,644,'2006-02-15 05:05:03'),
 (93,678,'2006-02-15 05:05:03'),
 (93,680,'2006-02-15 05:05:03'),
 (93,699,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (93,744,'2006-02-15 05:05:03'),
 (93,768,'2006-02-15 05:05:03'),
 (93,777,'2006-02-15 05:05:03'),
 (93,835,'2006-02-15 05:05:03'),
 (93,856,'2006-02-15 05:05:03'),
 (93,874,'2006-02-15 05:05:03'),
 (93,909,'2006-02-15 05:05:03'),
 (93,916,'2006-02-15 05:05:03'),
 (93,982,'2006-02-15 05:05:03'),
 (94,13,'2006-02-15 05:05:03'),
 (94,60,'2006-02-15 05:05:03'),
 (94,76,'2006-02-15 05:05:03'),
 (94,122,'2006-02-15 05:05:03'),
 (94,153,'2006-02-15 05:05:03'),
 (94,193,'2006-02-15 05:05:03'),
 (94,206,'2006-02-15 05:05:03'),
 (94,228,'2006-02-15 05:05:03'),
 (94,270,'2006-02-15 05:05:03'),
 (94,275,'2006-02-15 05:05:03'),
 (94,320,'2006-02-15 05:05:03'),
 (94,322,'2006-02-15 05:05:03'),
 (94,337,'2006-02-15 05:05:03'),
 (94,354,'2006-02-15 05:05:03'),
 (94,402,'2006-02-15 05:05:03'),
 (94,428,'2006-02-15 05:05:03'),
 (94,457,'2006-02-15 05:05:03'),
 (94,473,'2006-02-15 05:05:03'),
 (94,475,'2006-02-15 05:05:03'),
 (94,512,'2006-02-15 05:05:03'),
 (94,517,'2006-02-15 05:05:03'),
 (94,521,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (94,533,'2006-02-15 05:05:03'),
 (94,540,'2006-02-15 05:05:03'),
 (94,548,'2006-02-15 05:05:03'),
 (94,551,'2006-02-15 05:05:03'),
 (94,712,'2006-02-15 05:05:03'),
 (94,713,'2006-02-15 05:05:03'),
 (94,724,'2006-02-15 05:05:03'),
 (94,775,'2006-02-15 05:05:03'),
 (94,788,'2006-02-15 05:05:03'),
 (94,950,'2006-02-15 05:05:03'),
 (94,989,'2006-02-15 05:05:03'),
 (95,22,'2006-02-15 05:05:03'),
 (95,35,'2006-02-15 05:05:03'),
 (95,47,'2006-02-15 05:05:03'),
 (95,52,'2006-02-15 05:05:03'),
 (95,65,'2006-02-15 05:05:03'),
 (95,74,'2006-02-15 05:05:03'),
 (95,126,'2006-02-15 05:05:03'),
 (95,207,'2006-02-15 05:05:03'),
 (95,245,'2006-02-15 05:05:03'),
 (95,294,'2006-02-15 05:05:03'),
 (95,301,'2006-02-15 05:05:03'),
 (95,312,'2006-02-15 05:05:03'),
 (95,329,'2006-02-15 05:05:03'),
 (95,353,'2006-02-15 05:05:03'),
 (95,375,'2006-02-15 05:05:03'),
 (95,420,'2006-02-15 05:05:03'),
 (95,424,'2006-02-15 05:05:03'),
 (95,431,'2006-02-15 05:05:03'),
 (95,498,'2006-02-15 05:05:03'),
 (95,522,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (95,546,'2006-02-15 05:05:03'),
 (95,551,'2006-02-15 05:05:03'),
 (95,619,'2006-02-15 05:05:03'),
 (95,627,'2006-02-15 05:05:03'),
 (95,690,'2006-02-15 05:05:03'),
 (95,748,'2006-02-15 05:05:03'),
 (95,813,'2006-02-15 05:05:03'),
 (95,828,'2006-02-15 05:05:03'),
 (95,855,'2006-02-15 05:05:03'),
 (95,903,'2006-02-15 05:05:03'),
 (95,923,'2006-02-15 05:05:03'),
 (96,8,'2006-02-15 05:05:03'),
 (96,36,'2006-02-15 05:05:03'),
 (96,40,'2006-02-15 05:05:03'),
 (96,54,'2006-02-15 05:05:03'),
 (96,58,'2006-02-15 05:05:03'),
 (96,66,'2006-02-15 05:05:03'),
 (96,134,'2006-02-15 05:05:03'),
 (96,209,'2006-02-15 05:05:03'),
 (96,244,'2006-02-15 05:05:03'),
 (96,320,'2006-02-15 05:05:03'),
 (96,430,'2006-02-15 05:05:03'),
 (96,452,'2006-02-15 05:05:03'),
 (96,486,'2006-02-15 05:05:03'),
 (96,572,'2006-02-15 05:05:03'),
 (96,590,'2006-02-15 05:05:03'),
 (96,661,'2006-02-15 05:05:03'),
 (96,778,'2006-02-15 05:05:03'),
 (96,832,'2006-02-15 05:05:03'),
 (96,846,'2006-02-15 05:05:03'),
 (96,874,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (96,945,'2006-02-15 05:05:03'),
 (96,968,'2006-02-15 05:05:03'),
 (96,987,'2006-02-15 05:05:03'),
 (97,143,'2006-02-15 05:05:03'),
 (97,177,'2006-02-15 05:05:03'),
 (97,188,'2006-02-15 05:05:03'),
 (97,197,'2006-02-15 05:05:03'),
 (97,256,'2006-02-15 05:05:03'),
 (97,312,'2006-02-15 05:05:03'),
 (97,342,'2006-02-15 05:05:03'),
 (97,348,'2006-02-15 05:05:03'),
 (97,358,'2006-02-15 05:05:03'),
 (97,370,'2006-02-15 05:05:03'),
 (97,437,'2006-02-15 05:05:03'),
 (97,446,'2006-02-15 05:05:03'),
 (97,466,'2006-02-15 05:05:03'),
 (97,518,'2006-02-15 05:05:03'),
 (97,553,'2006-02-15 05:05:03'),
 (97,561,'2006-02-15 05:05:03'),
 (97,641,'2006-02-15 05:05:03'),
 (97,656,'2006-02-15 05:05:03'),
 (97,728,'2006-02-15 05:05:03'),
 (97,755,'2006-02-15 05:05:03'),
 (97,757,'2006-02-15 05:05:03'),
 (97,826,'2006-02-15 05:05:03'),
 (97,862,'2006-02-15 05:05:03'),
 (97,930,'2006-02-15 05:05:03'),
 (97,933,'2006-02-15 05:05:03'),
 (97,947,'2006-02-15 05:05:03'),
 (97,951,'2006-02-15 05:05:03'),
 (98,66,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (98,72,'2006-02-15 05:05:03'),
 (98,81,'2006-02-15 05:05:03'),
 (98,87,'2006-02-15 05:05:03'),
 (98,107,'2006-02-15 05:05:03'),
 (98,120,'2006-02-15 05:05:03'),
 (98,183,'2006-02-15 05:05:03'),
 (98,194,'2006-02-15 05:05:03'),
 (98,212,'2006-02-15 05:05:03'),
 (98,297,'2006-02-15 05:05:03'),
 (98,607,'2006-02-15 05:05:03'),
 (98,634,'2006-02-15 05:05:03'),
 (98,686,'2006-02-15 05:05:03'),
 (98,705,'2006-02-15 05:05:03'),
 (98,710,'2006-02-15 05:05:03'),
 (98,721,'2006-02-15 05:05:03'),
 (98,725,'2006-02-15 05:05:03'),
 (98,734,'2006-02-15 05:05:03'),
 (98,738,'2006-02-15 05:05:03'),
 (98,765,'2006-02-15 05:05:03'),
 (98,782,'2006-02-15 05:05:03'),
 (98,824,'2006-02-15 05:05:03'),
 (98,829,'2006-02-15 05:05:03'),
 (98,912,'2006-02-15 05:05:03'),
 (98,955,'2006-02-15 05:05:03'),
 (98,985,'2006-02-15 05:05:03'),
 (98,990,'2006-02-15 05:05:03'),
 (99,7,'2006-02-15 05:05:03'),
 (99,27,'2006-02-15 05:05:03'),
 (99,84,'2006-02-15 05:05:03'),
 (99,250,'2006-02-15 05:05:03'),
 (99,322,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (99,325,'2006-02-15 05:05:03'),
 (99,381,'2006-02-15 05:05:03'),
 (99,414,'2006-02-15 05:05:03'),
 (99,475,'2006-02-15 05:05:03'),
 (99,490,'2006-02-15 05:05:03'),
 (99,512,'2006-02-15 05:05:03'),
 (99,540,'2006-02-15 05:05:03'),
 (99,572,'2006-02-15 05:05:03'),
 (99,600,'2006-02-15 05:05:03'),
 (99,618,'2006-02-15 05:05:03'),
 (99,620,'2006-02-15 05:05:03'),
 (99,622,'2006-02-15 05:05:03'),
 (99,636,'2006-02-15 05:05:03'),
 (99,672,'2006-02-15 05:05:03'),
 (99,726,'2006-02-15 05:05:03'),
 (99,741,'2006-02-15 05:05:03'),
 (99,796,'2006-02-15 05:05:03'),
 (99,835,'2006-02-15 05:05:03'),
 (99,967,'2006-02-15 05:05:03'),
 (99,978,'2006-02-15 05:05:03'),
 (99,982,'2006-02-15 05:05:03'),
 (100,17,'2006-02-15 05:05:03'),
 (100,118,'2006-02-15 05:05:03'),
 (100,250,'2006-02-15 05:05:03'),
 (100,411,'2006-02-15 05:05:03'),
 (100,414,'2006-02-15 05:05:03'),
 (100,513,'2006-02-15 05:05:03'),
 (100,563,'2006-02-15 05:05:03'),
 (100,642,'2006-02-15 05:05:03'),
 (100,714,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (100,718,'2006-02-15 05:05:03'),
 (100,759,'2006-02-15 05:05:03'),
 (100,779,'2006-02-15 05:05:03'),
 (100,815,'2006-02-15 05:05:03'),
 (100,846,'2006-02-15 05:05:03'),
 (100,850,'2006-02-15 05:05:03'),
 (100,872,'2006-02-15 05:05:03'),
 (100,877,'2006-02-15 05:05:03'),
 (100,909,'2006-02-15 05:05:03'),
 (100,919,'2006-02-15 05:05:03'),
 (100,944,'2006-02-15 05:05:03'),
 (100,967,'2006-02-15 05:05:03'),
 (100,979,'2006-02-15 05:05:03'),
 (100,991,'2006-02-15 05:05:03'),
 (100,992,'2006-02-15 05:05:03'),
 (101,60,'2006-02-15 05:05:03'),
 (101,66,'2006-02-15 05:05:03'),
 (101,85,'2006-02-15 05:05:03'),
 (101,146,'2006-02-15 05:05:03'),
 (101,189,'2006-02-15 05:05:03'),
 (101,250,'2006-02-15 05:05:03'),
 (101,255,'2006-02-15 05:05:03'),
 (101,263,'2006-02-15 05:05:03'),
 (101,275,'2006-02-15 05:05:03'),
 (101,289,'2006-02-15 05:05:03'),
 (101,491,'2006-02-15 05:05:03'),
 (101,494,'2006-02-15 05:05:03'),
 (101,511,'2006-02-15 05:05:03'),
 (101,568,'2006-02-15 05:05:03'),
 (101,608,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (101,617,'2006-02-15 05:05:03'),
 (101,655,'2006-02-15 05:05:03'),
 (101,662,'2006-02-15 05:05:03'),
 (101,700,'2006-02-15 05:05:03'),
 (101,702,'2006-02-15 05:05:03'),
 (101,758,'2006-02-15 05:05:03'),
 (101,774,'2006-02-15 05:05:03'),
 (101,787,'2006-02-15 05:05:03'),
 (101,828,'2006-02-15 05:05:03'),
 (101,841,'2006-02-15 05:05:03'),
 (101,928,'2006-02-15 05:05:03'),
 (101,932,'2006-02-15 05:05:03'),
 (101,936,'2006-02-15 05:05:03'),
 (101,941,'2006-02-15 05:05:03'),
 (101,978,'2006-02-15 05:05:03'),
 (101,980,'2006-02-15 05:05:03'),
 (101,984,'2006-02-15 05:05:03'),
 (101,988,'2006-02-15 05:05:03'),
 (102,20,'2006-02-15 05:05:03'),
 (102,34,'2006-02-15 05:05:03'),
 (102,53,'2006-02-15 05:05:03'),
 (102,123,'2006-02-15 05:05:03'),
 (102,124,'2006-02-15 05:05:03'),
 (102,194,'2006-02-15 05:05:03'),
 (102,200,'2006-02-15 05:05:03'),
 (102,205,'2006-02-15 05:05:03'),
 (102,268,'2006-02-15 05:05:03'),
 (102,326,'2006-02-15 05:05:03'),
 (102,329,'2006-02-15 05:05:03'),
 (102,334,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (102,351,'2006-02-15 05:05:03'),
 (102,418,'2006-02-15 05:05:03'),
 (102,431,'2006-02-15 05:05:03'),
 (102,446,'2006-02-15 05:05:03'),
 (102,485,'2006-02-15 05:05:03'),
 (102,508,'2006-02-15 05:05:03'),
 (102,517,'2006-02-15 05:05:03'),
 (102,521,'2006-02-15 05:05:03'),
 (102,526,'2006-02-15 05:05:03'),
 (102,529,'2006-02-15 05:05:03'),
 (102,544,'2006-02-15 05:05:03'),
 (102,600,'2006-02-15 05:05:03'),
 (102,605,'2006-02-15 05:05:03'),
 (102,606,'2006-02-15 05:05:03'),
 (102,624,'2006-02-15 05:05:03'),
 (102,631,'2006-02-15 05:05:03'),
 (102,712,'2006-02-15 05:05:03'),
 (102,728,'2006-02-15 05:05:03'),
 (102,744,'2006-02-15 05:05:03'),
 (102,796,'2006-02-15 05:05:03'),
 (102,802,'2006-02-15 05:05:03'),
 (102,810,'2006-02-15 05:05:03'),
 (102,828,'2006-02-15 05:05:03'),
 (102,837,'2006-02-15 05:05:03'),
 (102,845,'2006-02-15 05:05:03'),
 (102,852,'2006-02-15 05:05:03'),
 (102,958,'2006-02-15 05:05:03'),
 (102,979,'2006-02-15 05:05:03'),
 (102,980,'2006-02-15 05:05:03'),
 (103,5,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (103,118,'2006-02-15 05:05:03'),
 (103,130,'2006-02-15 05:05:03'),
 (103,197,'2006-02-15 05:05:03'),
 (103,199,'2006-02-15 05:05:03'),
 (103,206,'2006-02-15 05:05:03'),
 (103,215,'2006-02-15 05:05:03'),
 (103,221,'2006-02-15 05:05:03'),
 (103,271,'2006-02-15 05:05:03'),
 (103,285,'2006-02-15 05:05:03'),
 (103,315,'2006-02-15 05:05:03'),
 (103,318,'2006-02-15 05:05:03'),
 (103,333,'2006-02-15 05:05:03'),
 (103,347,'2006-02-15 05:05:03'),
 (103,356,'2006-02-15 05:05:03'),
 (103,360,'2006-02-15 05:05:03'),
 (103,378,'2006-02-15 05:05:03'),
 (103,437,'2006-02-15 05:05:03'),
 (103,585,'2006-02-15 05:05:03'),
 (103,609,'2006-02-15 05:05:03'),
 (103,639,'2006-02-15 05:05:03'),
 (103,643,'2006-02-15 05:05:03'),
 (103,692,'2006-02-15 05:05:03'),
 (103,735,'2006-02-15 05:05:03'),
 (103,822,'2006-02-15 05:05:03'),
 (103,895,'2006-02-15 05:05:03'),
 (103,903,'2006-02-15 05:05:03'),
 (103,912,'2006-02-15 05:05:03'),
 (103,942,'2006-02-15 05:05:03'),
 (103,956,'2006-02-15 05:05:03'),
 (104,19,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (104,39,'2006-02-15 05:05:03'),
 (104,40,'2006-02-15 05:05:03'),
 (104,59,'2006-02-15 05:05:03'),
 (104,70,'2006-02-15 05:05:03'),
 (104,136,'2006-02-15 05:05:03'),
 (104,156,'2006-02-15 05:05:03'),
 (104,184,'2006-02-15 05:05:03'),
 (104,198,'2006-02-15 05:05:03'),
 (104,233,'2006-02-15 05:05:03'),
 (104,259,'2006-02-15 05:05:03'),
 (104,287,'2006-02-15 05:05:03'),
 (104,309,'2006-02-15 05:05:03'),
 (104,313,'2006-02-15 05:05:03'),
 (104,394,'2006-02-15 05:05:03'),
 (104,401,'2006-02-15 05:05:03'),
 (104,463,'2006-02-15 05:05:03'),
 (104,506,'2006-02-15 05:05:03'),
 (104,516,'2006-02-15 05:05:03'),
 (104,583,'2006-02-15 05:05:03'),
 (104,600,'2006-02-15 05:05:03'),
 (104,607,'2006-02-15 05:05:03'),
 (104,657,'2006-02-15 05:05:03'),
 (104,677,'2006-02-15 05:05:03'),
 (104,739,'2006-02-15 05:05:03'),
 (104,892,'2006-02-15 05:05:03'),
 (104,904,'2006-02-15 05:05:03'),
 (104,926,'2006-02-15 05:05:03'),
 (104,945,'2006-02-15 05:05:03'),
 (104,984,'2006-02-15 05:05:03'),
 (104,999,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (105,12,'2006-02-15 05:05:03'),
 (105,15,'2006-02-15 05:05:03'),
 (105,21,'2006-02-15 05:05:03'),
 (105,29,'2006-02-15 05:05:03'),
 (105,42,'2006-02-15 05:05:03'),
 (105,116,'2006-02-15 05:05:03'),
 (105,158,'2006-02-15 05:05:03'),
 (105,239,'2006-02-15 05:05:03'),
 (105,280,'2006-02-15 05:05:03'),
 (105,283,'2006-02-15 05:05:03'),
 (105,315,'2006-02-15 05:05:03'),
 (105,333,'2006-02-15 05:05:03'),
 (105,372,'2006-02-15 05:05:03'),
 (105,377,'2006-02-15 05:05:03'),
 (105,530,'2006-02-15 05:05:03'),
 (105,558,'2006-02-15 05:05:03'),
 (105,561,'2006-02-15 05:05:03'),
 (105,606,'2006-02-15 05:05:03'),
 (105,649,'2006-02-15 05:05:03'),
 (105,686,'2006-02-15 05:05:03'),
 (105,750,'2006-02-15 05:05:03'),
 (105,795,'2006-02-15 05:05:03'),
 (105,831,'2006-02-15 05:05:03'),
 (105,835,'2006-02-15 05:05:03'),
 (105,858,'2006-02-15 05:05:03'),
 (105,864,'2006-02-15 05:05:03'),
 (105,893,'2006-02-15 05:05:03'),
 (105,906,'2006-02-15 05:05:03'),
 (105,910,'2006-02-15 05:05:03'),
 (105,915,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (105,954,'2006-02-15 05:05:03'),
 (105,990,'2006-02-15 05:05:03'),
 (105,993,'2006-02-15 05:05:03'),
 (105,994,'2006-02-15 05:05:03'),
 (106,44,'2006-02-15 05:05:03'),
 (106,83,'2006-02-15 05:05:03'),
 (106,108,'2006-02-15 05:05:03'),
 (106,126,'2006-02-15 05:05:03'),
 (106,136,'2006-02-15 05:05:03'),
 (106,166,'2006-02-15 05:05:03'),
 (106,189,'2006-02-15 05:05:03'),
 (106,194,'2006-02-15 05:05:03'),
 (106,204,'2006-02-15 05:05:03'),
 (106,229,'2006-02-15 05:05:03'),
 (106,241,'2006-02-15 05:05:03'),
 (106,345,'2006-02-15 05:05:03'),
 (106,365,'2006-02-15 05:05:03'),
 (106,399,'2006-02-15 05:05:03'),
 (106,439,'2006-02-15 05:05:03'),
 (106,457,'2006-02-15 05:05:03'),
 (106,469,'2006-02-15 05:05:03'),
 (106,500,'2006-02-15 05:05:03'),
 (106,505,'2006-02-15 05:05:03'),
 (106,559,'2006-02-15 05:05:03'),
 (106,566,'2006-02-15 05:05:03'),
 (106,585,'2006-02-15 05:05:03'),
 (106,639,'2006-02-15 05:05:03'),
 (106,654,'2006-02-15 05:05:03'),
 (106,659,'2006-02-15 05:05:03'),
 (106,675,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (106,687,'2006-02-15 05:05:03'),
 (106,752,'2006-02-15 05:05:03'),
 (106,763,'2006-02-15 05:05:03'),
 (106,780,'2006-02-15 05:05:03'),
 (106,858,'2006-02-15 05:05:03'),
 (106,866,'2006-02-15 05:05:03'),
 (106,881,'2006-02-15 05:05:03'),
 (106,894,'2006-02-15 05:05:03'),
 (106,934,'2006-02-15 05:05:03'),
 (107,62,'2006-02-15 05:05:03'),
 (107,112,'2006-02-15 05:05:03'),
 (107,133,'2006-02-15 05:05:03'),
 (107,136,'2006-02-15 05:05:03'),
 (107,138,'2006-02-15 05:05:03'),
 (107,162,'2006-02-15 05:05:03'),
 (107,165,'2006-02-15 05:05:03'),
 (107,172,'2006-02-15 05:05:03'),
 (107,209,'2006-02-15 05:05:03'),
 (107,220,'2006-02-15 05:05:03'),
 (107,239,'2006-02-15 05:05:03'),
 (107,277,'2006-02-15 05:05:03'),
 (107,292,'2006-02-15 05:05:03'),
 (107,338,'2006-02-15 05:05:03'),
 (107,348,'2006-02-15 05:05:03'),
 (107,369,'2006-02-15 05:05:03'),
 (107,388,'2006-02-15 05:05:03'),
 (107,392,'2006-02-15 05:05:03'),
 (107,409,'2006-02-15 05:05:03'),
 (107,430,'2006-02-15 05:05:03'),
 (107,445,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (107,454,'2006-02-15 05:05:03'),
 (107,458,'2006-02-15 05:05:03'),
 (107,467,'2006-02-15 05:05:03'),
 (107,520,'2006-02-15 05:05:03'),
 (107,534,'2006-02-15 05:05:03'),
 (107,548,'2006-02-15 05:05:03'),
 (107,571,'2006-02-15 05:05:03'),
 (107,574,'2006-02-15 05:05:03'),
 (107,603,'2006-02-15 05:05:03'),
 (107,606,'2006-02-15 05:05:03'),
 (107,637,'2006-02-15 05:05:03'),
 (107,774,'2006-02-15 05:05:03'),
 (107,781,'2006-02-15 05:05:03'),
 (107,796,'2006-02-15 05:05:03'),
 (107,831,'2006-02-15 05:05:03'),
 (107,849,'2006-02-15 05:05:03'),
 (107,859,'2006-02-15 05:05:03'),
 (107,879,'2006-02-15 05:05:03'),
 (107,905,'2006-02-15 05:05:03'),
 (107,973,'2006-02-15 05:05:03'),
 (107,977,'2006-02-15 05:05:03'),
 (108,1,'2006-02-15 05:05:03'),
 (108,6,'2006-02-15 05:05:03'),
 (108,9,'2006-02-15 05:05:03'),
 (108,137,'2006-02-15 05:05:03'),
 (108,208,'2006-02-15 05:05:03'),
 (108,219,'2006-02-15 05:05:03'),
 (108,242,'2006-02-15 05:05:03'),
 (108,278,'2006-02-15 05:05:03'),
 (108,302,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (108,350,'2006-02-15 05:05:03'),
 (108,378,'2006-02-15 05:05:03'),
 (108,379,'2006-02-15 05:05:03'),
 (108,495,'2006-02-15 05:05:03'),
 (108,507,'2006-02-15 05:05:03'),
 (108,517,'2006-02-15 05:05:03'),
 (108,561,'2006-02-15 05:05:03'),
 (108,567,'2006-02-15 05:05:03'),
 (108,648,'2006-02-15 05:05:03'),
 (108,652,'2006-02-15 05:05:03'),
 (108,655,'2006-02-15 05:05:03'),
 (108,673,'2006-02-15 05:05:03'),
 (108,693,'2006-02-15 05:05:03'),
 (108,696,'2006-02-15 05:05:03'),
 (108,702,'2006-02-15 05:05:03'),
 (108,721,'2006-02-15 05:05:03'),
 (108,733,'2006-02-15 05:05:03'),
 (108,741,'2006-02-15 05:05:03'),
 (108,744,'2006-02-15 05:05:03'),
 (108,887,'2006-02-15 05:05:03'),
 (108,892,'2006-02-15 05:05:03'),
 (108,894,'2006-02-15 05:05:03'),
 (108,920,'2006-02-15 05:05:03'),
 (108,958,'2006-02-15 05:05:03'),
 (108,966,'2006-02-15 05:05:03'),
 (109,12,'2006-02-15 05:05:03'),
 (109,48,'2006-02-15 05:05:03'),
 (109,77,'2006-02-15 05:05:03'),
 (109,157,'2006-02-15 05:05:03'),
 (109,174,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (109,190,'2006-02-15 05:05:03'),
 (109,243,'2006-02-15 05:05:03'),
 (109,281,'2006-02-15 05:05:03'),
 (109,393,'2006-02-15 05:05:03'),
 (109,463,'2006-02-15 05:05:03'),
 (109,622,'2006-02-15 05:05:03'),
 (109,657,'2006-02-15 05:05:03'),
 (109,694,'2006-02-15 05:05:03'),
 (109,700,'2006-02-15 05:05:03'),
 (109,732,'2006-02-15 05:05:03'),
 (109,753,'2006-02-15 05:05:03'),
 (109,785,'2006-02-15 05:05:03'),
 (109,786,'2006-02-15 05:05:03'),
 (109,863,'2006-02-15 05:05:03'),
 (109,885,'2006-02-15 05:05:03'),
 (109,955,'2006-02-15 05:05:03'),
 (109,967,'2006-02-15 05:05:03'),
 (110,8,'2006-02-15 05:05:03'),
 (110,27,'2006-02-15 05:05:03'),
 (110,62,'2006-02-15 05:05:03'),
 (110,120,'2006-02-15 05:05:03'),
 (110,126,'2006-02-15 05:05:03'),
 (110,156,'2006-02-15 05:05:03'),
 (110,292,'2006-02-15 05:05:03'),
 (110,343,'2006-02-15 05:05:03'),
 (110,360,'2006-02-15 05:05:03'),
 (110,369,'2006-02-15 05:05:03'),
 (110,435,'2006-02-15 05:05:03'),
 (110,513,'2006-02-15 05:05:03'),
 (110,525,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (110,539,'2006-02-15 05:05:03'),
 (110,545,'2006-02-15 05:05:03'),
 (110,625,'2006-02-15 05:05:03'),
 (110,650,'2006-02-15 05:05:03'),
 (110,801,'2006-02-15 05:05:03'),
 (110,912,'2006-02-15 05:05:03'),
 (110,961,'2006-02-15 05:05:03'),
 (110,987,'2006-02-15 05:05:03'),
 (111,61,'2006-02-15 05:05:03'),
 (111,78,'2006-02-15 05:05:03'),
 (111,98,'2006-02-15 05:05:03'),
 (111,162,'2006-02-15 05:05:03'),
 (111,179,'2006-02-15 05:05:03'),
 (111,194,'2006-02-15 05:05:03'),
 (111,325,'2006-02-15 05:05:03'),
 (111,359,'2006-02-15 05:05:03'),
 (111,382,'2006-02-15 05:05:03'),
 (111,403,'2006-02-15 05:05:03'),
 (111,407,'2006-02-15 05:05:03'),
 (111,414,'2006-02-15 05:05:03'),
 (111,474,'2006-02-15 05:05:03'),
 (111,489,'2006-02-15 05:05:03'),
 (111,508,'2006-02-15 05:05:03'),
 (111,555,'2006-02-15 05:05:03'),
 (111,603,'2006-02-15 05:05:03'),
 (111,608,'2006-02-15 05:05:03'),
 (111,643,'2006-02-15 05:05:03'),
 (111,669,'2006-02-15 05:05:03'),
 (111,679,'2006-02-15 05:05:03'),
 (111,680,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (111,699,'2006-02-15 05:05:03'),
 (111,731,'2006-02-15 05:05:03'),
 (111,732,'2006-02-15 05:05:03'),
 (111,737,'2006-02-15 05:05:03'),
 (111,744,'2006-02-15 05:05:03'),
 (111,777,'2006-02-15 05:05:03'),
 (111,847,'2006-02-15 05:05:03'),
 (111,894,'2006-02-15 05:05:03'),
 (111,919,'2006-02-15 05:05:03'),
 (111,962,'2006-02-15 05:05:03'),
 (111,973,'2006-02-15 05:05:03'),
 (112,34,'2006-02-15 05:05:03'),
 (112,37,'2006-02-15 05:05:03'),
 (112,151,'2006-02-15 05:05:03'),
 (112,173,'2006-02-15 05:05:03'),
 (112,188,'2006-02-15 05:05:03'),
 (112,231,'2006-02-15 05:05:03'),
 (112,312,'2006-02-15 05:05:03'),
 (112,322,'2006-02-15 05:05:03'),
 (112,443,'2006-02-15 05:05:03'),
 (112,450,'2006-02-15 05:05:03'),
 (112,565,'2006-02-15 05:05:03'),
 (112,603,'2006-02-15 05:05:03'),
 (112,606,'2006-02-15 05:05:03'),
 (112,654,'2006-02-15 05:05:03'),
 (112,666,'2006-02-15 05:05:03'),
 (112,700,'2006-02-15 05:05:03'),
 (112,728,'2006-02-15 05:05:03'),
 (112,772,'2006-02-15 05:05:03'),
 (112,796,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (112,817,'2006-02-15 05:05:03'),
 (112,829,'2006-02-15 05:05:03'),
 (112,856,'2006-02-15 05:05:03'),
 (112,865,'2006-02-15 05:05:03'),
 (112,869,'2006-02-15 05:05:03'),
 (112,988,'2006-02-15 05:05:03'),
 (113,35,'2006-02-15 05:05:03'),
 (113,84,'2006-02-15 05:05:03'),
 (113,116,'2006-02-15 05:05:03'),
 (113,181,'2006-02-15 05:05:03'),
 (113,218,'2006-02-15 05:05:03'),
 (113,249,'2006-02-15 05:05:03'),
 (113,258,'2006-02-15 05:05:03'),
 (113,292,'2006-02-15 05:05:03'),
 (113,322,'2006-02-15 05:05:03'),
 (113,353,'2006-02-15 05:05:03'),
 (113,403,'2006-02-15 05:05:03'),
 (113,525,'2006-02-15 05:05:03'),
 (113,642,'2006-02-15 05:05:03'),
 (113,656,'2006-02-15 05:05:03'),
 (113,674,'2006-02-15 05:05:03'),
 (113,680,'2006-02-15 05:05:03'),
 (113,700,'2006-02-15 05:05:03'),
 (113,719,'2006-02-15 05:05:03'),
 (113,723,'2006-02-15 05:05:03'),
 (113,726,'2006-02-15 05:05:03'),
 (113,732,'2006-02-15 05:05:03'),
 (113,748,'2006-02-15 05:05:03'),
 (113,838,'2006-02-15 05:05:03'),
 (113,890,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (113,921,'2006-02-15 05:05:03'),
 (113,969,'2006-02-15 05:05:03'),
 (113,981,'2006-02-15 05:05:03'),
 (114,13,'2006-02-15 05:05:03'),
 (114,68,'2006-02-15 05:05:03'),
 (114,90,'2006-02-15 05:05:03'),
 (114,162,'2006-02-15 05:05:03'),
 (114,188,'2006-02-15 05:05:03'),
 (114,194,'2006-02-15 05:05:03'),
 (114,210,'2006-02-15 05:05:03'),
 (114,237,'2006-02-15 05:05:03'),
 (114,254,'2006-02-15 05:05:03'),
 (114,305,'2006-02-15 05:05:03'),
 (114,339,'2006-02-15 05:05:03'),
 (114,420,'2006-02-15 05:05:03'),
 (114,425,'2006-02-15 05:05:03'),
 (114,452,'2006-02-15 05:05:03'),
 (114,538,'2006-02-15 05:05:03'),
 (114,619,'2006-02-15 05:05:03'),
 (114,757,'2006-02-15 05:05:03'),
 (114,807,'2006-02-15 05:05:03'),
 (114,827,'2006-02-15 05:05:03'),
 (114,841,'2006-02-15 05:05:03'),
 (114,861,'2006-02-15 05:05:03'),
 (114,866,'2006-02-15 05:05:03'),
 (114,913,'2006-02-15 05:05:03'),
 (114,961,'2006-02-15 05:05:03'),
 (114,993,'2006-02-15 05:05:03'),
 (115,49,'2006-02-15 05:05:03'),
 (115,52,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (115,245,'2006-02-15 05:05:03'),
 (115,246,'2006-02-15 05:05:03'),
 (115,277,'2006-02-15 05:05:03'),
 (115,302,'2006-02-15 05:05:03'),
 (115,379,'2006-02-15 05:05:03'),
 (115,383,'2006-02-15 05:05:03'),
 (115,391,'2006-02-15 05:05:03'),
 (115,428,'2006-02-15 05:05:03'),
 (115,506,'2006-02-15 05:05:03'),
 (115,531,'2006-02-15 05:05:03'),
 (115,607,'2006-02-15 05:05:03'),
 (115,615,'2006-02-15 05:05:03'),
 (115,661,'2006-02-15 05:05:03'),
 (115,671,'2006-02-15 05:05:03'),
 (115,686,'2006-02-15 05:05:03'),
 (115,703,'2006-02-15 05:05:03'),
 (115,714,'2006-02-15 05:05:03'),
 (115,740,'2006-02-15 05:05:03'),
 (115,754,'2006-02-15 05:05:03'),
 (115,846,'2006-02-15 05:05:03'),
 (115,887,'2006-02-15 05:05:03'),
 (115,952,'2006-02-15 05:05:03'),
 (115,955,'2006-02-15 05:05:03'),
 (115,966,'2006-02-15 05:05:03'),
 (115,985,'2006-02-15 05:05:03'),
 (115,994,'2006-02-15 05:05:03'),
 (116,36,'2006-02-15 05:05:03'),
 (116,48,'2006-02-15 05:05:03'),
 (116,88,'2006-02-15 05:05:03'),
 (116,90,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (116,105,'2006-02-15 05:05:03'),
 (116,128,'2006-02-15 05:05:03'),
 (116,336,'2006-02-15 05:05:03'),
 (116,338,'2006-02-15 05:05:03'),
 (116,384,'2006-02-15 05:05:03'),
 (116,412,'2006-02-15 05:05:03'),
 (116,420,'2006-02-15 05:05:03'),
 (116,451,'2006-02-15 05:05:03'),
 (116,481,'2006-02-15 05:05:03'),
 (116,492,'2006-02-15 05:05:03'),
 (116,584,'2006-02-15 05:05:03'),
 (116,606,'2006-02-15 05:05:03'),
 (116,622,'2006-02-15 05:05:03'),
 (116,647,'2006-02-15 05:05:03'),
 (116,653,'2006-02-15 05:05:03'),
 (116,742,'2006-02-15 05:05:03'),
 (116,784,'2006-02-15 05:05:03'),
 (116,844,'2006-02-15 05:05:03'),
 (116,939,'2006-02-15 05:05:03'),
 (116,956,'2006-02-15 05:05:03'),
 (117,10,'2006-02-15 05:05:03'),
 (117,15,'2006-02-15 05:05:03'),
 (117,42,'2006-02-15 05:05:03'),
 (117,167,'2006-02-15 05:05:03'),
 (117,178,'2006-02-15 05:05:03'),
 (117,190,'2006-02-15 05:05:03'),
 (117,197,'2006-02-15 05:05:03'),
 (117,224,'2006-02-15 05:05:03'),
 (117,246,'2006-02-15 05:05:03'),
 (117,273,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (117,298,'2006-02-15 05:05:03'),
 (117,316,'2006-02-15 05:05:03'),
 (117,337,'2006-02-15 05:05:03'),
 (117,395,'2006-02-15 05:05:03'),
 (117,423,'2006-02-15 05:05:03'),
 (117,432,'2006-02-15 05:05:03'),
 (117,459,'2006-02-15 05:05:03'),
 (117,468,'2006-02-15 05:05:03'),
 (117,550,'2006-02-15 05:05:03'),
 (117,578,'2006-02-15 05:05:03'),
 (117,707,'2006-02-15 05:05:03'),
 (117,710,'2006-02-15 05:05:03'),
 (117,738,'2006-02-15 05:05:03'),
 (117,739,'2006-02-15 05:05:03'),
 (117,778,'2006-02-15 05:05:03'),
 (117,783,'2006-02-15 05:05:03'),
 (117,785,'2006-02-15 05:05:03'),
 (117,797,'2006-02-15 05:05:03'),
 (117,812,'2006-02-15 05:05:03'),
 (117,831,'2006-02-15 05:05:03'),
 (117,864,'2006-02-15 05:05:03'),
 (117,887,'2006-02-15 05:05:03'),
 (117,926,'2006-02-15 05:05:03'),
 (118,35,'2006-02-15 05:05:03'),
 (118,39,'2006-02-15 05:05:03'),
 (118,41,'2006-02-15 05:05:03'),
 (118,49,'2006-02-15 05:05:03'),
 (118,55,'2006-02-15 05:05:03'),
 (118,136,'2006-02-15 05:05:03'),
 (118,141,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (118,151,'2006-02-15 05:05:03'),
 (118,311,'2006-02-15 05:05:03'),
 (118,384,'2006-02-15 05:05:03'),
 (118,399,'2006-02-15 05:05:03'),
 (118,499,'2006-02-15 05:05:03'),
 (118,517,'2006-02-15 05:05:03'),
 (118,553,'2006-02-15 05:05:03'),
 (118,558,'2006-02-15 05:05:03'),
 (118,572,'2006-02-15 05:05:03'),
 (118,641,'2006-02-15 05:05:03'),
 (118,656,'2006-02-15 05:05:03'),
 (118,695,'2006-02-15 05:05:03'),
 (118,735,'2006-02-15 05:05:03'),
 (118,788,'2006-02-15 05:05:03'),
 (118,852,'2006-02-15 05:05:03'),
 (118,938,'2006-02-15 05:05:03'),
 (118,957,'2006-02-15 05:05:03'),
 (118,969,'2006-02-15 05:05:03'),
 (119,21,'2006-02-15 05:05:03'),
 (119,49,'2006-02-15 05:05:03'),
 (119,64,'2006-02-15 05:05:03'),
 (119,87,'2006-02-15 05:05:03'),
 (119,143,'2006-02-15 05:05:03'),
 (119,171,'2006-02-15 05:05:03'),
 (119,172,'2006-02-15 05:05:03'),
 (119,173,'2006-02-15 05:05:03'),
 (119,381,'2006-02-15 05:05:03'),
 (119,394,'2006-02-15 05:05:03'),
 (119,412,'2006-02-15 05:05:03'),
 (119,418,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (119,454,'2006-02-15 05:05:03'),
 (119,509,'2006-02-15 05:05:03'),
 (119,521,'2006-02-15 05:05:03'),
 (119,567,'2006-02-15 05:05:03'),
 (119,570,'2006-02-15 05:05:03'),
 (119,592,'2006-02-15 05:05:03'),
 (119,614,'2006-02-15 05:05:03'),
 (119,636,'2006-02-15 05:05:03'),
 (119,649,'2006-02-15 05:05:03'),
 (119,693,'2006-02-15 05:05:03'),
 (119,738,'2006-02-15 05:05:03'),
 (119,751,'2006-02-15 05:05:03'),
 (119,782,'2006-02-15 05:05:03'),
 (119,786,'2006-02-15 05:05:03'),
 (119,788,'2006-02-15 05:05:03'),
 (119,802,'2006-02-15 05:05:03'),
 (119,858,'2006-02-15 05:05:03'),
 (119,868,'2006-02-15 05:05:03'),
 (119,900,'2006-02-15 05:05:03'),
 (119,939,'2006-02-15 05:05:03'),
 (120,57,'2006-02-15 05:05:03'),
 (120,63,'2006-02-15 05:05:03'),
 (120,144,'2006-02-15 05:05:03'),
 (120,149,'2006-02-15 05:05:03'),
 (120,208,'2006-02-15 05:05:03'),
 (120,231,'2006-02-15 05:05:03'),
 (120,238,'2006-02-15 05:05:03'),
 (120,255,'2006-02-15 05:05:03'),
 (120,414,'2006-02-15 05:05:03'),
 (120,424,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (120,489,'2006-02-15 05:05:03'),
 (120,513,'2006-02-15 05:05:03'),
 (120,590,'2006-02-15 05:05:03'),
 (120,641,'2006-02-15 05:05:03'),
 (120,642,'2006-02-15 05:05:03'),
 (120,659,'2006-02-15 05:05:03'),
 (120,682,'2006-02-15 05:05:03'),
 (120,691,'2006-02-15 05:05:03'),
 (120,715,'2006-02-15 05:05:03'),
 (120,717,'2006-02-15 05:05:03'),
 (120,722,'2006-02-15 05:05:03'),
 (120,746,'2006-02-15 05:05:03'),
 (120,830,'2006-02-15 05:05:03'),
 (120,894,'2006-02-15 05:05:03'),
 (120,898,'2006-02-15 05:05:03'),
 (120,911,'2006-02-15 05:05:03'),
 (120,994,'2006-02-15 05:05:03'),
 (121,141,'2006-02-15 05:05:03'),
 (121,154,'2006-02-15 05:05:03'),
 (121,161,'2006-02-15 05:05:03'),
 (121,170,'2006-02-15 05:05:03'),
 (121,186,'2006-02-15 05:05:03'),
 (121,198,'2006-02-15 05:05:03'),
 (121,220,'2006-02-15 05:05:03'),
 (121,222,'2006-02-15 05:05:03'),
 (121,284,'2006-02-15 05:05:03'),
 (121,297,'2006-02-15 05:05:03'),
 (121,338,'2006-02-15 05:05:03'),
 (121,353,'2006-02-15 05:05:03'),
 (121,449,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (121,479,'2006-02-15 05:05:03'),
 (121,517,'2006-02-15 05:05:03'),
 (121,633,'2006-02-15 05:05:03'),
 (121,654,'2006-02-15 05:05:03'),
 (121,658,'2006-02-15 05:05:03'),
 (121,666,'2006-02-15 05:05:03'),
 (121,771,'2006-02-15 05:05:03'),
 (121,780,'2006-02-15 05:05:03'),
 (121,847,'2006-02-15 05:05:03'),
 (121,884,'2006-02-15 05:05:03'),
 (121,885,'2006-02-15 05:05:03'),
 (121,966,'2006-02-15 05:05:03'),
 (122,22,'2006-02-15 05:05:03'),
 (122,29,'2006-02-15 05:05:03'),
 (122,76,'2006-02-15 05:05:03'),
 (122,83,'2006-02-15 05:05:03'),
 (122,157,'2006-02-15 05:05:03'),
 (122,158,'2006-02-15 05:05:03'),
 (122,166,'2006-02-15 05:05:03'),
 (122,227,'2006-02-15 05:05:03'),
 (122,238,'2006-02-15 05:05:03'),
 (122,300,'2006-02-15 05:05:03'),
 (122,307,'2006-02-15 05:05:03'),
 (122,363,'2006-02-15 05:05:03'),
 (122,470,'2006-02-15 05:05:03'),
 (122,489,'2006-02-15 05:05:03'),
 (122,491,'2006-02-15 05:05:03'),
 (122,542,'2006-02-15 05:05:03'),
 (122,620,'2006-02-15 05:05:03'),
 (122,649,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (122,654,'2006-02-15 05:05:03'),
 (122,673,'2006-02-15 05:05:03'),
 (122,718,'2006-02-15 05:05:03'),
 (122,795,'2006-02-15 05:05:03'),
 (122,957,'2006-02-15 05:05:03'),
 (122,961,'2006-02-15 05:05:03'),
 (122,998,'2006-02-15 05:05:03'),
 (123,3,'2006-02-15 05:05:03'),
 (123,43,'2006-02-15 05:05:03'),
 (123,67,'2006-02-15 05:05:03'),
 (123,105,'2006-02-15 05:05:03'),
 (123,148,'2006-02-15 05:05:03'),
 (123,151,'2006-02-15 05:05:03'),
 (123,185,'2006-02-15 05:05:03'),
 (123,223,'2006-02-15 05:05:03'),
 (123,234,'2006-02-15 05:05:03'),
 (123,245,'2006-02-15 05:05:03'),
 (123,246,'2006-02-15 05:05:03'),
 (123,266,'2006-02-15 05:05:03'),
 (123,286,'2006-02-15 05:05:03'),
 (123,429,'2006-02-15 05:05:03'),
 (123,442,'2006-02-15 05:05:03'),
 (123,446,'2006-02-15 05:05:03'),
 (123,479,'2006-02-15 05:05:03'),
 (123,480,'2006-02-15 05:05:03'),
 (123,494,'2006-02-15 05:05:03'),
 (123,503,'2006-02-15 05:05:03'),
 (123,530,'2006-02-15 05:05:03'),
 (123,576,'2006-02-15 05:05:03'),
 (123,577,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (123,589,'2006-02-15 05:05:03'),
 (123,593,'2006-02-15 05:05:03'),
 (123,725,'2006-02-15 05:05:03'),
 (123,730,'2006-02-15 05:05:03'),
 (123,786,'2006-02-15 05:05:03'),
 (123,860,'2006-02-15 05:05:03'),
 (123,892,'2006-02-15 05:05:03'),
 (123,926,'2006-02-15 05:05:03'),
 (123,988,'2006-02-15 05:05:03'),
 (124,22,'2006-02-15 05:05:03'),
 (124,64,'2006-02-15 05:05:03'),
 (124,106,'2006-02-15 05:05:03'),
 (124,113,'2006-02-15 05:05:03'),
 (124,190,'2006-02-15 05:05:03'),
 (124,246,'2006-02-15 05:05:03'),
 (124,260,'2006-02-15 05:05:03'),
 (124,263,'2006-02-15 05:05:03'),
 (124,289,'2006-02-15 05:05:03'),
 (124,306,'2006-02-15 05:05:03'),
 (124,312,'2006-02-15 05:05:03'),
 (124,322,'2006-02-15 05:05:03'),
 (124,343,'2006-02-15 05:05:03'),
 (124,449,'2006-02-15 05:05:03'),
 (124,468,'2006-02-15 05:05:03'),
 (124,539,'2006-02-15 05:05:03'),
 (124,601,'2006-02-15 05:05:03'),
 (124,726,'2006-02-15 05:05:03'),
 (124,742,'2006-02-15 05:05:03'),
 (124,775,'2006-02-15 05:05:03'),
 (124,785,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (124,814,'2006-02-15 05:05:03'),
 (124,858,'2006-02-15 05:05:03'),
 (124,882,'2006-02-15 05:05:03'),
 (124,987,'2006-02-15 05:05:03'),
 (124,997,'2006-02-15 05:05:03'),
 (125,62,'2006-02-15 05:05:03'),
 (125,98,'2006-02-15 05:05:03'),
 (125,100,'2006-02-15 05:05:03'),
 (125,114,'2006-02-15 05:05:03'),
 (125,175,'2006-02-15 05:05:03'),
 (125,188,'2006-02-15 05:05:03'),
 (125,204,'2006-02-15 05:05:03'),
 (125,238,'2006-02-15 05:05:03'),
 (125,250,'2006-02-15 05:05:03'),
 (125,324,'2006-02-15 05:05:03'),
 (125,338,'2006-02-15 05:05:03'),
 (125,361,'2006-02-15 05:05:03'),
 (125,367,'2006-02-15 05:05:03'),
 (125,395,'2006-02-15 05:05:03'),
 (125,414,'2006-02-15 05:05:03'),
 (125,428,'2006-02-15 05:05:03'),
 (125,429,'2006-02-15 05:05:03'),
 (125,450,'2006-02-15 05:05:03'),
 (125,497,'2006-02-15 05:05:03'),
 (125,557,'2006-02-15 05:05:03'),
 (125,568,'2006-02-15 05:05:03'),
 (125,584,'2006-02-15 05:05:03'),
 (125,602,'2006-02-15 05:05:03'),
 (125,623,'2006-02-15 05:05:03'),
 (125,664,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (125,683,'2006-02-15 05:05:03'),
 (125,710,'2006-02-15 05:05:03'),
 (125,877,'2006-02-15 05:05:03'),
 (125,908,'2006-02-15 05:05:03'),
 (125,949,'2006-02-15 05:05:03'),
 (125,965,'2006-02-15 05:05:03'),
 (126,21,'2006-02-15 05:05:03'),
 (126,34,'2006-02-15 05:05:03'),
 (126,43,'2006-02-15 05:05:03'),
 (126,58,'2006-02-15 05:05:03'),
 (126,85,'2006-02-15 05:05:03'),
 (126,96,'2006-02-15 05:05:03'),
 (126,193,'2006-02-15 05:05:03'),
 (126,194,'2006-02-15 05:05:03'),
 (126,199,'2006-02-15 05:05:03'),
 (126,256,'2006-02-15 05:05:03'),
 (126,263,'2006-02-15 05:05:03'),
 (126,288,'2006-02-15 05:05:03'),
 (126,317,'2006-02-15 05:05:03'),
 (126,347,'2006-02-15 05:05:03'),
 (126,369,'2006-02-15 05:05:03'),
 (126,370,'2006-02-15 05:05:03'),
 (126,419,'2006-02-15 05:05:03'),
 (126,468,'2006-02-15 05:05:03'),
 (126,469,'2006-02-15 05:05:03'),
 (126,545,'2006-02-15 05:05:03'),
 (126,685,'2006-02-15 05:05:03'),
 (126,836,'2006-02-15 05:05:03'),
 (126,860,'2006-02-15 05:05:03'),
 (127,36,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (127,47,'2006-02-15 05:05:03'),
 (127,48,'2006-02-15 05:05:03'),
 (127,79,'2006-02-15 05:05:03'),
 (127,119,'2006-02-15 05:05:03'),
 (127,141,'2006-02-15 05:05:03'),
 (127,157,'2006-02-15 05:05:03'),
 (127,202,'2006-02-15 05:05:03'),
 (127,286,'2006-02-15 05:05:03'),
 (127,333,'2006-02-15 05:05:03'),
 (127,354,'2006-02-15 05:05:03'),
 (127,366,'2006-02-15 05:05:03'),
 (127,382,'2006-02-15 05:05:03'),
 (127,388,'2006-02-15 05:05:03'),
 (127,411,'2006-02-15 05:05:03'),
 (127,459,'2006-02-15 05:05:03'),
 (127,553,'2006-02-15 05:05:03'),
 (127,573,'2006-02-15 05:05:03'),
 (127,613,'2006-02-15 05:05:03'),
 (127,617,'2006-02-15 05:05:03'),
 (127,641,'2006-02-15 05:05:03'),
 (127,710,'2006-02-15 05:05:03'),
 (127,727,'2006-02-15 05:05:03'),
 (127,749,'2006-02-15 05:05:03'),
 (127,763,'2006-02-15 05:05:03'),
 (127,771,'2006-02-15 05:05:03'),
 (127,791,'2006-02-15 05:05:03'),
 (127,819,'2006-02-15 05:05:03'),
 (127,839,'2006-02-15 05:05:03'),
 (127,846,'2006-02-15 05:05:03'),
 (127,911,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (127,953,'2006-02-15 05:05:03'),
 (127,970,'2006-02-15 05:05:03'),
 (128,26,'2006-02-15 05:05:03'),
 (128,82,'2006-02-15 05:05:03'),
 (128,119,'2006-02-15 05:05:03'),
 (128,168,'2006-02-15 05:05:03'),
 (128,212,'2006-02-15 05:05:03'),
 (128,238,'2006-02-15 05:05:03'),
 (128,299,'2006-02-15 05:05:03'),
 (128,312,'2006-02-15 05:05:03'),
 (128,326,'2006-02-15 05:05:03'),
 (128,336,'2006-02-15 05:05:03'),
 (128,345,'2006-02-15 05:05:03'),
 (128,407,'2006-02-15 05:05:03'),
 (128,462,'2006-02-15 05:05:03'),
 (128,485,'2006-02-15 05:05:03'),
 (128,516,'2006-02-15 05:05:03'),
 (128,564,'2006-02-15 05:05:03'),
 (128,614,'2006-02-15 05:05:03'),
 (128,650,'2006-02-15 05:05:03'),
 (128,665,'2006-02-15 05:05:03'),
 (128,671,'2006-02-15 05:05:03'),
 (128,693,'2006-02-15 05:05:03'),
 (128,696,'2006-02-15 05:05:03'),
 (128,759,'2006-02-15 05:05:03'),
 (128,774,'2006-02-15 05:05:03'),
 (128,814,'2006-02-15 05:05:03'),
 (128,899,'2006-02-15 05:05:03'),
 (128,912,'2006-02-15 05:05:03'),
 (128,944,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (128,949,'2006-02-15 05:05:03'),
 (128,965,'2006-02-15 05:05:03'),
 (129,56,'2006-02-15 05:05:03'),
 (129,89,'2006-02-15 05:05:03'),
 (129,101,'2006-02-15 05:05:03'),
 (129,166,'2006-02-15 05:05:03'),
 (129,202,'2006-02-15 05:05:03'),
 (129,230,'2006-02-15 05:05:03'),
 (129,247,'2006-02-15 05:05:03'),
 (129,249,'2006-02-15 05:05:03'),
 (129,348,'2006-02-15 05:05:03'),
 (129,367,'2006-02-15 05:05:03'),
 (129,391,'2006-02-15 05:05:03'),
 (129,418,'2006-02-15 05:05:03'),
 (129,431,'2006-02-15 05:05:03'),
 (129,452,'2006-02-15 05:05:03'),
 (129,471,'2006-02-15 05:05:03'),
 (129,520,'2006-02-15 05:05:03'),
 (129,597,'2006-02-15 05:05:03'),
 (129,602,'2006-02-15 05:05:03'),
 (129,640,'2006-02-15 05:05:03'),
 (129,669,'2006-02-15 05:05:03'),
 (129,684,'2006-02-15 05:05:03'),
 (129,705,'2006-02-15 05:05:03'),
 (129,805,'2006-02-15 05:05:03'),
 (129,826,'2006-02-15 05:05:03'),
 (129,834,'2006-02-15 05:05:03'),
 (129,857,'2006-02-15 05:05:03'),
 (129,910,'2006-02-15 05:05:03'),
 (129,920,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (129,938,'2006-02-15 05:05:03'),
 (129,962,'2006-02-15 05:05:03'),
 (130,9,'2006-02-15 05:05:03'),
 (130,26,'2006-02-15 05:05:03'),
 (130,37,'2006-02-15 05:05:03'),
 (130,43,'2006-02-15 05:05:03'),
 (130,49,'2006-02-15 05:05:03'),
 (130,57,'2006-02-15 05:05:03'),
 (130,107,'2006-02-15 05:05:03'),
 (130,112,'2006-02-15 05:05:03'),
 (130,208,'2006-02-15 05:05:03'),
 (130,326,'2006-02-15 05:05:03'),
 (130,375,'2006-02-15 05:05:03'),
 (130,416,'2006-02-15 05:05:03'),
 (130,431,'2006-02-15 05:05:03'),
 (130,452,'2006-02-15 05:05:03'),
 (130,453,'2006-02-15 05:05:03'),
 (130,478,'2006-02-15 05:05:03'),
 (130,507,'2006-02-15 05:05:03'),
 (130,525,'2006-02-15 05:05:03'),
 (130,549,'2006-02-15 05:05:03'),
 (130,592,'2006-02-15 05:05:03'),
 (130,702,'2006-02-15 05:05:03'),
 (130,725,'2006-02-15 05:05:03'),
 (130,764,'2006-02-15 05:05:03'),
 (130,809,'2006-02-15 05:05:03'),
 (130,869,'2006-02-15 05:05:03'),
 (130,930,'2006-02-15 05:05:03'),
 (130,981,'2006-02-15 05:05:03'),
 (131,48,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (131,66,'2006-02-15 05:05:03'),
 (131,94,'2006-02-15 05:05:03'),
 (131,120,'2006-02-15 05:05:03'),
 (131,147,'2006-02-15 05:05:03'),
 (131,206,'2006-02-15 05:05:03'),
 (131,320,'2006-02-15 05:05:03'),
 (131,383,'2006-02-15 05:05:03'),
 (131,432,'2006-02-15 05:05:03'),
 (131,436,'2006-02-15 05:05:03'),
 (131,450,'2006-02-15 05:05:03'),
 (131,479,'2006-02-15 05:05:03'),
 (131,494,'2006-02-15 05:05:03'),
 (131,515,'2006-02-15 05:05:03'),
 (131,539,'2006-02-15 05:05:03'),
 (131,590,'2006-02-15 05:05:03'),
 (131,647,'2006-02-15 05:05:03'),
 (131,693,'2006-02-15 05:05:03'),
 (131,713,'2006-02-15 05:05:03'),
 (131,770,'2006-02-15 05:05:03'),
 (131,798,'2006-02-15 05:05:03'),
 (131,809,'2006-02-15 05:05:03'),
 (131,875,'2006-02-15 05:05:03'),
 (131,881,'2006-02-15 05:05:03'),
 (131,921,'2006-02-15 05:05:03'),
 (132,81,'2006-02-15 05:05:03'),
 (132,82,'2006-02-15 05:05:03'),
 (132,133,'2006-02-15 05:05:03'),
 (132,156,'2006-02-15 05:05:03'),
 (132,162,'2006-02-15 05:05:03'),
 (132,311,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (132,345,'2006-02-15 05:05:03'),
 (132,377,'2006-02-15 05:05:03'),
 (132,410,'2006-02-15 05:05:03'),
 (132,538,'2006-02-15 05:05:03'),
 (132,562,'2006-02-15 05:05:03'),
 (132,586,'2006-02-15 05:05:03'),
 (132,626,'2006-02-15 05:05:03'),
 (132,637,'2006-02-15 05:05:03'),
 (132,698,'2006-02-15 05:05:03'),
 (132,756,'2006-02-15 05:05:03'),
 (132,806,'2006-02-15 05:05:03'),
 (132,897,'2006-02-15 05:05:03'),
 (132,899,'2006-02-15 05:05:03'),
 (132,904,'2006-02-15 05:05:03'),
 (132,930,'2006-02-15 05:05:03'),
 (132,987,'2006-02-15 05:05:03'),
 (133,7,'2006-02-15 05:05:03'),
 (133,51,'2006-02-15 05:05:03'),
 (133,133,'2006-02-15 05:05:03'),
 (133,172,'2006-02-15 05:05:03'),
 (133,210,'2006-02-15 05:05:03'),
 (133,270,'2006-02-15 05:05:03'),
 (133,280,'2006-02-15 05:05:03'),
 (133,286,'2006-02-15 05:05:03'),
 (133,338,'2006-02-15 05:05:03'),
 (133,342,'2006-02-15 05:05:03'),
 (133,351,'2006-02-15 05:05:03'),
 (133,368,'2006-02-15 05:05:03'),
 (133,385,'2006-02-15 05:05:03'),
 (133,390,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (133,397,'2006-02-15 05:05:03'),
 (133,410,'2006-02-15 05:05:03'),
 (133,452,'2006-02-15 05:05:03'),
 (133,463,'2006-02-15 05:05:03'),
 (133,514,'2006-02-15 05:05:03'),
 (133,588,'2006-02-15 05:05:03'),
 (133,594,'2006-02-15 05:05:03'),
 (133,635,'2006-02-15 05:05:03'),
 (133,652,'2006-02-15 05:05:03'),
 (133,727,'2006-02-15 05:05:03'),
 (133,806,'2006-02-15 05:05:03'),
 (133,868,'2006-02-15 05:05:03'),
 (133,882,'2006-02-15 05:05:03'),
 (133,894,'2006-02-15 05:05:03'),
 (133,933,'2006-02-15 05:05:03'),
 (133,952,'2006-02-15 05:05:03'),
 (134,132,'2006-02-15 05:05:03'),
 (134,145,'2006-02-15 05:05:03'),
 (134,161,'2006-02-15 05:05:03'),
 (134,219,'2006-02-15 05:05:03'),
 (134,243,'2006-02-15 05:05:03'),
 (134,250,'2006-02-15 05:05:03'),
 (134,278,'2006-02-15 05:05:03'),
 (134,341,'2006-02-15 05:05:03'),
 (134,386,'2006-02-15 05:05:03'),
 (134,413,'2006-02-15 05:05:03'),
 (134,558,'2006-02-15 05:05:03'),
 (134,588,'2006-02-15 05:05:03'),
 (134,624,'2006-02-15 05:05:03'),
 (134,655,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (134,683,'2006-02-15 05:05:03'),
 (134,690,'2006-02-15 05:05:03'),
 (134,861,'2006-02-15 05:05:03'),
 (134,896,'2006-02-15 05:05:03'),
 (134,897,'2006-02-15 05:05:03'),
 (134,915,'2006-02-15 05:05:03'),
 (134,927,'2006-02-15 05:05:03'),
 (134,936,'2006-02-15 05:05:03'),
 (135,35,'2006-02-15 05:05:03'),
 (135,41,'2006-02-15 05:05:03'),
 (135,65,'2006-02-15 05:05:03'),
 (135,88,'2006-02-15 05:05:03'),
 (135,170,'2006-02-15 05:05:03'),
 (135,269,'2006-02-15 05:05:03'),
 (135,320,'2006-02-15 05:05:03'),
 (135,353,'2006-02-15 05:05:03'),
 (135,357,'2006-02-15 05:05:03'),
 (135,364,'2006-02-15 05:05:03'),
 (135,455,'2006-02-15 05:05:03'),
 (135,458,'2006-02-15 05:05:03'),
 (135,484,'2006-02-15 05:05:03'),
 (135,541,'2006-02-15 05:05:03'),
 (135,553,'2006-02-15 05:05:03'),
 (135,616,'2006-02-15 05:05:03'),
 (135,628,'2006-02-15 05:05:03'),
 (135,719,'2006-02-15 05:05:03'),
 (135,814,'2006-02-15 05:05:03'),
 (135,905,'2006-02-15 05:05:03'),
 (136,20,'2006-02-15 05:05:03'),
 (136,25,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (136,33,'2006-02-15 05:05:03'),
 (136,56,'2006-02-15 05:05:03'),
 (136,61,'2006-02-15 05:05:03'),
 (136,193,'2006-02-15 05:05:03'),
 (136,214,'2006-02-15 05:05:03'),
 (136,229,'2006-02-15 05:05:03'),
 (136,243,'2006-02-15 05:05:03'),
 (136,256,'2006-02-15 05:05:03'),
 (136,262,'2006-02-15 05:05:03'),
 (136,271,'2006-02-15 05:05:03'),
 (136,288,'2006-02-15 05:05:03'),
 (136,300,'2006-02-15 05:05:03'),
 (136,364,'2006-02-15 05:05:03'),
 (136,401,'2006-02-15 05:05:03'),
 (136,414,'2006-02-15 05:05:03'),
 (136,420,'2006-02-15 05:05:03'),
 (136,474,'2006-02-15 05:05:03'),
 (136,485,'2006-02-15 05:05:03'),
 (136,542,'2006-02-15 05:05:03'),
 (136,552,'2006-02-15 05:05:03'),
 (136,620,'2006-02-15 05:05:03'),
 (136,649,'2006-02-15 05:05:03'),
 (136,686,'2006-02-15 05:05:03'),
 (136,781,'2006-02-15 05:05:03'),
 (136,806,'2006-02-15 05:05:03'),
 (136,808,'2006-02-15 05:05:03'),
 (136,818,'2006-02-15 05:05:03'),
 (136,842,'2006-02-15 05:05:03'),
 (136,933,'2006-02-15 05:05:03'),
 (136,993,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (137,6,'2006-02-15 05:05:03'),
 (137,14,'2006-02-15 05:05:03'),
 (137,56,'2006-02-15 05:05:03'),
 (137,96,'2006-02-15 05:05:03'),
 (137,160,'2006-02-15 05:05:03'),
 (137,224,'2006-02-15 05:05:03'),
 (137,249,'2006-02-15 05:05:03'),
 (137,254,'2006-02-15 05:05:03'),
 (137,263,'2006-02-15 05:05:03'),
 (137,268,'2006-02-15 05:05:03'),
 (137,304,'2006-02-15 05:05:03'),
 (137,390,'2006-02-15 05:05:03'),
 (137,410,'2006-02-15 05:05:03'),
 (137,433,'2006-02-15 05:05:03'),
 (137,446,'2006-02-15 05:05:03'),
 (137,489,'2006-02-15 05:05:03'),
 (137,530,'2006-02-15 05:05:03'),
 (137,564,'2006-02-15 05:05:03'),
 (137,603,'2006-02-15 05:05:03'),
 (137,610,'2006-02-15 05:05:03'),
 (137,688,'2006-02-15 05:05:03'),
 (137,703,'2006-02-15 05:05:03'),
 (137,745,'2006-02-15 05:05:03'),
 (137,758,'2006-02-15 05:05:03'),
 (137,832,'2006-02-15 05:05:03'),
 (137,841,'2006-02-15 05:05:03'),
 (137,917,'2006-02-15 05:05:03'),
 (138,8,'2006-02-15 05:05:03'),
 (138,52,'2006-02-15 05:05:03'),
 (138,61,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (138,125,'2006-02-15 05:05:03'),
 (138,157,'2006-02-15 05:05:03'),
 (138,214,'2006-02-15 05:05:03'),
 (138,258,'2006-02-15 05:05:03'),
 (138,376,'2006-02-15 05:05:03'),
 (138,403,'2006-02-15 05:05:03'),
 (138,446,'2006-02-15 05:05:03'),
 (138,453,'2006-02-15 05:05:03'),
 (138,508,'2006-02-15 05:05:03'),
 (138,553,'2006-02-15 05:05:03'),
 (138,561,'2006-02-15 05:05:03'),
 (138,583,'2006-02-15 05:05:03'),
 (138,627,'2006-02-15 05:05:03'),
 (138,639,'2006-02-15 05:05:03'),
 (138,695,'2006-02-15 05:05:03'),
 (138,747,'2006-02-15 05:05:03'),
 (138,879,'2006-02-15 05:05:03'),
 (138,885,'2006-02-15 05:05:03'),
 (138,923,'2006-02-15 05:05:03'),
 (138,970,'2006-02-15 05:05:03'),
 (138,989,'2006-02-15 05:05:03'),
 (139,20,'2006-02-15 05:05:03'),
 (139,35,'2006-02-15 05:05:03'),
 (139,57,'2006-02-15 05:05:03'),
 (139,74,'2006-02-15 05:05:03'),
 (139,90,'2006-02-15 05:05:03'),
 (139,107,'2006-02-15 05:05:03'),
 (139,155,'2006-02-15 05:05:03'),
 (139,170,'2006-02-15 05:05:03'),
 (139,181,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (139,200,'2006-02-15 05:05:03'),
 (139,229,'2006-02-15 05:05:03'),
 (139,233,'2006-02-15 05:05:03'),
 (139,261,'2006-02-15 05:05:03'),
 (139,262,'2006-02-15 05:05:03'),
 (139,266,'2006-02-15 05:05:03'),
 (139,282,'2006-02-15 05:05:03'),
 (139,284,'2006-02-15 05:05:03'),
 (139,373,'2006-02-15 05:05:03'),
 (139,447,'2006-02-15 05:05:03'),
 (139,489,'2006-02-15 05:05:03'),
 (139,529,'2006-02-15 05:05:03'),
 (139,540,'2006-02-15 05:05:03'),
 (139,570,'2006-02-15 05:05:03'),
 (139,602,'2006-02-15 05:05:03'),
 (139,605,'2006-02-15 05:05:03'),
 (139,636,'2006-02-15 05:05:03'),
 (139,691,'2006-02-15 05:05:03'),
 (139,706,'2006-02-15 05:05:03'),
 (139,719,'2006-02-15 05:05:03'),
 (139,744,'2006-02-15 05:05:03'),
 (139,746,'2006-02-15 05:05:03'),
 (139,862,'2006-02-15 05:05:03'),
 (139,892,'2006-02-15 05:05:03'),
 (140,27,'2006-02-15 05:05:03'),
 (140,77,'2006-02-15 05:05:03'),
 (140,112,'2006-02-15 05:05:03'),
 (140,135,'2006-02-15 05:05:03'),
 (140,185,'2006-02-15 05:05:03'),
 (140,258,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (140,370,'2006-02-15 05:05:03'),
 (140,373,'2006-02-15 05:05:03'),
 (140,498,'2006-02-15 05:05:03'),
 (140,509,'2006-02-15 05:05:03'),
 (140,576,'2006-02-15 05:05:03'),
 (140,587,'2006-02-15 05:05:03'),
 (140,599,'2006-02-15 05:05:03'),
 (140,608,'2006-02-15 05:05:03'),
 (140,647,'2006-02-15 05:05:03'),
 (140,665,'2006-02-15 05:05:03'),
 (140,670,'2006-02-15 05:05:03'),
 (140,693,'2006-02-15 05:05:03'),
 (140,702,'2006-02-15 05:05:03'),
 (140,729,'2006-02-15 05:05:03'),
 (140,730,'2006-02-15 05:05:03'),
 (140,731,'2006-02-15 05:05:03'),
 (140,736,'2006-02-15 05:05:03'),
 (140,742,'2006-02-15 05:05:03'),
 (140,778,'2006-02-15 05:05:03'),
 (140,820,'2006-02-15 05:05:03'),
 (140,830,'2006-02-15 05:05:03'),
 (140,835,'2006-02-15 05:05:03'),
 (140,857,'2006-02-15 05:05:03'),
 (140,923,'2006-02-15 05:05:03'),
 (140,934,'2006-02-15 05:05:03'),
 (140,999,'2006-02-15 05:05:03'),
 (141,43,'2006-02-15 05:05:03'),
 (141,67,'2006-02-15 05:05:03'),
 (141,188,'2006-02-15 05:05:03'),
 (141,191,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (141,207,'2006-02-15 05:05:03'),
 (141,223,'2006-02-15 05:05:03'),
 (141,341,'2006-02-15 05:05:03'),
 (141,358,'2006-02-15 05:05:03'),
 (141,380,'2006-02-15 05:05:03'),
 (141,395,'2006-02-15 05:05:03'),
 (141,467,'2006-02-15 05:05:03'),
 (141,491,'2006-02-15 05:05:03'),
 (141,589,'2006-02-15 05:05:03'),
 (141,607,'2006-02-15 05:05:03'),
 (141,673,'2006-02-15 05:05:03'),
 (141,740,'2006-02-15 05:05:03'),
 (141,752,'2006-02-15 05:05:03'),
 (141,768,'2006-02-15 05:05:03'),
 (141,772,'2006-02-15 05:05:03'),
 (141,787,'2006-02-15 05:05:03'),
 (141,821,'2006-02-15 05:05:03'),
 (141,829,'2006-02-15 05:05:03'),
 (141,840,'2006-02-15 05:05:03'),
 (141,849,'2006-02-15 05:05:03'),
 (141,862,'2006-02-15 05:05:03'),
 (141,863,'2006-02-15 05:05:03'),
 (141,909,'2006-02-15 05:05:03'),
 (141,992,'2006-02-15 05:05:03'),
 (142,10,'2006-02-15 05:05:03'),
 (142,18,'2006-02-15 05:05:03'),
 (142,107,'2006-02-15 05:05:03'),
 (142,139,'2006-02-15 05:05:03'),
 (142,186,'2006-02-15 05:05:03'),
 (142,199,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (142,248,'2006-02-15 05:05:03'),
 (142,328,'2006-02-15 05:05:03'),
 (142,350,'2006-02-15 05:05:03'),
 (142,371,'2006-02-15 05:05:03'),
 (142,470,'2006-02-15 05:05:03'),
 (142,481,'2006-02-15 05:05:03'),
 (142,494,'2006-02-15 05:05:03'),
 (142,501,'2006-02-15 05:05:03'),
 (142,504,'2006-02-15 05:05:03'),
 (142,540,'2006-02-15 05:05:03'),
 (142,554,'2006-02-15 05:05:03'),
 (142,575,'2006-02-15 05:05:03'),
 (142,608,'2006-02-15 05:05:03'),
 (142,710,'2006-02-15 05:05:03'),
 (142,712,'2006-02-15 05:05:03'),
 (142,735,'2006-02-15 05:05:03'),
 (142,759,'2006-02-15 05:05:03'),
 (142,794,'2006-02-15 05:05:03'),
 (142,842,'2006-02-15 05:05:03'),
 (142,859,'2006-02-15 05:05:03'),
 (142,863,'2006-02-15 05:05:03'),
 (142,875,'2006-02-15 05:05:03'),
 (142,906,'2006-02-15 05:05:03'),
 (142,914,'2006-02-15 05:05:03'),
 (142,999,'2006-02-15 05:05:03'),
 (143,47,'2006-02-15 05:05:03'),
 (143,79,'2006-02-15 05:05:03'),
 (143,141,'2006-02-15 05:05:03'),
 (143,175,'2006-02-15 05:05:03'),
 (143,232,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (143,239,'2006-02-15 05:05:03'),
 (143,316,'2006-02-15 05:05:03'),
 (143,339,'2006-02-15 05:05:03'),
 (143,361,'2006-02-15 05:05:03'),
 (143,386,'2006-02-15 05:05:03'),
 (143,404,'2006-02-15 05:05:03'),
 (143,457,'2006-02-15 05:05:03'),
 (143,485,'2006-02-15 05:05:03'),
 (143,497,'2006-02-15 05:05:03'),
 (143,560,'2006-02-15 05:05:03'),
 (143,576,'2006-02-15 05:05:03'),
 (143,603,'2006-02-15 05:05:03'),
 (143,613,'2006-02-15 05:05:03'),
 (143,659,'2006-02-15 05:05:03'),
 (143,660,'2006-02-15 05:05:03'),
 (143,680,'2006-02-15 05:05:03'),
 (143,687,'2006-02-15 05:05:03'),
 (143,690,'2006-02-15 05:05:03'),
 (143,706,'2006-02-15 05:05:03'),
 (143,792,'2006-02-15 05:05:03'),
 (143,821,'2006-02-15 05:05:03'),
 (143,830,'2006-02-15 05:05:03'),
 (143,872,'2006-02-15 05:05:03'),
 (143,878,'2006-02-15 05:05:03'),
 (143,906,'2006-02-15 05:05:03'),
 (143,958,'2006-02-15 05:05:03'),
 (144,18,'2006-02-15 05:05:03'),
 (144,67,'2006-02-15 05:05:03'),
 (144,79,'2006-02-15 05:05:03'),
 (144,90,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (144,99,'2006-02-15 05:05:03'),
 (144,105,'2006-02-15 05:05:03'),
 (144,123,'2006-02-15 05:05:03'),
 (144,125,'2006-02-15 05:05:03'),
 (144,127,'2006-02-15 05:05:03'),
 (144,130,'2006-02-15 05:05:03'),
 (144,135,'2006-02-15 05:05:03'),
 (144,164,'2006-02-15 05:05:03'),
 (144,184,'2006-02-15 05:05:03'),
 (144,216,'2006-02-15 05:05:03'),
 (144,228,'2006-02-15 05:05:03'),
 (144,260,'2006-02-15 05:05:03'),
 (144,272,'2006-02-15 05:05:03'),
 (144,291,'2006-02-15 05:05:03'),
 (144,293,'2006-02-15 05:05:03'),
 (144,312,'2006-02-15 05:05:03'),
 (144,393,'2006-02-15 05:05:03'),
 (144,396,'2006-02-15 05:05:03'),
 (144,473,'2006-02-15 05:05:03'),
 (144,504,'2006-02-15 05:05:03'),
 (144,540,'2006-02-15 05:05:03'),
 (144,599,'2006-02-15 05:05:03'),
 (144,668,'2006-02-15 05:05:03'),
 (144,702,'2006-02-15 05:05:03'),
 (144,753,'2006-02-15 05:05:03'),
 (144,762,'2006-02-15 05:05:03'),
 (144,776,'2006-02-15 05:05:03'),
 (144,785,'2006-02-15 05:05:03'),
 (144,845,'2006-02-15 05:05:03'),
 (144,894,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (144,953,'2006-02-15 05:05:03'),
 (145,39,'2006-02-15 05:05:03'),
 (145,109,'2006-02-15 05:05:03'),
 (145,120,'2006-02-15 05:05:03'),
 (145,154,'2006-02-15 05:05:03'),
 (145,155,'2006-02-15 05:05:03'),
 (145,243,'2006-02-15 05:05:03'),
 (145,293,'2006-02-15 05:05:03'),
 (145,402,'2006-02-15 05:05:03'),
 (145,409,'2006-02-15 05:05:03'),
 (145,457,'2006-02-15 05:05:03'),
 (145,475,'2006-02-15 05:05:03'),
 (145,487,'2006-02-15 05:05:03'),
 (145,494,'2006-02-15 05:05:03'),
 (145,527,'2006-02-15 05:05:03'),
 (145,592,'2006-02-15 05:05:03'),
 (145,625,'2006-02-15 05:05:03'),
 (145,629,'2006-02-15 05:05:03'),
 (145,641,'2006-02-15 05:05:03'),
 (145,661,'2006-02-15 05:05:03'),
 (145,664,'2006-02-15 05:05:03'),
 (145,692,'2006-02-15 05:05:03'),
 (145,713,'2006-02-15 05:05:03'),
 (145,726,'2006-02-15 05:05:03'),
 (145,748,'2006-02-15 05:05:03'),
 (145,822,'2006-02-15 05:05:03'),
 (145,893,'2006-02-15 05:05:03'),
 (145,923,'2006-02-15 05:05:03'),
 (145,953,'2006-02-15 05:05:03'),
 (146,12,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (146,16,'2006-02-15 05:05:03'),
 (146,33,'2006-02-15 05:05:03'),
 (146,117,'2006-02-15 05:05:03'),
 (146,177,'2006-02-15 05:05:03'),
 (146,191,'2006-02-15 05:05:03'),
 (146,197,'2006-02-15 05:05:03'),
 (146,207,'2006-02-15 05:05:03'),
 (146,218,'2006-02-15 05:05:03'),
 (146,278,'2006-02-15 05:05:03'),
 (146,296,'2006-02-15 05:05:03'),
 (146,314,'2006-02-15 05:05:03'),
 (146,320,'2006-02-15 05:05:03'),
 (146,372,'2006-02-15 05:05:03'),
 (146,384,'2006-02-15 05:05:03'),
 (146,402,'2006-02-15 05:05:03'),
 (146,410,'2006-02-15 05:05:03'),
 (146,427,'2006-02-15 05:05:03'),
 (146,429,'2006-02-15 05:05:03'),
 (146,512,'2006-02-15 05:05:03'),
 (146,514,'2006-02-15 05:05:03'),
 (146,571,'2006-02-15 05:05:03'),
 (146,591,'2006-02-15 05:05:03'),
 (146,720,'2006-02-15 05:05:03'),
 (146,731,'2006-02-15 05:05:03'),
 (146,734,'2006-02-15 05:05:03'),
 (146,871,'2006-02-15 05:05:03'),
 (146,909,'2006-02-15 05:05:03'),
 (146,922,'2006-02-15 05:05:03'),
 (146,945,'2006-02-15 05:05:03'),
 (146,955,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (146,966,'2006-02-15 05:05:03'),
 (146,969,'2006-02-15 05:05:03'),
 (147,4,'2006-02-15 05:05:03'),
 (147,85,'2006-02-15 05:05:03'),
 (147,131,'2006-02-15 05:05:03'),
 (147,139,'2006-02-15 05:05:03'),
 (147,145,'2006-02-15 05:05:03'),
 (147,178,'2006-02-15 05:05:03'),
 (147,251,'2006-02-15 05:05:03'),
 (147,254,'2006-02-15 05:05:03'),
 (147,295,'2006-02-15 05:05:03'),
 (147,298,'2006-02-15 05:05:03'),
 (147,305,'2006-02-15 05:05:03'),
 (147,310,'2006-02-15 05:05:03'),
 (147,318,'2006-02-15 05:05:03'),
 (147,333,'2006-02-15 05:05:03'),
 (147,341,'2006-02-15 05:05:03'),
 (147,351,'2006-02-15 05:05:03'),
 (147,394,'2006-02-15 05:05:03'),
 (147,402,'2006-02-15 05:05:03'),
 (147,405,'2006-02-15 05:05:03'),
 (147,410,'2006-02-15 05:05:03'),
 (147,431,'2006-02-15 05:05:03'),
 (147,443,'2006-02-15 05:05:03'),
 (147,508,'2006-02-15 05:05:03'),
 (147,554,'2006-02-15 05:05:03'),
 (147,563,'2006-02-15 05:05:03'),
 (147,649,'2006-02-15 05:05:03'),
 (147,688,'2006-02-15 05:05:03'),
 (147,708,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (147,864,'2006-02-15 05:05:03'),
 (147,957,'2006-02-15 05:05:03'),
 (147,987,'2006-02-15 05:05:03'),
 (148,27,'2006-02-15 05:05:03'),
 (148,57,'2006-02-15 05:05:03'),
 (148,133,'2006-02-15 05:05:03'),
 (148,149,'2006-02-15 05:05:03'),
 (148,226,'2006-02-15 05:05:03'),
 (148,342,'2006-02-15 05:05:03'),
 (148,368,'2006-02-15 05:05:03'),
 (148,422,'2006-02-15 05:05:03'),
 (148,468,'2006-02-15 05:05:03'),
 (148,633,'2006-02-15 05:05:03'),
 (148,718,'2006-02-15 05:05:03'),
 (148,768,'2006-02-15 05:05:03'),
 (148,772,'2006-02-15 05:05:03'),
 (148,792,'2006-02-15 05:05:03'),
 (149,53,'2006-02-15 05:05:03'),
 (149,72,'2006-02-15 05:05:03'),
 (149,95,'2006-02-15 05:05:03'),
 (149,118,'2006-02-15 05:05:03'),
 (149,139,'2006-02-15 05:05:03'),
 (149,146,'2006-02-15 05:05:03'),
 (149,153,'2006-02-15 05:05:03'),
 (149,159,'2006-02-15 05:05:03'),
 (149,169,'2006-02-15 05:05:03'),
 (149,178,'2006-02-15 05:05:03'),
 (149,188,'2006-02-15 05:05:03'),
 (149,193,'2006-02-15 05:05:03'),
 (149,339,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (149,354,'2006-02-15 05:05:03'),
 (149,362,'2006-02-15 05:05:03'),
 (149,365,'2006-02-15 05:05:03'),
 (149,458,'2006-02-15 05:05:03'),
 (149,631,'2006-02-15 05:05:03'),
 (149,670,'2006-02-15 05:05:03'),
 (149,685,'2006-02-15 05:05:03'),
 (149,761,'2006-02-15 05:05:03'),
 (149,782,'2006-02-15 05:05:03'),
 (149,810,'2006-02-15 05:05:03'),
 (149,811,'2006-02-15 05:05:03'),
 (149,899,'2006-02-15 05:05:03'),
 (149,905,'2006-02-15 05:05:03'),
 (149,913,'2006-02-15 05:05:03'),
 (149,921,'2006-02-15 05:05:03'),
 (149,947,'2006-02-15 05:05:03'),
 (149,949,'2006-02-15 05:05:03'),
 (149,992,'2006-02-15 05:05:03'),
 (150,23,'2006-02-15 05:05:03'),
 (150,63,'2006-02-15 05:05:03'),
 (150,75,'2006-02-15 05:05:03'),
 (150,94,'2006-02-15 05:05:03'),
 (150,105,'2006-02-15 05:05:03'),
 (150,168,'2006-02-15 05:05:03'),
 (150,190,'2006-02-15 05:05:03'),
 (150,206,'2006-02-15 05:05:03'),
 (150,233,'2006-02-15 05:05:03'),
 (150,270,'2006-02-15 05:05:03'),
 (150,285,'2006-02-15 05:05:03'),
 (150,306,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (150,386,'2006-02-15 05:05:03'),
 (150,433,'2006-02-15 05:05:03'),
 (150,446,'2006-02-15 05:05:03'),
 (150,447,'2006-02-15 05:05:03'),
 (150,468,'2006-02-15 05:05:03'),
 (150,508,'2006-02-15 05:05:03'),
 (150,542,'2006-02-15 05:05:03'),
 (150,551,'2006-02-15 05:05:03'),
 (150,629,'2006-02-15 05:05:03'),
 (150,647,'2006-02-15 05:05:03'),
 (150,672,'2006-02-15 05:05:03'),
 (150,697,'2006-02-15 05:05:03'),
 (150,728,'2006-02-15 05:05:03'),
 (150,777,'2006-02-15 05:05:03'),
 (150,854,'2006-02-15 05:05:03'),
 (150,873,'2006-02-15 05:05:03'),
 (150,880,'2006-02-15 05:05:03'),
 (150,887,'2006-02-15 05:05:03'),
 (150,889,'2006-02-15 05:05:03'),
 (150,892,'2006-02-15 05:05:03'),
 (150,953,'2006-02-15 05:05:03'),
 (150,962,'2006-02-15 05:05:03'),
 (151,131,'2006-02-15 05:05:03'),
 (151,144,'2006-02-15 05:05:03'),
 (151,167,'2006-02-15 05:05:03'),
 (151,170,'2006-02-15 05:05:03'),
 (151,217,'2006-02-15 05:05:03'),
 (151,232,'2006-02-15 05:05:03'),
 (151,342,'2006-02-15 05:05:03'),
 (151,367,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (151,370,'2006-02-15 05:05:03'),
 (151,382,'2006-02-15 05:05:03'),
 (151,451,'2006-02-15 05:05:03'),
 (151,463,'2006-02-15 05:05:03'),
 (151,482,'2006-02-15 05:05:03'),
 (151,501,'2006-02-15 05:05:03'),
 (151,527,'2006-02-15 05:05:03'),
 (151,539,'2006-02-15 05:05:03'),
 (151,570,'2006-02-15 05:05:03'),
 (151,574,'2006-02-15 05:05:03'),
 (151,634,'2006-02-15 05:05:03'),
 (151,658,'2006-02-15 05:05:03'),
 (151,665,'2006-02-15 05:05:03'),
 (151,703,'2006-02-15 05:05:03'),
 (151,880,'2006-02-15 05:05:03'),
 (151,892,'2006-02-15 05:05:03'),
 (151,895,'2006-02-15 05:05:03'),
 (151,989,'2006-02-15 05:05:03'),
 (152,59,'2006-02-15 05:05:03'),
 (152,153,'2006-02-15 05:05:03'),
 (152,217,'2006-02-15 05:05:03'),
 (152,248,'2006-02-15 05:05:03'),
 (152,318,'2006-02-15 05:05:03'),
 (152,332,'2006-02-15 05:05:03'),
 (152,475,'2006-02-15 05:05:03'),
 (152,476,'2006-02-15 05:05:03'),
 (152,578,'2006-02-15 05:05:03'),
 (152,607,'2006-02-15 05:05:03'),
 (152,611,'2006-02-15 05:05:03'),
 (152,615,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (152,674,'2006-02-15 05:05:03'),
 (152,680,'2006-02-15 05:05:03'),
 (152,729,'2006-02-15 05:05:03'),
 (152,768,'2006-02-15 05:05:03'),
 (152,821,'2006-02-15 05:05:03'),
 (152,846,'2006-02-15 05:05:03'),
 (152,891,'2006-02-15 05:05:03'),
 (152,898,'2006-02-15 05:05:03'),
 (152,927,'2006-02-15 05:05:03'),
 (152,964,'2006-02-15 05:05:03'),
 (152,968,'2006-02-15 05:05:03'),
 (153,47,'2006-02-15 05:05:03'),
 (153,64,'2006-02-15 05:05:03'),
 (153,136,'2006-02-15 05:05:03'),
 (153,180,'2006-02-15 05:05:03'),
 (153,203,'2006-02-15 05:05:03'),
 (153,231,'2006-02-15 05:05:03'),
 (153,444,'2006-02-15 05:05:03'),
 (153,476,'2006-02-15 05:05:03'),
 (153,480,'2006-02-15 05:05:03'),
 (153,486,'2006-02-15 05:05:03'),
 (153,536,'2006-02-15 05:05:03'),
 (153,627,'2006-02-15 05:05:03'),
 (153,732,'2006-02-15 05:05:03'),
 (153,756,'2006-02-15 05:05:03'),
 (153,766,'2006-02-15 05:05:03'),
 (153,817,'2006-02-15 05:05:03'),
 (153,847,'2006-02-15 05:05:03'),
 (153,919,'2006-02-15 05:05:03'),
 (153,938,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (153,988,'2006-02-15 05:05:03'),
 (154,27,'2006-02-15 05:05:03'),
 (154,111,'2006-02-15 05:05:03'),
 (154,141,'2006-02-15 05:05:03'),
 (154,158,'2006-02-15 05:05:03'),
 (154,169,'2006-02-15 05:05:03'),
 (154,170,'2006-02-15 05:05:03'),
 (154,193,'2006-02-15 05:05:03'),
 (154,208,'2006-02-15 05:05:03'),
 (154,274,'2006-02-15 05:05:03'),
 (154,276,'2006-02-15 05:05:03'),
 (154,282,'2006-02-15 05:05:03'),
 (154,299,'2006-02-15 05:05:03'),
 (154,314,'2006-02-15 05:05:03'),
 (154,396,'2006-02-15 05:05:03'),
 (154,399,'2006-02-15 05:05:03'),
 (154,421,'2006-02-15 05:05:03'),
 (154,440,'2006-02-15 05:05:03'),
 (154,467,'2006-02-15 05:05:03'),
 (154,474,'2006-02-15 05:05:03'),
 (154,489,'2006-02-15 05:05:03'),
 (154,588,'2006-02-15 05:05:03'),
 (154,602,'2006-02-15 05:05:03'),
 (154,680,'2006-02-15 05:05:03'),
 (154,698,'2006-02-15 05:05:03'),
 (154,802,'2006-02-15 05:05:03'),
 (154,842,'2006-02-15 05:05:03'),
 (154,954,'2006-02-15 05:05:03'),
 (154,988,'2006-02-15 05:05:03'),
 (155,20,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (155,67,'2006-02-15 05:05:03'),
 (155,128,'2006-02-15 05:05:03'),
 (155,153,'2006-02-15 05:05:03'),
 (155,220,'2006-02-15 05:05:03'),
 (155,249,'2006-02-15 05:05:03'),
 (155,303,'2006-02-15 05:05:03'),
 (155,312,'2006-02-15 05:05:03'),
 (155,359,'2006-02-15 05:05:03'),
 (155,361,'2006-02-15 05:05:03'),
 (155,383,'2006-02-15 05:05:03'),
 (155,387,'2006-02-15 05:05:03'),
 (155,407,'2006-02-15 05:05:03'),
 (155,427,'2006-02-15 05:05:03'),
 (155,459,'2006-02-15 05:05:03'),
 (155,513,'2006-02-15 05:05:03'),
 (155,584,'2006-02-15 05:05:03'),
 (155,590,'2006-02-15 05:05:03'),
 (155,630,'2006-02-15 05:05:03'),
 (155,688,'2006-02-15 05:05:03'),
 (155,757,'2006-02-15 05:05:03'),
 (155,768,'2006-02-15 05:05:03'),
 (155,785,'2006-02-15 05:05:03'),
 (155,849,'2006-02-15 05:05:03'),
 (155,885,'2006-02-15 05:05:03'),
 (155,890,'2006-02-15 05:05:03'),
 (155,941,'2006-02-15 05:05:03'),
 (155,966,'2006-02-15 05:05:03'),
 (155,987,'2006-02-15 05:05:03'),
 (155,997,'2006-02-15 05:05:03'),
 (155,1000,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (156,53,'2006-02-15 05:05:03'),
 (156,155,'2006-02-15 05:05:03'),
 (156,198,'2006-02-15 05:05:03'),
 (156,244,'2006-02-15 05:05:03'),
 (156,262,'2006-02-15 05:05:03'),
 (156,263,'2006-02-15 05:05:03'),
 (156,285,'2006-02-15 05:05:03'),
 (156,297,'2006-02-15 05:05:03'),
 (156,301,'2006-02-15 05:05:03'),
 (156,349,'2006-02-15 05:05:03'),
 (156,379,'2006-02-15 05:05:03'),
 (156,448,'2006-02-15 05:05:03'),
 (156,462,'2006-02-15 05:05:03'),
 (156,467,'2006-02-15 05:05:03'),
 (156,504,'2006-02-15 05:05:03'),
 (156,518,'2006-02-15 05:05:03'),
 (156,593,'2006-02-15 05:05:03'),
 (156,646,'2006-02-15 05:05:03'),
 (156,705,'2006-02-15 05:05:03'),
 (156,754,'2006-02-15 05:05:03'),
 (156,775,'2006-02-15 05:05:03'),
 (156,844,'2006-02-15 05:05:03'),
 (157,10,'2006-02-15 05:05:03'),
 (157,24,'2006-02-15 05:05:03'),
 (157,34,'2006-02-15 05:05:03'),
 (157,122,'2006-02-15 05:05:03'),
 (157,159,'2006-02-15 05:05:03'),
 (157,183,'2006-02-15 05:05:03'),
 (157,210,'2006-02-15 05:05:03'),
 (157,217,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (157,291,'2006-02-15 05:05:03'),
 (157,303,'2006-02-15 05:05:03'),
 (157,321,'2006-02-15 05:05:03'),
 (157,326,'2006-02-15 05:05:03'),
 (157,353,'2006-02-15 05:05:03'),
 (157,400,'2006-02-15 05:05:03'),
 (157,406,'2006-02-15 05:05:03'),
 (157,431,'2006-02-15 05:05:03'),
 (157,496,'2006-02-15 05:05:03'),
 (157,535,'2006-02-15 05:05:03'),
 (157,573,'2006-02-15 05:05:03'),
 (157,574,'2006-02-15 05:05:03'),
 (157,604,'2006-02-15 05:05:03'),
 (157,616,'2006-02-15 05:05:03'),
 (157,642,'2006-02-15 05:05:03'),
 (157,661,'2006-02-15 05:05:03'),
 (157,696,'2006-02-15 05:05:03'),
 (157,713,'2006-02-15 05:05:03'),
 (157,802,'2006-02-15 05:05:03'),
 (157,835,'2006-02-15 05:05:03'),
 (157,874,'2006-02-15 05:05:03'),
 (157,913,'2006-02-15 05:05:03'),
 (157,967,'2006-02-15 05:05:03'),
 (157,973,'2006-02-15 05:05:03'),
 (158,32,'2006-02-15 05:05:03'),
 (158,47,'2006-02-15 05:05:03'),
 (158,64,'2006-02-15 05:05:03'),
 (158,66,'2006-02-15 05:05:03'),
 (158,102,'2006-02-15 05:05:03'),
 (158,121,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (158,177,'2006-02-15 05:05:03'),
 (158,178,'2006-02-15 05:05:03'),
 (158,188,'2006-02-15 05:05:03'),
 (158,215,'2006-02-15 05:05:03'),
 (158,241,'2006-02-15 05:05:03'),
 (158,293,'2006-02-15 05:05:03'),
 (158,437,'2006-02-15 05:05:03'),
 (158,473,'2006-02-15 05:05:03'),
 (158,483,'2006-02-15 05:05:03'),
 (158,532,'2006-02-15 05:05:03'),
 (158,555,'2006-02-15 05:05:03'),
 (158,581,'2006-02-15 05:05:03'),
 (158,601,'2006-02-15 05:05:03'),
 (158,616,'2006-02-15 05:05:03'),
 (158,626,'2006-02-15 05:05:03'),
 (158,637,'2006-02-15 05:05:03'),
 (158,799,'2006-02-15 05:05:03'),
 (158,812,'2006-02-15 05:05:03'),
 (158,824,'2006-02-15 05:05:03'),
 (158,830,'2006-02-15 05:05:03'),
 (158,840,'2006-02-15 05:05:03'),
 (158,869,'2006-02-15 05:05:03'),
 (158,879,'2006-02-15 05:05:03'),
 (158,880,'2006-02-15 05:05:03'),
 (158,894,'2006-02-15 05:05:03'),
 (158,896,'2006-02-15 05:05:03'),
 (158,967,'2006-02-15 05:05:03'),
 (158,968,'2006-02-15 05:05:03'),
 (158,990,'2006-02-15 05:05:03'),
 (159,20,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (159,82,'2006-02-15 05:05:03'),
 (159,127,'2006-02-15 05:05:03'),
 (159,187,'2006-02-15 05:05:03'),
 (159,206,'2006-02-15 05:05:03'),
 (159,208,'2006-02-15 05:05:03'),
 (159,223,'2006-02-15 05:05:03'),
 (159,248,'2006-02-15 05:05:03'),
 (159,342,'2006-02-15 05:05:03'),
 (159,343,'2006-02-15 05:05:03'),
 (159,344,'2006-02-15 05:05:03'),
 (159,364,'2006-02-15 05:05:03'),
 (159,418,'2006-02-15 05:05:03'),
 (159,549,'2006-02-15 05:05:03'),
 (159,561,'2006-02-15 05:05:03'),
 (159,600,'2006-02-15 05:05:03'),
 (159,674,'2006-02-15 05:05:03'),
 (159,680,'2006-02-15 05:05:03'),
 (159,784,'2006-02-15 05:05:03'),
 (159,789,'2006-02-15 05:05:03'),
 (159,800,'2006-02-15 05:05:03'),
 (159,802,'2006-02-15 05:05:03'),
 (159,818,'2006-02-15 05:05:03'),
 (159,876,'2006-02-15 05:05:03'),
 (159,907,'2006-02-15 05:05:03'),
 (159,978,'2006-02-15 05:05:03'),
 (160,2,'2006-02-15 05:05:03'),
 (160,17,'2006-02-15 05:05:03'),
 (160,43,'2006-02-15 05:05:03'),
 (160,242,'2006-02-15 05:05:03'),
 (160,267,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (160,275,'2006-02-15 05:05:03'),
 (160,368,'2006-02-15 05:05:03'),
 (160,455,'2006-02-15 05:05:03'),
 (160,469,'2006-02-15 05:05:03'),
 (160,484,'2006-02-15 05:05:03'),
 (160,579,'2006-02-15 05:05:03'),
 (160,660,'2006-02-15 05:05:03'),
 (160,755,'2006-02-15 05:05:03'),
 (160,767,'2006-02-15 05:05:03'),
 (160,769,'2006-02-15 05:05:03'),
 (160,794,'2006-02-15 05:05:03'),
 (160,826,'2006-02-15 05:05:03'),
 (160,883,'2006-02-15 05:05:03'),
 (160,950,'2006-02-15 05:05:03'),
 (160,954,'2006-02-15 05:05:03'),
 (161,43,'2006-02-15 05:05:03'),
 (161,58,'2006-02-15 05:05:03'),
 (161,89,'2006-02-15 05:05:03'),
 (161,90,'2006-02-15 05:05:03'),
 (161,120,'2006-02-15 05:05:03'),
 (161,188,'2006-02-15 05:05:03'),
 (161,247,'2006-02-15 05:05:03'),
 (161,269,'2006-02-15 05:05:03'),
 (161,281,'2006-02-15 05:05:03'),
 (161,340,'2006-02-15 05:05:03'),
 (161,353,'2006-02-15 05:05:03'),
 (161,401,'2006-02-15 05:05:03'),
 (161,414,'2006-02-15 05:05:03'),
 (161,425,'2006-02-15 05:05:03'),
 (161,469,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (161,526,'2006-02-15 05:05:03'),
 (161,588,'2006-02-15 05:05:03'),
 (161,644,'2006-02-15 05:05:03'),
 (161,653,'2006-02-15 05:05:03'),
 (161,655,'2006-02-15 05:05:03'),
 (161,669,'2006-02-15 05:05:03'),
 (161,684,'2006-02-15 05:05:03'),
 (161,714,'2006-02-15 05:05:03'),
 (161,749,'2006-02-15 05:05:03'),
 (161,807,'2006-02-15 05:05:03'),
 (161,825,'2006-02-15 05:05:03'),
 (161,850,'2006-02-15 05:05:03'),
 (161,880,'2006-02-15 05:05:03'),
 (161,920,'2006-02-15 05:05:03'),
 (161,921,'2006-02-15 05:05:03'),
 (161,924,'2006-02-15 05:05:03'),
 (161,927,'2006-02-15 05:05:03'),
 (162,1,'2006-02-15 05:05:03'),
 (162,4,'2006-02-15 05:05:03'),
 (162,7,'2006-02-15 05:05:03'),
 (162,18,'2006-02-15 05:05:03'),
 (162,28,'2006-02-15 05:05:03'),
 (162,32,'2006-02-15 05:05:03'),
 (162,33,'2006-02-15 05:05:03'),
 (162,41,'2006-02-15 05:05:03'),
 (162,85,'2006-02-15 05:05:03'),
 (162,121,'2006-02-15 05:05:03'),
 (162,164,'2006-02-15 05:05:03'),
 (162,274,'2006-02-15 05:05:03'),
 (162,279,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (162,409,'2006-02-15 05:05:03'),
 (162,410,'2006-02-15 05:05:03'),
 (162,415,'2006-02-15 05:05:03'),
 (162,500,'2006-02-15 05:05:03'),
 (162,574,'2006-02-15 05:05:03'),
 (162,612,'2006-02-15 05:05:03'),
 (162,636,'2006-02-15 05:05:03'),
 (162,659,'2006-02-15 05:05:03'),
 (162,786,'2006-02-15 05:05:03'),
 (162,844,'2006-02-15 05:05:03'),
 (162,909,'2006-02-15 05:05:03'),
 (162,968,'2006-02-15 05:05:03'),
 (163,30,'2006-02-15 05:05:03'),
 (163,45,'2006-02-15 05:05:03'),
 (163,166,'2006-02-15 05:05:03'),
 (163,180,'2006-02-15 05:05:03'),
 (163,239,'2006-02-15 05:05:03'),
 (163,283,'2006-02-15 05:05:03'),
 (163,303,'2006-02-15 05:05:03'),
 (163,304,'2006-02-15 05:05:03'),
 (163,307,'2006-02-15 05:05:03'),
 (163,394,'2006-02-15 05:05:03'),
 (163,409,'2006-02-15 05:05:03'),
 (163,434,'2006-02-15 05:05:03'),
 (163,444,'2006-02-15 05:05:03'),
 (163,522,'2006-02-15 05:05:03'),
 (163,719,'2006-02-15 05:05:03'),
 (163,785,'2006-02-15 05:05:03'),
 (163,833,'2006-02-15 05:05:03'),
 (163,881,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (163,891,'2006-02-15 05:05:03'),
 (163,947,'2006-02-15 05:05:03'),
 (163,996,'2006-02-15 05:05:03'),
 (164,15,'2006-02-15 05:05:03'),
 (164,23,'2006-02-15 05:05:03'),
 (164,148,'2006-02-15 05:05:03'),
 (164,169,'2006-02-15 05:05:03'),
 (164,252,'2006-02-15 05:05:03'),
 (164,324,'2006-02-15 05:05:03'),
 (164,347,'2006-02-15 05:05:03'),
 (164,367,'2006-02-15 05:05:03'),
 (164,431,'2006-02-15 05:05:03'),
 (164,448,'2006-02-15 05:05:03'),
 (164,469,'2006-02-15 05:05:03'),
 (164,545,'2006-02-15 05:05:03'),
 (164,610,'2006-02-15 05:05:03'),
 (164,613,'2006-02-15 05:05:03'),
 (164,673,'2006-02-15 05:05:03'),
 (164,681,'2006-02-15 05:05:03'),
 (164,698,'2006-02-15 05:05:03'),
 (164,801,'2006-02-15 05:05:03'),
 (164,820,'2006-02-15 05:05:03'),
 (164,832,'2006-02-15 05:05:03'),
 (164,834,'2006-02-15 05:05:03'),
 (164,851,'2006-02-15 05:05:03'),
 (164,884,'2006-02-15 05:05:03'),
 (164,908,'2006-02-15 05:05:03'),
 (164,957,'2006-02-15 05:05:03'),
 (164,984,'2006-02-15 05:05:03'),
 (165,72,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (165,95,'2006-02-15 05:05:03'),
 (165,146,'2006-02-15 05:05:03'),
 (165,204,'2006-02-15 05:05:03'),
 (165,253,'2006-02-15 05:05:03'),
 (165,286,'2006-02-15 05:05:03'),
 (165,360,'2006-02-15 05:05:03'),
 (165,375,'2006-02-15 05:05:03'),
 (165,395,'2006-02-15 05:05:03'),
 (165,421,'2006-02-15 05:05:03'),
 (165,437,'2006-02-15 05:05:03'),
 (165,473,'2006-02-15 05:05:03'),
 (165,607,'2006-02-15 05:05:03'),
 (165,644,'2006-02-15 05:05:03'),
 (165,659,'2006-02-15 05:05:03'),
 (165,693,'2006-02-15 05:05:03'),
 (165,737,'2006-02-15 05:05:03'),
 (165,779,'2006-02-15 05:05:03'),
 (165,798,'2006-02-15 05:05:03'),
 (165,807,'2006-02-15 05:05:03'),
 (165,809,'2006-02-15 05:05:03'),
 (165,832,'2006-02-15 05:05:03'),
 (165,833,'2006-02-15 05:05:03'),
 (165,947,'2006-02-15 05:05:03'),
 (165,948,'2006-02-15 05:05:03'),
 (165,962,'2006-02-15 05:05:03'),
 (166,25,'2006-02-15 05:05:03'),
 (166,38,'2006-02-15 05:05:03'),
 (166,55,'2006-02-15 05:05:03'),
 (166,61,'2006-02-15 05:05:03'),
 (166,68,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (166,86,'2006-02-15 05:05:03'),
 (166,146,'2006-02-15 05:05:03'),
 (166,255,'2006-02-15 05:05:03'),
 (166,297,'2006-02-15 05:05:03'),
 (166,306,'2006-02-15 05:05:03'),
 (166,326,'2006-02-15 05:05:03'),
 (166,361,'2006-02-15 05:05:03'),
 (166,366,'2006-02-15 05:05:03'),
 (166,426,'2006-02-15 05:05:03'),
 (166,580,'2006-02-15 05:05:03'),
 (166,622,'2006-02-15 05:05:03'),
 (166,674,'2006-02-15 05:05:03'),
 (166,714,'2006-02-15 05:05:03'),
 (166,788,'2006-02-15 05:05:03'),
 (166,867,'2006-02-15 05:05:03'),
 (166,944,'2006-02-15 05:05:03'),
 (166,1000,'2006-02-15 05:05:03'),
 (167,17,'2006-02-15 05:05:03'),
 (167,25,'2006-02-15 05:05:03'),
 (167,63,'2006-02-15 05:05:03'),
 (167,72,'2006-02-15 05:05:03'),
 (167,107,'2006-02-15 05:05:03'),
 (167,120,'2006-02-15 05:05:03'),
 (167,191,'2006-02-15 05:05:03'),
 (167,294,'2006-02-15 05:05:03'),
 (167,319,'2006-02-15 05:05:03'),
 (167,339,'2006-02-15 05:05:03'),
 (167,341,'2006-02-15 05:05:03'),
 (167,496,'2006-02-15 05:05:03'),
 (167,554,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (167,626,'2006-02-15 05:05:03'),
 (167,628,'2006-02-15 05:05:03'),
 (167,672,'2006-02-15 05:05:03'),
 (167,692,'2006-02-15 05:05:03'),
 (167,717,'2006-02-15 05:05:03'),
 (167,734,'2006-02-15 05:05:03'),
 (167,794,'2006-02-15 05:05:03'),
 (167,800,'2006-02-15 05:05:03'),
 (167,802,'2006-02-15 05:05:03'),
 (167,856,'2006-02-15 05:05:03'),
 (167,864,'2006-02-15 05:05:03'),
 (167,882,'2006-02-15 05:05:03'),
 (167,923,'2006-02-15 05:05:03'),
 (168,32,'2006-02-15 05:05:03'),
 (168,56,'2006-02-15 05:05:03'),
 (168,92,'2006-02-15 05:05:03'),
 (168,115,'2006-02-15 05:05:03'),
 (168,188,'2006-02-15 05:05:03'),
 (168,196,'2006-02-15 05:05:03'),
 (168,208,'2006-02-15 05:05:03'),
 (168,237,'2006-02-15 05:05:03'),
 (168,241,'2006-02-15 05:05:03'),
 (168,255,'2006-02-15 05:05:03'),
 (168,305,'2006-02-15 05:05:03'),
 (168,336,'2006-02-15 05:05:03'),
 (168,387,'2006-02-15 05:05:03'),
 (168,433,'2006-02-15 05:05:03'),
 (168,438,'2006-02-15 05:05:03'),
 (168,519,'2006-02-15 05:05:03'),
 (168,602,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (168,619,'2006-02-15 05:05:03'),
 (168,626,'2006-02-15 05:05:03'),
 (168,652,'2006-02-15 05:05:03'),
 (168,678,'2006-02-15 05:05:03'),
 (168,685,'2006-02-15 05:05:03'),
 (168,804,'2006-02-15 05:05:03'),
 (168,807,'2006-02-15 05:05:03'),
 (168,826,'2006-02-15 05:05:03'),
 (168,841,'2006-02-15 05:05:03'),
 (168,886,'2006-02-15 05:05:03'),
 (168,889,'2006-02-15 05:05:03'),
 (168,892,'2006-02-15 05:05:03'),
 (168,927,'2006-02-15 05:05:03'),
 (168,959,'2006-02-15 05:05:03'),
 (169,6,'2006-02-15 05:05:03'),
 (169,78,'2006-02-15 05:05:03'),
 (169,93,'2006-02-15 05:05:03'),
 (169,246,'2006-02-15 05:05:03'),
 (169,248,'2006-02-15 05:05:03'),
 (169,289,'2006-02-15 05:05:03'),
 (169,301,'2006-02-15 05:05:03'),
 (169,326,'2006-02-15 05:05:03'),
 (169,349,'2006-02-15 05:05:03'),
 (169,372,'2006-02-15 05:05:03'),
 (169,398,'2006-02-15 05:05:03'),
 (169,434,'2006-02-15 05:05:03'),
 (169,505,'2006-02-15 05:05:03'),
 (169,564,'2006-02-15 05:05:03'),
 (169,571,'2006-02-15 05:05:03'),
 (169,634,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (169,642,'2006-02-15 05:05:03'),
 (169,673,'2006-02-15 05:05:03'),
 (169,694,'2006-02-15 05:05:03'),
 (169,727,'2006-02-15 05:05:03'),
 (169,778,'2006-02-15 05:05:03'),
 (169,815,'2006-02-15 05:05:03'),
 (169,847,'2006-02-15 05:05:03'),
 (169,849,'2006-02-15 05:05:03'),
 (169,894,'2006-02-15 05:05:03'),
 (169,897,'2006-02-15 05:05:03'),
 (169,954,'2006-02-15 05:05:03'),
 (169,992,'2006-02-15 05:05:03'),
 (169,998,'2006-02-15 05:05:03'),
 (170,7,'2006-02-15 05:05:03'),
 (170,15,'2006-02-15 05:05:03'),
 (170,27,'2006-02-15 05:05:03'),
 (170,33,'2006-02-15 05:05:03'),
 (170,102,'2006-02-15 05:05:03'),
 (170,139,'2006-02-15 05:05:03'),
 (170,180,'2006-02-15 05:05:03'),
 (170,184,'2006-02-15 05:05:03'),
 (170,212,'2006-02-15 05:05:03'),
 (170,299,'2006-02-15 05:05:03'),
 (170,322,'2006-02-15 05:05:03'),
 (170,358,'2006-02-15 05:05:03'),
 (170,416,'2006-02-15 05:05:03'),
 (170,508,'2006-02-15 05:05:03'),
 (170,537,'2006-02-15 05:05:03'),
 (170,705,'2006-02-15 05:05:03'),
 (170,758,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (170,764,'2006-02-15 05:05:03'),
 (170,868,'2006-02-15 05:05:03'),
 (170,877,'2006-02-15 05:05:03'),
 (170,886,'2006-02-15 05:05:03'),
 (170,925,'2006-02-15 05:05:03'),
 (170,993,'2006-02-15 05:05:03'),
 (170,996,'2006-02-15 05:05:03'),
 (171,49,'2006-02-15 05:05:03'),
 (171,146,'2006-02-15 05:05:03'),
 (171,166,'2006-02-15 05:05:03'),
 (171,181,'2006-02-15 05:05:03'),
 (171,219,'2006-02-15 05:05:03'),
 (171,273,'2006-02-15 05:05:03'),
 (171,296,'2006-02-15 05:05:03'),
 (171,318,'2006-02-15 05:05:03'),
 (171,342,'2006-02-15 05:05:03'),
 (171,397,'2006-02-15 05:05:03'),
 (171,447,'2006-02-15 05:05:03'),
 (171,450,'2006-02-15 05:05:03'),
 (171,466,'2006-02-15 05:05:03'),
 (171,549,'2006-02-15 05:05:03'),
 (171,560,'2006-02-15 05:05:03'),
 (171,566,'2006-02-15 05:05:03'),
 (171,608,'2006-02-15 05:05:03'),
 (171,625,'2006-02-15 05:05:03'),
 (171,645,'2006-02-15 05:05:03'),
 (171,701,'2006-02-15 05:05:03'),
 (171,761,'2006-02-15 05:05:03'),
 (171,779,'2006-02-15 05:05:03'),
 (171,849,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (171,872,'2006-02-15 05:05:03'),
 (171,892,'2006-02-15 05:05:03'),
 (171,898,'2006-02-15 05:05:03'),
 (171,903,'2006-02-15 05:05:03'),
 (171,953,'2006-02-15 05:05:03'),
 (172,57,'2006-02-15 05:05:03'),
 (172,100,'2006-02-15 05:05:03'),
 (172,148,'2006-02-15 05:05:03'),
 (172,215,'2006-02-15 05:05:03'),
 (172,302,'2006-02-15 05:05:03'),
 (172,345,'2006-02-15 05:05:03'),
 (172,368,'2006-02-15 05:05:03'),
 (172,385,'2006-02-15 05:05:03'),
 (172,423,'2006-02-15 05:05:03'),
 (172,487,'2006-02-15 05:05:03'),
 (172,493,'2006-02-15 05:05:03'),
 (172,529,'2006-02-15 05:05:03'),
 (172,538,'2006-02-15 05:05:03'),
 (172,567,'2006-02-15 05:05:03'),
 (172,609,'2006-02-15 05:05:03'),
 (172,639,'2006-02-15 05:05:03'),
 (172,649,'2006-02-15 05:05:03'),
 (172,661,'2006-02-15 05:05:03'),
 (172,667,'2006-02-15 05:05:03'),
 (172,710,'2006-02-15 05:05:03'),
 (172,744,'2006-02-15 05:05:03'),
 (172,758,'2006-02-15 05:05:03'),
 (172,771,'2006-02-15 05:05:03'),
 (172,833,'2006-02-15 05:05:03'),
 (172,959,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (173,49,'2006-02-15 05:05:03'),
 (173,55,'2006-02-15 05:05:03'),
 (173,74,'2006-02-15 05:05:03'),
 (173,80,'2006-02-15 05:05:03'),
 (173,106,'2006-02-15 05:05:03'),
 (173,154,'2006-02-15 05:05:03'),
 (173,162,'2006-02-15 05:05:03'),
 (173,188,'2006-02-15 05:05:03'),
 (173,235,'2006-02-15 05:05:03'),
 (173,313,'2006-02-15 05:05:03'),
 (173,379,'2006-02-15 05:05:03'),
 (173,405,'2006-02-15 05:05:03'),
 (173,491,'2006-02-15 05:05:03'),
 (173,496,'2006-02-15 05:05:03'),
 (173,529,'2006-02-15 05:05:03'),
 (173,550,'2006-02-15 05:05:03'),
 (173,564,'2006-02-15 05:05:03'),
 (173,571,'2006-02-15 05:05:03'),
 (173,592,'2006-02-15 05:05:03'),
 (173,688,'2006-02-15 05:05:03'),
 (173,753,'2006-02-15 05:05:03'),
 (173,757,'2006-02-15 05:05:03'),
 (173,852,'2006-02-15 05:05:03'),
 (173,857,'2006-02-15 05:05:03'),
 (173,921,'2006-02-15 05:05:03'),
 (173,928,'2006-02-15 05:05:03'),
 (173,933,'2006-02-15 05:05:03'),
 (174,11,'2006-02-15 05:05:03'),
 (174,61,'2006-02-15 05:05:03'),
 (174,168,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (174,298,'2006-02-15 05:05:03'),
 (174,352,'2006-02-15 05:05:03'),
 (174,442,'2006-02-15 05:05:03'),
 (174,451,'2006-02-15 05:05:03'),
 (174,496,'2006-02-15 05:05:03'),
 (174,610,'2006-02-15 05:05:03'),
 (174,618,'2006-02-15 05:05:03'),
 (174,622,'2006-02-15 05:05:03'),
 (174,659,'2006-02-15 05:05:03'),
 (174,677,'2006-02-15 05:05:03'),
 (174,705,'2006-02-15 05:05:03'),
 (174,722,'2006-02-15 05:05:03'),
 (174,780,'2006-02-15 05:05:03'),
 (174,797,'2006-02-15 05:05:03'),
 (174,809,'2006-02-15 05:05:03'),
 (174,827,'2006-02-15 05:05:03'),
 (174,830,'2006-02-15 05:05:03'),
 (174,852,'2006-02-15 05:05:03'),
 (174,853,'2006-02-15 05:05:03'),
 (174,879,'2006-02-15 05:05:03'),
 (174,982,'2006-02-15 05:05:03'),
 (175,9,'2006-02-15 05:05:03'),
 (175,29,'2006-02-15 05:05:03'),
 (175,67,'2006-02-15 05:05:03'),
 (175,129,'2006-02-15 05:05:03'),
 (175,155,'2006-02-15 05:05:03'),
 (175,190,'2006-02-15 05:05:03'),
 (175,191,'2006-02-15 05:05:03'),
 (175,362,'2006-02-15 05:05:03'),
 (175,405,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (175,424,'2006-02-15 05:05:03'),
 (175,439,'2006-02-15 05:05:03'),
 (175,442,'2006-02-15 05:05:03'),
 (175,483,'2006-02-15 05:05:03'),
 (175,591,'2006-02-15 05:05:03'),
 (175,596,'2006-02-15 05:05:03'),
 (175,616,'2006-02-15 05:05:03'),
 (175,719,'2006-02-15 05:05:03'),
 (175,729,'2006-02-15 05:05:03'),
 (175,772,'2006-02-15 05:05:03'),
 (175,778,'2006-02-15 05:05:03'),
 (175,828,'2006-02-15 05:05:03'),
 (175,842,'2006-02-15 05:05:03'),
 (175,890,'2006-02-15 05:05:03'),
 (175,908,'2006-02-15 05:05:03'),
 (175,977,'2006-02-15 05:05:03'),
 (175,978,'2006-02-15 05:05:03'),
 (175,998,'2006-02-15 05:05:03'),
 (176,13,'2006-02-15 05:05:03'),
 (176,73,'2006-02-15 05:05:03'),
 (176,89,'2006-02-15 05:05:03'),
 (176,150,'2006-02-15 05:05:03'),
 (176,162,'2006-02-15 05:05:03'),
 (176,238,'2006-02-15 05:05:03'),
 (176,252,'2006-02-15 05:05:03'),
 (176,303,'2006-02-15 05:05:03'),
 (176,320,'2006-02-15 05:05:03'),
 (176,401,'2006-02-15 05:05:03'),
 (176,417,'2006-02-15 05:05:03'),
 (176,441,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (176,458,'2006-02-15 05:05:03'),
 (176,461,'2006-02-15 05:05:03'),
 (176,517,'2006-02-15 05:05:03'),
 (176,521,'2006-02-15 05:05:03'),
 (176,543,'2006-02-15 05:05:03'),
 (176,573,'2006-02-15 05:05:03'),
 (176,699,'2006-02-15 05:05:03'),
 (176,726,'2006-02-15 05:05:03'),
 (176,740,'2006-02-15 05:05:03'),
 (176,746,'2006-02-15 05:05:03'),
 (176,758,'2006-02-15 05:05:03'),
 (176,802,'2006-02-15 05:05:03'),
 (176,827,'2006-02-15 05:05:03'),
 (176,839,'2006-02-15 05:05:03'),
 (176,859,'2006-02-15 05:05:03'),
 (176,872,'2006-02-15 05:05:03'),
 (176,946,'2006-02-15 05:05:03'),
 (177,12,'2006-02-15 05:05:03'),
 (177,39,'2006-02-15 05:05:03'),
 (177,52,'2006-02-15 05:05:03'),
 (177,55,'2006-02-15 05:05:03'),
 (177,86,'2006-02-15 05:05:03'),
 (177,175,'2006-02-15 05:05:03'),
 (177,188,'2006-02-15 05:05:03'),
 (177,235,'2006-02-15 05:05:03'),
 (177,237,'2006-02-15 05:05:03'),
 (177,289,'2006-02-15 05:05:03'),
 (177,363,'2006-02-15 05:05:03'),
 (177,401,'2006-02-15 05:05:03'),
 (177,433,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (177,458,'2006-02-15 05:05:03'),
 (177,522,'2006-02-15 05:05:03'),
 (177,543,'2006-02-15 05:05:03'),
 (177,563,'2006-02-15 05:05:03'),
 (177,649,'2006-02-15 05:05:03'),
 (177,683,'2006-02-15 05:05:03'),
 (177,684,'2006-02-15 05:05:03'),
 (177,726,'2006-02-15 05:05:03'),
 (177,751,'2006-02-15 05:05:03'),
 (177,763,'2006-02-15 05:05:03'),
 (177,764,'2006-02-15 05:05:03'),
 (177,827,'2006-02-15 05:05:03'),
 (177,910,'2006-02-15 05:05:03'),
 (177,956,'2006-02-15 05:05:03'),
 (178,30,'2006-02-15 05:05:03'),
 (178,34,'2006-02-15 05:05:03'),
 (178,109,'2006-02-15 05:05:03'),
 (178,146,'2006-02-15 05:05:03'),
 (178,160,'2006-02-15 05:05:03'),
 (178,164,'2006-02-15 05:05:03'),
 (178,194,'2006-02-15 05:05:03'),
 (178,197,'2006-02-15 05:05:03'),
 (178,273,'2006-02-15 05:05:03'),
 (178,311,'2006-02-15 05:05:03'),
 (178,397,'2006-02-15 05:05:03'),
 (178,483,'2006-02-15 05:05:03'),
 (178,517,'2006-02-15 05:05:03'),
 (178,537,'2006-02-15 05:05:03'),
 (178,587,'2006-02-15 05:05:03'),
 (178,708,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (178,733,'2006-02-15 05:05:03'),
 (178,744,'2006-02-15 05:05:03'),
 (178,762,'2006-02-15 05:05:03'),
 (178,930,'2006-02-15 05:05:03'),
 (178,974,'2006-02-15 05:05:03'),
 (178,983,'2006-02-15 05:05:03'),
 (178,1000,'2006-02-15 05:05:03'),
 (179,24,'2006-02-15 05:05:03'),
 (179,27,'2006-02-15 05:05:03'),
 (179,65,'2006-02-15 05:05:03'),
 (179,85,'2006-02-15 05:05:03'),
 (179,109,'2006-02-15 05:05:03'),
 (179,131,'2006-02-15 05:05:03'),
 (179,159,'2006-02-15 05:05:03'),
 (179,193,'2006-02-15 05:05:03'),
 (179,250,'2006-02-15 05:05:03'),
 (179,291,'2006-02-15 05:05:03'),
 (179,353,'2006-02-15 05:05:03'),
 (179,415,'2006-02-15 05:05:03'),
 (179,463,'2006-02-15 05:05:03'),
 (179,468,'2006-02-15 05:05:03'),
 (179,489,'2006-02-15 05:05:03'),
 (179,566,'2006-02-15 05:05:03'),
 (179,588,'2006-02-15 05:05:03'),
 (179,650,'2006-02-15 05:05:03'),
 (179,698,'2006-02-15 05:05:03'),
 (179,732,'2006-02-15 05:05:03'),
 (179,737,'2006-02-15 05:05:03'),
 (179,769,'2006-02-15 05:05:03'),
 (179,811,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (179,817,'2006-02-15 05:05:03'),
 (179,852,'2006-02-15 05:05:03'),
 (179,924,'2006-02-15 05:05:03'),
 (179,931,'2006-02-15 05:05:03'),
 (179,960,'2006-02-15 05:05:03'),
 (179,976,'2006-02-15 05:05:03'),
 (180,12,'2006-02-15 05:05:03'),
 (180,33,'2006-02-15 05:05:03'),
 (180,144,'2006-02-15 05:05:03'),
 (180,195,'2006-02-15 05:05:03'),
 (180,258,'2006-02-15 05:05:03'),
 (180,441,'2006-02-15 05:05:03'),
 (180,506,'2006-02-15 05:05:03'),
 (180,561,'2006-02-15 05:05:03'),
 (180,609,'2006-02-15 05:05:03'),
 (180,622,'2006-02-15 05:05:03'),
 (180,628,'2006-02-15 05:05:03'),
 (180,657,'2006-02-15 05:05:03'),
 (180,724,'2006-02-15 05:05:03'),
 (180,729,'2006-02-15 05:05:03'),
 (180,732,'2006-02-15 05:05:03'),
 (180,777,'2006-02-15 05:05:03'),
 (180,809,'2006-02-15 05:05:03'),
 (180,811,'2006-02-15 05:05:03'),
 (180,820,'2006-02-15 05:05:03'),
 (180,824,'2006-02-15 05:05:03'),
 (180,847,'2006-02-15 05:05:03'),
 (180,869,'2006-02-15 05:05:03'),
 (180,874,'2006-02-15 05:05:03'),
 (180,955,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (180,963,'2006-02-15 05:05:03'),
 (181,5,'2006-02-15 05:05:03'),
 (181,40,'2006-02-15 05:05:03'),
 (181,74,'2006-02-15 05:05:03'),
 (181,78,'2006-02-15 05:05:03'),
 (181,83,'2006-02-15 05:05:03'),
 (181,152,'2006-02-15 05:05:03'),
 (181,195,'2006-02-15 05:05:03'),
 (181,233,'2006-02-15 05:05:03'),
 (181,286,'2006-02-15 05:05:03'),
 (181,301,'2006-02-15 05:05:03'),
 (181,311,'2006-02-15 05:05:03'),
 (181,381,'2006-02-15 05:05:03'),
 (181,387,'2006-02-15 05:05:03'),
 (181,403,'2006-02-15 05:05:03'),
 (181,409,'2006-02-15 05:05:03'),
 (181,420,'2006-02-15 05:05:03'),
 (181,437,'2006-02-15 05:05:03'),
 (181,456,'2006-02-15 05:05:03'),
 (181,507,'2006-02-15 05:05:03'),
 (181,522,'2006-02-15 05:05:03'),
 (181,539,'2006-02-15 05:05:03'),
 (181,542,'2006-02-15 05:05:03'),
 (181,546,'2006-02-15 05:05:03'),
 (181,579,'2006-02-15 05:05:03'),
 (181,596,'2006-02-15 05:05:03'),
 (181,604,'2006-02-15 05:05:03'),
 (181,609,'2006-02-15 05:05:03'),
 (181,625,'2006-02-15 05:05:03'),
 (181,744,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (181,816,'2006-02-15 05:05:03'),
 (181,836,'2006-02-15 05:05:03'),
 (181,868,'2006-02-15 05:05:03'),
 (181,870,'2006-02-15 05:05:03'),
 (181,874,'2006-02-15 05:05:03'),
 (181,892,'2006-02-15 05:05:03'),
 (181,907,'2006-02-15 05:05:03'),
 (181,911,'2006-02-15 05:05:03'),
 (181,921,'2006-02-15 05:05:03'),
 (181,991,'2006-02-15 05:05:03'),
 (182,33,'2006-02-15 05:05:03'),
 (182,160,'2006-02-15 05:05:03'),
 (182,301,'2006-02-15 05:05:03'),
 (182,324,'2006-02-15 05:05:03'),
 (182,346,'2006-02-15 05:05:03'),
 (182,362,'2006-02-15 05:05:03'),
 (182,391,'2006-02-15 05:05:03'),
 (182,413,'2006-02-15 05:05:03'),
 (182,421,'2006-02-15 05:05:03'),
 (182,437,'2006-02-15 05:05:03'),
 (182,590,'2006-02-15 05:05:03'),
 (182,639,'2006-02-15 05:05:03'),
 (182,668,'2006-02-15 05:05:03'),
 (182,677,'2006-02-15 05:05:03'),
 (182,679,'2006-02-15 05:05:03'),
 (182,695,'2006-02-15 05:05:03'),
 (182,714,'2006-02-15 05:05:03'),
 (182,720,'2006-02-15 05:05:03'),
 (182,819,'2006-02-15 05:05:03'),
 (182,828,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (182,845,'2006-02-15 05:05:03'),
 (182,864,'2006-02-15 05:05:03'),
 (182,940,'2006-02-15 05:05:03'),
 (182,990,'2006-02-15 05:05:03'),
 (183,32,'2006-02-15 05:05:03'),
 (183,40,'2006-02-15 05:05:03'),
 (183,71,'2006-02-15 05:05:03'),
 (183,113,'2006-02-15 05:05:03'),
 (183,313,'2006-02-15 05:05:03'),
 (183,388,'2006-02-15 05:05:03'),
 (183,389,'2006-02-15 05:05:03'),
 (183,390,'2006-02-15 05:05:03'),
 (183,495,'2006-02-15 05:05:03'),
 (183,520,'2006-02-15 05:05:03'),
 (183,576,'2006-02-15 05:05:03'),
 (183,636,'2006-02-15 05:05:03'),
 (183,715,'2006-02-15 05:05:03'),
 (183,850,'2006-02-15 05:05:03'),
 (183,862,'2006-02-15 05:05:03'),
 (183,914,'2006-02-15 05:05:03'),
 (183,941,'2006-02-15 05:05:03'),
 (183,949,'2006-02-15 05:05:03'),
 (183,983,'2006-02-15 05:05:03'),
 (184,35,'2006-02-15 05:05:03'),
 (184,87,'2006-02-15 05:05:03'),
 (184,146,'2006-02-15 05:05:03'),
 (184,169,'2006-02-15 05:05:03'),
 (184,221,'2006-02-15 05:05:03'),
 (184,336,'2006-02-15 05:05:03'),
 (184,371,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (184,452,'2006-02-15 05:05:03'),
 (184,486,'2006-02-15 05:05:03'),
 (184,492,'2006-02-15 05:05:03'),
 (184,500,'2006-02-15 05:05:03'),
 (184,574,'2006-02-15 05:05:03'),
 (184,580,'2006-02-15 05:05:03'),
 (184,597,'2006-02-15 05:05:03'),
 (184,615,'2006-02-15 05:05:03'),
 (184,640,'2006-02-15 05:05:03'),
 (184,642,'2006-02-15 05:05:03'),
 (184,650,'2006-02-15 05:05:03'),
 (184,661,'2006-02-15 05:05:03'),
 (184,684,'2006-02-15 05:05:03'),
 (184,745,'2006-02-15 05:05:03'),
 (184,772,'2006-02-15 05:05:03'),
 (184,787,'2006-02-15 05:05:03'),
 (184,867,'2006-02-15 05:05:03'),
 (184,959,'2006-02-15 05:05:03'),
 (184,966,'2006-02-15 05:05:03'),
 (184,967,'2006-02-15 05:05:03'),
 (184,969,'2006-02-15 05:05:03'),
 (184,985,'2006-02-15 05:05:03'),
 (185,7,'2006-02-15 05:05:03'),
 (185,95,'2006-02-15 05:05:03'),
 (185,138,'2006-02-15 05:05:03'),
 (185,265,'2006-02-15 05:05:03'),
 (185,286,'2006-02-15 05:05:03'),
 (185,360,'2006-02-15 05:05:03'),
 (185,411,'2006-02-15 05:05:03'),
 (185,427,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (185,437,'2006-02-15 05:05:03'),
 (185,448,'2006-02-15 05:05:03'),
 (185,494,'2006-02-15 05:05:03'),
 (185,510,'2006-02-15 05:05:03'),
 (185,518,'2006-02-15 05:05:03'),
 (185,554,'2006-02-15 05:05:03'),
 (185,560,'2006-02-15 05:05:03'),
 (185,571,'2006-02-15 05:05:03'),
 (185,584,'2006-02-15 05:05:03'),
 (185,631,'2006-02-15 05:05:03'),
 (185,665,'2006-02-15 05:05:03'),
 (185,694,'2006-02-15 05:05:03'),
 (185,730,'2006-02-15 05:05:03'),
 (185,761,'2006-02-15 05:05:03'),
 (185,818,'2006-02-15 05:05:03'),
 (185,845,'2006-02-15 05:05:03'),
 (185,880,'2006-02-15 05:05:03'),
 (185,882,'2006-02-15 05:05:03'),
 (185,919,'2006-02-15 05:05:03'),
 (185,920,'2006-02-15 05:05:03'),
 (185,965,'2006-02-15 05:05:03'),
 (185,973,'2006-02-15 05:05:03'),
 (186,95,'2006-02-15 05:05:03'),
 (186,187,'2006-02-15 05:05:03'),
 (186,208,'2006-02-15 05:05:03'),
 (186,228,'2006-02-15 05:05:03'),
 (186,237,'2006-02-15 05:05:03'),
 (186,422,'2006-02-15 05:05:03'),
 (186,482,'2006-02-15 05:05:03'),
 (186,508,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (186,552,'2006-02-15 05:05:03'),
 (186,579,'2006-02-15 05:05:03'),
 (186,637,'2006-02-15 05:05:03'),
 (186,648,'2006-02-15 05:05:03'),
 (186,654,'2006-02-15 05:05:03'),
 (186,729,'2006-02-15 05:05:03'),
 (186,983,'2006-02-15 05:05:03'),
 (186,994,'2006-02-15 05:05:03'),
 (187,17,'2006-02-15 05:05:03'),
 (187,25,'2006-02-15 05:05:03'),
 (187,29,'2006-02-15 05:05:03'),
 (187,51,'2006-02-15 05:05:03'),
 (187,73,'2006-02-15 05:05:03'),
 (187,76,'2006-02-15 05:05:03'),
 (187,98,'2006-02-15 05:05:03'),
 (187,110,'2006-02-15 05:05:03'),
 (187,127,'2006-02-15 05:05:03'),
 (187,168,'2006-02-15 05:05:03'),
 (187,222,'2006-02-15 05:05:03'),
 (187,224,'2006-02-15 05:05:03'),
 (187,297,'2006-02-15 05:05:03'),
 (187,354,'2006-02-15 05:05:03'),
 (187,379,'2006-02-15 05:05:03'),
 (187,417,'2006-02-15 05:05:03'),
 (187,435,'2006-02-15 05:05:03'),
 (187,441,'2006-02-15 05:05:03'),
 (187,474,'2006-02-15 05:05:03'),
 (187,499,'2006-02-15 05:05:03'),
 (187,538,'2006-02-15 05:05:03'),
 (187,548,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (187,561,'2006-02-15 05:05:03'),
 (187,617,'2006-02-15 05:05:03'),
 (187,625,'2006-02-15 05:05:03'),
 (187,664,'2006-02-15 05:05:03'),
 (187,671,'2006-02-15 05:05:03'),
 (187,768,'2006-02-15 05:05:03'),
 (187,779,'2006-02-15 05:05:03'),
 (187,906,'2006-02-15 05:05:03'),
 (187,914,'2006-02-15 05:05:03'),
 (187,923,'2006-02-15 05:05:03'),
 (187,976,'2006-02-15 05:05:03'),
 (188,1,'2006-02-15 05:05:03'),
 (188,10,'2006-02-15 05:05:03'),
 (188,14,'2006-02-15 05:05:03'),
 (188,51,'2006-02-15 05:05:03'),
 (188,102,'2006-02-15 05:05:03'),
 (188,111,'2006-02-15 05:05:03'),
 (188,146,'2006-02-15 05:05:03'),
 (188,206,'2006-02-15 05:05:03'),
 (188,223,'2006-02-15 05:05:03'),
 (188,289,'2006-02-15 05:05:03'),
 (188,311,'2006-02-15 05:05:03'),
 (188,322,'2006-02-15 05:05:03'),
 (188,338,'2006-02-15 05:05:03'),
 (188,396,'2006-02-15 05:05:03'),
 (188,412,'2006-02-15 05:05:03'),
 (188,506,'2006-02-15 05:05:03'),
 (188,517,'2006-02-15 05:05:03'),
 (188,529,'2006-02-15 05:05:03'),
 (188,566,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (188,593,'2006-02-15 05:05:03'),
 (188,606,'2006-02-15 05:05:03'),
 (188,662,'2006-02-15 05:05:03'),
 (188,770,'2006-02-15 05:05:03'),
 (188,773,'2006-02-15 05:05:03'),
 (188,774,'2006-02-15 05:05:03'),
 (188,815,'2006-02-15 05:05:03'),
 (188,849,'2006-02-15 05:05:03'),
 (188,925,'2006-02-15 05:05:03'),
 (188,988,'2006-02-15 05:05:03'),
 (188,989,'2006-02-15 05:05:03'),
 (189,43,'2006-02-15 05:05:03'),
 (189,82,'2006-02-15 05:05:03'),
 (189,171,'2006-02-15 05:05:03'),
 (189,266,'2006-02-15 05:05:03'),
 (189,272,'2006-02-15 05:05:03'),
 (189,315,'2006-02-15 05:05:03'),
 (189,378,'2006-02-15 05:05:03'),
 (189,492,'2006-02-15 05:05:03'),
 (189,509,'2006-02-15 05:05:03'),
 (189,512,'2006-02-15 05:05:03'),
 (189,519,'2006-02-15 05:05:03'),
 (189,533,'2006-02-15 05:05:03'),
 (189,548,'2006-02-15 05:05:03'),
 (189,560,'2006-02-15 05:05:03'),
 (189,628,'2006-02-15 05:05:03'),
 (189,734,'2006-02-15 05:05:03'),
 (189,748,'2006-02-15 05:05:03'),
 (189,788,'2006-02-15 05:05:03'),
 (189,820,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (189,853,'2006-02-15 05:05:03'),
 (189,882,'2006-02-15 05:05:03'),
 (189,896,'2006-02-15 05:05:03'),
 (189,899,'2006-02-15 05:05:03'),
 (189,940,'2006-02-15 05:05:03'),
 (190,38,'2006-02-15 05:05:03'),
 (190,54,'2006-02-15 05:05:03'),
 (190,62,'2006-02-15 05:05:03'),
 (190,87,'2006-02-15 05:05:03'),
 (190,173,'2006-02-15 05:05:03'),
 (190,234,'2006-02-15 05:05:03'),
 (190,253,'2006-02-15 05:05:03'),
 (190,278,'2006-02-15 05:05:03'),
 (190,310,'2006-02-15 05:05:03'),
 (190,374,'2006-02-15 05:05:03'),
 (190,411,'2006-02-15 05:05:03'),
 (190,426,'2006-02-15 05:05:03'),
 (190,472,'2006-02-15 05:05:03'),
 (190,549,'2006-02-15 05:05:03'),
 (190,562,'2006-02-15 05:05:03'),
 (190,606,'2006-02-15 05:05:03'),
 (190,623,'2006-02-15 05:05:03'),
 (190,679,'2006-02-15 05:05:03'),
 (190,682,'2006-02-15 05:05:03'),
 (190,693,'2006-02-15 05:05:03'),
 (190,695,'2006-02-15 05:05:03'),
 (190,705,'2006-02-15 05:05:03'),
 (190,708,'2006-02-15 05:05:03'),
 (190,802,'2006-02-15 05:05:03'),
 (190,806,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (190,874,'2006-02-15 05:05:03'),
 (190,959,'2006-02-15 05:05:03'),
 (191,16,'2006-02-15 05:05:03'),
 (191,39,'2006-02-15 05:05:03'),
 (191,84,'2006-02-15 05:05:03'),
 (191,185,'2006-02-15 05:05:03'),
 (191,219,'2006-02-15 05:05:03'),
 (191,293,'2006-02-15 05:05:03'),
 (191,296,'2006-02-15 05:05:03'),
 (191,378,'2006-02-15 05:05:03'),
 (191,410,'2006-02-15 05:05:03'),
 (191,420,'2006-02-15 05:05:03'),
 (191,461,'2006-02-15 05:05:03'),
 (191,544,'2006-02-15 05:05:03'),
 (191,551,'2006-02-15 05:05:03'),
 (191,596,'2006-02-15 05:05:03'),
 (191,638,'2006-02-15 05:05:03'),
 (191,668,'2006-02-15 05:05:03'),
 (191,692,'2006-02-15 05:05:03'),
 (191,775,'2006-02-15 05:05:03'),
 (191,801,'2006-02-15 05:05:03'),
 (191,819,'2006-02-15 05:05:03'),
 (191,827,'2006-02-15 05:05:03'),
 (191,830,'2006-02-15 05:05:03'),
 (191,834,'2006-02-15 05:05:03'),
 (191,849,'2006-02-15 05:05:03'),
 (191,858,'2006-02-15 05:05:03'),
 (191,914,'2006-02-15 05:05:03'),
 (191,958,'2006-02-15 05:05:03'),
 (191,969,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (191,971,'2006-02-15 05:05:03'),
 (191,993,'2006-02-15 05:05:03'),
 (192,16,'2006-02-15 05:05:03'),
 (192,69,'2006-02-15 05:05:03'),
 (192,117,'2006-02-15 05:05:03'),
 (192,155,'2006-02-15 05:05:03'),
 (192,166,'2006-02-15 05:05:03'),
 (192,179,'2006-02-15 05:05:03'),
 (192,214,'2006-02-15 05:05:03'),
 (192,361,'2006-02-15 05:05:03'),
 (192,367,'2006-02-15 05:05:03'),
 (192,426,'2006-02-15 05:05:03'),
 (192,465,'2006-02-15 05:05:03'),
 (192,470,'2006-02-15 05:05:03'),
 (192,475,'2006-02-15 05:05:03'),
 (192,485,'2006-02-15 05:05:03'),
 (192,541,'2006-02-15 05:05:03'),
 (192,578,'2006-02-15 05:05:03'),
 (192,592,'2006-02-15 05:05:03'),
 (192,614,'2006-02-15 05:05:03'),
 (192,618,'2006-02-15 05:05:03'),
 (192,622,'2006-02-15 05:05:03'),
 (192,674,'2006-02-15 05:05:03'),
 (192,677,'2006-02-15 05:05:03'),
 (192,680,'2006-02-15 05:05:03'),
 (192,682,'2006-02-15 05:05:03'),
 (192,708,'2006-02-15 05:05:03'),
 (192,711,'2006-02-15 05:05:03'),
 (192,747,'2006-02-15 05:05:03'),
 (192,763,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (192,819,'2006-02-15 05:05:03'),
 (193,44,'2006-02-15 05:05:03'),
 (193,80,'2006-02-15 05:05:03'),
 (193,103,'2006-02-15 05:05:03'),
 (193,109,'2006-02-15 05:05:03'),
 (193,119,'2006-02-15 05:05:03'),
 (193,141,'2006-02-15 05:05:03'),
 (193,164,'2006-02-15 05:05:03'),
 (193,291,'2006-02-15 05:05:03'),
 (193,352,'2006-02-15 05:05:03'),
 (193,358,'2006-02-15 05:05:03'),
 (193,376,'2006-02-15 05:05:03'),
 (193,412,'2006-02-15 05:05:03'),
 (193,462,'2006-02-15 05:05:03'),
 (193,689,'2006-02-15 05:05:03'),
 (193,709,'2006-02-15 05:05:03'),
 (193,745,'2006-02-15 05:05:03'),
 (193,807,'2006-02-15 05:05:03'),
 (193,828,'2006-02-15 05:05:03'),
 (193,834,'2006-02-15 05:05:03'),
 (193,851,'2006-02-15 05:05:03'),
 (193,937,'2006-02-15 05:05:03'),
 (193,953,'2006-02-15 05:05:03'),
 (193,960,'2006-02-15 05:05:03'),
 (194,9,'2006-02-15 05:05:03'),
 (194,42,'2006-02-15 05:05:03'),
 (194,67,'2006-02-15 05:05:03'),
 (194,86,'2006-02-15 05:05:03'),
 (194,88,'2006-02-15 05:05:03'),
 (194,98,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (194,135,'2006-02-15 05:05:03'),
 (194,161,'2006-02-15 05:05:03'),
 (194,163,'2006-02-15 05:05:03'),
 (194,215,'2006-02-15 05:05:03'),
 (194,232,'2006-02-15 05:05:03'),
 (194,352,'2006-02-15 05:05:03'),
 (194,415,'2006-02-15 05:05:03'),
 (194,486,'2006-02-15 05:05:03'),
 (194,498,'2006-02-15 05:05:03'),
 (194,531,'2006-02-15 05:05:03'),
 (194,719,'2006-02-15 05:05:03'),
 (194,738,'2006-02-15 05:05:03'),
 (194,786,'2006-02-15 05:05:03'),
 (194,872,'2006-02-15 05:05:03'),
 (194,938,'2006-02-15 05:05:03'),
 (194,940,'2006-02-15 05:05:03'),
 (195,129,'2006-02-15 05:05:03'),
 (195,130,'2006-02-15 05:05:03'),
 (195,141,'2006-02-15 05:05:03'),
 (195,144,'2006-02-15 05:05:03'),
 (195,298,'2006-02-15 05:05:03'),
 (195,359,'2006-02-15 05:05:03'),
 (195,361,'2006-02-15 05:05:03'),
 (195,392,'2006-02-15 05:05:03'),
 (195,403,'2006-02-15 05:05:03'),
 (195,494,'2006-02-15 05:05:03'),
 (195,520,'2006-02-15 05:05:03'),
 (195,534,'2006-02-15 05:05:03'),
 (195,560,'2006-02-15 05:05:03'),
 (195,592,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (195,649,'2006-02-15 05:05:03'),
 (195,658,'2006-02-15 05:05:03'),
 (195,673,'2006-02-15 05:05:03'),
 (195,677,'2006-02-15 05:05:03'),
 (195,706,'2006-02-15 05:05:03'),
 (195,738,'2006-02-15 05:05:03'),
 (195,769,'2006-02-15 05:05:03'),
 (195,781,'2006-02-15 05:05:03'),
 (195,794,'2006-02-15 05:05:03'),
 (195,813,'2006-02-15 05:05:03'),
 (195,869,'2006-02-15 05:05:03'),
 (195,885,'2006-02-15 05:05:03'),
 (195,962,'2006-02-15 05:05:03'),
 (196,64,'2006-02-15 05:05:03'),
 (196,122,'2006-02-15 05:05:03'),
 (196,156,'2006-02-15 05:05:03'),
 (196,169,'2006-02-15 05:05:03'),
 (196,276,'2006-02-15 05:05:03'),
 (196,284,'2006-02-15 05:05:03'),
 (196,303,'2006-02-15 05:05:03'),
 (196,324,'2006-02-15 05:05:03'),
 (196,423,'2006-02-15 05:05:03'),
 (196,473,'2006-02-15 05:05:03'),
 (196,484,'2006-02-15 05:05:03'),
 (196,515,'2006-02-15 05:05:03'),
 (196,524,'2006-02-15 05:05:03'),
 (196,541,'2006-02-15 05:05:03'),
 (196,560,'2006-02-15 05:05:03'),
 (196,575,'2006-02-15 05:05:03'),
 (196,576,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (196,587,'2006-02-15 05:05:03'),
 (196,615,'2006-02-15 05:05:03'),
 (196,635,'2006-02-15 05:05:03'),
 (196,684,'2006-02-15 05:05:03'),
 (196,795,'2006-02-15 05:05:03'),
 (196,815,'2006-02-15 05:05:03'),
 (196,833,'2006-02-15 05:05:03'),
 (196,837,'2006-02-15 05:05:03'),
 (196,906,'2006-02-15 05:05:03'),
 (196,908,'2006-02-15 05:05:03'),
 (196,919,'2006-02-15 05:05:03'),
 (196,939,'2006-02-15 05:05:03'),
 (196,972,'2006-02-15 05:05:03'),
 (197,6,'2006-02-15 05:05:03'),
 (197,29,'2006-02-15 05:05:03'),
 (197,63,'2006-02-15 05:05:03'),
 (197,123,'2006-02-15 05:05:03'),
 (197,129,'2006-02-15 05:05:03'),
 (197,147,'2006-02-15 05:05:03'),
 (197,164,'2006-02-15 05:05:03'),
 (197,189,'2006-02-15 05:05:03'),
 (197,243,'2006-02-15 05:05:03'),
 (197,249,'2006-02-15 05:05:03'),
 (197,258,'2006-02-15 05:05:03'),
 (197,364,'2006-02-15 05:05:03'),
 (197,369,'2006-02-15 05:05:03'),
 (197,370,'2006-02-15 05:05:03'),
 (197,418,'2006-02-15 05:05:03'),
 (197,522,'2006-02-15 05:05:03'),
 (197,531,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (197,554,'2006-02-15 05:05:03'),
 (197,598,'2006-02-15 05:05:03'),
 (197,628,'2006-02-15 05:05:03'),
 (197,691,'2006-02-15 05:05:03'),
 (197,724,'2006-02-15 05:05:03'),
 (197,746,'2006-02-15 05:05:03'),
 (197,752,'2006-02-15 05:05:03'),
 (197,758,'2006-02-15 05:05:03'),
 (197,769,'2006-02-15 05:05:03'),
 (197,815,'2006-02-15 05:05:03'),
 (197,916,'2006-02-15 05:05:03'),
 (197,950,'2006-02-15 05:05:03'),
 (197,967,'2006-02-15 05:05:03'),
 (197,974,'2006-02-15 05:05:03'),
 (197,979,'2006-02-15 05:05:03'),
 (197,995,'2006-02-15 05:05:03'),
 (198,1,'2006-02-15 05:05:03'),
 (198,109,'2006-02-15 05:05:03'),
 (198,125,'2006-02-15 05:05:03'),
 (198,186,'2006-02-15 05:05:03'),
 (198,262,'2006-02-15 05:05:03'),
 (198,264,'2006-02-15 05:05:03'),
 (198,303,'2006-02-15 05:05:03'),
 (198,309,'2006-02-15 05:05:03'),
 (198,311,'2006-02-15 05:05:03'),
 (198,329,'2006-02-15 05:05:03'),
 (198,347,'2006-02-15 05:05:03'),
 (198,379,'2006-02-15 05:05:03'),
 (198,395,'2006-02-15 05:05:03'),
 (198,406,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (198,450,'2006-02-15 05:05:03'),
 (198,464,'2006-02-15 05:05:03'),
 (198,482,'2006-02-15 05:05:03'),
 (198,499,'2006-02-15 05:05:03'),
 (198,536,'2006-02-15 05:05:03'),
 (198,541,'2006-02-15 05:05:03'),
 (198,545,'2006-02-15 05:05:03'),
 (198,555,'2006-02-15 05:05:03'),
 (198,568,'2006-02-15 05:05:03'),
 (198,570,'2006-02-15 05:05:03'),
 (198,588,'2006-02-15 05:05:03'),
 (198,597,'2006-02-15 05:05:03'),
 (198,628,'2006-02-15 05:05:03'),
 (198,745,'2006-02-15 05:05:03'),
 (198,758,'2006-02-15 05:05:03'),
 (198,796,'2006-02-15 05:05:03'),
 (198,806,'2006-02-15 05:05:03'),
 (198,817,'2006-02-15 05:05:03'),
 (198,843,'2006-02-15 05:05:03'),
 (198,858,'2006-02-15 05:05:03'),
 (198,871,'2006-02-15 05:05:03'),
 (198,886,'2006-02-15 05:05:03'),
 (198,892,'2006-02-15 05:05:03'),
 (198,924,'2006-02-15 05:05:03'),
 (198,952,'2006-02-15 05:05:03'),
 (198,997,'2006-02-15 05:05:03'),
 (199,67,'2006-02-15 05:05:03'),
 (199,84,'2006-02-15 05:05:03'),
 (199,145,'2006-02-15 05:05:03'),
 (199,159,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (199,216,'2006-02-15 05:05:03'),
 (199,432,'2006-02-15 05:05:03'),
 (199,541,'2006-02-15 05:05:03'),
 (199,604,'2006-02-15 05:05:03'),
 (199,640,'2006-02-15 05:05:03'),
 (199,689,'2006-02-15 05:05:03'),
 (199,730,'2006-02-15 05:05:03'),
 (199,784,'2006-02-15 05:05:03'),
 (199,785,'2006-02-15 05:05:03'),
 (199,886,'2006-02-15 05:05:03'),
 (199,953,'2006-02-15 05:05:03'),
 (200,5,'2006-02-15 05:05:03'),
 (200,49,'2006-02-15 05:05:03'),
 (200,80,'2006-02-15 05:05:03'),
 (200,116,'2006-02-15 05:05:03'),
 (200,121,'2006-02-15 05:05:03'),
 (200,149,'2006-02-15 05:05:03'),
 (200,346,'2006-02-15 05:05:03'),
 (200,419,'2006-02-15 05:05:03'),
 (200,462,'2006-02-15 05:05:03'),
 (200,465,'2006-02-15 05:05:03'),
 (200,474,'2006-02-15 05:05:03'),
 (200,537,'2006-02-15 05:05:03'),
 (200,538,'2006-02-15 05:05:03'),
 (200,544,'2006-02-15 05:05:03'),
 (200,714,'2006-02-15 05:05:03'),
 (200,879,'2006-02-15 05:05:03'),
 (200,912,'2006-02-15 05:05:03'),
 (200,945,'2006-02-15 05:05:03'),
 (200,958,'2006-02-15 05:05:03');
INSERT INTO `sakila`.`film_actor` VALUES  (200,993,'2006-02-15 05:05:03');
COMMIT;

--
-- Definition of table `sakila`.`film_category`
--

DROP TABLE IF EXISTS `sakila`.`film_category`;
CREATE TABLE  `sakila`.`film_category` (
  `film_id` smallint(5) unsigned NOT NULL,
  `category_id` tinyint(3) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`film_id`,`category_id`),
  KEY `fk_film_category_category` (`category_id`),
  CONSTRAINT `fk_film_category_category` FOREIGN KEY (`category_id`) REFERENCES `category` (`category_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_film_category_film` FOREIGN KEY (`film_id`) REFERENCES `film` (`film_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`film_category`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`film_category` VALUES  (1,6,'2006-02-15 05:07:09'),
 (2,11,'2006-02-15 05:07:09'),
 (3,6,'2006-02-15 05:07:09'),
 (4,11,'2006-02-15 05:07:09'),
 (5,8,'2006-02-15 05:07:09'),
 (6,9,'2006-02-15 05:07:09'),
 (7,5,'2006-02-15 05:07:09'),
 (8,11,'2006-02-15 05:07:09'),
 (9,11,'2006-02-15 05:07:09'),
 (10,15,'2006-02-15 05:07:09'),
 (11,9,'2006-02-15 05:07:09'),
 (12,12,'2006-02-15 05:07:09'),
 (13,11,'2006-02-15 05:07:09'),
 (14,4,'2006-02-15 05:07:09'),
 (15,9,'2006-02-15 05:07:09'),
 (16,9,'2006-02-15 05:07:09'),
 (17,12,'2006-02-15 05:07:09'),
 (18,2,'2006-02-15 05:07:09'),
 (19,1,'2006-02-15 05:07:09'),
 (20,12,'2006-02-15 05:07:09'),
 (21,1,'2006-02-15 05:07:09'),
 (22,13,'2006-02-15 05:07:09'),
 (23,2,'2006-02-15 05:07:09'),
 (24,11,'2006-02-15 05:07:09'),
 (25,13,'2006-02-15 05:07:09'),
 (26,14,'2006-02-15 05:07:09'),
 (27,15,'2006-02-15 05:07:09'),
 (28,5,'2006-02-15 05:07:09'),
 (29,1,'2006-02-15 05:07:09'),
 (30,11,'2006-02-15 05:07:09'),
 (31,8,'2006-02-15 05:07:09'),
 (32,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (33,7,'2006-02-15 05:07:09'),
 (34,11,'2006-02-15 05:07:09'),
 (35,11,'2006-02-15 05:07:09'),
 (36,2,'2006-02-15 05:07:09'),
 (37,4,'2006-02-15 05:07:09'),
 (38,1,'2006-02-15 05:07:09'),
 (39,14,'2006-02-15 05:07:09'),
 (40,6,'2006-02-15 05:07:09'),
 (41,16,'2006-02-15 05:07:09'),
 (42,15,'2006-02-15 05:07:09'),
 (43,8,'2006-02-15 05:07:09'),
 (44,14,'2006-02-15 05:07:09'),
 (45,13,'2006-02-15 05:07:09'),
 (46,10,'2006-02-15 05:07:09'),
 (47,9,'2006-02-15 05:07:09'),
 (48,3,'2006-02-15 05:07:09'),
 (49,14,'2006-02-15 05:07:09'),
 (50,8,'2006-02-15 05:07:09'),
 (51,12,'2006-02-15 05:07:09'),
 (52,9,'2006-02-15 05:07:09'),
 (53,8,'2006-02-15 05:07:09'),
 (54,12,'2006-02-15 05:07:09'),
 (55,14,'2006-02-15 05:07:09'),
 (56,1,'2006-02-15 05:07:09'),
 (57,16,'2006-02-15 05:07:09'),
 (58,6,'2006-02-15 05:07:09'),
 (59,3,'2006-02-15 05:07:09'),
 (60,4,'2006-02-15 05:07:09'),
 (61,7,'2006-02-15 05:07:09'),
 (62,6,'2006-02-15 05:07:09'),
 (63,8,'2006-02-15 05:07:09'),
 (64,7,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (65,11,'2006-02-15 05:07:09'),
 (66,3,'2006-02-15 05:07:09'),
 (67,1,'2006-02-15 05:07:09'),
 (68,3,'2006-02-15 05:07:09'),
 (69,14,'2006-02-15 05:07:09'),
 (70,2,'2006-02-15 05:07:09'),
 (71,8,'2006-02-15 05:07:09'),
 (72,6,'2006-02-15 05:07:09'),
 (73,14,'2006-02-15 05:07:09'),
 (74,12,'2006-02-15 05:07:09'),
 (75,16,'2006-02-15 05:07:09'),
 (76,12,'2006-02-15 05:07:09'),
 (77,13,'2006-02-15 05:07:09'),
 (78,2,'2006-02-15 05:07:09'),
 (79,7,'2006-02-15 05:07:09'),
 (80,8,'2006-02-15 05:07:09'),
 (81,14,'2006-02-15 05:07:09'),
 (82,8,'2006-02-15 05:07:09'),
 (83,8,'2006-02-15 05:07:09'),
 (84,16,'2006-02-15 05:07:09'),
 (85,6,'2006-02-15 05:07:09'),
 (86,12,'2006-02-15 05:07:09'),
 (87,16,'2006-02-15 05:07:09'),
 (88,16,'2006-02-15 05:07:09'),
 (89,2,'2006-02-15 05:07:09'),
 (90,13,'2006-02-15 05:07:09'),
 (91,4,'2006-02-15 05:07:09'),
 (92,11,'2006-02-15 05:07:09'),
 (93,13,'2006-02-15 05:07:09'),
 (94,8,'2006-02-15 05:07:09'),
 (95,13,'2006-02-15 05:07:09'),
 (96,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (97,1,'2006-02-15 05:07:09'),
 (98,7,'2006-02-15 05:07:09'),
 (99,5,'2006-02-15 05:07:09'),
 (100,9,'2006-02-15 05:07:09'),
 (101,6,'2006-02-15 05:07:09'),
 (102,15,'2006-02-15 05:07:09'),
 (103,16,'2006-02-15 05:07:09'),
 (104,9,'2006-02-15 05:07:09'),
 (105,1,'2006-02-15 05:07:09'),
 (106,10,'2006-02-15 05:07:09'),
 (107,7,'2006-02-15 05:07:09'),
 (108,13,'2006-02-15 05:07:09'),
 (109,13,'2006-02-15 05:07:09'),
 (110,3,'2006-02-15 05:07:09'),
 (111,1,'2006-02-15 05:07:09'),
 (112,9,'2006-02-15 05:07:09'),
 (113,15,'2006-02-15 05:07:09'),
 (114,14,'2006-02-15 05:07:09'),
 (115,1,'2006-02-15 05:07:09'),
 (116,4,'2006-02-15 05:07:09'),
 (117,10,'2006-02-15 05:07:09'),
 (118,2,'2006-02-15 05:07:09'),
 (119,5,'2006-02-15 05:07:09'),
 (120,15,'2006-02-15 05:07:09'),
 (121,2,'2006-02-15 05:07:09'),
 (122,11,'2006-02-15 05:07:09'),
 (123,16,'2006-02-15 05:07:09'),
 (124,3,'2006-02-15 05:07:09'),
 (125,16,'2006-02-15 05:07:09'),
 (126,1,'2006-02-15 05:07:09'),
 (127,5,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (128,9,'2006-02-15 05:07:09'),
 (129,6,'2006-02-15 05:07:09'),
 (130,1,'2006-02-15 05:07:09'),
 (131,4,'2006-02-15 05:07:09'),
 (132,14,'2006-02-15 05:07:09'),
 (133,12,'2006-02-15 05:07:09'),
 (134,2,'2006-02-15 05:07:09'),
 (135,15,'2006-02-15 05:07:09'),
 (136,13,'2006-02-15 05:07:09'),
 (137,14,'2006-02-15 05:07:09'),
 (138,14,'2006-02-15 05:07:09'),
 (139,8,'2006-02-15 05:07:09'),
 (140,14,'2006-02-15 05:07:09'),
 (141,10,'2006-02-15 05:07:09'),
 (142,6,'2006-02-15 05:07:09'),
 (143,7,'2006-02-15 05:07:09'),
 (144,13,'2006-02-15 05:07:09'),
 (145,8,'2006-02-15 05:07:09'),
 (146,7,'2006-02-15 05:07:09'),
 (147,8,'2006-02-15 05:07:09'),
 (148,9,'2006-02-15 05:07:09'),
 (149,3,'2006-02-15 05:07:09'),
 (150,6,'2006-02-15 05:07:09'),
 (151,14,'2006-02-15 05:07:09'),
 (152,3,'2006-02-15 05:07:09'),
 (153,14,'2006-02-15 05:07:09'),
 (154,2,'2006-02-15 05:07:09'),
 (155,13,'2006-02-15 05:07:09'),
 (156,6,'2006-02-15 05:07:09'),
 (157,3,'2006-02-15 05:07:09'),
 (158,12,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (159,5,'2006-02-15 05:07:09'),
 (160,2,'2006-02-15 05:07:09'),
 (161,12,'2006-02-15 05:07:09'),
 (162,1,'2006-02-15 05:07:09'),
 (163,13,'2006-02-15 05:07:09'),
 (164,6,'2006-02-15 05:07:09'),
 (165,14,'2006-02-15 05:07:09'),
 (166,4,'2006-02-15 05:07:09'),
 (167,16,'2006-02-15 05:07:09'),
 (168,3,'2006-02-15 05:07:09'),
 (169,16,'2006-02-15 05:07:09'),
 (170,9,'2006-02-15 05:07:09'),
 (171,11,'2006-02-15 05:07:09'),
 (172,7,'2006-02-15 05:07:09'),
 (173,7,'2006-02-15 05:07:09'),
 (174,12,'2006-02-15 05:07:09'),
 (175,8,'2006-02-15 05:07:09'),
 (176,15,'2006-02-15 05:07:09'),
 (177,14,'2006-02-15 05:07:09'),
 (178,5,'2006-02-15 05:07:09'),
 (179,7,'2006-02-15 05:07:09'),
 (180,4,'2006-02-15 05:07:09'),
 (181,16,'2006-02-15 05:07:09'),
 (182,5,'2006-02-15 05:07:09'),
 (183,8,'2006-02-15 05:07:09'),
 (184,4,'2006-02-15 05:07:09'),
 (185,9,'2006-02-15 05:07:09'),
 (186,7,'2006-02-15 05:07:09'),
 (187,15,'2006-02-15 05:07:09'),
 (188,5,'2006-02-15 05:07:09'),
 (189,10,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (190,4,'2006-02-15 05:07:09'),
 (191,3,'2006-02-15 05:07:09'),
 (192,9,'2006-02-15 05:07:09'),
 (193,2,'2006-02-15 05:07:09'),
 (194,1,'2006-02-15 05:07:09'),
 (195,14,'2006-02-15 05:07:09'),
 (196,4,'2006-02-15 05:07:09'),
 (197,15,'2006-02-15 05:07:09'),
 (198,9,'2006-02-15 05:07:09'),
 (199,6,'2006-02-15 05:07:09'),
 (200,10,'2006-02-15 05:07:09'),
 (201,9,'2006-02-15 05:07:09'),
 (202,5,'2006-02-15 05:07:09'),
 (203,14,'2006-02-15 05:07:09'),
 (204,7,'2006-02-15 05:07:09'),
 (205,1,'2006-02-15 05:07:09'),
 (206,6,'2006-02-15 05:07:09'),
 (207,9,'2006-02-15 05:07:09'),
 (208,2,'2006-02-15 05:07:09'),
 (209,7,'2006-02-15 05:07:09'),
 (210,1,'2006-02-15 05:07:09'),
 (211,10,'2006-02-15 05:07:09'),
 (212,1,'2006-02-15 05:07:09'),
 (213,8,'2006-02-15 05:07:09'),
 (214,3,'2006-02-15 05:07:09'),
 (215,10,'2006-02-15 05:07:09'),
 (216,13,'2006-02-15 05:07:09'),
 (217,10,'2006-02-15 05:07:09'),
 (218,7,'2006-02-15 05:07:09'),
 (219,6,'2006-02-15 05:07:09'),
 (220,12,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (221,6,'2006-02-15 05:07:09'),
 (222,11,'2006-02-15 05:07:09'),
 (223,2,'2006-02-15 05:07:09'),
 (224,16,'2006-02-15 05:07:09'),
 (225,7,'2006-02-15 05:07:09'),
 (226,13,'2006-02-15 05:07:09'),
 (227,10,'2006-02-15 05:07:09'),
 (228,4,'2006-02-15 05:07:09'),
 (229,1,'2006-02-15 05:07:09'),
 (230,7,'2006-02-15 05:07:09'),
 (231,8,'2006-02-15 05:07:09'),
 (232,10,'2006-02-15 05:07:09'),
 (233,16,'2006-02-15 05:07:09'),
 (234,14,'2006-02-15 05:07:09'),
 (235,14,'2006-02-15 05:07:09'),
 (236,10,'2006-02-15 05:07:09'),
 (237,15,'2006-02-15 05:07:09'),
 (238,3,'2006-02-15 05:07:09'),
 (239,2,'2006-02-15 05:07:09'),
 (240,14,'2006-02-15 05:07:09'),
 (241,2,'2006-02-15 05:07:09'),
 (242,5,'2006-02-15 05:07:09'),
 (243,2,'2006-02-15 05:07:09'),
 (244,12,'2006-02-15 05:07:09'),
 (245,2,'2006-02-15 05:07:09'),
 (246,9,'2006-02-15 05:07:09'),
 (247,5,'2006-02-15 05:07:09'),
 (248,6,'2006-02-15 05:07:09'),
 (249,4,'2006-02-15 05:07:09'),
 (250,1,'2006-02-15 05:07:09'),
 (251,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (252,1,'2006-02-15 05:07:09'),
 (253,1,'2006-02-15 05:07:09'),
 (254,15,'2006-02-15 05:07:09'),
 (255,12,'2006-02-15 05:07:09'),
 (256,15,'2006-02-15 05:07:09'),
 (257,16,'2006-02-15 05:07:09'),
 (258,11,'2006-02-15 05:07:09'),
 (259,2,'2006-02-15 05:07:09'),
 (260,15,'2006-02-15 05:07:09'),
 (261,6,'2006-02-15 05:07:09'),
 (262,8,'2006-02-15 05:07:09'),
 (263,15,'2006-02-15 05:07:09'),
 (264,10,'2006-02-15 05:07:09'),
 (265,5,'2006-02-15 05:07:09'),
 (266,4,'2006-02-15 05:07:09'),
 (267,13,'2006-02-15 05:07:09'),
 (268,2,'2006-02-15 05:07:09'),
 (269,8,'2006-02-15 05:07:09'),
 (270,13,'2006-02-15 05:07:09'),
 (271,1,'2006-02-15 05:07:09'),
 (272,7,'2006-02-15 05:07:09'),
 (273,8,'2006-02-15 05:07:09'),
 (274,6,'2006-02-15 05:07:09'),
 (275,11,'2006-02-15 05:07:09'),
 (276,5,'2006-02-15 05:07:09'),
 (277,11,'2006-02-15 05:07:09'),
 (278,12,'2006-02-15 05:07:09'),
 (279,15,'2006-02-15 05:07:09'),
 (280,3,'2006-02-15 05:07:09'),
 (281,10,'2006-02-15 05:07:09'),
 (282,7,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (283,13,'2006-02-15 05:07:09'),
 (284,12,'2006-02-15 05:07:09'),
 (285,14,'2006-02-15 05:07:09'),
 (286,16,'2006-02-15 05:07:09'),
 (287,1,'2006-02-15 05:07:09'),
 (288,16,'2006-02-15 05:07:09'),
 (289,13,'2006-02-15 05:07:09'),
 (290,9,'2006-02-15 05:07:09'),
 (291,15,'2006-02-15 05:07:09'),
 (292,1,'2006-02-15 05:07:09'),
 (293,15,'2006-02-15 05:07:09'),
 (294,16,'2006-02-15 05:07:09'),
 (295,6,'2006-02-15 05:07:09'),
 (296,14,'2006-02-15 05:07:09'),
 (297,4,'2006-02-15 05:07:09'),
 (298,14,'2006-02-15 05:07:09'),
 (299,16,'2006-02-15 05:07:09'),
 (300,2,'2006-02-15 05:07:09'),
 (301,11,'2006-02-15 05:07:09'),
 (302,10,'2006-02-15 05:07:09'),
 (303,1,'2006-02-15 05:07:09'),
 (304,3,'2006-02-15 05:07:09'),
 (305,13,'2006-02-15 05:07:09'),
 (306,10,'2006-02-15 05:07:09'),
 (307,16,'2006-02-15 05:07:09'),
 (308,5,'2006-02-15 05:07:09'),
 (309,8,'2006-02-15 05:07:09'),
 (310,10,'2006-02-15 05:07:09'),
 (311,9,'2006-02-15 05:07:09'),
 (312,14,'2006-02-15 05:07:09'),
 (313,11,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (314,2,'2006-02-15 05:07:09'),
 (315,8,'2006-02-15 05:07:09'),
 (316,10,'2006-02-15 05:07:09'),
 (317,5,'2006-02-15 05:07:09'),
 (318,1,'2006-02-15 05:07:09'),
 (319,14,'2006-02-15 05:07:09'),
 (320,13,'2006-02-15 05:07:09'),
 (321,13,'2006-02-15 05:07:09'),
 (322,15,'2006-02-15 05:07:09'),
 (323,15,'2006-02-15 05:07:09'),
 (324,5,'2006-02-15 05:07:09'),
 (325,2,'2006-02-15 05:07:09'),
 (326,2,'2006-02-15 05:07:09'),
 (327,1,'2006-02-15 05:07:09'),
 (328,3,'2006-02-15 05:07:09'),
 (329,1,'2006-02-15 05:07:09'),
 (330,2,'2006-02-15 05:07:09'),
 (331,10,'2006-02-15 05:07:09'),
 (332,5,'2006-02-15 05:07:09'),
 (333,12,'2006-02-15 05:07:09'),
 (334,11,'2006-02-15 05:07:09'),
 (335,5,'2006-02-15 05:07:09'),
 (336,6,'2006-02-15 05:07:09'),
 (337,9,'2006-02-15 05:07:09'),
 (338,14,'2006-02-15 05:07:09'),
 (339,16,'2006-02-15 05:07:09'),
 (340,13,'2006-02-15 05:07:09'),
 (341,4,'2006-02-15 05:07:09'),
 (342,16,'2006-02-15 05:07:09'),
 (343,3,'2006-02-15 05:07:09'),
 (344,3,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (345,8,'2006-02-15 05:07:09'),
 (346,4,'2006-02-15 05:07:09'),
 (347,16,'2006-02-15 05:07:09'),
 (348,8,'2006-02-15 05:07:09'),
 (349,2,'2006-02-15 05:07:09'),
 (350,14,'2006-02-15 05:07:09'),
 (351,11,'2006-02-15 05:07:09'),
 (352,10,'2006-02-15 05:07:09'),
 (353,9,'2006-02-15 05:07:09'),
 (354,3,'2006-02-15 05:07:09'),
 (355,2,'2006-02-15 05:07:09'),
 (356,3,'2006-02-15 05:07:09'),
 (357,4,'2006-02-15 05:07:09'),
 (358,4,'2006-02-15 05:07:09'),
 (359,8,'2006-02-15 05:07:09'),
 (360,1,'2006-02-15 05:07:09'),
 (361,15,'2006-02-15 05:07:09'),
 (362,10,'2006-02-15 05:07:09'),
 (363,12,'2006-02-15 05:07:09'),
 (364,13,'2006-02-15 05:07:09'),
 (365,5,'2006-02-15 05:07:09'),
 (366,7,'2006-02-15 05:07:09'),
 (367,14,'2006-02-15 05:07:09'),
 (368,7,'2006-02-15 05:07:09'),
 (369,14,'2006-02-15 05:07:09'),
 (370,3,'2006-02-15 05:07:09'),
 (371,1,'2006-02-15 05:07:09'),
 (372,15,'2006-02-15 05:07:09'),
 (373,3,'2006-02-15 05:07:09'),
 (374,14,'2006-02-15 05:07:09'),
 (375,1,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (376,9,'2006-02-15 05:07:09'),
 (377,8,'2006-02-15 05:07:09'),
 (378,12,'2006-02-15 05:07:09'),
 (379,7,'2006-02-15 05:07:09'),
 (380,9,'2006-02-15 05:07:09'),
 (381,10,'2006-02-15 05:07:09'),
 (382,10,'2006-02-15 05:07:09'),
 (383,15,'2006-02-15 05:07:09'),
 (384,12,'2006-02-15 05:07:09'),
 (385,5,'2006-02-15 05:07:09'),
 (386,16,'2006-02-15 05:07:09'),
 (387,10,'2006-02-15 05:07:09'),
 (388,5,'2006-02-15 05:07:09'),
 (389,15,'2006-02-15 05:07:09'),
 (390,14,'2006-02-15 05:07:09'),
 (391,8,'2006-02-15 05:07:09'),
 (392,3,'2006-02-15 05:07:09'),
 (393,6,'2006-02-15 05:07:09'),
 (394,14,'2006-02-15 05:07:09'),
 (395,1,'2006-02-15 05:07:09'),
 (396,7,'2006-02-15 05:07:09'),
 (397,14,'2006-02-15 05:07:09'),
 (398,12,'2006-02-15 05:07:09'),
 (399,9,'2006-02-15 05:07:09'),
 (400,6,'2006-02-15 05:07:09'),
 (401,7,'2006-02-15 05:07:09'),
 (402,2,'2006-02-15 05:07:09'),
 (403,7,'2006-02-15 05:07:09'),
 (404,5,'2006-02-15 05:07:09'),
 (405,16,'2006-02-15 05:07:09'),
 (406,10,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (407,6,'2006-02-15 05:07:09'),
 (408,10,'2006-02-15 05:07:09'),
 (409,3,'2006-02-15 05:07:09'),
 (410,5,'2006-02-15 05:07:09'),
 (411,12,'2006-02-15 05:07:09'),
 (412,6,'2006-02-15 05:07:09'),
 (413,5,'2006-02-15 05:07:09'),
 (414,9,'2006-02-15 05:07:09'),
 (415,11,'2006-02-15 05:07:09'),
 (416,9,'2006-02-15 05:07:09'),
 (417,1,'2006-02-15 05:07:09'),
 (418,7,'2006-02-15 05:07:09'),
 (419,8,'2006-02-15 05:07:09'),
 (420,15,'2006-02-15 05:07:09'),
 (421,9,'2006-02-15 05:07:09'),
 (422,14,'2006-02-15 05:07:09'),
 (423,3,'2006-02-15 05:07:09'),
 (424,3,'2006-02-15 05:07:09'),
 (425,4,'2006-02-15 05:07:09'),
 (426,12,'2006-02-15 05:07:09'),
 (427,6,'2006-02-15 05:07:09'),
 (428,8,'2006-02-15 05:07:09'),
 (429,15,'2006-02-15 05:07:09'),
 (430,2,'2006-02-15 05:07:09'),
 (431,9,'2006-02-15 05:07:09'),
 (432,4,'2006-02-15 05:07:09'),
 (433,2,'2006-02-15 05:07:09'),
 (434,16,'2006-02-15 05:07:09'),
 (435,9,'2006-02-15 05:07:09'),
 (436,13,'2006-02-15 05:07:09'),
 (437,8,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (438,10,'2006-02-15 05:07:09'),
 (439,7,'2006-02-15 05:07:09'),
 (440,9,'2006-02-15 05:07:09'),
 (441,6,'2006-02-15 05:07:09'),
 (442,8,'2006-02-15 05:07:09'),
 (443,5,'2006-02-15 05:07:09'),
 (444,5,'2006-02-15 05:07:09'),
 (445,4,'2006-02-15 05:07:09'),
 (446,15,'2006-02-15 05:07:09'),
 (447,10,'2006-02-15 05:07:09'),
 (448,13,'2006-02-15 05:07:09'),
 (449,14,'2006-02-15 05:07:09'),
 (450,3,'2006-02-15 05:07:09'),
 (451,16,'2006-02-15 05:07:09'),
 (452,9,'2006-02-15 05:07:09'),
 (453,15,'2006-02-15 05:07:09'),
 (454,12,'2006-02-15 05:07:09'),
 (455,9,'2006-02-15 05:07:09'),
 (456,2,'2006-02-15 05:07:09'),
 (457,6,'2006-02-15 05:07:09'),
 (458,8,'2006-02-15 05:07:09'),
 (459,9,'2006-02-15 05:07:09'),
 (460,9,'2006-02-15 05:07:09'),
 (461,2,'2006-02-15 05:07:09'),
 (462,12,'2006-02-15 05:07:09'),
 (463,15,'2006-02-15 05:07:09'),
 (464,2,'2006-02-15 05:07:09'),
 (465,13,'2006-02-15 05:07:09'),
 (466,6,'2006-02-15 05:07:09'),
 (467,9,'2006-02-15 05:07:09'),
 (468,3,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (469,4,'2006-02-15 05:07:09'),
 (470,2,'2006-02-15 05:07:09'),
 (471,4,'2006-02-15 05:07:09'),
 (472,16,'2006-02-15 05:07:09'),
 (473,7,'2006-02-15 05:07:09'),
 (474,15,'2006-02-15 05:07:09'),
 (475,11,'2006-02-15 05:07:09'),
 (476,8,'2006-02-15 05:07:09'),
 (477,12,'2006-02-15 05:07:09'),
 (478,5,'2006-02-15 05:07:09'),
 (479,8,'2006-02-15 05:07:09'),
 (480,4,'2006-02-15 05:07:09'),
 (481,13,'2006-02-15 05:07:09'),
 (482,4,'2006-02-15 05:07:09'),
 (483,10,'2006-02-15 05:07:09'),
 (484,4,'2006-02-15 05:07:09'),
 (485,3,'2006-02-15 05:07:09'),
 (486,9,'2006-02-15 05:07:09'),
 (487,4,'2006-02-15 05:07:09'),
 (488,15,'2006-02-15 05:07:09'),
 (489,2,'2006-02-15 05:07:09'),
 (490,13,'2006-02-15 05:07:09'),
 (491,3,'2006-02-15 05:07:09'),
 (492,13,'2006-02-15 05:07:09'),
 (493,9,'2006-02-15 05:07:09'),
 (494,11,'2006-02-15 05:07:09'),
 (495,11,'2006-02-15 05:07:09'),
 (496,16,'2006-02-15 05:07:09'),
 (497,6,'2006-02-15 05:07:09'),
 (498,8,'2006-02-15 05:07:09'),
 (499,8,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (500,9,'2006-02-15 05:07:09'),
 (501,1,'2006-02-15 05:07:09'),
 (502,5,'2006-02-15 05:07:09'),
 (503,15,'2006-02-15 05:07:09'),
 (504,7,'2006-02-15 05:07:09'),
 (505,3,'2006-02-15 05:07:09'),
 (506,11,'2006-02-15 05:07:09'),
 (507,10,'2006-02-15 05:07:09'),
 (508,10,'2006-02-15 05:07:09'),
 (509,3,'2006-02-15 05:07:09'),
 (510,2,'2006-02-15 05:07:09'),
 (511,1,'2006-02-15 05:07:09'),
 (512,4,'2006-02-15 05:07:09'),
 (513,16,'2006-02-15 05:07:09'),
 (514,7,'2006-02-15 05:07:09'),
 (515,3,'2006-02-15 05:07:09'),
 (516,12,'2006-02-15 05:07:09'),
 (517,15,'2006-02-15 05:07:09'),
 (518,16,'2006-02-15 05:07:09'),
 (519,15,'2006-02-15 05:07:09'),
 (520,14,'2006-02-15 05:07:09'),
 (521,7,'2006-02-15 05:07:09'),
 (522,5,'2006-02-15 05:07:09'),
 (523,4,'2006-02-15 05:07:09'),
 (524,5,'2006-02-15 05:07:09'),
 (525,4,'2006-02-15 05:07:09'),
 (526,16,'2006-02-15 05:07:09'),
 (527,11,'2006-02-15 05:07:09'),
 (528,8,'2006-02-15 05:07:09'),
 (529,5,'2006-02-15 05:07:09'),
 (530,1,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (531,9,'2006-02-15 05:07:09'),
 (532,15,'2006-02-15 05:07:09'),
 (533,9,'2006-02-15 05:07:09'),
 (534,8,'2006-02-15 05:07:09'),
 (535,11,'2006-02-15 05:07:09'),
 (536,4,'2006-02-15 05:07:09'),
 (537,4,'2006-02-15 05:07:09'),
 (538,13,'2006-02-15 05:07:09'),
 (539,7,'2006-02-15 05:07:09'),
 (540,12,'2006-02-15 05:07:09'),
 (541,2,'2006-02-15 05:07:09'),
 (542,1,'2006-02-15 05:07:09'),
 (543,16,'2006-02-15 05:07:09'),
 (544,6,'2006-02-15 05:07:09'),
 (545,9,'2006-02-15 05:07:09'),
 (546,10,'2006-02-15 05:07:09'),
 (547,3,'2006-02-15 05:07:09'),
 (548,4,'2006-02-15 05:07:09'),
 (549,1,'2006-02-15 05:07:09'),
 (550,8,'2006-02-15 05:07:09'),
 (551,13,'2006-02-15 05:07:09'),
 (552,6,'2006-02-15 05:07:09'),
 (553,3,'2006-02-15 05:07:09'),
 (554,4,'2006-02-15 05:07:09'),
 (555,5,'2006-02-15 05:07:09'),
 (556,10,'2006-02-15 05:07:09'),
 (557,8,'2006-02-15 05:07:09'),
 (558,13,'2006-02-15 05:07:09'),
 (559,14,'2006-02-15 05:07:09'),
 (560,10,'2006-02-15 05:07:09'),
 (561,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (562,12,'2006-02-15 05:07:09'),
 (563,10,'2006-02-15 05:07:09'),
 (564,2,'2006-02-15 05:07:09'),
 (565,9,'2006-02-15 05:07:09'),
 (566,9,'2006-02-15 05:07:09'),
 (567,9,'2006-02-15 05:07:09'),
 (568,5,'2006-02-15 05:07:09'),
 (569,2,'2006-02-15 05:07:09'),
 (570,15,'2006-02-15 05:07:09'),
 (571,6,'2006-02-15 05:07:09'),
 (572,14,'2006-02-15 05:07:09'),
 (573,3,'2006-02-15 05:07:09'),
 (574,1,'2006-02-15 05:07:09'),
 (575,6,'2006-02-15 05:07:09'),
 (576,6,'2006-02-15 05:07:09'),
 (577,15,'2006-02-15 05:07:09'),
 (578,4,'2006-02-15 05:07:09'),
 (579,1,'2006-02-15 05:07:09'),
 (580,13,'2006-02-15 05:07:09'),
 (581,12,'2006-02-15 05:07:09'),
 (582,2,'2006-02-15 05:07:09'),
 (583,2,'2006-02-15 05:07:09'),
 (584,9,'2006-02-15 05:07:09'),
 (585,7,'2006-02-15 05:07:09'),
 (586,1,'2006-02-15 05:07:09'),
 (587,6,'2006-02-15 05:07:09'),
 (588,3,'2006-02-15 05:07:09'),
 (589,6,'2006-02-15 05:07:09'),
 (590,13,'2006-02-15 05:07:09'),
 (591,10,'2006-02-15 05:07:09'),
 (592,12,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (593,11,'2006-02-15 05:07:09'),
 (594,1,'2006-02-15 05:07:09'),
 (595,9,'2006-02-15 05:07:09'),
 (596,10,'2006-02-15 05:07:09'),
 (597,10,'2006-02-15 05:07:09'),
 (598,15,'2006-02-15 05:07:09'),
 (599,15,'2006-02-15 05:07:09'),
 (600,11,'2006-02-15 05:07:09'),
 (601,16,'2006-02-15 05:07:09'),
 (602,14,'2006-02-15 05:07:09'),
 (603,8,'2006-02-15 05:07:09'),
 (604,5,'2006-02-15 05:07:09'),
 (605,9,'2006-02-15 05:07:09'),
 (606,15,'2006-02-15 05:07:09'),
 (607,9,'2006-02-15 05:07:09'),
 (608,3,'2006-02-15 05:07:09'),
 (609,16,'2006-02-15 05:07:09'),
 (610,8,'2006-02-15 05:07:09'),
 (611,4,'2006-02-15 05:07:09'),
 (612,15,'2006-02-15 05:07:09'),
 (613,5,'2006-02-15 05:07:09'),
 (614,10,'2006-02-15 05:07:09'),
 (615,2,'2006-02-15 05:07:09'),
 (616,6,'2006-02-15 05:07:09'),
 (617,8,'2006-02-15 05:07:09'),
 (618,7,'2006-02-15 05:07:09'),
 (619,15,'2006-02-15 05:07:09'),
 (620,14,'2006-02-15 05:07:09'),
 (621,8,'2006-02-15 05:07:09'),
 (622,6,'2006-02-15 05:07:09'),
 (623,9,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (624,10,'2006-02-15 05:07:09'),
 (625,14,'2006-02-15 05:07:09'),
 (626,3,'2006-02-15 05:07:09'),
 (627,6,'2006-02-15 05:07:09'),
 (628,15,'2006-02-15 05:07:09'),
 (629,6,'2006-02-15 05:07:09'),
 (630,7,'2006-02-15 05:07:09'),
 (631,15,'2006-02-15 05:07:09'),
 (632,13,'2006-02-15 05:07:09'),
 (633,4,'2006-02-15 05:07:09'),
 (634,8,'2006-02-15 05:07:09'),
 (635,13,'2006-02-15 05:07:09'),
 (636,12,'2006-02-15 05:07:09'),
 (637,14,'2006-02-15 05:07:09'),
 (638,5,'2006-02-15 05:07:09'),
 (639,8,'2006-02-15 05:07:09'),
 (640,9,'2006-02-15 05:07:09'),
 (641,9,'2006-02-15 05:07:09'),
 (642,16,'2006-02-15 05:07:09'),
 (643,7,'2006-02-15 05:07:09'),
 (644,2,'2006-02-15 05:07:09'),
 (645,16,'2006-02-15 05:07:09'),
 (646,10,'2006-02-15 05:07:09'),
 (647,12,'2006-02-15 05:07:09'),
 (648,16,'2006-02-15 05:07:09'),
 (649,2,'2006-02-15 05:07:09'),
 (650,6,'2006-02-15 05:07:09'),
 (651,2,'2006-02-15 05:07:09'),
 (652,4,'2006-02-15 05:07:09'),
 (653,11,'2006-02-15 05:07:09'),
 (654,10,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (655,14,'2006-02-15 05:07:09'),
 (656,16,'2006-02-15 05:07:09'),
 (657,5,'2006-02-15 05:07:09'),
 (658,11,'2006-02-15 05:07:09'),
 (659,1,'2006-02-15 05:07:09'),
 (660,5,'2006-02-15 05:07:09'),
 (661,9,'2006-02-15 05:07:09'),
 (662,7,'2006-02-15 05:07:09'),
 (663,4,'2006-02-15 05:07:09'),
 (664,1,'2006-02-15 05:07:09'),
 (665,11,'2006-02-15 05:07:09'),
 (666,7,'2006-02-15 05:07:09'),
 (667,15,'2006-02-15 05:07:09'),
 (668,15,'2006-02-15 05:07:09'),
 (669,9,'2006-02-15 05:07:09'),
 (670,6,'2006-02-15 05:07:09'),
 (671,15,'2006-02-15 05:07:09'),
 (672,5,'2006-02-15 05:07:09'),
 (673,12,'2006-02-15 05:07:09'),
 (674,9,'2006-02-15 05:07:09'),
 (675,13,'2006-02-15 05:07:09'),
 (676,15,'2006-02-15 05:07:09'),
 (677,13,'2006-02-15 05:07:09'),
 (678,15,'2006-02-15 05:07:09'),
 (679,8,'2006-02-15 05:07:09'),
 (680,5,'2006-02-15 05:07:09'),
 (681,15,'2006-02-15 05:07:09'),
 (682,8,'2006-02-15 05:07:09'),
 (683,7,'2006-02-15 05:07:09'),
 (684,10,'2006-02-15 05:07:09'),
 (685,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (686,13,'2006-02-15 05:07:09'),
 (687,6,'2006-02-15 05:07:09'),
 (688,3,'2006-02-15 05:07:09'),
 (689,9,'2006-02-15 05:07:09'),
 (690,2,'2006-02-15 05:07:09'),
 (691,15,'2006-02-15 05:07:09'),
 (692,2,'2006-02-15 05:07:09'),
 (693,2,'2006-02-15 05:07:09'),
 (694,4,'2006-02-15 05:07:09'),
 (695,8,'2006-02-15 05:07:09'),
 (696,2,'2006-02-15 05:07:09'),
 (697,1,'2006-02-15 05:07:09'),
 (698,6,'2006-02-15 05:07:09'),
 (699,10,'2006-02-15 05:07:09'),
 (700,8,'2006-02-15 05:07:09'),
 (701,10,'2006-02-15 05:07:09'),
 (702,11,'2006-02-15 05:07:09'),
 (703,2,'2006-02-15 05:07:09'),
 (704,5,'2006-02-15 05:07:09'),
 (705,9,'2006-02-15 05:07:09'),
 (706,7,'2006-02-15 05:07:09'),
 (707,1,'2006-02-15 05:07:09'),
 (708,6,'2006-02-15 05:07:09'),
 (709,7,'2006-02-15 05:07:09'),
 (710,8,'2006-02-15 05:07:09'),
 (711,14,'2006-02-15 05:07:09'),
 (712,6,'2006-02-15 05:07:09'),
 (713,6,'2006-02-15 05:07:09'),
 (714,14,'2006-02-15 05:07:09'),
 (715,8,'2006-02-15 05:07:09'),
 (716,11,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (717,1,'2006-02-15 05:07:09'),
 (718,12,'2006-02-15 05:07:09'),
 (719,15,'2006-02-15 05:07:09'),
 (720,13,'2006-02-15 05:07:09'),
 (721,12,'2006-02-15 05:07:09'),
 (722,11,'2006-02-15 05:07:09'),
 (723,14,'2006-02-15 05:07:09'),
 (724,8,'2006-02-15 05:07:09'),
 (725,4,'2006-02-15 05:07:09'),
 (726,9,'2006-02-15 05:07:09'),
 (727,8,'2006-02-15 05:07:09'),
 (728,7,'2006-02-15 05:07:09'),
 (729,15,'2006-02-15 05:07:09'),
 (730,13,'2006-02-15 05:07:09'),
 (731,4,'2006-02-15 05:07:09'),
 (732,1,'2006-02-15 05:07:09'),
 (733,15,'2006-02-15 05:07:09'),
 (734,6,'2006-02-15 05:07:09'),
 (735,3,'2006-02-15 05:07:09'),
 (736,8,'2006-02-15 05:07:09'),
 (737,11,'2006-02-15 05:07:09'),
 (738,9,'2006-02-15 05:07:09'),
 (739,7,'2006-02-15 05:07:09'),
 (740,11,'2006-02-15 05:07:09'),
 (741,12,'2006-02-15 05:07:09'),
 (742,10,'2006-02-15 05:07:09'),
 (743,2,'2006-02-15 05:07:09'),
 (744,4,'2006-02-15 05:07:09'),
 (745,15,'2006-02-15 05:07:09'),
 (746,10,'2006-02-15 05:07:09'),
 (747,10,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (748,1,'2006-02-15 05:07:09'),
 (749,11,'2006-02-15 05:07:09'),
 (750,13,'2006-02-15 05:07:09'),
 (751,13,'2006-02-15 05:07:09'),
 (752,12,'2006-02-15 05:07:09'),
 (753,8,'2006-02-15 05:07:09'),
 (754,5,'2006-02-15 05:07:09'),
 (755,3,'2006-02-15 05:07:09'),
 (756,5,'2006-02-15 05:07:09'),
 (757,6,'2006-02-15 05:07:09'),
 (758,7,'2006-02-15 05:07:09'),
 (759,13,'2006-02-15 05:07:09'),
 (760,13,'2006-02-15 05:07:09'),
 (761,3,'2006-02-15 05:07:09'),
 (762,10,'2006-02-15 05:07:09'),
 (763,15,'2006-02-15 05:07:09'),
 (764,15,'2006-02-15 05:07:09'),
 (765,5,'2006-02-15 05:07:09'),
 (766,7,'2006-02-15 05:07:09'),
 (767,12,'2006-02-15 05:07:09'),
 (768,3,'2006-02-15 05:07:09'),
 (769,9,'2006-02-15 05:07:09'),
 (770,9,'2006-02-15 05:07:09'),
 (771,7,'2006-02-15 05:07:09'),
 (772,7,'2006-02-15 05:07:09'),
 (773,15,'2006-02-15 05:07:09'),
 (774,5,'2006-02-15 05:07:09'),
 (775,7,'2006-02-15 05:07:09'),
 (776,6,'2006-02-15 05:07:09'),
 (777,15,'2006-02-15 05:07:09'),
 (778,8,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (779,15,'2006-02-15 05:07:09'),
 (780,8,'2006-02-15 05:07:09'),
 (781,10,'2006-02-15 05:07:09'),
 (782,15,'2006-02-15 05:07:09'),
 (783,16,'2006-02-15 05:07:09'),
 (784,16,'2006-02-15 05:07:09'),
 (785,16,'2006-02-15 05:07:09'),
 (786,3,'2006-02-15 05:07:09'),
 (787,16,'2006-02-15 05:07:09'),
 (788,6,'2006-02-15 05:07:09'),
 (789,9,'2006-02-15 05:07:09'),
 (790,7,'2006-02-15 05:07:09'),
 (791,6,'2006-02-15 05:07:09'),
 (792,9,'2006-02-15 05:07:09'),
 (793,1,'2006-02-15 05:07:09'),
 (794,1,'2006-02-15 05:07:09'),
 (795,8,'2006-02-15 05:07:09'),
 (796,15,'2006-02-15 05:07:09'),
 (797,12,'2006-02-15 05:07:09'),
 (798,14,'2006-02-15 05:07:09'),
 (799,11,'2006-02-15 05:07:09'),
 (800,11,'2006-02-15 05:07:09'),
 (801,3,'2006-02-15 05:07:09'),
 (802,1,'2006-02-15 05:07:09'),
 (803,7,'2006-02-15 05:07:09'),
 (804,11,'2006-02-15 05:07:09'),
 (805,2,'2006-02-15 05:07:09'),
 (806,13,'2006-02-15 05:07:09'),
 (807,10,'2006-02-15 05:07:09'),
 (808,4,'2006-02-15 05:07:09'),
 (809,15,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (810,8,'2006-02-15 05:07:09'),
 (811,16,'2006-02-15 05:07:09'),
 (812,6,'2006-02-15 05:07:09'),
 (813,15,'2006-02-15 05:07:09'),
 (814,5,'2006-02-15 05:07:09'),
 (815,4,'2006-02-15 05:07:09'),
 (816,2,'2006-02-15 05:07:09'),
 (817,14,'2006-02-15 05:07:09'),
 (818,7,'2006-02-15 05:07:09'),
 (819,12,'2006-02-15 05:07:09'),
 (820,2,'2006-02-15 05:07:09'),
 (821,9,'2006-02-15 05:07:09'),
 (822,8,'2006-02-15 05:07:09'),
 (823,1,'2006-02-15 05:07:09'),
 (824,8,'2006-02-15 05:07:09'),
 (825,1,'2006-02-15 05:07:09'),
 (826,16,'2006-02-15 05:07:09'),
 (827,7,'2006-02-15 05:07:09'),
 (828,4,'2006-02-15 05:07:09'),
 (829,8,'2006-02-15 05:07:09'),
 (830,11,'2006-02-15 05:07:09'),
 (831,14,'2006-02-15 05:07:09'),
 (832,8,'2006-02-15 05:07:09'),
 (833,3,'2006-02-15 05:07:09'),
 (834,6,'2006-02-15 05:07:09'),
 (835,10,'2006-02-15 05:07:09'),
 (836,15,'2006-02-15 05:07:09'),
 (837,5,'2006-02-15 05:07:09'),
 (838,1,'2006-02-15 05:07:09'),
 (839,14,'2006-02-15 05:07:09'),
 (840,10,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (841,15,'2006-02-15 05:07:09'),
 (842,10,'2006-02-15 05:07:09'),
 (843,4,'2006-02-15 05:07:09'),
 (844,15,'2006-02-15 05:07:09'),
 (845,9,'2006-02-15 05:07:09'),
 (846,13,'2006-02-15 05:07:09'),
 (847,13,'2006-02-15 05:07:09'),
 (848,16,'2006-02-15 05:07:09'),
 (849,2,'2006-02-15 05:07:09'),
 (850,1,'2006-02-15 05:07:09'),
 (851,15,'2006-02-15 05:07:09'),
 (852,3,'2006-02-15 05:07:09'),
 (853,3,'2006-02-15 05:07:09'),
 (854,11,'2006-02-15 05:07:09'),
 (855,6,'2006-02-15 05:07:09'),
 (856,11,'2006-02-15 05:07:09'),
 (857,5,'2006-02-15 05:07:09'),
 (858,5,'2006-02-15 05:07:09'),
 (859,2,'2006-02-15 05:07:09'),
 (860,14,'2006-02-15 05:07:09'),
 (861,10,'2006-02-15 05:07:09'),
 (862,4,'2006-02-15 05:07:09'),
 (863,14,'2006-02-15 05:07:09'),
 (864,3,'2006-02-15 05:07:09'),
 (865,2,'2006-02-15 05:07:09'),
 (866,8,'2006-02-15 05:07:09'),
 (867,8,'2006-02-15 05:07:09'),
 (868,16,'2006-02-15 05:07:09'),
 (869,1,'2006-02-15 05:07:09'),
 (870,11,'2006-02-15 05:07:09'),
 (871,5,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (872,16,'2006-02-15 05:07:09'),
 (873,3,'2006-02-15 05:07:09'),
 (874,4,'2006-02-15 05:07:09'),
 (875,15,'2006-02-15 05:07:09'),
 (876,11,'2006-02-15 05:07:09'),
 (877,12,'2006-02-15 05:07:09'),
 (878,16,'2006-02-15 05:07:09'),
 (879,12,'2006-02-15 05:07:09'),
 (880,2,'2006-02-15 05:07:09'),
 (881,11,'2006-02-15 05:07:09'),
 (882,7,'2006-02-15 05:07:09'),
 (883,3,'2006-02-15 05:07:09'),
 (884,12,'2006-02-15 05:07:09'),
 (885,11,'2006-02-15 05:07:09'),
 (886,2,'2006-02-15 05:07:09'),
 (887,2,'2006-02-15 05:07:09'),
 (888,6,'2006-02-15 05:07:09'),
 (889,3,'2006-02-15 05:07:09'),
 (890,15,'2006-02-15 05:07:09'),
 (891,4,'2006-02-15 05:07:09'),
 (892,2,'2006-02-15 05:07:09'),
 (893,14,'2006-02-15 05:07:09'),
 (894,16,'2006-02-15 05:07:09'),
 (895,4,'2006-02-15 05:07:09'),
 (896,3,'2006-02-15 05:07:09'),
 (897,7,'2006-02-15 05:07:09'),
 (898,15,'2006-02-15 05:07:09'),
 (899,4,'2006-02-15 05:07:09'),
 (900,9,'2006-02-15 05:07:09'),
 (901,2,'2006-02-15 05:07:09'),
 (902,15,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (903,16,'2006-02-15 05:07:09'),
 (904,11,'2006-02-15 05:07:09'),
 (905,5,'2006-02-15 05:07:09'),
 (906,5,'2006-02-15 05:07:09'),
 (907,7,'2006-02-15 05:07:09'),
 (908,9,'2006-02-15 05:07:09'),
 (909,11,'2006-02-15 05:07:09'),
 (910,7,'2006-02-15 05:07:09'),
 (911,1,'2006-02-15 05:07:09'),
 (912,14,'2006-02-15 05:07:09'),
 (913,13,'2006-02-15 05:07:09'),
 (914,16,'2006-02-15 05:07:09'),
 (915,1,'2006-02-15 05:07:09'),
 (916,2,'2006-02-15 05:07:09'),
 (917,15,'2006-02-15 05:07:09'),
 (918,3,'2006-02-15 05:07:09'),
 (919,10,'2006-02-15 05:07:09'),
 (920,13,'2006-02-15 05:07:09'),
 (921,12,'2006-02-15 05:07:09'),
 (922,11,'2006-02-15 05:07:09'),
 (923,7,'2006-02-15 05:07:09'),
 (924,14,'2006-02-15 05:07:09'),
 (925,6,'2006-02-15 05:07:09'),
 (926,6,'2006-02-15 05:07:09'),
 (927,1,'2006-02-15 05:07:09'),
 (928,3,'2006-02-15 05:07:09'),
 (929,9,'2006-02-15 05:07:09'),
 (930,14,'2006-02-15 05:07:09'),
 (931,16,'2006-02-15 05:07:09'),
 (932,5,'2006-02-15 05:07:09'),
 (933,13,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (934,10,'2006-02-15 05:07:09'),
 (935,13,'2006-02-15 05:07:09'),
 (936,12,'2006-02-15 05:07:09'),
 (937,13,'2006-02-15 05:07:09'),
 (938,5,'2006-02-15 05:07:09'),
 (939,5,'2006-02-15 05:07:09'),
 (940,15,'2006-02-15 05:07:09'),
 (941,10,'2006-02-15 05:07:09'),
 (942,7,'2006-02-15 05:07:09'),
 (943,6,'2006-02-15 05:07:09'),
 (944,7,'2006-02-15 05:07:09'),
 (945,6,'2006-02-15 05:07:09'),
 (946,8,'2006-02-15 05:07:09'),
 (947,9,'2006-02-15 05:07:09'),
 (948,13,'2006-02-15 05:07:09'),
 (949,10,'2006-02-15 05:07:09'),
 (950,4,'2006-02-15 05:07:09'),
 (951,4,'2006-02-15 05:07:09'),
 (952,6,'2006-02-15 05:07:09'),
 (953,2,'2006-02-15 05:07:09'),
 (954,13,'2006-02-15 05:07:09'),
 (955,3,'2006-02-15 05:07:09'),
 (956,10,'2006-02-15 05:07:09'),
 (957,9,'2006-02-15 05:07:09'),
 (958,7,'2006-02-15 05:07:09'),
 (959,3,'2006-02-15 05:07:09'),
 (960,6,'2006-02-15 05:07:09'),
 (961,9,'2006-02-15 05:07:09'),
 (962,4,'2006-02-15 05:07:09'),
 (963,2,'2006-02-15 05:07:09'),
 (964,1,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (965,11,'2006-02-15 05:07:09'),
 (966,6,'2006-02-15 05:07:09'),
 (967,14,'2006-02-15 05:07:09'),
 (968,1,'2006-02-15 05:07:09'),
 (969,7,'2006-02-15 05:07:09'),
 (970,4,'2006-02-15 05:07:09'),
 (971,9,'2006-02-15 05:07:09'),
 (972,14,'2006-02-15 05:07:09'),
 (973,6,'2006-02-15 05:07:09'),
 (974,13,'2006-02-15 05:07:09'),
 (975,8,'2006-02-15 05:07:09'),
 (976,10,'2006-02-15 05:07:09'),
 (977,16,'2006-02-15 05:07:09'),
 (978,5,'2006-02-15 05:07:09'),
 (979,7,'2006-02-15 05:07:09'),
 (980,12,'2006-02-15 05:07:09'),
 (981,16,'2006-02-15 05:07:09'),
 (982,1,'2006-02-15 05:07:09'),
 (983,12,'2006-02-15 05:07:09'),
 (984,9,'2006-02-15 05:07:09'),
 (985,14,'2006-02-15 05:07:09'),
 (986,2,'2006-02-15 05:07:09'),
 (987,12,'2006-02-15 05:07:09'),
 (988,16,'2006-02-15 05:07:09'),
 (989,16,'2006-02-15 05:07:09'),
 (990,11,'2006-02-15 05:07:09'),
 (991,1,'2006-02-15 05:07:09'),
 (992,6,'2006-02-15 05:07:09'),
 (993,3,'2006-02-15 05:07:09'),
 (994,13,'2006-02-15 05:07:09'),
 (995,11,'2006-02-15 05:07:09');
INSERT INTO `sakila`.`film_category` VALUES  (996,6,'2006-02-15 05:07:09'),
 (997,12,'2006-02-15 05:07:09'),
 (998,11,'2006-02-15 05:07:09'),
 (999,3,'2006-02-15 05:07:09'),
 (1000,5,'2006-02-15 05:07:09');
COMMIT;

--
-- Definition of table `sakila`.`film_text`
--

DROP TABLE IF EXISTS `sakila`.`film_text`;
CREATE TABLE  `sakila`.`film_text` (
  `film_id` smallint(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`film_id`),
  FULLTEXT KEY `idx_title_description` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`film_text`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`film_text` VALUES  (1,'ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies'),
 (2,'ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China'),
 (3,'ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory'),
 (4,'AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank'),
 (5,'AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico'),
 (6,'AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China'),
 (7,'AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat'),
 (8,'AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India'),
 (9,'ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat'),
 (10,'ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (11,'ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention'),
 (12,'ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia'),
 (13,'ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies'),
 (14,'ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia'),
 (15,'ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention'),
 (16,'ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans'),
 (17,'ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House'),
 (18,'ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies'),
 (19,'AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (20,'AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon'),
 (21,'AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank'),
 (22,'AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California'),
 (23,'ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia'),
 (24,'ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert'),
 (25,'ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin'),
 (26,'ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park'),
 (27,'ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank'),
 (28,'ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park');
INSERT INTO `sakila`.`film_text` VALUES  (29,'ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India'),
 (30,'ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House'),
 (31,'APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat'),
 (32,'APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park'),
 (33,'APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft'),
 (34,'ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria'),
 (35,'ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station'),
 (36,'ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft'),
 (37,'ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery');
INSERT INTO `sakila`.`film_text` VALUES  (38,'ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert'),
 (39,'ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft'),
 (40,'ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria'),
 (41,'ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin'),
 (42,'ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California'),
 (43,'ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank'),
 (44,'ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft'),
 (45,'ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan'),
 (46,'AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (47,'BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft'),
 (48,'BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery'),
 (49,'BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat'),
 (50,'BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery'),
 (51,'BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station'),
 (52,'BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California'),
 (53,'BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park'),
 (54,'BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station'),
 (55,'BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery');
INSERT INTO `sakila`.`film_text` VALUES  (56,'BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park'),
 (57,'BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat'),
 (58,'BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia'),
 (59,'BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station'),
 (60,'BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China'),
 (61,'BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft'),
 (62,'BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House'),
 (63,'BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House'),
 (64,'BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (65,'BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin'),
 (66,'BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station'),
 (67,'BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China'),
 (68,'BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank'),
 (69,'BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station'),
 (70,'BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station'),
 (71,'BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station'),
 (72,'BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention'),
 (73,'BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria');
INSERT INTO `sakila`.`film_text` VALUES  (74,'BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon'),
 (75,'BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies'),
 (76,'BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India'),
 (77,'BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California'),
 (78,'BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan'),
 (79,'BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station'),
 (80,'BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria'),
 (81,'BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat'),
 (82,'BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse'),
 (83,'BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House');
INSERT INTO `sakila`.`film_text` VALUES  (84,'BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan'),
 (85,'BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan'),
 (86,'BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico'),
 (87,'BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico'),
 (88,'BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria'),
 (89,'BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House'),
 (90,'BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China'),
 (91,'BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon'),
 (92,'BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California');
INSERT INTO `sakila`.`film_text` VALUES  (93,'BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin'),
 (94,'BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin'),
 (95,'BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin'),
 (96,'BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft'),
 (97,'BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans'),
 (98,'BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat'),
 (99,'BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat'),
 (100,'BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station'),
 (101,'BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan'),
 (102,'BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (103,'BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory'),
 (104,'BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station'),
 (105,'BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies'),
 (106,'BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback'),
 (107,'BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention'),
 (108,'BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans'),
 (109,'BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank'),
 (110,'CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory'),
 (111,'CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia');
INSERT INTO `sakila`.`film_text` VALUES  (112,'CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria'),
 (113,'CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India'),
 (114,'CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention'),
 (115,'CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat'),
 (116,'CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station'),
 (117,'CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House'),
 (118,'CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse'),
 (119,'CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention'),
 (120,'CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank');
INSERT INTO `sakila`.`film_text` VALUES  (121,'CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery'),
 (122,'CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies'),
 (123,'CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station'),
 (124,'CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert'),
 (125,'CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans'),
 (126,'CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery'),
 (127,'CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India'),
 (128,'CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria'),
 (129,'CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention');
INSERT INTO `sakila`.`film_text` VALUES  (130,'CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank'),
 (131,'CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California'),
 (132,'CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia'),
 (133,'CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria'),
 (134,'CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery'),
 (135,'CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China'),
 (136,'CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India'),
 (137,'CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention'),
 (138,'CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (139,'CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank'),
 (140,'CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan'),
 (141,'CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California'),
 (142,'CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia'),
 (143,'CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies'),
 (144,'CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India'),
 (145,'CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India'),
 (146,'CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station'),
 (147,'CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan');
INSERT INTO `sakila`.`film_text` VALUES  (148,'CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China'),
 (149,'CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse'),
 (150,'CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia'),
 (151,'CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin'),
 (152,'CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon'),
 (153,'CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback'),
 (154,'CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia'),
 (155,'CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon'),
 (156,'CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (157,'CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon'),
 (158,'CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans'),
 (159,'CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India'),
 (160,'CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat'),
 (161,'CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China'),
 (162,'CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House'),
 (163,'CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat'),
 (164,'COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert'),
 (165,'COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico'),
 (166,'COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (167,'COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California'),
 (168,'COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico'),
 (169,'COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft'),
 (170,'COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan'),
 (171,'COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft'),
 (172,'CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria'),
 (173,'CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon'),
 (174,'CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan'),
 (175,'CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (176,'CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon'),
 (177,'CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank'),
 (178,'CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station'),
 (179,'CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft'),
 (180,'CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft'),
 (181,'CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India'),
 (182,'CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery'),
 (183,'CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention'),
 (184,'CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse');
INSERT INTO `sakila`.`film_text` VALUES  (185,'COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon'),
 (186,'CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory'),
 (187,'CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory'),
 (188,'CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback'),
 (189,'CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India'),
 (190,'CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat'),
 (191,'CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park'),
 (192,'CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin'),
 (193,'CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback');
INSERT INTO `sakila`.`film_text` VALUES  (194,'CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station'),
 (195,'CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House'),
 (196,'CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria'),
 (197,'CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park'),
 (198,'CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan'),
 (199,'CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park'),
 (200,'CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank'),
 (201,'CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention'),
 (202,'DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (203,'DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India'),
 (204,'DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse'),
 (205,'DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park'),
 (206,'DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank'),
 (207,'DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California'),
 (208,'DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans'),
 (209,'DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert'),
 (210,'DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans'),
 (211,'DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico'),
 (212,'DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (213,'DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention'),
 (214,'DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station'),
 (215,'DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin'),
 (216,'DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat'),
 (217,'DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park'),
 (218,'DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India'),
 (219,'DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia'),
 (220,'DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia'),
 (221,'DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank');
INSERT INTO `sakila`.`film_text` VALUES  (222,'DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans'),
 (223,'DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station'),
 (224,'DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California'),
 (225,'DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat'),
 (226,'DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia'),
 (227,'DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat'),
 (228,'DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan'),
 (229,'DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan'),
 (230,'DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India');
INSERT INTO `sakila`.`film_text` VALUES  (231,'DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies'),
 (232,'DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback'),
 (233,'DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank'),
 (234,'DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat'),
 (235,'DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery'),
 (236,'DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park'),
 (237,'DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India'),
 (238,'DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback'),
 (239,'DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans');
INSERT INTO `sakila`.`film_text` VALUES  (240,'DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback'),
 (241,'DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan'),
 (242,'DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention'),
 (243,'DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico'),
 (244,'DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California'),
 (245,'DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico'),
 (246,'DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert'),
 (247,'DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert'),
 (248,'DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies');
INSERT INTO `sakila`.`film_text` VALUES  (249,'DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House'),
 (250,'DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China'),
 (251,'DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria'),
 (252,'DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico'),
 (253,'DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat'),
 (254,'DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House'),
 (255,'DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft'),
 (256,'DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China'),
 (257,'DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies');
INSERT INTO `sakila`.`film_text` VALUES  (258,'DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park'),
 (259,'DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank'),
 (260,'DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House'),
 (261,'DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention'),
 (262,'DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico'),
 (263,'DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft'),
 (264,'DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan'),
 (265,'DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California'),
 (266,'DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat'),
 (267,'EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (268,'EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback'),
 (269,'EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria'),
 (270,'EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India'),
 (271,'EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India'),
 (272,'EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat'),
 (273,'EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse'),
 (274,'EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station'),
 (275,'EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park'),
 (276,'ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (277,'ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon'),
 (278,'ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft'),
 (279,'ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan'),
 (280,'EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House'),
 (281,'ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon'),
 (282,'ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans'),
 (283,'ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin'),
 (284,'ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India'),
 (285,'ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China'),
 (286,'ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (287,'ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat'),
 (288,'ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans'),
 (289,'EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon'),
 (290,'EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria'),
 (291,'EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory'),
 (292,'EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank'),
 (293,'EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin'),
 (294,'EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat'),
 (295,'EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat'),
 (296,'EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California');
INSERT INTO `sakila`.`film_text` VALUES  (297,'EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin'),
 (298,'EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback'),
 (299,'FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert'),
 (300,'FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans'),
 (301,'FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin'),
 (302,'FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia'),
 (303,'FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention'),
 (304,'FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback'),
 (305,'FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan'),
 (306,'FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia');
INSERT INTO `sakila`.`film_text` VALUES  (307,'FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon'),
 (308,'FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico'),
 (309,'FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies'),
 (310,'FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico'),
 (311,'FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft'),
 (312,'FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico'),
 (313,'FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat'),
 (314,'FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse'),
 (315,'FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans');
INSERT INTO `sakila`.`film_text` VALUES  (316,'FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria'),
 (317,'FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft'),
 (318,'FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert'),
 (319,'FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia'),
 (320,'FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert'),
 (321,'FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico'),
 (322,'FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft'),
 (323,'FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans'),
 (324,'FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California');
INSERT INTO `sakila`.`film_text` VALUES  (325,'FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan'),
 (326,'FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria'),
 (327,'FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat'),
 (328,'FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat'),
 (329,'FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat'),
 (330,'FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria'),
 (331,'FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans'),
 (332,'FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria'),
 (333,'FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (334,'FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback'),
 (335,'FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon'),
 (336,'FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin'),
 (337,'FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft'),
 (338,'FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank'),
 (339,'FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia'),
 (340,'FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House'),
 (341,'FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention'),
 (342,'FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia'),
 (343,'FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank');
INSERT INTO `sakila`.`film_text` VALUES  (344,'FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery'),
 (345,'GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory'),
 (346,'GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin'),
 (347,'GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery'),
 (348,'GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin'),
 (349,'GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin'),
 (350,'GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback'),
 (351,'GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico'),
 (352,'GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention'),
 (353,'GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (354,'GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India'),
 (355,'GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin'),
 (356,'GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies'),
 (357,'GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse'),
 (358,'GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat'),
 (359,'GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan'),
 (360,'GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan'),
 (361,'GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies'),
 (362,'GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (363,'GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon'),
 (364,'GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback'),
 (365,'GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory'),
 (366,'GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans'),
 (367,'GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback'),
 (368,'GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse'),
 (369,'GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory'),
 (370,'GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory'),
 (371,'GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin');
INSERT INTO `sakila`.`film_text` VALUES  (372,'GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans'),
 (373,'GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China'),
 (374,'GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin'),
 (375,'GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft'),
 (376,'GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia'),
 (377,'GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia'),
 (378,'GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin'),
 (379,'GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies'),
 (380,'GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station'),
 (381,'GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (382,'GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank'),
 (383,'GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft'),
 (384,'GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia'),
 (385,'GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse'),
 (386,'GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft'),
 (387,'GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico'),
 (388,'GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert'),
 (389,'GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan'),
 (390,'GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat');
INSERT INTO `sakila`.`film_text` VALUES  (391,'HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat'),
 (392,'HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia'),
 (393,'HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat'),
 (394,'HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback'),
 (395,'HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia'),
 (396,'HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin'),
 (397,'HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia'),
 (398,'HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention'),
 (399,'HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan');
INSERT INTO `sakila`.`film_text` VALUES  (400,'HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin'),
 (401,'HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert'),
 (402,'HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert'),
 (403,'HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California'),
 (404,'HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station'),
 (405,'HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India'),
 (406,'HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park'),
 (407,'HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia'),
 (408,'HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (409,'HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies'),
 (410,'HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans'),
 (411,'HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat'),
 (412,'HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park'),
 (413,'HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery'),
 (414,'HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia'),
 (415,'HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia'),
 (416,'HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert'),
 (417,'HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat');
INSERT INTO `sakila`.`film_text` VALUES  (418,'HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station'),
 (419,'HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank'),
 (420,'HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies'),
 (421,'HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan'),
 (422,'HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery'),
 (423,'HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat'),
 (424,'HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia'),
 (425,'HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory'),
 (426,'HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention'),
 (427,'HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse');
INSERT INTO `sakila`.`film_text` VALUES  (428,'HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention'),
 (429,'HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank'),
 (430,'HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia'),
 (431,'HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station'),
 (432,'HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank'),
 (433,'HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank'),
 (434,'HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria'),
 (435,'HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback'),
 (436,'HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia'),
 (437,'HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia');
INSERT INTO `sakila`.`film_text` VALUES  (438,'HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico'),
 (439,'HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan'),
 (440,'HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft'),
 (441,'HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank'),
 (442,'HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft'),
 (443,'HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft'),
 (444,'HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert'),
 (445,'HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat'),
 (446,'HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse');
INSERT INTO `sakila`.`film_text` VALUES  (447,'ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse'),
 (448,'IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback'),
 (449,'IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback'),
 (450,'IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery'),
 (451,'IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory'),
 (452,'ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft'),
 (453,'IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies'),
 (454,'IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank'),
 (455,'IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China'),
 (456,'INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery');
INSERT INTO `sakila`.`film_text` VALUES  (457,'INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery'),
 (458,'INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House'),
 (459,'INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies'),
 (460,'INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback'),
 (461,'INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse'),
 (462,'INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory'),
 (463,'INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse'),
 (464,'INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat'),
 (465,'INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse');
INSERT INTO `sakila`.`film_text` VALUES  (466,'INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention'),
 (467,'INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat'),
 (468,'INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery'),
 (469,'IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon'),
 (470,'ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House'),
 (471,'ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House'),
 (472,'ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat'),
 (473,'JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon'),
 (474,'JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (475,'JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback'),
 (476,'JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery'),
 (477,'JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat'),
 (478,'JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House'),
 (479,'JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria'),
 (480,'JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia'),
 (481,'JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank'),
 (482,'JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India'),
 (483,'JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat'),
 (484,'JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan');
INSERT INTO `sakila`.`film_text` VALUES  (485,'JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan'),
 (486,'JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat'),
 (487,'JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon'),
 (488,'JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank'),
 (489,'JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California'),
 (490,'JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans'),
 (491,'JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin'),
 (492,'JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia'),
 (493,'KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin'),
 (494,'KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention');
INSERT INTO `sakila`.`film_text` VALUES  (495,'KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat'),
 (496,'KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans'),
 (497,'KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback'),
 (498,'KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft'),
 (499,'KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon'),
 (500,'KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies'),
 (501,'KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station'),
 (502,'KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon'),
 (503,'KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback'),
 (504,'KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia');
INSERT INTO `sakila`.`film_text` VALUES  (505,'LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert'),
 (506,'LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat'),
 (507,'LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans'),
 (508,'LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia'),
 (509,'LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park'),
 (510,'LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback'),
 (511,'LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin'),
 (512,'LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China'),
 (513,'LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft'),
 (514,'LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (515,'LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert'),
 (516,'LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback'),
 (517,'LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse'),
 (518,'LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies'),
 (519,'LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon'),
 (520,'LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery'),
 (521,'LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station'),
 (522,'LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station'),
 (523,'LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (524,'LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China'),
 (525,'LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico'),
 (526,'LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan'),
 (527,'LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan'),
 (528,'LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft'),
 (529,'LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia'),
 (530,'LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat'),
 (531,'LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station'),
 (532,'LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria');
INSERT INTO `sakila`.`film_text` VALUES  (533,'LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse'),
 (534,'LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank'),
 (535,'LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House'),
 (536,'LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback'),
 (537,'LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat'),
 (538,'LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia'),
 (539,'LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank'),
 (540,'LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat'),
 (541,'LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India');
INSERT INTO `sakila`.`film_text` VALUES  (542,'LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert'),
 (543,'MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback'),
 (544,'MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat'),
 (545,'MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico'),
 (546,'MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station'),
 (547,'MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California'),
 (548,'MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California'),
 (549,'MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans'),
 (550,'MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (551,'MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention'),
 (552,'MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station'),
 (553,'MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat'),
 (554,'MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback'),
 (555,'MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery'),
 (556,'MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California'),
 (557,'MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin'),
 (558,'MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India'),
 (559,'MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (560,'MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia'),
 (561,'MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California'),
 (562,'MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft'),
 (563,'MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California'),
 (564,'MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station'),
 (565,'MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California'),
 (566,'MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria'),
 (567,'MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention'),
 (568,'MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (569,'MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station'),
 (570,'MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California'),
 (571,'METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory'),
 (572,'METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory'),
 (573,'MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria'),
 (574,'MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery'),
 (575,'MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan'),
 (576,'MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention'),
 (577,'MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention');
INSERT INTO `sakila`.`film_text` VALUES  (578,'MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert'),
 (579,'MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery'),
 (580,'MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin'),
 (581,'MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback'),
 (582,'MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert'),
 (583,'MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House'),
 (584,'MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India'),
 (585,'MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies'),
 (586,'MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin');
INSERT INTO `sakila`.`film_text` VALUES  (587,'MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans'),
 (588,'MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia'),
 (589,'MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans'),
 (590,'MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia'),
 (591,'MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat'),
 (592,'MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia'),
 (593,'MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat'),
 (594,'MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat'),
 (595,'MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory'),
 (596,'MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (597,'MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans'),
 (598,'MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan'),
 (599,'MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China'),
 (600,'MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House'),
 (601,'MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft'),
 (602,'MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans'),
 (603,'MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin'),
 (604,'MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon'),
 (605,'MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (606,'MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia'),
 (607,'MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico'),
 (608,'MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention'),
 (609,'MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India'),
 (610,'MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station'),
 (611,'MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia'),
 (612,'MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China'),
 (613,'MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia'),
 (614,'NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria'),
 (615,'NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft');
INSERT INTO `sakila`.`film_text` VALUES  (616,'NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California'),
 (617,'NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory'),
 (618,'NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California'),
 (619,'NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park'),
 (620,'NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse'),
 (621,'NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California'),
 (622,'NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico'),
 (623,'NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India'),
 (624,'NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft');
INSERT INTO `sakila`.`film_text` VALUES  (625,'NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse'),
 (626,'NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse'),
 (627,'NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans'),
 (628,'NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback'),
 (629,'NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon'),
 (630,'NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies'),
 (631,'NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria'),
 (632,'NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California'),
 (633,'OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (634,'ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin'),
 (635,'OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert'),
 (636,'OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat'),
 (637,'OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat'),
 (638,'OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China'),
 (639,'OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria'),
 (640,'OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert'),
 (641,'ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat'),
 (642,'ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert'),
 (643,'ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (644,'OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia'),
 (645,'OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico'),
 (646,'OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat'),
 (647,'OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India'),
 (648,'OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert'),
 (649,'OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory'),
 (650,'PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse'),
 (651,'PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park'),
 (652,'PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California');
INSERT INTO `sakila`.`film_text` VALUES  (653,'PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon'),
 (654,'PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico'),
 (655,'PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico'),
 (656,'PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan'),
 (657,'PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse'),
 (658,'PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback'),
 (659,'PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan'),
 (660,'PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft'),
 (661,'PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery'),
 (662,'PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (663,'PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia'),
 (664,'PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California'),
 (665,'PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin'),
 (666,'PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert'),
 (667,'PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin'),
 (668,'PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft'),
 (669,'PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat'),
 (670,'PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin'),
 (671,'PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin'),
 (672,'PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon');
INSERT INTO `sakila`.`film_text` VALUES  (673,'PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan'),
 (674,'PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California'),
 (675,'PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery'),
 (676,'PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert'),
 (677,'PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery'),
 (678,'PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory'),
 (679,'PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft'),
 (680,'PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California'),
 (681,'PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies');
INSERT INTO `sakila`.`film_text` VALUES  (682,'PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia'),
 (683,'PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria'),
 (684,'PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat'),
 (685,'PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia'),
 (686,'PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank'),
 (687,'POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory'),
 (688,'POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback'),
 (689,'POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert'),
 (690,'POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China'),
 (691,'POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery');
INSERT INTO `sakila`.`film_text` VALUES  (692,'POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon'),
 (693,'POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin'),
 (694,'PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat'),
 (695,'PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia'),
 (696,'PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India'),
 (697,'PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies'),
 (698,'PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank'),
 (699,'PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon'),
 (700,'PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China'),
 (701,'PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria');
INSERT INTO `sakila`.`film_text` VALUES  (702,'PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria'),
 (703,'PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies'),
 (704,'PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse'),
 (705,'PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park'),
 (706,'QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans'),
 (707,'QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory'),
 (708,'QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia'),
 (709,'RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California'),
 (710,'RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park'),
 (711,'RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (712,'RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station'),
 (713,'RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India'),
 (714,'RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank'),
 (715,'RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon'),
 (716,'REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention'),
 (717,'REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia'),
 (718,'REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India'),
 (719,'RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback'),
 (720,'REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (721,'REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia'),
 (722,'REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon'),
 (723,'REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico'),
 (724,'REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India'),
 (725,'REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery'),
 (726,'RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California'),
 (727,'RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention'),
 (728,'REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory'),
 (729,'RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria');
INSERT INTO `sakila`.`film_text` VALUES  (730,'RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan'),
 (731,'RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat'),
 (732,'RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans'),
 (733,'RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention'),
 (734,'ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan'),
 (735,'ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia'),
 (736,'ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan'),
 (737,'ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India'),
 (738,'ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank');
INSERT INTO `sakila`.`film_text` VALUES  (739,'ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria'),
 (740,'ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank'),
 (741,'ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin'),
 (742,'ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon'),
 (743,'ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank'),
 (744,'ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin'),
 (745,'ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station'),
 (746,'ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia'),
 (747,'ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback');
INSERT INTO `sakila`.`film_text` VALUES  (748,'RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria'),
 (749,'RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House'),
 (750,'RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention'),
 (751,'RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House'),
 (752,'RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback'),
 (753,'RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia'),
 (754,'RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank'),
 (755,'SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert'),
 (756,'SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House');
INSERT INTO `sakila`.`film_text` VALUES  (757,'SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan'),
 (758,'SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico'),
 (759,'SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China'),
 (760,'SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon'),
 (761,'SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory'),
 (762,'SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse'),
 (763,'SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China'),
 (764,'SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon'),
 (765,'SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin'),
 (766,'SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico');
INSERT INTO `sakila`.`film_text` VALUES  (767,'SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery'),
 (768,'SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory'),
 (769,'SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse'),
 (770,'SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies'),
 (771,'SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House'),
 (772,'SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat'),
 (773,'SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention'),
 (774,'SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan'),
 (775,'SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert');
INSERT INTO `sakila`.`film_text` VALUES  (776,'SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans'),
 (777,'SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory'),
 (778,'SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse'),
 (779,'SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House'),
 (780,'SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory'),
 (781,'SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin'),
 (782,'SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention'),
 (783,'SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin'),
 (784,'SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House');
INSERT INTO `sakila`.`film_text` VALUES  (785,'SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park'),
 (786,'SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon'),
 (787,'SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India'),
 (788,'SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback'),
 (789,'SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans'),
 (790,'SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin'),
 (791,'SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan'),
 (792,'SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat'),
 (793,'SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon'),
 (794,'SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies');
INSERT INTO `sakila`.`film_text` VALUES  (795,'SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft'),
 (796,'SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California'),
 (797,'SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon'),
 (798,'SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India'),
 (799,'SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank'),
 (800,'SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft'),
 (801,'SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia'),
 (802,'SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House'),
 (803,'SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (804,'SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention'),
 (805,'SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia'),
 (806,'SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback'),
 (807,'SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India'),
 (808,'SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park'),
 (809,'SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention'),
 (810,'SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat'),
 (811,'SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin'),
 (812,'SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention');
INSERT INTO `sakila`.`film_text` VALUES  (813,'SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China'),
 (814,'SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin'),
 (815,'SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies'),
 (816,'SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse'),
 (817,'SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station'),
 (818,'SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station'),
 (819,'SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention'),
 (820,'SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China'),
 (821,'SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat');
INSERT INTO `sakila`.`film_text` VALUES  (822,'SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention'),
 (823,'SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park'),
 (824,'SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse'),
 (825,'SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse'),
 (826,'SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China'),
 (827,'SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft'),
 (828,'SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery'),
 (829,'SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California'),
 (830,'SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan');
INSERT INTO `sakila`.`film_text` VALUES  (831,'SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory'),
 (832,'SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank'),
 (833,'SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin'),
 (834,'SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico'),
 (835,'SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon'),
 (836,'SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin'),
 (837,'STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat'),
 (838,'STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California'),
 (839,'STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia'),
 (840,'STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat');
INSERT INTO `sakila`.`film_text` VALUES  (841,'STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank'),
 (842,'STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat'),
 (843,'STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria'),
 (844,'STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention'),
 (845,'STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention'),
 (846,'STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat'),
 (847,'STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China'),
 (848,'STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia'),
 (849,'STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank'),
 (850,'STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft');
INSERT INTO `sakila`.`film_text` VALUES  (851,'STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback'),
 (852,'STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park'),
 (853,'STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station'),
 (854,'STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico'),
 (855,'STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans'),
 (856,'STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico'),
 (857,'STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House'),
 (858,'SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia'),
 (859,'SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park');
INSERT INTO `sakila`.`film_text` VALUES  (860,'SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat'),
 (861,'SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia'),
 (862,'SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank'),
 (863,'SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park'),
 (864,'SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory'),
 (865,'SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse'),
 (866,'SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California'),
 (867,'SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback'),
 (868,'SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House');
INSERT INTO `sakila`.`film_text` VALUES  (869,'SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse'),
 (870,'SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention'),
 (871,'SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies'),
 (872,'SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon'),
 (873,'SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico'),
 (874,'TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park'),
 (875,'TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat'),
 (876,'TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert'),
 (877,'TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia');
INSERT INTO `sakila`.`film_text` VALUES  (878,'TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank'),
 (879,'TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat'),
 (880,'TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse'),
 (881,'TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia'),
 (882,'TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico'),
 (883,'TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria'),
 (884,'TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico'),
 (885,'TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park'),
 (886,'THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (887,'THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft'),
 (888,'THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India'),
 (889,'TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat'),
 (890,'TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon'),
 (891,'TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat'),
 (892,'TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory'),
 (893,'TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China'),
 (894,'TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank'),
 (895,'TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert'),
 (896,'TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin');
INSERT INTO `sakila`.`film_text` VALUES  (897,'TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan'),
 (898,'TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia'),
 (899,'TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention'),
 (900,'TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft'),
 (901,'TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria'),
 (902,'TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station'),
 (903,'TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat'),
 (904,'TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India'),
 (905,'TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan');
INSERT INTO `sakila`.`film_text` VALUES  (906,'TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India'),
 (907,'TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention'),
 (908,'TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert'),
 (909,'TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California'),
 (910,'TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft'),
 (911,'TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park'),
 (912,'TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India'),
 (913,'TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin'),
 (914,'TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan'),
 (915,'TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery');
INSERT INTO `sakila`.`film_text` VALUES  (916,'TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans'),
 (917,'TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India'),
 (918,'TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention'),
 (919,'TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse'),
 (920,'UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia'),
 (921,'UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat'),
 (922,'UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park'),
 (923,'UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans'),
 (924,'UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory');
INSERT INTO `sakila`.`film_text` VALUES  (925,'UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert'),
 (926,'UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House'),
 (927,'UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin'),
 (928,'UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park'),
 (929,'USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank'),
 (930,'VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia'),
 (931,'VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California'),
 (932,'VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin'),
 (933,'VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention');
INSERT INTO `sakila`.`film_text` VALUES  (934,'VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria'),
 (935,'VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California'),
 (936,'VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention'),
 (937,'VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention'),
 (938,'VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park'),
 (939,'VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan'),
 (940,'VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert'),
 (941,'VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia'),
 (942,'VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia');
INSERT INTO `sakila`.`film_text` VALUES  (943,'VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park'),
 (944,'VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank'),
 (945,'VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin'),
 (946,'VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia'),
 (947,'VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank'),
 (948,'VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse'),
 (949,'VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback'),
 (950,'VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California'),
 (951,'VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft'),
 (952,'WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse');
INSERT INTO `sakila`.`film_text` VALUES  (953,'WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse'),
 (954,'WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin'),
 (955,'WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House'),
 (956,'WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback'),
 (957,'WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies'),
 (958,'WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India'),
 (959,'WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback'),
 (960,'WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert'),
 (961,'WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (962,'WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China'),
 (963,'WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria'),
 (964,'WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria'),
 (965,'WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia'),
 (966,'WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft'),
 (967,'WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat'),
 (968,'WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery'),
 (969,'WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse'),
 (970,'WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China');
INSERT INTO `sakila`.`film_text` VALUES  (971,'WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention'),
 (972,'WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan'),
 (973,'WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan'),
 (974,'WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention'),
 (975,'WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse'),
 (976,'WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft'),
 (977,'WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery'),
 (978,'WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station'),
 (979,'WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria');
INSERT INTO `sakila`.`film_text` VALUES  (980,'WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention'),
 (981,'WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse'),
 (982,'WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia'),
 (983,'WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat'),
 (984,'WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat'),
 (985,'WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station'),
 (986,'WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India'),
 (987,'WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention'),
 (988,'WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station');
INSERT INTO `sakila`.`film_text` VALUES  (989,'WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China'),
 (990,'WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park'),
 (991,'WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback'),
 (992,'WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery'),
 (993,'WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans'),
 (994,'WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat'),
 (995,'YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin'),
 (996,'YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station'),
 (997,'YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat');
INSERT INTO `sakila`.`film_text` VALUES  (998,'ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies'),
 (999,'ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China'),
 (1000,'ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery');
COMMIT;

--
-- Definition of table `sakila`.`inventory`
--

DROP TABLE IF EXISTS `sakila`.`inventory`;
CREATE TABLE  `sakila`.`inventory` (
  `inventory_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `film_id` smallint(5) unsigned NOT NULL,
  `store_id` tinyint(3) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`inventory_id`),
  KEY `idx_fk_film_id` (`film_id`),
  KEY `idx_store_id_film_id` (`store_id`,`film_id`),
  CONSTRAINT `fk_inventory_film` FOREIGN KEY (`film_id`) REFERENCES `film` (`film_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_inventory_store` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`inventory`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`inventory` VALUES  (1,1,1,'2006-02-15 05:09:17'),
 (2,1,1,'2006-02-15 05:09:17'),
 (3,1,1,'2006-02-15 05:09:17'),
 (4,1,1,'2006-02-15 05:09:17'),
 (5,1,2,'2006-02-15 05:09:17'),
 (6,1,2,'2006-02-15 05:09:17'),
 (7,1,2,'2006-02-15 05:09:17'),
 (8,1,2,'2006-02-15 05:09:17'),
 (9,2,2,'2006-02-15 05:09:17'),
 (10,2,2,'2006-02-15 05:09:17'),
 (11,2,2,'2006-02-15 05:09:17'),
 (12,3,2,'2006-02-15 05:09:17'),
 (13,3,2,'2006-02-15 05:09:17'),
 (14,3,2,'2006-02-15 05:09:17'),
 (15,3,2,'2006-02-15 05:09:17'),
 (16,4,1,'2006-02-15 05:09:17'),
 (17,4,1,'2006-02-15 05:09:17'),
 (18,4,1,'2006-02-15 05:09:17'),
 (19,4,1,'2006-02-15 05:09:17'),
 (20,4,2,'2006-02-15 05:09:17'),
 (21,4,2,'2006-02-15 05:09:17'),
 (22,4,2,'2006-02-15 05:09:17'),
 (23,5,2,'2006-02-15 05:09:17'),
 (24,5,2,'2006-02-15 05:09:17'),
 (25,5,2,'2006-02-15 05:09:17'),
 (26,6,1,'2006-02-15 05:09:17'),
 (27,6,1,'2006-02-15 05:09:17'),
 (28,6,1,'2006-02-15 05:09:17'),
 (29,6,2,'2006-02-15 05:09:17'),
 (30,6,2,'2006-02-15 05:09:17'),
 (31,6,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (32,7,1,'2006-02-15 05:09:17'),
 (33,7,1,'2006-02-15 05:09:17'),
 (34,7,2,'2006-02-15 05:09:17'),
 (35,7,2,'2006-02-15 05:09:17'),
 (36,7,2,'2006-02-15 05:09:17'),
 (37,8,2,'2006-02-15 05:09:17'),
 (38,8,2,'2006-02-15 05:09:17'),
 (39,8,2,'2006-02-15 05:09:17'),
 (40,8,2,'2006-02-15 05:09:17'),
 (41,9,1,'2006-02-15 05:09:17'),
 (42,9,1,'2006-02-15 05:09:17'),
 (43,9,1,'2006-02-15 05:09:17'),
 (44,9,2,'2006-02-15 05:09:17'),
 (45,9,2,'2006-02-15 05:09:17'),
 (46,10,1,'2006-02-15 05:09:17'),
 (47,10,1,'2006-02-15 05:09:17'),
 (48,10,1,'2006-02-15 05:09:17'),
 (49,10,1,'2006-02-15 05:09:17'),
 (50,10,2,'2006-02-15 05:09:17'),
 (51,10,2,'2006-02-15 05:09:17'),
 (52,10,2,'2006-02-15 05:09:17'),
 (53,11,1,'2006-02-15 05:09:17'),
 (54,11,1,'2006-02-15 05:09:17'),
 (55,11,1,'2006-02-15 05:09:17'),
 (56,11,1,'2006-02-15 05:09:17'),
 (57,11,2,'2006-02-15 05:09:17'),
 (58,11,2,'2006-02-15 05:09:17'),
 (59,11,2,'2006-02-15 05:09:17'),
 (60,12,1,'2006-02-15 05:09:17'),
 (61,12,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (62,12,1,'2006-02-15 05:09:17'),
 (63,12,2,'2006-02-15 05:09:17'),
 (64,12,2,'2006-02-15 05:09:17'),
 (65,12,2,'2006-02-15 05:09:17'),
 (66,12,2,'2006-02-15 05:09:17'),
 (67,13,2,'2006-02-15 05:09:17'),
 (68,13,2,'2006-02-15 05:09:17'),
 (69,13,2,'2006-02-15 05:09:17'),
 (70,13,2,'2006-02-15 05:09:17'),
 (71,15,1,'2006-02-15 05:09:17'),
 (72,15,1,'2006-02-15 05:09:17'),
 (73,15,2,'2006-02-15 05:09:17'),
 (74,15,2,'2006-02-15 05:09:17'),
 (75,15,2,'2006-02-15 05:09:17'),
 (76,15,2,'2006-02-15 05:09:17'),
 (77,16,1,'2006-02-15 05:09:17'),
 (78,16,1,'2006-02-15 05:09:17'),
 (79,16,2,'2006-02-15 05:09:17'),
 (80,16,2,'2006-02-15 05:09:17'),
 (81,17,1,'2006-02-15 05:09:17'),
 (82,17,1,'2006-02-15 05:09:17'),
 (83,17,1,'2006-02-15 05:09:17'),
 (84,17,2,'2006-02-15 05:09:17'),
 (85,17,2,'2006-02-15 05:09:17'),
 (86,17,2,'2006-02-15 05:09:17'),
 (87,18,1,'2006-02-15 05:09:17'),
 (88,18,1,'2006-02-15 05:09:17'),
 (89,18,1,'2006-02-15 05:09:17'),
 (90,18,2,'2006-02-15 05:09:17'),
 (91,18,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (92,18,2,'2006-02-15 05:09:17'),
 (93,19,1,'2006-02-15 05:09:17'),
 (94,19,1,'2006-02-15 05:09:17'),
 (95,19,1,'2006-02-15 05:09:17'),
 (96,19,1,'2006-02-15 05:09:17'),
 (97,19,2,'2006-02-15 05:09:17'),
 (98,19,2,'2006-02-15 05:09:17'),
 (99,20,1,'2006-02-15 05:09:17'),
 (100,20,1,'2006-02-15 05:09:17'),
 (101,20,1,'2006-02-15 05:09:17'),
 (102,21,1,'2006-02-15 05:09:17'),
 (103,21,1,'2006-02-15 05:09:17'),
 (104,21,2,'2006-02-15 05:09:17'),
 (105,21,2,'2006-02-15 05:09:17'),
 (106,21,2,'2006-02-15 05:09:17'),
 (107,21,2,'2006-02-15 05:09:17'),
 (108,22,1,'2006-02-15 05:09:17'),
 (109,22,1,'2006-02-15 05:09:17'),
 (110,22,1,'2006-02-15 05:09:17'),
 (111,22,1,'2006-02-15 05:09:17'),
 (112,22,2,'2006-02-15 05:09:17'),
 (113,22,2,'2006-02-15 05:09:17'),
 (114,22,2,'2006-02-15 05:09:17'),
 (115,23,1,'2006-02-15 05:09:17'),
 (116,23,1,'2006-02-15 05:09:17'),
 (117,23,1,'2006-02-15 05:09:17'),
 (118,23,2,'2006-02-15 05:09:17'),
 (119,23,2,'2006-02-15 05:09:17'),
 (120,24,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (121,24,1,'2006-02-15 05:09:17'),
 (122,24,1,'2006-02-15 05:09:17'),
 (123,24,1,'2006-02-15 05:09:17'),
 (124,25,1,'2006-02-15 05:09:17'),
 (125,25,1,'2006-02-15 05:09:17'),
 (126,25,1,'2006-02-15 05:09:17'),
 (127,25,1,'2006-02-15 05:09:17'),
 (128,25,2,'2006-02-15 05:09:17'),
 (129,25,2,'2006-02-15 05:09:17'),
 (130,26,1,'2006-02-15 05:09:17'),
 (131,26,1,'2006-02-15 05:09:17'),
 (132,26,2,'2006-02-15 05:09:17'),
 (133,26,2,'2006-02-15 05:09:17'),
 (134,26,2,'2006-02-15 05:09:17'),
 (135,27,1,'2006-02-15 05:09:17'),
 (136,27,1,'2006-02-15 05:09:17'),
 (137,27,1,'2006-02-15 05:09:17'),
 (138,27,1,'2006-02-15 05:09:17'),
 (139,28,1,'2006-02-15 05:09:17'),
 (140,28,1,'2006-02-15 05:09:17'),
 (141,28,1,'2006-02-15 05:09:17'),
 (142,29,1,'2006-02-15 05:09:17'),
 (143,29,1,'2006-02-15 05:09:17'),
 (144,30,1,'2006-02-15 05:09:17'),
 (145,30,1,'2006-02-15 05:09:17'),
 (146,31,1,'2006-02-15 05:09:17'),
 (147,31,1,'2006-02-15 05:09:17'),
 (148,31,1,'2006-02-15 05:09:17'),
 (149,31,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (150,31,2,'2006-02-15 05:09:17'),
 (151,31,2,'2006-02-15 05:09:17'),
 (152,31,2,'2006-02-15 05:09:17'),
 (153,31,2,'2006-02-15 05:09:17'),
 (154,32,2,'2006-02-15 05:09:17'),
 (155,32,2,'2006-02-15 05:09:17'),
 (156,34,2,'2006-02-15 05:09:17'),
 (157,34,2,'2006-02-15 05:09:17'),
 (158,34,2,'2006-02-15 05:09:17'),
 (159,34,2,'2006-02-15 05:09:17'),
 (160,35,1,'2006-02-15 05:09:17'),
 (161,35,1,'2006-02-15 05:09:17'),
 (162,35,1,'2006-02-15 05:09:17'),
 (163,35,1,'2006-02-15 05:09:17'),
 (164,35,2,'2006-02-15 05:09:17'),
 (165,35,2,'2006-02-15 05:09:17'),
 (166,35,2,'2006-02-15 05:09:17'),
 (167,37,1,'2006-02-15 05:09:17'),
 (168,37,1,'2006-02-15 05:09:17'),
 (169,37,1,'2006-02-15 05:09:17'),
 (170,37,1,'2006-02-15 05:09:17'),
 (171,37,2,'2006-02-15 05:09:17'),
 (172,37,2,'2006-02-15 05:09:17'),
 (173,37,2,'2006-02-15 05:09:17'),
 (174,39,1,'2006-02-15 05:09:17'),
 (175,39,1,'2006-02-15 05:09:17'),
 (176,39,1,'2006-02-15 05:09:17'),
 (177,39,2,'2006-02-15 05:09:17'),
 (178,39,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (179,39,2,'2006-02-15 05:09:17'),
 (180,39,2,'2006-02-15 05:09:17'),
 (181,40,2,'2006-02-15 05:09:17'),
 (182,40,2,'2006-02-15 05:09:17'),
 (183,40,2,'2006-02-15 05:09:17'),
 (184,40,2,'2006-02-15 05:09:17'),
 (185,42,2,'2006-02-15 05:09:17'),
 (186,42,2,'2006-02-15 05:09:17'),
 (187,42,2,'2006-02-15 05:09:17'),
 (188,42,2,'2006-02-15 05:09:17'),
 (189,43,1,'2006-02-15 05:09:17'),
 (190,43,1,'2006-02-15 05:09:17'),
 (191,43,1,'2006-02-15 05:09:17'),
 (192,43,2,'2006-02-15 05:09:17'),
 (193,43,2,'2006-02-15 05:09:17'),
 (194,43,2,'2006-02-15 05:09:17'),
 (195,43,2,'2006-02-15 05:09:17'),
 (196,44,1,'2006-02-15 05:09:17'),
 (197,44,1,'2006-02-15 05:09:17'),
 (198,44,2,'2006-02-15 05:09:17'),
 (199,44,2,'2006-02-15 05:09:17'),
 (200,44,2,'2006-02-15 05:09:17'),
 (201,45,1,'2006-02-15 05:09:17'),
 (202,45,1,'2006-02-15 05:09:17'),
 (203,45,1,'2006-02-15 05:09:17'),
 (204,45,1,'2006-02-15 05:09:17'),
 (205,45,2,'2006-02-15 05:09:17'),
 (206,45,2,'2006-02-15 05:09:17'),
 (207,46,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (208,46,2,'2006-02-15 05:09:17'),
 (209,46,2,'2006-02-15 05:09:17'),
 (210,47,2,'2006-02-15 05:09:17'),
 (211,47,2,'2006-02-15 05:09:17'),
 (212,48,1,'2006-02-15 05:09:17'),
 (213,48,1,'2006-02-15 05:09:17'),
 (214,48,2,'2006-02-15 05:09:17'),
 (215,48,2,'2006-02-15 05:09:17'),
 (216,49,1,'2006-02-15 05:09:17'),
 (217,49,1,'2006-02-15 05:09:17'),
 (218,49,1,'2006-02-15 05:09:17'),
 (219,49,2,'2006-02-15 05:09:17'),
 (220,49,2,'2006-02-15 05:09:17'),
 (221,49,2,'2006-02-15 05:09:17'),
 (222,50,1,'2006-02-15 05:09:17'),
 (223,50,1,'2006-02-15 05:09:17'),
 (224,50,1,'2006-02-15 05:09:17'),
 (225,50,2,'2006-02-15 05:09:17'),
 (226,50,2,'2006-02-15 05:09:17'),
 (227,51,1,'2006-02-15 05:09:17'),
 (228,51,1,'2006-02-15 05:09:17'),
 (229,51,2,'2006-02-15 05:09:17'),
 (230,51,2,'2006-02-15 05:09:17'),
 (231,51,2,'2006-02-15 05:09:17'),
 (232,51,2,'2006-02-15 05:09:17'),
 (233,52,2,'2006-02-15 05:09:17'),
 (234,52,2,'2006-02-15 05:09:17'),
 (235,53,1,'2006-02-15 05:09:17'),
 (236,53,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (237,54,1,'2006-02-15 05:09:17'),
 (238,54,1,'2006-02-15 05:09:17'),
 (239,54,1,'2006-02-15 05:09:17'),
 (240,54,2,'2006-02-15 05:09:17'),
 (241,54,2,'2006-02-15 05:09:17'),
 (242,55,1,'2006-02-15 05:09:17'),
 (243,55,1,'2006-02-15 05:09:17'),
 (244,55,1,'2006-02-15 05:09:17'),
 (245,55,1,'2006-02-15 05:09:17'),
 (246,55,2,'2006-02-15 05:09:17'),
 (247,55,2,'2006-02-15 05:09:17'),
 (248,56,1,'2006-02-15 05:09:17'),
 (249,56,1,'2006-02-15 05:09:17'),
 (250,56,1,'2006-02-15 05:09:17'),
 (251,56,2,'2006-02-15 05:09:17'),
 (252,56,2,'2006-02-15 05:09:17'),
 (253,57,1,'2006-02-15 05:09:17'),
 (254,57,1,'2006-02-15 05:09:17'),
 (255,57,1,'2006-02-15 05:09:17'),
 (256,57,1,'2006-02-15 05:09:17'),
 (257,57,2,'2006-02-15 05:09:17'),
 (258,57,2,'2006-02-15 05:09:17'),
 (259,57,2,'2006-02-15 05:09:17'),
 (260,58,2,'2006-02-15 05:09:17'),
 (261,58,2,'2006-02-15 05:09:17'),
 (262,58,2,'2006-02-15 05:09:17'),
 (263,58,2,'2006-02-15 05:09:17'),
 (264,59,1,'2006-02-15 05:09:17'),
 (265,59,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (266,59,1,'2006-02-15 05:09:17'),
 (267,59,2,'2006-02-15 05:09:17'),
 (268,59,2,'2006-02-15 05:09:17'),
 (269,60,1,'2006-02-15 05:09:17'),
 (270,60,1,'2006-02-15 05:09:17'),
 (271,60,1,'2006-02-15 05:09:17'),
 (272,61,1,'2006-02-15 05:09:17'),
 (273,61,1,'2006-02-15 05:09:17'),
 (274,61,1,'2006-02-15 05:09:17'),
 (275,61,1,'2006-02-15 05:09:17'),
 (276,61,2,'2006-02-15 05:09:17'),
 (277,61,2,'2006-02-15 05:09:17'),
 (278,62,2,'2006-02-15 05:09:17'),
 (279,62,2,'2006-02-15 05:09:17'),
 (280,63,1,'2006-02-15 05:09:17'),
 (281,63,1,'2006-02-15 05:09:17'),
 (282,63,2,'2006-02-15 05:09:17'),
 (283,63,2,'2006-02-15 05:09:17'),
 (284,64,2,'2006-02-15 05:09:17'),
 (285,64,2,'2006-02-15 05:09:17'),
 (286,64,2,'2006-02-15 05:09:17'),
 (287,65,2,'2006-02-15 05:09:17'),
 (288,65,2,'2006-02-15 05:09:17'),
 (289,65,2,'2006-02-15 05:09:17'),
 (290,65,2,'2006-02-15 05:09:17'),
 (291,66,1,'2006-02-15 05:09:17'),
 (292,66,1,'2006-02-15 05:09:17'),
 (293,66,1,'2006-02-15 05:09:17'),
 (294,67,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (295,67,1,'2006-02-15 05:09:17'),
 (296,67,2,'2006-02-15 05:09:17'),
 (297,67,2,'2006-02-15 05:09:17'),
 (298,67,2,'2006-02-15 05:09:17'),
 (299,67,2,'2006-02-15 05:09:17'),
 (300,68,1,'2006-02-15 05:09:17'),
 (301,68,1,'2006-02-15 05:09:17'),
 (302,68,2,'2006-02-15 05:09:17'),
 (303,68,2,'2006-02-15 05:09:17'),
 (304,69,1,'2006-02-15 05:09:17'),
 (305,69,1,'2006-02-15 05:09:17'),
 (306,69,1,'2006-02-15 05:09:17'),
 (307,69,1,'2006-02-15 05:09:17'),
 (308,69,2,'2006-02-15 05:09:17'),
 (309,69,2,'2006-02-15 05:09:17'),
 (310,69,2,'2006-02-15 05:09:17'),
 (311,69,2,'2006-02-15 05:09:17'),
 (312,70,1,'2006-02-15 05:09:17'),
 (313,70,1,'2006-02-15 05:09:17'),
 (314,70,2,'2006-02-15 05:09:17'),
 (315,70,2,'2006-02-15 05:09:17'),
 (316,71,2,'2006-02-15 05:09:17'),
 (317,71,2,'2006-02-15 05:09:17'),
 (318,71,2,'2006-02-15 05:09:17'),
 (319,71,2,'2006-02-15 05:09:17'),
 (320,72,1,'2006-02-15 05:09:17'),
 (321,72,1,'2006-02-15 05:09:17'),
 (322,72,1,'2006-02-15 05:09:17'),
 (323,72,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (324,72,2,'2006-02-15 05:09:17'),
 (325,72,2,'2006-02-15 05:09:17'),
 (326,73,1,'2006-02-15 05:09:17'),
 (327,73,1,'2006-02-15 05:09:17'),
 (328,73,1,'2006-02-15 05:09:17'),
 (329,73,1,'2006-02-15 05:09:17'),
 (330,73,2,'2006-02-15 05:09:17'),
 (331,73,2,'2006-02-15 05:09:17'),
 (332,73,2,'2006-02-15 05:09:17'),
 (333,73,2,'2006-02-15 05:09:17'),
 (334,74,1,'2006-02-15 05:09:17'),
 (335,74,1,'2006-02-15 05:09:17'),
 (336,74,1,'2006-02-15 05:09:17'),
 (337,74,2,'2006-02-15 05:09:17'),
 (338,74,2,'2006-02-15 05:09:17'),
 (339,75,2,'2006-02-15 05:09:17'),
 (340,75,2,'2006-02-15 05:09:17'),
 (341,75,2,'2006-02-15 05:09:17'),
 (342,76,1,'2006-02-15 05:09:17'),
 (343,76,1,'2006-02-15 05:09:17'),
 (344,76,1,'2006-02-15 05:09:17'),
 (345,77,1,'2006-02-15 05:09:17'),
 (346,77,1,'2006-02-15 05:09:17'),
 (347,77,1,'2006-02-15 05:09:17'),
 (348,77,1,'2006-02-15 05:09:17'),
 (349,77,2,'2006-02-15 05:09:17'),
 (350,77,2,'2006-02-15 05:09:17'),
 (351,78,1,'2006-02-15 05:09:17'),
 (352,78,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (353,78,1,'2006-02-15 05:09:17'),
 (354,78,2,'2006-02-15 05:09:17'),
 (355,78,2,'2006-02-15 05:09:17'),
 (356,78,2,'2006-02-15 05:09:17'),
 (357,78,2,'2006-02-15 05:09:17'),
 (358,79,1,'2006-02-15 05:09:17'),
 (359,79,1,'2006-02-15 05:09:17'),
 (360,79,1,'2006-02-15 05:09:17'),
 (361,79,2,'2006-02-15 05:09:17'),
 (362,79,2,'2006-02-15 05:09:17'),
 (363,79,2,'2006-02-15 05:09:17'),
 (364,80,1,'2006-02-15 05:09:17'),
 (365,80,1,'2006-02-15 05:09:17'),
 (366,80,1,'2006-02-15 05:09:17'),
 (367,80,1,'2006-02-15 05:09:17'),
 (368,81,1,'2006-02-15 05:09:17'),
 (369,81,1,'2006-02-15 05:09:17'),
 (370,81,1,'2006-02-15 05:09:17'),
 (371,81,1,'2006-02-15 05:09:17'),
 (372,82,1,'2006-02-15 05:09:17'),
 (373,82,1,'2006-02-15 05:09:17'),
 (374,83,1,'2006-02-15 05:09:17'),
 (375,83,1,'2006-02-15 05:09:17'),
 (376,83,1,'2006-02-15 05:09:17'),
 (377,83,2,'2006-02-15 05:09:17'),
 (378,83,2,'2006-02-15 05:09:17'),
 (379,84,1,'2006-02-15 05:09:17'),
 (380,84,1,'2006-02-15 05:09:17'),
 (381,84,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (382,84,1,'2006-02-15 05:09:17'),
 (383,85,2,'2006-02-15 05:09:17'),
 (384,85,2,'2006-02-15 05:09:17'),
 (385,85,2,'2006-02-15 05:09:17'),
 (386,85,2,'2006-02-15 05:09:17'),
 (387,86,1,'2006-02-15 05:09:17'),
 (388,86,1,'2006-02-15 05:09:17'),
 (389,86,1,'2006-02-15 05:09:17'),
 (390,86,1,'2006-02-15 05:09:17'),
 (391,86,2,'2006-02-15 05:09:17'),
 (392,86,2,'2006-02-15 05:09:17'),
 (393,86,2,'2006-02-15 05:09:17'),
 (394,86,2,'2006-02-15 05:09:17'),
 (395,88,2,'2006-02-15 05:09:17'),
 (396,88,2,'2006-02-15 05:09:17'),
 (397,88,2,'2006-02-15 05:09:17'),
 (398,88,2,'2006-02-15 05:09:17'),
 (399,89,1,'2006-02-15 05:09:17'),
 (400,89,1,'2006-02-15 05:09:17'),
 (401,89,1,'2006-02-15 05:09:17'),
 (402,89,2,'2006-02-15 05:09:17'),
 (403,89,2,'2006-02-15 05:09:17'),
 (404,89,2,'2006-02-15 05:09:17'),
 (405,90,1,'2006-02-15 05:09:17'),
 (406,90,1,'2006-02-15 05:09:17'),
 (407,90,1,'2006-02-15 05:09:17'),
 (408,90,2,'2006-02-15 05:09:17'),
 (409,90,2,'2006-02-15 05:09:17'),
 (410,90,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (411,91,1,'2006-02-15 05:09:17'),
 (412,91,1,'2006-02-15 05:09:17'),
 (413,91,1,'2006-02-15 05:09:17'),
 (414,91,1,'2006-02-15 05:09:17'),
 (415,91,2,'2006-02-15 05:09:17'),
 (416,91,2,'2006-02-15 05:09:17'),
 (417,91,2,'2006-02-15 05:09:17'),
 (418,91,2,'2006-02-15 05:09:17'),
 (419,92,1,'2006-02-15 05:09:17'),
 (420,92,1,'2006-02-15 05:09:17'),
 (421,92,2,'2006-02-15 05:09:17'),
 (422,92,2,'2006-02-15 05:09:17'),
 (423,93,2,'2006-02-15 05:09:17'),
 (424,93,2,'2006-02-15 05:09:17'),
 (425,93,2,'2006-02-15 05:09:17'),
 (426,94,1,'2006-02-15 05:09:17'),
 (427,94,1,'2006-02-15 05:09:17'),
 (428,95,1,'2006-02-15 05:09:17'),
 (429,95,1,'2006-02-15 05:09:17'),
 (430,95,2,'2006-02-15 05:09:17'),
 (431,95,2,'2006-02-15 05:09:17'),
 (432,95,2,'2006-02-15 05:09:17'),
 (433,96,1,'2006-02-15 05:09:17'),
 (434,96,1,'2006-02-15 05:09:17'),
 (435,96,1,'2006-02-15 05:09:17'),
 (436,97,1,'2006-02-15 05:09:17'),
 (437,97,1,'2006-02-15 05:09:17'),
 (438,97,1,'2006-02-15 05:09:17'),
 (439,97,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (440,97,2,'2006-02-15 05:09:17'),
 (441,97,2,'2006-02-15 05:09:17'),
 (442,98,1,'2006-02-15 05:09:17'),
 (443,98,1,'2006-02-15 05:09:17'),
 (444,98,1,'2006-02-15 05:09:17'),
 (445,99,1,'2006-02-15 05:09:17'),
 (446,99,1,'2006-02-15 05:09:17'),
 (447,99,1,'2006-02-15 05:09:17'),
 (448,99,2,'2006-02-15 05:09:17'),
 (449,99,2,'2006-02-15 05:09:17'),
 (450,99,2,'2006-02-15 05:09:17'),
 (451,100,1,'2006-02-15 05:09:17'),
 (452,100,1,'2006-02-15 05:09:17'),
 (453,100,1,'2006-02-15 05:09:17'),
 (454,100,1,'2006-02-15 05:09:17'),
 (455,100,2,'2006-02-15 05:09:17'),
 (456,100,2,'2006-02-15 05:09:17'),
 (457,101,1,'2006-02-15 05:09:17'),
 (458,101,1,'2006-02-15 05:09:17'),
 (459,101,1,'2006-02-15 05:09:17'),
 (460,101,1,'2006-02-15 05:09:17'),
 (461,101,2,'2006-02-15 05:09:17'),
 (462,101,2,'2006-02-15 05:09:17'),
 (463,102,2,'2006-02-15 05:09:17'),
 (464,102,2,'2006-02-15 05:09:17'),
 (465,103,1,'2006-02-15 05:09:17'),
 (466,103,1,'2006-02-15 05:09:17'),
 (467,103,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (468,103,1,'2006-02-15 05:09:17'),
 (469,103,2,'2006-02-15 05:09:17'),
 (470,103,2,'2006-02-15 05:09:17'),
 (471,103,2,'2006-02-15 05:09:17'),
 (472,103,2,'2006-02-15 05:09:17'),
 (473,104,2,'2006-02-15 05:09:17'),
 (474,104,2,'2006-02-15 05:09:17'),
 (475,104,2,'2006-02-15 05:09:17'),
 (476,105,1,'2006-02-15 05:09:17'),
 (477,105,1,'2006-02-15 05:09:17'),
 (478,105,2,'2006-02-15 05:09:17'),
 (479,105,2,'2006-02-15 05:09:17'),
 (480,105,2,'2006-02-15 05:09:17'),
 (481,106,1,'2006-02-15 05:09:17'),
 (482,106,1,'2006-02-15 05:09:17'),
 (483,107,2,'2006-02-15 05:09:17'),
 (484,107,2,'2006-02-15 05:09:17'),
 (485,109,1,'2006-02-15 05:09:17'),
 (486,109,1,'2006-02-15 05:09:17'),
 (487,109,1,'2006-02-15 05:09:17'),
 (488,109,1,'2006-02-15 05:09:17'),
 (489,109,2,'2006-02-15 05:09:17'),
 (490,109,2,'2006-02-15 05:09:17'),
 (491,109,2,'2006-02-15 05:09:17'),
 (492,109,2,'2006-02-15 05:09:17'),
 (493,110,1,'2006-02-15 05:09:17'),
 (494,110,1,'2006-02-15 05:09:17'),
 (495,110,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (496,110,1,'2006-02-15 05:09:17'),
 (497,111,2,'2006-02-15 05:09:17'),
 (498,111,2,'2006-02-15 05:09:17'),
 (499,111,2,'2006-02-15 05:09:17'),
 (500,111,2,'2006-02-15 05:09:17'),
 (501,112,1,'2006-02-15 05:09:17'),
 (502,112,1,'2006-02-15 05:09:17'),
 (503,112,1,'2006-02-15 05:09:17'),
 (504,112,1,'2006-02-15 05:09:17'),
 (505,112,2,'2006-02-15 05:09:17'),
 (506,112,2,'2006-02-15 05:09:17'),
 (507,112,2,'2006-02-15 05:09:17'),
 (508,113,2,'2006-02-15 05:09:17'),
 (509,113,2,'2006-02-15 05:09:17'),
 (510,113,2,'2006-02-15 05:09:17'),
 (511,113,2,'2006-02-15 05:09:17'),
 (512,114,1,'2006-02-15 05:09:17'),
 (513,114,1,'2006-02-15 05:09:17'),
 (514,114,1,'2006-02-15 05:09:17'),
 (515,114,1,'2006-02-15 05:09:17'),
 (516,114,2,'2006-02-15 05:09:17'),
 (517,114,2,'2006-02-15 05:09:17'),
 (518,114,2,'2006-02-15 05:09:17'),
 (519,115,1,'2006-02-15 05:09:17'),
 (520,115,1,'2006-02-15 05:09:17'),
 (521,115,1,'2006-02-15 05:09:17'),
 (522,115,2,'2006-02-15 05:09:17'),
 (523,115,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (524,115,2,'2006-02-15 05:09:17'),
 (525,115,2,'2006-02-15 05:09:17'),
 (526,116,1,'2006-02-15 05:09:17'),
 (527,116,1,'2006-02-15 05:09:17'),
 (528,116,2,'2006-02-15 05:09:17'),
 (529,116,2,'2006-02-15 05:09:17'),
 (530,116,2,'2006-02-15 05:09:17'),
 (531,116,2,'2006-02-15 05:09:17'),
 (532,117,1,'2006-02-15 05:09:17'),
 (533,117,1,'2006-02-15 05:09:17'),
 (534,117,1,'2006-02-15 05:09:17'),
 (535,117,1,'2006-02-15 05:09:17'),
 (536,117,2,'2006-02-15 05:09:17'),
 (537,117,2,'2006-02-15 05:09:17'),
 (538,118,1,'2006-02-15 05:09:17'),
 (539,118,1,'2006-02-15 05:09:17'),
 (540,118,1,'2006-02-15 05:09:17'),
 (541,118,1,'2006-02-15 05:09:17'),
 (542,118,2,'2006-02-15 05:09:17'),
 (543,118,2,'2006-02-15 05:09:17'),
 (544,119,1,'2006-02-15 05:09:17'),
 (545,119,1,'2006-02-15 05:09:17'),
 (546,119,1,'2006-02-15 05:09:17'),
 (547,119,2,'2006-02-15 05:09:17'),
 (548,119,2,'2006-02-15 05:09:17'),
 (549,119,2,'2006-02-15 05:09:17'),
 (550,119,2,'2006-02-15 05:09:17'),
 (551,120,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (552,120,1,'2006-02-15 05:09:17'),
 (553,120,1,'2006-02-15 05:09:17'),
 (554,121,1,'2006-02-15 05:09:17'),
 (555,121,1,'2006-02-15 05:09:17'),
 (556,121,1,'2006-02-15 05:09:17'),
 (557,121,2,'2006-02-15 05:09:17'),
 (558,121,2,'2006-02-15 05:09:17'),
 (559,121,2,'2006-02-15 05:09:17'),
 (560,122,1,'2006-02-15 05:09:17'),
 (561,122,1,'2006-02-15 05:09:17'),
 (562,122,1,'2006-02-15 05:09:17'),
 (563,122,1,'2006-02-15 05:09:17'),
 (564,122,2,'2006-02-15 05:09:17'),
 (565,122,2,'2006-02-15 05:09:17'),
 (566,122,2,'2006-02-15 05:09:17'),
 (567,123,1,'2006-02-15 05:09:17'),
 (568,123,1,'2006-02-15 05:09:17'),
 (569,123,2,'2006-02-15 05:09:17'),
 (570,123,2,'2006-02-15 05:09:17'),
 (571,123,2,'2006-02-15 05:09:17'),
 (572,124,2,'2006-02-15 05:09:17'),
 (573,124,2,'2006-02-15 05:09:17'),
 (574,124,2,'2006-02-15 05:09:17'),
 (575,125,2,'2006-02-15 05:09:17'),
 (576,125,2,'2006-02-15 05:09:17'),
 (577,126,2,'2006-02-15 05:09:17'),
 (578,126,2,'2006-02-15 05:09:17'),
 (579,126,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (580,127,1,'2006-02-15 05:09:17'),
 (581,127,1,'2006-02-15 05:09:17'),
 (582,127,1,'2006-02-15 05:09:17'),
 (583,127,1,'2006-02-15 05:09:17'),
 (584,127,2,'2006-02-15 05:09:17'),
 (585,127,2,'2006-02-15 05:09:17'),
 (586,127,2,'2006-02-15 05:09:17'),
 (587,127,2,'2006-02-15 05:09:17'),
 (588,129,1,'2006-02-15 05:09:17'),
 (589,129,1,'2006-02-15 05:09:17'),
 (590,129,1,'2006-02-15 05:09:17'),
 (591,129,2,'2006-02-15 05:09:17'),
 (592,129,2,'2006-02-15 05:09:17'),
 (593,129,2,'2006-02-15 05:09:17'),
 (594,130,1,'2006-02-15 05:09:17'),
 (595,130,1,'2006-02-15 05:09:17'),
 (596,130,2,'2006-02-15 05:09:17'),
 (597,130,2,'2006-02-15 05:09:17'),
 (598,130,2,'2006-02-15 05:09:17'),
 (599,130,2,'2006-02-15 05:09:17'),
 (600,131,1,'2006-02-15 05:09:17'),
 (601,131,1,'2006-02-15 05:09:17'),
 (602,131,1,'2006-02-15 05:09:17'),
 (603,131,1,'2006-02-15 05:09:17'),
 (604,131,2,'2006-02-15 05:09:17'),
 (605,131,2,'2006-02-15 05:09:17'),
 (606,132,1,'2006-02-15 05:09:17'),
 (607,132,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (608,132,1,'2006-02-15 05:09:17'),
 (609,132,1,'2006-02-15 05:09:17'),
 (610,132,2,'2006-02-15 05:09:17'),
 (611,132,2,'2006-02-15 05:09:17'),
 (612,133,1,'2006-02-15 05:09:17'),
 (613,133,1,'2006-02-15 05:09:17'),
 (614,133,2,'2006-02-15 05:09:17'),
 (615,133,2,'2006-02-15 05:09:17'),
 (616,134,2,'2006-02-15 05:09:17'),
 (617,134,2,'2006-02-15 05:09:17'),
 (618,134,2,'2006-02-15 05:09:17'),
 (619,135,1,'2006-02-15 05:09:17'),
 (620,135,1,'2006-02-15 05:09:17'),
 (621,135,1,'2006-02-15 05:09:17'),
 (622,135,2,'2006-02-15 05:09:17'),
 (623,135,2,'2006-02-15 05:09:17'),
 (624,135,2,'2006-02-15 05:09:17'),
 (625,135,2,'2006-02-15 05:09:17'),
 (626,136,1,'2006-02-15 05:09:17'),
 (627,136,1,'2006-02-15 05:09:17'),
 (628,136,1,'2006-02-15 05:09:17'),
 (629,137,2,'2006-02-15 05:09:17'),
 (630,137,2,'2006-02-15 05:09:17'),
 (631,137,2,'2006-02-15 05:09:17'),
 (632,137,2,'2006-02-15 05:09:17'),
 (633,138,1,'2006-02-15 05:09:17'),
 (634,138,1,'2006-02-15 05:09:17'),
 (635,138,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (636,138,2,'2006-02-15 05:09:17'),
 (637,138,2,'2006-02-15 05:09:17'),
 (638,139,1,'2006-02-15 05:09:17'),
 (639,139,1,'2006-02-15 05:09:17'),
 (640,139,1,'2006-02-15 05:09:17'),
 (641,139,1,'2006-02-15 05:09:17'),
 (642,139,2,'2006-02-15 05:09:17'),
 (643,139,2,'2006-02-15 05:09:17'),
 (644,140,1,'2006-02-15 05:09:17'),
 (645,140,1,'2006-02-15 05:09:17'),
 (646,140,2,'2006-02-15 05:09:17'),
 (647,140,2,'2006-02-15 05:09:17'),
 (648,140,2,'2006-02-15 05:09:17'),
 (649,141,1,'2006-02-15 05:09:17'),
 (650,141,1,'2006-02-15 05:09:17'),
 (651,141,1,'2006-02-15 05:09:17'),
 (652,141,2,'2006-02-15 05:09:17'),
 (653,141,2,'2006-02-15 05:09:17'),
 (654,142,1,'2006-02-15 05:09:17'),
 (655,142,1,'2006-02-15 05:09:17'),
 (656,142,1,'2006-02-15 05:09:17'),
 (657,142,2,'2006-02-15 05:09:17'),
 (658,142,2,'2006-02-15 05:09:17'),
 (659,143,1,'2006-02-15 05:09:17'),
 (660,143,1,'2006-02-15 05:09:17'),
 (661,143,1,'2006-02-15 05:09:17'),
 (662,143,1,'2006-02-15 05:09:17'),
 (663,143,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (664,143,2,'2006-02-15 05:09:17'),
 (665,143,2,'2006-02-15 05:09:17'),
 (666,145,2,'2006-02-15 05:09:17'),
 (667,145,2,'2006-02-15 05:09:17'),
 (668,145,2,'2006-02-15 05:09:17'),
 (669,146,1,'2006-02-15 05:09:17'),
 (670,146,1,'2006-02-15 05:09:17'),
 (671,146,1,'2006-02-15 05:09:17'),
 (672,147,1,'2006-02-15 05:09:17'),
 (673,147,1,'2006-02-15 05:09:17'),
 (674,147,1,'2006-02-15 05:09:17'),
 (675,147,2,'2006-02-15 05:09:17'),
 (676,147,2,'2006-02-15 05:09:17'),
 (677,147,2,'2006-02-15 05:09:17'),
 (678,149,1,'2006-02-15 05:09:17'),
 (679,149,1,'2006-02-15 05:09:17'),
 (680,149,1,'2006-02-15 05:09:17'),
 (681,149,2,'2006-02-15 05:09:17'),
 (682,149,2,'2006-02-15 05:09:17'),
 (683,149,2,'2006-02-15 05:09:17'),
 (684,150,1,'2006-02-15 05:09:17'),
 (685,150,1,'2006-02-15 05:09:17'),
 (686,150,2,'2006-02-15 05:09:17'),
 (687,150,2,'2006-02-15 05:09:17'),
 (688,150,2,'2006-02-15 05:09:17'),
 (689,150,2,'2006-02-15 05:09:17'),
 (690,151,1,'2006-02-15 05:09:17'),
 (691,151,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (692,151,2,'2006-02-15 05:09:17'),
 (693,151,2,'2006-02-15 05:09:17'),
 (694,152,1,'2006-02-15 05:09:17'),
 (695,152,1,'2006-02-15 05:09:17'),
 (696,152,1,'2006-02-15 05:09:17'),
 (697,152,1,'2006-02-15 05:09:17'),
 (698,153,1,'2006-02-15 05:09:17'),
 (699,153,1,'2006-02-15 05:09:17'),
 (700,153,1,'2006-02-15 05:09:17'),
 (701,153,1,'2006-02-15 05:09:17'),
 (702,154,1,'2006-02-15 05:09:17'),
 (703,154,1,'2006-02-15 05:09:17'),
 (704,154,1,'2006-02-15 05:09:17'),
 (705,154,2,'2006-02-15 05:09:17'),
 (706,154,2,'2006-02-15 05:09:17'),
 (707,154,2,'2006-02-15 05:09:17'),
 (708,154,2,'2006-02-15 05:09:17'),
 (709,155,1,'2006-02-15 05:09:17'),
 (710,155,1,'2006-02-15 05:09:17'),
 (711,155,2,'2006-02-15 05:09:17'),
 (712,155,2,'2006-02-15 05:09:17'),
 (713,155,2,'2006-02-15 05:09:17'),
 (714,156,2,'2006-02-15 05:09:17'),
 (715,156,2,'2006-02-15 05:09:17'),
 (716,157,2,'2006-02-15 05:09:17'),
 (717,157,2,'2006-02-15 05:09:17'),
 (718,157,2,'2006-02-15 05:09:17'),
 (719,158,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (720,158,1,'2006-02-15 05:09:17'),
 (721,158,2,'2006-02-15 05:09:17'),
 (722,158,2,'2006-02-15 05:09:17'),
 (723,158,2,'2006-02-15 05:09:17'),
 (724,159,1,'2006-02-15 05:09:17'),
 (725,159,1,'2006-02-15 05:09:17'),
 (726,159,1,'2006-02-15 05:09:17'),
 (727,159,1,'2006-02-15 05:09:17'),
 (728,159,2,'2006-02-15 05:09:17'),
 (729,159,2,'2006-02-15 05:09:17'),
 (730,159,2,'2006-02-15 05:09:17'),
 (731,160,1,'2006-02-15 05:09:17'),
 (732,160,1,'2006-02-15 05:09:17'),
 (733,160,2,'2006-02-15 05:09:17'),
 (734,160,2,'2006-02-15 05:09:17'),
 (735,160,2,'2006-02-15 05:09:17'),
 (736,161,1,'2006-02-15 05:09:17'),
 (737,161,1,'2006-02-15 05:09:17'),
 (738,162,1,'2006-02-15 05:09:17'),
 (739,162,1,'2006-02-15 05:09:17'),
 (740,162,1,'2006-02-15 05:09:17'),
 (741,162,2,'2006-02-15 05:09:17'),
 (742,162,2,'2006-02-15 05:09:17'),
 (743,162,2,'2006-02-15 05:09:17'),
 (744,162,2,'2006-02-15 05:09:17'),
 (745,163,2,'2006-02-15 05:09:17'),
 (746,163,2,'2006-02-15 05:09:17'),
 (747,163,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (748,164,1,'2006-02-15 05:09:17'),
 (749,164,1,'2006-02-15 05:09:17'),
 (750,164,2,'2006-02-15 05:09:17'),
 (751,164,2,'2006-02-15 05:09:17'),
 (752,164,2,'2006-02-15 05:09:17'),
 (753,165,1,'2006-02-15 05:09:17'),
 (754,165,1,'2006-02-15 05:09:17'),
 (755,165,1,'2006-02-15 05:09:17'),
 (756,165,2,'2006-02-15 05:09:17'),
 (757,165,2,'2006-02-15 05:09:17'),
 (758,166,1,'2006-02-15 05:09:17'),
 (759,166,1,'2006-02-15 05:09:17'),
 (760,166,1,'2006-02-15 05:09:17'),
 (761,166,1,'2006-02-15 05:09:17'),
 (762,166,2,'2006-02-15 05:09:17'),
 (763,166,2,'2006-02-15 05:09:17'),
 (764,167,1,'2006-02-15 05:09:17'),
 (765,167,1,'2006-02-15 05:09:17'),
 (766,167,1,'2006-02-15 05:09:17'),
 (767,167,1,'2006-02-15 05:09:17'),
 (768,167,2,'2006-02-15 05:09:17'),
 (769,167,2,'2006-02-15 05:09:17'),
 (770,167,2,'2006-02-15 05:09:17'),
 (771,168,1,'2006-02-15 05:09:17'),
 (772,168,1,'2006-02-15 05:09:17'),
 (773,169,1,'2006-02-15 05:09:17'),
 (774,169,1,'2006-02-15 05:09:17'),
 (775,169,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (776,169,2,'2006-02-15 05:09:17'),
 (777,170,1,'2006-02-15 05:09:17'),
 (778,170,1,'2006-02-15 05:09:17'),
 (779,170,2,'2006-02-15 05:09:17'),
 (780,170,2,'2006-02-15 05:09:17'),
 (781,170,2,'2006-02-15 05:09:17'),
 (782,170,2,'2006-02-15 05:09:17'),
 (783,172,1,'2006-02-15 05:09:17'),
 (784,172,1,'2006-02-15 05:09:17'),
 (785,172,1,'2006-02-15 05:09:17'),
 (786,172,1,'2006-02-15 05:09:17'),
 (787,172,2,'2006-02-15 05:09:17'),
 (788,172,2,'2006-02-15 05:09:17'),
 (789,172,2,'2006-02-15 05:09:17'),
 (790,173,1,'2006-02-15 05:09:17'),
 (791,173,1,'2006-02-15 05:09:17'),
 (792,173,1,'2006-02-15 05:09:17'),
 (793,173,2,'2006-02-15 05:09:17'),
 (794,173,2,'2006-02-15 05:09:17'),
 (795,174,1,'2006-02-15 05:09:17'),
 (796,174,1,'2006-02-15 05:09:17'),
 (797,174,1,'2006-02-15 05:09:17'),
 (798,174,1,'2006-02-15 05:09:17'),
 (799,174,2,'2006-02-15 05:09:17'),
 (800,174,2,'2006-02-15 05:09:17'),
 (801,174,2,'2006-02-15 05:09:17'),
 (802,174,2,'2006-02-15 05:09:17'),
 (803,175,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (804,175,1,'2006-02-15 05:09:17'),
 (805,175,2,'2006-02-15 05:09:17'),
 (806,175,2,'2006-02-15 05:09:17'),
 (807,175,2,'2006-02-15 05:09:17'),
 (808,176,1,'2006-02-15 05:09:17'),
 (809,176,1,'2006-02-15 05:09:17'),
 (810,176,2,'2006-02-15 05:09:17'),
 (811,176,2,'2006-02-15 05:09:17'),
 (812,176,2,'2006-02-15 05:09:17'),
 (813,176,2,'2006-02-15 05:09:17'),
 (814,177,2,'2006-02-15 05:09:17'),
 (815,177,2,'2006-02-15 05:09:17'),
 (816,177,2,'2006-02-15 05:09:17'),
 (817,178,1,'2006-02-15 05:09:17'),
 (818,178,1,'2006-02-15 05:09:17'),
 (819,179,1,'2006-02-15 05:09:17'),
 (820,179,1,'2006-02-15 05:09:17'),
 (821,179,1,'2006-02-15 05:09:17'),
 (822,179,1,'2006-02-15 05:09:17'),
 (823,180,2,'2006-02-15 05:09:17'),
 (824,180,2,'2006-02-15 05:09:17'),
 (825,181,1,'2006-02-15 05:09:17'),
 (826,181,1,'2006-02-15 05:09:17'),
 (827,181,1,'2006-02-15 05:09:17'),
 (828,181,2,'2006-02-15 05:09:17'),
 (829,181,2,'2006-02-15 05:09:17'),
 (830,181,2,'2006-02-15 05:09:17'),
 (831,181,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (832,182,1,'2006-02-15 05:09:17'),
 (833,182,1,'2006-02-15 05:09:17'),
 (834,183,1,'2006-02-15 05:09:17'),
 (835,183,1,'2006-02-15 05:09:17'),
 (836,183,1,'2006-02-15 05:09:17'),
 (837,183,2,'2006-02-15 05:09:17'),
 (838,183,2,'2006-02-15 05:09:17'),
 (839,183,2,'2006-02-15 05:09:17'),
 (840,184,1,'2006-02-15 05:09:17'),
 (841,184,1,'2006-02-15 05:09:17'),
 (842,184,2,'2006-02-15 05:09:17'),
 (843,184,2,'2006-02-15 05:09:17'),
 (844,184,2,'2006-02-15 05:09:17'),
 (845,185,1,'2006-02-15 05:09:17'),
 (846,185,1,'2006-02-15 05:09:17'),
 (847,186,1,'2006-02-15 05:09:17'),
 (848,186,1,'2006-02-15 05:09:17'),
 (849,186,2,'2006-02-15 05:09:17'),
 (850,186,2,'2006-02-15 05:09:17'),
 (851,187,2,'2006-02-15 05:09:17'),
 (852,187,2,'2006-02-15 05:09:17'),
 (853,187,2,'2006-02-15 05:09:17'),
 (854,188,1,'2006-02-15 05:09:17'),
 (855,188,1,'2006-02-15 05:09:17'),
 (856,188,1,'2006-02-15 05:09:17'),
 (857,189,1,'2006-02-15 05:09:17'),
 (858,189,1,'2006-02-15 05:09:17'),
 (859,189,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (860,189,2,'2006-02-15 05:09:17'),
 (861,189,2,'2006-02-15 05:09:17'),
 (862,189,2,'2006-02-15 05:09:17'),
 (863,190,2,'2006-02-15 05:09:17'),
 (864,190,2,'2006-02-15 05:09:17'),
 (865,190,2,'2006-02-15 05:09:17'),
 (866,190,2,'2006-02-15 05:09:17'),
 (867,191,1,'2006-02-15 05:09:17'),
 (868,191,1,'2006-02-15 05:09:17'),
 (869,191,1,'2006-02-15 05:09:17'),
 (870,191,2,'2006-02-15 05:09:17'),
 (871,191,2,'2006-02-15 05:09:17'),
 (872,191,2,'2006-02-15 05:09:17'),
 (873,193,1,'2006-02-15 05:09:17'),
 (874,193,1,'2006-02-15 05:09:17'),
 (875,193,1,'2006-02-15 05:09:17'),
 (876,193,1,'2006-02-15 05:09:17'),
 (877,193,2,'2006-02-15 05:09:17'),
 (878,193,2,'2006-02-15 05:09:17'),
 (879,193,2,'2006-02-15 05:09:17'),
 (880,193,2,'2006-02-15 05:09:17'),
 (881,194,1,'2006-02-15 05:09:17'),
 (882,194,1,'2006-02-15 05:09:17'),
 (883,194,2,'2006-02-15 05:09:17'),
 (884,194,2,'2006-02-15 05:09:17'),
 (885,196,1,'2006-02-15 05:09:17'),
 (886,196,1,'2006-02-15 05:09:17'),
 (887,197,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (888,197,1,'2006-02-15 05:09:17'),
 (889,199,1,'2006-02-15 05:09:17'),
 (890,199,1,'2006-02-15 05:09:17'),
 (891,199,1,'2006-02-15 05:09:17'),
 (892,199,1,'2006-02-15 05:09:17'),
 (893,199,2,'2006-02-15 05:09:17'),
 (894,199,2,'2006-02-15 05:09:17'),
 (895,199,2,'2006-02-15 05:09:17'),
 (896,199,2,'2006-02-15 05:09:17'),
 (897,200,1,'2006-02-15 05:09:17'),
 (898,200,1,'2006-02-15 05:09:17'),
 (899,200,1,'2006-02-15 05:09:17'),
 (900,200,1,'2006-02-15 05:09:17'),
 (901,200,2,'2006-02-15 05:09:17'),
 (902,200,2,'2006-02-15 05:09:17'),
 (903,200,2,'2006-02-15 05:09:17'),
 (904,200,2,'2006-02-15 05:09:17'),
 (905,201,1,'2006-02-15 05:09:17'),
 (906,201,1,'2006-02-15 05:09:17'),
 (907,201,1,'2006-02-15 05:09:17'),
 (908,201,1,'2006-02-15 05:09:17'),
 (909,202,1,'2006-02-15 05:09:17'),
 (910,202,1,'2006-02-15 05:09:17'),
 (911,202,1,'2006-02-15 05:09:17'),
 (912,203,2,'2006-02-15 05:09:17'),
 (913,203,2,'2006-02-15 05:09:17'),
 (914,203,2,'2006-02-15 05:09:17'),
 (915,203,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (916,204,1,'2006-02-15 05:09:17'),
 (917,204,1,'2006-02-15 05:09:17'),
 (918,204,1,'2006-02-15 05:09:17'),
 (919,204,1,'2006-02-15 05:09:17'),
 (920,204,2,'2006-02-15 05:09:17'),
 (921,204,2,'2006-02-15 05:09:17'),
 (922,205,1,'2006-02-15 05:09:17'),
 (923,205,1,'2006-02-15 05:09:17'),
 (924,205,1,'2006-02-15 05:09:17'),
 (925,205,1,'2006-02-15 05:09:17'),
 (926,206,1,'2006-02-15 05:09:17'),
 (927,206,1,'2006-02-15 05:09:17'),
 (928,206,1,'2006-02-15 05:09:17'),
 (929,206,1,'2006-02-15 05:09:17'),
 (930,206,2,'2006-02-15 05:09:17'),
 (931,206,2,'2006-02-15 05:09:17'),
 (932,206,2,'2006-02-15 05:09:17'),
 (933,206,2,'2006-02-15 05:09:17'),
 (934,207,1,'2006-02-15 05:09:17'),
 (935,207,1,'2006-02-15 05:09:17'),
 (936,207,1,'2006-02-15 05:09:17'),
 (937,207,1,'2006-02-15 05:09:17'),
 (938,208,1,'2006-02-15 05:09:17'),
 (939,208,1,'2006-02-15 05:09:17'),
 (940,208,1,'2006-02-15 05:09:17'),
 (941,209,1,'2006-02-15 05:09:17'),
 (942,209,1,'2006-02-15 05:09:17'),
 (943,209,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (944,209,1,'2006-02-15 05:09:17'),
 (945,210,2,'2006-02-15 05:09:17'),
 (946,210,2,'2006-02-15 05:09:17'),
 (947,210,2,'2006-02-15 05:09:17'),
 (948,211,1,'2006-02-15 05:09:17'),
 (949,211,1,'2006-02-15 05:09:17'),
 (950,212,1,'2006-02-15 05:09:17'),
 (951,212,1,'2006-02-15 05:09:17'),
 (952,212,1,'2006-02-15 05:09:17'),
 (953,212,2,'2006-02-15 05:09:17'),
 (954,212,2,'2006-02-15 05:09:17'),
 (955,213,1,'2006-02-15 05:09:17'),
 (956,213,1,'2006-02-15 05:09:17'),
 (957,213,1,'2006-02-15 05:09:17'),
 (958,213,1,'2006-02-15 05:09:17'),
 (959,214,2,'2006-02-15 05:09:17'),
 (960,214,2,'2006-02-15 05:09:17'),
 (961,214,2,'2006-02-15 05:09:17'),
 (962,214,2,'2006-02-15 05:09:17'),
 (963,215,1,'2006-02-15 05:09:17'),
 (964,215,1,'2006-02-15 05:09:17'),
 (965,215,1,'2006-02-15 05:09:17'),
 (966,215,2,'2006-02-15 05:09:17'),
 (967,215,2,'2006-02-15 05:09:17'),
 (968,215,2,'2006-02-15 05:09:17'),
 (969,216,1,'2006-02-15 05:09:17'),
 (970,216,1,'2006-02-15 05:09:17'),
 (971,216,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (972,216,2,'2006-02-15 05:09:17'),
 (973,216,2,'2006-02-15 05:09:17'),
 (974,218,1,'2006-02-15 05:09:17'),
 (975,218,1,'2006-02-15 05:09:17'),
 (976,218,1,'2006-02-15 05:09:17'),
 (977,218,1,'2006-02-15 05:09:17'),
 (978,218,2,'2006-02-15 05:09:17'),
 (979,218,2,'2006-02-15 05:09:17'),
 (980,218,2,'2006-02-15 05:09:17'),
 (981,219,1,'2006-02-15 05:09:17'),
 (982,219,1,'2006-02-15 05:09:17'),
 (983,219,1,'2006-02-15 05:09:17'),
 (984,219,1,'2006-02-15 05:09:17'),
 (985,220,1,'2006-02-15 05:09:17'),
 (986,220,1,'2006-02-15 05:09:17'),
 (987,220,1,'2006-02-15 05:09:17'),
 (988,220,1,'2006-02-15 05:09:17'),
 (989,220,2,'2006-02-15 05:09:17'),
 (990,220,2,'2006-02-15 05:09:17'),
 (991,220,2,'2006-02-15 05:09:17'),
 (992,220,2,'2006-02-15 05:09:17'),
 (993,222,1,'2006-02-15 05:09:17'),
 (994,222,1,'2006-02-15 05:09:17'),
 (995,222,2,'2006-02-15 05:09:17'),
 (996,222,2,'2006-02-15 05:09:17'),
 (997,222,2,'2006-02-15 05:09:17'),
 (998,222,2,'2006-02-15 05:09:17'),
 (999,223,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1000,223,2,'2006-02-15 05:09:17'),
 (1001,224,1,'2006-02-15 05:09:17'),
 (1002,224,1,'2006-02-15 05:09:17'),
 (1003,225,1,'2006-02-15 05:09:17'),
 (1004,225,1,'2006-02-15 05:09:17'),
 (1005,225,1,'2006-02-15 05:09:17'),
 (1006,226,1,'2006-02-15 05:09:17'),
 (1007,226,1,'2006-02-15 05:09:17'),
 (1008,226,2,'2006-02-15 05:09:17'),
 (1009,226,2,'2006-02-15 05:09:17'),
 (1010,226,2,'2006-02-15 05:09:17'),
 (1011,227,1,'2006-02-15 05:09:17'),
 (1012,227,1,'2006-02-15 05:09:17'),
 (1013,227,1,'2006-02-15 05:09:17'),
 (1014,227,2,'2006-02-15 05:09:17'),
 (1015,227,2,'2006-02-15 05:09:17'),
 (1016,228,1,'2006-02-15 05:09:17'),
 (1017,228,1,'2006-02-15 05:09:17'),
 (1018,228,1,'2006-02-15 05:09:17'),
 (1019,228,2,'2006-02-15 05:09:17'),
 (1020,228,2,'2006-02-15 05:09:17'),
 (1021,228,2,'2006-02-15 05:09:17'),
 (1022,228,2,'2006-02-15 05:09:17'),
 (1023,229,1,'2006-02-15 05:09:17'),
 (1024,229,1,'2006-02-15 05:09:17'),
 (1025,229,2,'2006-02-15 05:09:17'),
 (1026,229,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1027,230,1,'2006-02-15 05:09:17'),
 (1028,230,1,'2006-02-15 05:09:17'),
 (1029,231,1,'2006-02-15 05:09:17'),
 (1030,231,1,'2006-02-15 05:09:17'),
 (1031,231,1,'2006-02-15 05:09:17'),
 (1032,231,1,'2006-02-15 05:09:17'),
 (1033,231,2,'2006-02-15 05:09:17'),
 (1034,231,2,'2006-02-15 05:09:17'),
 (1035,231,2,'2006-02-15 05:09:17'),
 (1036,231,2,'2006-02-15 05:09:17'),
 (1037,232,1,'2006-02-15 05:09:17'),
 (1038,232,1,'2006-02-15 05:09:17'),
 (1039,232,1,'2006-02-15 05:09:17'),
 (1040,232,2,'2006-02-15 05:09:17'),
 (1041,232,2,'2006-02-15 05:09:17'),
 (1042,233,1,'2006-02-15 05:09:17'),
 (1043,233,1,'2006-02-15 05:09:17'),
 (1044,233,1,'2006-02-15 05:09:17'),
 (1045,233,1,'2006-02-15 05:09:17'),
 (1046,233,2,'2006-02-15 05:09:17'),
 (1047,233,2,'2006-02-15 05:09:17'),
 (1048,234,1,'2006-02-15 05:09:17'),
 (1049,234,1,'2006-02-15 05:09:17'),
 (1050,234,1,'2006-02-15 05:09:17'),
 (1051,234,1,'2006-02-15 05:09:17'),
 (1052,234,2,'2006-02-15 05:09:17'),
 (1053,234,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1054,234,2,'2006-02-15 05:09:17'),
 (1055,235,1,'2006-02-15 05:09:17'),
 (1056,235,1,'2006-02-15 05:09:17'),
 (1057,235,2,'2006-02-15 05:09:17'),
 (1058,235,2,'2006-02-15 05:09:17'),
 (1059,235,2,'2006-02-15 05:09:17'),
 (1060,235,2,'2006-02-15 05:09:17'),
 (1061,236,2,'2006-02-15 05:09:17'),
 (1062,236,2,'2006-02-15 05:09:17'),
 (1063,236,2,'2006-02-15 05:09:17'),
 (1064,236,2,'2006-02-15 05:09:17'),
 (1065,237,1,'2006-02-15 05:09:17'),
 (1066,237,1,'2006-02-15 05:09:17'),
 (1067,238,1,'2006-02-15 05:09:17'),
 (1068,238,1,'2006-02-15 05:09:17'),
 (1069,239,1,'2006-02-15 05:09:17'),
 (1070,239,1,'2006-02-15 05:09:17'),
 (1071,239,1,'2006-02-15 05:09:17'),
 (1072,239,1,'2006-02-15 05:09:17'),
 (1073,239,2,'2006-02-15 05:09:17'),
 (1074,239,2,'2006-02-15 05:09:17'),
 (1075,239,2,'2006-02-15 05:09:17'),
 (1076,239,2,'2006-02-15 05:09:17'),
 (1077,240,2,'2006-02-15 05:09:17'),
 (1078,240,2,'2006-02-15 05:09:17'),
 (1079,240,2,'2006-02-15 05:09:17'),
 (1080,241,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1081,241,1,'2006-02-15 05:09:17'),
 (1082,241,1,'2006-02-15 05:09:17'),
 (1083,241,1,'2006-02-15 05:09:17'),
 (1084,242,1,'2006-02-15 05:09:17'),
 (1085,242,1,'2006-02-15 05:09:17'),
 (1086,242,2,'2006-02-15 05:09:17'),
 (1087,242,2,'2006-02-15 05:09:17'),
 (1088,242,2,'2006-02-15 05:09:17'),
 (1089,243,1,'2006-02-15 05:09:17'),
 (1090,243,1,'2006-02-15 05:09:17'),
 (1091,243,2,'2006-02-15 05:09:17'),
 (1092,243,2,'2006-02-15 05:09:17'),
 (1093,243,2,'2006-02-15 05:09:17'),
 (1094,243,2,'2006-02-15 05:09:17'),
 (1095,244,1,'2006-02-15 05:09:17'),
 (1096,244,1,'2006-02-15 05:09:17'),
 (1097,244,1,'2006-02-15 05:09:17'),
 (1098,244,1,'2006-02-15 05:09:17'),
 (1099,244,2,'2006-02-15 05:09:17'),
 (1100,244,2,'2006-02-15 05:09:17'),
 (1101,244,2,'2006-02-15 05:09:17'),
 (1102,245,1,'2006-02-15 05:09:17'),
 (1103,245,1,'2006-02-15 05:09:17'),
 (1104,245,1,'2006-02-15 05:09:17'),
 (1105,245,2,'2006-02-15 05:09:17'),
 (1106,245,2,'2006-02-15 05:09:17'),
 (1107,245,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1108,245,2,'2006-02-15 05:09:17'),
 (1109,246,2,'2006-02-15 05:09:17'),
 (1110,246,2,'2006-02-15 05:09:17'),
 (1111,246,2,'2006-02-15 05:09:17'),
 (1112,247,1,'2006-02-15 05:09:17'),
 (1113,247,1,'2006-02-15 05:09:17'),
 (1114,247,1,'2006-02-15 05:09:17'),
 (1115,247,2,'2006-02-15 05:09:17'),
 (1116,247,2,'2006-02-15 05:09:17'),
 (1117,247,2,'2006-02-15 05:09:17'),
 (1118,247,2,'2006-02-15 05:09:17'),
 (1119,248,2,'2006-02-15 05:09:17'),
 (1120,248,2,'2006-02-15 05:09:17'),
 (1121,249,1,'2006-02-15 05:09:17'),
 (1122,249,1,'2006-02-15 05:09:17'),
 (1123,249,2,'2006-02-15 05:09:17'),
 (1124,249,2,'2006-02-15 05:09:17'),
 (1125,249,2,'2006-02-15 05:09:17'),
 (1126,249,2,'2006-02-15 05:09:17'),
 (1127,250,2,'2006-02-15 05:09:17'),
 (1128,250,2,'2006-02-15 05:09:17'),
 (1129,250,2,'2006-02-15 05:09:17'),
 (1130,250,2,'2006-02-15 05:09:17'),
 (1131,251,1,'2006-02-15 05:09:17'),
 (1132,251,1,'2006-02-15 05:09:17'),
 (1133,251,2,'2006-02-15 05:09:17'),
 (1134,251,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1135,251,2,'2006-02-15 05:09:17'),
 (1136,252,1,'2006-02-15 05:09:17'),
 (1137,252,1,'2006-02-15 05:09:17'),
 (1138,252,1,'2006-02-15 05:09:17'),
 (1139,252,2,'2006-02-15 05:09:17'),
 (1140,252,2,'2006-02-15 05:09:17'),
 (1141,252,2,'2006-02-15 05:09:17'),
 (1142,253,1,'2006-02-15 05:09:17'),
 (1143,253,1,'2006-02-15 05:09:17'),
 (1144,253,1,'2006-02-15 05:09:17'),
 (1145,253,1,'2006-02-15 05:09:17'),
 (1146,253,2,'2006-02-15 05:09:17'),
 (1147,253,2,'2006-02-15 05:09:17'),
 (1148,254,1,'2006-02-15 05:09:17'),
 (1149,254,1,'2006-02-15 05:09:17'),
 (1150,254,2,'2006-02-15 05:09:17'),
 (1151,254,2,'2006-02-15 05:09:17'),
 (1152,254,2,'2006-02-15 05:09:17'),
 (1153,255,1,'2006-02-15 05:09:17'),
 (1154,255,1,'2006-02-15 05:09:17'),
 (1155,255,1,'2006-02-15 05:09:17'),
 (1156,255,1,'2006-02-15 05:09:17'),
 (1157,255,2,'2006-02-15 05:09:17'),
 (1158,255,2,'2006-02-15 05:09:17'),
 (1159,256,2,'2006-02-15 05:09:17'),
 (1160,256,2,'2006-02-15 05:09:17'),
 (1161,256,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1162,257,2,'2006-02-15 05:09:17'),
 (1163,257,2,'2006-02-15 05:09:17'),
 (1164,257,2,'2006-02-15 05:09:17'),
 (1165,258,2,'2006-02-15 05:09:17'),
 (1166,258,2,'2006-02-15 05:09:17'),
 (1167,258,2,'2006-02-15 05:09:17'),
 (1168,258,2,'2006-02-15 05:09:17'),
 (1169,259,1,'2006-02-15 05:09:17'),
 (1170,259,1,'2006-02-15 05:09:17'),
 (1171,260,2,'2006-02-15 05:09:17'),
 (1172,260,2,'2006-02-15 05:09:17'),
 (1173,260,2,'2006-02-15 05:09:17'),
 (1174,260,2,'2006-02-15 05:09:17'),
 (1175,261,1,'2006-02-15 05:09:17'),
 (1176,261,1,'2006-02-15 05:09:17'),
 (1177,262,2,'2006-02-15 05:09:17'),
 (1178,262,2,'2006-02-15 05:09:17'),
 (1179,263,1,'2006-02-15 05:09:17'),
 (1180,263,1,'2006-02-15 05:09:17'),
 (1181,263,1,'2006-02-15 05:09:17'),
 (1182,263,1,'2006-02-15 05:09:17'),
 (1183,263,2,'2006-02-15 05:09:17'),
 (1184,263,2,'2006-02-15 05:09:17'),
 (1185,263,2,'2006-02-15 05:09:17'),
 (1186,264,2,'2006-02-15 05:09:17'),
 (1187,264,2,'2006-02-15 05:09:17'),
 (1188,265,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1189,265,1,'2006-02-15 05:09:17'),
 (1190,265,1,'2006-02-15 05:09:17'),
 (1191,265,1,'2006-02-15 05:09:17'),
 (1192,266,1,'2006-02-15 05:09:17'),
 (1193,266,1,'2006-02-15 05:09:17'),
 (1194,266,1,'2006-02-15 05:09:17'),
 (1195,266,1,'2006-02-15 05:09:17'),
 (1196,266,2,'2006-02-15 05:09:17'),
 (1197,266,2,'2006-02-15 05:09:17'),
 (1198,266,2,'2006-02-15 05:09:17'),
 (1199,266,2,'2006-02-15 05:09:17'),
 (1200,267,1,'2006-02-15 05:09:17'),
 (1201,267,1,'2006-02-15 05:09:17'),
 (1202,267,1,'2006-02-15 05:09:17'),
 (1203,267,1,'2006-02-15 05:09:17'),
 (1204,267,2,'2006-02-15 05:09:17'),
 (1205,267,2,'2006-02-15 05:09:17'),
 (1206,268,2,'2006-02-15 05:09:17'),
 (1207,268,2,'2006-02-15 05:09:17'),
 (1208,269,1,'2006-02-15 05:09:17'),
 (1209,269,1,'2006-02-15 05:09:17'),
 (1210,269,2,'2006-02-15 05:09:17'),
 (1211,269,2,'2006-02-15 05:09:17'),
 (1212,269,2,'2006-02-15 05:09:17'),
 (1213,269,2,'2006-02-15 05:09:17'),
 (1214,270,1,'2006-02-15 05:09:17'),
 (1215,270,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1216,270,1,'2006-02-15 05:09:17'),
 (1217,270,2,'2006-02-15 05:09:17'),
 (1218,270,2,'2006-02-15 05:09:17'),
 (1219,270,2,'2006-02-15 05:09:17'),
 (1220,270,2,'2006-02-15 05:09:17'),
 (1221,271,1,'2006-02-15 05:09:17'),
 (1222,271,1,'2006-02-15 05:09:17'),
 (1223,271,1,'2006-02-15 05:09:17'),
 (1224,271,2,'2006-02-15 05:09:17'),
 (1225,271,2,'2006-02-15 05:09:17'),
 (1226,272,1,'2006-02-15 05:09:17'),
 (1227,272,1,'2006-02-15 05:09:17'),
 (1228,272,1,'2006-02-15 05:09:17'),
 (1229,272,1,'2006-02-15 05:09:17'),
 (1230,273,1,'2006-02-15 05:09:17'),
 (1231,273,1,'2006-02-15 05:09:17'),
 (1232,273,1,'2006-02-15 05:09:17'),
 (1233,273,1,'2006-02-15 05:09:17'),
 (1234,273,2,'2006-02-15 05:09:17'),
 (1235,273,2,'2006-02-15 05:09:17'),
 (1236,273,2,'2006-02-15 05:09:17'),
 (1237,274,1,'2006-02-15 05:09:17'),
 (1238,274,1,'2006-02-15 05:09:17'),
 (1239,274,1,'2006-02-15 05:09:17'),
 (1240,274,2,'2006-02-15 05:09:17'),
 (1241,274,2,'2006-02-15 05:09:17'),
 (1242,274,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1243,274,2,'2006-02-15 05:09:17'),
 (1244,275,1,'2006-02-15 05:09:17'),
 (1245,275,1,'2006-02-15 05:09:17'),
 (1246,275,1,'2006-02-15 05:09:17'),
 (1247,275,2,'2006-02-15 05:09:17'),
 (1248,275,2,'2006-02-15 05:09:17'),
 (1249,276,1,'2006-02-15 05:09:17'),
 (1250,276,1,'2006-02-15 05:09:17'),
 (1251,276,1,'2006-02-15 05:09:17'),
 (1252,276,1,'2006-02-15 05:09:17'),
 (1253,277,1,'2006-02-15 05:09:17'),
 (1254,277,1,'2006-02-15 05:09:17'),
 (1255,277,1,'2006-02-15 05:09:17'),
 (1256,278,1,'2006-02-15 05:09:17'),
 (1257,278,1,'2006-02-15 05:09:17'),
 (1258,279,1,'2006-02-15 05:09:17'),
 (1259,279,1,'2006-02-15 05:09:17'),
 (1260,280,1,'2006-02-15 05:09:17'),
 (1261,280,1,'2006-02-15 05:09:17'),
 (1262,280,1,'2006-02-15 05:09:17'),
 (1263,280,1,'2006-02-15 05:09:17'),
 (1264,280,2,'2006-02-15 05:09:17'),
 (1265,280,2,'2006-02-15 05:09:17'),
 (1266,281,1,'2006-02-15 05:09:17'),
 (1267,281,1,'2006-02-15 05:09:17'),
 (1268,281,2,'2006-02-15 05:09:17'),
 (1269,281,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1270,281,2,'2006-02-15 05:09:17'),
 (1271,281,2,'2006-02-15 05:09:17'),
 (1272,282,1,'2006-02-15 05:09:17'),
 (1273,282,1,'2006-02-15 05:09:17'),
 (1274,282,1,'2006-02-15 05:09:17'),
 (1275,282,2,'2006-02-15 05:09:17'),
 (1276,282,2,'2006-02-15 05:09:17'),
 (1277,282,2,'2006-02-15 05:09:17'),
 (1278,283,1,'2006-02-15 05:09:17'),
 (1279,283,1,'2006-02-15 05:09:17'),
 (1280,283,1,'2006-02-15 05:09:17'),
 (1281,284,1,'2006-02-15 05:09:17'),
 (1282,284,1,'2006-02-15 05:09:17'),
 (1283,284,1,'2006-02-15 05:09:17'),
 (1284,284,2,'2006-02-15 05:09:17'),
 (1285,284,2,'2006-02-15 05:09:17'),
 (1286,284,2,'2006-02-15 05:09:17'),
 (1287,284,2,'2006-02-15 05:09:17'),
 (1288,285,1,'2006-02-15 05:09:17'),
 (1289,285,1,'2006-02-15 05:09:17'),
 (1290,285,1,'2006-02-15 05:09:17'),
 (1291,285,2,'2006-02-15 05:09:17'),
 (1292,285,2,'2006-02-15 05:09:17'),
 (1293,285,2,'2006-02-15 05:09:17'),
 (1294,285,2,'2006-02-15 05:09:17'),
 (1295,286,1,'2006-02-15 05:09:17'),
 (1296,286,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1297,286,2,'2006-02-15 05:09:17'),
 (1298,286,2,'2006-02-15 05:09:17'),
 (1299,286,2,'2006-02-15 05:09:17'),
 (1300,287,1,'2006-02-15 05:09:17'),
 (1301,287,1,'2006-02-15 05:09:17'),
 (1302,287,2,'2006-02-15 05:09:17'),
 (1303,287,2,'2006-02-15 05:09:17'),
 (1304,288,1,'2006-02-15 05:09:17'),
 (1305,288,1,'2006-02-15 05:09:17'),
 (1306,288,2,'2006-02-15 05:09:17'),
 (1307,288,2,'2006-02-15 05:09:17'),
 (1308,288,2,'2006-02-15 05:09:17'),
 (1309,288,2,'2006-02-15 05:09:17'),
 (1310,289,1,'2006-02-15 05:09:17'),
 (1311,289,1,'2006-02-15 05:09:17'),
 (1312,290,1,'2006-02-15 05:09:17'),
 (1313,290,1,'2006-02-15 05:09:17'),
 (1314,290,1,'2006-02-15 05:09:17'),
 (1315,291,1,'2006-02-15 05:09:17'),
 (1316,291,1,'2006-02-15 05:09:17'),
 (1317,291,1,'2006-02-15 05:09:17'),
 (1318,291,1,'2006-02-15 05:09:17'),
 (1319,292,1,'2006-02-15 05:09:17'),
 (1320,292,1,'2006-02-15 05:09:17'),
 (1321,292,1,'2006-02-15 05:09:17'),
 (1322,292,2,'2006-02-15 05:09:17'),
 (1323,292,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1324,292,2,'2006-02-15 05:09:17'),
 (1325,293,1,'2006-02-15 05:09:17'),
 (1326,293,1,'2006-02-15 05:09:17'),
 (1327,293,2,'2006-02-15 05:09:17'),
 (1328,293,2,'2006-02-15 05:09:17'),
 (1329,293,2,'2006-02-15 05:09:17'),
 (1330,294,1,'2006-02-15 05:09:17'),
 (1331,294,1,'2006-02-15 05:09:17'),
 (1332,294,2,'2006-02-15 05:09:17'),
 (1333,294,2,'2006-02-15 05:09:17'),
 (1334,294,2,'2006-02-15 05:09:17'),
 (1335,295,1,'2006-02-15 05:09:17'),
 (1336,295,1,'2006-02-15 05:09:17'),
 (1337,295,1,'2006-02-15 05:09:17'),
 (1338,295,1,'2006-02-15 05:09:17'),
 (1339,295,2,'2006-02-15 05:09:17'),
 (1340,295,2,'2006-02-15 05:09:17'),
 (1341,295,2,'2006-02-15 05:09:17'),
 (1342,295,2,'2006-02-15 05:09:17'),
 (1343,296,1,'2006-02-15 05:09:17'),
 (1344,296,1,'2006-02-15 05:09:17'),
 (1345,296,1,'2006-02-15 05:09:17'),
 (1346,296,1,'2006-02-15 05:09:17'),
 (1347,297,2,'2006-02-15 05:09:17'),
 (1348,297,2,'2006-02-15 05:09:17'),
 (1349,298,1,'2006-02-15 05:09:17'),
 (1350,298,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1351,298,2,'2006-02-15 05:09:17'),
 (1352,298,2,'2006-02-15 05:09:17'),
 (1353,298,2,'2006-02-15 05:09:17'),
 (1354,299,1,'2006-02-15 05:09:17'),
 (1355,299,1,'2006-02-15 05:09:17'),
 (1356,299,1,'2006-02-15 05:09:17'),
 (1357,299,1,'2006-02-15 05:09:17'),
 (1358,300,1,'2006-02-15 05:09:17'),
 (1359,300,1,'2006-02-15 05:09:17'),
 (1360,300,2,'2006-02-15 05:09:17'),
 (1361,300,2,'2006-02-15 05:09:17'),
 (1362,300,2,'2006-02-15 05:09:17'),
 (1363,300,2,'2006-02-15 05:09:17'),
 (1364,301,1,'2006-02-15 05:09:17'),
 (1365,301,1,'2006-02-15 05:09:17'),
 (1366,301,1,'2006-02-15 05:09:17'),
 (1367,301,1,'2006-02-15 05:09:17'),
 (1368,301,2,'2006-02-15 05:09:17'),
 (1369,301,2,'2006-02-15 05:09:17'),
 (1370,301,2,'2006-02-15 05:09:17'),
 (1371,301,2,'2006-02-15 05:09:17'),
 (1372,302,1,'2006-02-15 05:09:17'),
 (1373,302,1,'2006-02-15 05:09:17'),
 (1374,302,2,'2006-02-15 05:09:17'),
 (1375,302,2,'2006-02-15 05:09:17'),
 (1376,302,2,'2006-02-15 05:09:17'),
 (1377,302,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1378,303,1,'2006-02-15 05:09:17'),
 (1379,303,1,'2006-02-15 05:09:17'),
 (1380,303,1,'2006-02-15 05:09:17'),
 (1381,303,1,'2006-02-15 05:09:17'),
 (1382,303,2,'2006-02-15 05:09:17'),
 (1383,303,2,'2006-02-15 05:09:17'),
 (1384,304,1,'2006-02-15 05:09:17'),
 (1385,304,1,'2006-02-15 05:09:17'),
 (1386,304,1,'2006-02-15 05:09:17'),
 (1387,304,1,'2006-02-15 05:09:17'),
 (1388,304,2,'2006-02-15 05:09:17'),
 (1389,304,2,'2006-02-15 05:09:17'),
 (1390,305,1,'2006-02-15 05:09:17'),
 (1391,305,1,'2006-02-15 05:09:17'),
 (1392,305,1,'2006-02-15 05:09:17'),
 (1393,305,1,'2006-02-15 05:09:17'),
 (1394,305,2,'2006-02-15 05:09:17'),
 (1395,305,2,'2006-02-15 05:09:17'),
 (1396,305,2,'2006-02-15 05:09:17'),
 (1397,306,1,'2006-02-15 05:09:17'),
 (1398,306,1,'2006-02-15 05:09:17'),
 (1399,306,1,'2006-02-15 05:09:17'),
 (1400,307,1,'2006-02-15 05:09:17'),
 (1401,307,1,'2006-02-15 05:09:17'),
 (1402,307,1,'2006-02-15 05:09:17'),
 (1403,307,2,'2006-02-15 05:09:17'),
 (1404,307,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1405,307,2,'2006-02-15 05:09:17'),
 (1406,308,1,'2006-02-15 05:09:17'),
 (1407,308,1,'2006-02-15 05:09:17'),
 (1408,308,2,'2006-02-15 05:09:17'),
 (1409,308,2,'2006-02-15 05:09:17'),
 (1410,309,1,'2006-02-15 05:09:17'),
 (1411,309,1,'2006-02-15 05:09:17'),
 (1412,309,2,'2006-02-15 05:09:17'),
 (1413,309,2,'2006-02-15 05:09:17'),
 (1414,309,2,'2006-02-15 05:09:17'),
 (1415,309,2,'2006-02-15 05:09:17'),
 (1416,310,1,'2006-02-15 05:09:17'),
 (1417,310,1,'2006-02-15 05:09:17'),
 (1418,311,1,'2006-02-15 05:09:17'),
 (1419,311,1,'2006-02-15 05:09:17'),
 (1420,311,1,'2006-02-15 05:09:17'),
 (1421,311,2,'2006-02-15 05:09:17'),
 (1422,311,2,'2006-02-15 05:09:17'),
 (1423,311,2,'2006-02-15 05:09:17'),
 (1424,311,2,'2006-02-15 05:09:17'),
 (1425,312,2,'2006-02-15 05:09:17'),
 (1426,312,2,'2006-02-15 05:09:17'),
 (1427,312,2,'2006-02-15 05:09:17'),
 (1428,313,1,'2006-02-15 05:09:17'),
 (1429,313,1,'2006-02-15 05:09:17'),
 (1430,313,1,'2006-02-15 05:09:17'),
 (1431,313,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1432,313,2,'2006-02-15 05:09:17'),
 (1433,313,2,'2006-02-15 05:09:17'),
 (1434,314,1,'2006-02-15 05:09:17'),
 (1435,314,1,'2006-02-15 05:09:17'),
 (1436,314,2,'2006-02-15 05:09:17'),
 (1437,314,2,'2006-02-15 05:09:17'),
 (1438,314,2,'2006-02-15 05:09:17'),
 (1439,314,2,'2006-02-15 05:09:17'),
 (1440,315,2,'2006-02-15 05:09:17'),
 (1441,315,2,'2006-02-15 05:09:17'),
 (1442,315,2,'2006-02-15 05:09:17'),
 (1443,316,2,'2006-02-15 05:09:17'),
 (1444,316,2,'2006-02-15 05:09:17'),
 (1445,317,1,'2006-02-15 05:09:17'),
 (1446,317,1,'2006-02-15 05:09:17'),
 (1447,317,1,'2006-02-15 05:09:17'),
 (1448,317,1,'2006-02-15 05:09:17'),
 (1449,317,2,'2006-02-15 05:09:17'),
 (1450,317,2,'2006-02-15 05:09:17'),
 (1451,317,2,'2006-02-15 05:09:17'),
 (1452,319,1,'2006-02-15 05:09:17'),
 (1453,319,1,'2006-02-15 05:09:17'),
 (1454,319,1,'2006-02-15 05:09:17'),
 (1455,319,2,'2006-02-15 05:09:17'),
 (1456,319,2,'2006-02-15 05:09:17'),
 (1457,319,2,'2006-02-15 05:09:17'),
 (1458,319,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1459,320,1,'2006-02-15 05:09:17'),
 (1460,320,1,'2006-02-15 05:09:17'),
 (1461,320,1,'2006-02-15 05:09:17'),
 (1462,320,2,'2006-02-15 05:09:17'),
 (1463,320,2,'2006-02-15 05:09:17'),
 (1464,320,2,'2006-02-15 05:09:17'),
 (1465,320,2,'2006-02-15 05:09:17'),
 (1466,321,1,'2006-02-15 05:09:17'),
 (1467,321,1,'2006-02-15 05:09:17'),
 (1468,321,1,'2006-02-15 05:09:17'),
 (1469,321,1,'2006-02-15 05:09:17'),
 (1470,322,1,'2006-02-15 05:09:17'),
 (1471,322,1,'2006-02-15 05:09:17'),
 (1472,322,1,'2006-02-15 05:09:17'),
 (1473,322,1,'2006-02-15 05:09:17'),
 (1474,322,2,'2006-02-15 05:09:17'),
 (1475,322,2,'2006-02-15 05:09:17'),
 (1476,323,2,'2006-02-15 05:09:17'),
 (1477,323,2,'2006-02-15 05:09:17'),
 (1478,323,2,'2006-02-15 05:09:17'),
 (1479,323,2,'2006-02-15 05:09:17'),
 (1480,324,1,'2006-02-15 05:09:17'),
 (1481,324,1,'2006-02-15 05:09:17'),
 (1482,324,1,'2006-02-15 05:09:17'),
 (1483,324,2,'2006-02-15 05:09:17'),
 (1484,324,2,'2006-02-15 05:09:17'),
 (1485,326,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1486,326,1,'2006-02-15 05:09:17'),
 (1487,326,2,'2006-02-15 05:09:17'),
 (1488,326,2,'2006-02-15 05:09:17'),
 (1489,326,2,'2006-02-15 05:09:17'),
 (1490,326,2,'2006-02-15 05:09:17'),
 (1491,327,1,'2006-02-15 05:09:17'),
 (1492,327,1,'2006-02-15 05:09:17'),
 (1493,327,1,'2006-02-15 05:09:17'),
 (1494,327,1,'2006-02-15 05:09:17'),
 (1495,327,2,'2006-02-15 05:09:17'),
 (1496,327,2,'2006-02-15 05:09:17'),
 (1497,328,2,'2006-02-15 05:09:17'),
 (1498,328,2,'2006-02-15 05:09:17'),
 (1499,328,2,'2006-02-15 05:09:17'),
 (1500,328,2,'2006-02-15 05:09:17'),
 (1501,329,1,'2006-02-15 05:09:17'),
 (1502,329,1,'2006-02-15 05:09:17'),
 (1503,329,1,'2006-02-15 05:09:17'),
 (1504,329,2,'2006-02-15 05:09:17'),
 (1505,329,2,'2006-02-15 05:09:17'),
 (1506,329,2,'2006-02-15 05:09:17'),
 (1507,330,1,'2006-02-15 05:09:17'),
 (1508,330,1,'2006-02-15 05:09:17'),
 (1509,330,1,'2006-02-15 05:09:17'),
 (1510,330,1,'2006-02-15 05:09:17'),
 (1511,330,2,'2006-02-15 05:09:17'),
 (1512,330,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1513,330,2,'2006-02-15 05:09:17'),
 (1514,331,1,'2006-02-15 05:09:17'),
 (1515,331,1,'2006-02-15 05:09:17'),
 (1516,331,1,'2006-02-15 05:09:17'),
 (1517,331,1,'2006-02-15 05:09:17'),
 (1518,331,2,'2006-02-15 05:09:17'),
 (1519,331,2,'2006-02-15 05:09:17'),
 (1520,331,2,'2006-02-15 05:09:17'),
 (1521,331,2,'2006-02-15 05:09:17'),
 (1522,333,1,'2006-02-15 05:09:17'),
 (1523,333,1,'2006-02-15 05:09:17'),
 (1524,333,2,'2006-02-15 05:09:17'),
 (1525,333,2,'2006-02-15 05:09:17'),
 (1526,334,1,'2006-02-15 05:09:17'),
 (1527,334,1,'2006-02-15 05:09:17'),
 (1528,334,2,'2006-02-15 05:09:17'),
 (1529,334,2,'2006-02-15 05:09:17'),
 (1530,334,2,'2006-02-15 05:09:17'),
 (1531,334,2,'2006-02-15 05:09:17'),
 (1532,335,1,'2006-02-15 05:09:17'),
 (1533,335,1,'2006-02-15 05:09:17'),
 (1534,336,1,'2006-02-15 05:09:17'),
 (1535,336,1,'2006-02-15 05:09:17'),
 (1536,336,1,'2006-02-15 05:09:17'),
 (1537,336,2,'2006-02-15 05:09:17'),
 (1538,336,2,'2006-02-15 05:09:17'),
 (1539,337,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1540,337,1,'2006-02-15 05:09:17'),
 (1541,337,2,'2006-02-15 05:09:17'),
 (1542,337,2,'2006-02-15 05:09:17'),
 (1543,338,2,'2006-02-15 05:09:17'),
 (1544,338,2,'2006-02-15 05:09:17'),
 (1545,338,2,'2006-02-15 05:09:17'),
 (1546,339,2,'2006-02-15 05:09:17'),
 (1547,339,2,'2006-02-15 05:09:17'),
 (1548,339,2,'2006-02-15 05:09:17'),
 (1549,340,1,'2006-02-15 05:09:17'),
 (1550,340,1,'2006-02-15 05:09:17'),
 (1551,341,1,'2006-02-15 05:09:17'),
 (1552,341,1,'2006-02-15 05:09:17'),
 (1553,341,1,'2006-02-15 05:09:17'),
 (1554,341,1,'2006-02-15 05:09:17'),
 (1555,341,2,'2006-02-15 05:09:17'),
 (1556,341,2,'2006-02-15 05:09:17'),
 (1557,341,2,'2006-02-15 05:09:17'),
 (1558,341,2,'2006-02-15 05:09:17'),
 (1559,342,1,'2006-02-15 05:09:17'),
 (1560,342,1,'2006-02-15 05:09:17'),
 (1561,342,1,'2006-02-15 05:09:17'),
 (1562,342,1,'2006-02-15 05:09:17'),
 (1563,343,1,'2006-02-15 05:09:17'),
 (1564,343,1,'2006-02-15 05:09:17'),
 (1565,344,1,'2006-02-15 05:09:17'),
 (1566,344,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1567,344,1,'2006-02-15 05:09:17'),
 (1568,344,2,'2006-02-15 05:09:17'),
 (1569,344,2,'2006-02-15 05:09:17'),
 (1570,345,1,'2006-02-15 05:09:17'),
 (1571,345,1,'2006-02-15 05:09:17'),
 (1572,345,1,'2006-02-15 05:09:17'),
 (1573,345,2,'2006-02-15 05:09:17'),
 (1574,345,2,'2006-02-15 05:09:17'),
 (1575,346,1,'2006-02-15 05:09:17'),
 (1576,346,1,'2006-02-15 05:09:17'),
 (1577,346,2,'2006-02-15 05:09:17'),
 (1578,346,2,'2006-02-15 05:09:17'),
 (1579,346,2,'2006-02-15 05:09:17'),
 (1580,346,2,'2006-02-15 05:09:17'),
 (1581,347,1,'2006-02-15 05:09:17'),
 (1582,347,1,'2006-02-15 05:09:17'),
 (1583,347,1,'2006-02-15 05:09:17'),
 (1584,347,1,'2006-02-15 05:09:17'),
 (1585,348,2,'2006-02-15 05:09:17'),
 (1586,348,2,'2006-02-15 05:09:17'),
 (1587,348,2,'2006-02-15 05:09:17'),
 (1588,348,2,'2006-02-15 05:09:17'),
 (1589,349,1,'2006-02-15 05:09:17'),
 (1590,349,1,'2006-02-15 05:09:17'),
 (1591,349,1,'2006-02-15 05:09:17'),
 (1592,349,1,'2006-02-15 05:09:17'),
 (1593,349,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1594,349,2,'2006-02-15 05:09:17'),
 (1595,349,2,'2006-02-15 05:09:17'),
 (1596,350,1,'2006-02-15 05:09:17'),
 (1597,350,1,'2006-02-15 05:09:17'),
 (1598,350,1,'2006-02-15 05:09:17'),
 (1599,350,1,'2006-02-15 05:09:17'),
 (1600,350,2,'2006-02-15 05:09:17'),
 (1601,350,2,'2006-02-15 05:09:17'),
 (1602,350,2,'2006-02-15 05:09:17'),
 (1603,350,2,'2006-02-15 05:09:17'),
 (1604,351,1,'2006-02-15 05:09:17'),
 (1605,351,1,'2006-02-15 05:09:17'),
 (1606,351,1,'2006-02-15 05:09:17'),
 (1607,351,2,'2006-02-15 05:09:17'),
 (1608,351,2,'2006-02-15 05:09:17'),
 (1609,351,2,'2006-02-15 05:09:17'),
 (1610,352,2,'2006-02-15 05:09:17'),
 (1611,352,2,'2006-02-15 05:09:17'),
 (1612,352,2,'2006-02-15 05:09:17'),
 (1613,352,2,'2006-02-15 05:09:17'),
 (1614,353,1,'2006-02-15 05:09:17'),
 (1615,353,1,'2006-02-15 05:09:17'),
 (1616,353,2,'2006-02-15 05:09:17'),
 (1617,353,2,'2006-02-15 05:09:17'),
 (1618,353,2,'2006-02-15 05:09:17'),
 (1619,353,2,'2006-02-15 05:09:17'),
 (1620,354,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1621,354,1,'2006-02-15 05:09:17'),
 (1622,354,1,'2006-02-15 05:09:17'),
 (1623,354,2,'2006-02-15 05:09:17'),
 (1624,354,2,'2006-02-15 05:09:17'),
 (1625,355,2,'2006-02-15 05:09:17'),
 (1626,355,2,'2006-02-15 05:09:17'),
 (1627,356,1,'2006-02-15 05:09:17'),
 (1628,356,1,'2006-02-15 05:09:17'),
 (1629,356,1,'2006-02-15 05:09:17'),
 (1630,356,1,'2006-02-15 05:09:17'),
 (1631,356,2,'2006-02-15 05:09:17'),
 (1632,356,2,'2006-02-15 05:09:17'),
 (1633,356,2,'2006-02-15 05:09:17'),
 (1634,356,2,'2006-02-15 05:09:17'),
 (1635,357,2,'2006-02-15 05:09:17'),
 (1636,357,2,'2006-02-15 05:09:17'),
 (1637,357,2,'2006-02-15 05:09:17'),
 (1638,357,2,'2006-02-15 05:09:17'),
 (1639,358,1,'2006-02-15 05:09:17'),
 (1640,358,1,'2006-02-15 05:09:17'),
 (1641,358,1,'2006-02-15 05:09:17'),
 (1642,358,1,'2006-02-15 05:09:17'),
 (1643,358,2,'2006-02-15 05:09:17'),
 (1644,358,2,'2006-02-15 05:09:17'),
 (1645,358,2,'2006-02-15 05:09:17'),
 (1646,358,2,'2006-02-15 05:09:17'),
 (1647,360,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1648,360,1,'2006-02-15 05:09:17'),
 (1649,360,1,'2006-02-15 05:09:17'),
 (1650,360,1,'2006-02-15 05:09:17'),
 (1651,361,1,'2006-02-15 05:09:17'),
 (1652,361,1,'2006-02-15 05:09:17'),
 (1653,361,1,'2006-02-15 05:09:17'),
 (1654,361,1,'2006-02-15 05:09:17'),
 (1655,361,2,'2006-02-15 05:09:17'),
 (1656,361,2,'2006-02-15 05:09:17'),
 (1657,361,2,'2006-02-15 05:09:17'),
 (1658,361,2,'2006-02-15 05:09:17'),
 (1659,362,1,'2006-02-15 05:09:17'),
 (1660,362,1,'2006-02-15 05:09:17'),
 (1661,363,1,'2006-02-15 05:09:17'),
 (1662,363,1,'2006-02-15 05:09:17'),
 (1663,363,1,'2006-02-15 05:09:17'),
 (1664,363,2,'2006-02-15 05:09:17'),
 (1665,363,2,'2006-02-15 05:09:17'),
 (1666,363,2,'2006-02-15 05:09:17'),
 (1667,364,1,'2006-02-15 05:09:17'),
 (1668,364,1,'2006-02-15 05:09:17'),
 (1669,364,1,'2006-02-15 05:09:17'),
 (1670,365,1,'2006-02-15 05:09:17'),
 (1671,365,1,'2006-02-15 05:09:17'),
 (1672,365,2,'2006-02-15 05:09:17'),
 (1673,365,2,'2006-02-15 05:09:17'),
 (1674,366,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1675,366,1,'2006-02-15 05:09:17'),
 (1676,366,1,'2006-02-15 05:09:17'),
 (1677,366,1,'2006-02-15 05:09:17'),
 (1678,366,2,'2006-02-15 05:09:17'),
 (1679,366,2,'2006-02-15 05:09:17'),
 (1680,366,2,'2006-02-15 05:09:17'),
 (1681,367,1,'2006-02-15 05:09:17'),
 (1682,367,1,'2006-02-15 05:09:17'),
 (1683,367,1,'2006-02-15 05:09:17'),
 (1684,367,1,'2006-02-15 05:09:17'),
 (1685,367,2,'2006-02-15 05:09:17'),
 (1686,367,2,'2006-02-15 05:09:17'),
 (1687,367,2,'2006-02-15 05:09:17'),
 (1688,368,1,'2006-02-15 05:09:17'),
 (1689,368,1,'2006-02-15 05:09:17'),
 (1690,369,1,'2006-02-15 05:09:17'),
 (1691,369,1,'2006-02-15 05:09:17'),
 (1692,369,1,'2006-02-15 05:09:17'),
 (1693,369,1,'2006-02-15 05:09:17'),
 (1694,369,2,'2006-02-15 05:09:17'),
 (1695,369,2,'2006-02-15 05:09:17'),
 (1696,369,2,'2006-02-15 05:09:17'),
 (1697,369,2,'2006-02-15 05:09:17'),
 (1698,370,1,'2006-02-15 05:09:17'),
 (1699,370,1,'2006-02-15 05:09:17'),
 (1700,370,1,'2006-02-15 05:09:17'),
 (1701,370,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1702,370,2,'2006-02-15 05:09:17'),
 (1703,371,1,'2006-02-15 05:09:17'),
 (1704,371,1,'2006-02-15 05:09:17'),
 (1705,371,1,'2006-02-15 05:09:17'),
 (1706,372,1,'2006-02-15 05:09:17'),
 (1707,372,1,'2006-02-15 05:09:17'),
 (1708,373,1,'2006-02-15 05:09:17'),
 (1709,373,1,'2006-02-15 05:09:17'),
 (1710,373,1,'2006-02-15 05:09:17'),
 (1711,373,2,'2006-02-15 05:09:17'),
 (1712,373,2,'2006-02-15 05:09:17'),
 (1713,374,1,'2006-02-15 05:09:17'),
 (1714,374,1,'2006-02-15 05:09:17'),
 (1715,374,1,'2006-02-15 05:09:17'),
 (1716,374,2,'2006-02-15 05:09:17'),
 (1717,374,2,'2006-02-15 05:09:17'),
 (1718,374,2,'2006-02-15 05:09:17'),
 (1719,374,2,'2006-02-15 05:09:17'),
 (1720,375,1,'2006-02-15 05:09:17'),
 (1721,375,1,'2006-02-15 05:09:17'),
 (1722,376,1,'2006-02-15 05:09:17'),
 (1723,376,1,'2006-02-15 05:09:17'),
 (1724,376,1,'2006-02-15 05:09:17'),
 (1725,376,1,'2006-02-15 05:09:17'),
 (1726,376,2,'2006-02-15 05:09:17'),
 (1727,376,2,'2006-02-15 05:09:17'),
 (1728,376,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1729,377,1,'2006-02-15 05:09:17'),
 (1730,377,1,'2006-02-15 05:09:17'),
 (1731,377,1,'2006-02-15 05:09:17'),
 (1732,377,2,'2006-02-15 05:09:17'),
 (1733,377,2,'2006-02-15 05:09:17'),
 (1734,377,2,'2006-02-15 05:09:17'),
 (1735,378,1,'2006-02-15 05:09:17'),
 (1736,378,1,'2006-02-15 05:09:17'),
 (1737,378,1,'2006-02-15 05:09:17'),
 (1738,378,1,'2006-02-15 05:09:17'),
 (1739,378,2,'2006-02-15 05:09:17'),
 (1740,378,2,'2006-02-15 05:09:17'),
 (1741,378,2,'2006-02-15 05:09:17'),
 (1742,378,2,'2006-02-15 05:09:17'),
 (1743,379,2,'2006-02-15 05:09:17'),
 (1744,379,2,'2006-02-15 05:09:17'),
 (1745,379,2,'2006-02-15 05:09:17'),
 (1746,379,2,'2006-02-15 05:09:17'),
 (1747,380,1,'2006-02-15 05:09:17'),
 (1748,380,1,'2006-02-15 05:09:17'),
 (1749,380,2,'2006-02-15 05:09:17'),
 (1750,380,2,'2006-02-15 05:09:17'),
 (1751,380,2,'2006-02-15 05:09:17'),
 (1752,381,1,'2006-02-15 05:09:17'),
 (1753,381,1,'2006-02-15 05:09:17'),
 (1754,381,2,'2006-02-15 05:09:17'),
 (1755,381,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1756,381,2,'2006-02-15 05:09:17'),
 (1757,382,1,'2006-02-15 05:09:17'),
 (1758,382,1,'2006-02-15 05:09:17'),
 (1759,382,1,'2006-02-15 05:09:17'),
 (1760,382,1,'2006-02-15 05:09:17'),
 (1761,382,2,'2006-02-15 05:09:17'),
 (1762,382,2,'2006-02-15 05:09:17'),
 (1763,382,2,'2006-02-15 05:09:17'),
 (1764,382,2,'2006-02-15 05:09:17'),
 (1765,383,1,'2006-02-15 05:09:17'),
 (1766,383,1,'2006-02-15 05:09:17'),
 (1767,383,1,'2006-02-15 05:09:17'),
 (1768,383,2,'2006-02-15 05:09:17'),
 (1769,383,2,'2006-02-15 05:09:17'),
 (1770,384,2,'2006-02-15 05:09:17'),
 (1771,384,2,'2006-02-15 05:09:17'),
 (1772,384,2,'2006-02-15 05:09:17'),
 (1773,385,1,'2006-02-15 05:09:17'),
 (1774,385,1,'2006-02-15 05:09:17'),
 (1775,385,2,'2006-02-15 05:09:17'),
 (1776,385,2,'2006-02-15 05:09:17'),
 (1777,385,2,'2006-02-15 05:09:17'),
 (1778,387,1,'2006-02-15 05:09:17'),
 (1779,387,1,'2006-02-15 05:09:17'),
 (1780,387,1,'2006-02-15 05:09:17'),
 (1781,387,2,'2006-02-15 05:09:17'),
 (1782,387,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1783,387,2,'2006-02-15 05:09:17'),
 (1784,388,1,'2006-02-15 05:09:17'),
 (1785,388,1,'2006-02-15 05:09:17'),
 (1786,388,1,'2006-02-15 05:09:17'),
 (1787,388,2,'2006-02-15 05:09:17'),
 (1788,388,2,'2006-02-15 05:09:17'),
 (1789,388,2,'2006-02-15 05:09:17'),
 (1790,389,1,'2006-02-15 05:09:17'),
 (1791,389,1,'2006-02-15 05:09:17'),
 (1792,389,2,'2006-02-15 05:09:17'),
 (1793,389,2,'2006-02-15 05:09:17'),
 (1794,390,1,'2006-02-15 05:09:17'),
 (1795,390,1,'2006-02-15 05:09:17'),
 (1796,390,1,'2006-02-15 05:09:17'),
 (1797,391,1,'2006-02-15 05:09:17'),
 (1798,391,1,'2006-02-15 05:09:17'),
 (1799,391,1,'2006-02-15 05:09:17'),
 (1800,391,1,'2006-02-15 05:09:17'),
 (1801,391,2,'2006-02-15 05:09:17'),
 (1802,391,2,'2006-02-15 05:09:17'),
 (1803,391,2,'2006-02-15 05:09:17'),
 (1804,392,1,'2006-02-15 05:09:17'),
 (1805,392,1,'2006-02-15 05:09:17'),
 (1806,392,1,'2006-02-15 05:09:17'),
 (1807,392,1,'2006-02-15 05:09:17'),
 (1808,392,2,'2006-02-15 05:09:17'),
 (1809,392,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1810,393,1,'2006-02-15 05:09:17'),
 (1811,393,1,'2006-02-15 05:09:17'),
 (1812,394,1,'2006-02-15 05:09:17'),
 (1813,394,1,'2006-02-15 05:09:17'),
 (1814,394,1,'2006-02-15 05:09:17'),
 (1815,394,1,'2006-02-15 05:09:17'),
 (1816,395,1,'2006-02-15 05:09:17'),
 (1817,395,1,'2006-02-15 05:09:17'),
 (1818,395,1,'2006-02-15 05:09:17'),
 (1819,395,2,'2006-02-15 05:09:17'),
 (1820,395,2,'2006-02-15 05:09:17'),
 (1821,395,2,'2006-02-15 05:09:17'),
 (1822,396,2,'2006-02-15 05:09:17'),
 (1823,396,2,'2006-02-15 05:09:17'),
 (1824,396,2,'2006-02-15 05:09:17'),
 (1825,396,2,'2006-02-15 05:09:17'),
 (1826,397,1,'2006-02-15 05:09:17'),
 (1827,397,1,'2006-02-15 05:09:17'),
 (1828,397,1,'2006-02-15 05:09:17'),
 (1829,397,2,'2006-02-15 05:09:17'),
 (1830,397,2,'2006-02-15 05:09:17'),
 (1831,397,2,'2006-02-15 05:09:17'),
 (1832,397,2,'2006-02-15 05:09:17'),
 (1833,398,2,'2006-02-15 05:09:17'),
 (1834,398,2,'2006-02-15 05:09:17'),
 (1835,398,2,'2006-02-15 05:09:17'),
 (1836,398,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1837,399,2,'2006-02-15 05:09:17'),
 (1838,399,2,'2006-02-15 05:09:17'),
 (1839,400,1,'2006-02-15 05:09:17'),
 (1840,400,1,'2006-02-15 05:09:17'),
 (1841,401,1,'2006-02-15 05:09:17'),
 (1842,401,1,'2006-02-15 05:09:17'),
 (1843,402,1,'2006-02-15 05:09:17'),
 (1844,402,1,'2006-02-15 05:09:17'),
 (1845,402,1,'2006-02-15 05:09:17'),
 (1846,402,2,'2006-02-15 05:09:17'),
 (1847,402,2,'2006-02-15 05:09:17'),
 (1848,402,2,'2006-02-15 05:09:17'),
 (1849,403,1,'2006-02-15 05:09:17'),
 (1850,403,1,'2006-02-15 05:09:17'),
 (1851,403,1,'2006-02-15 05:09:17'),
 (1852,403,1,'2006-02-15 05:09:17'),
 (1853,403,2,'2006-02-15 05:09:17'),
 (1854,403,2,'2006-02-15 05:09:17'),
 (1855,403,2,'2006-02-15 05:09:17'),
 (1856,403,2,'2006-02-15 05:09:17'),
 (1857,405,2,'2006-02-15 05:09:17'),
 (1858,405,2,'2006-02-15 05:09:17'),
 (1859,406,1,'2006-02-15 05:09:17'),
 (1860,406,1,'2006-02-15 05:09:17'),
 (1861,406,2,'2006-02-15 05:09:17'),
 (1862,406,2,'2006-02-15 05:09:17'),
 (1863,406,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1864,406,2,'2006-02-15 05:09:17'),
 (1865,407,1,'2006-02-15 05:09:17'),
 (1866,407,1,'2006-02-15 05:09:17'),
 (1867,408,1,'2006-02-15 05:09:17'),
 (1868,408,1,'2006-02-15 05:09:17'),
 (1869,408,1,'2006-02-15 05:09:17'),
 (1870,408,1,'2006-02-15 05:09:17'),
 (1871,408,2,'2006-02-15 05:09:17'),
 (1872,408,2,'2006-02-15 05:09:17'),
 (1873,408,2,'2006-02-15 05:09:17'),
 (1874,409,1,'2006-02-15 05:09:17'),
 (1875,409,1,'2006-02-15 05:09:17'),
 (1876,409,1,'2006-02-15 05:09:17'),
 (1877,409,1,'2006-02-15 05:09:17'),
 (1878,409,2,'2006-02-15 05:09:17'),
 (1879,409,2,'2006-02-15 05:09:17'),
 (1880,409,2,'2006-02-15 05:09:17'),
 (1881,410,1,'2006-02-15 05:09:17'),
 (1882,410,1,'2006-02-15 05:09:17'),
 (1883,410,1,'2006-02-15 05:09:17'),
 (1884,410,2,'2006-02-15 05:09:17'),
 (1885,410,2,'2006-02-15 05:09:17'),
 (1886,411,1,'2006-02-15 05:09:17'),
 (1887,411,1,'2006-02-15 05:09:17'),
 (1888,412,1,'2006-02-15 05:09:17'),
 (1889,412,1,'2006-02-15 05:09:17'),
 (1890,412,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1891,412,1,'2006-02-15 05:09:17'),
 (1892,412,2,'2006-02-15 05:09:17'),
 (1893,412,2,'2006-02-15 05:09:17'),
 (1894,412,2,'2006-02-15 05:09:17'),
 (1895,412,2,'2006-02-15 05:09:17'),
 (1896,413,1,'2006-02-15 05:09:17'),
 (1897,413,1,'2006-02-15 05:09:17'),
 (1898,413,1,'2006-02-15 05:09:17'),
 (1899,414,1,'2006-02-15 05:09:17'),
 (1900,414,1,'2006-02-15 05:09:17'),
 (1901,414,1,'2006-02-15 05:09:17'),
 (1902,414,2,'2006-02-15 05:09:17'),
 (1903,414,2,'2006-02-15 05:09:17'),
 (1904,414,2,'2006-02-15 05:09:17'),
 (1905,415,1,'2006-02-15 05:09:17'),
 (1906,415,1,'2006-02-15 05:09:17'),
 (1907,415,1,'2006-02-15 05:09:17'),
 (1908,415,2,'2006-02-15 05:09:17'),
 (1909,415,2,'2006-02-15 05:09:17'),
 (1910,415,2,'2006-02-15 05:09:17'),
 (1911,416,1,'2006-02-15 05:09:17'),
 (1912,416,1,'2006-02-15 05:09:17'),
 (1913,416,2,'2006-02-15 05:09:17'),
 (1914,416,2,'2006-02-15 05:09:17'),
 (1915,416,2,'2006-02-15 05:09:17'),
 (1916,416,2,'2006-02-15 05:09:17'),
 (1917,417,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1918,417,1,'2006-02-15 05:09:17'),
 (1919,417,1,'2006-02-15 05:09:17'),
 (1920,417,1,'2006-02-15 05:09:17'),
 (1921,417,2,'2006-02-15 05:09:17'),
 (1922,417,2,'2006-02-15 05:09:17'),
 (1923,418,1,'2006-02-15 05:09:17'),
 (1924,418,1,'2006-02-15 05:09:17'),
 (1925,418,1,'2006-02-15 05:09:17'),
 (1926,418,1,'2006-02-15 05:09:17'),
 (1927,418,2,'2006-02-15 05:09:17'),
 (1928,418,2,'2006-02-15 05:09:17'),
 (1929,418,2,'2006-02-15 05:09:17'),
 (1930,418,2,'2006-02-15 05:09:17'),
 (1931,420,1,'2006-02-15 05:09:17'),
 (1932,420,1,'2006-02-15 05:09:17'),
 (1933,420,2,'2006-02-15 05:09:17'),
 (1934,420,2,'2006-02-15 05:09:17'),
 (1935,420,2,'2006-02-15 05:09:17'),
 (1936,421,2,'2006-02-15 05:09:17'),
 (1937,421,2,'2006-02-15 05:09:17'),
 (1938,421,2,'2006-02-15 05:09:17'),
 (1939,421,2,'2006-02-15 05:09:17'),
 (1940,422,2,'2006-02-15 05:09:17'),
 (1941,422,2,'2006-02-15 05:09:17'),
 (1942,423,1,'2006-02-15 05:09:17'),
 (1943,423,1,'2006-02-15 05:09:17'),
 (1944,423,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1945,423,2,'2006-02-15 05:09:17'),
 (1946,424,1,'2006-02-15 05:09:17'),
 (1947,424,1,'2006-02-15 05:09:17'),
 (1948,424,1,'2006-02-15 05:09:17'),
 (1949,424,2,'2006-02-15 05:09:17'),
 (1950,424,2,'2006-02-15 05:09:17'),
 (1951,425,2,'2006-02-15 05:09:17'),
 (1952,425,2,'2006-02-15 05:09:17'),
 (1953,426,2,'2006-02-15 05:09:17'),
 (1954,426,2,'2006-02-15 05:09:17'),
 (1955,426,2,'2006-02-15 05:09:17'),
 (1956,427,1,'2006-02-15 05:09:17'),
 (1957,427,1,'2006-02-15 05:09:17'),
 (1958,427,1,'2006-02-15 05:09:17'),
 (1959,427,1,'2006-02-15 05:09:17'),
 (1960,428,1,'2006-02-15 05:09:17'),
 (1961,428,1,'2006-02-15 05:09:17'),
 (1962,428,1,'2006-02-15 05:09:17'),
 (1963,428,1,'2006-02-15 05:09:17'),
 (1964,428,2,'2006-02-15 05:09:17'),
 (1965,428,2,'2006-02-15 05:09:17'),
 (1966,429,1,'2006-02-15 05:09:17'),
 (1967,429,1,'2006-02-15 05:09:17'),
 (1968,429,2,'2006-02-15 05:09:17'),
 (1969,429,2,'2006-02-15 05:09:17'),
 (1970,429,2,'2006-02-15 05:09:17'),
 (1971,429,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1972,430,2,'2006-02-15 05:09:17'),
 (1973,430,2,'2006-02-15 05:09:17'),
 (1974,430,2,'2006-02-15 05:09:17'),
 (1975,430,2,'2006-02-15 05:09:17'),
 (1976,431,2,'2006-02-15 05:09:17'),
 (1977,431,2,'2006-02-15 05:09:17'),
 (1978,431,2,'2006-02-15 05:09:17'),
 (1979,432,1,'2006-02-15 05:09:17'),
 (1980,432,1,'2006-02-15 05:09:17'),
 (1981,432,1,'2006-02-15 05:09:17'),
 (1982,432,2,'2006-02-15 05:09:17'),
 (1983,432,2,'2006-02-15 05:09:17'),
 (1984,433,1,'2006-02-15 05:09:17'),
 (1985,433,1,'2006-02-15 05:09:17'),
 (1986,433,1,'2006-02-15 05:09:17'),
 (1987,433,1,'2006-02-15 05:09:17'),
 (1988,433,2,'2006-02-15 05:09:17'),
 (1989,433,2,'2006-02-15 05:09:17'),
 (1990,434,1,'2006-02-15 05:09:17'),
 (1991,434,1,'2006-02-15 05:09:17'),
 (1992,434,1,'2006-02-15 05:09:17'),
 (1993,434,1,'2006-02-15 05:09:17'),
 (1994,434,2,'2006-02-15 05:09:17'),
 (1995,434,2,'2006-02-15 05:09:17'),
 (1996,434,2,'2006-02-15 05:09:17'),
 (1997,434,2,'2006-02-15 05:09:17'),
 (1998,435,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (1999,435,1,'2006-02-15 05:09:17'),
 (2000,436,1,'2006-02-15 05:09:17'),
 (2001,436,1,'2006-02-15 05:09:17'),
 (2002,436,1,'2006-02-15 05:09:17'),
 (2003,436,2,'2006-02-15 05:09:17'),
 (2004,436,2,'2006-02-15 05:09:17'),
 (2005,436,2,'2006-02-15 05:09:17'),
 (2006,437,1,'2006-02-15 05:09:17'),
 (2007,437,1,'2006-02-15 05:09:17'),
 (2008,437,2,'2006-02-15 05:09:17'),
 (2009,437,2,'2006-02-15 05:09:17'),
 (2010,437,2,'2006-02-15 05:09:17'),
 (2011,437,2,'2006-02-15 05:09:17'),
 (2012,438,1,'2006-02-15 05:09:17'),
 (2013,438,1,'2006-02-15 05:09:17'),
 (2014,438,2,'2006-02-15 05:09:17'),
 (2015,438,2,'2006-02-15 05:09:17'),
 (2016,438,2,'2006-02-15 05:09:17'),
 (2017,439,1,'2006-02-15 05:09:17'),
 (2018,439,1,'2006-02-15 05:09:17'),
 (2019,439,1,'2006-02-15 05:09:17'),
 (2020,439,1,'2006-02-15 05:09:17'),
 (2021,439,2,'2006-02-15 05:09:17'),
 (2022,439,2,'2006-02-15 05:09:17'),
 (2023,440,1,'2006-02-15 05:09:17'),
 (2024,440,1,'2006-02-15 05:09:17'),
 (2025,440,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2026,440,2,'2006-02-15 05:09:17'),
 (2027,441,1,'2006-02-15 05:09:17'),
 (2028,441,1,'2006-02-15 05:09:17'),
 (2029,442,1,'2006-02-15 05:09:17'),
 (2030,442,1,'2006-02-15 05:09:17'),
 (2031,442,1,'2006-02-15 05:09:17'),
 (2032,443,1,'2006-02-15 05:09:17'),
 (2033,443,1,'2006-02-15 05:09:17'),
 (2034,443,1,'2006-02-15 05:09:17'),
 (2035,443,2,'2006-02-15 05:09:17'),
 (2036,443,2,'2006-02-15 05:09:17'),
 (2037,443,2,'2006-02-15 05:09:17'),
 (2038,443,2,'2006-02-15 05:09:17'),
 (2039,444,1,'2006-02-15 05:09:17'),
 (2040,444,1,'2006-02-15 05:09:17'),
 (2041,444,1,'2006-02-15 05:09:17'),
 (2042,444,1,'2006-02-15 05:09:17'),
 (2043,444,2,'2006-02-15 05:09:17'),
 (2044,444,2,'2006-02-15 05:09:17'),
 (2045,444,2,'2006-02-15 05:09:17'),
 (2046,444,2,'2006-02-15 05:09:17'),
 (2047,445,1,'2006-02-15 05:09:17'),
 (2048,445,1,'2006-02-15 05:09:17'),
 (2049,445,1,'2006-02-15 05:09:17'),
 (2050,445,2,'2006-02-15 05:09:17'),
 (2051,445,2,'2006-02-15 05:09:17'),
 (2052,445,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2053,446,1,'2006-02-15 05:09:17'),
 (2054,446,1,'2006-02-15 05:09:17'),
 (2055,446,2,'2006-02-15 05:09:17'),
 (2056,446,2,'2006-02-15 05:09:17'),
 (2057,447,1,'2006-02-15 05:09:17'),
 (2058,447,1,'2006-02-15 05:09:17'),
 (2059,447,1,'2006-02-15 05:09:17'),
 (2060,447,1,'2006-02-15 05:09:17'),
 (2061,447,2,'2006-02-15 05:09:17'),
 (2062,447,2,'2006-02-15 05:09:17'),
 (2063,447,2,'2006-02-15 05:09:17'),
 (2064,448,1,'2006-02-15 05:09:17'),
 (2065,448,1,'2006-02-15 05:09:17'),
 (2066,448,2,'2006-02-15 05:09:17'),
 (2067,448,2,'2006-02-15 05:09:17'),
 (2068,448,2,'2006-02-15 05:09:17'),
 (2069,449,2,'2006-02-15 05:09:17'),
 (2070,449,2,'2006-02-15 05:09:17'),
 (2071,449,2,'2006-02-15 05:09:17'),
 (2072,449,2,'2006-02-15 05:09:17'),
 (2073,450,1,'2006-02-15 05:09:17'),
 (2074,450,1,'2006-02-15 05:09:17'),
 (2075,450,1,'2006-02-15 05:09:17'),
 (2076,450,2,'2006-02-15 05:09:17'),
 (2077,450,2,'2006-02-15 05:09:17'),
 (2078,450,2,'2006-02-15 05:09:17'),
 (2079,450,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2080,451,1,'2006-02-15 05:09:17'),
 (2081,451,1,'2006-02-15 05:09:17'),
 (2082,451,2,'2006-02-15 05:09:17'),
 (2083,451,2,'2006-02-15 05:09:17'),
 (2084,451,2,'2006-02-15 05:09:17'),
 (2085,452,2,'2006-02-15 05:09:17'),
 (2086,452,2,'2006-02-15 05:09:17'),
 (2087,452,2,'2006-02-15 05:09:17'),
 (2088,452,2,'2006-02-15 05:09:17'),
 (2089,453,1,'2006-02-15 05:09:17'),
 (2090,453,1,'2006-02-15 05:09:17'),
 (2091,453,1,'2006-02-15 05:09:17'),
 (2092,453,2,'2006-02-15 05:09:17'),
 (2093,453,2,'2006-02-15 05:09:17'),
 (2094,454,1,'2006-02-15 05:09:17'),
 (2095,454,1,'2006-02-15 05:09:17'),
 (2096,455,1,'2006-02-15 05:09:17'),
 (2097,455,1,'2006-02-15 05:09:17'),
 (2098,455,1,'2006-02-15 05:09:17'),
 (2099,455,1,'2006-02-15 05:09:17'),
 (2100,456,1,'2006-02-15 05:09:17'),
 (2101,456,1,'2006-02-15 05:09:17'),
 (2102,456,2,'2006-02-15 05:09:17'),
 (2103,456,2,'2006-02-15 05:09:17'),
 (2104,456,2,'2006-02-15 05:09:17'),
 (2105,456,2,'2006-02-15 05:09:17'),
 (2106,457,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2107,457,1,'2006-02-15 05:09:17'),
 (2108,457,2,'2006-02-15 05:09:17'),
 (2109,457,2,'2006-02-15 05:09:17'),
 (2110,457,2,'2006-02-15 05:09:17'),
 (2111,457,2,'2006-02-15 05:09:17'),
 (2112,458,1,'2006-02-15 05:09:17'),
 (2113,458,1,'2006-02-15 05:09:17'),
 (2114,458,2,'2006-02-15 05:09:17'),
 (2115,458,2,'2006-02-15 05:09:17'),
 (2116,458,2,'2006-02-15 05:09:17'),
 (2117,458,2,'2006-02-15 05:09:17'),
 (2118,459,2,'2006-02-15 05:09:17'),
 (2119,459,2,'2006-02-15 05:09:17'),
 (2120,460,1,'2006-02-15 05:09:17'),
 (2121,460,1,'2006-02-15 05:09:17'),
 (2122,460,1,'2006-02-15 05:09:17'),
 (2123,460,1,'2006-02-15 05:09:17'),
 (2124,460,2,'2006-02-15 05:09:17'),
 (2125,460,2,'2006-02-15 05:09:17'),
 (2126,460,2,'2006-02-15 05:09:17'),
 (2127,460,2,'2006-02-15 05:09:17'),
 (2128,461,1,'2006-02-15 05:09:17'),
 (2129,461,1,'2006-02-15 05:09:17'),
 (2130,461,2,'2006-02-15 05:09:17'),
 (2131,461,2,'2006-02-15 05:09:17'),
 (2132,461,2,'2006-02-15 05:09:17'),
 (2133,461,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2134,462,1,'2006-02-15 05:09:17'),
 (2135,462,1,'2006-02-15 05:09:17'),
 (2136,462,2,'2006-02-15 05:09:17'),
 (2137,462,2,'2006-02-15 05:09:17'),
 (2138,462,2,'2006-02-15 05:09:17'),
 (2139,463,1,'2006-02-15 05:09:17'),
 (2140,463,1,'2006-02-15 05:09:17'),
 (2141,463,1,'2006-02-15 05:09:17'),
 (2142,463,2,'2006-02-15 05:09:17'),
 (2143,463,2,'2006-02-15 05:09:17'),
 (2144,464,1,'2006-02-15 05:09:17'),
 (2145,464,1,'2006-02-15 05:09:17'),
 (2146,464,1,'2006-02-15 05:09:17'),
 (2147,464,1,'2006-02-15 05:09:17'),
 (2148,464,2,'2006-02-15 05:09:17'),
 (2149,464,2,'2006-02-15 05:09:17'),
 (2150,464,2,'2006-02-15 05:09:17'),
 (2151,465,1,'2006-02-15 05:09:17'),
 (2152,465,1,'2006-02-15 05:09:17'),
 (2153,465,2,'2006-02-15 05:09:17'),
 (2154,465,2,'2006-02-15 05:09:17'),
 (2155,465,2,'2006-02-15 05:09:17'),
 (2156,466,1,'2006-02-15 05:09:17'),
 (2157,466,1,'2006-02-15 05:09:17'),
 (2158,467,1,'2006-02-15 05:09:17'),
 (2159,467,1,'2006-02-15 05:09:17'),
 (2160,467,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2161,467,1,'2006-02-15 05:09:17'),
 (2162,467,2,'2006-02-15 05:09:17'),
 (2163,467,2,'2006-02-15 05:09:17'),
 (2164,467,2,'2006-02-15 05:09:17'),
 (2165,468,1,'2006-02-15 05:09:17'),
 (2166,468,1,'2006-02-15 05:09:17'),
 (2167,468,1,'2006-02-15 05:09:17'),
 (2168,468,1,'2006-02-15 05:09:17'),
 (2169,468,2,'2006-02-15 05:09:17'),
 (2170,468,2,'2006-02-15 05:09:17'),
 (2171,468,2,'2006-02-15 05:09:17'),
 (2172,468,2,'2006-02-15 05:09:17'),
 (2173,469,2,'2006-02-15 05:09:17'),
 (2174,469,2,'2006-02-15 05:09:17'),
 (2175,469,2,'2006-02-15 05:09:17'),
 (2176,470,1,'2006-02-15 05:09:17'),
 (2177,470,1,'2006-02-15 05:09:17'),
 (2178,471,1,'2006-02-15 05:09:17'),
 (2179,471,1,'2006-02-15 05:09:17'),
 (2180,471,1,'2006-02-15 05:09:17'),
 (2181,471,2,'2006-02-15 05:09:17'),
 (2182,471,2,'2006-02-15 05:09:17'),
 (2183,471,2,'2006-02-15 05:09:17'),
 (2184,471,2,'2006-02-15 05:09:17'),
 (2185,472,2,'2006-02-15 05:09:17'),
 (2186,472,2,'2006-02-15 05:09:17'),
 (2187,473,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2188,473,1,'2006-02-15 05:09:17'),
 (2189,473,2,'2006-02-15 05:09:17'),
 (2190,473,2,'2006-02-15 05:09:17'),
 (2191,473,2,'2006-02-15 05:09:17'),
 (2192,474,2,'2006-02-15 05:09:17'),
 (2193,474,2,'2006-02-15 05:09:17'),
 (2194,474,2,'2006-02-15 05:09:17'),
 (2195,474,2,'2006-02-15 05:09:17'),
 (2196,475,2,'2006-02-15 05:09:17'),
 (2197,475,2,'2006-02-15 05:09:17'),
 (2198,476,1,'2006-02-15 05:09:17'),
 (2199,476,1,'2006-02-15 05:09:17'),
 (2200,476,1,'2006-02-15 05:09:17'),
 (2201,476,2,'2006-02-15 05:09:17'),
 (2202,476,2,'2006-02-15 05:09:17'),
 (2203,476,2,'2006-02-15 05:09:17'),
 (2204,476,2,'2006-02-15 05:09:17'),
 (2205,477,2,'2006-02-15 05:09:17'),
 (2206,477,2,'2006-02-15 05:09:17'),
 (2207,477,2,'2006-02-15 05:09:17'),
 (2208,478,1,'2006-02-15 05:09:17'),
 (2209,478,1,'2006-02-15 05:09:17'),
 (2210,478,2,'2006-02-15 05:09:17'),
 (2211,478,2,'2006-02-15 05:09:17'),
 (2212,478,2,'2006-02-15 05:09:17'),
 (2213,479,1,'2006-02-15 05:09:17'),
 (2214,479,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2215,479,2,'2006-02-15 05:09:17'),
 (2216,479,2,'2006-02-15 05:09:17'),
 (2217,479,2,'2006-02-15 05:09:17'),
 (2218,480,1,'2006-02-15 05:09:17'),
 (2219,480,1,'2006-02-15 05:09:17'),
 (2220,480,2,'2006-02-15 05:09:17'),
 (2221,480,2,'2006-02-15 05:09:17'),
 (2222,481,1,'2006-02-15 05:09:17'),
 (2223,481,1,'2006-02-15 05:09:17'),
 (2224,481,1,'2006-02-15 05:09:17'),
 (2225,481,2,'2006-02-15 05:09:17'),
 (2226,481,2,'2006-02-15 05:09:17'),
 (2227,481,2,'2006-02-15 05:09:17'),
 (2228,482,1,'2006-02-15 05:09:17'),
 (2229,482,1,'2006-02-15 05:09:17'),
 (2230,482,1,'2006-02-15 05:09:17'),
 (2231,483,1,'2006-02-15 05:09:17'),
 (2232,483,1,'2006-02-15 05:09:17'),
 (2233,483,1,'2006-02-15 05:09:17'),
 (2234,483,2,'2006-02-15 05:09:17'),
 (2235,483,2,'2006-02-15 05:09:17'),
 (2236,484,1,'2006-02-15 05:09:17'),
 (2237,484,1,'2006-02-15 05:09:17'),
 (2238,484,1,'2006-02-15 05:09:17'),
 (2239,484,1,'2006-02-15 05:09:17'),
 (2240,484,2,'2006-02-15 05:09:17'),
 (2241,484,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2242,484,2,'2006-02-15 05:09:17'),
 (2243,485,2,'2006-02-15 05:09:17'),
 (2244,485,2,'2006-02-15 05:09:17'),
 (2245,485,2,'2006-02-15 05:09:17'),
 (2246,486,1,'2006-02-15 05:09:17'),
 (2247,486,1,'2006-02-15 05:09:17'),
 (2248,486,1,'2006-02-15 05:09:17'),
 (2249,486,1,'2006-02-15 05:09:17'),
 (2250,486,2,'2006-02-15 05:09:17'),
 (2251,486,2,'2006-02-15 05:09:17'),
 (2252,487,2,'2006-02-15 05:09:17'),
 (2253,487,2,'2006-02-15 05:09:17'),
 (2254,487,2,'2006-02-15 05:09:17'),
 (2255,488,1,'2006-02-15 05:09:17'),
 (2256,488,1,'2006-02-15 05:09:17'),
 (2257,488,2,'2006-02-15 05:09:17'),
 (2258,488,2,'2006-02-15 05:09:17'),
 (2259,488,2,'2006-02-15 05:09:17'),
 (2260,489,1,'2006-02-15 05:09:17'),
 (2261,489,1,'2006-02-15 05:09:17'),
 (2262,489,1,'2006-02-15 05:09:17'),
 (2263,489,1,'2006-02-15 05:09:17'),
 (2264,489,2,'2006-02-15 05:09:17'),
 (2265,489,2,'2006-02-15 05:09:17'),
 (2266,489,2,'2006-02-15 05:09:17'),
 (2267,489,2,'2006-02-15 05:09:17'),
 (2268,490,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2269,490,1,'2006-02-15 05:09:17'),
 (2270,491,1,'2006-02-15 05:09:17'),
 (2271,491,1,'2006-02-15 05:09:17'),
 (2272,491,2,'2006-02-15 05:09:17'),
 (2273,491,2,'2006-02-15 05:09:17'),
 (2274,491,2,'2006-02-15 05:09:17'),
 (2275,491,2,'2006-02-15 05:09:17'),
 (2276,492,1,'2006-02-15 05:09:17'),
 (2277,492,1,'2006-02-15 05:09:17'),
 (2278,493,2,'2006-02-15 05:09:17'),
 (2279,493,2,'2006-02-15 05:09:17'),
 (2280,493,2,'2006-02-15 05:09:17'),
 (2281,494,1,'2006-02-15 05:09:17'),
 (2282,494,1,'2006-02-15 05:09:17'),
 (2283,494,1,'2006-02-15 05:09:17'),
 (2284,494,1,'2006-02-15 05:09:17'),
 (2285,494,2,'2006-02-15 05:09:17'),
 (2286,494,2,'2006-02-15 05:09:17'),
 (2287,496,1,'2006-02-15 05:09:17'),
 (2288,496,1,'2006-02-15 05:09:17'),
 (2289,496,2,'2006-02-15 05:09:17'),
 (2290,496,2,'2006-02-15 05:09:17'),
 (2291,496,2,'2006-02-15 05:09:17'),
 (2292,498,1,'2006-02-15 05:09:17'),
 (2293,498,1,'2006-02-15 05:09:17'),
 (2294,499,1,'2006-02-15 05:09:17'),
 (2295,499,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2296,500,1,'2006-02-15 05:09:17'),
 (2297,500,1,'2006-02-15 05:09:17'),
 (2298,500,1,'2006-02-15 05:09:17'),
 (2299,500,1,'2006-02-15 05:09:17'),
 (2300,500,2,'2006-02-15 05:09:17'),
 (2301,500,2,'2006-02-15 05:09:17'),
 (2302,500,2,'2006-02-15 05:09:17'),
 (2303,500,2,'2006-02-15 05:09:17'),
 (2304,501,1,'2006-02-15 05:09:17'),
 (2305,501,1,'2006-02-15 05:09:17'),
 (2306,501,1,'2006-02-15 05:09:17'),
 (2307,501,2,'2006-02-15 05:09:17'),
 (2308,501,2,'2006-02-15 05:09:17'),
 (2309,502,1,'2006-02-15 05:09:17'),
 (2310,502,1,'2006-02-15 05:09:17'),
 (2311,502,1,'2006-02-15 05:09:17'),
 (2312,502,1,'2006-02-15 05:09:17'),
 (2313,502,2,'2006-02-15 05:09:17'),
 (2314,502,2,'2006-02-15 05:09:17'),
 (2315,502,2,'2006-02-15 05:09:17'),
 (2316,503,1,'2006-02-15 05:09:17'),
 (2317,503,1,'2006-02-15 05:09:17'),
 (2318,503,1,'2006-02-15 05:09:17'),
 (2319,504,1,'2006-02-15 05:09:17'),
 (2320,504,1,'2006-02-15 05:09:17'),
 (2321,504,1,'2006-02-15 05:09:17'),
 (2322,504,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2323,504,2,'2006-02-15 05:09:17'),
 (2324,504,2,'2006-02-15 05:09:17'),
 (2325,505,2,'2006-02-15 05:09:17'),
 (2326,505,2,'2006-02-15 05:09:17'),
 (2327,505,2,'2006-02-15 05:09:17'),
 (2328,505,2,'2006-02-15 05:09:17'),
 (2329,506,1,'2006-02-15 05:09:17'),
 (2330,506,1,'2006-02-15 05:09:17'),
 (2331,506,1,'2006-02-15 05:09:17'),
 (2332,506,1,'2006-02-15 05:09:17'),
 (2333,506,2,'2006-02-15 05:09:17'),
 (2334,506,2,'2006-02-15 05:09:17'),
 (2335,507,2,'2006-02-15 05:09:17'),
 (2336,507,2,'2006-02-15 05:09:17'),
 (2337,508,2,'2006-02-15 05:09:17'),
 (2338,508,2,'2006-02-15 05:09:17'),
 (2339,508,2,'2006-02-15 05:09:17'),
 (2340,509,2,'2006-02-15 05:09:17'),
 (2341,509,2,'2006-02-15 05:09:17'),
 (2342,509,2,'2006-02-15 05:09:17'),
 (2343,510,1,'2006-02-15 05:09:17'),
 (2344,510,1,'2006-02-15 05:09:17'),
 (2345,510,1,'2006-02-15 05:09:17'),
 (2346,510,1,'2006-02-15 05:09:17'),
 (2347,511,1,'2006-02-15 05:09:17'),
 (2348,511,1,'2006-02-15 05:09:17'),
 (2349,511,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2350,511,2,'2006-02-15 05:09:17'),
 (2351,511,2,'2006-02-15 05:09:17'),
 (2352,512,1,'2006-02-15 05:09:17'),
 (2353,512,1,'2006-02-15 05:09:17'),
 (2354,512,2,'2006-02-15 05:09:17'),
 (2355,512,2,'2006-02-15 05:09:17'),
 (2356,512,2,'2006-02-15 05:09:17'),
 (2357,512,2,'2006-02-15 05:09:17'),
 (2358,513,2,'2006-02-15 05:09:17'),
 (2359,513,2,'2006-02-15 05:09:17'),
 (2360,514,1,'2006-02-15 05:09:17'),
 (2361,514,1,'2006-02-15 05:09:17'),
 (2362,514,2,'2006-02-15 05:09:17'),
 (2363,514,2,'2006-02-15 05:09:17'),
 (2364,514,2,'2006-02-15 05:09:17'),
 (2365,514,2,'2006-02-15 05:09:17'),
 (2366,515,2,'2006-02-15 05:09:17'),
 (2367,515,2,'2006-02-15 05:09:17'),
 (2368,516,2,'2006-02-15 05:09:17'),
 (2369,516,2,'2006-02-15 05:09:17'),
 (2370,516,2,'2006-02-15 05:09:17'),
 (2371,517,2,'2006-02-15 05:09:17'),
 (2372,517,2,'2006-02-15 05:09:17'),
 (2373,518,1,'2006-02-15 05:09:17'),
 (2374,518,1,'2006-02-15 05:09:17'),
 (2375,518,2,'2006-02-15 05:09:17'),
 (2376,518,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2377,518,2,'2006-02-15 05:09:17'),
 (2378,518,2,'2006-02-15 05:09:17'),
 (2379,519,2,'2006-02-15 05:09:17'),
 (2380,519,2,'2006-02-15 05:09:17'),
 (2381,519,2,'2006-02-15 05:09:17'),
 (2382,519,2,'2006-02-15 05:09:17'),
 (2383,520,1,'2006-02-15 05:09:17'),
 (2384,520,1,'2006-02-15 05:09:17'),
 (2385,521,1,'2006-02-15 05:09:17'),
 (2386,521,1,'2006-02-15 05:09:17'),
 (2387,521,1,'2006-02-15 05:09:17'),
 (2388,521,1,'2006-02-15 05:09:17'),
 (2389,521,2,'2006-02-15 05:09:17'),
 (2390,521,2,'2006-02-15 05:09:17'),
 (2391,521,2,'2006-02-15 05:09:17'),
 (2392,522,2,'2006-02-15 05:09:17'),
 (2393,522,2,'2006-02-15 05:09:17'),
 (2394,523,1,'2006-02-15 05:09:17'),
 (2395,523,1,'2006-02-15 05:09:17'),
 (2396,524,1,'2006-02-15 05:09:17'),
 (2397,524,1,'2006-02-15 05:09:17'),
 (2398,524,2,'2006-02-15 05:09:17'),
 (2399,524,2,'2006-02-15 05:09:17'),
 (2400,524,2,'2006-02-15 05:09:17'),
 (2401,524,2,'2006-02-15 05:09:17'),
 (2402,525,1,'2006-02-15 05:09:17'),
 (2403,525,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2404,525,1,'2006-02-15 05:09:17'),
 (2405,525,1,'2006-02-15 05:09:17'),
 (2406,525,2,'2006-02-15 05:09:17'),
 (2407,525,2,'2006-02-15 05:09:17'),
 (2408,525,2,'2006-02-15 05:09:17'),
 (2409,525,2,'2006-02-15 05:09:17'),
 (2410,526,2,'2006-02-15 05:09:17'),
 (2411,526,2,'2006-02-15 05:09:17'),
 (2412,526,2,'2006-02-15 05:09:17'),
 (2413,526,2,'2006-02-15 05:09:17'),
 (2414,527,1,'2006-02-15 05:09:17'),
 (2415,527,1,'2006-02-15 05:09:17'),
 (2416,527,2,'2006-02-15 05:09:17'),
 (2417,527,2,'2006-02-15 05:09:17'),
 (2418,527,2,'2006-02-15 05:09:17'),
 (2419,527,2,'2006-02-15 05:09:17'),
 (2420,528,1,'2006-02-15 05:09:17'),
 (2421,528,1,'2006-02-15 05:09:17'),
 (2422,528,1,'2006-02-15 05:09:17'),
 (2423,529,1,'2006-02-15 05:09:17'),
 (2424,529,1,'2006-02-15 05:09:17'),
 (2425,529,1,'2006-02-15 05:09:17'),
 (2426,529,1,'2006-02-15 05:09:17'),
 (2427,530,1,'2006-02-15 05:09:17'),
 (2428,530,1,'2006-02-15 05:09:17'),
 (2429,530,1,'2006-02-15 05:09:17'),
 (2430,531,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2431,531,1,'2006-02-15 05:09:17'),
 (2432,531,1,'2006-02-15 05:09:17'),
 (2433,531,1,'2006-02-15 05:09:17'),
 (2434,531,2,'2006-02-15 05:09:17'),
 (2435,531,2,'2006-02-15 05:09:17'),
 (2436,531,2,'2006-02-15 05:09:17'),
 (2437,531,2,'2006-02-15 05:09:17'),
 (2438,532,2,'2006-02-15 05:09:17'),
 (2439,532,2,'2006-02-15 05:09:17'),
 (2440,532,2,'2006-02-15 05:09:17'),
 (2441,532,2,'2006-02-15 05:09:17'),
 (2442,533,1,'2006-02-15 05:09:17'),
 (2443,533,1,'2006-02-15 05:09:17'),
 (2444,533,1,'2006-02-15 05:09:17'),
 (2445,534,1,'2006-02-15 05:09:17'),
 (2446,534,1,'2006-02-15 05:09:17'),
 (2447,534,2,'2006-02-15 05:09:17'),
 (2448,534,2,'2006-02-15 05:09:17'),
 (2449,534,2,'2006-02-15 05:09:17'),
 (2450,535,1,'2006-02-15 05:09:17'),
 (2451,535,1,'2006-02-15 05:09:17'),
 (2452,535,1,'2006-02-15 05:09:17'),
 (2453,535,1,'2006-02-15 05:09:17'),
 (2454,536,1,'2006-02-15 05:09:17'),
 (2455,536,1,'2006-02-15 05:09:17'),
 (2456,536,1,'2006-02-15 05:09:17'),
 (2457,536,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2458,536,2,'2006-02-15 05:09:17'),
 (2459,537,2,'2006-02-15 05:09:17'),
 (2460,537,2,'2006-02-15 05:09:17'),
 (2461,537,2,'2006-02-15 05:09:17'),
 (2462,538,2,'2006-02-15 05:09:17'),
 (2463,538,2,'2006-02-15 05:09:17'),
 (2464,538,2,'2006-02-15 05:09:17'),
 (2465,539,1,'2006-02-15 05:09:17'),
 (2466,539,1,'2006-02-15 05:09:17'),
 (2467,540,1,'2006-02-15 05:09:17'),
 (2468,540,1,'2006-02-15 05:09:17'),
 (2469,540,1,'2006-02-15 05:09:17'),
 (2470,541,2,'2006-02-15 05:09:17'),
 (2471,541,2,'2006-02-15 05:09:17'),
 (2472,542,1,'2006-02-15 05:09:17'),
 (2473,542,1,'2006-02-15 05:09:17'),
 (2474,542,1,'2006-02-15 05:09:17'),
 (2475,542,1,'2006-02-15 05:09:17'),
 (2476,542,2,'2006-02-15 05:09:17'),
 (2477,542,2,'2006-02-15 05:09:17'),
 (2478,543,1,'2006-02-15 05:09:17'),
 (2479,543,1,'2006-02-15 05:09:17'),
 (2480,544,1,'2006-02-15 05:09:17'),
 (2481,544,1,'2006-02-15 05:09:17'),
 (2482,544,2,'2006-02-15 05:09:17'),
 (2483,544,2,'2006-02-15 05:09:17'),
 (2484,545,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2485,545,1,'2006-02-15 05:09:17'),
 (2486,545,1,'2006-02-15 05:09:17'),
 (2487,545,1,'2006-02-15 05:09:17'),
 (2488,545,2,'2006-02-15 05:09:17'),
 (2489,545,2,'2006-02-15 05:09:17'),
 (2490,546,2,'2006-02-15 05:09:17'),
 (2491,546,2,'2006-02-15 05:09:17'),
 (2492,546,2,'2006-02-15 05:09:17'),
 (2493,546,2,'2006-02-15 05:09:17'),
 (2494,547,2,'2006-02-15 05:09:17'),
 (2495,547,2,'2006-02-15 05:09:17'),
 (2496,548,1,'2006-02-15 05:09:17'),
 (2497,548,1,'2006-02-15 05:09:17'),
 (2498,549,1,'2006-02-15 05:09:17'),
 (2499,549,1,'2006-02-15 05:09:17'),
 (2500,549,2,'2006-02-15 05:09:17'),
 (2501,549,2,'2006-02-15 05:09:17'),
 (2502,550,1,'2006-02-15 05:09:17'),
 (2503,550,1,'2006-02-15 05:09:17'),
 (2504,550,1,'2006-02-15 05:09:17'),
 (2505,551,1,'2006-02-15 05:09:17'),
 (2506,551,1,'2006-02-15 05:09:17'),
 (2507,551,1,'2006-02-15 05:09:17'),
 (2508,551,2,'2006-02-15 05:09:17'),
 (2509,551,2,'2006-02-15 05:09:17'),
 (2510,551,2,'2006-02-15 05:09:17'),
 (2511,552,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2512,552,2,'2006-02-15 05:09:17'),
 (2513,552,2,'2006-02-15 05:09:17'),
 (2514,552,2,'2006-02-15 05:09:17'),
 (2515,553,2,'2006-02-15 05:09:17'),
 (2516,553,2,'2006-02-15 05:09:17'),
 (2517,553,2,'2006-02-15 05:09:17'),
 (2518,554,1,'2006-02-15 05:09:17'),
 (2519,554,1,'2006-02-15 05:09:17'),
 (2520,554,1,'2006-02-15 05:09:17'),
 (2521,554,1,'2006-02-15 05:09:17'),
 (2522,554,2,'2006-02-15 05:09:17'),
 (2523,554,2,'2006-02-15 05:09:17'),
 (2524,554,2,'2006-02-15 05:09:17'),
 (2525,555,1,'2006-02-15 05:09:17'),
 (2526,555,1,'2006-02-15 05:09:17'),
 (2527,555,1,'2006-02-15 05:09:17'),
 (2528,555,2,'2006-02-15 05:09:17'),
 (2529,555,2,'2006-02-15 05:09:17'),
 (2530,555,2,'2006-02-15 05:09:17'),
 (2531,555,2,'2006-02-15 05:09:17'),
 (2532,556,1,'2006-02-15 05:09:17'),
 (2533,556,1,'2006-02-15 05:09:17'),
 (2534,556,1,'2006-02-15 05:09:17'),
 (2535,556,2,'2006-02-15 05:09:17'),
 (2536,556,2,'2006-02-15 05:09:17'),
 (2537,556,2,'2006-02-15 05:09:17'),
 (2538,556,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2539,557,1,'2006-02-15 05:09:17'),
 (2540,557,1,'2006-02-15 05:09:17'),
 (2541,557,2,'2006-02-15 05:09:17'),
 (2542,557,2,'2006-02-15 05:09:17'),
 (2543,557,2,'2006-02-15 05:09:17'),
 (2544,558,2,'2006-02-15 05:09:17'),
 (2545,558,2,'2006-02-15 05:09:17'),
 (2546,559,1,'2006-02-15 05:09:17'),
 (2547,559,1,'2006-02-15 05:09:17'),
 (2548,559,1,'2006-02-15 05:09:17'),
 (2549,559,1,'2006-02-15 05:09:17'),
 (2550,559,2,'2006-02-15 05:09:17'),
 (2551,559,2,'2006-02-15 05:09:17'),
 (2552,559,2,'2006-02-15 05:09:17'),
 (2553,559,2,'2006-02-15 05:09:17'),
 (2554,560,1,'2006-02-15 05:09:17'),
 (2555,560,1,'2006-02-15 05:09:17'),
 (2556,560,1,'2006-02-15 05:09:17'),
 (2557,560,2,'2006-02-15 05:09:17'),
 (2558,560,2,'2006-02-15 05:09:17'),
 (2559,561,1,'2006-02-15 05:09:17'),
 (2560,561,1,'2006-02-15 05:09:17'),
 (2561,561,1,'2006-02-15 05:09:17'),
 (2562,561,1,'2006-02-15 05:09:17'),
 (2563,562,1,'2006-02-15 05:09:17'),
 (2564,562,1,'2006-02-15 05:09:17'),
 (2565,562,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2566,562,1,'2006-02-15 05:09:17'),
 (2567,562,2,'2006-02-15 05:09:17'),
 (2568,562,2,'2006-02-15 05:09:17'),
 (2569,563,1,'2006-02-15 05:09:17'),
 (2570,563,1,'2006-02-15 05:09:17'),
 (2571,563,1,'2006-02-15 05:09:17'),
 (2572,563,1,'2006-02-15 05:09:17'),
 (2573,563,2,'2006-02-15 05:09:17'),
 (2574,563,2,'2006-02-15 05:09:17'),
 (2575,563,2,'2006-02-15 05:09:17'),
 (2576,564,2,'2006-02-15 05:09:17'),
 (2577,564,2,'2006-02-15 05:09:17'),
 (2578,564,2,'2006-02-15 05:09:17'),
 (2579,565,1,'2006-02-15 05:09:17'),
 (2580,565,1,'2006-02-15 05:09:17'),
 (2581,566,1,'2006-02-15 05:09:17'),
 (2582,566,1,'2006-02-15 05:09:17'),
 (2583,567,1,'2006-02-15 05:09:17'),
 (2584,567,1,'2006-02-15 05:09:17'),
 (2585,567,2,'2006-02-15 05:09:17'),
 (2586,567,2,'2006-02-15 05:09:17'),
 (2587,568,1,'2006-02-15 05:09:17'),
 (2588,568,1,'2006-02-15 05:09:17'),
 (2589,568,2,'2006-02-15 05:09:17'),
 (2590,568,2,'2006-02-15 05:09:17'),
 (2591,569,1,'2006-02-15 05:09:17'),
 (2592,569,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2593,570,1,'2006-02-15 05:09:17'),
 (2594,570,1,'2006-02-15 05:09:17'),
 (2595,570,2,'2006-02-15 05:09:17'),
 (2596,570,2,'2006-02-15 05:09:17'),
 (2597,570,2,'2006-02-15 05:09:17'),
 (2598,571,1,'2006-02-15 05:09:17'),
 (2599,571,1,'2006-02-15 05:09:17'),
 (2600,571,2,'2006-02-15 05:09:17'),
 (2601,571,2,'2006-02-15 05:09:17'),
 (2602,571,2,'2006-02-15 05:09:17'),
 (2603,571,2,'2006-02-15 05:09:17'),
 (2604,572,1,'2006-02-15 05:09:17'),
 (2605,572,1,'2006-02-15 05:09:17'),
 (2606,572,1,'2006-02-15 05:09:17'),
 (2607,572,1,'2006-02-15 05:09:17'),
 (2608,572,2,'2006-02-15 05:09:17'),
 (2609,572,2,'2006-02-15 05:09:17'),
 (2610,572,2,'2006-02-15 05:09:17'),
 (2611,572,2,'2006-02-15 05:09:17'),
 (2612,573,1,'2006-02-15 05:09:17'),
 (2613,573,1,'2006-02-15 05:09:17'),
 (2614,573,1,'2006-02-15 05:09:17'),
 (2615,573,1,'2006-02-15 05:09:17'),
 (2616,574,1,'2006-02-15 05:09:17'),
 (2617,574,1,'2006-02-15 05:09:17'),
 (2618,574,2,'2006-02-15 05:09:17'),
 (2619,574,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2620,574,2,'2006-02-15 05:09:17'),
 (2621,575,1,'2006-02-15 05:09:17'),
 (2622,575,1,'2006-02-15 05:09:17'),
 (2623,575,2,'2006-02-15 05:09:17'),
 (2624,575,2,'2006-02-15 05:09:17'),
 (2625,575,2,'2006-02-15 05:09:17'),
 (2626,575,2,'2006-02-15 05:09:17'),
 (2627,576,2,'2006-02-15 05:09:17'),
 (2628,576,2,'2006-02-15 05:09:17'),
 (2629,576,2,'2006-02-15 05:09:17'),
 (2630,577,1,'2006-02-15 05:09:17'),
 (2631,577,1,'2006-02-15 05:09:17'),
 (2632,577,1,'2006-02-15 05:09:17'),
 (2633,578,1,'2006-02-15 05:09:17'),
 (2634,578,1,'2006-02-15 05:09:17'),
 (2635,578,2,'2006-02-15 05:09:17'),
 (2636,578,2,'2006-02-15 05:09:17'),
 (2637,578,2,'2006-02-15 05:09:17'),
 (2638,579,1,'2006-02-15 05:09:17'),
 (2639,579,1,'2006-02-15 05:09:17'),
 (2640,579,1,'2006-02-15 05:09:17'),
 (2641,579,1,'2006-02-15 05:09:17'),
 (2642,579,2,'2006-02-15 05:09:17'),
 (2643,579,2,'2006-02-15 05:09:17'),
 (2644,579,2,'2006-02-15 05:09:17'),
 (2645,580,1,'2006-02-15 05:09:17'),
 (2646,580,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2647,580,1,'2006-02-15 05:09:17'),
 (2648,580,1,'2006-02-15 05:09:17'),
 (2649,580,2,'2006-02-15 05:09:17'),
 (2650,580,2,'2006-02-15 05:09:17'),
 (2651,581,1,'2006-02-15 05:09:17'),
 (2652,581,1,'2006-02-15 05:09:17'),
 (2653,581,1,'2006-02-15 05:09:17'),
 (2654,582,2,'2006-02-15 05:09:17'),
 (2655,582,2,'2006-02-15 05:09:17'),
 (2656,583,1,'2006-02-15 05:09:17'),
 (2657,583,1,'2006-02-15 05:09:17'),
 (2658,583,1,'2006-02-15 05:09:17'),
 (2659,583,2,'2006-02-15 05:09:17'),
 (2660,583,2,'2006-02-15 05:09:17'),
 (2661,584,1,'2006-02-15 05:09:17'),
 (2662,584,1,'2006-02-15 05:09:17'),
 (2663,585,2,'2006-02-15 05:09:17'),
 (2664,585,2,'2006-02-15 05:09:17'),
 (2665,585,2,'2006-02-15 05:09:17'),
 (2666,585,2,'2006-02-15 05:09:17'),
 (2667,586,1,'2006-02-15 05:09:17'),
 (2668,586,1,'2006-02-15 05:09:17'),
 (2669,586,1,'2006-02-15 05:09:17'),
 (2670,586,1,'2006-02-15 05:09:17'),
 (2671,586,2,'2006-02-15 05:09:17'),
 (2672,586,2,'2006-02-15 05:09:17'),
 (2673,586,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2674,586,2,'2006-02-15 05:09:17'),
 (2675,587,1,'2006-02-15 05:09:17'),
 (2676,587,1,'2006-02-15 05:09:17'),
 (2677,587,1,'2006-02-15 05:09:17'),
 (2678,588,2,'2006-02-15 05:09:17'),
 (2679,588,2,'2006-02-15 05:09:17'),
 (2680,588,2,'2006-02-15 05:09:17'),
 (2681,588,2,'2006-02-15 05:09:17'),
 (2682,589,2,'2006-02-15 05:09:17'),
 (2683,589,2,'2006-02-15 05:09:17'),
 (2684,589,2,'2006-02-15 05:09:17'),
 (2685,589,2,'2006-02-15 05:09:17'),
 (2686,590,1,'2006-02-15 05:09:17'),
 (2687,590,1,'2006-02-15 05:09:17'),
 (2688,590,1,'2006-02-15 05:09:17'),
 (2689,590,2,'2006-02-15 05:09:17'),
 (2690,590,2,'2006-02-15 05:09:17'),
 (2691,590,2,'2006-02-15 05:09:17'),
 (2692,590,2,'2006-02-15 05:09:17'),
 (2693,591,2,'2006-02-15 05:09:17'),
 (2694,591,2,'2006-02-15 05:09:17'),
 (2695,591,2,'2006-02-15 05:09:17'),
 (2696,592,1,'2006-02-15 05:09:17'),
 (2697,592,1,'2006-02-15 05:09:17'),
 (2698,592,2,'2006-02-15 05:09:17'),
 (2699,592,2,'2006-02-15 05:09:17'),
 (2700,593,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2701,593,2,'2006-02-15 05:09:17'),
 (2702,593,2,'2006-02-15 05:09:17'),
 (2703,593,2,'2006-02-15 05:09:17'),
 (2704,594,1,'2006-02-15 05:09:17'),
 (2705,594,1,'2006-02-15 05:09:17'),
 (2706,594,1,'2006-02-15 05:09:17'),
 (2707,595,1,'2006-02-15 05:09:17'),
 (2708,595,1,'2006-02-15 05:09:17'),
 (2709,595,1,'2006-02-15 05:09:17'),
 (2710,595,1,'2006-02-15 05:09:17'),
 (2711,595,2,'2006-02-15 05:09:17'),
 (2712,595,2,'2006-02-15 05:09:17'),
 (2713,595,2,'2006-02-15 05:09:17'),
 (2714,595,2,'2006-02-15 05:09:17'),
 (2715,596,1,'2006-02-15 05:09:17'),
 (2716,596,1,'2006-02-15 05:09:17'),
 (2717,596,2,'2006-02-15 05:09:17'),
 (2718,596,2,'2006-02-15 05:09:17'),
 (2719,596,2,'2006-02-15 05:09:17'),
 (2720,596,2,'2006-02-15 05:09:17'),
 (2721,597,2,'2006-02-15 05:09:17'),
 (2722,597,2,'2006-02-15 05:09:17'),
 (2723,597,2,'2006-02-15 05:09:17'),
 (2724,597,2,'2006-02-15 05:09:17'),
 (2725,598,1,'2006-02-15 05:09:17'),
 (2726,598,1,'2006-02-15 05:09:17'),
 (2727,598,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2728,598,1,'2006-02-15 05:09:17'),
 (2729,599,1,'2006-02-15 05:09:17'),
 (2730,599,1,'2006-02-15 05:09:17'),
 (2731,599,1,'2006-02-15 05:09:17'),
 (2732,599,2,'2006-02-15 05:09:17'),
 (2733,599,2,'2006-02-15 05:09:17'),
 (2734,600,1,'2006-02-15 05:09:17'),
 (2735,600,1,'2006-02-15 05:09:17'),
 (2736,600,2,'2006-02-15 05:09:17'),
 (2737,600,2,'2006-02-15 05:09:17'),
 (2738,601,1,'2006-02-15 05:09:17'),
 (2739,601,1,'2006-02-15 05:09:17'),
 (2740,601,1,'2006-02-15 05:09:17'),
 (2741,601,2,'2006-02-15 05:09:17'),
 (2742,601,2,'2006-02-15 05:09:17'),
 (2743,602,1,'2006-02-15 05:09:17'),
 (2744,602,1,'2006-02-15 05:09:17'),
 (2745,602,2,'2006-02-15 05:09:17'),
 (2746,602,2,'2006-02-15 05:09:17'),
 (2747,602,2,'2006-02-15 05:09:17'),
 (2748,603,1,'2006-02-15 05:09:17'),
 (2749,603,1,'2006-02-15 05:09:17'),
 (2750,603,1,'2006-02-15 05:09:17'),
 (2751,603,1,'2006-02-15 05:09:17'),
 (2752,603,2,'2006-02-15 05:09:17'),
 (2753,603,2,'2006-02-15 05:09:17'),
 (2754,604,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2755,604,2,'2006-02-15 05:09:17'),
 (2756,604,2,'2006-02-15 05:09:17'),
 (2757,605,2,'2006-02-15 05:09:17'),
 (2758,605,2,'2006-02-15 05:09:17'),
 (2759,606,1,'2006-02-15 05:09:17'),
 (2760,606,1,'2006-02-15 05:09:17'),
 (2761,606,2,'2006-02-15 05:09:17'),
 (2762,606,2,'2006-02-15 05:09:17'),
 (2763,606,2,'2006-02-15 05:09:17'),
 (2764,606,2,'2006-02-15 05:09:17'),
 (2765,608,1,'2006-02-15 05:09:17'),
 (2766,608,1,'2006-02-15 05:09:17'),
 (2767,608,2,'2006-02-15 05:09:17'),
 (2768,608,2,'2006-02-15 05:09:17'),
 (2769,608,2,'2006-02-15 05:09:17'),
 (2770,608,2,'2006-02-15 05:09:17'),
 (2771,609,1,'2006-02-15 05:09:17'),
 (2772,609,1,'2006-02-15 05:09:17'),
 (2773,609,1,'2006-02-15 05:09:17'),
 (2774,609,1,'2006-02-15 05:09:17'),
 (2775,609,2,'2006-02-15 05:09:17'),
 (2776,609,2,'2006-02-15 05:09:17'),
 (2777,609,2,'2006-02-15 05:09:17'),
 (2778,609,2,'2006-02-15 05:09:17'),
 (2779,610,1,'2006-02-15 05:09:17'),
 (2780,610,1,'2006-02-15 05:09:17'),
 (2781,610,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2782,610,2,'2006-02-15 05:09:17'),
 (2783,610,2,'2006-02-15 05:09:17'),
 (2784,611,1,'2006-02-15 05:09:17'),
 (2785,611,1,'2006-02-15 05:09:17'),
 (2786,611,1,'2006-02-15 05:09:17'),
 (2787,611,1,'2006-02-15 05:09:17'),
 (2788,611,2,'2006-02-15 05:09:17'),
 (2789,611,2,'2006-02-15 05:09:17'),
 (2790,612,2,'2006-02-15 05:09:17'),
 (2791,612,2,'2006-02-15 05:09:17'),
 (2792,613,1,'2006-02-15 05:09:17'),
 (2793,613,1,'2006-02-15 05:09:17'),
 (2794,614,1,'2006-02-15 05:09:17'),
 (2795,614,1,'2006-02-15 05:09:17'),
 (2796,614,1,'2006-02-15 05:09:17'),
 (2797,614,2,'2006-02-15 05:09:17'),
 (2798,614,2,'2006-02-15 05:09:17'),
 (2799,614,2,'2006-02-15 05:09:17'),
 (2800,615,2,'2006-02-15 05:09:17'),
 (2801,615,2,'2006-02-15 05:09:17'),
 (2802,615,2,'2006-02-15 05:09:17'),
 (2803,615,2,'2006-02-15 05:09:17'),
 (2804,616,1,'2006-02-15 05:09:17'),
 (2805,616,1,'2006-02-15 05:09:17'),
 (2806,616,2,'2006-02-15 05:09:17'),
 (2807,616,2,'2006-02-15 05:09:17'),
 (2808,616,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2809,616,2,'2006-02-15 05:09:17'),
 (2810,617,1,'2006-02-15 05:09:17'),
 (2811,617,1,'2006-02-15 05:09:17'),
 (2812,617,1,'2006-02-15 05:09:17'),
 (2813,618,2,'2006-02-15 05:09:17'),
 (2814,618,2,'2006-02-15 05:09:17'),
 (2815,618,2,'2006-02-15 05:09:17'),
 (2816,618,2,'2006-02-15 05:09:17'),
 (2817,619,1,'2006-02-15 05:09:17'),
 (2818,619,1,'2006-02-15 05:09:17'),
 (2819,619,2,'2006-02-15 05:09:17'),
 (2820,619,2,'2006-02-15 05:09:17'),
 (2821,619,2,'2006-02-15 05:09:17'),
 (2822,619,2,'2006-02-15 05:09:17'),
 (2823,620,1,'2006-02-15 05:09:17'),
 (2824,620,1,'2006-02-15 05:09:17'),
 (2825,620,2,'2006-02-15 05:09:17'),
 (2826,620,2,'2006-02-15 05:09:17'),
 (2827,620,2,'2006-02-15 05:09:17'),
 (2828,621,1,'2006-02-15 05:09:17'),
 (2829,621,1,'2006-02-15 05:09:17'),
 (2830,621,1,'2006-02-15 05:09:17'),
 (2831,621,1,'2006-02-15 05:09:17'),
 (2832,621,2,'2006-02-15 05:09:17'),
 (2833,621,2,'2006-02-15 05:09:17'),
 (2834,621,2,'2006-02-15 05:09:17'),
 (2835,621,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2836,622,2,'2006-02-15 05:09:17'),
 (2837,622,2,'2006-02-15 05:09:17'),
 (2838,623,1,'2006-02-15 05:09:17'),
 (2839,623,1,'2006-02-15 05:09:17'),
 (2840,623,2,'2006-02-15 05:09:17'),
 (2841,623,2,'2006-02-15 05:09:17'),
 (2842,623,2,'2006-02-15 05:09:17'),
 (2843,624,1,'2006-02-15 05:09:17'),
 (2844,624,1,'2006-02-15 05:09:17'),
 (2845,624,1,'2006-02-15 05:09:17'),
 (2846,624,2,'2006-02-15 05:09:17'),
 (2847,624,2,'2006-02-15 05:09:17'),
 (2848,624,2,'2006-02-15 05:09:17'),
 (2849,624,2,'2006-02-15 05:09:17'),
 (2850,625,1,'2006-02-15 05:09:17'),
 (2851,625,1,'2006-02-15 05:09:17'),
 (2852,625,1,'2006-02-15 05:09:17'),
 (2853,625,2,'2006-02-15 05:09:17'),
 (2854,625,2,'2006-02-15 05:09:17'),
 (2855,625,2,'2006-02-15 05:09:17'),
 (2856,625,2,'2006-02-15 05:09:17'),
 (2857,626,2,'2006-02-15 05:09:17'),
 (2858,626,2,'2006-02-15 05:09:17'),
 (2859,626,2,'2006-02-15 05:09:17'),
 (2860,626,2,'2006-02-15 05:09:17'),
 (2861,627,2,'2006-02-15 05:09:17'),
 (2862,627,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2863,627,2,'2006-02-15 05:09:17'),
 (2864,628,1,'2006-02-15 05:09:17'),
 (2865,628,1,'2006-02-15 05:09:17'),
 (2866,628,1,'2006-02-15 05:09:17'),
 (2867,628,2,'2006-02-15 05:09:17'),
 (2868,628,2,'2006-02-15 05:09:17'),
 (2869,629,2,'2006-02-15 05:09:17'),
 (2870,629,2,'2006-02-15 05:09:17'),
 (2871,629,2,'2006-02-15 05:09:17'),
 (2872,629,2,'2006-02-15 05:09:17'),
 (2873,630,2,'2006-02-15 05:09:17'),
 (2874,630,2,'2006-02-15 05:09:17'),
 (2875,630,2,'2006-02-15 05:09:17'),
 (2876,631,1,'2006-02-15 05:09:17'),
 (2877,631,1,'2006-02-15 05:09:17'),
 (2878,631,1,'2006-02-15 05:09:17'),
 (2879,631,2,'2006-02-15 05:09:17'),
 (2880,631,2,'2006-02-15 05:09:17'),
 (2881,632,1,'2006-02-15 05:09:17'),
 (2882,632,1,'2006-02-15 05:09:17'),
 (2883,632,1,'2006-02-15 05:09:17'),
 (2884,633,2,'2006-02-15 05:09:17'),
 (2885,633,2,'2006-02-15 05:09:17'),
 (2886,633,2,'2006-02-15 05:09:17'),
 (2887,634,2,'2006-02-15 05:09:17'),
 (2888,634,2,'2006-02-15 05:09:17'),
 (2889,634,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2890,634,2,'2006-02-15 05:09:17'),
 (2891,635,2,'2006-02-15 05:09:17'),
 (2892,635,2,'2006-02-15 05:09:17'),
 (2893,636,1,'2006-02-15 05:09:17'),
 (2894,636,1,'2006-02-15 05:09:17'),
 (2895,636,1,'2006-02-15 05:09:17'),
 (2896,637,1,'2006-02-15 05:09:17'),
 (2897,637,1,'2006-02-15 05:09:17'),
 (2898,637,2,'2006-02-15 05:09:17'),
 (2899,637,2,'2006-02-15 05:09:17'),
 (2900,637,2,'2006-02-15 05:09:17'),
 (2901,638,1,'2006-02-15 05:09:17'),
 (2902,638,1,'2006-02-15 05:09:17'),
 (2903,638,1,'2006-02-15 05:09:17'),
 (2904,638,1,'2006-02-15 05:09:17'),
 (2905,638,2,'2006-02-15 05:09:17'),
 (2906,638,2,'2006-02-15 05:09:17'),
 (2907,638,2,'2006-02-15 05:09:17'),
 (2908,638,2,'2006-02-15 05:09:17'),
 (2909,639,2,'2006-02-15 05:09:17'),
 (2910,639,2,'2006-02-15 05:09:17'),
 (2911,639,2,'2006-02-15 05:09:17'),
 (2912,640,2,'2006-02-15 05:09:17'),
 (2913,640,2,'2006-02-15 05:09:17'),
 (2914,640,2,'2006-02-15 05:09:17'),
 (2915,641,1,'2006-02-15 05:09:17'),
 (2916,641,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2917,641,1,'2006-02-15 05:09:17'),
 (2918,641,2,'2006-02-15 05:09:17'),
 (2919,641,2,'2006-02-15 05:09:17'),
 (2920,641,2,'2006-02-15 05:09:17'),
 (2921,641,2,'2006-02-15 05:09:17'),
 (2922,643,1,'2006-02-15 05:09:17'),
 (2923,643,1,'2006-02-15 05:09:17'),
 (2924,643,1,'2006-02-15 05:09:17'),
 (2925,643,2,'2006-02-15 05:09:17'),
 (2926,643,2,'2006-02-15 05:09:17'),
 (2927,643,2,'2006-02-15 05:09:17'),
 (2928,644,1,'2006-02-15 05:09:17'),
 (2929,644,1,'2006-02-15 05:09:17'),
 (2930,644,1,'2006-02-15 05:09:17'),
 (2931,644,2,'2006-02-15 05:09:17'),
 (2932,644,2,'2006-02-15 05:09:17'),
 (2933,644,2,'2006-02-15 05:09:17'),
 (2934,644,2,'2006-02-15 05:09:17'),
 (2935,645,1,'2006-02-15 05:09:17'),
 (2936,645,1,'2006-02-15 05:09:17'),
 (2937,645,1,'2006-02-15 05:09:17'),
 (2938,645,2,'2006-02-15 05:09:17'),
 (2939,645,2,'2006-02-15 05:09:17'),
 (2940,645,2,'2006-02-15 05:09:17'),
 (2941,646,1,'2006-02-15 05:09:17'),
 (2942,646,1,'2006-02-15 05:09:17'),
 (2943,646,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2944,646,2,'2006-02-15 05:09:17'),
 (2945,646,2,'2006-02-15 05:09:17'),
 (2946,647,1,'2006-02-15 05:09:17'),
 (2947,647,1,'2006-02-15 05:09:17'),
 (2948,647,1,'2006-02-15 05:09:17'),
 (2949,647,2,'2006-02-15 05:09:17'),
 (2950,647,2,'2006-02-15 05:09:17'),
 (2951,647,2,'2006-02-15 05:09:17'),
 (2952,648,1,'2006-02-15 05:09:17'),
 (2953,648,1,'2006-02-15 05:09:17'),
 (2954,648,1,'2006-02-15 05:09:17'),
 (2955,648,1,'2006-02-15 05:09:17'),
 (2956,648,2,'2006-02-15 05:09:17'),
 (2957,648,2,'2006-02-15 05:09:17'),
 (2958,649,1,'2006-02-15 05:09:17'),
 (2959,649,1,'2006-02-15 05:09:17'),
 (2960,649,2,'2006-02-15 05:09:17'),
 (2961,649,2,'2006-02-15 05:09:17'),
 (2962,649,2,'2006-02-15 05:09:17'),
 (2963,649,2,'2006-02-15 05:09:17'),
 (2964,650,1,'2006-02-15 05:09:17'),
 (2965,650,1,'2006-02-15 05:09:17'),
 (2966,650,2,'2006-02-15 05:09:17'),
 (2967,650,2,'2006-02-15 05:09:17'),
 (2968,650,2,'2006-02-15 05:09:17'),
 (2969,650,2,'2006-02-15 05:09:17'),
 (2970,651,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2971,651,1,'2006-02-15 05:09:17'),
 (2972,651,2,'2006-02-15 05:09:17'),
 (2973,651,2,'2006-02-15 05:09:17'),
 (2974,651,2,'2006-02-15 05:09:17'),
 (2975,651,2,'2006-02-15 05:09:17'),
 (2976,652,1,'2006-02-15 05:09:17'),
 (2977,652,1,'2006-02-15 05:09:17'),
 (2978,652,1,'2006-02-15 05:09:17'),
 (2979,652,1,'2006-02-15 05:09:17'),
 (2980,653,1,'2006-02-15 05:09:17'),
 (2981,653,1,'2006-02-15 05:09:17'),
 (2982,654,1,'2006-02-15 05:09:17'),
 (2983,654,1,'2006-02-15 05:09:17'),
 (2984,654,2,'2006-02-15 05:09:17'),
 (2985,654,2,'2006-02-15 05:09:17'),
 (2986,655,1,'2006-02-15 05:09:17'),
 (2987,655,1,'2006-02-15 05:09:17'),
 (2988,655,1,'2006-02-15 05:09:17'),
 (2989,655,2,'2006-02-15 05:09:17'),
 (2990,655,2,'2006-02-15 05:09:17'),
 (2991,655,2,'2006-02-15 05:09:17'),
 (2992,656,2,'2006-02-15 05:09:17'),
 (2993,656,2,'2006-02-15 05:09:17'),
 (2994,657,1,'2006-02-15 05:09:17'),
 (2995,657,1,'2006-02-15 05:09:17'),
 (2996,657,1,'2006-02-15 05:09:17'),
 (2997,657,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (2998,657,2,'2006-02-15 05:09:17'),
 (2999,657,2,'2006-02-15 05:09:17'),
 (3000,658,2,'2006-02-15 05:09:17'),
 (3001,658,2,'2006-02-15 05:09:17'),
 (3002,658,2,'2006-02-15 05:09:17'),
 (3003,658,2,'2006-02-15 05:09:17'),
 (3004,659,2,'2006-02-15 05:09:17'),
 (3005,659,2,'2006-02-15 05:09:17'),
 (3006,660,1,'2006-02-15 05:09:17'),
 (3007,660,1,'2006-02-15 05:09:17'),
 (3008,660,2,'2006-02-15 05:09:17'),
 (3009,660,2,'2006-02-15 05:09:17'),
 (3010,661,1,'2006-02-15 05:09:17'),
 (3011,661,1,'2006-02-15 05:09:17'),
 (3012,661,1,'2006-02-15 05:09:17'),
 (3013,661,1,'2006-02-15 05:09:17'),
 (3014,662,1,'2006-02-15 05:09:17'),
 (3015,662,1,'2006-02-15 05:09:17'),
 (3016,662,2,'2006-02-15 05:09:17'),
 (3017,662,2,'2006-02-15 05:09:17'),
 (3018,663,1,'2006-02-15 05:09:17'),
 (3019,663,1,'2006-02-15 05:09:17'),
 (3020,663,1,'2006-02-15 05:09:17'),
 (3021,663,2,'2006-02-15 05:09:17'),
 (3022,663,2,'2006-02-15 05:09:17'),
 (3023,664,1,'2006-02-15 05:09:17'),
 (3024,664,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3025,664,2,'2006-02-15 05:09:17'),
 (3026,664,2,'2006-02-15 05:09:17'),
 (3027,664,2,'2006-02-15 05:09:17'),
 (3028,665,1,'2006-02-15 05:09:17'),
 (3029,665,1,'2006-02-15 05:09:17'),
 (3030,665,1,'2006-02-15 05:09:17'),
 (3031,665,1,'2006-02-15 05:09:17'),
 (3032,665,2,'2006-02-15 05:09:17'),
 (3033,665,2,'2006-02-15 05:09:17'),
 (3034,665,2,'2006-02-15 05:09:17'),
 (3035,666,1,'2006-02-15 05:09:17'),
 (3036,666,1,'2006-02-15 05:09:17'),
 (3037,666,1,'2006-02-15 05:09:17'),
 (3038,666,2,'2006-02-15 05:09:17'),
 (3039,666,2,'2006-02-15 05:09:17'),
 (3040,667,1,'2006-02-15 05:09:17'),
 (3041,667,1,'2006-02-15 05:09:17'),
 (3042,667,2,'2006-02-15 05:09:17'),
 (3043,667,2,'2006-02-15 05:09:17'),
 (3044,668,1,'2006-02-15 05:09:17'),
 (3045,668,1,'2006-02-15 05:09:17'),
 (3046,668,2,'2006-02-15 05:09:17'),
 (3047,668,2,'2006-02-15 05:09:17'),
 (3048,668,2,'2006-02-15 05:09:17'),
 (3049,670,1,'2006-02-15 05:09:17'),
 (3050,670,1,'2006-02-15 05:09:17'),
 (3051,670,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3052,670,1,'2006-02-15 05:09:17'),
 (3053,670,2,'2006-02-15 05:09:17'),
 (3054,670,2,'2006-02-15 05:09:17'),
 (3055,670,2,'2006-02-15 05:09:17'),
 (3056,672,1,'2006-02-15 05:09:17'),
 (3057,672,1,'2006-02-15 05:09:17'),
 (3058,672,2,'2006-02-15 05:09:17'),
 (3059,672,2,'2006-02-15 05:09:17'),
 (3060,672,2,'2006-02-15 05:09:17'),
 (3061,672,2,'2006-02-15 05:09:17'),
 (3062,673,1,'2006-02-15 05:09:17'),
 (3063,673,1,'2006-02-15 05:09:17'),
 (3064,673,2,'2006-02-15 05:09:17'),
 (3065,673,2,'2006-02-15 05:09:17'),
 (3066,674,1,'2006-02-15 05:09:17'),
 (3067,674,1,'2006-02-15 05:09:17'),
 (3068,674,1,'2006-02-15 05:09:17'),
 (3069,675,1,'2006-02-15 05:09:17'),
 (3070,675,1,'2006-02-15 05:09:17'),
 (3071,676,1,'2006-02-15 05:09:17'),
 (3072,676,1,'2006-02-15 05:09:17'),
 (3073,676,2,'2006-02-15 05:09:17'),
 (3074,676,2,'2006-02-15 05:09:17'),
 (3075,676,2,'2006-02-15 05:09:17'),
 (3076,676,2,'2006-02-15 05:09:17'),
 (3077,677,1,'2006-02-15 05:09:17'),
 (3078,677,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3079,677,1,'2006-02-15 05:09:17'),
 (3080,677,2,'2006-02-15 05:09:17'),
 (3081,677,2,'2006-02-15 05:09:17'),
 (3082,677,2,'2006-02-15 05:09:17'),
 (3083,677,2,'2006-02-15 05:09:17'),
 (3084,678,1,'2006-02-15 05:09:17'),
 (3085,678,1,'2006-02-15 05:09:17'),
 (3086,678,1,'2006-02-15 05:09:17'),
 (3087,678,1,'2006-02-15 05:09:17'),
 (3088,679,1,'2006-02-15 05:09:17'),
 (3089,679,1,'2006-02-15 05:09:17'),
 (3090,679,2,'2006-02-15 05:09:17'),
 (3091,679,2,'2006-02-15 05:09:17'),
 (3092,680,1,'2006-02-15 05:09:17'),
 (3093,680,1,'2006-02-15 05:09:17'),
 (3094,680,2,'2006-02-15 05:09:17'),
 (3095,680,2,'2006-02-15 05:09:17'),
 (3096,680,2,'2006-02-15 05:09:17'),
 (3097,680,2,'2006-02-15 05:09:17'),
 (3098,681,1,'2006-02-15 05:09:17'),
 (3099,681,1,'2006-02-15 05:09:17'),
 (3100,681,1,'2006-02-15 05:09:17'),
 (3101,681,2,'2006-02-15 05:09:17'),
 (3102,681,2,'2006-02-15 05:09:17'),
 (3103,681,2,'2006-02-15 05:09:17'),
 (3104,682,1,'2006-02-15 05:09:17'),
 (3105,682,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3106,682,1,'2006-02-15 05:09:17'),
 (3107,683,1,'2006-02-15 05:09:17'),
 (3108,683,1,'2006-02-15 05:09:17'),
 (3109,683,1,'2006-02-15 05:09:17'),
 (3110,683,1,'2006-02-15 05:09:17'),
 (3111,683,2,'2006-02-15 05:09:17'),
 (3112,683,2,'2006-02-15 05:09:17'),
 (3113,683,2,'2006-02-15 05:09:17'),
 (3114,683,2,'2006-02-15 05:09:17'),
 (3115,684,2,'2006-02-15 05:09:17'),
 (3116,684,2,'2006-02-15 05:09:17'),
 (3117,685,2,'2006-02-15 05:09:17'),
 (3118,685,2,'2006-02-15 05:09:17'),
 (3119,686,1,'2006-02-15 05:09:17'),
 (3120,686,1,'2006-02-15 05:09:17'),
 (3121,686,1,'2006-02-15 05:09:17'),
 (3122,686,1,'2006-02-15 05:09:17'),
 (3123,687,1,'2006-02-15 05:09:17'),
 (3124,687,1,'2006-02-15 05:09:17'),
 (3125,687,1,'2006-02-15 05:09:17'),
 (3126,687,2,'2006-02-15 05:09:17'),
 (3127,687,2,'2006-02-15 05:09:17'),
 (3128,687,2,'2006-02-15 05:09:17'),
 (3129,687,2,'2006-02-15 05:09:17'),
 (3130,688,2,'2006-02-15 05:09:17'),
 (3131,688,2,'2006-02-15 05:09:17'),
 (3132,688,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3133,688,2,'2006-02-15 05:09:17'),
 (3134,689,1,'2006-02-15 05:09:17'),
 (3135,689,1,'2006-02-15 05:09:17'),
 (3136,689,1,'2006-02-15 05:09:17'),
 (3137,689,1,'2006-02-15 05:09:17'),
 (3138,689,2,'2006-02-15 05:09:17'),
 (3139,689,2,'2006-02-15 05:09:17'),
 (3140,690,1,'2006-02-15 05:09:17'),
 (3141,690,1,'2006-02-15 05:09:17'),
 (3142,690,1,'2006-02-15 05:09:17'),
 (3143,690,1,'2006-02-15 05:09:17'),
 (3144,690,2,'2006-02-15 05:09:17'),
 (3145,690,2,'2006-02-15 05:09:17'),
 (3146,691,1,'2006-02-15 05:09:17'),
 (3147,691,1,'2006-02-15 05:09:17'),
 (3148,691,1,'2006-02-15 05:09:17'),
 (3149,691,2,'2006-02-15 05:09:17'),
 (3150,691,2,'2006-02-15 05:09:17'),
 (3151,692,2,'2006-02-15 05:09:17'),
 (3152,692,2,'2006-02-15 05:09:17'),
 (3153,692,2,'2006-02-15 05:09:17'),
 (3154,693,1,'2006-02-15 05:09:17'),
 (3155,693,1,'2006-02-15 05:09:17'),
 (3156,693,2,'2006-02-15 05:09:17'),
 (3157,693,2,'2006-02-15 05:09:17'),
 (3158,693,2,'2006-02-15 05:09:17'),
 (3159,694,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3160,694,1,'2006-02-15 05:09:17'),
 (3161,694,1,'2006-02-15 05:09:17'),
 (3162,694,1,'2006-02-15 05:09:17'),
 (3163,694,2,'2006-02-15 05:09:17'),
 (3164,694,2,'2006-02-15 05:09:17'),
 (3165,695,1,'2006-02-15 05:09:17'),
 (3166,695,1,'2006-02-15 05:09:17'),
 (3167,696,1,'2006-02-15 05:09:17'),
 (3168,696,1,'2006-02-15 05:09:17'),
 (3169,696,2,'2006-02-15 05:09:17'),
 (3170,696,2,'2006-02-15 05:09:17'),
 (3171,696,2,'2006-02-15 05:09:17'),
 (3172,697,1,'2006-02-15 05:09:17'),
 (3173,697,1,'2006-02-15 05:09:17'),
 (3174,697,1,'2006-02-15 05:09:17'),
 (3175,697,1,'2006-02-15 05:09:17'),
 (3176,697,2,'2006-02-15 05:09:17'),
 (3177,697,2,'2006-02-15 05:09:17'),
 (3178,697,2,'2006-02-15 05:09:17'),
 (3179,697,2,'2006-02-15 05:09:17'),
 (3180,698,1,'2006-02-15 05:09:17'),
 (3181,698,1,'2006-02-15 05:09:17'),
 (3182,698,1,'2006-02-15 05:09:17'),
 (3183,698,1,'2006-02-15 05:09:17'),
 (3184,698,2,'2006-02-15 05:09:17'),
 (3185,698,2,'2006-02-15 05:09:17'),
 (3186,698,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3187,699,1,'2006-02-15 05:09:17'),
 (3188,699,1,'2006-02-15 05:09:17'),
 (3189,700,2,'2006-02-15 05:09:17'),
 (3190,700,2,'2006-02-15 05:09:17'),
 (3191,700,2,'2006-02-15 05:09:17'),
 (3192,702,1,'2006-02-15 05:09:17'),
 (3193,702,1,'2006-02-15 05:09:17'),
 (3194,702,1,'2006-02-15 05:09:17'),
 (3195,702,1,'2006-02-15 05:09:17'),
 (3196,702,2,'2006-02-15 05:09:17'),
 (3197,702,2,'2006-02-15 05:09:17'),
 (3198,702,2,'2006-02-15 05:09:17'),
 (3199,702,2,'2006-02-15 05:09:17'),
 (3200,703,2,'2006-02-15 05:09:17'),
 (3201,703,2,'2006-02-15 05:09:17'),
 (3202,704,1,'2006-02-15 05:09:17'),
 (3203,704,1,'2006-02-15 05:09:17'),
 (3204,704,2,'2006-02-15 05:09:17'),
 (3205,704,2,'2006-02-15 05:09:17'),
 (3206,704,2,'2006-02-15 05:09:17'),
 (3207,705,1,'2006-02-15 05:09:17'),
 (3208,705,1,'2006-02-15 05:09:17'),
 (3209,705,1,'2006-02-15 05:09:17'),
 (3210,705,1,'2006-02-15 05:09:17'),
 (3211,706,1,'2006-02-15 05:09:17'),
 (3212,706,1,'2006-02-15 05:09:17'),
 (3213,706,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3214,706,2,'2006-02-15 05:09:17'),
 (3215,706,2,'2006-02-15 05:09:17'),
 (3216,706,2,'2006-02-15 05:09:17'),
 (3217,707,1,'2006-02-15 05:09:17'),
 (3218,707,1,'2006-02-15 05:09:17'),
 (3219,707,2,'2006-02-15 05:09:17'),
 (3220,707,2,'2006-02-15 05:09:17'),
 (3221,707,2,'2006-02-15 05:09:17'),
 (3222,707,2,'2006-02-15 05:09:17'),
 (3223,708,1,'2006-02-15 05:09:17'),
 (3224,708,1,'2006-02-15 05:09:17'),
 (3225,708,2,'2006-02-15 05:09:17'),
 (3226,708,2,'2006-02-15 05:09:17'),
 (3227,709,1,'2006-02-15 05:09:17'),
 (3228,709,1,'2006-02-15 05:09:17'),
 (3229,709,2,'2006-02-15 05:09:17'),
 (3230,709,2,'2006-02-15 05:09:17'),
 (3231,709,2,'2006-02-15 05:09:17'),
 (3232,709,2,'2006-02-15 05:09:17'),
 (3233,710,1,'2006-02-15 05:09:17'),
 (3234,710,1,'2006-02-15 05:09:17'),
 (3235,710,1,'2006-02-15 05:09:17'),
 (3236,710,1,'2006-02-15 05:09:17'),
 (3237,710,2,'2006-02-15 05:09:17'),
 (3238,710,2,'2006-02-15 05:09:17'),
 (3239,711,2,'2006-02-15 05:09:17'),
 (3240,711,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3241,711,2,'2006-02-15 05:09:17'),
 (3242,711,2,'2006-02-15 05:09:17'),
 (3243,714,2,'2006-02-15 05:09:17'),
 (3244,714,2,'2006-02-15 05:09:17'),
 (3245,714,2,'2006-02-15 05:09:17'),
 (3246,715,1,'2006-02-15 05:09:17'),
 (3247,715,1,'2006-02-15 05:09:17'),
 (3248,715,1,'2006-02-15 05:09:17'),
 (3249,715,1,'2006-02-15 05:09:17'),
 (3250,715,2,'2006-02-15 05:09:17'),
 (3251,715,2,'2006-02-15 05:09:17'),
 (3252,715,2,'2006-02-15 05:09:17'),
 (3253,716,1,'2006-02-15 05:09:17'),
 (3254,716,1,'2006-02-15 05:09:17'),
 (3255,716,2,'2006-02-15 05:09:17'),
 (3256,716,2,'2006-02-15 05:09:17'),
 (3257,716,2,'2006-02-15 05:09:17'),
 (3258,717,1,'2006-02-15 05:09:17'),
 (3259,717,1,'2006-02-15 05:09:17'),
 (3260,717,2,'2006-02-15 05:09:17'),
 (3261,717,2,'2006-02-15 05:09:17'),
 (3262,718,2,'2006-02-15 05:09:17'),
 (3263,718,2,'2006-02-15 05:09:17'),
 (3264,719,1,'2006-02-15 05:09:17'),
 (3265,719,1,'2006-02-15 05:09:17'),
 (3266,720,1,'2006-02-15 05:09:17'),
 (3267,720,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3268,720,1,'2006-02-15 05:09:17'),
 (3269,720,2,'2006-02-15 05:09:17'),
 (3270,720,2,'2006-02-15 05:09:17'),
 (3271,720,2,'2006-02-15 05:09:17'),
 (3272,720,2,'2006-02-15 05:09:17'),
 (3273,721,1,'2006-02-15 05:09:17'),
 (3274,721,1,'2006-02-15 05:09:17'),
 (3275,722,1,'2006-02-15 05:09:17'),
 (3276,722,1,'2006-02-15 05:09:17'),
 (3277,722,2,'2006-02-15 05:09:17'),
 (3278,722,2,'2006-02-15 05:09:17'),
 (3279,723,1,'2006-02-15 05:09:17'),
 (3280,723,1,'2006-02-15 05:09:17'),
 (3281,723,1,'2006-02-15 05:09:17'),
 (3282,723,1,'2006-02-15 05:09:17'),
 (3283,723,2,'2006-02-15 05:09:17'),
 (3284,723,2,'2006-02-15 05:09:17'),
 (3285,723,2,'2006-02-15 05:09:17'),
 (3286,724,1,'2006-02-15 05:09:17'),
 (3287,724,1,'2006-02-15 05:09:17'),
 (3288,724,2,'2006-02-15 05:09:17'),
 (3289,724,2,'2006-02-15 05:09:17'),
 (3290,724,2,'2006-02-15 05:09:17'),
 (3291,724,2,'2006-02-15 05:09:17'),
 (3292,725,1,'2006-02-15 05:09:17'),
 (3293,725,1,'2006-02-15 05:09:17'),
 (3294,725,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3295,725,2,'2006-02-15 05:09:17'),
 (3296,725,2,'2006-02-15 05:09:17'),
 (3297,725,2,'2006-02-15 05:09:17'),
 (3298,726,2,'2006-02-15 05:09:17'),
 (3299,726,2,'2006-02-15 05:09:17'),
 (3300,726,2,'2006-02-15 05:09:17'),
 (3301,727,1,'2006-02-15 05:09:17'),
 (3302,727,1,'2006-02-15 05:09:17'),
 (3303,727,2,'2006-02-15 05:09:17'),
 (3304,727,2,'2006-02-15 05:09:17'),
 (3305,727,2,'2006-02-15 05:09:17'),
 (3306,728,1,'2006-02-15 05:09:17'),
 (3307,728,1,'2006-02-15 05:09:17'),
 (3308,728,1,'2006-02-15 05:09:17'),
 (3309,728,2,'2006-02-15 05:09:17'),
 (3310,728,2,'2006-02-15 05:09:17'),
 (3311,729,2,'2006-02-15 05:09:17'),
 (3312,729,2,'2006-02-15 05:09:17'),
 (3313,729,2,'2006-02-15 05:09:17'),
 (3314,729,2,'2006-02-15 05:09:17'),
 (3315,730,1,'2006-02-15 05:09:17'),
 (3316,730,1,'2006-02-15 05:09:17'),
 (3317,730,1,'2006-02-15 05:09:17'),
 (3318,730,1,'2006-02-15 05:09:17'),
 (3319,730,2,'2006-02-15 05:09:17'),
 (3320,730,2,'2006-02-15 05:09:17'),
 (3321,730,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3322,730,2,'2006-02-15 05:09:17'),
 (3323,731,2,'2006-02-15 05:09:17'),
 (3324,731,2,'2006-02-15 05:09:17'),
 (3325,731,2,'2006-02-15 05:09:17'),
 (3326,732,1,'2006-02-15 05:09:17'),
 (3327,732,1,'2006-02-15 05:09:17'),
 (3328,732,1,'2006-02-15 05:09:17'),
 (3329,732,1,'2006-02-15 05:09:17'),
 (3330,733,1,'2006-02-15 05:09:17'),
 (3331,733,1,'2006-02-15 05:09:17'),
 (3332,733,1,'2006-02-15 05:09:17'),
 (3333,733,1,'2006-02-15 05:09:17'),
 (3334,733,2,'2006-02-15 05:09:17'),
 (3335,733,2,'2006-02-15 05:09:17'),
 (3336,733,2,'2006-02-15 05:09:17'),
 (3337,734,1,'2006-02-15 05:09:17'),
 (3338,734,1,'2006-02-15 05:09:17'),
 (3339,734,2,'2006-02-15 05:09:17'),
 (3340,734,2,'2006-02-15 05:09:17'),
 (3341,734,2,'2006-02-15 05:09:17'),
 (3342,734,2,'2006-02-15 05:09:17'),
 (3343,735,1,'2006-02-15 05:09:17'),
 (3344,735,1,'2006-02-15 05:09:17'),
 (3345,735,1,'2006-02-15 05:09:17'),
 (3346,735,2,'2006-02-15 05:09:17'),
 (3347,735,2,'2006-02-15 05:09:17'),
 (3348,735,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3349,735,2,'2006-02-15 05:09:17'),
 (3350,736,1,'2006-02-15 05:09:17'),
 (3351,736,1,'2006-02-15 05:09:17'),
 (3352,736,1,'2006-02-15 05:09:17'),
 (3353,736,1,'2006-02-15 05:09:17'),
 (3354,737,1,'2006-02-15 05:09:17'),
 (3355,737,1,'2006-02-15 05:09:17'),
 (3356,737,2,'2006-02-15 05:09:17'),
 (3357,737,2,'2006-02-15 05:09:17'),
 (3358,737,2,'2006-02-15 05:09:17'),
 (3359,737,2,'2006-02-15 05:09:17'),
 (3360,738,1,'2006-02-15 05:09:17'),
 (3361,738,1,'2006-02-15 05:09:17'),
 (3362,738,1,'2006-02-15 05:09:17'),
 (3363,738,1,'2006-02-15 05:09:17'),
 (3364,738,2,'2006-02-15 05:09:17'),
 (3365,738,2,'2006-02-15 05:09:17'),
 (3366,738,2,'2006-02-15 05:09:17'),
 (3367,738,2,'2006-02-15 05:09:17'),
 (3368,739,1,'2006-02-15 05:09:17'),
 (3369,739,1,'2006-02-15 05:09:17'),
 (3370,739,2,'2006-02-15 05:09:17'),
 (3371,739,2,'2006-02-15 05:09:17'),
 (3372,739,2,'2006-02-15 05:09:17'),
 (3373,740,2,'2006-02-15 05:09:17'),
 (3374,740,2,'2006-02-15 05:09:17'),
 (3375,740,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3376,741,1,'2006-02-15 05:09:17'),
 (3377,741,1,'2006-02-15 05:09:17'),
 (3378,741,1,'2006-02-15 05:09:17'),
 (3379,741,1,'2006-02-15 05:09:17'),
 (3380,741,2,'2006-02-15 05:09:17'),
 (3381,741,2,'2006-02-15 05:09:17'),
 (3382,743,1,'2006-02-15 05:09:17'),
 (3383,743,1,'2006-02-15 05:09:17'),
 (3384,743,2,'2006-02-15 05:09:17'),
 (3385,743,2,'2006-02-15 05:09:17'),
 (3386,743,2,'2006-02-15 05:09:17'),
 (3387,743,2,'2006-02-15 05:09:17'),
 (3388,744,1,'2006-02-15 05:09:17'),
 (3389,744,1,'2006-02-15 05:09:17'),
 (3390,744,2,'2006-02-15 05:09:17'),
 (3391,744,2,'2006-02-15 05:09:17'),
 (3392,744,2,'2006-02-15 05:09:17'),
 (3393,745,1,'2006-02-15 05:09:17'),
 (3394,745,1,'2006-02-15 05:09:17'),
 (3395,745,1,'2006-02-15 05:09:17'),
 (3396,745,1,'2006-02-15 05:09:17'),
 (3397,745,2,'2006-02-15 05:09:17'),
 (3398,745,2,'2006-02-15 05:09:17'),
 (3399,745,2,'2006-02-15 05:09:17'),
 (3400,745,2,'2006-02-15 05:09:17'),
 (3401,746,1,'2006-02-15 05:09:17'),
 (3402,746,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3403,746,2,'2006-02-15 05:09:17'),
 (3404,746,2,'2006-02-15 05:09:17'),
 (3405,746,2,'2006-02-15 05:09:17'),
 (3406,747,1,'2006-02-15 05:09:17'),
 (3407,747,1,'2006-02-15 05:09:17'),
 (3408,747,2,'2006-02-15 05:09:17'),
 (3409,747,2,'2006-02-15 05:09:17'),
 (3410,747,2,'2006-02-15 05:09:17'),
 (3411,748,1,'2006-02-15 05:09:17'),
 (3412,748,1,'2006-02-15 05:09:17'),
 (3413,748,1,'2006-02-15 05:09:17'),
 (3414,748,1,'2006-02-15 05:09:17'),
 (3415,748,2,'2006-02-15 05:09:17'),
 (3416,748,2,'2006-02-15 05:09:17'),
 (3417,748,2,'2006-02-15 05:09:17'),
 (3418,748,2,'2006-02-15 05:09:17'),
 (3419,749,1,'2006-02-15 05:09:17'),
 (3420,749,1,'2006-02-15 05:09:17'),
 (3421,749,2,'2006-02-15 05:09:17'),
 (3422,749,2,'2006-02-15 05:09:17'),
 (3423,750,1,'2006-02-15 05:09:17'),
 (3424,750,1,'2006-02-15 05:09:17'),
 (3425,750,1,'2006-02-15 05:09:17'),
 (3426,751,2,'2006-02-15 05:09:17'),
 (3427,751,2,'2006-02-15 05:09:17'),
 (3428,752,2,'2006-02-15 05:09:17'),
 (3429,752,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3430,752,2,'2006-02-15 05:09:17'),
 (3431,753,1,'2006-02-15 05:09:17'),
 (3432,753,1,'2006-02-15 05:09:17'),
 (3433,753,1,'2006-02-15 05:09:17'),
 (3434,753,1,'2006-02-15 05:09:17'),
 (3435,753,2,'2006-02-15 05:09:17'),
 (3436,753,2,'2006-02-15 05:09:17'),
 (3437,753,2,'2006-02-15 05:09:17'),
 (3438,753,2,'2006-02-15 05:09:17'),
 (3439,754,2,'2006-02-15 05:09:17'),
 (3440,754,2,'2006-02-15 05:09:17'),
 (3441,755,1,'2006-02-15 05:09:17'),
 (3442,755,1,'2006-02-15 05:09:17'),
 (3443,755,1,'2006-02-15 05:09:17'),
 (3444,755,1,'2006-02-15 05:09:17'),
 (3445,755,2,'2006-02-15 05:09:17'),
 (3446,755,2,'2006-02-15 05:09:17'),
 (3447,755,2,'2006-02-15 05:09:17'),
 (3448,756,2,'2006-02-15 05:09:17'),
 (3449,756,2,'2006-02-15 05:09:17'),
 (3450,756,2,'2006-02-15 05:09:17'),
 (3451,757,1,'2006-02-15 05:09:17'),
 (3452,757,1,'2006-02-15 05:09:17'),
 (3453,757,1,'2006-02-15 05:09:17'),
 (3454,757,2,'2006-02-15 05:09:17'),
 (3455,757,2,'2006-02-15 05:09:17'),
 (3456,758,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3457,758,2,'2006-02-15 05:09:17'),
 (3458,758,2,'2006-02-15 05:09:17'),
 (3459,759,1,'2006-02-15 05:09:17'),
 (3460,759,1,'2006-02-15 05:09:17'),
 (3461,759,2,'2006-02-15 05:09:17'),
 (3462,759,2,'2006-02-15 05:09:17'),
 (3463,759,2,'2006-02-15 05:09:17'),
 (3464,759,2,'2006-02-15 05:09:17'),
 (3465,760,1,'2006-02-15 05:09:17'),
 (3466,760,1,'2006-02-15 05:09:17'),
 (3467,760,1,'2006-02-15 05:09:17'),
 (3468,760,2,'2006-02-15 05:09:17'),
 (3469,760,2,'2006-02-15 05:09:17'),
 (3470,760,2,'2006-02-15 05:09:17'),
 (3471,760,2,'2006-02-15 05:09:17'),
 (3472,761,2,'2006-02-15 05:09:17'),
 (3473,761,2,'2006-02-15 05:09:17'),
 (3474,761,2,'2006-02-15 05:09:17'),
 (3475,762,2,'2006-02-15 05:09:17'),
 (3476,762,2,'2006-02-15 05:09:17'),
 (3477,762,2,'2006-02-15 05:09:17'),
 (3478,762,2,'2006-02-15 05:09:17'),
 (3479,763,1,'2006-02-15 05:09:17'),
 (3480,763,1,'2006-02-15 05:09:17'),
 (3481,763,1,'2006-02-15 05:09:17'),
 (3482,763,2,'2006-02-15 05:09:17'),
 (3483,763,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3484,764,1,'2006-02-15 05:09:17'),
 (3485,764,1,'2006-02-15 05:09:17'),
 (3486,764,1,'2006-02-15 05:09:17'),
 (3487,764,1,'2006-02-15 05:09:17'),
 (3488,764,2,'2006-02-15 05:09:17'),
 (3489,764,2,'2006-02-15 05:09:17'),
 (3490,764,2,'2006-02-15 05:09:17'),
 (3491,764,2,'2006-02-15 05:09:17'),
 (3492,765,1,'2006-02-15 05:09:17'),
 (3493,765,1,'2006-02-15 05:09:17'),
 (3494,765,1,'2006-02-15 05:09:17'),
 (3495,765,1,'2006-02-15 05:09:17'),
 (3496,766,1,'2006-02-15 05:09:17'),
 (3497,766,1,'2006-02-15 05:09:17'),
 (3498,766,1,'2006-02-15 05:09:17'),
 (3499,767,1,'2006-02-15 05:09:17'),
 (3500,767,1,'2006-02-15 05:09:17'),
 (3501,767,1,'2006-02-15 05:09:17'),
 (3502,767,1,'2006-02-15 05:09:17'),
 (3503,767,2,'2006-02-15 05:09:17'),
 (3504,767,2,'2006-02-15 05:09:17'),
 (3505,767,2,'2006-02-15 05:09:17'),
 (3506,767,2,'2006-02-15 05:09:17'),
 (3507,768,1,'2006-02-15 05:09:17'),
 (3508,768,1,'2006-02-15 05:09:17'),
 (3509,768,1,'2006-02-15 05:09:17'),
 (3510,768,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3511,768,2,'2006-02-15 05:09:17'),
 (3512,768,2,'2006-02-15 05:09:17'),
 (3513,769,2,'2006-02-15 05:09:17'),
 (3514,769,2,'2006-02-15 05:09:17'),
 (3515,770,2,'2006-02-15 05:09:17'),
 (3516,770,2,'2006-02-15 05:09:17'),
 (3517,770,2,'2006-02-15 05:09:17'),
 (3518,771,1,'2006-02-15 05:09:17'),
 (3519,771,1,'2006-02-15 05:09:17'),
 (3520,771,1,'2006-02-15 05:09:17'),
 (3521,771,2,'2006-02-15 05:09:17'),
 (3522,771,2,'2006-02-15 05:09:17'),
 (3523,771,2,'2006-02-15 05:09:17'),
 (3524,771,2,'2006-02-15 05:09:17'),
 (3525,772,1,'2006-02-15 05:09:17'),
 (3526,772,1,'2006-02-15 05:09:17'),
 (3527,772,1,'2006-02-15 05:09:17'),
 (3528,772,1,'2006-02-15 05:09:17'),
 (3529,772,2,'2006-02-15 05:09:17'),
 (3530,772,2,'2006-02-15 05:09:17'),
 (3531,773,1,'2006-02-15 05:09:17'),
 (3532,773,1,'2006-02-15 05:09:17'),
 (3533,773,1,'2006-02-15 05:09:17'),
 (3534,773,1,'2006-02-15 05:09:17'),
 (3535,773,2,'2006-02-15 05:09:17'),
 (3536,773,2,'2006-02-15 05:09:17'),
 (3537,773,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3538,773,2,'2006-02-15 05:09:17'),
 (3539,774,1,'2006-02-15 05:09:17'),
 (3540,774,1,'2006-02-15 05:09:17'),
 (3541,774,1,'2006-02-15 05:09:17'),
 (3542,774,1,'2006-02-15 05:09:17'),
 (3543,775,1,'2006-02-15 05:09:17'),
 (3544,775,1,'2006-02-15 05:09:17'),
 (3545,775,1,'2006-02-15 05:09:17'),
 (3546,775,2,'2006-02-15 05:09:17'),
 (3547,775,2,'2006-02-15 05:09:17'),
 (3548,776,1,'2006-02-15 05:09:17'),
 (3549,776,1,'2006-02-15 05:09:17'),
 (3550,776,2,'2006-02-15 05:09:17'),
 (3551,776,2,'2006-02-15 05:09:17'),
 (3552,776,2,'2006-02-15 05:09:17'),
 (3553,777,1,'2006-02-15 05:09:17'),
 (3554,777,1,'2006-02-15 05:09:17'),
 (3555,777,1,'2006-02-15 05:09:17'),
 (3556,777,2,'2006-02-15 05:09:17'),
 (3557,777,2,'2006-02-15 05:09:17'),
 (3558,777,2,'2006-02-15 05:09:17'),
 (3559,778,1,'2006-02-15 05:09:17'),
 (3560,778,1,'2006-02-15 05:09:17'),
 (3561,778,1,'2006-02-15 05:09:17'),
 (3562,778,1,'2006-02-15 05:09:17'),
 (3563,778,2,'2006-02-15 05:09:17'),
 (3564,778,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3565,779,2,'2006-02-15 05:09:17'),
 (3566,779,2,'2006-02-15 05:09:17'),
 (3567,780,2,'2006-02-15 05:09:17'),
 (3568,780,2,'2006-02-15 05:09:17'),
 (3569,780,2,'2006-02-15 05:09:17'),
 (3570,781,2,'2006-02-15 05:09:17'),
 (3571,781,2,'2006-02-15 05:09:17'),
 (3572,782,1,'2006-02-15 05:09:17'),
 (3573,782,1,'2006-02-15 05:09:17'),
 (3574,782,1,'2006-02-15 05:09:17'),
 (3575,782,2,'2006-02-15 05:09:17'),
 (3576,782,2,'2006-02-15 05:09:17'),
 (3577,782,2,'2006-02-15 05:09:17'),
 (3578,783,1,'2006-02-15 05:09:17'),
 (3579,783,1,'2006-02-15 05:09:17'),
 (3580,783,1,'2006-02-15 05:09:17'),
 (3581,783,1,'2006-02-15 05:09:17'),
 (3582,784,1,'2006-02-15 05:09:17'),
 (3583,784,1,'2006-02-15 05:09:17'),
 (3584,784,1,'2006-02-15 05:09:17'),
 (3585,784,2,'2006-02-15 05:09:17'),
 (3586,784,2,'2006-02-15 05:09:17'),
 (3587,784,2,'2006-02-15 05:09:17'),
 (3588,785,1,'2006-02-15 05:09:17'),
 (3589,785,1,'2006-02-15 05:09:17'),
 (3590,785,1,'2006-02-15 05:09:17'),
 (3591,785,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3592,785,2,'2006-02-15 05:09:17'),
 (3593,785,2,'2006-02-15 05:09:17'),
 (3594,786,1,'2006-02-15 05:09:17'),
 (3595,786,1,'2006-02-15 05:09:17'),
 (3596,786,1,'2006-02-15 05:09:17'),
 (3597,786,2,'2006-02-15 05:09:17'),
 (3598,786,2,'2006-02-15 05:09:17'),
 (3599,786,2,'2006-02-15 05:09:17'),
 (3600,786,2,'2006-02-15 05:09:17'),
 (3601,787,1,'2006-02-15 05:09:17'),
 (3602,787,1,'2006-02-15 05:09:17'),
 (3603,787,1,'2006-02-15 05:09:17'),
 (3604,788,1,'2006-02-15 05:09:17'),
 (3605,788,1,'2006-02-15 05:09:17'),
 (3606,788,2,'2006-02-15 05:09:17'),
 (3607,788,2,'2006-02-15 05:09:17'),
 (3608,789,1,'2006-02-15 05:09:17'),
 (3609,789,1,'2006-02-15 05:09:17'),
 (3610,789,1,'2006-02-15 05:09:17'),
 (3611,789,1,'2006-02-15 05:09:17'),
 (3612,789,2,'2006-02-15 05:09:17'),
 (3613,789,2,'2006-02-15 05:09:17'),
 (3614,789,2,'2006-02-15 05:09:17'),
 (3615,789,2,'2006-02-15 05:09:17'),
 (3616,790,1,'2006-02-15 05:09:17'),
 (3617,790,1,'2006-02-15 05:09:17'),
 (3618,790,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3619,790,1,'2006-02-15 05:09:17'),
 (3620,790,2,'2006-02-15 05:09:17'),
 (3621,790,2,'2006-02-15 05:09:17'),
 (3622,790,2,'2006-02-15 05:09:17'),
 (3623,791,1,'2006-02-15 05:09:17'),
 (3624,791,1,'2006-02-15 05:09:17'),
 (3625,791,2,'2006-02-15 05:09:17'),
 (3626,791,2,'2006-02-15 05:09:17'),
 (3627,791,2,'2006-02-15 05:09:17'),
 (3628,791,2,'2006-02-15 05:09:17'),
 (3629,792,2,'2006-02-15 05:09:17'),
 (3630,792,2,'2006-02-15 05:09:17'),
 (3631,792,2,'2006-02-15 05:09:17'),
 (3632,793,1,'2006-02-15 05:09:17'),
 (3633,793,1,'2006-02-15 05:09:17'),
 (3634,793,1,'2006-02-15 05:09:17'),
 (3635,793,1,'2006-02-15 05:09:17'),
 (3636,794,1,'2006-02-15 05:09:17'),
 (3637,794,1,'2006-02-15 05:09:17'),
 (3638,794,2,'2006-02-15 05:09:17'),
 (3639,794,2,'2006-02-15 05:09:17'),
 (3640,795,1,'2006-02-15 05:09:17'),
 (3641,795,1,'2006-02-15 05:09:17'),
 (3642,795,1,'2006-02-15 05:09:17'),
 (3643,795,1,'2006-02-15 05:09:17'),
 (3644,796,1,'2006-02-15 05:09:17'),
 (3645,796,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3646,796,2,'2006-02-15 05:09:17'),
 (3647,796,2,'2006-02-15 05:09:17'),
 (3648,796,2,'2006-02-15 05:09:17'),
 (3649,797,1,'2006-02-15 05:09:17'),
 (3650,797,1,'2006-02-15 05:09:17'),
 (3651,797,2,'2006-02-15 05:09:17'),
 (3652,797,2,'2006-02-15 05:09:17'),
 (3653,797,2,'2006-02-15 05:09:17'),
 (3654,798,1,'2006-02-15 05:09:17'),
 (3655,798,1,'2006-02-15 05:09:17'),
 (3656,798,2,'2006-02-15 05:09:17'),
 (3657,798,2,'2006-02-15 05:09:17'),
 (3658,799,1,'2006-02-15 05:09:17'),
 (3659,799,1,'2006-02-15 05:09:17'),
 (3660,800,1,'2006-02-15 05:09:17'),
 (3661,800,1,'2006-02-15 05:09:17'),
 (3662,800,2,'2006-02-15 05:09:17'),
 (3663,800,2,'2006-02-15 05:09:17'),
 (3664,800,2,'2006-02-15 05:09:17'),
 (3665,800,2,'2006-02-15 05:09:17'),
 (3666,803,1,'2006-02-15 05:09:17'),
 (3667,803,1,'2006-02-15 05:09:17'),
 (3668,803,1,'2006-02-15 05:09:17'),
 (3669,803,1,'2006-02-15 05:09:17'),
 (3670,803,2,'2006-02-15 05:09:17'),
 (3671,803,2,'2006-02-15 05:09:17'),
 (3672,804,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3673,804,1,'2006-02-15 05:09:17'),
 (3674,804,1,'2006-02-15 05:09:17'),
 (3675,804,1,'2006-02-15 05:09:17'),
 (3676,804,2,'2006-02-15 05:09:17'),
 (3677,804,2,'2006-02-15 05:09:17'),
 (3678,804,2,'2006-02-15 05:09:17'),
 (3679,805,1,'2006-02-15 05:09:17'),
 (3680,805,1,'2006-02-15 05:09:17'),
 (3681,805,2,'2006-02-15 05:09:17'),
 (3682,805,2,'2006-02-15 05:09:17'),
 (3683,805,2,'2006-02-15 05:09:17'),
 (3684,806,1,'2006-02-15 05:09:17'),
 (3685,806,1,'2006-02-15 05:09:17'),
 (3686,806,1,'2006-02-15 05:09:17'),
 (3687,806,2,'2006-02-15 05:09:17'),
 (3688,806,2,'2006-02-15 05:09:17'),
 (3689,807,1,'2006-02-15 05:09:17'),
 (3690,807,1,'2006-02-15 05:09:17'),
 (3691,807,1,'2006-02-15 05:09:17'),
 (3692,807,2,'2006-02-15 05:09:17'),
 (3693,807,2,'2006-02-15 05:09:17'),
 (3694,808,2,'2006-02-15 05:09:17'),
 (3695,808,2,'2006-02-15 05:09:17'),
 (3696,809,2,'2006-02-15 05:09:17'),
 (3697,809,2,'2006-02-15 05:09:17'),
 (3698,809,2,'2006-02-15 05:09:17'),
 (3699,809,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3700,810,1,'2006-02-15 05:09:17'),
 (3701,810,1,'2006-02-15 05:09:17'),
 (3702,810,1,'2006-02-15 05:09:17'),
 (3703,810,1,'2006-02-15 05:09:17'),
 (3704,810,2,'2006-02-15 05:09:17'),
 (3705,810,2,'2006-02-15 05:09:17'),
 (3706,810,2,'2006-02-15 05:09:17'),
 (3707,811,1,'2006-02-15 05:09:17'),
 (3708,811,1,'2006-02-15 05:09:17'),
 (3709,811,1,'2006-02-15 05:09:17'),
 (3710,812,1,'2006-02-15 05:09:17'),
 (3711,812,1,'2006-02-15 05:09:17'),
 (3712,812,1,'2006-02-15 05:09:17'),
 (3713,812,2,'2006-02-15 05:09:17'),
 (3714,812,2,'2006-02-15 05:09:17'),
 (3715,812,2,'2006-02-15 05:09:17'),
 (3716,813,2,'2006-02-15 05:09:17'),
 (3717,813,2,'2006-02-15 05:09:17'),
 (3718,813,2,'2006-02-15 05:09:17'),
 (3719,813,2,'2006-02-15 05:09:17'),
 (3720,814,1,'2006-02-15 05:09:17'),
 (3721,814,1,'2006-02-15 05:09:17'),
 (3722,814,1,'2006-02-15 05:09:17'),
 (3723,814,2,'2006-02-15 05:09:17'),
 (3724,814,2,'2006-02-15 05:09:17'),
 (3725,814,2,'2006-02-15 05:09:17'),
 (3726,814,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3727,815,1,'2006-02-15 05:09:17'),
 (3728,815,1,'2006-02-15 05:09:17'),
 (3729,815,1,'2006-02-15 05:09:17'),
 (3730,816,1,'2006-02-15 05:09:17'),
 (3731,816,1,'2006-02-15 05:09:17'),
 (3732,816,1,'2006-02-15 05:09:17'),
 (3733,816,1,'2006-02-15 05:09:17'),
 (3734,816,2,'2006-02-15 05:09:17'),
 (3735,816,2,'2006-02-15 05:09:17'),
 (3736,816,2,'2006-02-15 05:09:17'),
 (3737,817,1,'2006-02-15 05:09:17'),
 (3738,817,1,'2006-02-15 05:09:17'),
 (3739,818,1,'2006-02-15 05:09:17'),
 (3740,818,1,'2006-02-15 05:09:17'),
 (3741,818,1,'2006-02-15 05:09:17'),
 (3742,818,2,'2006-02-15 05:09:17'),
 (3743,818,2,'2006-02-15 05:09:17'),
 (3744,819,1,'2006-02-15 05:09:17'),
 (3745,819,1,'2006-02-15 05:09:17'),
 (3746,819,1,'2006-02-15 05:09:17'),
 (3747,820,1,'2006-02-15 05:09:17'),
 (3748,820,1,'2006-02-15 05:09:17'),
 (3749,820,1,'2006-02-15 05:09:17'),
 (3750,820,1,'2006-02-15 05:09:17'),
 (3751,820,2,'2006-02-15 05:09:17'),
 (3752,820,2,'2006-02-15 05:09:17'),
 (3753,821,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3754,821,2,'2006-02-15 05:09:17'),
 (3755,821,2,'2006-02-15 05:09:17'),
 (3756,821,2,'2006-02-15 05:09:17'),
 (3757,822,2,'2006-02-15 05:09:17'),
 (3758,822,2,'2006-02-15 05:09:17'),
 (3759,823,1,'2006-02-15 05:09:17'),
 (3760,823,1,'2006-02-15 05:09:17'),
 (3761,823,1,'2006-02-15 05:09:17'),
 (3762,823,2,'2006-02-15 05:09:17'),
 (3763,823,2,'2006-02-15 05:09:17'),
 (3764,823,2,'2006-02-15 05:09:17'),
 (3765,823,2,'2006-02-15 05:09:17'),
 (3766,824,2,'2006-02-15 05:09:17'),
 (3767,824,2,'2006-02-15 05:09:17'),
 (3768,824,2,'2006-02-15 05:09:17'),
 (3769,824,2,'2006-02-15 05:09:17'),
 (3770,825,1,'2006-02-15 05:09:17'),
 (3771,825,1,'2006-02-15 05:09:17'),
 (3772,825,1,'2006-02-15 05:09:17'),
 (3773,826,2,'2006-02-15 05:09:17'),
 (3774,826,2,'2006-02-15 05:09:17'),
 (3775,827,1,'2006-02-15 05:09:17'),
 (3776,827,1,'2006-02-15 05:09:17'),
 (3777,827,2,'2006-02-15 05:09:17'),
 (3778,827,2,'2006-02-15 05:09:17'),
 (3779,827,2,'2006-02-15 05:09:17'),
 (3780,827,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3781,828,2,'2006-02-15 05:09:17'),
 (3782,828,2,'2006-02-15 05:09:17'),
 (3783,828,2,'2006-02-15 05:09:17'),
 (3784,828,2,'2006-02-15 05:09:17'),
 (3785,829,1,'2006-02-15 05:09:17'),
 (3786,829,1,'2006-02-15 05:09:17'),
 (3787,829,2,'2006-02-15 05:09:17'),
 (3788,829,2,'2006-02-15 05:09:17'),
 (3789,829,2,'2006-02-15 05:09:17'),
 (3790,830,2,'2006-02-15 05:09:17'),
 (3791,830,2,'2006-02-15 05:09:17'),
 (3792,830,2,'2006-02-15 05:09:17'),
 (3793,830,2,'2006-02-15 05:09:17'),
 (3794,831,1,'2006-02-15 05:09:17'),
 (3795,831,1,'2006-02-15 05:09:17'),
 (3796,831,1,'2006-02-15 05:09:17'),
 (3797,832,1,'2006-02-15 05:09:17'),
 (3798,832,1,'2006-02-15 05:09:17'),
 (3799,832,1,'2006-02-15 05:09:17'),
 (3800,832,1,'2006-02-15 05:09:17'),
 (3801,833,1,'2006-02-15 05:09:17'),
 (3802,833,1,'2006-02-15 05:09:17'),
 (3803,833,1,'2006-02-15 05:09:17'),
 (3804,833,2,'2006-02-15 05:09:17'),
 (3805,833,2,'2006-02-15 05:09:17'),
 (3806,833,2,'2006-02-15 05:09:17'),
 (3807,833,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3808,834,2,'2006-02-15 05:09:17'),
 (3809,834,2,'2006-02-15 05:09:17'),
 (3810,834,2,'2006-02-15 05:09:17'),
 (3811,835,1,'2006-02-15 05:09:17'),
 (3812,835,1,'2006-02-15 05:09:17'),
 (3813,835,1,'2006-02-15 05:09:17'),
 (3814,835,1,'2006-02-15 05:09:17'),
 (3815,835,2,'2006-02-15 05:09:17'),
 (3816,835,2,'2006-02-15 05:09:17'),
 (3817,835,2,'2006-02-15 05:09:17'),
 (3818,835,2,'2006-02-15 05:09:17'),
 (3819,836,1,'2006-02-15 05:09:17'),
 (3820,836,1,'2006-02-15 05:09:17'),
 (3821,836,1,'2006-02-15 05:09:17'),
 (3822,837,2,'2006-02-15 05:09:17'),
 (3823,837,2,'2006-02-15 05:09:17'),
 (3824,837,2,'2006-02-15 05:09:17'),
 (3825,838,1,'2006-02-15 05:09:17'),
 (3826,838,1,'2006-02-15 05:09:17'),
 (3827,838,2,'2006-02-15 05:09:17'),
 (3828,838,2,'2006-02-15 05:09:17'),
 (3829,838,2,'2006-02-15 05:09:17'),
 (3830,838,2,'2006-02-15 05:09:17'),
 (3831,839,2,'2006-02-15 05:09:17'),
 (3832,839,2,'2006-02-15 05:09:17'),
 (3833,840,1,'2006-02-15 05:09:17'),
 (3834,840,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3835,840,1,'2006-02-15 05:09:17'),
 (3836,840,1,'2006-02-15 05:09:17'),
 (3837,841,1,'2006-02-15 05:09:17'),
 (3838,841,1,'2006-02-15 05:09:17'),
 (3839,841,1,'2006-02-15 05:09:17'),
 (3840,841,2,'2006-02-15 05:09:17'),
 (3841,841,2,'2006-02-15 05:09:17'),
 (3842,841,2,'2006-02-15 05:09:17'),
 (3843,841,2,'2006-02-15 05:09:17'),
 (3844,842,1,'2006-02-15 05:09:17'),
 (3845,842,1,'2006-02-15 05:09:17'),
 (3846,842,2,'2006-02-15 05:09:17'),
 (3847,842,2,'2006-02-15 05:09:17'),
 (3848,843,1,'2006-02-15 05:09:17'),
 (3849,843,1,'2006-02-15 05:09:17'),
 (3850,843,1,'2006-02-15 05:09:17'),
 (3851,843,1,'2006-02-15 05:09:17'),
 (3852,843,2,'2006-02-15 05:09:17'),
 (3853,843,2,'2006-02-15 05:09:17'),
 (3854,843,2,'2006-02-15 05:09:17'),
 (3855,844,1,'2006-02-15 05:09:17'),
 (3856,844,1,'2006-02-15 05:09:17'),
 (3857,844,2,'2006-02-15 05:09:17'),
 (3858,844,2,'2006-02-15 05:09:17'),
 (3859,845,1,'2006-02-15 05:09:17'),
 (3860,845,1,'2006-02-15 05:09:17'),
 (3861,845,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3862,845,1,'2006-02-15 05:09:17'),
 (3863,845,2,'2006-02-15 05:09:17'),
 (3864,845,2,'2006-02-15 05:09:17'),
 (3865,845,2,'2006-02-15 05:09:17'),
 (3866,846,1,'2006-02-15 05:09:17'),
 (3867,846,1,'2006-02-15 05:09:17'),
 (3868,846,1,'2006-02-15 05:09:17'),
 (3869,846,1,'2006-02-15 05:09:17'),
 (3870,846,2,'2006-02-15 05:09:17'),
 (3871,846,2,'2006-02-15 05:09:17'),
 (3872,846,2,'2006-02-15 05:09:17'),
 (3873,846,2,'2006-02-15 05:09:17'),
 (3874,847,2,'2006-02-15 05:09:17'),
 (3875,847,2,'2006-02-15 05:09:17'),
 (3876,847,2,'2006-02-15 05:09:17'),
 (3877,847,2,'2006-02-15 05:09:17'),
 (3878,848,1,'2006-02-15 05:09:17'),
 (3879,848,1,'2006-02-15 05:09:17'),
 (3880,848,1,'2006-02-15 05:09:17'),
 (3881,849,1,'2006-02-15 05:09:17'),
 (3882,849,1,'2006-02-15 05:09:17'),
 (3883,849,1,'2006-02-15 05:09:17'),
 (3884,849,1,'2006-02-15 05:09:17'),
 (3885,849,2,'2006-02-15 05:09:17'),
 (3886,849,2,'2006-02-15 05:09:17'),
 (3887,849,2,'2006-02-15 05:09:17'),
 (3888,849,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3889,850,1,'2006-02-15 05:09:17'),
 (3890,850,1,'2006-02-15 05:09:17'),
 (3891,850,1,'2006-02-15 05:09:17'),
 (3892,850,2,'2006-02-15 05:09:17'),
 (3893,850,2,'2006-02-15 05:09:17'),
 (3894,850,2,'2006-02-15 05:09:17'),
 (3895,850,2,'2006-02-15 05:09:17'),
 (3896,851,1,'2006-02-15 05:09:17'),
 (3897,851,1,'2006-02-15 05:09:17'),
 (3898,851,1,'2006-02-15 05:09:17'),
 (3899,851,2,'2006-02-15 05:09:17'),
 (3900,851,2,'2006-02-15 05:09:17'),
 (3901,851,2,'2006-02-15 05:09:17'),
 (3902,852,1,'2006-02-15 05:09:17'),
 (3903,852,1,'2006-02-15 05:09:17'),
 (3904,852,1,'2006-02-15 05:09:17'),
 (3905,852,1,'2006-02-15 05:09:17'),
 (3906,852,2,'2006-02-15 05:09:17'),
 (3907,852,2,'2006-02-15 05:09:17'),
 (3908,852,2,'2006-02-15 05:09:17'),
 (3909,853,1,'2006-02-15 05:09:17'),
 (3910,853,1,'2006-02-15 05:09:17'),
 (3911,853,1,'2006-02-15 05:09:17'),
 (3912,854,2,'2006-02-15 05:09:17'),
 (3913,854,2,'2006-02-15 05:09:17'),
 (3914,854,2,'2006-02-15 05:09:17'),
 (3915,854,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3916,855,1,'2006-02-15 05:09:17'),
 (3917,855,1,'2006-02-15 05:09:17'),
 (3918,855,2,'2006-02-15 05:09:17'),
 (3919,855,2,'2006-02-15 05:09:17'),
 (3920,856,1,'2006-02-15 05:09:17'),
 (3921,856,1,'2006-02-15 05:09:17'),
 (3922,856,1,'2006-02-15 05:09:17'),
 (3923,856,1,'2006-02-15 05:09:17'),
 (3924,856,2,'2006-02-15 05:09:17'),
 (3925,856,2,'2006-02-15 05:09:17'),
 (3926,856,2,'2006-02-15 05:09:17'),
 (3927,856,2,'2006-02-15 05:09:17'),
 (3928,857,1,'2006-02-15 05:09:17'),
 (3929,857,1,'2006-02-15 05:09:17'),
 (3930,857,1,'2006-02-15 05:09:17'),
 (3931,857,2,'2006-02-15 05:09:17'),
 (3932,857,2,'2006-02-15 05:09:17'),
 (3933,857,2,'2006-02-15 05:09:17'),
 (3934,857,2,'2006-02-15 05:09:17'),
 (3935,858,2,'2006-02-15 05:09:17'),
 (3936,858,2,'2006-02-15 05:09:17'),
 (3937,858,2,'2006-02-15 05:09:17'),
 (3938,858,2,'2006-02-15 05:09:17'),
 (3939,859,1,'2006-02-15 05:09:17'),
 (3940,859,1,'2006-02-15 05:09:17'),
 (3941,859,1,'2006-02-15 05:09:17'),
 (3942,859,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3943,859,2,'2006-02-15 05:09:17'),
 (3944,859,2,'2006-02-15 05:09:17'),
 (3945,861,1,'2006-02-15 05:09:17'),
 (3946,861,1,'2006-02-15 05:09:17'),
 (3947,861,1,'2006-02-15 05:09:17'),
 (3948,861,2,'2006-02-15 05:09:17'),
 (3949,861,2,'2006-02-15 05:09:17'),
 (3950,861,2,'2006-02-15 05:09:17'),
 (3951,862,1,'2006-02-15 05:09:17'),
 (3952,862,1,'2006-02-15 05:09:17'),
 (3953,862,1,'2006-02-15 05:09:17'),
 (3954,862,2,'2006-02-15 05:09:17'),
 (3955,862,2,'2006-02-15 05:09:17'),
 (3956,863,1,'2006-02-15 05:09:17'),
 (3957,863,1,'2006-02-15 05:09:17'),
 (3958,863,1,'2006-02-15 05:09:17'),
 (3959,863,1,'2006-02-15 05:09:17'),
 (3960,863,2,'2006-02-15 05:09:17'),
 (3961,863,2,'2006-02-15 05:09:17'),
 (3962,863,2,'2006-02-15 05:09:17'),
 (3963,864,1,'2006-02-15 05:09:17'),
 (3964,864,1,'2006-02-15 05:09:17'),
 (3965,864,1,'2006-02-15 05:09:17'),
 (3966,864,1,'2006-02-15 05:09:17'),
 (3967,864,2,'2006-02-15 05:09:17'),
 (3968,864,2,'2006-02-15 05:09:17'),
 (3969,865,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3970,865,1,'2006-02-15 05:09:17'),
 (3971,865,1,'2006-02-15 05:09:17'),
 (3972,865,1,'2006-02-15 05:09:17'),
 (3973,865,2,'2006-02-15 05:09:17'),
 (3974,865,2,'2006-02-15 05:09:17'),
 (3975,866,2,'2006-02-15 05:09:17'),
 (3976,866,2,'2006-02-15 05:09:17'),
 (3977,867,1,'2006-02-15 05:09:17'),
 (3978,867,1,'2006-02-15 05:09:17'),
 (3979,867,1,'2006-02-15 05:09:17'),
 (3980,867,1,'2006-02-15 05:09:17'),
 (3981,868,1,'2006-02-15 05:09:17'),
 (3982,868,1,'2006-02-15 05:09:17'),
 (3983,868,1,'2006-02-15 05:09:17'),
 (3984,869,1,'2006-02-15 05:09:17'),
 (3985,869,1,'2006-02-15 05:09:17'),
 (3986,869,1,'2006-02-15 05:09:17'),
 (3987,869,1,'2006-02-15 05:09:17'),
 (3988,869,2,'2006-02-15 05:09:17'),
 (3989,869,2,'2006-02-15 05:09:17'),
 (3990,869,2,'2006-02-15 05:09:17'),
 (3991,870,1,'2006-02-15 05:09:17'),
 (3992,870,1,'2006-02-15 05:09:17'),
 (3993,870,1,'2006-02-15 05:09:17'),
 (3994,870,1,'2006-02-15 05:09:17'),
 (3995,870,2,'2006-02-15 05:09:17'),
 (3996,870,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (3997,870,2,'2006-02-15 05:09:17'),
 (3998,870,2,'2006-02-15 05:09:17'),
 (3999,871,1,'2006-02-15 05:09:17'),
 (4000,871,1,'2006-02-15 05:09:17'),
 (4001,871,2,'2006-02-15 05:09:17'),
 (4002,871,2,'2006-02-15 05:09:17'),
 (4003,871,2,'2006-02-15 05:09:17'),
 (4004,872,2,'2006-02-15 05:09:17'),
 (4005,872,2,'2006-02-15 05:09:17'),
 (4006,872,2,'2006-02-15 05:09:17'),
 (4007,873,1,'2006-02-15 05:09:17'),
 (4008,873,1,'2006-02-15 05:09:17'),
 (4009,873,1,'2006-02-15 05:09:17'),
 (4010,873,1,'2006-02-15 05:09:17'),
 (4011,873,2,'2006-02-15 05:09:17'),
 (4012,873,2,'2006-02-15 05:09:17'),
 (4013,873,2,'2006-02-15 05:09:17'),
 (4014,873,2,'2006-02-15 05:09:17'),
 (4015,875,1,'2006-02-15 05:09:17'),
 (4016,875,1,'2006-02-15 05:09:17'),
 (4017,875,1,'2006-02-15 05:09:17'),
 (4018,875,2,'2006-02-15 05:09:17'),
 (4019,875,2,'2006-02-15 05:09:17'),
 (4020,875,2,'2006-02-15 05:09:17'),
 (4021,875,2,'2006-02-15 05:09:17'),
 (4022,876,1,'2006-02-15 05:09:17'),
 (4023,876,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4024,877,1,'2006-02-15 05:09:17'),
 (4025,877,1,'2006-02-15 05:09:17'),
 (4026,877,1,'2006-02-15 05:09:17'),
 (4027,877,2,'2006-02-15 05:09:17'),
 (4028,877,2,'2006-02-15 05:09:17'),
 (4029,878,2,'2006-02-15 05:09:17'),
 (4030,878,2,'2006-02-15 05:09:17'),
 (4031,878,2,'2006-02-15 05:09:17'),
 (4032,878,2,'2006-02-15 05:09:17'),
 (4033,879,1,'2006-02-15 05:09:17'),
 (4034,879,1,'2006-02-15 05:09:17'),
 (4035,879,1,'2006-02-15 05:09:17'),
 (4036,879,1,'2006-02-15 05:09:17'),
 (4037,879,2,'2006-02-15 05:09:17'),
 (4038,879,2,'2006-02-15 05:09:17'),
 (4039,879,2,'2006-02-15 05:09:17'),
 (4040,880,1,'2006-02-15 05:09:17'),
 (4041,880,1,'2006-02-15 05:09:17'),
 (4042,880,1,'2006-02-15 05:09:17'),
 (4043,880,1,'2006-02-15 05:09:17'),
 (4044,880,2,'2006-02-15 05:09:17'),
 (4045,880,2,'2006-02-15 05:09:17'),
 (4046,880,2,'2006-02-15 05:09:17'),
 (4047,880,2,'2006-02-15 05:09:17'),
 (4048,881,2,'2006-02-15 05:09:17'),
 (4049,881,2,'2006-02-15 05:09:17'),
 (4050,881,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4051,881,2,'2006-02-15 05:09:17'),
 (4052,882,1,'2006-02-15 05:09:17'),
 (4053,882,1,'2006-02-15 05:09:17'),
 (4054,882,1,'2006-02-15 05:09:17'),
 (4055,882,1,'2006-02-15 05:09:17'),
 (4056,883,2,'2006-02-15 05:09:17'),
 (4057,883,2,'2006-02-15 05:09:17'),
 (4058,884,2,'2006-02-15 05:09:17'),
 (4059,884,2,'2006-02-15 05:09:17'),
 (4060,884,2,'2006-02-15 05:09:17'),
 (4061,885,1,'2006-02-15 05:09:17'),
 (4062,885,1,'2006-02-15 05:09:17'),
 (4063,886,1,'2006-02-15 05:09:17'),
 (4064,886,1,'2006-02-15 05:09:17'),
 (4065,886,1,'2006-02-15 05:09:17'),
 (4066,886,1,'2006-02-15 05:09:17'),
 (4067,887,1,'2006-02-15 05:09:17'),
 (4068,887,1,'2006-02-15 05:09:17'),
 (4069,887,1,'2006-02-15 05:09:17'),
 (4070,887,1,'2006-02-15 05:09:17'),
 (4071,887,2,'2006-02-15 05:09:17'),
 (4072,887,2,'2006-02-15 05:09:17'),
 (4073,888,1,'2006-02-15 05:09:17'),
 (4074,888,1,'2006-02-15 05:09:17'),
 (4075,888,1,'2006-02-15 05:09:17'),
 (4076,888,1,'2006-02-15 05:09:17'),
 (4077,889,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4078,889,1,'2006-02-15 05:09:17'),
 (4079,889,1,'2006-02-15 05:09:17'),
 (4080,890,1,'2006-02-15 05:09:17'),
 (4081,890,1,'2006-02-15 05:09:17'),
 (4082,890,1,'2006-02-15 05:09:17'),
 (4083,890,2,'2006-02-15 05:09:17'),
 (4084,890,2,'2006-02-15 05:09:17'),
 (4085,890,2,'2006-02-15 05:09:17'),
 (4086,890,2,'2006-02-15 05:09:17'),
 (4087,891,1,'2006-02-15 05:09:17'),
 (4088,891,1,'2006-02-15 05:09:17'),
 (4089,891,1,'2006-02-15 05:09:17'),
 (4090,891,2,'2006-02-15 05:09:17'),
 (4091,891,2,'2006-02-15 05:09:17'),
 (4092,891,2,'2006-02-15 05:09:17'),
 (4093,891,2,'2006-02-15 05:09:17'),
 (4094,892,1,'2006-02-15 05:09:17'),
 (4095,892,1,'2006-02-15 05:09:17'),
 (4096,892,1,'2006-02-15 05:09:17'),
 (4097,892,2,'2006-02-15 05:09:17'),
 (4098,892,2,'2006-02-15 05:09:17'),
 (4099,892,2,'2006-02-15 05:09:17'),
 (4100,892,2,'2006-02-15 05:09:17'),
 (4101,893,1,'2006-02-15 05:09:17'),
 (4102,893,1,'2006-02-15 05:09:17'),
 (4103,893,1,'2006-02-15 05:09:17'),
 (4104,893,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4105,893,2,'2006-02-15 05:09:17'),
 (4106,893,2,'2006-02-15 05:09:17'),
 (4107,893,2,'2006-02-15 05:09:17'),
 (4108,893,2,'2006-02-15 05:09:17'),
 (4109,894,1,'2006-02-15 05:09:17'),
 (4110,894,1,'2006-02-15 05:09:17'),
 (4111,894,1,'2006-02-15 05:09:17'),
 (4112,894,2,'2006-02-15 05:09:17'),
 (4113,894,2,'2006-02-15 05:09:17'),
 (4114,895,1,'2006-02-15 05:09:17'),
 (4115,895,1,'2006-02-15 05:09:17'),
 (4116,895,1,'2006-02-15 05:09:17'),
 (4117,895,1,'2006-02-15 05:09:17'),
 (4118,895,2,'2006-02-15 05:09:17'),
 (4119,895,2,'2006-02-15 05:09:17'),
 (4120,895,2,'2006-02-15 05:09:17'),
 (4121,896,1,'2006-02-15 05:09:17'),
 (4122,896,1,'2006-02-15 05:09:17'),
 (4123,896,2,'2006-02-15 05:09:17'),
 (4124,896,2,'2006-02-15 05:09:17'),
 (4125,897,1,'2006-02-15 05:09:17'),
 (4126,897,1,'2006-02-15 05:09:17'),
 (4127,897,1,'2006-02-15 05:09:17'),
 (4128,897,1,'2006-02-15 05:09:17'),
 (4129,897,2,'2006-02-15 05:09:17'),
 (4130,897,2,'2006-02-15 05:09:17'),
 (4131,897,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4132,897,2,'2006-02-15 05:09:17'),
 (4133,898,1,'2006-02-15 05:09:17'),
 (4134,898,1,'2006-02-15 05:09:17'),
 (4135,898,1,'2006-02-15 05:09:17'),
 (4136,898,2,'2006-02-15 05:09:17'),
 (4137,898,2,'2006-02-15 05:09:17'),
 (4138,899,1,'2006-02-15 05:09:17'),
 (4139,899,1,'2006-02-15 05:09:17'),
 (4140,899,1,'2006-02-15 05:09:17'),
 (4141,900,1,'2006-02-15 05:09:17'),
 (4142,900,1,'2006-02-15 05:09:17'),
 (4143,900,2,'2006-02-15 05:09:17'),
 (4144,900,2,'2006-02-15 05:09:17'),
 (4145,901,1,'2006-02-15 05:09:17'),
 (4146,901,1,'2006-02-15 05:09:17'),
 (4147,901,1,'2006-02-15 05:09:17'),
 (4148,901,1,'2006-02-15 05:09:17'),
 (4149,901,2,'2006-02-15 05:09:17'),
 (4150,901,2,'2006-02-15 05:09:17'),
 (4151,901,2,'2006-02-15 05:09:17'),
 (4152,902,1,'2006-02-15 05:09:17'),
 (4153,902,1,'2006-02-15 05:09:17'),
 (4154,902,1,'2006-02-15 05:09:17'),
 (4155,902,1,'2006-02-15 05:09:17'),
 (4156,902,2,'2006-02-15 05:09:17'),
 (4157,902,2,'2006-02-15 05:09:17'),
 (4158,902,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4159,903,2,'2006-02-15 05:09:17'),
 (4160,903,2,'2006-02-15 05:09:17'),
 (4161,904,1,'2006-02-15 05:09:17'),
 (4162,904,1,'2006-02-15 05:09:17'),
 (4163,905,1,'2006-02-15 05:09:17'),
 (4164,905,1,'2006-02-15 05:09:17'),
 (4165,905,1,'2006-02-15 05:09:17'),
 (4166,906,1,'2006-02-15 05:09:17'),
 (4167,906,1,'2006-02-15 05:09:17'),
 (4168,906,2,'2006-02-15 05:09:17'),
 (4169,906,2,'2006-02-15 05:09:17'),
 (4170,906,2,'2006-02-15 05:09:17'),
 (4171,907,1,'2006-02-15 05:09:17'),
 (4172,907,1,'2006-02-15 05:09:17'),
 (4173,907,1,'2006-02-15 05:09:17'),
 (4174,907,1,'2006-02-15 05:09:17'),
 (4175,908,1,'2006-02-15 05:09:17'),
 (4176,908,1,'2006-02-15 05:09:17'),
 (4177,908,2,'2006-02-15 05:09:17'),
 (4178,908,2,'2006-02-15 05:09:17'),
 (4179,910,2,'2006-02-15 05:09:17'),
 (4180,910,2,'2006-02-15 05:09:17'),
 (4181,911,1,'2006-02-15 05:09:17'),
 (4182,911,1,'2006-02-15 05:09:17'),
 (4183,911,1,'2006-02-15 05:09:17'),
 (4184,911,1,'2006-02-15 05:09:17'),
 (4185,911,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4186,911,2,'2006-02-15 05:09:17'),
 (4187,911,2,'2006-02-15 05:09:17'),
 (4188,911,2,'2006-02-15 05:09:17'),
 (4189,912,1,'2006-02-15 05:09:17'),
 (4190,912,1,'2006-02-15 05:09:17'),
 (4191,912,1,'2006-02-15 05:09:17'),
 (4192,912,2,'2006-02-15 05:09:17'),
 (4193,912,2,'2006-02-15 05:09:17'),
 (4194,912,2,'2006-02-15 05:09:17'),
 (4195,913,1,'2006-02-15 05:09:17'),
 (4196,913,1,'2006-02-15 05:09:17'),
 (4197,913,1,'2006-02-15 05:09:17'),
 (4198,913,1,'2006-02-15 05:09:17'),
 (4199,913,2,'2006-02-15 05:09:17'),
 (4200,913,2,'2006-02-15 05:09:17'),
 (4201,914,1,'2006-02-15 05:09:17'),
 (4202,914,1,'2006-02-15 05:09:17'),
 (4203,914,2,'2006-02-15 05:09:17'),
 (4204,914,2,'2006-02-15 05:09:17'),
 (4205,914,2,'2006-02-15 05:09:17'),
 (4206,914,2,'2006-02-15 05:09:17'),
 (4207,915,1,'2006-02-15 05:09:17'),
 (4208,915,1,'2006-02-15 05:09:17'),
 (4209,915,1,'2006-02-15 05:09:17'),
 (4210,915,1,'2006-02-15 05:09:17'),
 (4211,915,2,'2006-02-15 05:09:17'),
 (4212,915,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4213,916,1,'2006-02-15 05:09:17'),
 (4214,916,1,'2006-02-15 05:09:17'),
 (4215,916,2,'2006-02-15 05:09:17'),
 (4216,916,2,'2006-02-15 05:09:17'),
 (4217,917,1,'2006-02-15 05:09:17'),
 (4218,917,1,'2006-02-15 05:09:17'),
 (4219,917,1,'2006-02-15 05:09:17'),
 (4220,917,2,'2006-02-15 05:09:17'),
 (4221,917,2,'2006-02-15 05:09:17'),
 (4222,918,2,'2006-02-15 05:09:17'),
 (4223,918,2,'2006-02-15 05:09:17'),
 (4224,918,2,'2006-02-15 05:09:17'),
 (4225,918,2,'2006-02-15 05:09:17'),
 (4226,919,1,'2006-02-15 05:09:17'),
 (4227,919,1,'2006-02-15 05:09:17'),
 (4228,919,1,'2006-02-15 05:09:17'),
 (4229,919,1,'2006-02-15 05:09:17'),
 (4230,920,1,'2006-02-15 05:09:17'),
 (4231,920,1,'2006-02-15 05:09:17'),
 (4232,920,1,'2006-02-15 05:09:17'),
 (4233,920,2,'2006-02-15 05:09:17'),
 (4234,920,2,'2006-02-15 05:09:17'),
 (4235,921,1,'2006-02-15 05:09:17'),
 (4236,921,1,'2006-02-15 05:09:17'),
 (4237,921,2,'2006-02-15 05:09:17'),
 (4238,921,2,'2006-02-15 05:09:17'),
 (4239,922,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4240,922,1,'2006-02-15 05:09:17'),
 (4241,922,1,'2006-02-15 05:09:17'),
 (4242,922,2,'2006-02-15 05:09:17'),
 (4243,922,2,'2006-02-15 05:09:17'),
 (4244,922,2,'2006-02-15 05:09:17'),
 (4245,922,2,'2006-02-15 05:09:17'),
 (4246,923,2,'2006-02-15 05:09:17'),
 (4247,923,2,'2006-02-15 05:09:17'),
 (4248,923,2,'2006-02-15 05:09:17'),
 (4249,924,1,'2006-02-15 05:09:17'),
 (4250,924,1,'2006-02-15 05:09:17'),
 (4251,924,2,'2006-02-15 05:09:17'),
 (4252,924,2,'2006-02-15 05:09:17'),
 (4253,924,2,'2006-02-15 05:09:17'),
 (4254,925,1,'2006-02-15 05:09:17'),
 (4255,925,1,'2006-02-15 05:09:17'),
 (4256,925,1,'2006-02-15 05:09:17'),
 (4257,925,2,'2006-02-15 05:09:17'),
 (4258,925,2,'2006-02-15 05:09:17'),
 (4259,926,2,'2006-02-15 05:09:17'),
 (4260,926,2,'2006-02-15 05:09:17'),
 (4261,927,1,'2006-02-15 05:09:17'),
 (4262,927,1,'2006-02-15 05:09:17'),
 (4263,927,1,'2006-02-15 05:09:17'),
 (4264,927,1,'2006-02-15 05:09:17'),
 (4265,928,1,'2006-02-15 05:09:17'),
 (4266,928,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4267,928,1,'2006-02-15 05:09:17'),
 (4268,929,1,'2006-02-15 05:09:17'),
 (4269,929,1,'2006-02-15 05:09:17'),
 (4270,929,1,'2006-02-15 05:09:17'),
 (4271,929,1,'2006-02-15 05:09:17'),
 (4272,930,1,'2006-02-15 05:09:17'),
 (4273,930,1,'2006-02-15 05:09:17'),
 (4274,930,1,'2006-02-15 05:09:17'),
 (4275,930,2,'2006-02-15 05:09:17'),
 (4276,930,2,'2006-02-15 05:09:17'),
 (4277,930,2,'2006-02-15 05:09:17'),
 (4278,931,2,'2006-02-15 05:09:17'),
 (4279,931,2,'2006-02-15 05:09:17'),
 (4280,931,2,'2006-02-15 05:09:17'),
 (4281,932,1,'2006-02-15 05:09:17'),
 (4282,932,1,'2006-02-15 05:09:17'),
 (4283,932,2,'2006-02-15 05:09:17'),
 (4284,932,2,'2006-02-15 05:09:17'),
 (4285,933,1,'2006-02-15 05:09:17'),
 (4286,933,1,'2006-02-15 05:09:17'),
 (4287,933,1,'2006-02-15 05:09:17'),
 (4288,934,2,'2006-02-15 05:09:17'),
 (4289,934,2,'2006-02-15 05:09:17'),
 (4290,934,2,'2006-02-15 05:09:17'),
 (4291,935,2,'2006-02-15 05:09:17'),
 (4292,935,2,'2006-02-15 05:09:17'),
 (4293,936,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4294,936,1,'2006-02-15 05:09:17'),
 (4295,936,2,'2006-02-15 05:09:17'),
 (4296,936,2,'2006-02-15 05:09:17'),
 (4297,936,2,'2006-02-15 05:09:17'),
 (4298,936,2,'2006-02-15 05:09:17'),
 (4299,937,1,'2006-02-15 05:09:17'),
 (4300,937,1,'2006-02-15 05:09:17'),
 (4301,937,2,'2006-02-15 05:09:17'),
 (4302,937,2,'2006-02-15 05:09:17'),
 (4303,937,2,'2006-02-15 05:09:17'),
 (4304,938,1,'2006-02-15 05:09:17'),
 (4305,938,1,'2006-02-15 05:09:17'),
 (4306,938,1,'2006-02-15 05:09:17'),
 (4307,938,1,'2006-02-15 05:09:17'),
 (4308,938,2,'2006-02-15 05:09:17'),
 (4309,938,2,'2006-02-15 05:09:17'),
 (4310,939,2,'2006-02-15 05:09:17'),
 (4311,939,2,'2006-02-15 05:09:17'),
 (4312,939,2,'2006-02-15 05:09:17'),
 (4313,939,2,'2006-02-15 05:09:17'),
 (4314,940,1,'2006-02-15 05:09:17'),
 (4315,940,1,'2006-02-15 05:09:17'),
 (4316,940,1,'2006-02-15 05:09:17'),
 (4317,941,1,'2006-02-15 05:09:17'),
 (4318,941,1,'2006-02-15 05:09:17'),
 (4319,941,1,'2006-02-15 05:09:17'),
 (4320,941,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4321,941,2,'2006-02-15 05:09:17'),
 (4322,941,2,'2006-02-15 05:09:17'),
 (4323,941,2,'2006-02-15 05:09:17'),
 (4324,942,1,'2006-02-15 05:09:17'),
 (4325,942,1,'2006-02-15 05:09:17'),
 (4326,942,2,'2006-02-15 05:09:17'),
 (4327,942,2,'2006-02-15 05:09:17'),
 (4328,944,1,'2006-02-15 05:09:17'),
 (4329,944,1,'2006-02-15 05:09:17'),
 (4330,944,2,'2006-02-15 05:09:17'),
 (4331,944,2,'2006-02-15 05:09:17'),
 (4332,944,2,'2006-02-15 05:09:17'),
 (4333,945,1,'2006-02-15 05:09:17'),
 (4334,945,1,'2006-02-15 05:09:17'),
 (4335,945,1,'2006-02-15 05:09:17'),
 (4336,945,1,'2006-02-15 05:09:17'),
 (4337,945,2,'2006-02-15 05:09:17'),
 (4338,945,2,'2006-02-15 05:09:17'),
 (4339,945,2,'2006-02-15 05:09:17'),
 (4340,945,2,'2006-02-15 05:09:17'),
 (4341,946,2,'2006-02-15 05:09:17'),
 (4342,946,2,'2006-02-15 05:09:17'),
 (4343,946,2,'2006-02-15 05:09:17'),
 (4344,946,2,'2006-02-15 05:09:17'),
 (4345,947,1,'2006-02-15 05:09:17'),
 (4346,947,1,'2006-02-15 05:09:17'),
 (4347,948,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4348,948,1,'2006-02-15 05:09:17'),
 (4349,948,2,'2006-02-15 05:09:17'),
 (4350,948,2,'2006-02-15 05:09:17'),
 (4351,948,2,'2006-02-15 05:09:17'),
 (4352,948,2,'2006-02-15 05:09:17'),
 (4353,949,1,'2006-02-15 05:09:17'),
 (4354,949,1,'2006-02-15 05:09:17'),
 (4355,949,1,'2006-02-15 05:09:17'),
 (4356,949,1,'2006-02-15 05:09:17'),
 (4357,949,2,'2006-02-15 05:09:17'),
 (4358,949,2,'2006-02-15 05:09:17'),
 (4359,951,1,'2006-02-15 05:09:17'),
 (4360,951,1,'2006-02-15 05:09:17'),
 (4361,951,1,'2006-02-15 05:09:17'),
 (4362,951,2,'2006-02-15 05:09:17'),
 (4363,951,2,'2006-02-15 05:09:17'),
 (4364,951,2,'2006-02-15 05:09:17'),
 (4365,951,2,'2006-02-15 05:09:17'),
 (4366,952,1,'2006-02-15 05:09:17'),
 (4367,952,1,'2006-02-15 05:09:17'),
 (4368,952,1,'2006-02-15 05:09:17'),
 (4369,953,1,'2006-02-15 05:09:17'),
 (4370,953,1,'2006-02-15 05:09:17'),
 (4371,953,1,'2006-02-15 05:09:17'),
 (4372,953,1,'2006-02-15 05:09:17'),
 (4373,953,2,'2006-02-15 05:09:17'),
 (4374,953,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4375,956,1,'2006-02-15 05:09:17'),
 (4376,956,1,'2006-02-15 05:09:17'),
 (4377,956,1,'2006-02-15 05:09:17'),
 (4378,956,1,'2006-02-15 05:09:17'),
 (4379,957,1,'2006-02-15 05:09:17'),
 (4380,957,1,'2006-02-15 05:09:17'),
 (4381,957,1,'2006-02-15 05:09:17'),
 (4382,957,2,'2006-02-15 05:09:17'),
 (4383,957,2,'2006-02-15 05:09:17'),
 (4384,958,1,'2006-02-15 05:09:17'),
 (4385,958,1,'2006-02-15 05:09:17'),
 (4386,958,1,'2006-02-15 05:09:17'),
 (4387,958,2,'2006-02-15 05:09:17'),
 (4388,958,2,'2006-02-15 05:09:17'),
 (4389,958,2,'2006-02-15 05:09:17'),
 (4390,959,1,'2006-02-15 05:09:17'),
 (4391,959,1,'2006-02-15 05:09:17'),
 (4392,960,2,'2006-02-15 05:09:17'),
 (4393,960,2,'2006-02-15 05:09:17'),
 (4394,960,2,'2006-02-15 05:09:17'),
 (4395,961,1,'2006-02-15 05:09:17'),
 (4396,961,1,'2006-02-15 05:09:17'),
 (4397,961,1,'2006-02-15 05:09:17'),
 (4398,961,2,'2006-02-15 05:09:17'),
 (4399,961,2,'2006-02-15 05:09:17'),
 (4400,962,1,'2006-02-15 05:09:17'),
 (4401,962,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4402,962,1,'2006-02-15 05:09:17'),
 (4403,962,1,'2006-02-15 05:09:17'),
 (4404,963,1,'2006-02-15 05:09:17'),
 (4405,963,1,'2006-02-15 05:09:17'),
 (4406,963,2,'2006-02-15 05:09:17'),
 (4407,963,2,'2006-02-15 05:09:17'),
 (4408,963,2,'2006-02-15 05:09:17'),
 (4409,964,1,'2006-02-15 05:09:17'),
 (4410,964,1,'2006-02-15 05:09:17'),
 (4411,964,1,'2006-02-15 05:09:17'),
 (4412,964,2,'2006-02-15 05:09:17'),
 (4413,964,2,'2006-02-15 05:09:17'),
 (4414,965,1,'2006-02-15 05:09:17'),
 (4415,965,1,'2006-02-15 05:09:17'),
 (4416,966,1,'2006-02-15 05:09:17'),
 (4417,966,1,'2006-02-15 05:09:17'),
 (4418,966,2,'2006-02-15 05:09:17'),
 (4419,966,2,'2006-02-15 05:09:17'),
 (4420,966,2,'2006-02-15 05:09:17'),
 (4421,966,2,'2006-02-15 05:09:17'),
 (4422,967,1,'2006-02-15 05:09:17'),
 (4423,967,1,'2006-02-15 05:09:17'),
 (4424,967,1,'2006-02-15 05:09:17'),
 (4425,967,2,'2006-02-15 05:09:17'),
 (4426,967,2,'2006-02-15 05:09:17'),
 (4427,968,1,'2006-02-15 05:09:17'),
 (4428,968,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4429,968,1,'2006-02-15 05:09:17'),
 (4430,969,1,'2006-02-15 05:09:17'),
 (4431,969,1,'2006-02-15 05:09:17'),
 (4432,969,1,'2006-02-15 05:09:17'),
 (4433,969,1,'2006-02-15 05:09:17'),
 (4434,970,1,'2006-02-15 05:09:17'),
 (4435,970,1,'2006-02-15 05:09:17'),
 (4436,970,1,'2006-02-15 05:09:17'),
 (4437,970,2,'2006-02-15 05:09:17'),
 (4438,970,2,'2006-02-15 05:09:17'),
 (4439,970,2,'2006-02-15 05:09:17'),
 (4440,970,2,'2006-02-15 05:09:17'),
 (4441,971,1,'2006-02-15 05:09:17'),
 (4442,971,1,'2006-02-15 05:09:17'),
 (4443,971,1,'2006-02-15 05:09:17'),
 (4444,971,1,'2006-02-15 05:09:17'),
 (4445,972,1,'2006-02-15 05:09:17'),
 (4446,972,1,'2006-02-15 05:09:17'),
 (4447,972,1,'2006-02-15 05:09:17'),
 (4448,972,2,'2006-02-15 05:09:17'),
 (4449,972,2,'2006-02-15 05:09:17'),
 (4450,972,2,'2006-02-15 05:09:17'),
 (4451,973,1,'2006-02-15 05:09:17'),
 (4452,973,1,'2006-02-15 05:09:17'),
 (4453,973,1,'2006-02-15 05:09:17'),
 (4454,973,1,'2006-02-15 05:09:17'),
 (4455,973,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4456,973,2,'2006-02-15 05:09:17'),
 (4457,973,2,'2006-02-15 05:09:17'),
 (4458,973,2,'2006-02-15 05:09:17'),
 (4459,974,1,'2006-02-15 05:09:17'),
 (4460,974,1,'2006-02-15 05:09:17'),
 (4461,975,1,'2006-02-15 05:09:17'),
 (4462,975,1,'2006-02-15 05:09:17'),
 (4463,975,2,'2006-02-15 05:09:17'),
 (4464,975,2,'2006-02-15 05:09:17'),
 (4465,975,2,'2006-02-15 05:09:17'),
 (4466,976,1,'2006-02-15 05:09:17'),
 (4467,976,1,'2006-02-15 05:09:17'),
 (4468,976,2,'2006-02-15 05:09:17'),
 (4469,976,2,'2006-02-15 05:09:17'),
 (4470,976,2,'2006-02-15 05:09:17'),
 (4471,976,2,'2006-02-15 05:09:17'),
 (4472,977,2,'2006-02-15 05:09:17'),
 (4473,977,2,'2006-02-15 05:09:17'),
 (4474,977,2,'2006-02-15 05:09:17'),
 (4475,978,1,'2006-02-15 05:09:17'),
 (4476,978,1,'2006-02-15 05:09:17'),
 (4477,978,1,'2006-02-15 05:09:17'),
 (4478,979,1,'2006-02-15 05:09:17'),
 (4479,979,1,'2006-02-15 05:09:17'),
 (4480,979,1,'2006-02-15 05:09:17'),
 (4481,979,1,'2006-02-15 05:09:17'),
 (4482,979,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4483,979,2,'2006-02-15 05:09:17'),
 (4484,979,2,'2006-02-15 05:09:17'),
 (4485,980,1,'2006-02-15 05:09:17'),
 (4486,980,1,'2006-02-15 05:09:17'),
 (4487,980,1,'2006-02-15 05:09:17'),
 (4488,980,2,'2006-02-15 05:09:17'),
 (4489,980,2,'2006-02-15 05:09:17'),
 (4490,981,1,'2006-02-15 05:09:17'),
 (4491,981,1,'2006-02-15 05:09:17'),
 (4492,981,1,'2006-02-15 05:09:17'),
 (4493,981,2,'2006-02-15 05:09:17'),
 (4494,981,2,'2006-02-15 05:09:17'),
 (4495,981,2,'2006-02-15 05:09:17'),
 (4496,982,1,'2006-02-15 05:09:17'),
 (4497,982,1,'2006-02-15 05:09:17'),
 (4498,982,1,'2006-02-15 05:09:17'),
 (4499,982,2,'2006-02-15 05:09:17'),
 (4500,982,2,'2006-02-15 05:09:17'),
 (4501,982,2,'2006-02-15 05:09:17'),
 (4502,982,2,'2006-02-15 05:09:17'),
 (4503,983,1,'2006-02-15 05:09:17'),
 (4504,983,1,'2006-02-15 05:09:17'),
 (4505,983,1,'2006-02-15 05:09:17'),
 (4506,984,1,'2006-02-15 05:09:17'),
 (4507,984,1,'2006-02-15 05:09:17'),
 (4508,985,1,'2006-02-15 05:09:17'),
 (4509,985,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4510,985,1,'2006-02-15 05:09:17'),
 (4511,985,1,'2006-02-15 05:09:17'),
 (4512,985,2,'2006-02-15 05:09:17'),
 (4513,985,2,'2006-02-15 05:09:17'),
 (4514,985,2,'2006-02-15 05:09:17'),
 (4515,986,1,'2006-02-15 05:09:17'),
 (4516,986,1,'2006-02-15 05:09:17'),
 (4517,986,1,'2006-02-15 05:09:17'),
 (4518,986,1,'2006-02-15 05:09:17'),
 (4519,986,2,'2006-02-15 05:09:17'),
 (4520,986,2,'2006-02-15 05:09:17'),
 (4521,987,1,'2006-02-15 05:09:17'),
 (4522,987,1,'2006-02-15 05:09:17'),
 (4523,987,2,'2006-02-15 05:09:17'),
 (4524,987,2,'2006-02-15 05:09:17'),
 (4525,988,1,'2006-02-15 05:09:17'),
 (4526,988,1,'2006-02-15 05:09:17'),
 (4527,988,1,'2006-02-15 05:09:17'),
 (4528,988,2,'2006-02-15 05:09:17'),
 (4529,988,2,'2006-02-15 05:09:17'),
 (4530,989,1,'2006-02-15 05:09:17'),
 (4531,989,1,'2006-02-15 05:09:17'),
 (4532,989,1,'2006-02-15 05:09:17'),
 (4533,989,1,'2006-02-15 05:09:17'),
 (4534,989,2,'2006-02-15 05:09:17'),
 (4535,989,2,'2006-02-15 05:09:17'),
 (4536,990,2,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4537,990,2,'2006-02-15 05:09:17'),
 (4538,991,1,'2006-02-15 05:09:17'),
 (4539,991,1,'2006-02-15 05:09:17'),
 (4540,991,2,'2006-02-15 05:09:17'),
 (4541,991,2,'2006-02-15 05:09:17'),
 (4542,991,2,'2006-02-15 05:09:17'),
 (4543,992,2,'2006-02-15 05:09:17'),
 (4544,992,2,'2006-02-15 05:09:17'),
 (4545,992,2,'2006-02-15 05:09:17'),
 (4546,992,2,'2006-02-15 05:09:17'),
 (4547,993,1,'2006-02-15 05:09:17'),
 (4548,993,1,'2006-02-15 05:09:17'),
 (4549,993,1,'2006-02-15 05:09:17'),
 (4550,993,1,'2006-02-15 05:09:17'),
 (4551,993,2,'2006-02-15 05:09:17'),
 (4552,993,2,'2006-02-15 05:09:17'),
 (4553,993,2,'2006-02-15 05:09:17'),
 (4554,994,1,'2006-02-15 05:09:17'),
 (4555,994,1,'2006-02-15 05:09:17'),
 (4556,994,1,'2006-02-15 05:09:17'),
 (4557,995,1,'2006-02-15 05:09:17'),
 (4558,995,1,'2006-02-15 05:09:17'),
 (4559,995,1,'2006-02-15 05:09:17'),
 (4560,995,1,'2006-02-15 05:09:17'),
 (4561,995,2,'2006-02-15 05:09:17'),
 (4562,995,2,'2006-02-15 05:09:17'),
 (4563,996,1,'2006-02-15 05:09:17');
INSERT INTO `sakila`.`inventory` VALUES  (4564,996,1,'2006-02-15 05:09:17'),
 (4565,997,1,'2006-02-15 05:09:17'),
 (4566,997,1,'2006-02-15 05:09:17'),
 (4567,998,2,'2006-02-15 05:09:17'),
 (4568,998,2,'2006-02-15 05:09:17'),
 (4569,999,1,'2006-02-15 05:09:17'),
 (4570,999,1,'2006-02-15 05:09:17'),
 (4571,999,2,'2006-02-15 05:09:17'),
 (4572,999,2,'2006-02-15 05:09:17'),
 (4573,999,2,'2006-02-15 05:09:17'),
 (4574,1000,1,'2006-02-15 05:09:17'),
 (4575,1000,1,'2006-02-15 05:09:17'),
 (4576,1000,1,'2006-02-15 05:09:17'),
 (4577,1000,1,'2006-02-15 05:09:17'),
 (4578,1000,2,'2006-02-15 05:09:17'),
 (4579,1000,2,'2006-02-15 05:09:17'),
 (4580,1000,2,'2006-02-15 05:09:17'),
 (4581,1000,2,'2006-02-15 05:09:17');
COMMIT;

--
-- Definition of table `sakila`.`language`
--

DROP TABLE IF EXISTS `sakila`.`language`;
CREATE TABLE  `sakila`.`language` (
  `language_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`language`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`language` VALUES  (1,'English','2006-02-15 05:02:19'),
 (2,'Italian','2006-02-15 05:02:19'),
 (3,'Japanese','2006-02-15 05:02:19'),
 (4,'Mandarin','2006-02-15 05:02:19'),
 (5,'French','2006-02-15 05:02:19'),
 (6,'German','2006-02-15 05:02:19');
COMMIT;

--
-- Definition of table `sakila`.`payment`
--

DROP TABLE IF EXISTS `sakila`.`payment`;
CREATE TABLE  `sakila`.`payment` (
  `payment_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` smallint(5) unsigned NOT NULL,
  `staff_id` tinyint(3) unsigned NOT NULL,
  `rental_id` int(11) DEFAULT NULL,
  `amount` decimal(5,2) NOT NULL,
  `payment_date` datetime NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`payment_id`),
  KEY `idx_fk_staff_id` (`staff_id`),
  KEY `idx_fk_customer_id` (`customer_id`),
  KEY `fk_payment_rental` (`rental_id`),
  CONSTRAINT `fk_payment_customer` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`customer_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_payment_rental` FOREIGN KEY (`rental_id`) REFERENCES `rental` (`rental_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_payment_staff` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`staff_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`payment`
--
SET AUTOCOMMIT=0;
INSERT INTO `sakila`.`payment` VALUES  (1,1,1,76,'2.99','2005-05-25 11:30:37','2006-02-15 22:12:30'),
 (2,1,1,573,'0.99','2005-05-28 10:35:23','2006-02-15 22:12:30'),
 (3,1,1,1185,'5.99','2005-06-15 00:54:12','2006-02-15 22:12:30'),
 (4,1,2,1422,'0.99','2005-06-15 18:02:53','2006-02-15 22:12:30'),
 (5,1,2,1476,'9.99','2005-06-15 21:08:46','2006-02-15 22:12:30'),
 (6,1,1,1725,'4.99','2005-06-16 15:18:57','2006-02-15 22:12:30'),
 (7,1,1,2308,'4.99','2005-06-18 08:41:48','2006-02-15 22:12:30'),
 (8,1,2,2363,'0.99','2005-06-18 13:33:59','2006-02-15 22:12:30'),
 (9,1,1,3284,'3.99','2005-06-21 06:24:45','2006-02-15 22:12:30'),
 (10,1,2,4526,'5.99','2005-07-08 03:17:05','2006-02-15 22:12:30'),
 (11,1,1,4611,'5.99','2005-07-08 07:33:56','2006-02-15 22:12:30'),
 (12,1,1,5244,'4.99','2005-07-09 13:24:07','2006-02-15 22:12:30'),
 (13,1,1,5326,'4.99','2005-07-09 16:38:01','2006-02-15 22:12:30'),
 (14,1,1,6163,'7.99','2005-07-11 10:13:46','2006-02-15 22:12:30'),
 (15,1,2,7273,'2.99','2005-07-27 11:31:22','2006-02-15 22:12:30'),
 (16,1,1,7841,'4.99','2005-07-28 09:04:45','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (17,1,2,8033,'4.99','2005-07-28 16:18:23','2006-02-15 22:12:30'),
 (18,1,1,8074,'0.99','2005-07-28 17:33:39','2006-02-15 22:12:30'),
 (19,1,2,8116,'0.99','2005-07-28 19:20:07','2006-02-15 22:12:30'),
 (20,1,2,8326,'2.99','2005-07-29 03:58:49','2006-02-15 22:12:30'),
 (21,1,2,9571,'2.99','2005-07-31 02:42:18','2006-02-15 22:12:30'),
 (22,1,2,10437,'4.99','2005-08-01 08:51:04','2006-02-15 22:12:30'),
 (23,1,2,11299,'3.99','2005-08-02 15:36:52','2006-02-15 22:12:30'),
 (24,1,1,11367,'0.99','2005-08-02 18:01:38','2006-02-15 22:12:30'),
 (25,1,2,11824,'4.99','2005-08-17 12:37:54','2006-02-15 22:12:30'),
 (26,1,1,12250,'0.99','2005-08-18 03:57:29','2006-02-15 22:12:30'),
 (27,1,2,13068,'0.99','2005-08-19 09:55:16','2006-02-15 22:12:30'),
 (28,1,2,13176,'2.99','2005-08-19 13:56:54','2006-02-15 22:12:30'),
 (29,1,1,14762,'0.99','2005-08-21 23:33:57','2006-02-15 22:12:30'),
 (30,1,1,14825,'1.99','2005-08-22 01:27:57','2006-02-15 22:12:30'),
 (31,1,2,15298,'2.99','2005-08-22 19:41:37','2006-02-15 22:12:30'),
 (32,1,1,15315,'5.99','2005-08-22 20:03:46','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (33,2,1,320,'4.99','2005-05-27 00:09:24','2006-02-15 22:12:30'),
 (34,2,1,2128,'2.99','2005-06-17 20:54:58','2006-02-15 22:12:30'),
 (35,2,1,5636,'2.99','2005-07-10 06:31:24','2006-02-15 22:12:30'),
 (36,2,1,5755,'6.99','2005-07-10 12:38:56','2006-02-15 22:12:30'),
 (37,2,2,7346,'4.99','2005-07-27 14:30:42','2006-02-15 22:12:30'),
 (38,2,1,7376,'5.99','2005-07-27 15:23:02','2006-02-15 22:12:30'),
 (39,2,2,7459,'5.99','2005-07-27 18:40:20','2006-02-15 22:12:30'),
 (40,2,2,8230,'5.99','2005-07-29 00:12:59','2006-02-15 22:12:30'),
 (41,2,1,8598,'2.99','2005-07-29 12:56:59','2006-02-15 22:12:30'),
 (42,2,2,8705,'5.99','2005-07-29 17:14:29','2006-02-15 22:12:30'),
 (43,2,1,9031,'4.99','2005-07-30 06:06:10','2006-02-15 22:12:30'),
 (44,2,2,9236,'10.99','2005-07-30 13:47:43','2006-02-15 22:12:30'),
 (45,2,2,9248,'0.99','2005-07-30 14:14:11','2006-02-15 22:12:30'),
 (46,2,2,9296,'6.99','2005-07-30 16:21:13','2006-02-15 22:12:30'),
 (47,2,2,9465,'6.99','2005-07-30 22:39:53','2006-02-15 22:12:30'),
 (48,2,1,10136,'2.99','2005-07-31 21:58:56','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (49,2,1,10466,'0.99','2005-08-01 09:45:26','2006-02-15 22:12:30'),
 (50,2,1,10918,'0.99','2005-08-02 02:10:56','2006-02-15 22:12:30'),
 (51,2,1,11087,'5.99','2005-08-02 07:41:41','2006-02-15 22:12:30'),
 (52,2,1,11177,'6.99','2005-08-02 10:43:48','2006-02-15 22:12:30'),
 (53,2,2,11256,'2.99','2005-08-02 13:44:53','2006-02-15 22:12:30'),
 (54,2,1,11614,'2.99','2005-08-17 03:52:18','2006-02-15 22:12:30'),
 (55,2,1,12963,'2.99','2005-08-19 06:26:04','2006-02-15 22:12:30'),
 (56,2,1,14475,'4.99','2005-08-21 13:24:32','2006-02-15 22:12:30'),
 (57,2,2,14743,'5.99','2005-08-21 22:41:56','2006-02-15 22:12:30'),
 (58,2,2,15145,'4.99','2005-08-22 13:53:04','2006-02-15 22:12:30'),
 (59,2,2,15907,'4.99','2005-08-23 17:39:35','2006-02-15 22:12:30'),
 (60,3,1,435,'1.99','2005-05-27 17:17:09','2006-02-15 22:12:30'),
 (61,3,1,830,'2.99','2005-05-29 22:43:55','2006-02-15 22:12:30'),
 (62,3,1,1546,'8.99','2005-06-16 01:34:05','2006-02-15 22:12:30'),
 (63,3,1,1726,'6.99','2005-06-16 15:19:10','2006-02-15 22:12:30'),
 (64,3,2,1911,'6.99','2005-06-17 05:15:15','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (65,3,1,2628,'2.99','2005-06-19 08:34:53','2006-02-15 22:12:30'),
 (66,3,1,4180,'4.99','2005-07-07 10:23:25','2006-02-15 22:12:30'),
 (67,3,1,4725,'4.99','2005-07-08 12:47:11','2006-02-15 22:12:30'),
 (68,3,1,7096,'5.99','2005-07-27 04:54:42','2006-02-15 22:12:30'),
 (69,3,2,7503,'10.99','2005-07-27 20:23:12','2006-02-15 22:12:30'),
 (70,3,2,7703,'7.99','2005-07-28 03:59:21','2006-02-15 22:12:30'),
 (71,3,2,7724,'6.99','2005-07-28 04:46:30','2006-02-15 22:12:30'),
 (72,3,1,7911,'4.99','2005-07-28 11:46:45','2006-02-15 22:12:30'),
 (73,3,2,8086,'4.99','2005-07-28 18:17:14','2006-02-15 22:12:30'),
 (74,3,1,8545,'2.99','2005-07-29 11:07:04','2006-02-15 22:12:30'),
 (75,3,1,9226,'1.99','2005-07-30 13:31:20','2006-02-15 22:12:30'),
 (76,3,2,9443,'3.99','2005-07-30 21:45:46','2006-02-15 22:12:30'),
 (77,3,1,9595,'2.99','2005-07-31 03:27:58','2006-02-15 22:12:30'),
 (78,3,2,9816,'4.99','2005-07-31 11:32:58','2006-02-15 22:12:30'),
 (79,3,2,10597,'5.99','2005-08-01 14:19:48','2006-02-15 22:12:30'),
 (80,3,2,12556,'4.99','2005-08-18 14:49:55','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (81,3,1,13403,'8.99','2005-08-19 22:18:07','2006-02-15 22:12:30'),
 (82,3,2,13610,'2.99','2005-08-20 06:14:12','2006-02-15 22:12:30'),
 (83,3,2,14699,'8.99','2005-08-21 20:50:48','2006-02-15 22:12:30'),
 (84,3,2,15038,'0.99','2005-08-22 09:37:27','2006-02-15 22:12:30'),
 (85,3,1,15619,'2.99','2005-08-23 07:10:14','2006-02-15 22:12:30'),
 (86,4,1,1297,'4.99','2005-06-15 09:31:28','2006-02-15 22:12:30'),
 (87,4,1,1633,'0.99','2005-06-16 08:08:40','2006-02-15 22:12:30'),
 (88,4,2,1707,'2.99','2005-06-16 14:01:27','2006-02-15 22:12:30'),
 (89,4,2,1735,'0.99','2005-06-16 15:51:52','2006-02-15 22:12:30'),
 (90,4,2,2043,'0.99','2005-06-17 14:31:12','2006-02-15 22:12:30'),
 (91,4,1,2642,'5.99','2005-06-19 09:39:01','2006-02-15 22:12:30'),
 (92,4,1,7660,'2.99','2005-07-28 02:10:10','2006-02-15 22:12:30'),
 (93,4,2,7718,'2.99','2005-07-28 04:37:59','2006-02-15 22:12:30'),
 (94,4,1,8741,'3.99','2005-07-29 18:44:57','2006-02-15 22:12:30'),
 (95,4,1,9100,'5.99','2005-07-30 08:46:09','2006-02-15 22:12:30'),
 (96,4,1,9371,'5.99','2005-07-30 18:58:00','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (97,4,2,11069,'0.99','2005-08-02 07:09:34','2006-02-15 22:12:30'),
 (98,4,1,11110,'2.99','2005-08-02 08:20:31','2006-02-15 22:12:30'),
 (99,4,2,11529,'4.99','2005-08-17 00:28:01','2006-02-15 22:12:30'),
 (100,4,1,12151,'2.99','2005-08-18 00:14:03','2006-02-15 22:12:30'),
 (101,4,2,12294,'8.99','2005-08-18 05:14:44','2006-02-15 22:12:30'),
 (102,4,2,12856,'1.99','2005-08-19 02:19:13','2006-02-15 22:12:30'),
 (103,4,1,13704,'2.99','2005-08-20 09:32:04','2006-02-15 22:12:30'),
 (104,4,1,13807,'6.99','2005-08-20 12:55:40','2006-02-15 22:12:30'),
 (105,4,2,14225,'4.99','2005-08-21 04:53:37','2006-02-15 22:12:30'),
 (106,4,1,15147,'2.99','2005-08-22 13:58:23','2006-02-15 22:12:30'),
 (107,4,2,15635,'1.99','2005-08-23 07:43:00','2006-02-15 22:12:30'),
 (108,5,1,731,'0.99','2005-05-29 07:25:16','2006-02-15 22:12:30'),
 (109,5,1,1085,'6.99','2005-05-31 11:15:43','2006-02-15 22:12:30'),
 (110,5,1,1142,'1.99','2005-05-31 19:46:38','2006-02-15 22:12:30'),
 (111,5,1,1502,'3.99','2005-06-15 22:03:14','2006-02-15 22:12:30'),
 (112,5,2,1631,'2.99','2005-06-16 08:01:02','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (113,5,2,2063,'4.99','2005-06-17 15:56:53','2006-02-15 22:12:30'),
 (114,5,2,2570,'2.99','2005-06-19 04:20:13','2006-02-15 22:12:30'),
 (115,5,2,3126,'4.99','2005-06-20 18:38:22','2006-02-15 22:12:30'),
 (116,5,2,3677,'4.99','2005-07-06 09:11:58','2006-02-15 22:12:30'),
 (117,5,2,4889,'2.99','2005-07-08 20:04:43','2006-02-15 22:12:30'),
 (118,5,1,5016,'4.99','2005-07-09 01:57:57','2006-02-15 22:12:30'),
 (119,5,2,5118,'5.99','2005-07-09 07:13:52','2006-02-15 22:12:30'),
 (120,5,2,5156,'1.99','2005-07-09 08:51:42','2006-02-15 22:12:30'),
 (121,5,2,5721,'0.99','2005-07-10 11:09:35','2006-02-15 22:12:30'),
 (122,5,1,6042,'8.99','2005-07-11 03:17:04','2006-02-15 22:12:30'),
 (123,5,1,6663,'3.99','2005-07-12 11:27:35','2006-02-15 22:12:30'),
 (124,5,2,6685,'4.99','2005-07-12 12:16:28','2006-02-15 22:12:30'),
 (125,5,2,7293,'0.99','2005-07-27 12:37:28','2006-02-15 22:12:30'),
 (126,5,2,7652,'0.99','2005-07-28 01:50:29','2006-02-15 22:12:30'),
 (127,5,2,7829,'3.99','2005-07-28 08:43:39','2006-02-15 22:12:30'),
 (128,5,1,8263,'2.99','2005-07-29 01:11:23','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (129,5,1,8978,'1.99','2005-07-30 04:14:28','2006-02-15 22:12:30'),
 (130,5,1,9493,'4.99','2005-07-30 23:52:30','2006-02-15 22:12:30'),
 (131,5,1,9888,'3.99','2005-07-31 14:00:53','2006-02-15 22:12:30'),
 (132,5,2,10609,'4.99','2005-08-01 14:48:45','2006-02-15 22:12:30'),
 (133,5,1,10625,'0.99','2005-08-01 15:27:10','2006-02-15 22:12:30'),
 (134,5,2,11001,'4.99','2005-08-02 04:56:45','2006-02-15 22:12:30'),
 (135,5,1,11179,'4.99','2005-08-02 10:50:06','2006-02-15 22:12:30'),
 (136,5,2,11930,'3.99','2005-08-17 16:28:53','2006-02-15 22:12:30'),
 (137,5,1,12145,'9.99','2005-08-18 00:10:04','2006-02-15 22:12:30'),
 (138,5,1,12797,'2.99','2005-08-19 00:24:08','2006-02-15 22:12:30'),
 (139,5,1,13063,'1.99','2005-08-19 09:45:41','2006-02-15 22:12:30'),
 (140,5,2,13877,'0.99','2005-08-20 15:16:18','2006-02-15 22:12:30'),
 (141,5,2,14053,'6.99','2005-08-20 22:13:59','2006-02-15 22:12:30'),
 (142,5,1,14430,'6.99','2005-08-21 11:31:11','2006-02-15 22:12:30'),
 (143,5,2,14494,'2.99','2005-08-21 14:02:50','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (144,5,2,15232,'0.99','2005-08-22 17:37:02','2006-02-15 22:12:30'),
 (145,5,2,13209,'0.99','2006-02-14 15:16:03','2006-02-15 22:12:30'),
 (146,6,2,57,'4.99','2005-05-25 08:43:32','2006-02-15 22:12:30'),
 (147,6,1,577,'2.99','2005-05-28 11:09:14','2006-02-15 22:12:30'),
 (148,6,2,916,'0.99','2005-05-30 11:25:01','2006-02-15 22:12:30'),
 (149,6,1,1575,'3.99','2005-06-16 03:41:38','2006-02-15 22:12:30'),
 (150,6,2,1841,'2.99','2005-06-16 23:44:13','2006-02-15 22:12:30'),
 (151,6,1,1966,'0.99','2005-06-17 09:19:45','2006-02-15 22:12:30'),
 (152,6,1,2345,'0.99','2005-06-18 12:03:23','2006-02-15 22:12:30'),
 (153,6,2,3983,'0.99','2005-07-06 23:14:21','2006-02-15 22:12:30'),
 (154,6,2,4278,'2.99','2005-07-07 14:53:24','2006-02-15 22:12:30'),
 (155,6,1,5553,'0.99','2005-07-10 03:03:35','2006-02-15 22:12:30'),
 (156,6,2,6211,'5.99','2005-07-11 12:39:01','2006-02-15 22:12:30'),
 (157,6,1,6248,'7.99','2005-07-11 15:01:54','2006-02-15 22:12:30'),
 (158,6,2,6686,'0.99','2005-07-12 12:18:38','2006-02-15 22:12:30'),
 (159,6,2,7099,'2.99','2005-07-27 05:03:44','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (160,6,2,7136,'2.99','2005-07-27 06:38:25','2006-02-15 22:12:30'),
 (161,6,1,8101,'0.99','2005-07-28 18:47:23','2006-02-15 22:12:30'),
 (162,6,1,10271,'2.99','2005-08-01 03:13:39','2006-02-15 22:12:30'),
 (163,6,1,11023,'2.99','2005-08-02 05:36:38','2006-02-15 22:12:30'),
 (164,6,1,11398,'3.99','2005-08-02 18:55:15','2006-02-15 22:12:30'),
 (165,6,1,11591,'6.99','2005-08-17 02:29:41','2006-02-15 22:12:30'),
 (166,6,1,11727,'0.99','2005-08-17 08:12:20','2006-02-15 22:12:30'),
 (167,6,1,11853,'0.99','2005-08-17 13:39:32','2006-02-15 22:12:30'),
 (168,6,2,12254,'2.99','2005-08-18 04:05:29','2006-02-15 22:12:30'),
 (169,6,2,13451,'6.99','2005-08-20 00:18:25','2006-02-15 22:12:30'),
 (170,6,1,14329,'7.99','2005-08-21 08:22:56','2006-02-15 22:12:30'),
 (171,6,1,14377,'4.99','2005-08-21 09:49:28','2006-02-15 22:12:30'),
 (172,6,1,15509,'5.99','2005-08-23 02:51:24','2006-02-15 22:12:30'),
 (173,6,2,15603,'0.99','2005-08-23 06:41:32','2006-02-15 22:12:30'),
 (174,7,2,46,'5.99','2005-05-25 06:04:08','2006-02-15 22:12:30');
INSERT INTO `sakila`.`payment` VALUES  (175,7,2,117,'0.99','2005-05-25 19:30:46','2006-02-15 22:12:30'),
 (176,7,2,748,'2.99','2005-05-29 09:27:00','2006-02-15 22:12:30'),
 (177,7,1,975,'4.99','2005-05-30 21:07:15','2006-02-15 22:12:30'),
 (178,7,1,1063,'5.99','2005-05-31 08:44:29','2006-02-15 22:12:30'),
 (179,7,2,1810,'0.99','2005-06-16 21:06:00','2006-02-15 22:12:30'),
 (180,7,1,2250,'2.99','2005-06-18 05:03:36','2006-02-15 22:12:31'),
 (181,7,1,2709,'0.99','2005-06-19 14:00:26','2006-02-15 22:12:31'),
 (182,7,1,2888,'4.99','2005-06-20 01:50:56','2006-02-15 22:12:31'),
 (183,7,1,3007,'0.99','2005-06-20 10:11:53','2006-02-15 22:12:31'),
 (184,7,2,3639,'5.99','2005-07-06 07:09:17','2006-02-15 22:12:31'),
 (185,7,2,4238,'2.99','2005-07-07 13:22:20','2006-02-15 22:12:31'),
 (186,7,2,4787,'5.99','2005-07-08 16:16:04','2006-02-15 22:12:31'),
 (187,7,1,4856,'4.99','2005-07-08 18:47:38','2006-02-15 22:12:31'),
 (188,7,1,5441,'8.99','2005-07-09 21:52:05','2006-02-15 22:12:31'),
 (189,7,1,5921,'7.99','2005-07-10 21:35:12','2006-02-15 22:12:31'),
 (190,7,1,6174,'1.99','2005-07-11 10:36:28','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (191,7,1,6295,'2.99','2005-07-11 17:30:58','2006-02-15 22:12:31'),
 (192,7,2,6761,'3.99','2005-07-12 15:17:42','2006-02-15 22:12:31'),
 (193,7,2,8422,'5.99','2005-07-29 07:02:55','2006-02-15 22:12:31'),
 (194,7,2,9624,'7.99','2005-07-31 04:30:03','2006-02-15 22:12:31'),
 (195,7,2,10330,'6.99','2005-08-01 04:57:04','2006-02-15 22:12:31'),
 (196,7,1,10423,'5.99','2005-08-01 08:19:53','2006-02-15 22:12:31'),
 (197,7,1,10514,'4.99','2005-08-01 11:39:26','2006-02-15 22:12:31'),
 (198,7,2,10644,'4.99','2005-08-01 15:52:00','2006-02-15 22:12:31'),
 (199,7,2,10989,'3.99','2005-08-02 04:40:54','2006-02-15 22:12:31'),
 (200,7,2,11542,'7.99','2005-08-17 00:51:32','2006-02-15 22:12:31'),
 (201,7,1,12367,'8.99','2005-08-18 07:57:14','2006-02-15 22:12:31'),
 (202,7,1,12730,'2.99','2005-08-18 21:55:01','2006-02-15 22:12:31'),
 (203,7,2,13373,'2.99','2005-08-19 21:23:31','2006-02-15 22:12:31'),
 (204,7,1,13476,'2.99','2005-08-20 01:06:04','2006-02-15 22:12:31'),
 (205,7,1,13594,'0.99','2005-08-20 05:53:31','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (206,7,1,14222,'5.99','2005-08-21 04:49:48','2006-02-15 22:12:31'),
 (207,8,2,866,'6.99','2005-05-30 03:43:54','2006-02-15 22:12:31'),
 (208,8,2,1305,'2.99','2005-06-15 09:59:16','2006-02-15 22:12:31'),
 (209,8,1,2095,'5.99','2005-06-17 18:21:35','2006-02-15 22:12:31'),
 (210,8,2,3114,'4.99','2005-06-20 17:57:47','2006-02-15 22:12:31'),
 (211,8,1,3475,'5.99','2005-07-05 23:01:21','2006-02-15 22:12:31'),
 (212,8,1,4003,'0.99','2005-07-07 00:09:02','2006-02-15 22:12:31'),
 (213,8,2,4175,'2.99','2005-07-07 10:02:03','2006-02-15 22:12:31'),
 (214,8,2,4409,'3.99','2005-07-07 21:47:29','2006-02-15 22:12:31'),
 (215,8,1,4503,'3.99','2005-07-08 02:17:12','2006-02-15 22:12:31'),
 (216,8,1,5300,'2.99','2005-07-09 15:40:46','2006-02-15 22:12:31'),
 (217,8,2,5341,'2.99','2005-07-09 17:13:23','2006-02-15 22:12:31'),
 (218,8,1,6375,'4.99','2005-07-11 21:39:46','2006-02-15 22:12:31'),
 (219,8,1,6647,'0.99','2005-07-12 10:43:53','2006-02-15 22:12:31'),
 (220,8,1,8809,'1.99','2005-07-29 21:42:49','2006-02-15 22:12:31'),
 (221,8,2,9629,'2.99','2005-07-31 04:54:43','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (222,8,2,10141,'0.99','2005-07-31 22:08:29','2006-02-15 22:12:31'),
 (223,8,2,10561,'2.99','2005-08-01 13:05:35','2006-02-15 22:12:31'),
 (224,8,1,11232,'9.99','2005-08-02 13:04:12','2006-02-15 22:12:31'),
 (225,8,2,11284,'2.99','2005-08-02 14:42:45','2006-02-15 22:12:31'),
 (226,8,1,12613,'2.99','2005-08-18 17:16:01','2006-02-15 22:12:31'),
 (227,8,1,14114,'0.99','2005-08-21 01:07:11','2006-02-15 22:12:31'),
 (228,8,1,15374,'7.99','2005-08-22 22:09:09','2006-02-15 22:12:31'),
 (229,8,1,15764,'2.99','2005-08-23 13:05:10','2006-02-15 22:12:31'),
 (230,8,1,15805,'4.99','2005-08-23 14:31:19','2006-02-15 22:12:31'),
 (231,9,2,350,'4.99','2005-05-27 05:01:28','2006-02-15 22:12:31'),
 (232,9,2,877,'0.99','2005-05-30 05:48:59','2006-02-15 22:12:31'),
 (233,9,2,1075,'4.99','2005-05-31 10:13:34','2006-02-15 22:12:31'),
 (234,9,2,3142,'7.99','2005-06-20 19:59:28','2006-02-15 22:12:31'),
 (235,9,2,3262,'4.99','2005-06-21 04:08:43','2006-02-15 22:12:31'),
 (236,9,1,4454,'2.99','2005-07-07 23:37:00','2006-02-15 22:12:31'),
 (237,9,2,4748,'0.99','2005-07-08 13:59:38','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (238,9,1,4796,'1.99','2005-07-08 16:35:44','2006-02-15 22:12:31'),
 (239,9,1,5659,'2.99','2005-07-10 07:45:40','2006-02-15 22:12:31'),
 (240,9,2,6019,'4.99','2005-07-11 02:08:29','2006-02-15 22:12:31'),
 (241,9,1,6165,'5.99','2005-07-11 10:17:29','2006-02-15 22:12:31'),
 (242,9,2,7616,'0.99','2005-07-28 00:15:26','2006-02-15 22:12:31'),
 (243,9,1,7801,'2.99','2005-07-28 07:51:56','2006-02-15 22:12:31'),
 (244,9,1,9043,'4.99','2005-07-30 06:34:07','2006-02-15 22:12:31'),
 (245,9,1,10451,'0.99','2005-08-01 09:11:25','2006-02-15 22:12:31'),
 (246,9,1,10454,'4.99','2005-08-01 09:14:00','2006-02-15 22:12:31'),
 (247,9,2,11400,'5.99','2005-08-02 19:00:52','2006-02-15 22:12:31'),
 (248,9,1,11556,'0.99','2005-08-17 01:11:53','2006-02-15 22:12:31'),
 (249,9,1,12228,'2.99','2005-08-18 03:08:10','2006-02-15 22:12:31'),
 (250,9,1,12309,'2.99','2005-08-18 05:58:40','2006-02-15 22:12:31'),
 (251,9,2,12652,'4.99','2005-08-18 18:48:58','2006-02-15 22:12:31'),
 (252,9,2,14489,'7.99','2005-08-21 13:53:59','2006-02-15 22:12:31'),
 (253,9,1,15813,'4.99','2006-02-14 15:16:03','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (254,10,2,1140,'4.99','2005-05-31 19:36:30','2006-02-15 22:12:31'),
 (255,10,1,1801,'4.99','2005-06-16 20:21:53','2006-02-15 22:12:31'),
 (256,10,1,1995,'4.99','2005-06-17 11:11:14','2006-02-15 22:12:31'),
 (257,10,2,2222,'3.99','2005-06-18 03:26:23','2006-02-15 22:12:31'),
 (258,10,1,2814,'0.99','2005-06-19 20:01:59','2006-02-15 22:12:31'),
 (259,10,1,2865,'0.99','2005-06-20 00:00:55','2006-02-15 22:12:31'),
 (260,10,2,3790,'3.99','2005-07-06 14:13:45','2006-02-15 22:12:31'),
 (261,10,2,4042,'4.99','2005-07-07 03:06:40','2006-02-15 22:12:31'),
 (262,10,1,4255,'1.99','2005-07-07 14:14:13','2006-02-15 22:12:31'),
 (263,10,1,5038,'7.99','2005-07-09 03:12:52','2006-02-15 22:12:31'),
 (264,10,2,5068,'2.99','2005-07-09 04:53:18','2006-02-15 22:12:31'),
 (265,10,1,5444,'0.99','2005-07-09 21:58:57','2006-02-15 22:12:31'),
 (266,10,1,5905,'2.99','2005-07-10 20:41:09','2006-02-15 22:12:31'),
 (267,10,1,7738,'2.99','2005-07-28 05:21:42','2006-02-15 22:12:31'),
 (268,10,2,8001,'6.99','2005-07-28 15:10:55','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (269,10,2,8188,'4.99','2005-07-28 22:34:12','2006-02-15 22:12:31'),
 (270,10,1,9935,'4.99','2005-07-31 15:27:07','2006-02-15 22:12:31'),
 (271,10,2,10671,'8.99','2005-08-01 17:09:59','2006-02-15 22:12:31'),
 (272,10,2,11289,'2.99','2005-08-02 14:55:00','2006-02-15 22:12:31'),
 (273,10,1,11405,'0.99','2005-08-02 19:13:39','2006-02-15 22:12:31'),
 (274,10,2,12031,'2.99','2005-08-17 20:11:35','2006-02-15 22:12:31'),
 (275,10,2,12400,'2.99','2005-08-18 09:19:12','2006-02-15 22:12:31'),
 (276,10,2,13316,'4.99','2005-08-19 19:23:30','2006-02-15 22:12:31'),
 (277,10,2,13917,'2.99','2005-08-20 16:43:28','2006-02-15 22:12:31'),
 (278,10,1,15370,'5.99','2005-08-22 21:59:29','2006-02-15 22:12:31'),
 (279,11,1,987,'6.99','2005-05-30 22:59:12','2006-02-15 22:12:31'),
 (280,11,1,1470,'6.99','2005-06-15 20:53:07','2006-02-15 22:12:31'),
 (281,11,1,1939,'7.99','2005-06-17 07:26:45','2006-02-15 22:12:31'),
 (282,11,1,3192,'0.99','2005-06-20 23:49:12','2006-02-15 22:12:31'),
 (283,11,2,4608,'2.99','2005-07-08 07:19:11','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (284,11,1,4943,'4.99','2005-07-08 22:43:05','2006-02-15 22:12:31'),
 (285,11,2,5835,'5.99','2005-07-10 16:44:58','2006-02-15 22:12:31'),
 (286,11,2,6146,'6.99','2005-07-11 09:09:59','2006-02-15 22:12:31'),
 (287,11,1,7314,'4.99','2005-07-27 13:13:32','2006-02-15 22:12:31'),
 (288,11,1,8014,'4.99','2005-07-28 15:32:07','2006-02-15 22:12:31'),
 (289,11,2,8100,'2.99','2005-07-28 18:43:11','2006-02-15 22:12:31'),
 (290,11,2,8447,'1.99','2005-07-29 07:38:14','2006-02-15 22:12:31'),
 (291,11,1,8715,'0.99','2005-07-29 17:33:45','2006-02-15 22:12:31'),
 (292,11,1,8950,'9.99','2005-07-30 03:17:13','2006-02-15 22:12:31'),
 (293,11,2,9292,'6.99','2005-07-30 16:08:21','2006-02-15 22:12:31'),
 (294,11,1,10812,'4.99','2005-08-01 22:41:16','2006-02-15 22:12:31'),
 (295,11,2,11166,'6.99','2005-08-02 10:14:58','2006-02-15 22:12:31'),
 (296,11,2,11502,'0.99','2005-08-16 23:06:30','2006-02-15 22:12:31'),
 (297,11,2,12015,'5.99','2005-08-17 19:32:44','2006-02-15 22:12:31'),
 (298,11,2,13572,'0.99','2005-08-20 05:07:27','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (299,11,1,13790,'4.99','2005-08-20 12:17:27','2006-02-15 22:12:31'),
 (300,11,1,15120,'0.99','2005-08-22 12:42:47','2006-02-15 22:12:31'),
 (301,11,2,15240,'2.99','2005-08-22 17:46:41','2006-02-15 22:12:31'),
 (302,11,1,11646,'0.99','2006-02-14 15:16:03','2006-02-15 22:12:31'),
 (303,12,1,988,'4.99','2005-05-30 23:08:03','2006-02-15 22:12:31'),
 (304,12,1,1084,'4.99','2005-05-31 11:10:17','2006-02-15 22:12:31'),
 (305,12,2,1752,'5.99','2005-06-16 17:02:55','2006-02-15 22:12:31'),
 (306,12,2,2434,'5.99','2005-06-18 18:11:51','2006-02-15 22:12:31'),
 (307,12,2,2500,'5.99','2005-06-18 23:07:12','2006-02-15 22:12:31'),
 (308,12,2,2623,'4.99','2005-06-19 08:11:51','2006-02-15 22:12:31'),
 (309,12,2,3135,'2.99','2005-06-20 19:33:52','2006-02-15 22:12:31'),
 (310,12,1,3411,'0.99','2005-06-21 16:31:27','2006-02-15 22:12:31'),
 (311,12,1,3870,'3.99','2005-07-06 17:57:54','2006-02-15 22:12:31'),
 (312,12,1,5071,'0.99','2005-07-09 05:00:39','2006-02-15 22:12:31'),
 (313,12,1,5074,'0.99','2005-07-09 05:06:24','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (314,12,2,5111,'0.99','2005-07-09 07:02:19','2006-02-15 22:12:31'),
 (315,12,2,5242,'3.99','2005-07-09 13:20:25','2006-02-15 22:12:31'),
 (316,12,1,6773,'2.99','2005-07-12 15:55:39','2006-02-15 22:12:31'),
 (317,12,2,7008,'0.99','2005-07-27 01:44:03','2006-02-15 22:12:31'),
 (318,12,2,7279,'0.99','2005-07-27 11:50:47','2006-02-15 22:12:31'),
 (319,12,2,8985,'0.99','2005-07-30 04:34:51','2006-02-15 22:12:31'),
 (320,12,2,9166,'4.99','2005-07-30 11:26:28','2006-02-15 22:12:31'),
 (321,12,2,9238,'5.99','2005-07-30 13:49:43','2006-02-15 22:12:31'),
 (322,12,1,9627,'5.99','2005-07-31 04:42:46','2006-02-15 22:12:31'),
 (323,12,2,9708,'5.99','2005-07-31 07:45:33','2006-02-15 22:12:31'),
 (324,12,2,10392,'10.99','2005-08-01 06:50:26','2006-02-15 22:12:31'),
 (325,12,2,11497,'0.99','2005-08-16 22:52:30','2006-02-15 22:12:31'),
 (326,12,1,12604,'4.99','2005-08-18 16:58:48','2006-02-15 22:12:31'),
 (327,12,2,13519,'0.99','2005-08-20 02:37:07','2006-02-15 22:12:31'),
 (328,12,2,13895,'2.99','2005-08-20 15:58:28','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (329,12,2,14240,'4.99','2005-08-21 05:19:39','2006-02-15 22:12:31'),
 (330,12,1,15993,'0.99','2005-08-23 20:28:44','2006-02-15 22:12:31'),
 (331,13,1,1933,'2.99','2005-06-17 06:54:42','2006-02-15 22:12:31'),
 (332,13,1,2209,'4.99','2005-06-18 02:24:01','2006-02-15 22:12:31'),
 (333,13,1,2952,'2.99','2005-06-20 06:26:57','2006-02-15 22:12:31'),
 (334,13,1,3047,'8.99','2005-06-20 12:45:33','2006-02-15 22:12:31'),
 (335,13,2,3946,'2.99','2005-07-06 21:39:24','2006-02-15 22:12:31'),
 (336,13,1,6118,'8.99','2005-07-11 07:43:08','2006-02-15 22:12:31'),
 (337,13,1,6568,'2.99','2005-07-12 05:45:47','2006-02-15 22:12:31'),
 (338,13,1,6870,'0.99','2005-07-12 20:13:45','2006-02-15 22:12:31'),
 (339,13,1,6897,'2.99','2005-07-12 21:30:41','2006-02-15 22:12:31'),
 (340,13,1,7916,'2.99','2005-07-28 11:49:53','2006-02-15 22:12:31'),
 (341,13,1,8277,'2.99','2005-07-29 01:38:53','2006-02-15 22:12:31'),
 (342,13,2,8831,'11.99','2005-07-29 22:37:41','2006-02-15 22:12:31'),
 (343,13,2,9260,'9.99','2005-07-30 14:38:22','2006-02-15 22:12:31');
INSERT INTO `sakila`.`payment` VALUES  (344,13,2,9434,'0.99','2005-07-30 21:29:41','2006-02-15 22:12:32'),
 (345,13,1,9664,'0.99','2005-07-31 06:12:08','2006-02-15 22:12:32'),
 (346,13,1,9736,'7.99','2005-07-31 08:58:40','2006-02-15 22:12:32'),
 (347,13,1,10003,'4.99','2005-07-31 17:48:51','2006-02-15 22:12:32'),
 (348,13,1,11292,'4.99','2005-08-02 14:58:41','2006-02-15 22:12:32'),
 (349,13,2,11315,'0.99','2005-08-02 16:05:17','2006-02-15 22:12:32'),
 (350,13,2,11761,'5.99','2005-08-17 09:44:59','2006-02-15 22:12:32'),
 (351,13,2,12918,'7.99','2005-08-19 04:31:36','2006-02-15 22:12:32'),
 (352,13,2,13096,'4.99','2005-08-19 10:49:03','2006-02-15 22:12:32'),
 (353,13,2,13213,'0.99','2005-08-19 15:25:48','2006-02-15 22:12:32'),
 (354,13,1,13456,'0.99','2005-08-20 00:33:19','2006-02-15 22:12:32'),
 (355,13,1,14252,'9.99','2005-08-21 05:44:07','2006-02-15 22:12:32'),
 (356,13,2,14545,'7.99','2005-08-21 15:44:23','2006-02-15 22:12:32'),
 (357,13,1,15338,'4.99','2005-08-22 20:51:24','2006-02-15 22:12:32'),
 (358,14,1,151,'0.99','2005-05-26 00:37:28','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (359,14,1,346,'9.99','2005-05-27 04:34:41','2006-02-15 22:12:32'),
 (360,14,1,525,'5.99','2005-05-28 04:25:33','2006-02-15 22:12:32'),
 (361,14,1,671,'2.99','2005-05-28 22:04:30','2006-02-15 22:12:32'),
 (362,14,2,815,'0.99','2005-05-29 20:24:28','2006-02-15 22:12:32'),
 (363,14,2,1360,'4.99','2005-06-15 13:32:15','2006-02-15 22:12:32'),
 (364,14,1,3707,'2.99','2005-07-06 10:21:49','2006-02-15 22:12:32'),
 (365,14,1,4952,'0.99','2005-07-08 23:00:07','2006-02-15 22:12:32'),
 (366,14,1,5104,'0.99','2005-07-09 06:37:07','2006-02-15 22:12:32'),
 (367,14,2,5317,'7.99','2005-07-09 16:10:25','2006-02-15 22:12:32'),
 (368,14,1,5383,'4.99','2005-07-09 19:14:32','2006-02-15 22:12:32'),
 (369,14,1,5565,'7.99','2005-07-10 03:29:48','2006-02-15 22:12:32'),
 (370,14,1,8035,'6.99','2005-07-28 16:23:01','2006-02-15 22:12:32'),
 (371,14,1,8042,'0.99','2005-07-28 16:45:11','2006-02-15 22:12:32'),
 (372,14,1,8548,'3.99','2005-07-29 11:11:33','2006-02-15 22:12:32'),
 (373,14,2,8836,'4.99','2005-07-29 22:46:08','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (374,14,2,9438,'4.99','2005-07-30 21:36:15','2006-02-15 22:12:32'),
 (375,14,1,9592,'2.99','2005-07-31 03:21:16','2006-02-15 22:12:32'),
 (376,14,1,10348,'2.99','2005-08-01 05:23:00','2006-02-15 22:12:32'),
 (377,14,2,10526,'6.99','2005-08-01 11:55:33','2006-02-15 22:12:32'),
 (378,14,1,11480,'4.99','2005-08-02 22:18:24','2006-02-15 22:12:32'),
 (379,14,2,11528,'3.99','2005-08-17 00:27:23','2006-02-15 22:12:32'),
 (380,14,1,12668,'2.99','2005-08-18 19:16:47','2006-02-15 22:12:32'),
 (381,14,1,13757,'4.99','2005-08-20 11:20:12','2006-02-15 22:12:32'),
 (382,14,2,15015,'6.99','2005-08-22 08:43:50','2006-02-15 22:12:32'),
 (383,14,1,15373,'0.99','2005-08-22 22:08:11','2006-02-15 22:12:32'),
 (384,14,1,16045,'0.99','2005-08-23 22:25:26','2006-02-15 22:12:32'),
 (385,14,1,13780,'4.99','2006-02-14 15:16:03','2006-02-15 22:12:32'),
 (386,15,1,2486,'2.99','2005-06-18 21:26:56','2006-02-15 22:12:32'),
 (387,15,1,2937,'5.99','2005-06-20 05:15:37','2006-02-15 22:12:32'),
 (388,15,2,3182,'0.99','2005-06-20 22:52:18','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (389,15,1,3550,'7.99','2005-07-06 02:29:21','2006-02-15 22:12:32'),
 (390,15,1,4127,'5.99','2005-07-07 07:26:19','2006-02-15 22:12:32'),
 (391,15,1,5717,'2.99','2005-07-10 11:02:03','2006-02-15 22:12:32'),
 (392,15,2,5975,'2.99','2005-07-11 00:14:19','2006-02-15 22:12:32'),
 (393,15,1,7105,'4.99','2005-07-27 05:15:37','2006-02-15 22:12:32'),
 (394,15,1,8193,'0.99','2005-07-28 22:50:50','2006-02-15 22:12:32'),
 (395,15,2,8615,'6.99','2005-07-29 13:36:01','2006-02-15 22:12:32'),
 (396,15,2,8927,'4.99','2005-07-30 02:13:31','2006-02-15 22:12:32'),
 (397,15,1,9987,'2.99','2005-07-31 17:22:35','2006-02-15 22:12:32'),
 (398,15,1,11118,'2.99','2005-08-02 08:44:18','2006-02-15 22:12:32'),
 (399,15,1,11141,'2.99','2005-08-02 09:29:11','2006-02-15 22:12:32'),
 (400,15,2,11307,'2.99','2005-08-02 15:48:08','2006-02-15 22:12:32'),
 (401,15,2,11341,'2.99','2005-08-02 17:09:24','2006-02-15 22:12:32'),
 (402,15,1,11922,'7.99','2005-08-17 16:20:37','2006-02-15 22:12:32'),
 (403,15,2,12272,'2.99','2005-08-18 04:39:10','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (404,15,2,12551,'2.99','2005-08-18 14:46:26','2006-02-15 22:12:32'),
 (405,15,1,12635,'2.99','2005-08-18 18:00:23','2006-02-15 22:12:32'),
 (406,15,2,13339,'8.99','2005-08-19 20:18:36','2006-02-15 22:12:32'),
 (407,15,1,13393,'5.99','2005-08-19 22:03:46','2006-02-15 22:12:32'),
 (408,15,2,13503,'5.99','2005-08-20 02:00:33','2006-02-15 22:12:32'),
 (409,15,1,13541,'4.99','2005-08-20 03:41:41','2006-02-15 22:12:32'),
 (410,15,2,13677,'3.99','2005-08-20 08:34:41','2006-02-15 22:12:32'),
 (411,15,2,14569,'0.99','2005-08-21 16:31:22','2006-02-15 22:12:32'),
 (412,15,2,14776,'4.99','2005-08-21 23:53:35','2006-02-15 22:12:32'),
 (413,15,2,14872,'8.99','2005-08-22 03:23:41','2006-02-15 22:12:32'),
 (414,15,1,15178,'0.99','2005-08-22 15:36:04','2006-02-15 22:12:32'),
 (415,15,1,15897,'4.99','2005-08-23 17:12:31','2006-02-15 22:12:32'),
 (416,15,1,13798,'3.98','2006-02-14 15:16:03','2006-02-15 22:12:32'),
 (417,15,2,13968,'0.00','2006-02-14 15:16:03','2006-02-15 22:12:32'),
 (418,16,1,335,'3.99','2005-05-27 03:07:10','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (419,16,1,593,'2.99','2005-05-28 13:33:23','2006-02-15 22:12:32'),
 (420,16,2,887,'0.99','2005-05-30 07:10:00','2006-02-15 22:12:32'),
 (421,16,1,1017,'2.99','2005-05-31 02:53:36','2006-02-15 22:12:32'),
 (422,16,2,1934,'6.99','2005-06-17 07:04:57','2006-02-15 22:12:32'),
 (423,16,1,1944,'7.99','2005-06-17 07:50:53','2006-02-15 22:12:32'),
 (424,16,1,NULL,'1.99','2005-06-18 04:56:12','2006-02-15 22:12:32'),
 (425,16,1,2960,'7.99','2005-06-20 07:10:09','2006-02-15 22:12:32'),
 (426,16,2,3348,'0.99','2005-06-21 11:16:42','2006-02-15 22:12:32'),
 (427,16,1,3548,'0.99','2005-07-06 02:23:39','2006-02-15 22:12:32'),
 (428,16,2,4219,'2.99','2005-07-07 12:11:22','2006-02-15 22:12:32'),
 (429,16,2,4263,'3.99','2005-07-07 14:24:44','2006-02-15 22:12:32'),
 (430,16,2,4517,'4.99','2005-07-08 02:45:19','2006-02-15 22:12:32'),
 (431,16,1,6100,'4.99','2005-07-11 06:40:31','2006-02-15 22:12:32'),
 (432,16,2,7489,'0.99','2005-07-27 19:39:38','2006-02-15 22:12:32'),
 (433,16,2,7552,'2.99','2005-07-27 22:03:41','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (434,16,2,8452,'5.99','2005-07-29 07:45:00','2006-02-15 22:12:32'),
 (435,16,2,9158,'0.99','2005-07-30 11:12:03','2006-02-15 22:12:32'),
 (436,16,2,9610,'5.99','2005-07-31 03:54:05','2006-02-15 22:12:32'),
 (437,16,2,10687,'2.99','2005-08-01 17:53:02','2006-02-15 22:12:32'),
 (438,16,2,10727,'2.99','2005-08-01 19:15:08','2006-02-15 22:12:32'),
 (439,16,2,11308,'0.99','2005-08-02 15:50:44','2006-02-15 22:12:32'),
 (440,16,2,12104,'2.99','2005-08-17 22:53:00','2006-02-15 22:12:32'),
 (441,16,1,12358,'4.99','2005-08-18 07:41:43','2006-02-15 22:12:32'),
 (442,16,1,12577,'7.99','2005-08-18 15:39:46','2006-02-15 22:12:32'),
 (443,16,2,13151,'4.99','2005-08-19 13:08:23','2006-02-15 22:12:32'),
 (444,16,1,13391,'4.99','2005-08-19 22:01:42','2006-02-15 22:12:32'),
 (445,16,1,13480,'6.99','2005-08-20 01:10:27','2006-02-15 22:12:32'),
 (446,16,1,14511,'8.99','2005-08-21 14:45:34','2006-02-15 22:12:32'),
 (447,17,2,287,'2.99','2005-05-26 19:44:54','2006-02-15 22:12:32'),
 (448,17,1,580,'2.99','2005-05-28 11:19:53','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (449,17,2,884,'4.99','2005-05-30 06:41:32','2006-02-15 22:12:32'),
 (450,17,2,2175,'5.99','2005-06-18 00:17:58','2006-02-15 22:12:32'),
 (451,17,1,2684,'8.99','2005-06-19 12:29:08','2006-02-15 22:12:32'),
 (452,17,2,3269,'5.99','2005-06-21 05:06:30','2006-02-15 22:12:32'),
 (453,17,1,5714,'3.99','2005-07-10 10:46:57','2006-02-15 22:12:32'),
 (454,17,1,5883,'3.99','2005-07-10 19:25:21','2006-02-15 22:12:32'),
 (455,17,2,6884,'1.99','2005-07-12 20:52:41','2006-02-15 22:12:32'),
 (456,17,2,8076,'8.99','2005-07-28 17:45:58','2006-02-15 22:12:32'),
 (457,17,1,8213,'2.99','2005-07-28 23:37:33','2006-02-15 22:12:32'),
 (458,17,2,9092,'8.99','2005-07-30 08:30:56','2006-02-15 22:12:32'),
 (459,17,1,9138,'2.99','2005-07-30 10:11:52','2006-02-15 22:12:32'),
 (460,17,2,9382,'8.99','2005-07-30 19:23:44','2006-02-15 22:12:32'),
 (461,17,1,9489,'0.99','2005-07-30 23:43:32','2006-02-15 22:12:32'),
 (462,17,2,11990,'4.99','2005-08-17 18:26:22','2006-02-15 22:12:32'),
 (463,17,1,13732,'2.99','2005-08-20 10:24:41','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (464,17,1,14040,'2.99','2005-08-20 21:43:44','2006-02-15 22:12:32'),
 (465,17,2,14326,'2.99','2005-08-21 08:15:41','2006-02-15 22:12:32'),
 (466,17,1,14346,'2.99','2005-08-21 08:42:26','2006-02-15 22:12:32'),
 (467,17,2,15752,'5.99','2005-08-23 12:41:38','2006-02-15 22:12:32'),
 (468,18,1,50,'2.99','2005-05-25 06:44:53','2006-02-15 22:12:32'),
 (469,18,1,116,'4.99','2005-05-25 19:27:51','2006-02-15 22:12:32'),
 (470,18,1,692,'4.99','2005-05-29 01:32:10','2006-02-15 22:12:32'),
 (471,18,2,1451,'5.99','2005-06-15 19:30:18','2006-02-15 22:12:32'),
 (472,18,2,1783,'4.99','2005-06-16 19:23:23','2006-02-15 22:12:32'),
 (473,18,2,2112,'5.99','2005-06-17 19:52:42','2006-02-15 22:12:32'),
 (474,18,1,2990,'8.99','2005-06-20 09:02:51','2006-02-15 22:12:32'),
 (475,18,2,4672,'3.99','2005-07-08 10:15:38','2006-02-15 22:12:32'),
 (476,18,2,4724,'3.99','2005-07-08 12:46:30','2006-02-15 22:12:32'),
 (477,18,2,4923,'3.99','2005-07-08 21:44:39','2006-02-15 22:12:32'),
 (478,18,2,6128,'2.99','2005-07-11 08:15:08','2006-02-15 22:12:32');
INSERT INTO `sakila`.`payment` VALUES  (479,18,1,6846,'0.99','2005-07-12 19:20:45','2006-02-15 22:12:32'),
 (480,18,2,8122,'2.99','2005-07-28 19:27:37','2006-02-15 22:12:32'),
 (481,18,1,8555,'4.99','2005-07-29 11:18:01','2006-02-15 22:12:32'),
 (482,18,1,9036,'4.99','2005-07-30 06:18:38','2006-02-15 22:12:32'),
 (483,18,2,9114,'4.99','2005-07-30 09:13:21','2006-02-15 22:12:32'),
 (484,18,1,10682,'4.99','2005-08-01 17:32:53','2006-02-15 22:12:32'),
 (485,18,2,10721,'1.99','2005-08-01 19:05:18','2006-02-15 22:12:32'),
 (486,18,2,11094,'4.99','2005-08-02 08:03:02','2006-02-15 22:12:33'),
 (487,18,2,11439,'4.99','2005-08-02 20:22:45','2006-02-15 22:12:33'),
 (488,18,2,12333,'0.99','2005-08-18 06:51:39','2006-02-15 22:12:33'),
 (489,18,2,13490,'0.99','2005-08-20 01:29:29','2006-02-15 22:12:33'),
 (490,19,2,18,'0.99','2005-05-25 01:10:47','2006-02-15 22:12:33'),
 (491,19,2,110,'9.99','2005-05-25 18:43:49','2006-02-15 22:12:33'),
 (492,19,1,179,'6.99','2005-05-26 04:26:06','2006-02-15 22:12:33'),
 (493,19,1,337,'2.99','2005-05-27 03:22:30','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (494,19,2,591,'2.99','2005-05-28 13:11:04','2006-02-15 22:12:33'),
 (495,19,2,696,'2.99','2005-05-29 01:59:10','2006-02-15 22:12:33'),
 (496,19,1,2657,'2.99','2005-06-19 10:42:59','2006-02-15 22:12:33'),
 (497,19,1,2848,'2.99','2005-06-19 22:55:37','2006-02-15 22:12:33'),
 (498,19,2,3423,'2.99','2005-06-21 17:38:02','2006-02-15 22:12:33'),
 (499,19,2,3549,'4.99','2005-07-06 02:24:55','2006-02-15 22:12:33'),
 (500,19,2,6495,'4.99','2005-07-12 02:57:02','2006-02-15 22:12:33'),
 (501,19,1,9157,'5.99','2005-07-30 11:06:23','2006-02-15 22:12:33'),
 (502,19,1,9256,'0.99','2005-07-30 14:29:29','2006-02-15 22:12:33'),
 (503,19,2,10077,'9.99','2005-07-31 20:01:06','2006-02-15 22:12:33'),
 (504,19,1,10176,'7.99','2005-07-31 23:40:35','2006-02-15 22:12:33'),
 (505,19,2,11508,'8.99','2005-08-16 23:27:36','2006-02-15 22:12:33'),
 (506,19,1,11869,'5.99','2005-08-17 14:10:22','2006-02-15 22:12:33'),
 (507,19,1,12211,'9.99','2005-08-18 02:31:18','2006-02-15 22:12:33'),
 (508,19,2,12357,'2.99','2005-08-18 07:40:52','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (509,19,1,13718,'8.99','2005-08-20 09:53:44','2006-02-15 22:12:33'),
 (510,19,2,13804,'8.99','2005-08-20 12:46:32','2006-02-15 22:12:33'),
 (511,19,1,14101,'4.99','2005-08-21 00:33:03','2006-02-15 22:12:33'),
 (512,19,1,15047,'2.99','2005-08-22 09:57:16','2006-02-15 22:12:33'),
 (513,19,2,15529,'0.99','2005-08-23 03:46:47','2006-02-15 22:12:33'),
 (514,20,2,202,'2.99','2005-05-26 07:27:36','2006-02-15 22:12:33'),
 (515,20,2,497,'6.99','2005-05-28 00:54:39','2006-02-15 22:12:33'),
 (516,20,2,546,'1.99','2005-05-28 07:16:25','2006-02-15 22:12:33'),
 (517,20,2,1558,'0.99','2005-06-16 02:33:53','2006-02-15 22:12:33'),
 (518,20,2,2136,'3.99','2005-06-17 21:16:41','2006-02-15 22:12:33'),
 (519,20,2,2343,'4.99','2005-06-18 11:46:26','2006-02-15 22:12:33'),
 (520,20,1,3350,'4.99','2005-06-21 11:21:38','2006-02-15 22:12:33'),
 (521,20,2,4011,'3.99','2005-07-07 00:48:25','2006-02-15 22:12:33'),
 (522,20,1,4407,'2.99','2005-07-07 21:39:45','2006-02-15 22:12:33'),
 (523,20,1,5718,'2.99','2005-07-10 11:03:20','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (524,20,1,6254,'2.99','2005-07-11 15:10:18','2006-02-15 22:12:33'),
 (525,20,2,6267,'6.99','2005-07-11 15:53:00','2006-02-15 22:12:33'),
 (526,20,2,7217,'4.99','2005-07-27 09:31:44','2006-02-15 22:12:33'),
 (527,20,2,7864,'5.99','2005-07-28 10:06:10','2006-02-15 22:12:33'),
 (528,20,2,8127,'2.99','2005-07-28 19:45:19','2006-02-15 22:12:33'),
 (529,20,2,9075,'4.99','2005-07-30 07:55:14','2006-02-15 22:12:33'),
 (530,20,2,9468,'3.99','2005-07-30 22:53:52','2006-02-15 22:12:33'),
 (531,20,2,10284,'4.99','2005-08-01 03:33:19','2006-02-15 22:12:33'),
 (532,20,1,10616,'7.99','2005-08-01 14:59:50','2006-02-15 22:12:33'),
 (533,20,1,10954,'1.99','2005-08-02 03:30:24','2006-02-15 22:12:33'),
 (534,20,1,11821,'0.99','2005-08-17 12:27:55','2006-02-15 22:12:33'),
 (535,20,1,12180,'0.99','2005-08-18 01:28:15','2006-02-15 22:12:33'),
 (536,20,2,13036,'4.99','2005-08-19 08:48:37','2006-02-15 22:12:33'),
 (537,20,1,13137,'4.99','2005-08-19 12:26:32','2006-02-15 22:12:33'),
 (538,20,2,13317,'2.99','2005-08-19 19:25:42','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (539,20,2,14613,'2.99','2005-08-21 18:03:20','2006-02-15 22:12:33'),
 (540,20,2,15057,'6.99','2005-08-22 10:19:58','2006-02-15 22:12:33'),
 (541,20,1,15161,'1.99','2005-08-22 14:37:22','2006-02-15 22:12:33'),
 (542,20,2,15248,'0.99','2005-08-22 17:53:06','2006-02-15 22:12:33'),
 (543,20,1,15460,'2.99','2005-08-23 01:10:42','2006-02-15 22:12:33'),
 (544,21,1,260,'3.99','2005-05-26 15:42:20','2006-02-15 22:12:33'),
 (545,21,2,463,'3.99','2005-05-27 20:11:47','2006-02-15 22:12:33'),
 (546,21,1,570,'0.99','2005-05-28 10:15:04','2006-02-15 22:12:33'),
 (547,21,2,2235,'7.99','2005-06-18 04:08:50','2006-02-15 22:12:33'),
 (548,21,1,2268,'4.99','2005-06-18 06:13:41','2006-02-15 22:12:33'),
 (549,21,1,2393,'2.99','2005-06-18 15:37:55','2006-02-15 22:12:33'),
 (550,21,2,2830,'4.99','2005-06-19 21:14:33','2006-02-15 22:12:33'),
 (551,21,1,3212,'10.99','2005-06-21 01:04:35','2006-02-15 22:12:33'),
 (552,21,2,5107,'4.99','2005-07-09 06:42:32','2006-02-15 22:12:33'),
 (553,21,1,5772,'3.99','2005-07-10 13:27:40','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (554,21,1,5961,'2.99','2005-07-10 23:43:23','2006-02-15 22:12:33'),
 (555,21,2,6943,'1.99','2005-07-26 23:28:13','2006-02-15 22:12:33'),
 (556,21,1,7994,'0.99','2005-07-28 14:56:54','2006-02-15 22:12:33'),
 (557,21,2,8196,'6.99','2005-07-28 22:56:11','2006-02-15 22:12:33'),
 (558,21,2,8862,'2.99','2005-07-29 23:49:23','2006-02-15 22:12:33'),
 (559,21,2,9149,'0.99','2005-07-30 10:45:12','2006-02-15 22:12:33'),
 (560,21,1,9699,'5.99','2005-07-31 07:29:25','2006-02-15 22:12:33'),
 (561,21,2,10570,'4.99','2005-08-01 13:23:06','2006-02-15 22:12:33'),
 (562,21,1,10734,'0.99','2005-08-01 19:28:47','2006-02-15 22:12:33'),
 (563,21,2,11072,'0.99','2005-08-02 07:10:57','2006-02-15 22:12:33'),
 (564,21,2,11970,'0.99','2005-08-17 17:53:09','2006-02-15 22:12:33'),
 (565,21,2,12131,'2.99','2005-08-17 23:34:16','2006-02-15 22:12:33'),
 (566,21,2,12660,'4.99','2005-08-18 19:07:23','2006-02-15 22:12:33'),
 (567,21,1,12774,'6.99','2005-08-18 23:34:22','2006-02-15 22:12:33'),
 (568,21,1,13381,'2.99','2005-08-19 21:37:57','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (569,21,2,13399,'4.99','2005-08-19 22:09:28','2006-02-15 22:12:33'),
 (570,21,1,13411,'4.99','2005-08-19 22:43:38','2006-02-15 22:12:33'),
 (571,21,1,13463,'8.99','2005-08-20 00:50:54','2006-02-15 22:12:33'),
 (572,21,1,13699,'9.99','2005-08-20 09:26:14','2006-02-15 22:12:33'),
 (573,21,1,13740,'4.99','2005-08-20 10:48:43','2006-02-15 22:12:33'),
 (574,21,2,14077,'8.99','2005-08-20 23:24:07','2006-02-15 22:12:33'),
 (575,21,2,14161,'2.99','2005-08-21 02:51:59','2006-02-15 22:12:33'),
 (576,21,2,14446,'2.99','2005-08-21 12:10:41','2006-02-15 22:12:33'),
 (577,21,1,14869,'4.99','2005-08-22 03:20:26','2006-02-15 22:12:33'),
 (578,21,1,14933,'2.99','2006-02-14 15:16:03','2006-02-15 22:12:33'),
 (579,22,1,370,'4.99','2005-05-27 07:49:43','2006-02-15 22:12:33'),
 (580,22,1,556,'4.99','2005-05-28 08:31:36','2006-02-15 22:12:33'),
 (581,22,2,820,'8.99','2005-05-29 21:07:22','2006-02-15 22:12:33'),
 (582,22,1,3419,'2.99','2005-06-21 17:18:01','2006-02-15 22:12:33'),
 (583,22,2,4215,'2.99','2005-07-07 12:00:52','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (584,22,1,5294,'6.99','2005-07-09 15:23:42','2006-02-15 22:12:33'),
 (585,22,1,5815,'2.99','2005-07-10 15:48:19','2006-02-15 22:12:33'),
 (586,22,1,7087,'4.99','2005-07-27 04:42:08','2006-02-15 22:12:33'),
 (587,22,1,7705,'7.99','2005-07-28 04:02:58','2006-02-15 22:12:33'),
 (588,22,2,9410,'0.99','2005-07-30 20:38:05','2006-02-15 22:12:33'),
 (589,22,1,9580,'4.99','2005-07-31 03:01:11','2006-02-15 22:12:33'),
 (590,22,1,12023,'5.99','2005-08-17 19:54:54','2006-02-15 22:12:33'),
 (591,22,1,12124,'2.99','2005-08-17 23:22:46','2006-02-15 22:12:33'),
 (592,22,2,12809,'0.99','2005-08-19 00:42:24','2006-02-15 22:12:33'),
 (593,22,2,13060,'9.99','2005-08-19 09:43:25','2006-02-15 22:12:33'),
 (594,22,1,14056,'2.99','2005-08-20 22:18:53','2006-02-15 22:12:33'),
 (595,22,1,14564,'6.99','2005-08-21 16:24:43','2006-02-15 22:12:33'),
 (596,22,1,15134,'7.99','2005-08-22 13:18:25','2006-02-15 22:12:33'),
 (597,22,1,15589,'6.99','2005-08-23 06:03:31','2006-02-15 22:12:33'),
 (598,22,1,15658,'4.99','2005-08-23 08:48:43','2006-02-15 22:12:33');
INSERT INTO `sakila`.`payment` VALUES  (599,22,1,15793,'4.99','2005-08-23 14:06:19','2006-02-15 22:12:33'),
 (600,22,1,12222,'4.99','2006-02-14 15:16:03','2006-02-15 22:12:33'),
 (601,23,1,129,'8.99','2005-05-25 21:20:03','2006-02-15 22:12:33'),
 (602,23,1,654,'2.99','2005-05-28 20:15:30','2006-02-15 22:12:33'),
 (603,23,2,1090,'0.99','2005-05-31 12:03:44','2006-02-15 22:12:33'),
 (604,23,1,2753,'1.99','2005-06-19 16:44:35','2006-02-15 22:12:33'),
 (605,23,1,2827,'0.99','2005-06-19 20:50:01','2006-02-15 22:12:33'),
 (606,23,1,3015,'5.99','2005-06-20 10:48:56','2006-02-15 22:12:33'),
 (607,23,1,3055,'4.99','2005-06-20 13:19:58','2006-02-15 22:12:33'),
 (608,23,1,3461,'2.99','2005-06-21 21:49:18','2006-02-15 22:12:34'),
 (609,23,2,3736,'3.99','2005-07-06 11:43:44','2006-02-15 22:12:34'),
 (610,23,2,3781,'2.99','2005-07-06 13:53:41','2006-02-15 22:12:34'),
 (611,23,2,4853,'2.99','2005-07-08 18:43:18','2006-02-15 22:12:34'),
 (612,23,1,6213,'2.99','2005-07-11 12:43:07','2006-02-15 22:12:34'),
 (613,23,1,6238,'2.99','2005-07-11 14:20:18','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (614,23,2,6917,'5.99','2005-07-12 22:30:15','2006-02-15 22:12:34'),
 (615,23,1,7155,'7.99','2005-07-27 07:18:46','2006-02-15 22:12:34'),
 (616,23,1,8015,'2.99','2005-07-28 15:33:03','2006-02-15 22:12:34'),
 (617,23,2,8718,'0.99','2005-07-29 17:41:14','2006-02-15 22:12:34'),
 (618,23,2,9209,'5.99','2005-07-30 12:55:36','2006-02-15 22:12:34'),
 (619,23,2,9255,'9.99','2005-07-30 14:26:46','2006-02-15 22:12:34'),
 (620,23,2,9718,'3.99','2005-07-31 08:25:03','2006-02-15 22:12:34'),
 (621,23,1,10132,'6.99','2005-07-31 21:50:24','2006-02-15 22:12:34'),
 (622,23,1,10898,'2.99','2005-08-02 01:29:57','2006-02-15 22:12:34'),
 (623,23,2,11501,'2.99','2005-08-16 23:04:53','2006-02-15 22:12:34'),
 (624,23,2,13290,'2.99','2005-08-19 18:31:50','2006-02-15 22:12:34'),
 (625,23,2,13331,'4.99','2005-08-19 20:00:25','2006-02-15 22:12:34'),
 (626,23,2,13429,'6.99','2005-08-19 23:25:37','2006-02-15 22:12:34'),
 (627,23,2,13511,'0.99','2005-08-20 02:21:40','2006-02-15 22:12:34'),
 (628,23,2,13557,'0.99','2005-08-20 04:12:41','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (629,23,2,14482,'2.99','2005-08-21 13:42:45','2006-02-15 22:12:34'),
 (630,23,2,15532,'2.99','2006-02-14 15:16:03','2006-02-15 22:12:34'),
 (631,24,2,1007,'6.99','2005-05-31 01:02:28','2006-02-15 22:12:34'),
 (632,24,2,1077,'2.99','2005-05-31 10:22:54','2006-02-15 22:12:34'),
 (633,24,1,1716,'2.99','2005-06-16 14:39:31','2006-02-15 22:12:34'),
 (634,24,1,2070,'2.99','2005-06-17 16:27:51','2006-02-15 22:12:34'),
 (635,24,2,2116,'4.99','2005-06-17 20:16:12','2006-02-15 22:12:34'),
 (636,24,1,2451,'5.99','2005-06-18 19:28:02','2006-02-15 22:12:34'),
 (637,24,2,2963,'7.99','2005-06-20 07:33:09','2006-02-15 22:12:34'),
 (638,24,2,3649,'7.99','2005-07-06 07:32:42','2006-02-15 22:12:34'),
 (639,24,2,4378,'2.99','2005-07-07 20:29:08','2006-02-15 22:12:34'),
 (640,24,1,5310,'0.99','2005-07-09 16:00:34','2006-02-15 22:12:34'),
 (641,24,2,5648,'0.99','2005-07-10 07:09:21','2006-02-15 22:12:34'),
 (642,24,1,6855,'4.99','2005-07-12 19:46:29','2006-02-15 22:12:34'),
 (643,24,1,7266,'1.99','2005-07-27 11:22:17','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (644,24,1,8947,'4.99','2005-07-30 03:15:37','2006-02-15 22:12:34'),
 (645,24,1,9723,'0.99','2005-07-31 08:31:18','2006-02-15 22:12:34'),
 (646,24,2,9925,'0.99','2005-07-31 15:08:47','2006-02-15 22:12:34'),
 (647,24,2,10491,'2.99','2005-08-01 10:38:27','2006-02-15 22:12:34'),
 (648,24,1,11209,'2.99','2005-08-02 12:09:45','2006-02-15 22:12:34'),
 (649,24,2,11546,'2.99','2005-08-17 00:57:36','2006-02-15 22:12:34'),
 (650,24,2,12165,'8.99','2005-08-18 00:53:37','2006-02-15 22:12:34'),
 (651,24,1,12745,'2.99','2005-08-18 22:22:45','2006-02-15 22:12:34'),
 (652,24,1,12999,'1.99','2005-08-19 07:34:53','2006-02-15 22:12:34'),
 (653,24,2,13058,'4.99','2005-08-19 09:40:53','2006-02-15 22:12:34'),
 (654,24,1,13247,'0.99','2005-08-19 16:45:59','2006-02-15 22:12:34'),
 (655,24,2,15357,'4.99','2005-08-22 21:28:59','2006-02-15 22:12:34'),
 (656,25,1,90,'7.99','2005-05-25 14:31:25','2006-02-15 22:12:34'),
 (657,25,2,1033,'2.99','2005-05-31 04:50:07','2006-02-15 22:12:34'),
 (658,25,1,1338,'4.99','2005-06-15 12:17:34','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (659,25,1,1365,'2.99','2005-06-15 14:09:55','2006-02-15 22:12:34'),
 (660,25,2,1754,'6.99','2005-06-16 17:13:23','2006-02-15 22:12:34'),
 (661,25,2,2625,'8.99','2005-06-19 08:23:11','2006-02-15 22:12:34'),
 (662,25,1,2901,'4.99','2005-06-20 02:41:28','2006-02-15 22:12:34'),
 (663,25,1,3447,'4.99','2005-06-21 20:53:31','2006-02-15 22:12:34'),
 (664,25,1,4282,'2.99','2005-07-07 15:26:31','2006-02-15 22:12:34'),
 (665,25,1,4319,'0.99','2005-07-07 17:50:27','2006-02-15 22:12:34'),
 (666,25,2,4404,'2.99','2005-07-07 21:31:53','2006-02-15 22:12:34'),
 (667,25,1,5881,'2.99','2005-07-10 19:19:43','2006-02-15 22:12:34'),
 (668,25,1,6653,'4.99','2005-07-12 11:06:17','2006-02-15 22:12:34'),
 (669,25,2,6905,'2.99','2005-07-12 22:02:18','2006-02-15 22:12:34'),
 (670,25,2,8667,'2.99','2005-07-29 15:40:57','2006-02-15 22:12:34'),
 (671,25,2,8878,'0.99','2005-07-30 00:15:57','2006-02-15 22:12:34'),
 (672,25,1,9140,'8.99','2005-07-30 10:12:01','2006-02-15 22:12:34'),
 (673,25,2,9334,'2.99','2005-07-30 17:56:38','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (674,25,2,9922,'2.99','2005-07-31 14:59:37','2006-02-15 22:12:34'),
 (675,25,2,10103,'2.99','2005-07-31 20:49:13','2006-02-15 22:12:34'),
 (676,25,1,10324,'5.99','2005-08-01 04:49:06','2006-02-15 22:12:34'),
 (677,25,2,10860,'2.99','2005-08-02 00:12:32','2006-02-15 22:12:34'),
 (678,25,1,10916,'2.99','2005-08-02 02:05:59','2006-02-15 22:12:34'),
 (679,25,1,11642,'0.99','2005-08-17 04:48:05','2006-02-15 22:12:34'),
 (680,25,1,12922,'0.99','2005-08-19 04:48:48','2006-02-15 22:12:34'),
 (681,25,1,14193,'4.99','2005-08-21 03:38:27','2006-02-15 22:12:34'),
 (682,25,1,14236,'4.99','2005-08-21 05:13:16','2006-02-15 22:12:34'),
 (683,25,1,15512,'0.99','2005-08-23 02:57:30','2006-02-15 22:12:34'),
 (684,25,1,15972,'5.99','2005-08-23 20:00:30','2006-02-15 22:12:34'),
 (685,26,1,796,'2.99','2005-05-29 16:59:44','2006-02-15 22:12:34'),
 (686,26,2,1105,'2.99','2005-05-31 14:33:56','2006-02-15 22:12:34'),
 (687,26,1,1440,'5.99','2005-06-15 18:53:14','2006-02-15 22:12:34'),
 (688,26,2,1706,'4.99','2005-06-16 14:01:02','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (689,26,1,2093,'9.99','2005-06-17 18:14:08','2006-02-15 22:12:34'),
 (690,26,2,2416,'3.99','2005-06-18 17:07:34','2006-02-15 22:12:34'),
 (691,26,2,2421,'6.99','2005-06-18 17:25:05','2006-02-15 22:12:34'),
 (692,26,1,2532,'4.99','2005-06-19 01:27:46','2006-02-15 22:12:34'),
 (693,26,1,2745,'4.99','2005-06-19 16:21:19','2006-02-15 22:12:34'),
 (694,26,1,4065,'2.99','2005-07-07 04:32:28','2006-02-15 22:12:34'),
 (695,26,1,4274,'4.99','2005-07-07 14:42:04','2006-02-15 22:12:34'),
 (696,26,1,4382,'4.99','2005-07-07 20:41:03','2006-02-15 22:12:34'),
 (697,26,2,4402,'0.99','2005-07-07 21:28:46','2006-02-15 22:12:34'),
 (698,26,1,4431,'6.99','2005-07-07 22:39:02','2006-02-15 22:12:34'),
 (699,26,1,4536,'3.99','2005-07-08 03:43:22','2006-02-15 22:12:34'),
 (700,26,1,4641,'6.99','2005-07-08 09:09:46','2006-02-15 22:12:34'),
 (701,26,1,5437,'2.99','2005-07-09 21:32:29','2006-02-15 22:12:34'),
 (702,26,1,6149,'1.99','2005-07-11 09:19:31','2006-02-15 22:12:34'),
 (703,26,2,6243,'2.99','2005-07-11 14:53:25','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (704,26,2,7328,'0.99','2005-07-27 13:55:18','2006-02-15 22:12:34'),
 (705,26,1,8241,'4.99','2005-07-29 00:33:36','2006-02-15 22:12:34'),
 (706,26,1,9484,'0.99','2005-07-30 23:31:40','2006-02-15 22:12:34'),
 (707,26,1,10386,'3.99','2005-08-01 06:42:20','2006-02-15 22:12:34'),
 (708,26,1,10996,'3.99','2005-08-02 04:48:11','2006-02-15 22:12:34'),
 (709,26,2,11314,'2.99','2005-08-02 16:04:08','2006-02-15 22:12:34'),
 (710,26,1,11338,'0.99','2005-08-02 17:00:12','2006-02-15 22:12:34'),
 (711,26,1,11744,'5.99','2005-08-17 08:54:30','2006-02-15 22:12:34'),
 (712,26,2,13111,'4.99','2005-08-19 11:25:10','2006-02-15 22:12:34'),
 (713,26,2,14183,'4.99','2005-08-21 03:24:29','2006-02-15 22:12:34'),
 (714,26,2,14192,'8.99','2005-08-21 03:37:42','2006-02-15 22:12:34'),
 (715,26,2,14603,'1.99','2005-08-21 17:51:06','2006-02-15 22:12:34'),
 (716,26,1,14677,'7.99','2005-08-21 20:12:30','2006-02-15 22:12:34'),
 (717,26,1,15384,'2.99','2005-08-22 22:34:44','2006-02-15 22:12:34'),
 (718,26,1,15722,'7.99','2005-08-23 11:16:29','2006-02-15 22:12:34');
INSERT INTO `sakila`.`payment` VALUES  (719,27,2,787,'2.99','2005-05-29 16:03:03','2006-02-15 22:12:34'),
 (720,27,1,1310,'4.99','2005-06-15 10:11:42','2006-02-15 22:12:35'),
 (721,27,2,1480,'4.99','2005-06-15 21:17:17','2006-02-15 22:12:35'),
 (722,27,2,1699,'2.99','2005-06-16 13:05:09','2006-02-15 22:12:35'),
 (723,27,2,1960,'3.99','2005-06-17 08:59:57','2006-02-15 22:12:35'),
 (724,27,2,2512,'2.99','2005-06-18 23:48:47','2006-02-15 22:12:35'),
 (725,27,1,2815,'4.99','2005-06-19 20:03:29','2006-02-15 22:12:35'),
 (726,27,1,3038,'1.99','2005-06-20 12:28:59','2006-02-15 22:12:35'),
 (727,27,2,3420,'3.99','2005-06-21 17:22:36','2006-02-15 22:12:35'),
 (728,27,2,4038,'0.99','2005-07-07 02:52:53','2006-02-15 22:12:35'),
 (729,27,1,4510,'5.99','2005-07-08 02:34:51','2006-02-15 22:12:35'),
 (730,27,1,5552,'0.99','2005-07-10 03:01:19','2006-02-15 22:12:35'),
 (731,27,1,5736,'4.99','2005-07-10 11:45:48','2006-02-15 22:12:35'),
 (732,27,2,6115,'0.99','2005-07-11 07:36:50','2006-02-15 22:12:35'),
 (733,27,2,6562,'5.99','2005-07-12 05:26:26','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (734,27,2,6658,'4.99','2005-07-12 11:13:21','2006-02-15 22:12:35'),
 (735,27,1,7927,'1.99','2005-07-28 12:13:42','2006-02-15 22:12:35'),
 (736,27,2,9244,'0.99','2005-07-30 14:06:53','2006-02-15 22:12:35'),
 (737,27,2,9636,'5.99','2005-07-31 05:12:59','2006-02-15 22:12:35'),
 (738,27,1,9673,'7.99','2005-07-31 06:34:55','2006-02-15 22:12:35'),
 (739,27,1,9908,'4.99','2005-07-31 14:39:52','2006-02-15 22:12:35'),
 (740,27,1,10794,'7.99','2005-08-01 21:51:15','2006-02-15 22:12:35'),
 (741,27,1,10852,'4.99','2005-08-02 00:00:33','2006-02-15 22:12:35'),
 (742,27,1,11234,'0.99','2005-08-02 13:12:17','2006-02-15 22:12:35'),
 (743,27,1,11661,'8.99','2005-08-17 05:25:57','2006-02-15 22:12:35'),
 (744,27,2,11740,'6.99','2005-08-17 08:48:31','2006-02-15 22:12:35'),
 (745,27,2,12021,'5.99','2005-08-17 19:52:43','2006-02-15 22:12:35'),
 (746,27,2,12461,'0.99','2005-08-18 11:28:14','2006-02-15 22:12:35'),
 (747,27,1,12531,'2.99','2005-08-18 13:57:50','2006-02-15 22:12:35'),
 (748,27,2,13816,'4.99','2005-08-20 13:13:56','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (749,27,1,15048,'0.99','2005-08-22 10:00:04','2006-02-15 22:12:35'),
 (750,28,2,388,'2.99','2005-05-27 10:37:27','2006-02-15 22:12:35'),
 (751,28,1,868,'2.99','2005-05-30 04:19:55','2006-02-15 22:12:35'),
 (752,28,2,1240,'2.99','2005-06-15 04:58:07','2006-02-15 22:12:35'),
 (753,28,1,1543,'4.99','2005-06-16 01:24:08','2006-02-15 22:12:35'),
 (754,28,2,2299,'3.99','2005-06-18 08:18:52','2006-02-15 22:12:35'),
 (755,28,2,2604,'0.99','2005-06-19 06:30:10','2006-02-15 22:12:35'),
 (756,28,1,3231,'0.99','2005-06-21 02:25:00','2006-02-15 22:12:35'),
 (757,28,1,3845,'0.99','2005-07-06 16:38:14','2006-02-15 22:12:35'),
 (758,28,2,4704,'0.99','2005-07-08 11:45:35','2006-02-15 22:12:35'),
 (759,28,2,4951,'4.99','2005-07-08 22:58:21','2006-02-15 22:12:35'),
 (760,28,2,5653,'2.99','2005-07-10 07:21:27','2006-02-15 22:12:35'),
 (761,28,1,5817,'5.99','2005-07-10 15:49:12','2006-02-15 22:12:35'),
 (762,28,2,6032,'0.99','2005-07-11 02:49:01','2006-02-15 22:12:35'),
 (763,28,2,6476,'0.99','2005-07-12 01:37:48','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (764,28,1,7580,'9.99','2005-07-27 23:07:40','2006-02-15 22:12:35'),
 (765,28,1,8464,'4.99','2005-07-29 08:18:20','2006-02-15 22:12:35'),
 (766,28,1,8901,'2.99','2005-07-30 01:07:12','2006-02-15 22:12:35'),
 (767,28,2,9544,'2.99','2005-07-31 01:44:51','2006-02-15 22:12:35'),
 (768,28,2,9593,'4.99','2005-07-31 03:22:30','2006-02-15 22:12:35'),
 (769,28,2,9705,'4.99','2005-07-31 07:40:33','2006-02-15 22:12:35'),
 (770,28,2,10116,'2.99','2005-07-31 21:14:02','2006-02-15 22:12:35'),
 (771,28,2,10294,'6.99','2005-08-01 03:48:12','2006-02-15 22:12:35'),
 (772,28,1,11444,'2.99','2005-08-02 20:32:55','2006-02-15 22:12:35'),
 (773,28,1,11856,'3.99','2005-08-17 13:44:49','2006-02-15 22:12:35'),
 (774,28,2,12190,'2.99','2005-08-18 01:54:44','2006-02-15 22:12:35'),
 (775,28,1,12359,'0.99','2005-08-18 07:44:05','2006-02-15 22:12:35'),
 (776,28,1,12708,'2.99','2005-08-18 20:59:17','2006-02-15 22:12:35'),
 (777,28,2,13783,'4.99','2005-08-20 12:11:03','2006-02-15 22:12:35'),
 (778,28,2,14540,'2.99','2005-08-21 15:34:23','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (779,28,1,15445,'4.99','2005-08-23 00:48:29','2006-02-15 22:12:35'),
 (780,28,1,15491,'2.99','2005-08-23 02:08:40','2006-02-15 22:12:35'),
 (781,28,2,12938,'2.99','2006-02-14 15:16:03','2006-02-15 22:12:35'),
 (782,29,2,194,'1.99','2005-05-26 06:52:33','2006-02-15 22:12:35'),
 (783,29,1,2655,'0.99','2005-06-19 10:38:42','2006-02-15 22:12:35'),
 (784,29,1,2673,'0.99','2005-06-19 11:42:20','2006-02-15 22:12:35'),
 (785,29,1,2701,'7.99','2005-06-19 13:33:06','2006-02-15 22:12:35'),
 (786,29,1,2735,'2.99','2005-06-19 15:42:07','2006-02-15 22:12:35'),
 (787,29,2,2801,'2.99','2005-06-19 19:18:09','2006-02-15 22:12:35'),
 (788,29,2,2923,'2.99','2005-06-20 04:16:07','2006-02-15 22:12:35'),
 (789,29,1,3324,'2.99','2005-06-21 08:49:16','2006-02-15 22:12:35'),
 (790,29,2,4262,'6.99','2005-07-07 14:24:30','2006-02-15 22:12:35'),
 (791,29,1,4313,'0.99','2005-07-07 17:36:56','2006-02-15 22:12:35'),
 (792,29,2,4535,'0.99','2005-07-08 03:40:46','2006-02-15 22:12:35'),
 (793,29,2,5442,'10.99','2005-07-09 21:55:19','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (794,29,1,5857,'1.99','2005-07-10 17:59:29','2006-02-15 22:12:35'),
 (795,29,2,7237,'3.99','2005-07-27 10:12:36','2006-02-15 22:12:35'),
 (796,29,1,7451,'6.99','2005-07-27 18:18:41','2006-02-15 22:12:35'),
 (797,29,1,7453,'0.99','2005-07-27 18:27:13','2006-02-15 22:12:35'),
 (798,29,2,8673,'2.99','2005-07-29 15:50:14','2006-02-15 22:12:35'),
 (799,29,2,9392,'4.99','2005-07-30 19:50:13','2006-02-15 22:12:35'),
 (800,29,1,9946,'4.99','2005-07-31 15:48:54','2006-02-15 22:12:35'),
 (801,29,1,10543,'5.99','2005-08-01 12:36:09','2006-02-15 22:12:35'),
 (802,29,2,10899,'1.99','2005-08-02 01:30:21','2006-02-15 22:12:35'),
 (803,29,1,11079,'4.99','2005-08-02 07:29:10','2006-02-15 22:12:35'),
 (804,29,2,11962,'2.99','2005-08-17 17:34:38','2006-02-15 22:12:35'),
 (805,29,1,12488,'4.99','2005-08-18 12:48:22','2006-02-15 22:12:35'),
 (806,29,1,12508,'2.99','2005-08-18 13:20:13','2006-02-15 22:12:35'),
 (807,29,2,12569,'6.99','2005-08-18 15:20:46','2006-02-15 22:12:35'),
 (808,29,2,12615,'6.99','2005-08-18 17:16:07','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (809,29,2,13173,'2.99','2005-08-19 13:50:36','2006-02-15 22:12:35'),
 (810,29,1,13436,'0.99','2005-08-19 23:36:25','2006-02-15 22:12:35'),
 (811,29,2,13777,'2.99','2005-08-20 12:03:35','2006-02-15 22:12:35'),
 (812,29,1,13832,'3.99','2005-08-20 14:00:25','2006-02-15 22:12:35'),
 (813,29,1,14174,'0.99','2005-08-21 03:01:45','2006-02-15 22:12:35'),
 (814,29,1,14703,'4.99','2005-08-21 21:01:19','2006-02-15 22:12:35'),
 (815,29,1,14985,'7.99','2005-08-22 07:35:56','2006-02-15 22:12:35'),
 (816,29,1,14997,'5.99','2005-08-22 07:53:00','2006-02-15 22:12:35'),
 (817,29,2,15577,'0.99','2006-02-14 15:16:03','2006-02-15 22:12:35'),
 (818,30,2,1874,'1.99','2005-06-17 02:39:20','2006-02-15 22:12:35'),
 (819,30,2,1895,'2.99','2005-06-17 04:25:12','2006-02-15 22:12:35'),
 (820,30,2,2154,'4.99','2005-06-17 22:59:42','2006-02-15 22:12:35'),
 (821,30,2,2730,'2.99','2005-06-19 15:10:09','2006-02-15 22:12:35'),
 (822,30,1,3964,'4.99','2005-07-06 22:23:02','2006-02-15 22:12:35'),
 (823,30,2,4471,'2.99','2005-07-08 00:21:29','2006-02-15 22:12:35');
INSERT INTO `sakila`.`payment` VALUES  (824,30,2,4642,'2.99','2005-07-08 09:13:28','2006-02-15 22:12:35'),
 (825,30,2,5028,'5.99','2005-07-09 02:34:45','2006-02-15 22:12:36'),
 (826,30,1,5108,'9.99','2005-07-09 06:44:30','2006-02-15 22:12:36'),
 (827,30,1,5289,'0.99','2005-07-09 15:14:08','2006-02-15 22:12:36'),
 (828,30,2,5972,'7.99','2005-07-11 00:08:54','2006-02-15 22:12:36'),
 (829,30,1,6249,'0.99','2005-07-11 15:02:02','2006-02-15 22:12:36'),
 (830,30,2,6359,'2.99','2005-07-11 21:06:17','2006-02-15 22:12:36'),
 (831,30,2,7394,'2.99','2005-07-27 16:03:08','2006-02-15 22:12:36'),
 (832,30,2,7769,'4.99','2005-07-28 06:45:23','2006-02-15 22:12:36'),
 (833,30,1,8030,'4.99','2005-07-28 16:12:53','2006-02-15 22:12:36'),
 (834,30,2,8038,'4.99','2005-07-28 16:32:55','2006-02-15 22:12:36'),
 (835,30,1,8083,'4.99','2005-07-28 18:09:48','2006-02-15 22:12:36'),
 (836,30,1,8641,'2.99','2005-07-29 14:37:30','2006-02-15 22:12:36'),
 (837,30,2,9309,'2.99','2005-07-30 16:55:53','2006-02-15 22:12:36'),
 (838,30,2,9551,'0.99','2005-07-31 02:04:58','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (839,30,1,9641,'0.99','2005-07-31 05:33:48','2006-02-15 22:12:36'),
 (840,30,1,9998,'2.99','2005-07-31 17:40:35','2006-02-15 22:12:36'),
 (841,30,1,10235,'6.99','2005-08-01 01:57:48','2006-02-15 22:12:36'),
 (842,30,1,12240,'2.99','2005-08-18 03:27:11','2006-02-15 22:12:36'),
 (843,30,1,12546,'2.99','2005-08-18 14:29:37','2006-02-15 22:12:36'),
 (844,30,2,12758,'0.99','2005-08-18 22:58:34','2006-02-15 22:12:36'),
 (845,30,1,13435,'0.99','2005-08-19 23:35:44','2006-02-15 22:12:36'),
 (846,30,1,13682,'4.99','2005-08-20 08:50:39','2006-02-15 22:12:36'),
 (847,30,1,14339,'0.99','2005-08-21 08:37:15','2006-02-15 22:12:36'),
 (848,30,1,14585,'2.99','2005-08-21 17:18:33','2006-02-15 22:12:36'),
 (849,30,1,15063,'4.99','2005-08-22 10:39:51','2006-02-15 22:12:36'),
 (850,30,1,15544,'4.99','2005-08-23 04:17:56','2006-02-15 22:12:36'),
 (851,30,2,15829,'2.99','2005-08-23 15:17:14','2006-02-15 22:12:36'),
 (852,31,2,1656,'4.99','2005-06-16 10:05:40','2006-02-15 22:12:36'),
 (853,31,1,1838,'1.99','2005-06-16 23:20:16','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (854,31,1,2233,'0.99','2005-06-18 03:57:36','2006-02-15 22:12:36'),
 (855,31,2,2341,'6.99','2005-06-18 11:35:30','2006-02-15 22:12:36'),
 (856,31,1,2396,'7.99','2005-06-18 15:49:48','2006-02-15 22:12:36'),
 (857,31,2,2438,'0.99','2005-06-18 18:34:21','2006-02-15 22:12:36'),
 (858,31,1,2530,'0.99','2005-06-19 01:20:00','2006-02-15 22:12:36'),
 (859,31,2,2648,'4.99','2005-06-19 10:06:20','2006-02-15 22:12:36'),
 (860,31,2,3117,'2.99','2005-06-20 18:05:15','2006-02-15 22:12:36'),
 (861,31,2,3172,'1.99','2005-06-20 22:19:25','2006-02-15 22:12:36'),
 (862,31,1,3205,'0.99','2005-06-21 00:38:47','2006-02-15 22:12:36'),
 (863,31,1,3701,'4.99','2005-07-06 10:12:45','2006-02-15 22:12:36'),
 (864,31,2,3967,'4.99','2005-07-06 22:45:10','2006-02-15 22:12:36'),
 (865,31,1,4122,'6.99','2005-07-07 07:15:35','2006-02-15 22:12:36'),
 (866,31,2,4738,'9.99','2005-07-08 13:24:58','2006-02-15 22:12:36'),
 (867,31,1,6208,'3.99','2005-07-11 12:34:56','2006-02-15 22:12:36'),
 (868,31,2,6580,'4.99','2005-07-12 06:26:10','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (869,31,1,7000,'1.99','2005-07-27 01:23:24','2006-02-15 22:12:36'),
 (870,31,2,7138,'3.99','2005-07-27 06:47:13','2006-02-15 22:12:36'),
 (871,31,2,7178,'2.99','2005-07-27 08:09:25','2006-02-15 22:12:36'),
 (872,31,2,7464,'2.99','2005-07-27 18:49:42','2006-02-15 22:12:36'),
 (873,31,2,8997,'0.99','2005-07-30 04:53:56','2006-02-15 22:12:36'),
 (874,31,2,12085,'4.99','2005-08-17 22:17:09','2006-02-15 22:12:36'),
 (875,31,1,12377,'0.99','2005-08-18 08:26:05','2006-02-15 22:12:36'),
 (876,31,2,15682,'6.99','2005-08-23 09:37:34','2006-02-15 22:12:36'),
 (877,31,2,15816,'6.99','2005-08-23 14:58:06','2006-02-15 22:12:36'),
 (878,32,2,483,'4.99','2005-05-27 23:00:25','2006-02-15 22:12:36'),
 (879,32,2,803,'4.99','2005-05-29 17:52:30','2006-02-15 22:12:36'),
 (880,32,2,1067,'4.99','2005-05-31 09:12:13','2006-02-15 22:12:36'),
 (881,32,2,1887,'6.99','2005-06-17 03:53:18','2006-02-15 22:12:36'),
 (882,32,2,2160,'0.99','2005-06-17 23:39:11','2006-02-15 22:12:36'),
 (883,32,2,2624,'5.99','2005-06-19 08:22:09','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (884,32,2,2891,'1.99','2005-06-20 02:02:05','2006-02-15 22:12:36'),
 (885,32,1,3500,'2.99','2005-07-06 00:11:13','2006-02-15 22:12:36'),
 (886,32,1,4434,'2.99','2005-07-07 22:48:34','2006-02-15 22:12:36'),
 (887,32,2,4771,'2.99','2005-07-08 15:33:32','2006-02-15 22:12:36'),
 (888,32,2,4899,'0.99','2005-07-08 20:37:11','2006-02-15 22:12:36'),
 (889,32,1,5307,'9.99','2005-07-09 15:57:15','2006-02-15 22:12:36'),
 (890,32,1,5767,'0.99','2005-07-10 13:13:18','2006-02-15 22:12:36'),
 (891,32,1,5954,'2.99','2005-07-10 23:22:01','2006-02-15 22:12:36'),
 (892,32,1,6122,'3.99','2005-07-11 07:58:07','2006-02-15 22:12:36'),
 (893,32,2,6450,'2.99','2005-07-12 00:49:05','2006-02-15 22:12:36'),
 (894,32,1,7084,'6.99','2005-07-27 04:34:07','2006-02-15 22:12:36'),
 (895,32,1,7589,'5.99','2005-07-27 23:23:36','2006-02-15 22:12:36'),
 (896,32,1,7793,'2.99','2005-07-28 07:26:14','2006-02-15 22:12:36'),
 (897,32,2,8390,'5.99','2005-07-29 05:52:26','2006-02-15 22:12:36'),
 (898,32,2,8453,'2.99','2005-07-29 07:46:29','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (899,32,2,8914,'2.99','2005-07-30 01:42:03','2006-02-15 22:12:36'),
 (900,32,1,11135,'4.99','2005-08-02 09:22:25','2006-02-15 22:12:36'),
 (901,32,2,11831,'4.99','2005-08-17 12:54:47','2006-02-15 22:12:36'),
 (902,32,2,12414,'9.99','2005-08-18 09:50:40','2006-02-15 22:12:36'),
 (903,32,1,13736,'8.99','2005-08-20 10:31:23','2006-02-15 22:12:36'),
 (904,32,1,13931,'1.99','2005-08-20 17:16:10','2006-02-15 22:12:36'),
 (905,32,1,14075,'0.99','2005-08-20 23:18:54','2006-02-15 22:12:36'),
 (906,32,2,14570,'5.99','2005-08-21 16:32:32','2006-02-15 22:12:36'),
 (907,33,1,165,'2.99','2005-05-26 02:28:36','2006-02-15 22:12:36'),
 (908,33,1,1301,'10.99','2005-06-15 09:46:33','2006-02-15 22:12:36'),
 (909,33,2,3173,'8.99','2005-06-20 22:21:10','2006-02-15 22:12:36'),
 (910,33,1,4095,'5.99','2005-07-07 06:01:48','2006-02-15 22:12:36'),
 (911,33,1,5421,'0.99','2005-07-09 20:49:12','2006-02-15 22:12:36'),
 (912,33,1,5723,'4.99','2005-07-10 11:14:48','2006-02-15 22:12:36'),
 (913,33,2,6280,'0.99','2005-07-11 16:36:17','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (914,33,1,7992,'4.99','2005-07-28 14:53:06','2006-02-15 22:12:36'),
 (915,33,1,9040,'4.99','2005-07-30 06:31:45','2006-02-15 22:12:36'),
 (916,33,2,9085,'4.99','2005-07-30 08:17:24','2006-02-15 22:12:36'),
 (917,33,1,9254,'1.99','2005-07-30 14:26:11','2006-02-15 22:12:36'),
 (918,33,2,10335,'2.99','2005-08-01 04:59:30','2006-02-15 22:12:36'),
 (919,33,1,10870,'4.99','2005-08-02 00:27:12','2006-02-15 22:12:36'),
 (920,33,1,13241,'7.99','2005-08-19 16:25:00','2006-02-15 22:12:36'),
 (921,33,1,13858,'2.99','2005-08-20 14:50:57','2006-02-15 22:12:36'),
 (922,33,1,13958,'7.99','2005-08-20 18:11:44','2006-02-15 22:12:36'),
 (923,33,1,14002,'0.99','2005-08-20 20:12:19','2006-02-15 22:12:36'),
 (924,33,1,14623,'0.99','2005-08-21 18:29:13','2006-02-15 22:12:36'),
 (925,33,1,15096,'5.99','2005-08-22 11:43:04','2006-02-15 22:12:36'),
 (926,33,2,15115,'2.99','2005-08-22 12:28:01','2006-02-15 22:12:36'),
 (927,33,1,12277,'0.99','2006-02-14 15:16:03','2006-02-15 22:12:36'),
 (928,34,1,1900,'4.99','2005-06-17 04:29:58','2006-02-15 22:12:36');
INSERT INTO `sakila`.`payment` VALUES  (929,34,2,2257,'5.99','2005-06-18 05:29:52','2006-02-15 22:12:36'),
 (930,34,1,3150,'0.99','2005-06-20 20:35:28','2006-02-15 22:12:36'),
 (931,34,2,3508,'3.99','2005-07-06 00:24:25','2006-02-15 22:12:36'),
 (932,34,1,3911,'2.99','2005-07-06 20:09:11','2006-02-15 22:12:36'),
 (933,34,1,5188,'4.99','2005-07-09 10:22:31','2006-02-15 22:12:36'),
 (934,34,2,5643,'4.99','2005-07-10 06:49:00','2006-02-15 22:12:36'),
 (935,34,2,5918,'5.99','2005-07-10 21:32:06','2006-02-15 22:12:36'),
 (936,34,2,7015,'2.99','2005-07-27 02:15:01','2006-02-15 22:12:36'),
 (937,34,2,7124,'2.99','2005-07-27 06:09:30','2006-02-15 22:12:36'),
 (938,34,1,7532,'0.99','2005-07-27 21:20:52','2006-02-15 22:12:36'),
 (939,34,1,9160,'3.99','2005-07-30 11:17:33','2006-02-15 22:12:37'),
 (940,34,1,10523,'0.99','2005-08-01 11:52:32','2006-02-15 22:12:37'),
 (941,34,1,10615,'4.99','2005-08-01 14:58:14','2006-02-15 22:12:37'),
 (942,34,2,11096,'0.99','2005-08-02 08:05:19','2006-02-15 22:12:37'),
 (943,34,1,11505,'2.99','2005-08-16 23:18:47','2006-02-15 22:12:37');
INSERT INTO `sakila`.`payment` VALUES  (944,34,2,11701,'4.99','2005-08-17 07:15:47','2006-02-15 22:12:37'),
 (945,34,2,12286,'2.99','2005-08-18 04:57:59','2006-02-15 22:12:37'),
 (946,34,1,12599,'2.99','2005-08-18 16:42:45','2006-02-15 22:12:37'),
 (947,34,1,12651,'0.99','2005-08-18 18:36:16','2006-02-15 22:12:37'),
 (948,34,1,13371,'4.99','2005-08-19 21:21:47','2006-02-15 22:12:37'),
 (949,34,2,13949,'2.99','2005-08-20 17:55:13','2006-02-15 22:12:37'),
 (950,34,1,14686,'5.99','2005-08-21 20:32:08','2006-02-15 22:12:37'),
 (951,34,2,14701,'7.99','2005-08-21 20:54:32','2006-02-15 22:12:37'),
 (952,35,2,47,'3.99','2005-05-25 06:05:20','2006-02-15 22:12:37'),
 (953,35,1,424,'6.99','2005-05-27 15:34:01','2006-02-15 22:12:37'),
 (954,35,1,1579,'0.99','2005-06-16 04:09:08','2006-02-15 22:12:37'),
 (955,35,1,1989,'2.99','2005-06-17 10:47:24','2006-02-15 22:12:37'),
 (956,35,1,2229,'4.99','2005-06-18 03:50:18','2006-02-15 22:12:37'),
 (957,35,1,2231,'0.99','2005-06-18 03:52:14','2006-02-15 22:12:37'),
 (958,35,1,2743,'2.99','2005-06-19 16:15:56','2006-02-15 22:12:37');
INSERT INTO `sakila`.`payment` VALUES  (959,35,2,3112,'4.99','2005-06-20 17:53:30','2006-02-15 22:12:37'),
 (960,35,2,3597,'2.99','2005-07-06 05:03:59','2006-02-15 22:12:37'),
 (961,35,2,4098,'4.99','2005-07-07 06:14:51','2006-02-15 22:12:37'),
 (962,35,2,4990,'0.99','2005-07-09 00:48:49','2006-02-15 22:12:37'),
 (963,35,1,5013,'2.99','2005-07-09 01:46:45','2006-02-15 22:12:37'),
 (964,35,2,5323,'0.99','2005-07-09 16:34:07','2006-02-15 22:12:37'),
 (965,35,1,5916,'5.99','2005-07-10 21:26:31','2006-02-15 22:12:37'),
 (966,35,1,5963,'0.99','2005-07-10 23:47:08','2006-02-15 22:12:37'),
 (967,35,1,6147,'5.99','2005-07-11 09:13:08','2006-02-15 22:12:37'),
 (968,35,1,6401,'4.99','2005-07-11 22:44:34','2006-02-15 22:12:37'),
 (969,35,1,6565,'4.99','2005-07-12 05:39:50','2006-02-15 22:12:37'),
 (970,35,1,6572,'4.99','2005-07-12 05:56:38','2006-02-15 22:12:37'),
 (971,35,1,7140,'4.99','2005-07-27 06:54:12','2006-02-15 22:12:37'),
 (972,35,1,8822,'6.99','2005-07-29 22:20:21','2006-02-15 22:12:37'),
 (973,35,1,8971,'5.99','2005-07-30 04:03:58','2006-02-15 22:12:37');
INSERT INTO `sakila`.`payment` VALUES  (974,35,2,9033,'2.99','2005-07-30 06:07:42','2006-02-15 22:12:37'),
 (975,35,1,9579,'6.99','2005-07-31 02:59:20','2006-02-15 22:12:37'),
 (976,35,1,11298,'1.99','2005-08-02 15:32:32','2006-02-15 22:12:37'),
 (977,35,1,11452,'7.99','2005-08-02 20:59:52','2006-02-15 22:12:37'),
 (978,35,1,11645,'4.99','2005-08-17 04:50:56','2006-02-15 22:12:37'),
 (979,35,1,12055,'4.99','2005-08-17 21:02:19','2006-02-15 22:12:37'),
 (980,35,1,13735,'2.99','2005-08-20 10:31:01','2006-02-15 22:12:37'),
 (981,35,1,14110,'0.99','2005-08-21 00:53:09','2006-02-15 22:12:37'),
 (982,35,2,14124,'2.99','2005-08-21 01:31:51','2006-02-15 22:12:37'),
 (983,35,2,14735,'4.99','2005-08-21 22:25:09','2006-02-15 22:12:37'),
 (984,36,1,349,'0.99','2005-05-27 04:53:11','2006-02-15 22:12:37'),
 (985,36,1,716,'0.99','2005-05-29 04:35:29','2006-02-15 22:12:37'),
 (986,36,2,2741,'0.99','2005-06-19 16:05:41','2006-02-15 22:12:37'),
 (987,36,2,4135,'0.99','2005-07-07 08:15:03','2006-02-15 22:12:37'),
 (988,36,2,4560,'4.99','2005-07-08 04:58:48','2006-02-15 22:12:37');
INSERT INTO `sakila`.`payment` VALUES  (989,36,2,4762,'4.99','2005-07-08 14:54:42','2006-02-15 22:12:37'),
 (990,36,1,5403,'0.99','2005-07-09 20:07:09','2006-02-15 22:12:37'),
 (991,36,2,6030,'0.99','2005-07-11 02:37:51','2006-02-15 22:12:37'),
 (992,36,1,7205,'6.99','2005-07-27 09:06:13','2006-02-15 22:12:37'),
 (993,36,1,7647,'0.99','2005-07-28 01:35:17','2006-02-15 22:12:37'),
 (994,36,2,7919,'6.99','2005-07-28 11:59:45','2006-02-15 22:12:37'),
 (995,36,2,8099,'0.99','2005-07-28 18:35:12','2006-02-15 22:12:37'),
 (996,36,1,8391,'2.99','2005-07-29 05:52:50','2006-02-15 22:12:37'),
 (997,36,1,8952,'4.99','2005-07-30 03:20:38','2006-02-15 22:12:37'),
 (998,36,