package com.mysql.grt;

public class GrtMessage implements GrtXml {
	private int msgType = 1; // 0..message, 1..error, 2.. progress

	private String msg = "";

	private GrtStringList msgDetails = new GrtStringList();
	
	private int progress = -1;

	final static int logMessage = 0;

	final static int logError = 1;
	
	final static int logProgress = 2;

	public GrtMessage(String msg, int msgType) {
		this.msg = msg;
		this.msgType = msgType;
	}
	
	public GrtMessage(String msg, int msgType, int progress) {
		this.msg = msg;
		this.msgType = msgType;
		this.progress = progress;
	}

	public void addMessageDetail(String msgDetail) {
		msgDetails.add(msgDetail);
	}

	public String getGrtXml() {
		return getGrtXml("");
	}

	public String getGrtXml(String keyTag) {
		String xml = "<value type=\"dict\" struct-name=\"GrtMessage\" key=\""
				+ keyTag + "\">" + "<value type=\"int\" key=\"msgType\">"
				+ Integer.toString(msgType) + "</value>\n"
				+ "<value type=\"int\" key=\"progress\">"
				+ Integer.toString(progress) + "</value>\n"
				+ "<value type=\"string\" key=\"msg\">" + msg + "</value>\n"
				+ msgDetails.getGrtXml(" key=\"details\"") + "</value>\n";

		return xml;
	}
}