//
//  MPreferenceEditor.h
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 1/8/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#include "myx_public_interface.h"

@class MConnectionEditor;

@interface MPreferenceEditor : NSObject {
  IBOutlet NSPanel *window;
  IBOutlet NSTabView *tabView;
  
  NSMutableArray *_pages;

  BOOL _inModalLoop;
  BOOL _releaseOnClose;
  MConnectionEditor *_connectionEditor;
}

- (id)initForConnectionsFile:(NSString*)file;

- (void)registerPageNib:(NSString*)nibName withLabel:(NSString*)label;

- (NSWindow*)window;

- (void)setReleaseOnClose:(BOOL)flag;
- (void)show;
- (int)runConnectionEditor;

@end
