unit RecordSetPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Contnrs, Graphics, Controls,
  VirtualTrees, TntExtCtrls, TntComCtrls, TntClasses, TntStdCtrls,
  myx_public_interface, gnugettext, auxfuncs, PNGImage;

type
  TRSPanel = class(TTntPanel)
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AddRSGridToPanel;
  public
    RSGrids: TObjectList;
  end;

  TRSGrid = class(TObject)
    constructor Create(AOwner: TComponent);
    destructor Destroy; override;

    procedure SetEditPanelStatusMessage(Caption: WideString;
      Msg: WideString = ''; IsErrorMsg: Boolean = False);
    procedure RefreshEditPanel;
    procedure DoSearch;
    procedure GotoFirstRow;
    procedure GotoLastRow;
  public
    ResultSet: PMYX_RESULTSET;
    RSVT: TVirtualStringTree;

    CurrentQuery: WideString;
    QueryHistroy: TTntStringList;
    CurrentHistoryEntry: integer;

    RSEditable,
    RSChanged,
    AtLeastOneRecord,
    FirstRowSelected,
    LastRowSelected: Boolean;
  private
    //The MainPanel holds the TV and the Edit Panel
    MainPanel: TTntPanel;

    EditPanel: TTntPanel;
    EditPaintBox: TTntPaintBox;

    RSErrorPNGImg,
    RSEditPNGImg,
    RSEditDisabledPNGImg,
    RSApplyPNGImg,
    RSApplyDisabledPNGImg,
    RSDiscardPNGImg,
    RSDiscardDisabledPNGImg,
    RSFirstPNGImg,
    RSFirstDisabledPNGImg,
    RSLastPNGImg,
    RSLastDisabledPNGImg,
    RSSearchPNGImg,
    RSSearchDisabledPNGImg: TPNGObject;

    StatusText, Msg: WideString;
    ErrorOccured: Boolean;

    RSEditXPos,
    RSApplyXPos,
    RSDiscardXPos,
    RSFirstXPos,
    RSLastXPos,
    RSSearchXPos: integer;


    procedure RSVTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure RSVTFocusChanging(Sender: TBaseVirtualTree; OldNode,
      NewNode: PVirtualNode; OldColumn, NewColumn: TColumnIndex;
      var Allowed: Boolean);
    procedure RSVTAfterCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellRect: TRect);
    procedure RSVTEditing(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; var Allowed: Boolean);
    procedure RSVTKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RSVTFocusChanged(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex);

    procedure EditPanelPaint(Sender: TObject);
    function PaintEditButton(Caption: WideString; var xpos: integer;
      PNGImg: TPNGObject; DisabledPNGImg: TPNGObject; Enabled: Boolean): integer;

    procedure EditPanelMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  end;

  PRSRowData = ^RSRowData;
  RSRowData = record
    //row: PMYX_RS_ROW;
    row_index: Longint;
    actions: TList;
  end;

implementation

constructor TRSPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Parent:=TWinControl(AOwner);
  BevelOuter:=bvNone;
  Caption:='';
  Width:=650;
  Height:=500;

  RSGrids:=TObjectList.Create;

  AddRSGridToPanel;
end;

destructor TRSPanel.Destroy;
begin
  RSGrids.Free;

  inherited;
end;

procedure TRSPanel.AddRSGridToPanel;
var RSGrid: TRSGrid;
begin
  RSGrid:=TRSGrid.Create(self);
  RSGrids.Add(RSGrid);
end;

constructor TRSGrid.Create(AOwner: TComponent);
begin
  inherited Create;

  //Create Main Panel holding VT and EditPanel
  MainPanel:=TTntPanel.Create(AOwner);
  MainPanel.Parent:=TWinControl(AOwner);
  MainPanel.BevelOuter:=bvNone;
  MainPanel.Caption:='';
  MainPanel.Align:=alClient;


  //Generate Virtual Tree
  RSVT:=TVirtualStringTree.Create(MainPanel);
  RSVT.Parent:=MainPanel;

  RSVT.NodeDataSize:=SizeOf(RSRowData);

  RSVT.Font.Name:='Tahoma';
  RSVT.Header.Font.Name:='Tahoma';
  RSVT.Header.Options:=RSVT.Header.Options+[hoDblClickResize, hoVisible];
  RSVT.LineStyle:=lsSolid;
  RSVT.ParentBackground:=False;
  RSVT.TreeOptions.MiscOptions:=RSVT.TreeOptions.MiscOptions+
    [toEditable, toGridExtensions, toVariableNodeHeight];
  RSVT.TreeOptions.PaintOptions:=RSVT.TreeOptions.PaintOptions+
    [toShowHorzGridLines, toShowVertGridLines]-
    [toShowRoot, toShowTreeLines];
  RSVT.TreeOptions.SelectionOptions:=RSVT.TreeOptions.SelectionOptions+
    [toExtendedFocus];
  RSVT.WantTabs:=True;
  RSVT.OnAfterCellPaint:=RSVTAfterCellPaint;
  RSVT.OnEditing:=RSVTEditing;
  RSVT.OnFocusChanging:=RSVTFocusChanging;
  RSVT.OnGetText:=RSVTGetText;
  RSVT.OnKeyDown:=RSVTKeyDown;
  RSVT.OnFocusChanged:=RSVTFocusChanged;

  //--------------------------------------------------------
  //Create Edit panel
  EditPanel:=TTntPanel.Create(MainPanel);
  EditPanel.Parent:=MainPanel;
  EditPanel.Height:=20;
  EditPanel.BevelOuter:=bvNone;
  EditPanel.Caption:='';
  EditPanel.Align:=alBottom;

  RSVT.Align:=alClient;

  //Create EditPaintBox
  EditPaintBox:=TTntPaintBox.Create(EditPanel);
  EditPaintBox.Parent:=EditPanel;
  EditPaintBox.Align:=alClient;
  EditPaintBox.OnPaint:=EditPanelPaint;
  EditPaintBox.OnMouseDown:=EditPanelMouseDown;

  //Load PNG Images
  RSErrorPNGImg:=LoadPNGImageFromResource('rs_error');

  RSEditPNGImg:=LoadPNGImageFromResource('rs_edit');
  RSEditDisabledPNGImg:=LoadPNGImageFromResource('rs_edit_disabled');
  RSApplyPNGImg:=LoadPNGImageFromResource('rs_apply');
  RSApplyDisabledPNGImg:=LoadPNGImageFromResource('rs_apply_disabled');
  RSDiscardPNGImg:=LoadPNGImageFromResource('rs_discard');
  RSDiscardDisabledPNGImg:=LoadPNGImageFromResource('rs_discard_disabled');

  RSFirstPNGImg:=LoadPNGImageFromResource('rs_first');
  RSFirstDisabledPNGImg:=LoadPNGImageFromResource('rs_first_disabled');

  RSLastPNGImg:=LoadPNGImageFromResource('rs_last');
  RSLastDisabledPNGImg:=LoadPNGImageFromResource('rs_last_disabled');

  RSSearchPNGImg:=LoadPNGImageFromResource('rs_search');
  RSSearchDisabledPNGImg:=LoadPNGImageFromResource('rs_search_disabled');

  QueryHistroy:=TTntStringList.Create;
  CurrentHistoryEntry:=0;
  CurrentQuery:='';

  StatusText:='';
  ErrorOccured:=False;

  RSEditable:=False;
  RSChanged:=False;
end;

destructor TRSGrid.Destroy;
begin
  if(ResultSet<>nil)then
    myx_query_free_resultset(ResultSet);

  QueryHistroy.Free;

  inherited;
end;

procedure TRSGrid.SetEditPanelStatusMessage(Caption: WideString;
  Msg: WideString; IsErrorMsg: Boolean);
begin
  StatusText:=Caption;
  self.Msg:=Msg;

  ErrorOccured:=IsErrorMsg;

  if(Msg<>'')then
  begin
    EditPanel.Height:=41;
  end
  else
  begin
    EditPanel.Height:=20;
  end;

  RefreshEditPanel;
end;

procedure TRSGrid.RefreshEditPanel;
begin
  if(ResultSet<>nil)then
    RSEditable:=(ResultSet.editable=1);

  AtLeastOneRecord:=False;
  if(ResultSet<>nil)then
    if(ResultSet.rows_num>0)then
      AtLeastOneRecord:=True;

  FirstRowSelected:=False;
  if(ResultSet<>nil)then
    if(ResultSet.rows_num>0)then
      if(RSVT.FocusedNode<>nil)then
        if(RSVT.FocusedNode=RSVT.GetFirstNoInit)then
          FirstRowSelected:=True;

  LastRowSelected:=False;
  if(ResultSet<>nil)then
    if(ResultSet.rows_num>0)then
      if(RSVT.FocusedNode<>nil)then
        if(RSVT.FocusedNode=RSVT.GetLastNoInit)then
          LastRowSelected:=True;

  EditPanelPaint(self);
end;

procedure TRSGrid.DoSearch;
var searchtxt: WideString;
begin
  if(ShowModalEditDialog(_('Search Resultset'),
    _('Enter the WideString you are searching for.'),
    myx_mtEdit, _('Search')+#13#10+_('Cancel'),
    True, _('Search for:'), searchtxt)=1)then
  begin
  end;
end;

procedure TRSGrid.GotoFirstRow;
begin
  RSVT.FocusedNode:=RSVT.GetFirstNoInit;
  RSVT.ClearSelection;
  RSVT.Selected[RSVT.FocusedNode]:=True;
end;

procedure TRSGrid.GotoLastRow;
begin
  RSVT.FocusedNode:=RSVT.GetLastNoInit;
  RSVT.ClearSelection;
  RSVT.Selected[RSVT.FocusedNode]:=True;
end;

procedure TRSGrid.EditPanelMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if(Not(FirstRowSelected)and(AtLeastOneRecord))and
    (X>RSFirstXPos)and(X<RSLastXPos)then
    GotoFirstRow;

  if(Not(LastRowSelected)and(AtLeastOneRecord))and
    (X>RSLastXPos)and(X<RSSearchXPos)then
    GotoLastRow;

  if(AtLeastOneRecord)and
    (X>RSSearchXPos)then
    DoSearch;
end;

procedure TRSGrid.EditPanelPaint(Sender: TObject);
var xpos: integer;
begin
  with EditPaintBox.Canvas do
  begin
    Pen.Color:=$009C9B91;
    Brush.Color:=clWhite;
    Rectangle(Rect(0, -1, EditPaintBox.Width, EditPaintBox.Height));

    if(EditPaintBox.Height>20)then
    begin
      MoveTo(0, 20);
      LineTo(EditPaintBox.Width, 20);
    end;

    xpos:=EditPaintBox.Width;

    Font.Name:='Tahoma';
    Font.Size:=7;

    RSSearchXPos:=PaintEditButton(_('Search'), xpos, RSSearchPNGImg,
      RSSearchDisabledPNGImg, AtLeastOneRecord);

    RSLastXPos:=PaintEditButton(_('Last'), xpos, RSLastPNGImg,
      RSLastDisabledPNGImg, Not(LastRowSelected)and(AtLeastOneRecord));

    RSFirstXPos:=PaintEditButton(_('First'), xpos, RSFirstPNGImg,
      RSFirstDisabledPNGImg, Not(FirstRowSelected)and(AtLeastOneRecord));

    xpos:=xpos-3;
    MoveTo(xpos, 0);
    LineTo(xpos, 20);

    RSDiscardXPos:=PaintEditButton(_('Discard Changes'), xpos, RSDiscardPNGImg,
      RSDiscardDisabledPNGImg, (RSChanged)and(AtLeastOneRecord));

    RSApplyXPos:=PaintEditButton(_('Apply Changes'), xpos, RSApplyPNGImg,
      RSApplyDisabledPNGImg, (RSChanged));

    RSEditXPos:=PaintEditButton(_('Edit'), xpos, RSEditPNGImg,
      RSEditDisabledPNGImg, (RSEditable)and(Not(RSChanged)));

    xpos:=xpos-3;
    MoveTo(xpos, 0);
    LineTo(xpos, 20);

    Font.Color:=clBlack;

    DrawWideStringText(EditPaintBox.Canvas.Handle, PWideChar(StatusText),
      Length(StatusText), Rect(4, 4, xpos-3, 4+10));

    if(Msg<>'')then
    begin
      if(Not(ErrorOccured))then
        DrawWideStringText(EditPaintBox.Canvas.Handle, PWideChar(Msg),
          Length(Msg), Rect(4, 21+4, EditPaintBox.Width-3, 21+4+10))
      else
      begin
        RSErrorPNGImg.Draw(EditPaintBox.Canvas,
          Rect(4, 21+2, 4+RSErrorPNGImg.Width, 21+2+RSErrorPNGImg.Height));

        DrawWideStringText(EditPaintBox.Canvas.Handle, PWideChar(Msg),
          Length(Msg), Rect(4+16+4, 21+4, EditPaintBox.Width-3, 21+4+10));
      end;
    end;
  end;
end;

function TRSGrid.PaintEditButton(Caption: WideString; var xpos: integer;
  PNGImg: TPNGObject; DisabledPNGImg: TPNGObject; Enabled: Boolean): integer;
var l: integer;
  s: WideString;
begin
  with EditPaintBox.Canvas do
  begin
    xpos:=xpos-7;

    s:=Caption;
    l:=GetWideStringTextWidth(EditPaintBox.Canvas, s);
    xpos:=xpos-l;

    if(Enabled)then
      Font.Color:=clBlack
    else
      Font.Color:=$00CCCCCC;

    DrawWideStringText(EditPaintBox.Canvas.Handle, PWideChar(s),
      Length(s), Rect(xpos, 4, xpos+l, 4+18));

    xpos:=xpos-21;

    if(Enabled)then
      PNGImg.Draw(EditPaintBox.Canvas,
        Rect(xpos, 1, xpos+RSSearchPNGImg.Width, 1+RSSearchPNGImg.Height))
    else
      DisabledPNGImg.Draw(EditPaintBox.Canvas,
        Rect(xpos, 1, xpos+RSSearchPNGImg.Width, 1+RSSearchPNGImg.Height));

    xpos:=xpos-5;
    MoveTo(xpos, 0);
    LineTo(xpos, 20);
  end;

  Result:=xpos;
end;

procedure TRSGrid.RSVTGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);
var NodeData: PRSRowData;
  row: MYX_RS_ROW;
  field: MYX_RS_FIELD;
begin
  if(Column=0)then
  begin
    CellText:='';
  end
  else if(Column-1<integer(ResultSet.columns_num))then
  begin
    NodeData:=Sender.GetNodeData(Node);

    //row:=NodeData^.row^;
    row:=PMYX_RS_ROW(integer(ResultSet.rows)+sizeof(MYX_RS_ROW)*NodeData.row_index)^;

    field:=(PMYX_RS_FIELD(integer(row.fields)+(sizeof(MYX_RS_FIELD)*(Column-1))))^;

    if(field.value<>nil)then
      CellText:=field.value
    else
      CellText:='';
  end;
end;

procedure TRSGrid.RSVTFocusChanging(Sender: TBaseVirtualTree;
  OldNode, NewNode: PVirtualNode; OldColumn, NewColumn: TColumnIndex;
  var Allowed: Boolean);
begin
 if(NewColumn=0)then
   Allowed:=False;
end;

procedure TRSGrid.RSVTAfterCellPaint(Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  CellRect: TRect);
var mx, my: integer;
begin
  if(Column=0)and(Node=Sender.FocusedNode)then
  begin
    mx:=(CellRect.Right-CellRect.Left) div 2;
    my:=(CellRect.Bottom-CellRect.Top) div 2;
    with TargetCanvas do
    begin
      Pen.Color:=clBlack;
      Brush.Color:=clBlack;
      Polygon([Point(mx-3, my-5), Point(mx+2, my), Point(mx-3, my+5)]);
    end;
  end;
end;

procedure TRSGrid.RSVTEditing(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; var Allowed: Boolean);
begin
  Allowed:=True;
end;

procedure TRSGrid.RSVTKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if(Key=VK_Return)and(RSVT.FocusedNode<>nil)then
    RSVT.EditNode(
      RSVT.FocusedNode,
      RSVT.FocusedColumn);
end;

procedure TRSGrid.RSVTFocusChanged(Sender: TBaseVirtualTree; Node: PVirtualNode;
  Column: TColumnIndex);
begin
  RefreshEditPanel;
end;

end.
