/* Copyright (C) 2003 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#ifndef CSHOWTABLEGROUPPROPERTIES_H
#define CSHOWTABLEGROUPPROPERTIES_H

#include "CTable.h"
#include "CTableItem.h"
#include "CTableGroupItem.h"

class CShowTableGroupProperties : public CTable
{
  Q_OBJECT

public:
  CShowTableGroupProperties(QWidget * parent, const char *name = 0);
  void setCurrentItem(CTableGroupItem *item) { current_item = item; }
  CTableGroupItem * currentItem() { return current_item; }
  virtual void sortColumn(int col, bool ascending, bool wholeRows);

private:
  CTableGroupItem * current_item;
  CTableItem * findItem(const QString &str);
  void DoubleClicked (int, int, int, const QPoint &);
  void ContextMenuRequested(int, int, const QPoint &);
};

#endif
