#!/usr/bin/env python
## -*- coding: utf-8 -*-
#
#
# Copyright (C) 2011, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu-bare is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from mythbackup import Backup
import ConfigParser
import logging

logger = logging.getLogger('mythbuntu-bare')
hdlr = logging.FileHandler('/var/log/mythbuntu-bare-client.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr) 
logger.setLevel(logging.WARNING)

ACTOR="<backup-task> "

CONFIGFILENAME = "mythbuntu-bare-client.conf"
CONFIGPATH = "/var/lib/mythtv/bare-client/"
CONFIGFILE = CONFIGPATH+CONFIGFILENAME

## Read config file
config = ConfigParser.ConfigParser()
config.read(CONFIGFILE)

## Check if managed and if so, then update
managed = config.get("General", "managed")
logger.info(ACTOR+'Checking if managed: '+str(managed))
if managed:
  pipe = subprocess.Popen(["/usr/share/mythbuntu-bare/update-task.py"], stdout=subprocess.PIPE).communicate()

## Reread config file in case it was updated
config.read(CONFIGFILE)
DB = config.get("Backup", "database")
logger.info(ACTOR+'Setting database backup to '+str(DB))
storagedir = config.get("Backup", "storagedir")
logger.info(ACTOR+'Setting backup storage directory to '+str(storagedir))

## Run backup job
logger.info(ACTOR+'Starting backup job')
Backup().backup_job(DB, storagedir)


