# -*- coding: utf-8 -*-
#
# «mysql» - libmythbuntu class for mysql mangling
#
# This script:
# Copyright (C) 2007-2008, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import shutil
import os
import subprocess
import re

#MySQL testing support
import MySQLdb

class MySQLHandler:
    """MySQL configuration, mangling, and activation class"""

    def __init__(self,config={"user":"mythtv","password":"mythtv","server":"localhost","database":"mythconverg"}):
        self.user=config["user"]
        self.password=config["password"]
        self.server=config["server"]
        self.database=config["database"]

    def read_mysql_txt(self,file):
        """Reads in file to setup stored mysql information"""
        try:
            in_f=open(file)
            for line in in_f:
                if re.compile("^DBHostName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.server = text
                elif re.compile("^DBUserName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.user = text
                elif re.compile("^DBName").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.database = text
                elif re.compile("^DBPassword").search(line):
                    text=string.split(string.split(line,"=")[1],'\n')[0]
                    self.password= text
            in_f.close()
        except IOError:
            print "Error reading " + file

    def write_mysql_txt(self,file,rewrite=True):
        """Writes mysql.txt to a given file name"""
        if os.path.exists(file):
            if rewrite:
                print "Moving " + file + " to " + file + ".old"
                shutil.move(file, file + ".old")
            else:
                print "Ignoring rewrite due to user request"
                return
        out_f = open(file, "w")
        out_f.write("DBHostName=" + self.server + "\n")
        out_f.write("DBUserName=" + self.user + "\n")
        out_f.write("DBName=" + self.database + "\n")
        out_f.write("DBPassword=" + self.password + "\n")
        out_f.close()

    def toggle_mysql_service_config(self,enable):
        """Enables and disables the mysql service on all interfaces"""
        if not os.path.exists("/etc/mysql/conf.d"):
            os.mkdir("/etc/mysql/conf.d")
        lines = None
        out_f = None
        found = False
        pattern = re.compile("^bind-address|^#bind-address")
        try:
            in_f = open("/etc/mysql/conf.d/mythtv.cnf")
            lines = in_f.readlines()
            in_f.close()
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            for line in lines:
                if pattern.search(line) is None:
                    out_f.write(line)
                elif not found:
                    if enable:
                        out_f.write("bind-address=0.0.0.0\n")
                    else:
                        out_f.write("#bind-address=0.0.0.0\n")
                    found = True
            if not found:
                if enable:
                    out_f.write("bind-address=0.0.0.0\n")
                else:
                    out_f.write("#bind-address=0.0.0.0\n")
        except IOError:
            print "/etc/mysql/conf.d/mythtv.cnf not found"
            out_f=open("/etc/mysql/conf.d/mythtv.cnf","w")
            out_f.write("[mysqld]\n")
            if enable:
                out_f.write("bind-address=0.0.0.0\n")
            else:
                out_f.write("#bind-address=0.0.0.0\n")
        out_f.close()

    def restart_mysql_service(self):
        """Restarts MySQL service"""
        start_mysql = subprocess.Popen(["invoke-rc.d", "mysql", "restart"],stdout=subprocess.PIPE).communicate()[0]
        print start_mysql

    def update_config(self,config):
        """Sets up a new configuration based on the dict {user,pass,server,db}"""
        self.user=config["user"]
        self.password=config["password"]
        self.server=config["server"]
        self.database=config["database"]

    def get_config(self):
        """Returns our currently stored configuration"""
        return {"user":self.user,"password":self.password,"server":self.server,"database":self.database}

    def reset_user_password(self,admin_user,admin_pass,password):
        """Resets a user's password if it was forgotten"""
        try:
            db = MySQLdb.connect(host=self.server, user=admin_user, passwd=admin_pass,db=self.database)
            cursor = db.cursor()
            cursor.execute("UPDATE user SET Password=PASSWORD('"+password+"') WHERE user="+self.user+"')")
            result = cursor.fetchone()
            cursor.execute("FLUSH PRIVILEGES")
            result = cursor.fetchone()
            cursor.close()
            db.close()
            result = "Successful"
        except:
            result = "Failure"
        return result

    def do_connection_test(self):
        """Tests to make sure that the backend is accessible"""
        try:
            db = MySQLdb.connect(host=self.server, user=self.user, passwd=self.password,db=self.database)
            cursor = db.cursor()
            cursor.execute("SELECT NULL")
            result = cursor.fetchone()
            cursor.close()
            db.close()
            result = "Successful"
        except:
            result = "Failure"
        return result
