#!/usr/bin/python
# Mythbuntu-Control-Centre install script
# Copyright (C) 2007, Mario Limonciello <superm1@mythbuntu.org>
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from distutils.core import setup

import subprocess, glob, os.path

# mo file support taken from package "restricted-manager"
mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))


setup(
    name="mythbuntu-control-centre",
    author="Mario Limonciello",
    author_email="superm1@mythbuntu.org",
    maintainer="Ubuntu MythTV Team",
    maintainer_email="ubuntu-mythtv@lists.ubuntu.com",
    url="http://www.mythbuntu.org",
    license="gpl",
    description="configures mythbuntu system settings",
    packages=["MythbuntuControlCentre"],
    data_files=[("share/mythtv", glob.glob("config/main_settings.xml")),
                ("share/mythbuntu-control-centre/glade", glob.glob("MythbuntuControlCentre/*.glade")),
                ("share/mythbuntu-control-centre/glade", glob.glob("MythbuntuControlCentre/*.png")),
                ("share/mythbuntu-control-centre/bin", glob.glob("bin/mythbuntu-control-centre")),
                ("share/applications", glob.glob("applications/*.desktop"))] + mo_files,
    scripts=["mythbuntu-control-centre"],
)

