/*
**  IconTableView.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "IconTableView.h"
#include <AppKit/AppKit.h>

@implementation IconTableView

- (void) mouseDown: (NSEvent *) event
{
//  NSLog(@"Type %d", [event type]);
//  NSLog(@"Click %d", [event clickCount]);
  if (([event clickCount] > 1) && ([event type] == NSLeftMouseDown))
    {
      NSPoint p = [self convertPoint: [event locationInWindow]
	                    fromView: [[self window] contentView]];
      NSLog(@"Row %d", [self rowAtPoint: p]);
      if (p.x <= 15)
	{
          NSLog(@"Double click on icon");
	  return;
	}
    }

  [super mouseDown: event];
}

- (void)drawRow: (int)rowIndex clipRect: (NSRect)aRect
{
  [super drawRow: rowIndex clipRect: aRect];

  NSTableColumn *tb;
  NSRect drawingRect;
  NSImage *icon;
  id cell;
  int i;

  tb = [[self tableColumns] objectAtIndex: 0];
  cell = [tb dataCellForRow: rowIndex];
  drawingRect = [self frameOfCellAtColumn: 0
                      row: rowIndex];

  if ([[self delegate] respondsToSelector:@selector(tableView:iconForTableColumn:row:)] == YES)
    {
      icon = [[self dataSource] tableView: self
                                iconForTableColumn: tb
                                row: rowIndex];
    }

  if (icon) {
#ifdef GNUSTEP
    drawingRect = NSMakeRect(drawingRect.origin.x-drawingRect.size.height,
                             drawingRect.origin.y,
                             drawingRect.size.height,
                             drawingRect.size.height);
    if ([self isFlipped])
      drawingRect.origin.y += drawingRect.size.height;
#else
    drawingRect = NSMakeRect(drawingRect.origin.x-drawingRect.size.height+2,
                             drawingRect.origin.y,
                             drawingRect.size.height,
			     drawingRect.size.height);

    if ([self isFlipped])
      drawingRect.origin.y += drawingRect.size.height-1;
    else
      drawingRect.origin.y -= 1;
#endif

    [icon compositeToPoint: drawingRect.origin
                 operation: NSCompositeSourceOver];
  }
}

- (NSRect) frameOfCellAtColumn: (int)columnIndex 
                           row: (int)rowIndex
{
  if ([[self delegate] respondsToSelector:@selector(tableView:iconForTableColumn:row:)] == NO)
    {
      return [super frameOfCellAtColumn: columnIndex
	                            row: rowIndex];
    }
  NSTableColumn *tb;
  NSString *identifier;

  if ((columnIndex < 0) 
      || (rowIndex < 0)
      || (columnIndex > ([self numberOfColumns] - 1))
      || (rowIndex > ([self numberOfRows] - 1)))
    return NSZeroRect;

  tb = [[self tableColumns] objectAtIndex: columnIndex];
  identifier = [tb identifier];

  // FIXME: Not for general case
  if (columnIndex == 0)
    {
      NSRect result;
      result = [super frameOfCellAtColumn: columnIndex
                      row:rowIndex];
      result.origin.x += result.size.height;
      result.size.width -= result.size.height;
      return result;
    }
  else
    {
      return [super frameOfCellAtColumn: columnIndex
                    row: rowIndex];
    }
}

@end
