/*
**  MWKHandler.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "MWKHandler.h"
#include "GNUstep.h"
#include "DataSource.h"
#include <Foundation/Foundation.h>

@implementation MWKHandler

- (void) tag: (NSString *) string
{
  NSString *substring = [string substringFromIndex: 1];
  if ([string isEqualToString: XMLTitleTag])
    {
      tagType = TitleTag;
      return;
    }
  else if ([string isEqualToString: XMLCreatedDateTag])
    {
      tagType = CreatedDateTag;
      return;
    }
  else if ([string isEqualToString: XMLModifiedDateTag])
    {
      tagType = ModifiedDateTag;
      return;
    }
  else if ([string isEqualToString: XMLVersionTag])
    {
      tagType = VersionTag;
      return;
    }
  else if (([substring isEqualToString: XMLTitleTag]) ||
	   ([substring isEqualToString: XMLCreatedDateTag]) ||
           ([substring isEqualToString: XMLModifiedDateTag]) ||
	   ([substring isEqualToString: XMLVersionTag]))
    {
      tagType = OtherTag;
      return;
    }
  else if ([string isEqualToString: XMLContentTag])
    {
      tagType = ContentTag;
      return;
    }
  else if ([substring isEqualToString: XMLContentTag])
    {
      tagType = OtherTag;
      NSCalendarDate *created, *modified;

      modified = [NSCalendarDate dateWithString: modifiedDate
	                         calendarFormat: DateFormat];
      if (modified == nil)
	modified = [NSCalendarDate calendarDate];

      created = [NSCalendarDate dateWithString: createdDate 
	                        calendarFormat: DateFormat];
      if (created == nil)
        created = [NSCalendarDate calendarDate];

      if ([created compare: modified] == NSOrderedDescending)
	{
          // Modified date should not earlier than created date
	  modified = [NSCalendarDate calendarDate];
	}

      NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithObjectsAndKeys:
	          AUTORELEASE([content copy]), ContentKey,
		  AUTORELEASE([title copy]), TitleKey, 
		  AUTORELEASE([modified copy]), ModifiedDateKey,
		  AUTORELEASE([created copy]), CreatedDateKey, nil];
      [wikiPages addObject: dict];
      [title setString: @""];
      [content setString: @""];
      [modifiedDate setString: @""];
      [createdDate setString: @""];
      return;
    }

  if (tagType == ContentTag)
    [content appendString: [NSString stringWithFormat: @"<%@>", string]];
}

- (void) content: (NSString *) string
{
  id s;
  switch(tagType) {
    case TitleTag:
      s = title;
      break;
    case ContentTag:
      s = content;
      break;
    case CreatedDateTag:
      s = createdDate;
      break;
    case ModifiedDateTag:
      s = modifiedDate;
      break;
    case VersionTag:
      s = version;
      break;
    default: 
      return;
  }

  [s appendString: string];
}

- (void) special: (NSString *) string
{
  if (tagType == ContentTag)
    [content appendString: string];
}

- (void) error: (ErrorType) type
{
  // Ignore error
}

- (id) init
{
  self = [super init];
  tagType = OtherTag;
  wikiPages = [[NSMutableArray alloc] init];
  title = [[NSMutableString alloc] init];
  content = [[NSMutableString alloc] init];
  createdDate = [[NSMutableString alloc] init];
  modifiedDate = [[NSMutableString alloc] init];
  version = [[NSMutableString alloc] init];
  return self;
}

- (void) dealloc
{
  RELEASE(wikiPages);
  RELEASE(title);
  RELEASE(content);
  RELEASE(createdDate);
  RELEASE(modifiedDate);
  RELEASE(version);
  [super dealloc];
}

- (NSArray *) wikiPages
{
  return AUTORELEASE([wikiPages copy]);;
}

@end

