/*
 * Mausezahn - A fast versatile traffic generator
 * Copyright (C) 2008 Herbert Haas
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the 
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with 
 * this program; if not, see http://www.gnu.org/licenses/gpl-2.0.html
 * 
*/




#include "mz.h"

// PURPOSE: Find usable network devices
// 
// NOTE: 
//   
//  1. Ignores devices without IP address 
//  2. Ignores loopback (etc)
// 
// RETURN VALUES:
// 
//  0 if usable device found (device_list[] and tx.device set)
//  1 if no usable device found
//  
int lookupdev()
{
   // char *tx.device is global, see as.h

   char 
     ipaddress[IPADDRSIZE+1],
     errbuf[PCAP_ERRBUF_SIZE];

   pcap_if_t 
     *alldevs,
     *index = NULL;

   pcap_addr_t *pcap_addr;

   int i=0;

   
   // ----------

   // FIRST get a list of all available devices
   //  
   if (pcap_findalldevs(&alldevs, errbuf) == -1)
     {
	fprintf(stderr," mz: %s\n",errbuf);
	return 1;
     }
   
   index = (pcap_if_t *) alldevs;
   
   while (index)
     {
	if (index->addresses)
	  {
	     pcap_addr = index->addresses;
	     while(pcap_addr)
	       {
		  if (pcap_addr->addr && (pcap_addr->addr->sa_family==AF_INET))
		    {
		       if (inet_ntop(pcap_addr->addr->sa_family,
				     (void *)&pcap_addr->addr->sa_data[2],
				     ipaddress,
				     IPADDRSIZE))
			 {
			    if (verbose)
			      {
				 fprintf(stderr," mz: device %s got assigned %s ",
					 index->name, ipaddress);
			      }
			    
			    if (strncmp(ipaddress, "127", 3)==0)
			      {
				 if (verbose) fprintf(stderr, "but loopback\n");
			      }
			    else if (strncmp(ipaddress, "169.254", 7)==0)
			      {
				 if (verbose) fprintf(stderr, "but IGNORED (cause: host-scope address)\n");
			      }
			    else // FOUND VALID INTERFACE
			      {
				 if (verbose) fprintf(stderr, "so let's take it.\n");
				 strncpy(device_list[i].dev, index->name, 9);
				 strncpy(device_list[i].ip, ipaddress, IPADDRSIZE);
				 i++;
			      }
			    
				 // Select only interfaces with IP addresses
				 // but avoid those that start with 127 or 169.254
				 // Put the remaining on a list. If this list has more than one entry
				 // ask the user which interface to listen to.

			 }
		       
		       else
			 {
			    return 1;
			 }
		       
		    }
		  pcap_addr = pcap_addr->next;
	       }
	   
	  }
	index = index->next;	  
     }
   
   device_list_entries = i;

   /*
   if (verbose)
     {
	for (i=0; i<device_list_entries; i++)
	  {
	     fprintf(stderr, " mz: Found device %s with IP %s\n", device_list[i].dev, device_list[i].ip);
	  }
     }
   */
   
   if (device_list_entries==0) return 1;

   strncpy (tx.device, device_list[0].dev,16);
   
   return 0;
}
