# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's lisence.
#
#
# shell command bot
#
# $Id: shellbot.nb 130 2005-05-26 12:04:08Z ko1 $
#

require 'timeout'
require 'kconv'

class ShellBot < Nadoka::NDK_Bot
  ShellNick = 'nadoka_shell'
  
  def on_client_privmsg client, ch, message
    
    if ch == ShellNick
      ans = exec_shell(message)
      ans.each{|line|
        msg = Cmd.privmsg(@state.nick, 'ans: ' + line)
        client.send_to_client client.add_prefix(msg, ShellNick)
      }
      raise ::Nadoka::NDK_BotSendCancel
    end
  end

  def on_nadoka_command client, command, *params
    if command == 'shell'
      msg = Cmd.privmsg(@state.nick, 'Hello, this is shell command executor')
      client.send_to_client client.add_prefix(msg, ShellNick)
      raise ::Nadoka::NDK_BotSendCancel
    end
  end

  def exec_shell message
    begin
      ans = Thread.new{
        begin
          timeout(3){
            str = `#{message}`.to_s
            str.tojis
          }
        rescue Exception => e
          e.message
        end
        }.value
    rescue Exception => e
      ans = e.message
    end
  end
end


