<?php
# $Id: nagiosdata.inc,v 1.13 2002/06/22 07:11:16 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

$NAGIOS_CFGFILES = array(
        'nagioscfg' => 'nagios.cfg',
        'cgicfg' => 'cgi.cfg',
        );

# Nagios objecttypes
$NAGIOS_OBJTYPES = array(
	"host", "hostgroup", 
	"hostdependency", "hostescalation", "hostgroupescalation",
	"service", "servicegroup", "servicedependency","serviceescalation",
	"timeperiod",
	"contact", "contactgroup",
	"command"
	);

# Where and in what fields can an object be used in another object
$NAGIOS_OBJUSAGE = array(
	"host" => array(
		"host" => array("parents"),
		"hostgroup" => array("members"),
		"service" => array("host_name"),
		"hostdependency" => array("host_name", "dependent_host_name"),
		"hostescalation" => array("host_name"),
		"serviceescalation" => array("host_name"),
		),
	"hostgroup" => array(
		"service" => array("hostgroup_name"),
		"hostgroupescalation" => array("hostgroup_name"),
		"serviceescalation" => array("hostgroup_name"),
		),
	"service" => array(
		"servicegroup" => array("members"),
		"servicedependency" =>
			array("service_name","dependent_service_name"),
		"serviceescalation" => array("service_description"),
		),
	"contact" => array(
		"contactgroup" => array("members"),
		),
	"contactgroup" => array(
		"hostgroup" => array("contact_groups"),
		"service" => array("contact_groups"),
		"serviceescalation" => array("contact_groups"),
		),
	);

#
# $confobject = array(
#	'scope'	=> array(
#		'propertyname' => array('inputtype','defaultvalue', required)
#	);
$confobjects = array(
 'host' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
	'host_name'	=> array('string', '',TRUE),
	'alias'		=> array('string', '',TRUE),
	'address'	=> array('string', '',TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplhost','',FALSE),
	'max_check_attempts' => array('number','',TRUE),
	'notification_interval' => array('number','',TRUE),
	'notification_period' => array('timeperiod','',TRUE),
	'notification_options' => array('notoptshost','',TRUE),
	'notifications_enabled' => array('yesno','1',FALSE),
	'check_command' => array('command', '',FALSE),
	'checks_enabled' => array('yesno', '',FALSE),
	'event_handler' => array('command', '',FALSE),
	'event_handler_enabled' => array('yesno','',FALSE),
	'low_flap_threshold' => array('number','',FALSE),
	'high_flap_threshold' => array('number','',FALSE),
	'flap_detection_enabled' => array('yesno','',FALSE),
	'process_perf_data' => array('yesno','',FALSE),
	'retain_status_information' => array('yesno','',FALSE),
	'retain_nonstatus_information' => array('yesno','',FALSE),
	'stalking_options' => array('stalkopts','',FALSE),
	'parents'	=> array('hostcommalist','',FALSE),
	),
 'hostgroup' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
 	'hostgroup_name' => array('string','',TRUE),
	'alias' => array('string','','TRUE'),
	'name' => array('string','',TRUE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplhostgroup','',FALSE),
	'contact_groups' => array('contactgroupcommalist','','TRUE'),
	'members' => array('hostcommalist','',TRUE)
 	),
 'service' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
 	'host_name' => array('host','',TRUE),
 	'service_description' => array('string','',TRUE),
 	'check_command' => array('command','',TRUE),
	'name' => array('string','',TRUE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplservice','',FALSE),
 	'max_check_attempts' => array('number','',TRUE),
 	'normal_check_interval' => array('number','',TRUE),
 	'retry_check_interval' => array('number','',TRUE),
	'active_checks_enabled' => array('yesno','',FALSE),
	'check_period' => array('timeperiod','',TRUE),
	'passive_checks_enabled' => array('yesno','',FALSE),
	'parallelize_check' => array('yesno','',FALSE),
	'obsess_over_service' => array('yesno','',FALSE),
	'check_freshness' => array('yesno','',FALSE),
 	'freshness_threshold' => array('number','',FALSE),
 	'event_handler' => array('command','',FALSE),
	'event_handler_enabled' => array('yesno','',FALSE),
 	'low_flap_threshold' => array('number','',FALSE),
 	'high_flap_threshold' => array('number','',FALSE),
 	'flap_detection_enabled' => array('yesno','',FALSE),
 	'process_perf_data' => array('yesno','',FALSE),
 	'retain_status_information' => array('yesno','',FALSE),
 	'retain_nonstatus_information' => array('yesno','',FALSE),
 	'notification_interval' => array('number','',TRUE),
	'notification_period' => array('timeperiod','',TRUE),
	'notification_options' => array('notsrvcnt','',TRUE),
 	'notifications_enabled' => array('yesno','',FALSE),
	'contact_groups' => array('contactgroupcommalist','',TRUE),
	'stalking_options' => array('stalksrvopts','',FALSE)
	),
 'serviceescalation' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
 	'service_description' => array('servicewildcard','',TRUE),
 	'host_name' => array('hostwildcardcommalist','',FALSE),
	'hostgroup_name' => array('hostgroupwildcardcommalist','',FALSE),
 	'first_notification' => array('number','',TRUE),
 	'last_notification' => array('number','',TRUE),
	'contact_groups' => array('contactgroupcommalist','',TRUE),
 	'notification_interval' => array('number','',TRUE),
    ),
 'contact' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
	'contact_name'	=> array('string', '',TRUE),
	'alias'		=> array('string', '',TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplcontact','',FALSE),
	'host_notification_period' => array('timeperiod','',TRUE),
	'host_notification_options' => array('nothstcnt','',TRUE),
	'host_notification_commands' => array('commandcommalist','',FALSE),
	'service_notification_period' => array('timeperiod','',TRUE),
	'service_notification_options' => array('notsrvcnt','',TRUE),
	'service_notification_commands' => array('commandcommalist','',FALSE),
	'email' => array('string','',FALSE),
	'pager' => array('string','',FALSE)
 	),
 'contactgroup' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
 	'contactgroup_name' => array('string','',TRUE),
	'alias' => array('string','','TRUE'),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplcontactgroup','',FALSE),
	'members' => array('contactcommalist','',TRUE)
 	),
 'timeperiod' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
 	'timeperiod_name' => array('string','',TRUE),
	'alias' => array('string','',TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tpltimeperiod','',FALSE),
	'sunday' => array('timerangs','',FALSE),
	'monday' => array('timerangs','',FALSE),
	'tuesday' => array('timerangs','',FALSE),
	'wednesday' => array('timerangs','',FALSE),
	'thursday' => array('timerangs','',FALSE),
	'friday' => array('timerangs','',FALSE),
	'saturday' => array('timerangs','',FALSE)
 	),
  'command' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
	'command_name' => array('string','',TRUE),
	'command_line' => array('cmdline','',TRUE)
  	),
  'hostextinfo' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
  	'host_name' => array('host','',TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplhostextinfo','',FALSE),
	'notes_url' => array('string','',FALSE),
	'icon_image' => array('iconimage','',FALSE),
	'icon_image_alt' => array('string','',FALSE),
	'vrml_image' => array('vrmlimage','',FALSE),
	'statusmap_image' => array('statusimage','',FALSE),
	'2d_coords' => array('xy','',FALSE),
	'3d_coords' => array('xyz','',FALSE)
  	),
  'serviceextinfo' => array(
	'__cfgfile'	=> array('cfgfile','',TRUE),
  	'host_name' => array('host','',TRUE),
	'service_name' => array('service','',TRUE),
	'name'	=> array('string', '', FALSE),
	'register' => array('yesno','1', FALSE),
	'use' => array('tplserviceextinfo','',FALSE),
	'notes_url' => array('string','',FALSE),
	'icon_image' => array('iconimage','',FALSE),
	'icon_image_alt' => array('string','',FALSE)
  	),
  'nagioscfg' => array(
	'log_file' => array('string','',TRUE),
	'cfg_file' => array('multistring','',FALSE),
	'cfg_dir' => array('multistring','',FALSE),
	'resource_file' => array('multistring','',FALSE),
	'temp_file' => array('string','',TRUE),
	'status_file' => array('string','',TRUE),
	'aggregate_status_updates' => array('yesno','1',FALSE),
	'status_update_interval' => array('number','',FALSE),
	'nagios_user' => array('string','',TRUE),
	'nagios_group' => array('string','',TRUE),
	'enable_notifications' => array('yesno','1',FALSE),
	'execute_service_checks' => array('yesno','1',FALSE),
	'accept_passive_service_checks' => array('yesno','1',FALSE),
	'enable_event_handlers' => array('yesno','1',FALSE),
	'log_rotation_method' => array('logrotate','n',FALSE),
	'log_archive_path' => array('string','',FALSE),
	'check_external_commands' => array('yesno','0',FALSE),
	'command_check_interval' => array('number','',TRUE),
	'comment_file' => array('string','',TRUE),
	'downtime_file' => array('string','',TRUE),
	'command_file' => array('string','',TRUE),
	'lock_file' => array('string','',TRUE),
	'retain_state_information' => array('string','0',TRUE),
	'state_retention_file' => array('string','',TRUE),
	'retention_update_interval' => array('string','',TRUE),
	'use_retained_program_state' => array('yesno','1',TRUE),
	'use_syslog' => array('yesno','',TRUE),
	'log_notifications' => array('yesno','',FALSE),
	'log_service_retries' => array('yesno','',FALSE),
	'log_host_retries' => array('yesno','',FALSE),
	'log_event_handlers' => array('yesno','',FALSE),
	'log_initial_states' => array('yesno','0',FALSE),
	'log_external_commands' => array('yesno','1',FALSE),
	'log_passive_service_checks' => array('yesno','1',FALSE),
	'global_host_event_handler' => array('command','',FALSE),
	'global_service_event_handler' => array('command','',FALSE),
	'sleep_time' => array('number','',TRUE),
	'inter_check_delay_method' => array('intercheck','s',FALSE),
	'service_interleave_factor' => array('interleavefact','s',FALSE),
	'max_concurrent_checks' => array('number','',FALSE),
	'service_reaper_frequency' => array('number','',TRUE),
	'interval_length' => array('number','60',FALSE),
	'use_agressive_host_checking' => array('yesno','0',FALSE),
	'enable_flap_detection' => array('yesno','0',FALSE),
	'low_service_flap_threshold' => array('number','',TRUE),
	'high_service_flap_threshold' => array('number','',TRUE),
	'low_host_flap_threshold' => array('number','',TRUE),
	'high_host_flap_threshold' => array('number','',TRUE),
	'soft_state_dependencies' => array('yesno','0',FALSE),
	'service_check_timeout' => array('number','',TRUE),
	'host_check_timeout' => array('number','',TRUE),
	'event_handler_timeout' => array('number','',TRUE),
	'notification_timeout' => array('number','',TRUE),
	'ocsp_timeout' => array('number','',TRUE),
	'perfdata_timeout' => array('number','',TRUE),
	'obsess_over_services' => array('yesno','0',FALSE),
	'ocsp_command' => array('command','',FALSE),
	'process_performance_data' => array('yesno','0',FALSE),
	'check_for_orphaned_services' => array('yesno','0',FALSE),
	'check_service_freshness' => array('yesno','1',FALSE),
	'freshness_check_interval' => array('number','1',TRUE),
	'admin_email' => array('string','',TRUE),
	'admin_pager' => array('string','',TRUE),
	'date_format' => array('dateformat','us',FALSE)
	),
  'cgicfg' => array(
	'authorized_for_all_host_commands' => array('users','',FALSE),
	'authorized_for_all_hosts' => array('users','',FALSE),
	'authorized_for_all_service_commands' => array('users','',FALSE),
	'authorized_for_all_services' => array('users','',FALSE),
	'authorized_for_configuration_information' => array('users','',FALSE),
	'authorized_for_system_commands' => array('users','',FALSE),
	'authorized_for_system_information' => array('users','',FALSE),
	'default_statusmap_layout' => array('string','',FALSE),
	'default_statuswrl_layout' => array('string','',FALSE),
	'main_config_file' => array('string','',FALSE),
	'physical_html_path' => array('string','',FALSE),
	'process_check_command' => array('string','',FALSE),
	'refresh_rate' => array('string','',FALSE),
	'url_html_path' => array('string','',FALSE),
	'use_authentication' => array('string','',FALSE),
	'xcddb_database' => array('string','',FALSE),
	'xcddb_host' => array('string','',FALSE),
	'xcddb_password' => array('password','',FALSE),
	'xcddb_port' => array('string','',FALSE),
	'xcddb_username' => array('string','',FALSE),
	'xdddb_database' => array('string','',FALSE),
	'xdddb_host' => array('string','',FALSE),
	'xdddb_password' => array('password','',FALSE),
	'xdddb_port' => array('string','',FALSE),
	'xdddb_username' => array('string','',FALSE),
	'xeddb_database' => array('string','',FALSE),
	'xeddb_host' => array('string','',FALSE),
	'xeddb_password' => array('password','',FALSE),
	'xeddb_port' => array('string','',FALSE),
	'xeddb_username' => array('string','',FALSE),
	'xsddb_database' => array('string','',FALSE),
	'xsddb_host' => array('string','',FALSE),
	'xsddb_password' => array('password','',FALSE),
	'xsddb_port' => array('string','',FALSE),
	'xsddb_username' => array('string','',FALSE)
	)
);

$propoptions = array(
 'notoptshost' => array(
	'd' => 'send on a down state',
	'u' => 'send on an unreachable state',
	'r' => 'send notifications on recoveries (up state)'
	),
 'stalkopts' => array(
 	'o' => 'stalk on up states',
	'd' => 'stalk on down states',
	'u' => 'stalk on unreachable states'
 	),
 'stalksrvopts' => array(
 	'o' => 'stalk on ok states',
	'w' => 'stalk on warning states',
	'u' => 'stalk on unknown states',
	'c' => 'stalk on critical states'
 	),
 'notsrvcnt' => array(
	'w' => 'notify on warning service state',
	'u' => 'notify on unknown service states',
	'c' => 'notify on critical service states',
	'r' => 'notify on service recoveries (ok state)'
 	),
 'nothstcnt' => array(
 	'd' => 'notify on down host state',
	'u' => 'notify on unreachable host states',
	'r' => 'send notifications on recoveries (up state)'
	),
 'dateformat' => array(
 	'us' => 'us (MM-DD-YYYY HH:MM:SS)',
	'euro' => 'euro (DD-MM-YYYY HH:MM:SS)',
	'iso8601' => 'iso8601 (YYYY-MM-DD HH:MM:SS)',
	'strict-iso8601' => 'strict-iso8601 (YYYY-MM-DDTHH:MM:SS)'
 	),
 'intercheck' => array(
	's' => 'Use "smart" inter-check delay calculation',
	'n' => "None - don't use any delay between checks",
	'd' => 'Use a "dumb" delay of 1 second between checks',
	'x' => 'interleave factor: :numberinput: seconds'
 	),
 'interleavefact' => array(
	's' => 'Use "smart" interleave factor calculation',
	'x' => 'interleave factor: :numberinput:'
 	)
);

$cfgnagios = array(
  'accept_passive_service_checks' => array('yesno','',TRUE),
  'admin_email' => array('string','',TRUE),
  'admin_pager' => array('string','',TRUE),
  'aggregate_status_updates' => array('string','',TRUE),
  'cfg_file' => array('string','',TRUE),
  'check_external_commands' => array('string','',TRUE),
  'check_for_orphaned_services' => array('string','',TRUE),
  'check_service_freshness' => array('string','',TRUE),
  'command_check_interval' => array('string','',TRUE),
  'command_file' => array('string','',TRUE),
  'comment_file' => array('string','',TRUE),
  'date_format' => array('string','',TRUE),
  'downtime_file' => array('string','',TRUE),
  'enable_event_handlers' => array('string','',TRUE),
  'enable_flap_detection' => array('string','',TRUE),
  'enable_notifications' => array('string','',TRUE),
  'event_handler_timeout' => array('string','',TRUE),
  'execute_service_checks' => array('string','',TRUE),
  'freshness_check_interval' => array('string','',TRUE),
  'high_host_flap_threshold' => array('string','',TRUE),
  'high_service_flap_threshold' => array('string','',TRUE),
  'host_check_timeout' => array('string','',TRUE),
  'inter_check_delay_method' => array('string','',TRUE),
  'interval_length' => array('string','',TRUE),
  'lock_file' => array('string','',TRUE),
  'log_archive_path' => array('string','',TRUE),
  'log_event_handlers' => array('string','',TRUE),
  'log_external_commands' => array('string','',TRUE),
  'log_file' => array('string','',TRUE),
  'log_host_retries' => array('string','',TRUE),
  'log_initial_states' => array('string','',TRUE),
  'log_notifications' => array('string','',TRUE),
  'log_passive_service_checks' => array('string','',TRUE),
  'log_rotation_method' => array('string','',TRUE),
  'log_service_retries' => array('string','',TRUE),
  'low_host_flap_threshold' => array('string','',TRUE),
  'low_service_flap_threshold' => array('string','',TRUE),
  'max_concurrent_checks' => array('string','',TRUE),
  'nagios_group' => array('string','',TRUE),
  'nagios_user' => array('string','',TRUE),
  'notification_timeout' => array('string','',TRUE),
  'obsess_over_services' => array('string','',TRUE),
  'ocsp_timeout' => array('string','',TRUE),
  'perfdata_timeout' => array('string','',TRUE),
  'process_performance_data' => array('string','',TRUE),
  'resource_file' => array('string','',TRUE),
  'retain_state_information' => array('string','',TRUE),
  'retention_update_interval' => array('string','',TRUE),
  'service_check_timeout' => array('string','',TRUE),
  'service_interleave_factor' => array('string','',TRUE),
  'service_reaper_frequency' => array('string','',TRUE),
  'sleep_time' => array('string','',TRUE),
  'state_retention_file' => array('string','',TRUE),
  'status_file' => array('string','',TRUE),
  'status_update_interval' => array('string','',TRUE),
  'temp_file' => array('string','',TRUE),
  'use_agressive_host_checking' => array('string','',TRUE),
  'use_retained_program_state' => array('string','',TRUE),
  'use_syslog' => array('string','',TRUE)
);

?>
