/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting;

import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportImpl;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.coverage.reporting.collation.StaticFileCollator;
import com.jcoverage.coverage.reporting.html.MultiViewStaticHtmlFormat;
import com.jcoverage.reporting.FileSerializer;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.Report;
import com.jcoverage.util.ClassHelper;
import java.io.File;
import org.apache.log4j.Logger;

public class ReportDriver {
    static final Logger logger = Logger.getLogger((Class)(class$com$jcoverage$coverage$reporting$ReportDriver == null ? (class$com$jcoverage$coverage$reporting$ReportDriver = ReportDriver.class$("com.jcoverage.coverage.reporting.ReportDriver")) : class$com$jcoverage$coverage$reporting$ReportDriver));
    File javaSourceDirectory;
    Report report = new ReportImpl();
    Page indexPage;
    static /* synthetic */ Class class$com$jcoverage$coverage$reporting$ReportDriver;

    public ReportDriver(File javaSourceDirectory) {
        this.javaSourceDirectory = javaSourceDirectory;
        this.indexPage = this.report.createFrontPage();
    }

    public synchronized void addInstrumentation(String clzName, Instrumentation instrumentation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("clzName: " + clzName));
        }
        if (!ReportDriver.isInnerClass(clzName)) {
            String id = ReportDriver.getSourceFileId(clzName, instrumentation);
            String sourcePath = id.replace('.', '/') + ".java";
            String packageName = ClassHelper.getPackageName(id);
            if (packageName.equals("")) {
                packageName = "default";
            }
            Line packageLine = this.indexPage.lookupLineByField(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY, ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, packageName);
            Page packageDetailPage = null;
            if (packageLine == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new line for packagename " + packageName));
                }
                packageLine = this.indexPage.createLine(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY);
                packageLine.setField(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, packageName);
                packageDetailPage = packageLine.openDetailPage();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found existing line for packagename " + packageName));
                }
                packageDetailPage = packageLine.getDetailPage();
            }
            Line javaFileLine = packageDetailPage.lookupLineByField(PackageSummaryPage.CATEGORY_JAVAFILES, JavaFileLine.COLUMN_FILE_NAME, clzName);
            Page javaFileDetailPage = null;
            if (javaFileLine == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new line for class " + clzName));
                }
                javaFileLine = packageDetailPage.createLine(PackageSummaryPage.CATEGORY_JAVAFILES);
                javaFileLine.setField(JavaFileLine.COLUMN_FILE_NAME, clzName);
                javaFileLine.setField(JavaFileLine.COLUMN_PATH, new File(this.javaSourceDirectory, sourcePath).getAbsolutePath());
                javaFileDetailPage = javaFileLine.openDetailPage();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found existing line for class " + clzName));
                }
                javaFileDetailPage = javaFileLine.getDetailPage();
            }
            this.indexPage.addLineReference(javaFileLine, PackageSummaryPage.CATEGORY_JAVAFILES);
            ((JavaFilePage)javaFileDetailPage).addInstrumentation(instrumentation);
        }
    }

    public void generate(File outputDir) throws Exception {
        StaticFileCollator collator = new StaticFileCollator(".html");
        this.report.setCollator(collator);
        MultiViewStaticHtmlFormat htmlFormat = new MultiViewStaticHtmlFormat();
        FileSerializer serializer = new FileSerializer(outputDir);
        collator.addOutputter(htmlFormat, serializer);
        this.indexPage.close();
    }

    public static String getSourceFileId(String clzName, Instrumentation instrumentation) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("clzName: " + clzName));
        }
        if (ReportDriver.isInnerClass(clzName)) {
            throw new IllegalStateException("Cannot call this method (getSourceFileId) for an inner class");
        }
        String pkgname = ClassHelper.getPackageName(clzName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("pkgname: " + pkgname));
        }
        if (instrumentation.getSourceFileName() == null) {
            logger.fatal((Object)"Incomplete jcoverage.ser instrumentation. Do you need to merge?");
            return clzName;
        }
        if (pkgname.equals("")) {
            return ReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
        }
        return pkgname + "." + ReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
    }

    public static String stripJavaSuffix(String s) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("s: " + s));
        }
        return s.substring(0, s.length() - ".java".length());
    }

    public static boolean isInnerClass(String clzName) {
        return clzName.indexOf("$") != -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

