--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Conversion;
with GNAT.Sockets;
with Interfaces;

package Socket_Handling is

   type Local_Socket_Type is new Integer;

   function To_Local_Socket is new Ada.Unchecked_Conversion
     (GNAT.Sockets.Socket_Type, Local_Socket_Type);
   type Fichier_Descripteur_Set is private;

   Fichier_Descripteur_Set_Nul : constant Fichier_Descripteur_Set;
   procedure Fd_Clr (Fd : Local_Socket_Type;
                     Ensemble_Descripteur : in out Fichier_Descripteur_Set);
   function Fd_Isset (Fd : Local_Socket_Type;
                      Ensemble_Descripteur : Fichier_Descripteur_Set)
                     return Boolean;
   procedure Fd_Set (Fd : Local_Socket_Type;
                     Ensemble_Descripteur : in out Fichier_Descripteur_Set);
   procedure Fd_Zero (Ensemble_Descripteur : in out Fichier_Descripteur_Set);

   type Timeval is record
      Tv_Sec : Integer;
      Tv_Usec : Integer;
   end record;
   pragma Convention (C, Timeval);

   procedure Fichier_Accessible
     (Nombre_De_Descripteurs_Touches : out Integer;
      Descripteurs_En_Lecture : in out Fichier_Descripteur_Set;
      Descripteurs_En_Ecriture : in out Fichier_Descripteur_Set;
      Descripteurs_En_Exception : in out Fichier_Descripteur_Set;
      Temp_Timeout : Timeval);

private
   type Fichier_Descripteur_Set is array (Local_Socket_Type range 0 .. 31)
     of Interfaces.Unsigned_32;
   pragma Convention (C, Fichier_Descripteur_Set);
   Fichier_Descripteur_Set_Nul : constant Fichier_Descripteur_Set :=
     (others => 0);
end Socket_Handling;
