--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Interfaces.C;
with System;
package body System_Calls is

   ------------------------
   -- Execution_Commande --
   ------------------------

   function Exec_Command (Command : String) return Integer is
      C_Command : aliased String := Command & ASCII.NUL;
      function C_System (Command : System.Address) return Interfaces.C.int;
      pragma Import (C, C_System, "system");
      use type Interfaces.C.int;
   begin
      return Integer (C_System (C_Command'Address) / 256);
   end Exec_Command;

   procedure Exec_Command (Command : String) is
      pragma Warnings (Off);
      C_System_Return : Integer;
   begin
      C_System_Return := Exec_Command (Command);
   end Exec_Command;
end System_Calls;
