--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

with Exception_Message;
with Ok_Message;
with Ok_With_Message;

with Narval.Narval_Naming_Registry;
with Narval.Configurator.Abstract_Actors_Coordination;

with McKae.XML.EZ_Out.String_Stream;

package body Send_Order_Command is

   use Ada.Strings.Unbounded;
   use Narval.Configurator.Abstract_Actors_Coordination;

   ----------------
   -- Send_Order --
   ----------------

   function Send_Order (Shell_Line : String) return String is
   begin
      declare
         Arguments : constant Shell_Commands.Arguments_Array :=
           Shell_Commands.Arguments (Shell_Line);
         use Narval;
         Config : Configuration_Access;
      begin
         if Arguments'Length /= 2 then
            return Syntax_String;
         end if;
         Config := Narval_Naming_Registry.Get_Configuration
           (To_String (Arguments (1)));
         if Arguments (2) /= "finish" then
            Configurator.Abstract_Actors_Coordination.Change_State
              (Config, Action'Value (To_String (Arguments (2))));
            return Ok_With_Message
              ("send_order",
               Sub_System_Name => To_String (Arguments (1)),
               Message => To_String (Arguments (2)));
         else
            End_Actor_Handler (Config);
            return Ok_Message ("send_order",
                               Sub_System_Name => To_String (Arguments (1)));
         end if;
      end;
   exception
      when Shell_Commands.No_Argument =>
         return Syntax_String;
      when E : others =>
         return Exception_Message ("send_order", E);
   end Send_Order;

   function Special_Domi (Shell_Line : String) return String is
   begin
      declare
         Arguments : constant Shell_Commands.Arguments_Array :=
           Shell_Commands.Arguments (Shell_Line);
         Config : Configuration_Access;
      begin
         if Arguments'Length /= 1 then
            return "<error><severity>WARNING</severity>" &
              "<msg>special_domi need one argument</msg></error>";
         end if;
         Config := Narval.Narval_Naming_Registry.Get_Configuration
           (To_String (Arguments (1)));
         Special_Domi (Config);
         return "<result cmd=""special_domi"">" & Get_Xml (Config, "state") &
           "</result>";
      end;
   end Special_Domi;

   function Syntax_String
     (Status : Shell_Commands.Status_Type := Shell_Commands.Syntax_Error)
     return String is
      use McKae.XML.EZ_Out.String_Stream.String_Buffering;
      use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
      Xml_Buffer : String_Buffer;
   begin
      Clear (Xml_Buffer);
      Start_Element (Xml_Buffer, "result",
                     ("cmd" = "send_order", "status" = Status'Img));
      Start_Element (Xml_Buffer, "message", "type" = "help");
      Output_Element (Xml_Buffer, "syntax",
                      "send_order sub_system_name {action|finish}");
      End_Element (Xml_Buffer, "message");
      End_Element (Xml_Buffer, "result");
      declare
         String_To_Return : constant String := Get_String (Xml_Buffer);
      begin
         Full_Clear (Xml_Buffer);
         return String_To_Return;
      end;
   end Syntax_String;

end Send_Order_Command;
