/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * LADSPA bridge
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NALADSPA_LRDF_H
#define _NALADSPA_LRDF_H

#include <NASPRO/core/lib.h>

void _naladspa_lrdf_load_all();
void _naladspa_lrdf_unload_all();
void _naladspa_lrdf_get_classes(struct nacore_descriptor *desc);
void _naladspa_lrdf_get_scale_defaults(struct nacore_descriptor *desc,
				     struct nacore_port_descriptor *port_descs);
void _naladspa_lrdf_get_scale_points(struct nacore_descriptor *desc,
				     struct nacore_port_descriptor *port,
				     size_t index);
void _naladspa_lrdf_get_scale_units(struct nacore_descriptor *desc,
				    struct nacore_port_descriptor *port,
				    size_t index);
void _naladspa_lrdf_free_data(struct nacore_port_descriptor *port);

#endif /* !_NALADSPA_LRDF_H */
