/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * LADSPA bridge
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _NALADSPA_LV2API_H
#define _NALADSPA_LV2API_H

#include <stdlib.h>

#include <lv2.h>

LV2_Handle _naladspa_lv2api_instantiate(const LV2_Descriptor *descriptor,
					double sample_rate,
					const char *bundle_path,
					const LV2_Feature * const *features);
void _naladspa_lv2api_connect_port(LV2_Handle instance, uint32_t port,
				   void *data_location);
void _naladspa_lv2api_activate(LV2_Handle instance);
void _naladspa_lv2api_run(LV2_Handle instance, uint32_t sample_count);
void _naladspa_lv2api_deactivate(LV2_Handle instance);
void _naladspa_lv2api_cleanup(LV2_Handle instance);

int _naladspa_lv2api_generate_descs();
void _naladspa_lv2api_free_descs();

#endif /* !_NALADSPA_LV2API_H */
