/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2012 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _POSIX_C_SOURCE	200809L

#include "internal.h"

#include <semaphore.h>

_NACORE_DEF nacore_sem
nacore_sem_new(unsigned int value)
{
	nacore_sem ret;
	
	ret = malloc(sizeof(sem_t));
	if (ret == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	if (sem_init((sem_t *)ret, 0, value) != 0)
	  {
		free(ret);
		errno = EINVAL;
		return NULL;
	  }

	return ret;
}

_NACORE_DEF void
nacore_sem_free(nacore_sem sem)
{
	sem_destroy((sem_t *)sem);

	free(sem);
}

_NACORE_DEF int
nacore_sem_wait(nacore_sem sem)
{
	return (sem_wait((sem_t *)sem) != 0) ? EINTR : 0;
}

_NACORE_DEF int
nacore_sem_trywait(nacore_sem sem)
{
	return (sem_trywait((sem_t *)sem) != 0) ? errno : 0;
}

_NACORE_DEF int
nacore_sem_post(nacore_sem sem)
{
	sem_post((sem_t *)sem);
	
	return 0;
}
