/* $Id: Seq_interval.hpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#ifndef OBJECTS_SEQLOC_SEQ_INTERVAL_HPP
#define OBJECTS_SEQLOC_SEQ_INTERVAL_HPP


// generated includes
#include <objects/seqloc/Seq_interval_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_SEQLOC_EXPORT CSeq_interval : public CSeq_interval_Base
{
    typedef CSeq_interval_Base Tparent;
public:
    // See also related function in util/sequence.hpp:
    //
    //   bool IsValid(const CSeq_interval&, CScope*)
    //

    // constructor
    CSeq_interval(void);
    CSeq_interval(TId& id, TFrom from, TTo to, TStrand strand = eNa_strand_unknown);

    // destructor
    ~CSeq_interval(void);

    // Get the length of the interval
    TSeqPos GetLength(void) const;

    // check start or stop end of location for e_Lim fuzz
    bool IsPartialStart(ESeqLocExtremes ext) const;
    bool IsPartialStop (ESeqLocExtremes ext) const;

    // set / remove e_Lim fuzz on start or stop end
    void SetPartialStart(bool val, ESeqLocExtremes ext);
    void SetPartialStop (bool val, ESeqLocExtremes ext);

    /// check if parts of the seq-loc are missing
    bool IsTruncatedStart(ESeqLocExtremes ext) const;
    bool IsTruncatedStop (ESeqLocExtremes ext) const;

    /// set / remove e_Lim fuzz on start or stop
    /// (tl/tr - indicating removed parts of the seq-loc)
    void SetTruncatedStart(bool val, ESeqLocExtremes ext);
    void SetTruncatedStop (bool val, ESeqLocExtremes ext);

    TSeqPos GetStart(ESeqLocExtremes ext) const;
    TSeqPos GetStop (ESeqLocExtremes ext) const;

    // Flip the strand (e.g. plus to minus)
    void FlipStrand(void);
        
private:
    // Prohibit copy constructor & assignment operator
    CSeq_interval(const CSeq_interval&);
    CSeq_interval& operator= (const CSeq_interval&);

    bool x_IsMinusStrand(void) const;
};



/////////////////// CSeq_interval inline methods

// constructor
inline
CSeq_interval::CSeq_interval(void)
{
}


inline
CSeq_interval::CSeq_interval(TId& id, TFrom from, TTo to, TStrand strand)
{
    SetId(id);
    SetFrom(from);
    SetTo(to);
    if ( strand != eNa_strand_unknown ) {
        SetStrand(strand);
    }
}


// length return
inline
TSeqPos CSeq_interval::GetLength(void) const
{
    return GetTo() >= GetFrom() ? ((GetTo() - GetFrom()) + 1) : 0;
}

/////////////////// end of CSeq_interval inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_INTERVAL_HPP
