/* $Id: Pub_set.cpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'pub.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/pub/Pub_set.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPub_set::~CPub_set(void)
{
}

// Handles looping thru list of pub, medline, article, journal, book, 
// proceeding, or patent, creating a label by concatenting labels
// for objects in the list
template <class T>
static bool s_GetLabel(string* label, const list<CRef<T> >& the_list,
                       CPub_set::TLabelFlags flags,
                       CPub_set::ELabelVersion version)
{
    bool first = true;
    ITERATE(typename list<CRef<T> >, it, the_list) {
        if (!first) {
            *label += ",";
        }
        first &= !(*it)->GetLabel(label, flags, version);
    }
    return !first;
}

// Determines the type of set and calls the appropriately instantiated
// s_GetLabel
bool CPub_set::GetLabel(string* label, TLabelFlags flags,
                        ELabelVersion version) const
{
    // Ensure label exists
    if (!label) {
        return false;
    }
    
    switch (Which()) {
    case e_Pub:
        return s_GetLabel<CPub>(label, GetPub(), flags, version);
    case e_Medline:
        return s_GetLabel<CMedline_entry>(label, GetMedline(), flags, version);
    case e_Article:
        return s_GetLabel<CCit_art>(label, GetArticle(), flags, version);
    case e_Journal:
        return s_GetLabel<CCit_jour>(label, GetJournal(), flags, version);
    case e_Book:
        return s_GetLabel<CCit_book>(label, GetBook(), flags, version);
    case e_Proc:
        return s_GetLabel<CCit_proc>(label, GetProc(), flags, version);
    case e_Patent:
        return s_GetLabel<CCit_pat>(label, GetPatent(), flags, version);
    default:
        return false;
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1874, CRC32: 8b72a069 */
