/* $Id: Seq_point.cpp 371868 2012-08-13 15:10:25Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */
#include <ncbi_pch.hpp>
#include <objects/seqloc/Seq_point.hpp>
#include <objects/general/Int_fuzz.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


// destructor
CSeq_point::~CSeq_point(void)
{
}


bool CSeq_point::x_IsMinusStrand(void) const
{
    ENa_strand strand = eNa_strand_unknown;
    if ( IsSetStrand() ) {
        strand = GetStrand();
    }
    return (strand == eNa_strand_minus)  ||  (strand == eNa_strand_both_rev);
}


bool CSeq_point::IsPartialStart(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
        CInt_fuzz::eLim_gt : CInt_fuzz::eLim_lt;
    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}


bool CSeq_point::IsPartialStop(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
        CInt_fuzz::eLim_lt : CInt_fuzz::eLim_gt;
    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}

bool CSeq_point::IsLeftOf (void) const
{
    if (IsSetFuzz()  &&  GetFuzz().IsLim()) {
        CInt_fuzz::TLim lim = GetFuzz().GetLim();
        return x_IsMinusStrand() ?
            lim == CInt_fuzz::eLim_tr : lim == CInt_fuzz::eLim_tl;
    }
    return false;
}

bool CSeq_point::IsRightOf (void) const
{
    if (IsSetFuzz()  &&  GetFuzz().IsLim()) {
        CInt_fuzz::TLim lim = GetFuzz().GetLim();
        return x_IsMinusStrand() ?
            lim == CInt_fuzz::eLim_tl : lim == CInt_fuzz::eLim_tr;
    }
    return false;
}


// set / remove e_Lim fuzz on left (5') or right (3') end
void CSeq_point::SetPartialStart(bool val, ESeqLocExtremes ext)
{
    if (val == IsPartialStart(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
            CInt_fuzz::eLim_gt : CInt_fuzz::eLim_lt;
        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


void CSeq_point::SetPartialStop (bool val, ESeqLocExtremes ext)
{
    if (val == IsPartialStop(ext)) {
        return;
    }
    if (val) {
        CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
            CInt_fuzz::eLim_lt : CInt_fuzz::eLim_gt;
        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


bool CSeq_point::IsTruncatedStart(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
        CInt_fuzz::eLim_tr : CInt_fuzz::eLim_tl;
    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}


bool CSeq_point::IsTruncatedStop(ESeqLocExtremes ext) const
{
    CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
        CInt_fuzz::eLim_tl : CInt_fuzz::eLim_tr;
    return IsSetFuzz()  &&  GetFuzz().IsLim()  &&  GetFuzz().GetLim() == lim;
}


void CSeq_point::SetTruncatedStart(bool val, ESeqLocExtremes ext)
{
    if (val == IsTruncatedStart(ext)) {
        return;
    }

    if (val) {
        CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
            CInt_fuzz::eLim_tr : CInt_fuzz::eLim_tl;
        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


void CSeq_point::SetTruncatedStop (bool val, ESeqLocExtremes ext)
{
    if (val == IsTruncatedStop(ext)) {
        return;
    }
    if (val) {
        CInt_fuzz::TLim lim = (x_IsMinusStrand()  &&  ext == eExtreme_Biological) ?
            CInt_fuzz::eLim_tl : CInt_fuzz::eLim_tr;
        SetFuzz().SetLim(lim);
    } else {
        ResetFuzz();
    }
}


void CSeq_point::SetLeftOf(bool val)
{
    if (val == IsLeftOf()) {
        return;
    }

    if (val) {
        SetFuzz().SetLim(x_IsMinusStrand() ? CInt_fuzz::eLim_tr : CInt_fuzz::eLim_tl);
    } else {
        ResetFuzz();
    }
    _ASSERT(val == IsLeftOf());
}


void CSeq_point::SetRightOf(bool val)
{
    if (val == IsRightOf()) {
        return;
    }

    if ( val ) {
        SetFuzz().SetLim(x_IsMinusStrand() ? CInt_fuzz::eLim_tl : CInt_fuzz::eLim_tr);
    } else {
        ResetFuzz();
    }
    _ASSERT(val == IsRightOf());
}


void CSeq_point::FlipStrand(void)
{
    if (IsSetStrand()) {
        SetStrand(Reverse(GetStrand()));
    }
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1886, CRC32: 5f7b1244 */
