/* $Id: SubSource.hpp 417374 2013-11-06 16:04:14Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @SubSource.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: SubSource_.hpp


#ifndef OBJECTS_SEQFEAT_SUBSOURCE_HPP
#define OBJECTS_SEQFEAT_SUBSOURCE_HPP


// generated includes
#include <objects/seqfeat/SubSource_.hpp>

// generated classes


// other includes
#include <objects/general/Date.hpp>
#include <objects/general/Date_std.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::
class CDate;
class CDate_std;

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CSubSource : public CSubSource_Base
{
    typedef CSubSource_Base Tparent;
public:
    // constructor
    CSubSource(void);
    CSubSource(TSubtype subtype, const TName& name);
    CSubSource(const string& subtype, const TName& name);

    // destructor
    ~CSubSource(void);

    void GetLabel(string* str) const;

    enum EVocabulary {
        eVocabulary_raw, // per ASN.1, except eSubtype_other <-> "note"
        eVocabulary_insdc // per GB/DDBJ/EMBL qualifier names
    };

    // convert subtype from string to enum.
    static TSubtype GetSubtypeValue(const string& str,
                                    EVocabulary vocabulary = eVocabulary_raw);

	// get name for subsource
    static string GetSubtypeName(CSubSource::TSubtype stype,
                                 EVocabulary vocabulary = eVocabulary_raw);

	  // identify whether subsource value should be blank
	  static bool NeedsNoText (const TSubtype& subtype);

    // some subsources are discouraged and should not be offered to the user as an option
    static bool IsDiscouraged (const TSubtype subtype);

	// read collection date from string
    static CRef<CDate> DateFromCollectionDate (const string& str) THROWS((CException));

    static void IsCorrectDateFormat(const string& date_string, bool& bad_format, bool& in_future);
    static string GetCollectionDateProblem (const string& date_string);

    static bool IsISOFormatDate (const string& orig_date);
    static CRef<CDate> GetDateFromISODate(const string& orig_date);

    /// Determine whether day number could occur in month.
    /// @param day   The number of the day, 1-based [in]
    /// @param month The number of the month, 1-based [in]
    /// @param year  The number of the year, 1-based [in]
    static bool IsDayValueOkForMonth(int day, int month, int year);

    /// Attempt to fix the format of the date
    /// Returns a blank if the format of the date cannot be determined
    /// @param orig_date The original date [in]
    /// Rules:
    /// First, check to see if the string matches the ISO format (YYYY-MM-DD);
    /// if so then just return original string as this is valid.
    /// Second, try to split the string into tokens using the following delimiters:
    ///      * space
    ///      * comma (,)
    ///      * dash (-)
    ///      * slash (/)
    ///      * underscore (_)
    ///      * equals (=)
    ///      * period (.)
    /// If more than three tokens are generated, fail and return empty string.
    /// Of the tokens that are generated, look for a token that contains letters.
    /// If there is such a token, this token is assumed to be the month, and will
    /// be checked to see if it begins with any of the three-letter abbreviations
    /// for months (Jan, Feb, Mar, etc.). If so, the month is known. If none of 
    /// the abbreviations produce a match, fail and return an empty string. If 
    /// more than one token that contains letters is found, return an empty string.
    /// If there are no tokens that contain letters, try to determine which token is
    /// the month by eliminating tokens that would be year or day.
    /// Any token that is a number and has a value greater than 31 will be assumed
    /// to be the year. If there is more than one such token, return an empty string.
    /// After making this initial pass, try to guess the identities of the remaining tokens.
    /// Numbers between 1 and 12 could be considered months, if no month token containing
    /// letters was already identified. If two or more such tokens are found, the date is 
    /// ambiguous: return an empty string, unless one of these two conditions are met:
    ///   a) the numbers are equal, in which case ambiguity about placement is irrelevant
    ///   b) if one token is NOT zero-padded and less than 10, and the other is 
    ///      either 10 or more or IS zero-padded, then the token that is not padded and
    ///      less than 10 is the day, and the other is the year, to which we should add 2000
    /// If a number is between 1 and 31, it could be considered the day. If two such tokens
    /// are found, the date is ambiguous: return an empty string.
    /// If there is a number that cannot be the month or the day, assume that this is the
    /// year. If the year is less than 100, this may be a two-digit representation. If
    /// 2000 + the value is not in the future, use this as the year, otherwise use
    /// 1900 + the value for the year.
    /// If all tokens can be identified, arrange them in the output string in one of the 
    /// following formats:
    /// YYYY
    /// Mmm-YYYY
    /// DD-Mmm-YYYY

    static string FixDateFormat(const string& orig_date);
    static string FixDateFormat(const string& orig_date, bool month_first, bool& month_ambiguous);
    static void IsCorrectLatLonFormat (string lat_lon, bool& format_correct, bool& precision_correct,
                                     bool& lat_in_range, bool& lon_in_range,
                                     double& lat_value, double& lon_value);
    static string FixLatLonFormat (string orig_lat_lon, bool guess = false);


private:
    // Prohibit copy constructor and assignment operator
    CSubSource(const CSubSource& value);
    CSubSource& operator=(const CSubSource& value);

};

/////////////////// CSubSource inline methods

// constructor
inline
CSubSource::CSubSource(void)
{
}

inline
CSubSource::CSubSource(TSubtype subtype, const TName& name)
{
    SetSubtype(subtype);
    SetName(name);
}

inline
CSubSource::CSubSource(const string& subtype, const TName& name)
{
    SetSubtype(GetSubtypeValue(subtype));
    SetName(name);
}


/////////////////// end of CSubSource inline methods


// =============================================================================
//                 Country Names (legal values found in country subtype)
// =============================================================================


class NCBI_SEQFEAT_EXPORT CCountries
{
public:
    static bool IsValid(const string& country);
    static bool IsValid(const string& country, bool& is_miscapitalized);
    static bool WasValid(const string& country);
    static bool WasValid(const string& country, bool& is_miscapitalized);
    static string CapitalizeFirstLetterOfEveryWord (const string &phrase);
    static string WholeCountryFix(string country);
    static bool IsSubstringOfStringInList(const string& phrase, const string& country1, int pos1);
    static bool ContainsMultipleCountryNames (const string &phrase);
    static string GetCorrectedCountryCapitalization(const string& country);
    static string NewFixCountry (const string& input);
    static string CountryFixupItem(const string &input, bool capitalize_after_colon);
private:
    static const string sm_Countries[];
    static const string sm_Former_Countries[];
    static void x_RemoveDelimitersFromEnds(string& val);
    static vector<string> x_Tokenize(const string& val);
};




END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQFEAT_SUBSOURCE_HPP
/* Original file checksum: lines: 94, chars: 2578, CRC32: 1c534244 */
