/*  $Id: common_tax.inc 523138 2016-12-28 19:53:42Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Colleen Bollin
 *
 * File Description:
 *   Built-in copy of common_tax.txt.
 *
 */

static const char* const kOrgRefList[] = {
    "Acacia koa\t-\t1\t1\t11\t468172\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Mimosoideae; Acacieae; Acacia",
    "Acanthisitta chloris\trifleman\t1\t2\t-\t57068\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Acanthisittidae; Acanthisitta",
    "Acanthoscurria geniculata\t-\t1\t5\t-\t575412\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Araneae; Mygalomorphae; Theraphosidae; Acanthoscurria",
    "Acinetobacter baumannii\t-\t11\t0\t-\t470\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Moraxellaceae; Acinetobacter; Acinetobacter calcoaceticus/baumannii complex",
    "Acinetobacter pittii\t-\t11\t0\t-\t48296\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Moraxellaceae; Acinetobacter; Acinetobacter calcoaceticus/baumannii complex",
    "Acinonyx jubatus\tcheetah\t1\t2\t-\t32536\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Acinonychinae; Acinonyx",
    "Acropora cervicornis\t-\t1\t4\t-\t6130\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Acropora digitifera\t-\t1\t4\t-\t70779\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Acropora millepora\t-\t1\t4\t-\t45264\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Acroporidae; Acropora",
    "Actias selene\tIndian moon moth\t1\t5\t-\t37776\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Saturniini; Actias",
    "Acyrthosiphon pisum\tpea aphid\t1\t5\t-\t7029\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidiformes; Aphidomorpha; Aphidoidea; Aphididae; Aphidinae; Macrosiphini; Acyrthosiphon",
    "Adineta vaga\t-\t1\t5\t-\t104782\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Rotifera; Bdelloidea; Adinetida; Adinetidae; Adineta",
    "Aedes aegypti\tyellow fever mosquito\t1\t5\t-\t7159\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Culicomorpha; Culicoidea; Culicidae; Culicinae; Aedini; Aedes; Stegomyia",
    "Aedes albopictus\tAsian tiger mosquito\t1\t5\t-\t7160\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Culicomorpha; Culicoidea; Culicidae; Culicinae; Aedini; Aedes; Stegomyia",
    "Aegilops tauschii\t-\t1\t1\t11\t37682\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Aegilops",
    "Aethina tumida\tsmall hive beetle\t1\t5\t-\t116153\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Cucujoidea; Nitidulidae; Nitidulinae; Aethina",
    "Agapanthus praecox subsp. orientalis\t-\t1\t1\t11\t547170\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Amaryllidaceae; Agapanthoideae; Agapanthus; Agapanthus praecox",
    "Agave deserti\t-\t1\t1\t11\t382119\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Asparagaceae; Agavoideae; Agave",
    "Agave tequilana\t-\t1\t1\t11\t386106\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Asparagaceae; Agavoideae; Agave",
    "Agrilus planipennis\temerald ash borer\t1\t5\t-\t224129\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Elateriformia; Buprestoidea; Buprestidae; Agrilinae; Agrilus",
    "Agrotis segetum\tturnip moth\t1\t5\t-\t47767\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Noctuinae; Agrotis",
    "Ailuropoda melanoleuca\tgiant panda\t1\t2\t-\t9646\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Ursidae; Ailuropoda",
    "Alexandrium tamarense\t-\t1\t4\t11\t2926\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Gonyaulacales; Gonyaulacaceae; Alexandrium",
    "Alligator mississippiensis\tAmerican alligator\t1\t2\t-\t8496\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Crocodylia; Alligatoridae; Alligatorinae; Alligator",
    "Alligator sinensis\tChinese alligator\t1\t2\t-\t38654\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Crocodylia; Alligatoridae; Alligatorinae; Alligator",
    "Allium cepa\tonion\t1\t1\t11\t4679\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Amaryllidaceae; Allioideae; Allieae; Allium",
    "Allium fistulosum\tWelsh onion\t1\t1\t11\t35875\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Amaryllidaceae; Allioideae; Allieae; Allium",
    "Allium sativum\tgarlic\t1\t1\t11\t4682\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Amaryllidaceae; Allioideae; Allieae; Allium",
    "Amaranthus tricolor\t-\t1\t1\t11\t29722\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Amaranthaceae; Amaranthus",
    "Amazona vittata\tPuerto Rican parrot\t1\t2\t-\t241585\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Psittaciformes; Psittacidae; Amazona",
    "Ameiurus nebulosus\tbrown bullhead\t1\t2\t-\t27778\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Characiphysae; Siluriformes; Siluroidei; Ictaluridae; Ameiurus",
    "Amoebidium parasiticum JAP-7-2\t-\t1\t4\t-\t1069442\tINV\tcellular organisms; Eukaryota; Opisthokonta; Opisthokonta incertae sedis; Ichthyosporea; Ichthyophonida; Amoebidiaceae; Amoebidium; Amoebidium parasiticum",
    "Anas platyrhynchos\tmallard\t1\t2\t-\t8839\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Anseriformes; Anatidae; Anas",
    "Ancylostoma ceylanicum\t-\t1\t5\t-\t53326\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Ancylostomatoidea; Ancylostomatidae; Ancylostomatinae; Ancylostoma",
    "Ancylostoma duodenale\t-\t1\t5\t-\t51022\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Ancylostomatoidea; Ancylostomatidae; Ancylostomatinae; Ancylostoma",
    "Anguilla anguilla\tEuropean eel\t1\t2\t-\t7936\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Elopocephalai; Elopocephala; Elopomorpha; Anguilliformes; Anguillidae; Anguilla",
    "Anguilla japonica\tJapanese eel\t1\t2\t-\t7937\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Elopocephalai; Elopocephala; Elopomorpha; Anguilliformes; Anguillidae; Anguilla",
    "Anisakis simplex\therring worm\t1\t5\t-\t6269\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Ascaridida; Ascaridoidea; Anisakidae; Anisakis; Anisakis simplex complex",
    "Anneissia japonica\t-\t1\t9\t-\t1529436\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Pelmatozoa; Crinoidea; Articulata; Comatulida; Comatulidae; Comatulinae; Anneissia",
    "Annulipalpia sp. AD-2013\t-\t1\t5\t-\t1499517\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Trichoptera; Annulipalpia; Unclassified Annulipalpia",
    "Anolis carolinensis\tgreen anole\t1\t2\t-\t28377\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Iguania; Iguanidae; Polychrotinae; Anolis",
    "Anopheles funestus\tAfrican malaria mosquito\t1\t5\t-\t62324\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Culicomorpha; Culicoidea; Culicidae; Anophelinae; Anopheles; Cellia; Myzomyia; funestus group; funestus subgroup",
    "Anopheles gambiae\tAfrican malaria mosquito\t1\t5\t-\t7165\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Culicomorpha; Culicoidea; Culicidae; Anophelinae; Anopheles; Cellia; Pyretophorus; gambiae species complex",
    "Anopheles sinensis\t-\t1\t5\t-\t74873\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Culicomorpha; Culicoidea; Culicidae; Anophelinae; Anopheles; Anopheles; Laticorn; Myzorhynchus; hyrcanus group",
    "Anoplophora glabripennis\tAsian longhorned beetle\t1\t5\t-\t217634\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Chrysomeloidea; Cerambycidae; Lamiinae; Lamiini; Anoplophora",
    "Anoplopoma fimbria\tsablefish\t1\t2\t-\t229290\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Perciformes; Cottioidei; Anoplopomatales; Anoplopomatidae; Anoplopoma",
    "Anser cygnoides domesticus\t-\t1\t2\t-\t381198\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Anseriformes; Anatidae; Anser; Anser cygnoides",
    "Antheraea assama\tIndian muga silkmoth\t1\t5\t-\t91021\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Saturniini; Antheraea",
    "Antheraea pernyi\tChinese oak silkmoth\t1\t5\t-\t7119\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Saturniini; Antheraea",
    "Antheraea yamamai\tJapanese oak silkmoth\t1\t5\t-\t7121\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Saturniini; Antheraea",
    "Anthopleura elegantissima\tclonal anemone\t1\t4\t-\t6110\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Nynantheae; Actiniidae; Anthopleura",
    "Anthoxanthum odoratum\t-\t1\t1\t11\t29661\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 1 (Aveneae type); Anthoxanthinae; Anthoxanthum",
    "Anthurium andraeanum\t-\t1\t1\t11\t226677\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Alismatales; Araceae; Pothoideae; Potheae; Anthurium",
    "Aotus nancymaae\tMa's night monkey\t1\t2\t-\t37293\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Platyrrhini; Aotidae; Aotus",
    "Apaloderma vittatum\tbar-tailed trogon\t1\t2\t-\t57397\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Trogoniformes; Trogonidae; Apaloderma",
    "Aphelocoma californica obscura\t-\t1\t2\t-\t947029\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Corvoidea; Corvidae; Aphelocoma; Aphelocoma californica",
    "Aphyosemion striatum\t-\t1\t2\t-\t60296\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Aphyosemion",
    "Apis cerana\tAsiatic honeybee\t1\t5\t-\t7461\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apinae; Apini; Apis",
    "Apis florea\tlittle honeybee\t1\t5\t-\t7463\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apinae; Apini; Apis",
    "Apis mellifera\thoney bee\t1\t5\t-\t7460\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Apinae; Apini; Apis",
    "Aplysia californica\tCalifornia sea hare\t1\t5\t-\t6500\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Euopisthobranchia; Aplysiomorpha; Aplysioidea; Aplysiidae; Aplysia",
    "Apostichopus japonicus\tJapanese sea cucumber\t1\t9\t-\t307972\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Holothuroidea; Aspidochirotacea; Aspidochirotida; Stichopodidae; Apostichopus",
    "Apteryx australis mantelli\t-\t1\t2\t-\t202946\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Palaeognathae; Apterygiformes; Apterygidae; Apteryx; Apteryx australis",
    "Aquila chrysaetos canadensis\t-\t1\t2\t-\t216574\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Accipitridae; Accipitrinae; Aquila; Aquila chrysaetos",
    "Ara macao\tscarlet macaw\t1\t2\t-\t176014\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Psittaciformes; Psittacidae; Ara",
    "Arabidopsis lyrata subsp. lyrata\t-\t1\t1\t11\t81972\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Arabidopsis; Arabidopsis lyrata",
    "Arabidopsis thaliana\tthale cress\t1\t1\t11\t3702\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Arabidopsis",
    "Arachis duranensis\t-\t1\t1\t11\t130453\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Dalbergieae; Arachis",
    "Arachis hypogaea\tpeanut\t1\t1\t11\t3818\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Dalbergieae; Arachis",
    "Arachis hypogaea var. vulgaris\t-\t1\t1\t11\t925390\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Dalbergieae; Arachis; Arachis hypogaea; Arachis hypogaea subsp. fastigiata",
    "Arachis ipaensis\t-\t1\t1\t11\t130454\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Dalbergieae; Arachis",
    "Araucaria cunninghamii\t-\t1\t1\t11\t56994\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Araucariales; Araucariaceae; Araucaria",
    "Archaeopsylla erinacei\t-\t1\t5\t-\t48909\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Siphonaptera; Pulicomorpha; Pulicoidea; Pulicidae; Archaeopsyllinae; Archaeopsylla",
    "Aretaon asperrimus\tthorny stick insect\t1\t5\t-\t173775\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Phasmatodea; Verophasmatodea; Areolatae; Bacilloidea; Heteropterygidae; Obriminae; Obrimini; Aretaon",
    "Argochrysis armilla\t-\t1\t5\t-\t1317734\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Chrysidoidea; Chrysididae; Chrysidinae; Chrysidini; Argochrysis",
    "Argulus siamensis\t-\t1\t5\t-\t1167309\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Branchiura; Arguloida; Argulidae; Argulus",
    "Arion vulgaris\t-\t1\t5\t-\t1028688\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Eupulmonata; Stylommatophora; Sigmurethra; Arionoidea; Arionidae; Arion",
    "Artemisia annua\tsweet wormwood\t1\t1\t11\t35608\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Anthemideae; Artemisiinae; Artemisia",
    "artificial sequences\t-\t11\t0\t11\t81077\tSYN\tother sequences",
    "Arundo donax\tgiant reed\t1\t1\t11\t35708\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Arundinoideae; Arundineae; Arundo",
    "Ascaris suum\tpig roundworm\t1\t5\t-\t6253\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Ascaridida; Ascaridoidea; Ascarididae; Ascaris",
    "Aspergillus oryzae\t-\t1\t4\t-\t5062\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Ascomycota; saccharomyceta; Pezizomycotina; leotiomyceta; Eurotiomycetes; Eurotiomycetidae; Eurotiales; Aspergillaceae; Aspergillus",
    "Aspidistra saxicola\t-\t1\t1\t11\t1197444\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Asparagaceae; Nolinoideae; Aspidistra",
    "Astacus astacus\tbroad-fingered crayfish\t1\t5\t-\t6715\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Astacoidea; Astacidae; Astacus",
    "Astacus leptodactylus\tnarrow-clawed crayfish\t1\t5\t-\t6717\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Astacoidea; Astacidae; Astacus",
    "Asterias amurensis\t-\t1\t9\t-\t7602\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Asterias",
    "Asterias forbesi\tForbes's starfish\t1\t9\t-\t7603\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Asterias",
    "Asterias rubens\tEuropean starfish\t1\t9\t-\t7604\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Asterias",
    "Astyanax mexicanus\tMexican tetra\t1\t2\t-\t7994\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Characiphysae; Characiformes; Characoidei; Characidae; Characidae incertae sedis; Astyanax clade; Astyanax",
    "Athetis lepigone\t-\t1\t5\t-\t1223490\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Noctuinae; Athetis",
    "Atractaspis aterrima\tmole viper\t1\t2\t-\t1355159\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Lamprophiidae; Atractaspidinae; Atractaspis",
    "Aurelia aurita\tmoon jelly\t1\t4\t-\t6145\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Scyphozoa; Semaeostomeae; Ulmaridae; Aurelia",
    "Austrofundulus limnaeus\t-\t1\t2\t-\t52670\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Rivulidae; Austrofundulus",
    "Avena sativa\toat\t1\t1\t11\t4498\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Aveninae; Avena",
    "Avicennia marina\t-\t1\t1\t11\t82927\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Acanthaceae; Avicennioideae; Avicennia",
    "Bacillus cereus\t-\t11\t0\t-\t1396\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Bacillales; Bacillaceae; Bacillus; Bacillus cereus group",
    "Bacillus licheniformis\t-\t11\t0\t-\t1402\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Bacillales; Bacillaceae; Bacillus; Bacillus subtilis group",
    "Bactrocera cucurbitae\tmelon fly\t1\t5\t-\t28588\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Dacini; Bactrocera; Zeugodacus",
    "Bactrocera dorsalis\toriental fruit fly\t1\t5\t-\t27457\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Dacini; Bactrocera; Bactrocera; Bactrocera dorsalis species complex",
    "Bactrocera latifrons\t-\t1\t5\t-\t174628\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Dacini; Bactrocera; Bactrocera",
    "Bactrocera minax\tOriental citrus fly\t1\t5\t-\t104690\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Dacini; Bactrocera; Tetradacus",
    "Bactrocera oleae\tolive fruit fly\t1\t5\t-\t104688\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Dacini; Bactrocera; Daculus",
    "Balaenoptera acutorostrata scammoni\t-\t1\t2\t-\t310752\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Mysticeti; Balaenopteridae; Balaenoptera; Balaenoptera acutorostrata",
    "Balaenoptera bonaerensis\tAntarctic minke whale\t1\t2\t-\t33556\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Mysticeti; Balaenopteridae; Balaenoptera",
    "Balearica regulorum gibbericeps\tEast African grey crowned-crane\t1\t2\t-\t100784\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Gruidae; Balearica; Balearica regulorum",
    "Banksia hookeriana\t-\t1\t1\t11\t199770\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; stem eudicotyledons; Proteales; Proteaceae; Banksia",
    "Bdellocephala annandalei\t-\t1\t9\t-\t1421413\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Planarioidea; Dendrocoelidae; Bdellocephala",
    "Bemisia tabaci\t-\t1\t5\t-\t7038\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aleyrodiformes; Aleyrodoidea; Aleyrodidae; Aleyrodinae; Bemisia",
    "Beta vulgaris\t-\t1\t1\t11\t161934\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Betoideae; Beta",
    "Beta vulgaris subsp. vulgaris\t-\t1\t1\t11\t3555\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Betoideae; Beta; Beta vulgaris",
    "Betula platyphylla\t-\t1\t1\t11\t78630\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Betulaceae; Betula",
    "Biomphalaria glabrata\t-\t1\t5\t-\t6526\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Hygrophila; Planorboidea; Planorbidae; Biomphalaria",
    "Bison bison bison\t-\t1\t2\t-\t43346\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bison; Bison bison",
    "Bithynia siamensis goniomphalos\t-\t1\t5\t-\t479249\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Caenogastropoda; Hypsogastropoda; Littorinimorpha; Truncatelloidea; Bithyniidae; Bithynia; Bithynia siamensis",
    "Boechera gunnisoniana\t-\t1\t1\t11\t93888\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Boechereae; Boechera",
    "Bombina bombina\tfire-bellied toad\t1\t2\t-\t8345\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina",
    "Bombina orientalis\t-\t1\t2\t-\t8346\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina",
    "Bombina variegata scabra\t-\t1\t2\t-\t251232\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina; Bombina variegata",
    "Bombina variegata variegata\t-\t1\t2\t-\t191472\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Bombinatoridae; Bombina; Bombina variegata",
    "Bombus impatiens\tcommon eastern bumble bee\t1\t5\t-\t132113\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Bombinae; Bombini; Bombus; Pyrobombus",
    "Bombus insularis\t-\t1\t5\t-\t207637\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Bombinae; Bombini; Bombus; Psithyrus",
    "Bombus terrestris\tbuff-tailed bumblebee\t1\t5\t-\t30195\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Bombinae; Bombini; Bombus; Bombus",
    "Bombyx mori\tdomestic silkworm\t1\t5\t-\t7091\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Bombycidae; Bombycinae; Bombyx",
    "Bordetella pertussis\t-\t11\t0\t-\t520\tBCT\tcellular organisms; Bacteria; Proteobacteria; Betaproteobacteria; Burkholderiales; Alcaligenaceae; Bordetella",
    "Bos mutus\twild yak\t1\t2\t-\t72004\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bos",
    "Bos taurus\tcattle\t1\t2\t-\t9913\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bos",
    "Botryococcus braunii\t-\t1\t1\t11\t38881\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Chlorophyta; Trebouxiophyceae; Trebouxiophyceae incertae sedis; Botryococcaceae; Botryococcus",
    "Brachionus calyciflorus\t-\t1\t5\t-\t104777\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Rotifera; Monogononta; Pseudotrocha; Ploima; Brachionidae; Brachionus",
    "Brachycistis timberlakei\t-\t1\t5\t-\t1317728\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Tiphiidae; Brachycistidinae; Brachycistis",
    "Brachypodium distachyon\tstiff brome\t1\t1\t11\t15368\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Brachypodieae; Brachypodium",
    "Bragasellus peltatus\t-\t1\t5\t-\t1282048\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Bragasellus",
    "Branchiostoma lanceolatum\tamphioxus\t1\t5\t-\t7740\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Cephalochordata; Branchiostomidae; Branchiostoma",
    "Brassica juncea\t-\t1\t1\t11\t3707\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica napus\trape\t1\t1\t11\t3708\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica oleracea var. capitata\tcabbage\t1\t1\t11\t3716\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica; Brassica oleracea",
    "Brassica oleracea var. oleracea\t-\t1\t1\t11\t109376\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica; Brassica oleracea",
    "Brassica rapa\tfield mustard\t1\t1\t11\t3711\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica",
    "Brassica rapa subsp. pekinensis\tChinese cabbage\t1\t1\t11\t51351\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica; Brassica rapa",
    "Brassica rapa x Raphanus sativus\t-\t1\t1\t11\t1417620\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Brassica x Raphanus",
    "Brassicogethes aeneus\t-\t1\t5\t-\t1431903\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Cucujoidea; Nitidulidae; Meligethinae; Brassicogethes",
    "Brugia malayi\t-\t1\t5\t-\t6279\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Spirurida; Filarioidea; Onchocercidae; Brugia",
    "Bubalus bubalis\twater buffalo\t1\t2\t-\t89462\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Bovinae; Bubalus",
    "Buceros rhinoceros silvestris\t-\t1\t2\t-\t175836\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Bucerotiformes; Bucerotidae; Buceros; Buceros rhinoceros",
    "Burkholderia ubonensis\t-\t11\t0\t-\t101571\tBCT\tcellular organisms; Bacteria; Proteobacteria; Betaproteobacteria; Burkholderiales; Burkholderiaceae; Burkholderia",
    "Caenorhabditis elegans\t-\t1\t5\t-\t6239\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditoidea; Rhabditidae; Peloderinae; Caenorhabditis",
    "Caenorhabditis remanei\t-\t1\t5\t-\t31234\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Rhabditoidea; Rhabditidae; Peloderinae; Caenorhabditis",
    "Cajanus cajan\tpigeon pea\t1\t1\t11\t3821\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Cajanus",
    "Calanus finmarchicus\t-\t1\t5\t-\t6837\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Gymnoplea; Calanoida; Calanidae; Calanus",
    "Calanus glacialis\t-\t1\t5\t-\t113644\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Gymnoplea; Calanoida; Calanidae; Calanus",
    "Calidris pugnax\truff\t1\t2\t-\t198806\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Charadriiformes; Scolopacidae; Calidris",
    "Caligus rogercresseyi\t-\t1\t5\t-\t217165\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Podoplea; Siphonostomatoida; Caligidae; Caligus",
    "Callithrix jacchus\twhite-tufted-ear marmoset\t1\t2\t-\t9483\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Platyrrhini; Cebidae; Callitrichinae; Callithrix",
    "Callorhinchus milii\telephant shark\t1\t2\t-\t7868\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Chondrichthyes; Holocephali; Chimaeriformes; Callorhinchidae; Callorhinchus",
    "Calypte anna\tAnna's hummingbird\t1\t2\t-\t9244\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Trochiliformes; Trochilidae; Calypte",
    "Camelina sativa\tfalse flax\t1\t1\t11\t90675\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Camelina",
    "Camellia oleifera\t-\t1\t1\t11\t385388\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Theaceae; Camellia",
    "Camellia sinensis\t-\t1\t1\t11\t4442\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Theaceae; Camellia",
    "Camellia sinensis var. sinensis\t-\t1\t1\t11\t542762\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Theaceae; Camellia; Camellia sinensis",
    "Camelus bactrianus\tBactrian camel\t1\t2\t-\t9837\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Camelus",
    "Camelus dromedarius\tArabian camel\t1\t2\t-\t9838\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Camelus",
    "Camelus ferus\tWild Bactrian camel\t1\t2\t-\t419612\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Camelus",
    "Camponotus floridanus\tFlorida carpenter ant\t1\t5\t-\t104421\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Camponotini; Camponotus",
    "Camptotheca acuminata\t-\t1\t1\t11\t16922\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Cornales; Nyssaceae; Camptotheca",
    "Campylobacter coli\t-\t11\t0\t-\t195\tBCT\tcellular organisms; Bacteria; Proteobacteria; delta/epsilon subdivisions; Epsilonproteobacteria; Campylobacterales; Campylobacteraceae; Campylobacter",
    "Campylobacter jejuni\t-\t11\t0\t-\t197\tBCT\tcellular organisms; Bacteria; Proteobacteria; delta/epsilon subdivisions; Epsilonproteobacteria; Campylobacterales; Campylobacteraceae; Campylobacter",
    "Canis lupus familiaris\tdog\t1\t2\t-\t9615\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Canidae; Canis; Canis lupus",
    "Cannabis sativa\themp\t1\t1\t11\t3483\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Cannabis",
    "Capra hircus\tgoat\t1\t2\t-\t9925\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Capra",
    "Caprimulgus carolinensis\tchuck-will's-widow\t1\t2\t-\t279965\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Caprimulgiformes; Caprimulgidae; Caprimulginae; Caprimulgus",
    "Capsella rubella\t-\t1\t1\t11\t81985\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Camelineae; Capsella",
    "Capsicum annuum\t-\t1\t1\t11\t4072\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Capsiceae; Capsicum",
    "Carabus granulatus\t-\t1\t5\t-\t118799\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Adephaga; Caraboidea; Carabidae; Carabinae; Carabini; Carabina; Carabus; Carabus",
    "Caragana korshinskii\t-\t1\t1\t11\t220689\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Caraganeae; Caragana",
    "Cariama cristata\tred-legged seriema\t1\t2\t-\t54380\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Cariamidae; Cariama",
    "Carlito syrichta\tPhilippine tarsier\t1\t2\t-\t1868482\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Tarsiiformes; Tarsiidae; Carlito",
    "Catharanthus roseus\tMadagascar periwinkle\t1\t1\t11\t4058\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Apocynaceae; Rauvolfioideae; Vinceae; Catharanthinae; Catharanthus",
    "Cathartes aura\tturkey vulture\t1\t2\t-\t43455\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Ciconiiformes; Cathartidae; Cathartes",
    "Cavia porcellus\tdomestic guinea pig\t1\t2\t-\t10141\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Caviidae; Cavia",
    "Cebus capucinus imitator\t-\t1\t2\t-\t1737458\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Platyrrhini; Cebidae; Cebinae; Cebus; Cebus capucinus",
    "Cecidomyiidae sp. BOLD-2016\t-\t1\t5\t-\t1881751\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Nematocera; Bibionomorpha; Sciaroidea; Cecidomyiidae; unclassified Cecidomyiidae",
    "Cenchrus americanus\t-\t1\t1\t11\t4543\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Cenchrus",
    "Centris flavifrons\t-\t1\t5\t-\t360639\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Anthophorinae; Centridini; Centris",
    "Cephalotaxus hainanensis\t-\t1\t1\t11\t191701\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Cupressales; Taxaceae; Cephalotaxus",
    "Cerapachys biroi\tclonal raider ant\t1\t5\t-\t443821\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Cerapachyinae; Cerapachyini; Cerapachys",
    "Ceratina calcarata\t-\t1\t5\t-\t156304\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Xylocopinae; Ceratinini; Ceratina; Zadontomerus",
    "Ceratitis capitata\tMediterranean fruit fly\t1\t5\t-\t7213\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Dacinae; Ceratitidini; Ceratitis; Ceratitis",
    "Ceratotherium simum simum\tsouthern white rhinoceros\t1\t2\t-\t73337\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Perissodactyla; Rhinocerotidae; Ceratotherium; Ceratotherium simum",
    "Cercis gigantea\t-\t1\t1\t11\t183790\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Cercideae; Cercis",
    "Cercocebus atys\tsooty mangabey\t1\t2\t-\t9531\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Cercocebus",
    "Chaetura pelagica\tchimney swift\t1\t2\t-\t8897\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Apodiformes; Apodidae; Chaetura",
    "Charadrius vociferus\tkilldeer\t1\t2\t-\t50402\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Charadriiformes; Charadriidae; Charadrius",
    "Chelonia mydas\tgreen sea turtle\t1\t2\t-\t8469\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Testudines; Cryptodira; Durocryptodira; Americhelydia; Chelonioidea; Cheloniidae; Chelonia",
    "Cherax quadricarinatus\t-\t1\t5\t-\t27406\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Parastacoidea; Parastacidae; Cherax",
    "Chilo suppressalis\tstriped riceborer\t1\t5\t-\t168631\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Pyraloidea; Crambidae; Crambinae; Chilo",
    "Chinavia ubica\t-\t1\t5\t-\t1497372\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Neohemiptera; Prosorrhyncha; Heteroptera; Euheteroptera; Neoheteroptera; Panheteroptera; Pentatomomorpha; Pentatomoidea; Pentatomidae; Pentatominae; Chinavia",
    "Chinchilla lanigera\tlong-tailed chinchilla\t1\t2\t-\t34839\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Chinchillidae; Chinchilla",
    "Chlamydia trachomatis\t-\t11\t0\t-\t813\tBCT\tcellular organisms; Bacteria; PVC group; Chlamydiae; Chlamydiia; Chlamydiales; Chlamydiaceae; Chlamydia/Chlamydophila group; Chlamydia",
    "Chlamydotis macqueenii\tMacqueen's bustard\t1\t2\t-\t187382\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Otididae; Chlamydotis",
    "Chlorella sorokiniana\t-\t1\t1\t11\t3076\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Chlorophyta; Trebouxiophyceae; Chlorellales; Chlorellaceae; Chlorella",
    "Chloris chloris\tEuropean greenfinch\t1\t2\t-\t37601\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Fringillidae; Carduelinae; Chloris",
    "Chlorocebus sabaeus\tgreen monkey\t1\t2\t-\t60711\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Chlorocebus",
    "Chorispora bungeana\t-\t1\t1\t11\t238895\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Chorisporeae; Chorispora",
    "Chromolaena odorata\t-\t1\t1\t11\t103745\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Heliantheae alliance; Eupatorieae; Chromolaena",
    "Chrysemys picta bellii\twestern painted turtle\t1\t2\t-\t8478\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Testudines; Cryptodira; Durocryptodira; Testudinoidea; Emydidae; Chrysemys; Chrysemys picta",
    "Chrysochloris asiatica\tCape golden mole\t1\t2\t-\t185453\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Chrysochloridae; Chrysochlorinae; Chrysochloris",
    "Chrysopa pallens\t-\t1\t5\t-\t417485\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Neuropterida; Neuroptera; Chrysopidae; Chrysopa",
    "Chyphotes mellipes\t-\t1\t5\t-\t292179\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Bradynobaenidae; Chyphotinae; Chyphotes",
    "Cicer arietinum\tchickpea\t1\t1\t11\t3827\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Cicereae; Cicer",
    "Ciona intestinalis\tvase tunicate\t1\t13\t-\t7719\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Tunicata; Ascidiacea; Enterogona; Phlebobranchia; Cionidae; Ciona",
    "Citrus clementina\t-\t1\t1\t11\t85681\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Rutaceae; Aurantioideae; Citrus",
    "Citrus sinensis\tsweet orange\t1\t1\t11\t2711\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Rutaceae; Aurantioideae; Citrus",
    "Clostridioides difficile\t-\t11\t0\t-\t1496\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Clostridia; Clostridiales; Peptostreptococcaceae; Clostridioides",
    "Clostridium botulinum\t-\t11\t0\t-\t1491\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Clostridia; Clostridiales; Clostridiaceae; Clostridium",
    "Clupea harengus\tAtlantic herring\t1\t2\t-\t7950\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Clupei; Clupeiformes; Clupeoidei; Clupeidae; Clupeinae; Clupea",
    "Cocos nucifera\tcoconut palm\t1\t1\t11\t13894\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Arecales; Arecaceae; Arecoideae; Cocoseae; Attaleinae; Cocos",
    "Colaphellus bowringi\t-\t1\t5\t-\t561076\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Chrysomeloidea; Chrysomelidae; Chrysomelinae; Chrysomelini; Colaphellus",
    "Colius striatus\tspeckled mousebird\t1\t2\t-\t57412\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coliiformes; Coliidae; Colius",
    "Colobus angolensis palliatus\t-\t1\t2\t-\t336983\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Colobinae; Colobus; Colobus angolensis",
    "Columba livia\trock pigeon\t1\t2\t-\t8932\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Columbiformes; Columbidae; Columba",
    "Condylura cristata\tstar-nosed mole\t1\t2\t-\t143302\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Insectivora; Talpidae; Condylura",
    "Copidosoma floridanum\t-\t1\t5\t-\t29053\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Chaldicoidea group; Chalcidoidea; Encyrtidae; Encyrtinae; Copidosoma",
    "Corchorus capsularis\t-\t1\t1\t11\t210143\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Grewioideae; Apeibeae; Corchorus",
    "Corvus brachyrhynchos\tAmerican crow\t1\t2\t-\t85066\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Corvoidea; Corvidae; Corvus",
    "Corvus cornix cornix\t-\t1\t2\t-\t932674\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Corvoidea; Corvidae; Corvus; Corvus cornix",
    "Corydalinae sp. KMRSPBM-2012\t-\t1\t5\t-\t1247484\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Neuropterida; Megaloptera; Corydalidae; Corydalinae; unclassified Corydalinae",
    "Corylus avellana\t-\t1\t1\t11\t13451\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Betulaceae; Corylus",
    "Costus pictus\t-\t1\t1\t11\t168183\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Zingiberales; Costaceae; Costus",
    "Coturnix japonica\tJapanese quail\t1\t2\t-\t93934\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Perdicinae; Coturnix",
    "Crassostrea angulata\t-\t1\t5\t-\t558553\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Ostreoida; Ostreoidea; Ostreidae; Crassostrea",
    "Crassostrea gigas\tPacific oyster\t1\t5\t-\t29159\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Ostreoida; Ostreoidea; Ostreidae; Crassostrea",
    "Crataegus pinnatifida\t-\t1\t1\t11\t510735\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Maleae; Crataegus",
    "Crepidula fornicata\t-\t1\t5\t-\t176853\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Caenogastropoda; Hypsogastropoda; Littorinimorpha; Calyptraeoidea; Calyptraeidae; Crepidula",
    "Cricetulus griseus\tChinese hamster\t1\t2\t-\t10029\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Cricetidae; Cricetinae; Cricetulus",
    "Crioscolia alcione\t-\t1\t5\t-\t1317732\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Scoliidae; Crioscolia",
    "Ctenomys sociabilis\tsocial tuco-tuco\t1\t2\t-\t43321\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Ctenomyidae; Ctenomys",
    "Cucumis melo\tmuskmelon\t1\t1\t11\t3656\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Cucumis",
    "Cucumis sativus\tcucumber\t1\t1\t11\t3659\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Cucumis",
    "Cunninghamia lanceolata\t-\t1\t1\t11\t28977\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Cupressales; Cupressaceae; Cunninghamia",
    "Curcuma longa\tturmeric\t1\t1\t11\t136217\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Zingiberales; Zingiberaceae; Curcuma",
    "Cuscuta pentagona\t-\t1\t1\t11\t112407\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Cuscuteae; Cuscuta; Grammica; Cuscuta sect. Cleistogrammica",
    "Cylicostephanus goldi\t-\t1\t5\t-\t71465\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Strongyloidea; Strongylidae; Cyathostominae; Cylicostephanus",
    "Cynoglossus semilaevis\ttongue sole\t1\t2\t-\t244447\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Carangaria; Pleuronectiformes; Pleuronectoidei; Cynoglossidae; Cynoglossinae; Cynoglossus",
    "Cynopterus sphinx\tIndian short-nosed fruit bat\t1\t2\t-\t9400\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Cynopterus",
    "Cypridininae sp. BMR-2011\t-\t1\t5\t-\t1032739\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Ostracoda; Myodocopa; Myodocopida; Cypridinoidea; Cypridinidae; unclassified Cypridinidae",
    "Cyprinodon variegatus\tsheepshead minnow\t1\t2\t-\t28743\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Cyprinodontidae; Cyprinodontinae; Cyprinodontini; Cyprinodon",
    "Cyprinus carpio\tcommon carp\t1\t2\t-\t7962\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Cyprinus",
    "Dahlia pinnata\t-\t1\t1\t11\t101596\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Heliantheae alliance; Coreopsideae; Dahlia",
    "Danio rerio\tzebrafish\t1\t2\t-\t7955\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Danio",
    "Daphnia magna\t-\t1\t5\t-\t35525\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Branchiopoda; Phyllopoda; Diplostraca; Cladocera; Anomopoda; Daphniidae; Daphnia",
    "Dastarcus helophoroides\t-\t1\t5\t-\t1169899\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Cucujoidea; Bothrideridae; Dastarcus",
    "Dasypus novemcinctus\tnine-banded armadillo\t1\t2\t-\t9361\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Xenarthra; Cingulata; Dasypodidae; Dasypus",
    "Daucus carota subsp. sativus\t-\t1\t1\t11\t79200\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Apiales; Apiineae; Apiaceae; Apioideae; Scandiceae; Daucinae; Daucus; Daucus sect. Daucus; Daucus carota",
    "Dendroctonus ponderosae\tmountain pine beetle\t1\t5\t-\t77166\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Cucujiformia; Curculionoidea; Curculionidae; Scolytinae; Dendroctonus",
    "Dermacentor variabilis\tAmerican dog tick\t1\t5\t-\t34621\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Rhipicephalinae; Dermacentor",
    "Dermanyssus gallinae\t-\t1\t5\t-\t34641\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Mesostigmata; Monogynaspida; Gamasina; Dermanyssoidea; Dermanyssidae; Dermanyssus",
    "Dianthus caryophyllus\tclove pink\t1\t1\t11\t3570\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Caryophyllaceae; Caryophylleae; Dianthus",
    "Diaphorina citri\tAsian citrus psyllid\t1\t5\t-\t121845\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Psylliformes; Psylloidea; Psyllidae; Diaphorina",
    "Dicrocoelium dendriticum\t-\t1\t9\t-\t57078\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Plagiorchiida; Xiphidiata; Plagiorchioidea; Dicrocoeliidae; Dicrocoelium",
    "Dinobryon sp. LO226KS\t-\t1\t1\t11\t1825119\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; Chromulinales; Dinobryaceae; Dinobryon",
    "Dinoponera quadriceps\t-\t1\t5\t-\t609295\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Ponerinae; Ponerini; Dinoponera",
    "Diospyros lotus\t-\t1\t1\t11\t55363\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Ebenaceae; Diospyros",
    "Diphyllobothrium latum\t-\t1\t9\t-\t60516\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Cestoda; Eucestoda; Diphyllobothriidea; Diphyllobothriidae; Diphyllobothrium",
    "Dipodomys ordii\tOrd's kangaroo rat\t1\t2\t-\t10020\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Heteromyidae; Dipodomyinae; Dipodomys",
    "Dorcoceras hygrometricum\t-\t1\t1\t11\t472368\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Gesneriaceae; Didymocarpoideae; Trichosporeae; Loxocarpinae; Dorcoceras",
    "Drosophila ananassae\t-\t1\t5\t-\t7217\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; ananassae subgroup; ananassae species complex",
    "Drosophila grimshawi\t-\t1\t5\t-\t7222\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Hawaiian Drosophila; picture wing clade; grimshawi clade; grimshawi group; grimshawi subgroup",
    "Drosophila melanogaster\tfruit fly\t1\t5\t-\t7227\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; melanogaster subgroup",
    "Drosophila miranda\t-\t1\t5\t-\t7229\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; obscura group; pseudoobscura subgroup",
    "Drosophila mojavensis\t-\t1\t5\t-\t7230\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Drosophila; repleta group; mulleri subgroup; mojavensis species complex",
    "Drosophila persimilis\t-\t1\t5\t-\t7234\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; obscura group; pseudoobscura subgroup",
    "Drosophila pseudoobscura pseudoobscura\t-\t1\t5\t-\t46245\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; obscura group; pseudoobscura subgroup; Drosophila pseudoobscura",
    "Drosophila rhopaloa\t-\t1\t5\t-\t1041015\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; rhopaloa subgroup",
    "Drosophila sechellia\t-\t1\t5\t-\t7238\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; melanogaster subgroup",
    "Drosophila simulans\t-\t1\t5\t-\t7240\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; melanogaster subgroup",
    "Drosophila suzukii\t-\t1\t5\t-\t28584\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; suzukii subgroup",
    "Drosophila virilis\t-\t1\t5\t-\t7244\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Drosophila; virilis group",
    "Drosophila willistoni\t-\t1\t5\t-\t7260\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; willistoni group; willistoni subgroup",
    "Drosophila yakuba\t-\t1\t5\t-\t7245\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Ephydroidea; Drosophilidae; Drosophilinae; Drosophilini; Drosophila; Sophophora; melanogaster group; melanogaster subgroup",
    "Dugesia japonica\t-\t1\t9\t-\t6161\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Geoplanoidea; Dugesiidae; Dugesia",
    "Echinarachnius parma\t-\t1\t9\t-\t869203\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Gnathostomata; Clypeasteroida; Echinarachniidae; Echinarachnius",
    "Echinaster spinulosus\t-\t1\t9\t-\t1451296\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Spinulosacea; Spinulosida; Echinasteridae; Echinaster",
    "Echinops telfairi\tsmall Madagascar hedgehog\t1\t2\t-\t9371\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Tenrecidae; Tenrecinae; Echinops",
    "Echinostoma caproni\t-\t1\t9\t-\t27848\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Plagiorchiida; Echinostomata; Echinostomatoidea; Echinostomatidae; Echinostoma",
    "Eidolon helvum\tstraw-colored fruit bat\t1\t2\t-\t77214\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Eidolon",
    "Eimeria mitis\t-\t1\t4\t4\t44415\tINV\tcellular organisms; Eukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Eimeriidae; Eimeria",
    "Elaeis guineensis\tAfrican oil palm\t1\t1\t11\t51953\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Arecales; Arecaceae; Arecoideae; Cocoseae; Elaeidinae; Elaeis",
    "Elephantulus edwardii\tCape elephant shrew\t1\t2\t-\t28737\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Macroscelidea; Macroscelididae; Elephantulus",
    "Elliptio complanata\teastern elliptio\t1\t5\t-\t55832\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Palaeoheterodonta; Unionoida; Unionoidea; Unionidae; Ambleminae; Elliptio",
    "Elodea nuttallii\t-\t1\t1\t11\t55313\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Alismatales; Hydrocharitaceae; Elodea",
    "Emiliania huxleyi CCMP1516\t-\t1\t4\t11\t280463\tPLN\tcellular organisms; Eukaryota; Haptophyceae; Isochrysidales; Noelaerhabdaceae; Emiliania; Emiliania huxleyi",
    "Enterobacter cloacae\t-\t11\t0\t-\t550\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Enterobacter; Enterobacter cloacae complex",
    "Enterococcus faecalis\t-\t11\t0\t-\t1351\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Enterococcaceae; Enterococcus",
    "Enterococcus faecium\t-\t11\t0\t-\t1352\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Enterococcaceae; Enterococcus",
    "Epipyxis sp. PR26KG\t-\t1\t1\t11\t1825121\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; Chromulinales; Dinobryaceae; Epipyxis",
    "Eptesicus fuscus\tbig brown bat\t1\t2\t-\t29078\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Eptesicus",
    "Equus asinus\tass\t1\t2\t-\t9793\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Perissodactyla; Equidae; Equus; Asinus",
    "Equus caballus\thorse\t1\t2\t-\t9796\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Perissodactyla; Equidae; Equus; Equus",
    "Equus przewalskii\tPrzewalski's horse\t1\t2\t-\t9798\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Perissodactyla; Equidae; Equus; Equus",
    "Erinaceus europaeus\twestern European hedgehog\t1\t2\t-\t9365\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Insectivora; Erinaceidae; Erinaceinae; Erinaceus",
    "Eriocheir sinensis\tChinese mitten crab\t1\t5\t-\t95602\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Brachyura; Eubrachyura; Thoracotremata; Grapsoidea; Varunidae; Eriocheir",
    "Erythranthe guttata\tspotted monkey flower\t1\t1\t11\t4155\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Phrymaceae; Erythranthe",
    "Escherichia coli\t-\t11\t0\t-\t562\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Escherichia",
    "Esox lucius\tnorthern pike\t1\t2\t-\t8010\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Protacanthopterygii; Esociformes; Esocidae; Esox",
    "Eucalyptus camaldulensis\tMurray red gum\t1\t1\t11\t34316\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Myrtaceae; Myrtoideae; Eucalypteae; Eucalyptus",
    "Eucalyptus grandis\t-\t1\t1\t11\t71139\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Myrtaceae; Myrtoideae; Eucalypteae; Eucalyptus",
    "Eucidaris tribuloides\t-\t1\t9\t-\t7632\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Perischoechinoidea; Cidaroida; Cidaridae; Eucidaris",
    "Eucyclops serrulatus\t-\t1\t5\t-\t84317\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Podoplea; Cyclopoida; Cyclopidae; Eucyclops",
    "Eufriesea mexicana\t-\t1\t5\t-\t516756\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Bombinae; Euglossini; Eufriesea",
    "Eurypyga helias\tsunbittern\t1\t2\t-\t54383\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Eurypygidae; Eurypyga",
    "Eustoma exaltatum subsp. russellianum\t-\t1\t1\t11\t52518\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Gentianaceae; Chironieae; Eustoma; Eustoma exaltatum",
    "Evechinus chloroticus\t-\t1\t9\t-\t137513\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Echinometridae; Evechinus",
    "Exaiptasia pallida\t-\t1\t4\t-\t1720309\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Aiptasiidae; Exaiptasia",
    "Exoneura robusta\t-\t1\t5\t-\t175328\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Xylocopinae; Allodapini; Exoneura",
    "Extatosoma tiaratum\tgiant prickly stick insect\t1\t5\t-\t7024\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Tropidoderinae; Extatosoma",
    "Fagopyrum esculentum\tcommon buckwheat\t1\t1\t11\t3617\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Polygonaceae; Polygonoideae; Fagopyreae; Fagopyrum",
    "Falco cherrug\tSaker falcon\t1\t2\t-\t345164\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Falconidae; Falco",
    "Falco peregrinus\tperegrine falcon\t1\t2\t-\t8954\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Falconidae; Falco",
    "Fasciola hepatica\tliver fluke\t1\t9\t-\t6192\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Plagiorchiida; Echinostomata; Echinostomatoidea; Fasciolidae; Fasciola",
    "Felis catus\tdomestic cat\t1\t2\t-\t9685\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Felinae; Felis",
    "Ficedula albicollis\tcollared flycatcher\t1\t2\t-\t59894\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Muscicapidae; Ficedula",
    "Ficus carica\tcommon fig\t1\t1\t11\t3494\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Moraceae; Ficus",
    "fish metagenome\t-\t11\t2\t11\t496924\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Folsomia candida\t-\t1\t5\t-\t158441\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Collembola; Collembola; Entomobryomorpha; Isotomoidea; Isotomidae; Proisotominae; Folsomia",
    "Fopius arisanus\t-\t1\t5\t-\t64838\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Ichneumonoidea; Braconidae; Opiinae; Fopius",
    "Formica aquilonia\t-\t1\t5\t-\t258703\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica cinerea\t-\t1\t5\t-\t609761\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica exsecta\t-\t1\t5\t-\t72781\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica fusca\t-\t1\t5\t-\t72779\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica pratensis\t-\t1\t5\t-\t221681\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica pressilabris\t-\t1\t5\t-\t609858\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Formica truncorum\t-\t1\t5\t-\t72783\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Formicini; Formica",
    "Fragaria vesca subsp. vesca\t-\t1\t1\t11\t101020\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Rosoideae; Potentilleae; Fragariinae; Fragaria; Fragaria vesca",
    "Fragaria x ananassa\tstrawberry\t1\t1\t11\t3747\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Rosoideae; Potentilleae; Fragariinae; Fragaria",
    "Frankliniella occidentalis\twestern flower thrips\t1\t5\t-\t133901\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Thysanoptera; Terebrantia; Thripoidea; Thripidae; Thripinae; Frankliniella",
    "Fraxinus excelsior\tEuropean ash\t1\t1\t11\t38873\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Oleaceae; Oleeae; Fraxinus",
    "Fukomys damarensis\tDamara mole-rat\t1\t2\t-\t885580\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Bathyergidae; Fukomys",
    "Fulmarus glacialis\tnorthern fulmar\t1\t2\t-\t30455\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Procellariiformes; Procellariidae; Procellariinae; Fulmarus",
    "Fundulus grandis\tGulf killifish\t1\t2\t-\t34779\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Fundulidae; Fundulus",
    "Fundulus heteroclitus\tmummichog\t1\t2\t-\t8078\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Fundulidae; Fundulus",
    "Gadus morhua\tAtlantic cod\t1\t2\t-\t8049\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Paracanthomorphacea; Zeiogadaria; Gadariae; Gadiformes; Gadoidei; Gadidae; Gadus",
    "Galeopterus variegatus\tSunda flying lemur\t1\t2\t-\t482537\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Dermoptera; Cynocephalidae; Galeopterus",
    "Gallus gallus\tchicken\t1\t2\t-\t9031\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Phasianinae; Gallus",
    "Gammarus chevreuxi\t-\t1\t5\t-\t732109\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Amphipoda; Senticaudata; Gammarida; Gammaridira; Gammaroidea; Gammaridae; Gammarus",
    "Gardenia jasminoides\t-\t1\t1\t11\t114476\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Ixoroideae; Gardenieae; Gardenia",
    "Gavia stellata\tred-throated loon\t1\t2\t-\t37040\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gaviiformes; Gaviidae; Gavia",
    "Gavialis gangeticus\tGharial\t1\t2\t-\t94835\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Crocodylia; Longirostres; Gavialidae; Gavialinae; Gavialis",
    "Gekko japonicus\t-\t1\t2\t-\t146911\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Gekkota; Gekkonidae; Gekkoninae; Gekko",
    "Geminigera cryophila\t-\t1\t1\t11\t46947\tPLN\tcellular organisms; Eukaryota; Cryptophyta; Pyrenomonadales; Geminigeraceae; Geminigera",
    "Gene trapping vector VICTR76\t-\t11\t0\t11\t447635\tSYN\tother sequences; artificial sequences; vectors",
    "Gentiana macrophylla\t-\t1\t1\t11\t50765\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Gentianaceae; Gentianeae; Gentiana",
    "Geospiza fortis\tmedium ground-finch\t1\t2\t-\t48883\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Thraupidae; Geospiza",
    "Gerbera hybrid cultivar\t-\t1\t1\t11\t18101\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Mutisioideae; Mutisieae; Gerbera",
    "Gigaspora margarita\t-\t1\t4\t-\t4874\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Mucoromycota; Glomeromycotina; Glomeromycetes; Diversisporales; Gigasporaceae; Gigaspora",
    "Glomeris pustulata\t-\t1\t5\t-\t1288506\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Myriapoda; Diplopoda; Pentazonia; Glomerida; Glomeridae; Glomeris",
    "Glossoscolex paulistus\t-\t1\t5\t-\t1046353\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Annelida; Clitellata; Oligochaeta; Haplotaxida; Lumbricina; Glossoscolecidae; Glossoscolex",
    "Glycera dibranchiata\t-\t1\t5\t-\t6350\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Annelida; Polychaeta; Palpata; Aciculata; Phyllodocida; Glyceridae; Glycera",
    "Glycine max\tsoybean\t1\t1\t11\t3847\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Glycine; Soja",
    "Gongylonema pulchrum\t-\t1\t5\t-\t637853\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Spirurida; Spiruroidea; Gongylonematidae; Gongylonema",
    "Gorilla gorilla gorilla\twestern lowland gorilla\t1\t2\t-\t9595\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Gorilla; Gorilla gorilla",
    "Gossypium arboreum\t-\t1\t1\t11\t29729\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Gossypium hirsutum\t-\t1\t1\t11\t3635\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Gossypium raimondii\t-\t1\t1\t11\t29730\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Malvoideae; Gossypium",
    "Graminella nigrifrons\t-\t1\t5\t-\t30127\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Clypeorrhyncha; Membracoidea; Cicadellidae; Deltocephalinae; Graminella",
    "gut metagenome\t-\t11\t2\t11\t749906\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Habropoda laboriosa\t-\t1\t5\t-\t597456\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Apidae; Anthophorinae; Anthophorini; Habropoda",
    "Haliaeetus albicilla\twhite-tailed eagle\t1\t2\t-\t8969\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Falconiformes; Accipitridae; Accipitrinae; Haliaeetus",
    "Halyomorpha halys\tbrown marmorated stink bug\t1\t5\t-\t286706\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Neohemiptera; Prosorrhyncha; Heteroptera; Euheteroptera; Neoheteroptera; Panheteroptera; Pentatomomorpha; Pentatomoidea; Pentatomidae; Pentatominae; Halyomorpha",
    "Hammondia hammondi\t-\t1\t4\t4\t99158\tINV\tcellular organisms; Eukaryota; Alveolata; Apicomplexa; Conoidasida; Coccidia; Eucoccidiorida; Eimeriorina; Sarcocystidae; Hammondia",
    "Haplochromis burtoni\tBurton's mouthbrooder\t1\t2\t-\t8153\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Haplochromis",
    "Harpegnathos saltator\tJerdon's jumping ant\t1\t5\t-\t610380\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Ponerinae; Ponerini; Harpegnathos",
    "Helicobacter pylori\t-\t11\t0\t-\t210\tBCT\tcellular organisms; Bacteria; Proteobacteria; delta/epsilon subdivisions; Epsilonproteobacteria; Campylobacterales; Helicobacteraceae; Helicobacter",
    "Helicoverpa assulta\t-\t1\t5\t-\t52344\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Heliothinae; Helicoverpa",
    "Heligmosomoides polygyrus\t-\t1\t5\t-\t6339\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Trichostrongyloidea; Heligmosomatidae; Heligmosomoides",
    "Henricia sp. AR-2014\t-\t1\t9\t-\t1462731\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Spinulosacea; Spinulosida; Echinasteridae; Henricia",
    "Hepatitis B virus\t-\t1\t0\t-\t10407\tVRL\tViruses; Retro-transcribing viruses; Hepadnaviridae; Orthohepadnavirus",
    "Hepatitis C virus\t-\t1\t0\t-\t11103\tVRL\tViruses; ssRNA viruses; ssRNA positive-strand viruses, no DNA stage; Flaviviridae; Hepacivirus",
    "Heterocephalus glaber\tnaked mole-rat\t1\t2\t-\t10181\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Bathyergidae; Heterocephalus",
    "Heterodera glycines\tsoybean cyst nematode\t1\t5\t-\t51029\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Tylenchida; Tylenchina; Tylenchoidea; Heteroderidae; Heteroderinae; Heterodera",
    "Hevea brasiliensis\t-\t1\t1\t11\t3981\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Micrandreae; Hevea",
    "Homalodisca liturata\t-\t1\t5\t-\t320908\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Clypeorrhyncha; Membracoidea; Cicadellidae; Cicadellinae; unclassified Cicadellinae; Homalodisca",
    "Homalodisca vitripennis\tglassy-winged sharpshooter\t1\t5\t-\t197043\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Clypeorrhyncha; Membracoidea; Cicadellidae; Cicadellinae; unclassified Cicadellinae; Homalodisca",
    "Homo sapiens\thuman\t1\t2\t-\t9606\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Homo",
    "Hordeum pubiflorum\t-\t1\t1\t11\t112521\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hordeum vulgare\t-\t1\t1\t11\t4513\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum",
    "Hordeum vulgare subsp. vulgare\tdomesticated barley\t1\t1\t11\t112509\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Hordeum; Hordeum vulgare",
    "human gut metagenome\t-\t11\t2\t11\t408170\tENV\tunclassified sequences; metagenomes; organismal metagenomes",
    "Human immunodeficiency virus 1\t-\t1\t0\t-\t11676\tVRL\tViruses; Retro-transcribing viruses; Retroviridae; Orthoretrovirinae; Lentivirus; Primate lentivirus group",
    "Humulus lupulus\tEuropean hop\t1\t1\t11\t3486\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus",
    "Humulus lupulus var. cordifolius\t-\t1\t1\t11\t278022\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus; Humulus lupulus",
    "Humulus lupulus var. lupulus\t-\t1\t1\t11\t1571165\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Cannabaceae; Humulus; Humulus lupulus",
    "Hyalella azteca\t-\t1\t5\t-\t294128\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Amphipoda; Senticaudata; Talitrida; Talitroidea; Hyalellidae; Hyalella",
    "Hyas araneus\t-\t1\t5\t-\t361634\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Brachyura; Eubrachyura; Heterotremata; Majoidea; Majidae; Hyas",
    "Hydra vulgaris\t-\t1\t4\t-\t6087\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Aplanulata; Hydridae; Hydra",
    "Hydractinia symbiolongicarpus\t-\t1\t4\t-\t13093\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Filifera; Hydractiniidae; Hydractinia",
    "Hynobius chinensis\tChinese salamander\t1\t2\t-\t288313\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Caudata; Cryptobranchoidea; Hynobiidae; Hynobius; Hynobius",
    "Hynobius retardatus\tHokkaido salamander\t1\t2\t-\t36312\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Caudata; Cryptobranchoidea; Hynobiidae; Hynobius; Satobius",
    "Hypsizygus marmoreus\t-\t1\t4\t-\t39966\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Basidiomycota; Agaricomycotina; Agaricomycetes; Agaricomycetidae; Agaricales; Lyophyllaceae; Hypsizygus",
    "Ictalurus punctatus\tchannel catfish\t1\t2\t-\t7998\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Characiphysae; Siluriformes; Siluroidei; Ictaluridae; Ictalurus",
    "Ictidomys tridecemlineatus\tthirteen-lined ground squirrel\t1\t2\t-\t43179\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Sciuridae; Xerinae; Marmotini; Ictidomys",
    "Ipomoea batatas\tsweet potato\t1\t1\t11\t4120\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea nil\tJapanese morning glory\t1\t1\t11\t35883\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea purpurea\tcommon morning-glory\t1\t1\t11\t4121\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ipomoea trifida\t-\t1\t1\t11\t35884\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Convolvulaceae; Ipomoeeae; Ipomoea",
    "Ixodes ricinus\tcastor bean tick\t1\t5\t-\t34613\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Ixodinae; Ixodes",
    "Ixodes scapularis\tblack-legged tick\t1\t5\t-\t6945\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Ixodinae; Ixodes",
    "Jaculus jaculus\tlesser Egyptian jerboa\t1\t2\t-\t51337\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Dipodidae; Dipodinae; Jaculus",
    "Jatropha curcas\t-\t1\t1\t11\t180498\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Jatropheae; Jatropha",
    "Juglans regia\tEnglish walnut\t1\t1\t11\t51240\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Juglandaceae; Juglans",
    "Karelinia caspia\t-\t1\t1\t11\t313960\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Asteroideae; Inuleae; Plucheinae; Karelinia",
    "Kerria lacca\tcommon lac scale\t1\t5\t-\t473130\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Aphidiformes; Coccoidea; Kerriidae; Kerria",
    "Klebsiella pneumoniae\t-\t11\t0\t-\t573\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Klebsiella",
    "Kryptolebias marmoratus\tmangrove rivulus\t1\t2\t-\t37003\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Rivulidae; Kryptolebias",
    "Lactuca sativa\t-\t1\t1\t11\t4236\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Cichorioideae; Cichorieae; Lactucinae; Lactuca",
    "Lactuca serriola\t-\t1\t1\t11\t75943\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Cichorioideae; Cichorieae; Lactucinae; Lactuca",
    "Lagenaria siceraria\twhite-flowered gourd\t1\t1\t11\t3668\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Benincaseae; Lagenaria",
    "Landoltia punctata\t-\t1\t1\t11\t50518\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Alismatales; Araceae; Lemnoideae; Landoltia",
    "Larimichthys crocea\tlarge yellow croaker\t1\t2\t-\t215358\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Eupercaria incertae sedis; Sciaenidae; Larimichthys",
    "Larix kaempferi\t-\t1\t1\t11\t54800\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Larix",
    "Lasius neglectus\t-\t1\t5\t-\t111072\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Lasiini; Lasius; Lasius",
    "Lasius turcicus\t-\t1\t5\t-\t235463\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Lasiini; Lasius; Lasius",
    "Lates calcarifer\tbarramundi perch\t1\t2\t-\t8187\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Carangaria; Carangiaria incertae sedis; Centropomidae; Lates",
    "Lathyrus sativus\t-\t1\t1\t11\t3860\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Fabeae; Lathyrus",
    "Latimeria chalumnae\tcoelacanth\t1\t2\t-\t7897\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Coelacanthimorpha; Coelacanthiformes; Coelacanthidae; Latimeria",
    "Latimeria menadoensis\tMenado coelacanth\t1\t2\t-\t106881\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Coelacanthimorpha; Coelacanthiformes; Coelacanthidae; Latimeria",
    "Latrodectus hesperus\twestern black widow\t1\t5\t-\t256737\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Orbiculariae; Araneoidea; Theridiidae; Latrodectus",
    "Legionella pneumophila\t-\t11\t0\t-\t446\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Legionellales; Legionellaceae; Legionella",
    "Lepeophtheirus salmonis\tsalmon louse\t1\t5\t-\t72036\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Podoplea; Siphonostomatoida; Caligidae; Lepeophtheirus",
    "Lepidonotothen nudifrons\tyellowfin notie\t1\t2\t-\t83203\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Perciformes; Notothenioidei; Nototheniidae; Lepidonotothen",
    "Lepidothrix coronata\tblue-crowned manakin\t1\t2\t-\t321398\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Pipridae; Lepidothrix",
    "Lepisosteus oculatus\tspotted gar\t1\t2\t-\t7918\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Holostei; Semionotiformes; Lepisosteidae; Lepisosteus",
    "Leptasterias sp. AR-2014\t-\t1\t9\t-\t1462732\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Leptasterias",
    "Leptonychotes weddellii\tWeddell seal\t1\t2\t-\t9713\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Phocidae; Leptonychotes",
    "Leptosomus discolor\tcuckoo roller\t1\t2\t-\t188344\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coraciiformes; Leptosomidae; Leptosomus",
    "Leptospira interrogans\t-\t11\t0\t-\t173\tBCT\tcellular organisms; Bacteria; Spirochaetes; Spirochaetia; Leptospirales; Leptospiraceae; Leptospira",
    "Limnephilus lunatus\t-\t1\t5\t-\t1218281\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Trichoptera; Integripalpia; Plenitentoria; Limnephiloidea; Limnephilidae; Limnephilinae; Limnephilini; Limnephilus",
    "Limnoperna fortunei\t-\t1\t5\t-\t356393\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Mytiloida; Mytiloidea; Mytilidae; Mytilinae; Limnoperna",
    "Limulus polyphemus\tAtlantic horseshoe crab\t1\t5\t-\t6850\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Merostomata; Xiphosura; Limulidae; Limulus",
    "Linepithema humile\tArgentine ant\t1\t5\t-\t83485\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Dolichoderinae; Linepithema",
    "Lingula anatina\t-\t1\t5\t-\t7574\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Brachiopoda; Linguliformea; Lingulata; Lingulida; Linguloidea; Lingulidae; Lingula",
    "Lingulodinium polyedrum\t-\t1\t4\t11\t160621\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Gonyaulacales; Lingulodinium",
    "Lipotes vexillifer\tYangtze River dolphin\t1\t2\t-\t118797\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Lipotidae; Lipotes",
    "Listeria monocytogenes\t-\t11\t0\t-\t1639\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Bacillales; Listeriaceae; Listeria",
    "Litchi chinensis\t-\t1\t1\t11\t151069\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Sapindaceae; Litchi",
    "Litopenaeus vannamei\tPacific white shrimp\t1\t5\t-\t6689\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Dendrobranchiata; Penaeoidea; Penaeidae; Litopenaeus",
    "Loa loa\teye worm\t1\t5\t-\t7209\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Spirurida; Filarioidea; Onchocercidae; Loa",
    "Lolium perenne\t-\t1\t1\t11\t4522\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Loliinae; Lolium",
    "Lotus corniculatus\t-\t1\t1\t11\t47247\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Loteae; Lotus",
    "Loxodonta africana\tAfrican savanna elephant\t1\t2\t-\t9785\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Proboscidea; Elephantidae; Loxodonta",
    "Luidia clathrata\t-\t1\t9\t-\t133437\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Paxillosida; Luidiidae; Luidia",
    "Lupinus angustifolius\tnarrow-leaved blue lupine\t1\t1\t11\t3871\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Genisteae; Lupinus",
    "Lygodium japonicum\t-\t1\t1\t11\t13824\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Moniliformopses; Polypodiidae; Schizaeales; Lygodiaceae; Lygodium",
    "Lygus hesperus\tlygus bug\t1\t5\t-\t30085\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Neohemiptera; Prosorrhyncha; Heteroptera; Euheteroptera; Neoheteroptera; Panheteroptera; Cimicomorpha; Cimicoidea; Miridae; Mirinae; Mirini; Lygus",
    "Lymnaea stagnalis\tgreat pond snail\t1\t5\t-\t6523\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Hygrophila; Lymnaeoidea; Lymnaeidae; Lymnaea",
    "Lynx pardinus\tSpanish lynx\t1\t2\t-\t191816\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Felinae; Lynx",
    "Lytechinus variegatus\tgreen sea urchin\t1\t9\t-\t7654\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Temnopleuroida; Toxopneustidae; Lytechinus",
    "Macaca fascicularis\tcrab-eating macaque\t1\t2\t-\t9541\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca mulatta\tRhesus monkey\t1\t2\t-\t9544\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Macaca",
    "Macaca nemestrina\tpig-tailed macaque\t1\t2\t-\t9545\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Macaca",
    "Macropus eugenii\ttammar wallaby\t1\t2\t-\t9315\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Metatheria; Diprotodontia; Macropodidae; Macropus",
    "Malus domestica\tapple\t1\t1\t11\t3750\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Maleae; Malus",
    "Manacus vitellinus\tgolden-collared manakin\t1\t2\t-\t328815\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Pipridae; Manacus",
    "Mandrillus leucophaeus\tdrill\t1\t2\t-\t9568\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Mandrillus",
    "Mangifera indica\tmango\t1\t1\t11\t29780\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Sapindales; Anacardiaceae; Mangifera",
    "Manihot esculenta\tcassava\t1\t1\t11\t3983\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Crotonoideae; Manihoteae; Manihot",
    "Manis javanica\tMalayan pangolin\t1\t2\t-\t9974\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Pholidota; Manidae; Manis",
    "marine metagenome\t-\t11\t2\t11\t408172\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "marine sediment metagenome\t-\t11\t2\t11\t412755\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "Marmota marmota marmota\tAlpine marmot\t1\t2\t-\t9994\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Sciuridae; Xerinae; Marmotini; Marmota; Marmota marmota",
    "Marthasterias glacialis\tspiny starfish\t1\t9\t-\t7609\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Marthasterias",
    "Maylandia zebra\tzebra mbuna\t1\t2\t-\t106582\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Maylandia; Maylandia zebra complex",
    "Medauroidea extradentata\t-\t1\t5\t-\t614211\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Phasmatinae; Clitumnini; Medauroidea",
    "Medicago sativa\t-\t1\t1\t11\t3879\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Trifolieae; Medicago",
    "Medicago truncatula\tbarrel medic\t1\t1\t11\t3880\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Trifolieae; Medicago",
    "Megachile rotundata\talfalfa leafcutting bee\t1\t5\t-\t143995\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Megachilidae; Megachilinae; Megachilini; Megachile",
    "Megaderma lyra\tIndian false vampire\t1\t2\t-\t9413\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Megadermatidae; Megaderma",
    "Megajapyx sp. UVienna-2012\t-\t1\t5\t-\t1136246\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Diplura; Diplura; Dicellurata; Japygoidea; Japygidae; Japyginae; Megajapyx",
    "Megaselia scalaris\t-\t1\t5\t-\t36166\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Aschiza; Platypezoidea; Phoridae; Metopininae; Megaseliini; Megaselia",
    "Meleagris gallopavo\tturkey\t1\t2\t-\t9103\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Phasianidae; Meleagridinae; Meleagris",
    "Melopsittacus undulatus\tbudgerigar\t1\t2\t-\t13146\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Psittaciformes; Psittaculidae; Melopsittacus",
    "Mengenilla moldrzyki\t-\t1\t5\t-\t1155016\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Strepsiptera; Mengenillidia; Mengenilloidea; Mengenillidae; Mengenilla",
    "Meretrix meretrix\tAsiatic hard clam\t1\t5\t-\t291251\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Heteroconchia; Euheterodonta; Veneroida; Veneroidea; Veneridae; Meretrix",
    "Merops nubicus\tcarmine bee-eater\t1\t2\t-\t57421\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Coraciiformes; Meropidae; Merops",
    "Mesembryanthemum crystallinum\tcommon iceplant\t1\t1\t11\t3544\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Aizoaceae; Mesembryanthemum; Cryophytum",
    "Mesitornis unicolor\tbrown roatelo\t1\t2\t-\t54374\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Gruiformes; Mesitornithidae; Mesitornis",
    "Mesocricetus auratus\tgolden hamster\t1\t2\t-\t10036\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Cricetidae; Cricetinae; Mesocricetus",
    "Metaseiulus occidentalis\twestern predatory mite\t1\t5\t-\t34638\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Mesostigmata; Monogynaspida; Gamasina; Phytoseioidea; Phytoseiidae; Typhlodrominae; Metaseiulus",
    "Microcebus murinus\tgray mouse lemur\t1\t2\t-\t30608\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Strepsirrhini; Lemuriformes; Cheirogaleidae; Microcebus",
    "Microplitis demolitor\t-\t1\t5\t-\t69319\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Ichneumonoidea; Braconidae; Microgastrinae; Microplitis",
    "Micropterix calthella\t-\t1\t5\t-\t41027\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Zeugloptera; Micropterigidae; Micropterix",
    "Micropterus floridanus\tFlorida bass\t1\t2\t-\t225391\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus",
    "Micropterus salmoides\tlargemouth bass\t1\t2\t-\t27706\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus",
    "Micropterus salmoides salmoides\tnorthern largemouth bass\t1\t2\t-\t489037\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Centrarchiformes; Centrarchoidei; Centrarchidae; Micropterus; Micropterus salmoides",
    "Microtus ochrogaster\tprairie vole\t1\t2\t-\t79684\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Cricetidae; Arvicolinae; Microtus",
    "Miichthys miiuy\tMi-iuy croaker\t1\t2\t-\t240162\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Eupercaria incertae sedis; Sciaenidae; Miichthys",
    "mine drainage metagenome\t-\t11\t2\t11\t410659\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "Mischocyttarus flavitarsis\t-\t1\t5\t-\t231975\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Vespidae; Polistinae; Mischocyttarini; Mischocyttarus",
    "Momordica charantia\t-\t1\t1\t11\t3673\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Cucurbitales; Cucurbitaceae; Momordiceae; Momordica",
    "Moniezia expansa\tsheep tapeworm\t1\t9\t-\t28841\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Cestoda; Eucestoda; Cyclophyllidea; Anoplocephalidae; Moniezia",
    "Monodelphis domestica\tgray short-tailed opossum\t1\t2\t-\t13616\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Metatheria; Didelphimorphia; Didelphidae; Didelphinae; Monodelphis",
    "Monomorium chinense\t-\t1\t5\t-\t482359\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Solenopsidini; Monomorium",
    "Monomorium pharaonis\tpharaoh ant\t1\t5\t-\t307658\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Solenopsidini; Monomorium",
    "Morone chrysops\twhite bass\t1\t2\t-\t46259\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Eupercaria incertae sedis; Moronidae; Morone",
    "Morone saxatilis\tstriped sea-bass\t1\t2\t-\t34816\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Eupercaria incertae sedis; Moronidae; Morone",
    "Morus notabilis\t-\t1\t1\t11\t981085\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Moraceae; Morus",
    "Mus musculus\thouse mouse\t1\t2\t-\t10090\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Muridae; Murinae; Mus; Mus",
    "Musa ABB Group\t-\t1\t1\t11\t214693\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Zingiberales; Musaceae; Musa; Musa x paradisiaca",
    "Musa acuminata AAA Group\tdessert banana\t1\t1\t11\t214697\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Zingiberales; Musaceae; Musa; Musa acuminata",
    "Musa acuminata subsp. malaccensis\twild Malaysian banana\t1\t1\t11\t214687\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Zingiberales; Musaceae; Musa; Musa acuminata",
    "Musca domestica\thouse fly\t1\t5\t-\t7370\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Calyptratae; Muscoidea; Muscidae; Muscinae; Muscini; Musca; Musca",
    "Mustela putorius furo\tdomestic ferret\t1\t2\t-\t9669\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Mustelidae; Mustelinae; Mustela; Mustela putorius",
    "Mycobacterium abscessus\t-\t11\t0\t-\t36809\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Actinobacteria; Actinobacteria; Corynebacteriales; Mycobacteriaceae; Mycobacterium; Mycobacterium chelonae group; Mycobacterium abscessus subgroup",
    "Mycobacterium tuberculosis\t-\t11\t0\t-\t1773\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Actinobacteria; Actinobacteria; Corynebacteriales; Mycobacteriaceae; Mycobacterium; Mycobacterium tuberculosis complex",
    "Myotis brandtii\tBrandt's bat\t1\t2\t-\t109478\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myotis davidii\t-\t1\t2\t-\t225400\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myotis lucifugus\tlittle brown bat\t1\t2\t-\t59463\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myotis ricketti\tRickett's big-footed Myotis\t1\t2\t-\t203696\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Vespertilionidae; Myotis",
    "Myrionecta rubra\t-\t1\t4\t11\t283649\tINV\tcellular organisms; Eukaryota; Alveolata; Ciliophora; Intramacronucleata; Litostomatea; Haptoria; Cyclotrichida; Mesodiniidae; Myrionecta",
    "Myrmica rubra\t-\t1\t5\t-\t106198\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Myrmicini; Myrmica",
    "Myrmica ruginodis\t-\t1\t5\t-\t34708\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Myrmicini; Myrmica",
    "Myrmica sulcinodis\t-\t1\t5\t-\t229918\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Myrmicini; Myrmica",
    "Mytilus galloprovincialis\tMediterranean mussel\t1\t5\t-\t29158\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Mytiloida; Mytiloidea; Mytilidae; Mytilinae; Mytilus",
    "Nannochorista philpotti\t-\t1\t5\t-\t1260225\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Mecoptera; Nannochoristidae; Nannochorista",
    "Nannospalax galili\tUpper Galilee mountains blind mole rat\t1\t2\t-\t1026970\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Spalacidae; Spalacinae; Nannospalax",
    "Nanorana parkeri\t-\t1\t2\t-\t125878\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Neobatrachia; Ranoidea; Dicroglossidae; Dicroglossinae; Nanorana",
    "Nasonia vitripennis\tjewel wasp\t1\t5\t-\t7425\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Chaldicoidea group; Chalcidoidea; Pteromalidae; Pteromalinae; Nasonia",
    "Necator americanus\t-\t1\t5\t-\t51031\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Ancylostomatoidea; Ancylostomatidae; Bunostominae; Necator",
    "Neisseria gonorrhoeae\t-\t11\t0\t-\t485\tBCT\tcellular organisms; Bacteria; Proteobacteria; Betaproteobacteria; Neisseriales; Neisseriaceae; Neisseria",
    "Neisseria meningitidis\t-\t11\t0\t-\t487\tBCT\tcellular organisms; Bacteria; Proteobacteria; Betaproteobacteria; Neisseriales; Neisseriaceae; Neisseria",
    "Nelumbo nucifera\tsacred lotus\t1\t1\t11\t4432\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; stem eudicotyledons; Proteales; Nelumbonaceae; Nelumbo",
    "Nematostella vectensis\tstarlet sea anemone\t1\t4\t-\t45351\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Actiniaria; Edwardsiidae; Nematostella",
    "Neolamarckia cadamba\t-\t1\t1\t11\t153762\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Rubiaceae; Cinchonoideae; Naucleeae; Neolamarckia",
    "Neolamprologus brichardi\t-\t1\t2\t-\t32507\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Lamprologini; Neolamprologus",
    "Nestor notabilis\tKea\t1\t2\t-\t176057\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Psittaciformes; Psittacidae; Nestor",
    "Nicotiana attenuata\t-\t1\t1\t11\t49451\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana benthamiana\t-\t1\t1\t11\t4100\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana sylvestris\twood tobacco\t1\t1\t11\t4096\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana tabacum\tcommon tobacco\t1\t1\t11\t4097\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicotiana tomentosiformis\t-\t1\t1\t11\t4098\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Nicotianoideae; Nicotianeae; Nicotiana",
    "Nicrophorus vespilloides\t-\t1\t5\t-\t110193\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Staphyliniformia; Staphylinoidea; Silphidae; Nicrophorinae; Nicrophorus",
    "Nilaparvata lugens\tbrown planthopper\t1\t5\t-\t108931\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Euhemiptera; Neohemiptera; Archaeorrhyncha; Fulgoroidea; Delphacidae; Delphacinae; Nilaparvata",
    "Nipponia nippon\tcrested ibis\t1\t2\t-\t128390\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Threskiornithidae; Nipponia",
    "Nitella hyalina\t-\t1\t1\t11\t181804\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Charophyceae; Charales; Characeae; Nitella",
    "Nitella mirabilis\t-\t1\t1\t11\t231897\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Charophyceae; Charales; Characeae; Nitella",
    "Noccaea caerulescens\t-\t1\t1\t11\t107243\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Coluteocarpeae; Noccaea",
    "Nomascus leucogenys\tnorthern white-cheeked gibbon\t1\t2\t-\t61853\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hylobatidae; Nomascus",
    "Nothobranchius furzeri\tturquoise killifish\t1\t2\t-\t105023\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Nothobranchius kadleci\t-\t1\t2\t-\t1051664\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Nothobranchius korthausae\t-\t1\t2\t-\t1143690\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Nothobranchius kuhntae\tBeira killifish\t1\t2\t-\t321403\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Nothobranchius pienaari\t-\t1\t2\t-\t704102\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Nothobranchius rachovii\tbluefin notho\t1\t2\t-\t451742\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Aplocheiloidei; Nothobranchiidae; Nothobranchius",
    "Notholithocarpus densiflorus\t-\t1\t1\t11\t165545\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Notholithocarpus",
    "Notothenia coriiceps\tblack rockcod\t1\t2\t-\t8208\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Perciformes; Notothenioidei; Nototheniidae; Notothenia",
    "Numida meleagris\thelmeted guineafowl\t1\t2\t-\t8996\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Galloanserae; Galliformes; Numididae; Numida",
    "Nylanderia pubens\t-\t1\t5\t-\t613973\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Formicinae; Lasiini; Nylanderia",
    "Ochotona princeps\tAmerican pika\t1\t2\t-\t9978\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Lagomorpha; Ochotonidae; Ochotona",
    "Ochromonas sp. LO244K-D\t-\t1\t1\t11\t1825117\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; Chromulinales; Chromulinaceae; Ochromonas",
    "Octodon degus\tdegu\t1\t2\t-\t10160\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Hystricognathi; Octodontidae; Octodon",
    "Octopus bimaculoides\t-\t1\t5\t-\t37653\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Cephalopoda; Coleoidea; Neocoleoidea; Octopodiformes; Octopoda; Incirrata; Octopodidae; Octopus",
    "Odobenus rosmarus divergens\tPacific walrus\t1\t2\t-\t9708\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Odobenidae; Odobenus; Odobenus rosmarus",
    "Oenococcus oeni\t-\t11\t0\t-\t1247\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Leuconostocaceae; Oenococcus",
    "Oesophagostomum dentatum\t-\t1\t5\t-\t61180\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Strongyloidea; Cloacinidae; Oesophagostomum",
    "Olavius algarvensis\t-\t1\t5\t-\t188229\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Annelida; Clitellata; Oligochaeta; Haplotaxida; Tubificina; Tubificidae; Phallodrilinae; Olavius",
    "Olea europaea\tcommon olive\t1\t1\t11\t4146\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Oleaceae; Oleeae; Olea",
    "Onchocerca flexuosa\t-\t1\t5\t-\t387005\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Spirurida; Filarioidea; Onchocercidae; Onchocerca",
    "Oncidium hybrid cultivar\t-\t1\t1\t11\t141207\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Orchidaceae; Epidendroideae; Cymbidieae; Oncidiinae; Oncidium",
    "Oncorhynchus masou masou\tcherry salmon\t1\t2\t-\t90313\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus; Oncorhynchus masou",
    "Oncorhynchus mykiss\trainbow trout\t1\t2\t-\t8022\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Oncorhynchus",
    "Onthophagus nigriventris\t-\t1\t5\t-\t476074\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Polyphaga; Scarabaeiformia; Scarabaeoidea; Scarabaeidae; Scarabaeinae; Scarabaeinae incertae sedis; Onthophagus",
    "Ophiocoma echinata\t-\t1\t9\t-\t331088\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Ophiuroidea; Ophiuridea; Ophiurida; Ophiurina; Gnathophiurina; Ophiocomidae; Ophiocominae; Ophiocoma",
    "Ophthalmotilapia ventralis\t-\t1\t2\t-\t27755\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Ectodini; Ophthalmotilapia",
    "Opisthorchis viverrini\t-\t1\t9\t-\t6198\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Opisthorchiida; Opisthorchiata; Opisthorchiidae; Opisthorchis",
    "Orchesella cincta\t-\t1\t5\t-\t48709\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Collembola; Collembola; Entomobryomorpha; Entomobryoidea; Entomobryidae; Orchesellinae; Orchesella",
    "Oreochromis niloticus\tNile tilapia\t1\t2\t-\t8128\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Oreochromini; Oreochromis",
    "Ornithorhynchus anatinus\tplatypus\t1\t2\t-\t9258\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Prototheria; Monotremata; Ornithorhynchidae; Ornithorhynchus",
    "Oropsylla silantiewi\t-\t1\t5\t-\t1461318\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Siphonaptera; Ceratophyllomorpha; Ceratophylloidea; Ceratophyllidae; Oropsylla",
    "Orycteropus afer afer\t-\t1\t2\t-\t1230840\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Tubulidentata; Orycteropodidae; Orycteropus; Orycteropus afer",
    "Oryctolagus cuniculus\trabbit\t1\t2\t-\t9986\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Lagomorpha; Leporidae; Oryctolagus",
    "Oryza brachyantha\tmalo sina\t1\t1\t11\t4533\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza sativa\trice\t1\t1\t11\t4530\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza",
    "Oryza sativa Indica Group\tlong-grained rice\t1\t1\t11\t39946\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryza sativa Japonica Group\tJapanese rice\t1\t1\t11\t39947\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Oryzoideae; Oryzeae; Oryzinae; Oryza; Oryza sativa",
    "Oryzias latipes\tJapanese medaka\t1\t2\t-\t8090\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Beloniformes; Adrianichthyoidei; Adrianichthyidae; Oryziinae; Oryzias",
    "Osmia cornuta\t-\t1\t5\t-\t185587\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Apoidea; Megachilidae; Megachilinae; Osmiini; Osmia",
    "Ostrinia furnacalis\tAsian corn borer\t1\t5\t-\t93504\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Pyraloidea; Crambidae; Pyraustinae; Ostrinia",
    "Ostrinia nubilalis\tEuropean corn borer\t1\t5\t-\t29057\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Pyraloidea; Crambidae; Pyraustinae; Ostrinia",
    "Otolemur garnettii\tsmall-eared galago\t1\t2\t-\t30611\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Strepsirrhini; Lorisiformes; Galagidae; Otolemur",
    "Ovis aries\tsheep\t1\t2\t-\t9940\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Ovis",
    "Ovis aries musimon\tmouflon\t1\t2\t-\t9938\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Caprinae; Ovis; Ovis aries",
    "Pachycladon fastigiatum\t-\t1\t1\t11\t106774\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Microlepidieae; Pachycladon",
    "Pachypsylla venusta\thackberry petiole gall psyllid\t1\t5\t-\t38123\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Paraneoptera; Hemiptera; Sternorrhyncha; Psylliformes; Psylloidea; Psyllidae; Pachypsylla",
    "Paeonia lactiflora\tChinese peony\t1\t1\t11\t35924\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Saxifragales; Paeoniaceae; Paeonia",
    "Pan paniscus\tpygmy chimpanzee\t1\t2\t-\t9597\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Pan",
    "Pan troglodytes\tchimpanzee\t1\t2\t-\t9598\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Pan",
    "Pan troglodytes troglodytes\t-\t1\t2\t-\t37011\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Pan; Pan troglodytes",
    "Pan troglodytes verus\t-\t1\t2\t-\t37012\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Homininae; Pan; Pan troglodytes",
    "Panax ginseng\t-\t1\t1\t11\t4054\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Apiales; Apiineae; Araliaceae; Panax",
    "Panicum hallii var. filipes\t-\t1\t1\t11\t907226\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Panicinae; Panicum; Panicum hallii",
    "Panthera tigris altaica\tAmur tiger\t1\t2\t-\t74533\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Feliformia; Felidae; Pantherinae; Panthera; Panthera tigris",
    "Pantholops hodgsonii\tchiru\t1\t2\t-\t59538\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Ruminantia; Pecora; Bovidae; Antilopinae; Pantholops",
    "Papilio machaon\tcommon yellow swallowtail\t1\t5\t-\t76193\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Papilionoidea; Papilionidae; Papilioninae; Papilionini; Papilio",
    "Papilio xuthus\tAsian swallowtail\t1\t5\t-\t66420\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Papilionoidea; Papilionidae; Papilioninae; Papilionini; Papilio",
    "Papio anubis\tolive baboon\t1\t2\t-\t9555\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Papio",
    "Papio hamadryas\thamadryas baboon\t1\t2\t-\t9557\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Cercopithecinae; Papio",
    "Paramecium tetraurelia strain d4-2\t-\t6\t4\t11\t412030\tINV\tcellular organisms; Eukaryota; Alveolata; Ciliophora; Intramacronucleata; Oligohymenophorea; Peniculida; Parameciidae; Paramecium; Paramecium tetraurelia",
    "Parascaris equorum\t-\t1\t5\t-\t6256\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Ascaridida; Ascaridoidea; Ascarididae; Parascaris",
    "Parasteatoda tepidariorum\tcommon house spider\t1\t5\t-\t114398\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Orbiculariae; Araneoidea; Theridiidae; Parasteatoda",
    "Parus major\tGreat Tit\t1\t2\t-\t9157\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Paridae; Parus",
    "Patiria miniata\tbat star\t1\t9\t-\t46514\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Valvatida; Asterinidae; Patiria",
    "Patiria pectinifera\t-\t1\t9\t-\t7594\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Valvatacea; Valvatida; Asterinidae; Patiria",
    "Pecten maximus\t-\t1\t5\t-\t6579\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Pteriomorphia; Pectinoida; Pectinoidea; Pectinidae; Pecten",
    "Pedospumella encystans\t-\t1\t1\t11\t1117030\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; Chromulinales; Chromulinaceae; Pedospumella",
    "Pelecanus crispus\tDalmatian pelican\t1\t2\t-\t36300\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Pelecanidae; Pelecanus",
    "Pelodiscus sinensis\tChinese soft-shelled turtle\t1\t2\t-\t13735\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Testudines; Cryptodira; Trionychia; Trionychidae; Pelodiscus",
    "Penaeus monodon\tblack tiger shrimp\t1\t5\t-\t6687\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Dendrobranchiata; Penaeoidea; Penaeidae; Penaeus",
    "Pepsis grossa\t-\t1\t5\t-\t1317727\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Pompiloidea; Pompilidae; Pepsinae; Pepsis",
    "Perkinsus marinus ATCC 50983\t-\t1\t4\t11\t423536\tINV\tcellular organisms; Eukaryota; Alveolata; Perkinsea; Perkinsida; Perkinsidae; Perkinsus; Perkinsus marinus",
    "Peromyscus maniculatus bairdii\tprairie deer mouse\t1\t2\t-\t230844\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Cricetidae; Neotominae; Peromyscus; Peromyscus maniculatus",
    "Persicaria minor\t-\t1\t1\t11\t488003\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Polygonaceae; Polygonoideae; Persicarieae; Persicaria",
    "Petunia integrifolia subsp. inflata\t-\t1\t1\t11\t212142\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Petunioideae; Petunia; Petunia integrifolia",
    "Phaethon lepturus\twhite-tailed tropicbird\t1\t2\t-\t97097\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Phaethontidae; Phaethon",
    "Phalacrocorax carbo\tgreat cormorant\t1\t2\t-\t9209\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Pelecaniformes; Phalacrocoracidae; Phalacrocorax",
    "Phalaenopsis aphrodite\t-\t1\t1\t11\t212056\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; Asparagales; Orchidaceae; Epidendroideae; Vandeae; Aeridinae; Phalaenopsis",
    "Phaseolus vulgaris\t-\t1\t1\t11\t3885\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Phaseolus",
    "Phoca largha\tspotted seal\t1\t2\t-\t39090\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Phocidae; Phoca",
    "Phoenicopterus ruber ruber\t-\t1\t2\t-\t9218\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Phoenicopteriformes; Phoenicopteridae; Phoenicopterus; Phoenicopterus ruber",
    "Phoenix dactylifera\tdate palm\t1\t1\t11\t42345\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Arecales; Arecaceae; Coryphoideae; Phoeniceae; Phoenix",
    "Physalis alkekengi var. franchetii\t-\t1\t1\t11\t221454\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Physaleae; Physalis; Physalis alkekengi",
    "Physalis peruviana\t-\t1\t1\t11\t126903\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Physaleae; Physalis",
    "Physcomitrella patens\t-\t1\t1\t11\t3218\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Bryophyta; Bryophytina; Bryopsida; Funariidae; Funariales; Funariaceae; Physcomitrella",
    "Physeter catodon\tsperm whale\t1\t2\t-\t9755\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Physeteridae; Physeter",
    "Phytophthora cambivora\t-\t1\t1\t11\t53983\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Oomycetes; Peronosporales; Phytophthora",
    "Phytophthora cinnamomi\t-\t1\t1\t11\t4785\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Oomycetes; Peronosporales; Phytophthora",
    "Phytophthora x alni\t-\t1\t1\t11\t299392\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Oomycetes; Peronosporales; Phytophthora",
    "Picea glauca\twhite spruce\t1\t1\t11\t3330\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Picea",
    "Picoides pubescens\tdowny woodpecker\t1\t2\t-\t118200\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Piciformes; Picidae; Picoides",
    "Pinus massoniana\t-\t1\t1\t11\t88730\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pinus sylvestris\tScots pine\t1\t1\t11\t3349\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pinus taeda\tloblolly pine\t1\t1\t11\t3352\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Pinus; Pinus",
    "Pisaster ochraceus\tpurple sea star\t1\t9\t-\t7612\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Asterozoa; Asteroidea; Forcipulatacea; Forcipulatida; Asteriidae; Pisaster",
    "Pisum sativum\tpea\t1\t1\t11\t3888\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Fabeae; Pisum",
    "Pisum sativum subsp. sativum\t-\t1\t1\t11\t208194\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Fabeae; Pisum; Pisum sativum",
    "Plakobranchus ocellatus\t-\t1\t5\t-\t259542\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Gastropoda; Heterobranchia; Euthyneura; Panpulmonata; Sacoglossa; Placobranchoidea; Placobranchidae; Plakobranchus",
    "Plasmodium falciparum\tmalaria parasite P. falciparum\t1\t4\t11\t5833\tINV\tcellular organisms; Eukaryota; Alveolata; Apicomplexa; Aconoidasida; Haemosporida; Plasmodiidae; Plasmodium; Plasmodium (Laverania)",
    "Plecoglossus altivelis\tayu\t1\t2\t-\t61084\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Stomiatii; Osmeriformes; Plecoglossidae; Plecoglossus",
    "Plecoglossus altivelis altivelis\t-\t1\t2\t-\t281464\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Stomiatii; Osmeriformes; Plecoglossidae; Plecoglossus; Plecoglossus altivelis",
    "Plukenetia volubilis\t-\t1\t1\t11\t316893\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Acalyphoideae; Plukenetieae; Plukenetia",
    "Plutella xylostella\tdiamondback moth\t1\t5\t-\t51655\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Yponomeutoidea; Plutellidae; Plutella",
    "Poa infirma\t-\t1\t1\t11\t165094\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Poinae; Poa",
    "Poa supina\t-\t1\t1\t11\t289064\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Poodae; Poeae; Poeae Chloroplast Group 2 (Poeae type); Poinae; Poa",
    "Podiceps cristatus\tgreat crested grebe\t1\t2\t-\t345573\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Podicipediformes; Podicipedidae; Podiceps",
    "Poecilia formosa\tAmazon molly\t1\t2\t-\t48698\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Poecilia",
    "Poecilia latipinna\tsailfin molly\t1\t2\t-\t48699\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Poecilia",
    "Poecilia mexicana\t-\t1\t2\t-\t48701\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Poecilia",
    "Poecilia reticulata\tguppy\t1\t2\t-\t8081\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Poecilia",
    "Poeciliopsis prolifica\tblackstripe livebearer\t1\t2\t-\t188132\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Poeciliopsis",
    "Pogonus chalceus\t-\t1\t5\t-\t235516\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Coleoptera; Adephaga; Caraboidea; Carabidae; Trechinae; Pogonini; Pogonus",
    "Pohlia nutans\t-\t1\t1\t11\t140635\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Bryophyta; Bryophytina; Bryopsida; Bryidae; Bryanae; Bryales; Mniaceae; Pohlia",
    "Polistes canadensis\t-\t1\t5\t-\t91411\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Vespidae; Polistinae; Polistini; Polistes",
    "Polistes metricus\t-\t1\t5\t-\t91422\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Vespidae; Polistinae; Polistini; Polistes",
    "Pongo abelii\tSumatran orangutan\t1\t2\t-\t9601\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Hominoidea; Hominidae; Ponginae; Pongo",
    "Populus euphratica\tEuphrates poplar\t1\t1\t11\t75702\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Salicaceae; Saliceae; Populus",
    "Populus trichocarpa\tblack cottonwood\t1\t1\t11\t3694\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Salicaceae; Saliceae; Populus",
    "Porites australiensis\t-\t1\t4\t-\t51061\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Fungiina; Poritidae; Porites",
    "Poterioochromonas sp. DS\t-\t1\t1\t11\t519425\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Synurophyceae; Ochromonadales; Ochromonadaceae; Poterioochromonas",
    "Priapulus caudatus\t-\t1\t5\t-\t37621\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Scalidophora; Priapulida; Priapulidae; Priapulus",
    "Proasellus aragonensis\t-\t1\t5\t-\t1281939\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus arthrodilus\t-\t1\t5\t-\t1281940\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus assaforensis\t-\t1\t5\t-\t1282049\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus cantabricus\t-\t1\t5\t-\t1281948\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus cavaticus\t-\t1\t5\t-\t1281949\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus coiffaiti\t-\t1\t5\t-\t1281953\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus coxalis\t-\t1\t5\t-\t63229\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ebrensis\t-\t1\t5\t-\t1281961\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus escolai\t-\t1\t5\t-\t1281963\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus grafi\t-\t1\t5\t-\t1281973\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus granadensis\t-\t1\t5\t-\t1281974\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus hercegovinensis\t-\t1\t5\t-\t1281977\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ibericus\t-\t1\t5\t-\t1281981\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus jaloniacus\t-\t1\t5\t-\t1281986\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus karamani\t-\t1\t5\t-\t1281987\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus margalefi\t-\t1\t5\t-\t1281998\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus meridianus\t-\t1\t5\t-\t1282001\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus ortizi\t-\t1\t5\t-\t1282012\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus racovitzai\t-\t1\t5\t-\t1282023\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus rectus\t-\t1\t5\t-\t1282025\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus solanasi\t-\t1\t5\t-\t1282031\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Proasellus spelaeus\t-\t1\t5\t-\t1282033\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Peracarida; Isopoda; Asellota; Aselloidea; Asellidae; Proasellus",
    "Procambarus clarkii\tred swamp crayfish\t1\t5\t-\t6728\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Astacidea; Astacoidea; Cambaridae; Cambarinae; Procambarus",
    "Procotyla fluviatilis\t-\t1\t9\t-\t231627\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Planarioidea; Dendrocoelidae; Procotyla",
    "Propithecus coquereli\tCoquerel's sifaka\t1\t2\t-\t379532\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Strepsirrhini; Lemuriformes; Indriidae; Propithecus",
    "Prosopis alba\t-\t1\t1\t11\t207710\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Mimosoideae; Mimoseae; Prosopis",
    "Protobothrops mucrosquamatus\t-\t1\t2\t-\t103944\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Viperidae; Crotalinae; Protobothrops",
    "Protopolystoma xenopodis\t-\t1\t9\t-\t117903\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Monogenea; Polyopisthocotylea; Polystomatidae; Protopolystoma",
    "Prunus armeniaca\tapricot\t1\t1\t11\t36596\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Amygdaleae; Prunus",
    "Prunus mume\tJapanese apricot\t1\t1\t11\t102107\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Amygdaleae; Prunus",
    "Prunus persica\tpeach\t1\t1\t11\t3760\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Amygdaleae; Prunus",
    "Prymnesium parvum\t-\t1\t1\t11\t97485\tPLN\tcellular organisms; Eukaryota; Haptophyceae; Prymnesiales; Prymnesiaceae; Prymnesium",
    "Pseudacris regilla\tPacific treefrog\t1\t2\t-\t47562\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Neobatrachia; Hyloidea; Hylidae; Hylinae; Hylini; Pseudacris",
    "Pseudodiploria strigosa\t-\t1\t4\t-\t1428006\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Faviina; Mussidae; Faviinae; Pseudodiploria",
    "Pseudomasaris vespoides\t-\t1\t5\t-\t1317726\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Vespidae; Masarinae; Masarini; Pseudomasaris",
    "Pseudomonas aeruginosa\t-\t11\t0\t-\t287\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Pseudomonadaceae; Pseudomonas; Pseudomonas aeruginosa group",
    "Pseudopodoces humilis\tTibetan ground-tit\t1\t2\t-\t181119\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Paridae; Pseudopodoces",
    "Pseudotsuga menziesii var. menziesii\t-\t1\t1\t11\t278161\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Pinales; Pinaceae; Pseudotsuga; Pseudotsuga menziesii",
    "Pteridium aquilinum subsp. aquilinum\t-\t1\t1\t11\t104588\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Moniliformopses; Polypodiidae; Polypodiales; Dennstaedtiaceae; Pteridium; Pteridium aquilinum",
    "Pterocles gutturalis\tyellow-throated sandgrouse\t1\t2\t-\t240206\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Ciconiiformes; Pteroclidae; Pterocles",
    "Pteronotus parnellii\tParnell's mustached bat\t1\t2\t-\t59476\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Mormoopidae; Pteronotus",
    "Pteropus alecto\tblack flying fox\t1\t2\t-\t9402\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Pteropus",
    "Pteropus vampyrus\tlarge flying fox\t1\t2\t-\t132908\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Pteropus",
    "Ptychodera flava\t-\t1\t9\t-\t63121\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Hemichordata; Enteropneusta; Ptychoderidae; Ptychodera",
    "Puccinia psidii\t-\t1\t4\t-\t181123\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Basidiomycota; Pucciniomycotina; Pucciniomycetes; Pucciniales; Pucciniaceae; Puccinia",
    "Pundamilia nyererei\t-\t1\t2\t-\t303518\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Cichlomorphae; Cichliformes; Cichlidae; African cichlids; Pseudocrenilabrinae; Haplochromini; Pundamilia",
    "Punica granatum\tpomegranate\t1\t1\t11\t22663\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Myrtales; Lythraceae; Punica",
    "Pygocentrus nattereri\tred-bellied piranha\t1\t2\t-\t42514\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Characiphysae; Characiformes; Characoidei; Serrasalmidae; Pygocentrus",
    "Pygoscelis adeliae\tAdelie penguin\t1\t2\t-\t9238\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Sphenisciformes; Spheniscidae; Pygoscelis",
    "Pyrodinium bahamense var. compressum\t-\t1\t4\t11\t73916\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Gonyaulacales; Goniodomataceae; Pyrodinium; Pyrodinium bahamense",
    "Pyrus communis\tpear\t1\t1\t11\t23211\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Maleae; Pyrus",
    "Pyrus x bretschneideri\tChinese white pear\t1\t1\t11\t225117\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Maloideae; Maleae; Pyrus",
    "Python bivittatus\tBurmese python\t1\t2\t-\t176946\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Henophidia; Pythonidae; Python",
    "Quercus suber\t-\t1\t1\t11\t58331\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fagales; Fagaceae; Quercus",
    "Ramulus artemis\t-\t1\t5\t-\t1390046\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Phasmatodea; Verophasmatodea; Anareolatae; Phasmatidae; Phasmatinae; Clitumnini; Ramulus",
    "Rana clamitans\tbronze frog\t1\t2\t-\t145282\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Neobatrachia; Ranoidea; Ranidae; Rana; Aquarana",
    "Raphanus sativus\tradish\t1\t1\t11\t3726\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Brassicaceae; Brassiceae; Raphanus",
    "Rattus norvegicus\tNorway rat\t1\t2\t-\t10116\tROD\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Glires; Rodentia; Sciurognathi; Muroidea; Muridae; Murinae; Rattus",
    "Rauvolfia serpentina\tserpentwood\t1\t1\t11\t4060\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Gentianales; Apocynaceae; Rauvolfioideae; Vinceae; Rauvolfiinae; Rauvolfia",
    "Reaumuria trigyna\t-\t1\t1\t11\t1091135\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Tamaricaceae; Reaumuria",
    "Rhagoletis zephyria\tsnowberry fruit fly\t1\t5\t-\t28612\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Tephritoidea; Tephritidae; Trypetinae; Carpomyini; Carpomyina; Rhagoletis",
    "Rhinolophus ferrumequinum\tgreater horseshoe bat\t1\t2\t-\t59479\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Microchiroptera; Rhinolophidae; Rhinolophinae; Rhinolophus",
    "Rhinopithecus bieti\tblack snub-nosed monkey\t1\t2\t-\t61621\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Colobinae; Rhinopithecus",
    "Rhinopithecus roxellana\tgolden snub-nosed monkey\t1\t2\t-\t61622\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Catarrhini; Cercopithecoidea; Cercopithecidae; Colobinae; Rhinopithecus",
    "Rhipicephalus sanguineus\tbrown dog tick\t1\t5\t-\t34632\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Parasitiformes; Ixodida; Ixodoidea; Ixodidae; Rhipicephalinae; Rhipicephalus; Rhipicephalus; Rhipicephalus sanguineus group",
    "Rhizoctonia solani AG-1 IA\t-\t1\t4\t-\t983506\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Basidiomycota; Agaricomycotina; Agaricomycetes; Agaricomycetes incertae sedis; Cantharellales; Ceratobasidiaceae; Rhizoctonia; Rhizoctonia solani",
    "Rhodinia newara\t-\t1\t5\t-\t1579501\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Saturniini; Rhodinia",
    "Ricinus communis\tcastor bean\t1\t1\t11\t3988\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Malpighiales; Euphorbiaceae; Acalyphoideae; Acalypheae; Ricinus",
    "Romanomermis culicivorax\t-\t1\t5\t-\t13658\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Enoplea; Dorylaimia; Mermithida; Mermithoidea; Mermithidae; Romanomermis",
    "Rousettus aegyptiacus\tEgyptian rousette\t1\t2\t-\t9407\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Chiroptera; Megachiroptera; Pteropodidae; Pteropodinae; Rousettus",
    "Rubus hybrid cultivar\t-\t1\t1\t11\t564016\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rosaceae; Rosoideae; Rosoideae unplaced; Rubus",
    "Rumex palustris\t-\t1\t1\t11\t50298\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Polygonaceae; Polygonoideae; Rumiceae; Rumex",
    "Saccharomyces cerevisiae\tbaker's yeast\t1\t3\t-\t4932\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Ascomycota; saccharomyceta; Saccharomycotina; Saccharomycetes; Saccharomycetales; Saccharomycetaceae; Saccharomyces",
    "Saccharomyces pastorianus\t-\t1\t3\t-\t27292\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Ascomycota; saccharomyceta; Saccharomycotina; Saccharomycetes; Saccharomycetales; Saccharomycetaceae; Saccharomyces",
    "Saccoglossus kowalevskii\t-\t1\t9\t-\t10224\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Hemichordata; Enteropneusta; Harrimaniidae; Saccoglossus",
    "Saimiri boliviensis boliviensis\tBolivian squirrel monkey\t1\t2\t-\t39432\tPRI\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Primates; Haplorrhini; Simiiformes; Platyrrhini; Cebidae; Saimiriinae; Saimiri; Saimiri boliviensis",
    "Salicornia europaea\t-\t1\t1\t11\t206448\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Salicornioideae; Salicornia",
    "Salmo salar\tAtlantic salmon\t1\t2\t-\t8030\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Protacanthopterygii; Salmoniformes; Salmonidae; Salmoninae; Salmo",
    "Salmonella enterica\t-\t11\t0\t-\t28901\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella",
    "Salmonella enterica subsp. enterica serovar Typhi\t-\t11\t0\t-\t90370\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella; Salmonella enterica; Salmonella enterica subsp. enterica",
    "Salmonella enterica subsp. enterica serovar Typhimurium\t-\t11\t0\t-\t90371\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella; Salmonella enterica; Salmonella enterica subsp. enterica",
    "Salmonella enterica subsp. enterica serovar Typhimurium str. DT104\t-\t11\t0\t-\t85569\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Salmonella; Salmonella enterica; Salmonella enterica subsp. enterica; Salmonella enterica subsp. enterica serovar Typhimurium",
    "Samia ricini\tIndian eri silkmoth\t1\t5\t-\t63990\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Bombycoidea; Saturniidae; Saturniinae; Attacini; Samia",
    "Sarcophilus harrisii\tTasmanian devil\t1\t2\t-\t9305\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Metatheria; Dasyuromorphia; Dasyuridae; Sarcophilus",
    "Sarsinebalia urgorrii\t-\t1\t5\t-\t1032695\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Phyllocarida; Leptostraca; Nebaliidae; Sarsinebalia",
    "Saussurea involucrata\t-\t1\t1\t11\t200489\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; campanulids; Asterales; Asteraceae; Carduoideae; Cardueae; Carduinae; Saussurea",
    "Sceliphron caementarium\t-\t1\t5\t-\t253855\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Sphecoidea; Sphecidae; Sphecinae; Sceliphrini; Sceliphrina; Sceliphron",
    "Schistocephalus solidus\t-\t1\t9\t-\t70667\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Cestoda; Eucestoda; Diphyllobothriidea; Diphyllobothriidae; Schistocephalus",
    "Schistosoma curassoni\t-\t1\t9\t-\t6186\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma haematobium\t-\t1\t9\t-\t6185\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma japonicum\t-\t1\t9\t-\t6182\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma mansoni\t-\t1\t9\t-\t6183\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma mattheei\t-\t1\t9\t-\t31246\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schistosoma rodhaini\t-\t1\t9\t-\t6188\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Schistosoma",
    "Schmidtea mediterranea\t-\t1\t9\t-\t79327\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Rhabditophora; Seriata; Tricladida; Continenticola; Geoplanoidea; Dugesiidae; Schmidtea",
    "Sclerodactyla briareus\t-\t1\t9\t-\t7710\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Holothuroidea; Dendrochirotacea; Dendrochirotida; Sclerodactylidae; Sclerodactyla",
    "Scleropages formosus\tAsian bonytongue\t1\t2\t-\t113540\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Osteoglossocephala; Osteoglossomorpha; Osteoglossiformes; Osteoglossidae; Scleropages",
    "Sclerotinia homoeocarpa\t-\t1\t4\t-\t38483\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Ascomycota; saccharomyceta; Pezizomycotina; leotiomyceta; sordariomyceta; Leotiomycetes; Helotiales; Sclerotiniaceae; Sclerotinia",
    "Scophthalmus maximus\tturbot\t1\t2\t-\t52904\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Carangaria; Pleuronectiformes; Pleuronectoidei; Scophthalmidae; Scophthalmus",
    "Scylla olivacea\torange mud crab\t1\t5\t-\t85551\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Malacostraca; Eumalacostraca; Eucarida; Decapoda; Pleocyemata; Brachyura; Eubrachyura; Heterotremata; Portunoidea; Portunidae; Scylla",
    "Sebastes nigrocinctus\ttiger rockfish\t1\t2\t-\t72089\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Perciformes; Scorpaenoidei; Sebastidae; Sebastinae; Sebastes",
    "Secale cereale\trye\t1\t1\t11\t4550\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Hordeinae; Secale",
    "Sedum alfredii\t-\t1\t1\t11\t439688\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Saxifragales; Crassulaceae; Sedum",
    "Selaginella moellendorffii\t-\t1\t1\t11\t88036\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Lycopodiidae; Selaginellales; Selaginellaceae; Selaginella",
    "Serinus canaria\tcommon canary\t1\t2\t-\t9135\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Fringillidae; Carduelinae; Serinus",
    "Sesamum indicum\tsesame\t1\t1\t11\t4182\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Lamiales; Pedaliaceae; Sesamum",
    "Setaria italica\tfoxtail millet\t1\t1\t11\t4555\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Panicodae; Paniceae; Cenchrinae; Setaria",
    "Shigella sonnei\t-\t11\t0\t-\t624\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Enterobacterales; Enterobacteriaceae; Shigella",
    "Silene latifolia\t-\t1\t1\t11\t37657\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Caryophyllaceae; Sileneae; Silene",
    "Simian immunodeficiency virus\t-\t1\t0\t-\t11723\tVRL\tViruses; Retro-transcribing viruses; Retroviridae; Orthoretrovirinae; Lentivirus; Primate lentivirus group",
    "Sinocyclocheilus angustiporus\t-\t1\t2\t-\t307947\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus anophthalmus\teyeless golden-line fish\t1\t2\t-\t307955\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus anshuiensis\t-\t1\t2\t-\t1608454\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus grahami\t-\t1\t2\t-\t75366\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Sinocyclocheilus",
    "Sinocyclocheilus rhinocerous\t-\t1\t2\t-\t307959\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Otomorpha; Ostariophysi; Otophysi; Cypriniphysae; Cypriniformes; Cyprinoidea; Cyprinidae; Sinocyclocheilus",
    "Sinopodophyllum hexandrum\t-\t1\t1\t11\t93608\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; stem eudicotyledons; Ranunculales; Berberidaceae; Podophylloideae; Sinopodophyllum",
    "Sipyloidea sipylus\t-\t1\t5\t-\t202427\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Phasmatodea; Verophasmatodea; Anareolatae; Diapheromeridae; Necrosciinae; Sipyloidea",
    "soil metagenome\t-\t11\t2\t11\t410658\tENV\tunclassified sequences; metagenomes; ecological metagenomes",
    "Solanum chacoense\tChaco potato\t1\t1\t11\t4108\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum lycopersicum\ttomato\t1\t1\t11\t4081\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum; Lycopersicon",
    "Solanum melongena\teggplant\t1\t1\t11\t4111\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum pennellii\t-\t1\t1\t11\t28526\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum; Lycopersicon",
    "Solanum torvum\t-\t1\t1\t11\t119830\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solanum tuberosum\tpotato\t1\t1\t11\t4113\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Solaneae; Solanum",
    "Solenopsis invicta\tred fire ant\t1\t5\t-\t13686\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Solenopsidini; Solenopsis",
    "Sorex araneus\tEuropean shrew\t1\t2\t-\t42254\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Insectivora; Soricidae; Soricinae; Sorex",
    "Sorghum bicolor\tsorghum\t1\t1\t11\t4558\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Sorghinae; Sorghum",
    "Speleonectes cf. tulumensis BMR-2011\t-\t1\t5\t-\t1032549\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Remipedia; Nectiopoda; Speleonectidae; Speleonectes",
    "Sphaerechinus granularis\t-\t1\t9\t-\t39374\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Temnopleuroida; Toxopneustidae; Sphaerechinus",
    "Sphaeroforma arctica JP610\t-\t1\t1\t-\t667725\tINV\tcellular organisms; Eukaryota; Opisthokonta; Opisthokonta incertae sedis; Ichthyosporea; Ichthyophonida; Sphaeroforma; Sphaeroforma arctica",
    "Sphaeropthalma orestes\t-\t1\t5\t-\t374941\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Pompiloidea; Mutillidae; Sphaeropthalminae; Sphaeropthalma",
    "Spinacia oleracea\tspinach\t1\t1\t11\t3562\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; Caryophyllales; Chenopodiaceae; Chenopodioideae; Anserineae; Spinacia",
    "Spirometra erinaceieuropaei\t-\t1\t9\t-\t99802\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Cestoda; Eucestoda; Diphyllobothriidea; Diphyllobothriidae; Spirometra",
    "Spodoptera exigua\tbeet armyworm\t1\t5\t-\t7107\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Amphipyrinae; Spodoptera",
    "Spodoptera frugiperda\tfall armyworm\t1\t5\t-\t7108\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Amphipyrinae; Spodoptera",
    "Spumella vulgaris\t-\t1\t1\t11\t1117031\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; Chromulinales; Chromulinaceae; Spumella",
    "Spumella-like flagellate JBC/S23\t-\t1\t1\t11\t293195\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; unclassified Chrysophyceae; Spumella-like flagellate JB",
    "Spumella-like flagellate JBNZ39\t-\t1\t1\t11\t293202\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Chrysophyceae; unclassified Chrysophyceae; Spumella-like flagellate JB",
    "Staphylococcus aureus\t-\t11\t0\t-\t1280\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Bacillales; Staphylococcaceae; Staphylococcus",
    "Staphylococcus epidermidis\t-\t11\t0\t-\t1282\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Bacillales; Staphylococcaceae; Staphylococcus",
    "Stegastes partitus\tbicolor damselfish\t1\t2\t-\t144197\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Ovalentaria incertae sedis; Pomacentridae; Stegastes",
    "Stegodyphus mimosarum\t-\t1\t5\t-\t407821\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Araneae; Araneomorphae; Entelegynae; Eresoidea; Eresidae; Stegodyphus",
    "Stenotrophomonas maltophilia\t-\t11\t0\t-\t40324\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Xanthomonadales; Xanthomonadaceae; Stenotrophomonas; Stenotrophomonas maltophilia group",
    "Stigmatomma oregonense\t-\t1\t5\t-\t602440\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Amblyoponinae; Stigmatomma",
    "Stomoxys calcitrans\tstable fly\t1\t5\t-\t35570\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Calyptratae; Muscoidea; Muscidae; Muscinae; Stomoxyini; Stomoxys",
    "Streptococcus agalactiae\t-\t11\t0\t-\t1311\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Streptococcus equi subsp. equi\t-\t11\t0\t-\t148942\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus; Streptococcus dysgalactiae group; Streptococcus equi",
    "Streptococcus pneumoniae\t-\t11\t0\t-\t1313\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Streptococcus suis\t-\t11\t0\t-\t1307\tBCT\tcellular organisms; Bacteria; Terrabacteria group; Firmicutes; Bacilli; Lactobacillales; Streptococcaceae; Streptococcus",
    "Strongylocentrotus purpuratus\tpurple sea urchin\t1\t9\t-\t7668\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Echinodermata; Eleutherozoa; Echinozoa; Echinoidea; Euechinoidea; Echinacea; Echinoida; Strongylocentrotidae; Strongylocentrotus",
    "Strongylus vulgaris\t-\t1\t5\t-\t40348\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Chromadorea; Rhabditida; Strongylida; Strongyloidea; Strongylidae; Strongylinae; Strongylus",
    "Struthio camelus australis\t-\t1\t2\t-\t441894\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Palaeognathae; Struthioniformes; Struthionidae; Struthio; Struthio camelus",
    "Stylophora pistillata\t-\t1\t4\t-\t50429\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Anthozoa; Hexacorallia; Scleractinia; Astrocoeniina; Pocilloporidae; Stylophora",
    "Sus scrofa\tpig\t1\t2\t-\t9823\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Suina; Suidae; Sus",
    "Symbiodinium sp. A1\t-\t1\t4\t11\t503409\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Symbiodinium; Symbiodinium sp. clades; Symbiodinium sp. clade A",
    "Symbiodinium sp. A2\t-\t1\t4\t11\t765178\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Symbiodinium; Symbiodinium sp. clades; Symbiodinium sp. clade A",
    "Symbiodinium sp. B2\t-\t1\t4\t11\t154560\tPLN\tcellular organisms; Eukaryota; Alveolata; Dinophyceae; Suessiales; Symbiodiniaceae; Symbiodinium; Symbiodinium sp. clades; Symbiodinium sp. clade B",
    "Symphylella vulgaris\t-\t1\t5\t-\t1288507\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Myriapoda; Symphyla; Scolopendrellidae; Symphylella",
    "synthetic construct\t-\t11\t0\t11\t32630\tSYN\tother sequences; artificial sequences",
    "Synura sp. LO234KE\t-\t1\t1\t11\t1825120\tPLN\tcellular organisms; Eukaryota; Stramenopiles; Synurophyceae; Synurales; Mallomonadaceae; Synura",
    "Taeniopygia guttata\tzebra finch\t1\t2\t-\t59729\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passeroidea; Estrildidae; Estrildinae; Taeniopygia",
    "Takifugu rubripes\ttorafugu\t1\t2\t-\t31033\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Tetraodontiformes; Tetraodontoidei; Tetradontoidea; Tetraodontidae; Takifugu",
    "Tarenaya hassleriana\t-\t1\t1\t11\t28532\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Brassicales; Cleomaceae; Tarenaya",
    "Tauraco erythrolophus\tred-crested turaco\t1\t2\t-\t121530\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Musophagiformes; Musophagidae; Tauraco",
    "Taxus wallichiana var. chinensis\t-\t1\t1\t11\t29808\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Acrogymnospermae; Pinidae; Cupressales; Taxaceae; Taxus; Taxus wallichiana",
    "Telenomus podisi\t-\t1\t5\t-\t408256\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Platygastroidea; Scelionidae; Telenominae; Telenomus",
    "Teleogryllus commodus\t-\t1\t5\t-\t672150\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Orthopteroidea; Orthoptera; Ensifera; Grylloidea; Gryllidae; Gryllinae; Teleogryllus",
    "Teleopsis dalmanni\t-\t1\t5\t-\t139649\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Diopsoidea; Diopsidae; Teleopsis",
    "Teleopsis whitei\t-\t1\t5\t-\t139651\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Diptera; Brachycera; Muscomorpha; Eremoneura; Cyclorrhapha; Schizophora; Acalyptratae; Diopsoidea; Diopsidae; Teleopsis",
    "Termitomyces clypeatus MTCC 5091\t-\t1\t4\t-\t1282671\tPLN\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Dikarya; Basidiomycota; Agaricomycotina; Agaricomycetes; Agaricomycetidae; Agaricales; Lyophyllaceae; Termitomyces; Termitomyces clypeatus",
    "Tetramorium bicarinatum\t-\t1\t5\t-\t219812\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Tetramoriini; Tetramorium",
    "Tetranychus urticae\ttwo-spotted spider mite\t1\t5\t-\t32264\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Chelicerata; Arachnida; Acari; Acariformes; Trombidiformes; Prostigmata; Eleutherengona; Raphignathae; Tetranychoidea; Tetranychidae; Tetranychus",
    "Tetraodon nigroviridis\tspotted green pufferfish\t1\t2\t-\t99883\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Tetraodontiformes; Tetraodontoidei; Tetradontoidea; Tetraodontidae; Tetraodon",
    "Tetraselmis subcordiformis\t-\t1\t1\t11\t3161\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Chlorophyta; Chlorodendrophyceae; Chlorodendrales; Chlorodendraceae; Tetraselmis",
    "Thamnophis sirtalis\t-\t1\t2\t-\t35019\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Lepidosauria; Squamata; Bifurcata; Unidentata; Episquamata; Toxicofera; Serpentes; Colubroidea; Colubridae; Natricinae; Thamnophis",
    "Theobroma cacao\tcacao\t1\t1\t11\t3641\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; malvids; Malvales; Malvaceae; Byttnerioideae; Theobroma",
    "Thermobia domestica\tfirebrat\t1\t5\t-\t89055\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Zygentoma; Lepismatidae; Thermobia",
    "Tigriopus californicus\t-\t1\t5\t-\t6832\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Crustacea; Maxillopoda; Copepoda; Neocopepoda; Podoplea; Harpacticoida; Harpacticidae; Tigriopus",
    "Tinamus guttatus\twhite-throated tinamou\t1\t2\t-\t94827\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Palaeognathae; Tinamiformes; Tinamidae; Tinamus",
    "Trachemys scripta elegans\t-\t1\t2\t-\t31138\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Testudines; Cryptodira; Durocryptodira; Testudinoidea; Emydidae; Trachemys; Trachemys scripta",
    "Trachymyrmex cornetzi\t-\t1\t5\t-\t471704\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Attini; Trachymyrmex",
    "Trematomus bernacchii\temerald rockcod\t1\t2\t-\t40690\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Eupercaria; Perciformes; Notothenioidei; Nototheniidae; Trematomus",
    "Trichechus manatus latirostris\tFlorida manatee\t1\t2\t-\t127582\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Afrotheria; Sirenia; Trichechidae; Trichechus; Trichechus manatus",
    "Trichinella spiralis\t-\t1\t5\t-\t6334\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Nematoda; Enoplea; Dorylaimia; Trichocephalida; Trichinellidae; Trichinella",
    "Trichobilharzia regenti\t-\t1\t9\t-\t157069\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Platyhelminthes; Trematoda; Digenea; Strigeidida; Schistosomatoidea; Schistosomatidae; Trichobilharzia",
    "Trichomonas vaginalis G3\t-\t1\t0\t11\t412133\tINV\tcellular organisms; Eukaryota; Parabasalia; Trichomonadida; Trichomonadidae; Trichomonas; Trichomonas vaginalis",
    "Trichoplusia ni\tcabbage looper\t1\t5\t-\t7111\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Amphiesmenoptera; Lepidoptera; Glossata; Neolepidoptera; Heteroneura; Ditrysia; Obtectomera; Noctuoidea; Noctuidae; Plusiinae; Trichoplusia",
    "Trifolium pratense\t-\t1\t1\t11\t57577\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Trifolieae; Trifolium",
    "Tripterygion delaisi\t-\t1\t2\t-\t57862\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Blenniimorphae; Blenniiformes; Blennioidei; Tripterygiidae; Tripterygiinae; Tripterygion",
    "Tripterygium wilfordii\t-\t1\t1\t11\t458696\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Celastrales; Celastraceae; Tripterygium",
    "Triticum aestivum\tbread wheat\t1\t1\t11\t4565\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Triticum turgidum\t-\t1\t1\t11\t4571\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Triticum urartu\t-\t1\t1\t11\t4572\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; BOP clade; Pooideae; Triticodae; Triticeae; Triticinae; Triticum",
    "Trypanosoma cruzi strain CL Brener\t-\t1\t4\t11\t353153\tINV\tcellular organisms; Eukaryota; Euglenozoa; Kinetoplastida; Trypanosomatidae; Trypanosoma; Schizotrypanum; Trypanosoma cruzi",
    "Tupaia chinensis\tChinese tree shrew\t1\t2\t-\t246437\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Euarchontoglires; Scandentia; Tupaiidae; Tupaia",
    "Turritopsis sp. SK-2016\t-\t1\t4\t-\t1784781\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Cnidaria; Hydrozoa; Hydroidolina; Anthoathecata; Filifera; Oceaniidae; Turritopsis",
    "Tursiops truncatus\tbottlenosed dolphin\t1\t2\t-\t9739\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Cetacea; Odontoceti; Delphinidae; Tursiops",
    "Tyto alba\tbarn owl\t1\t2\t-\t56313\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Strigiformes; Tytonidae; Tyto",
    "uncultured archaeon\t-\t11\t0\t-\t115547\tENV\tcellular organisms; Archaea; environmental samples",
    "uncultured bacterium\t-\t11\t0\t-\t77133\tENV\tcellular organisms; Bacteria; environmental samples",
    "uncultured eukaryote\t-\t1\t1\t11\t100272\tENV\tcellular organisms; Eukaryota; environmental samples",
    "uncultured fungus\t-\t1\t4\t-\t175245\tENV\tcellular organisms; Eukaryota; Opisthokonta; Fungi; environmental samples",
    "uncultured microorganism\t-\t11\t2\t11\t358574\tENV\tunclassified sequences; environmental samples",
    "uncultured Neocallimastigales\t-\t1\t0\t-\t325898\tENV\tcellular organisms; Eukaryota; Opisthokonta; Fungi; Neocallimastigomycota; Neocallimastigomycetes; Neocallimastigales; environmental samples",
    "uncultured organism\t-\t11\t2\t11\t155900\tENV\tunclassified sequences; environmental samples",
    "uncultured prokaryote\t-\t11\t0\t11\t198431\tENV\tunclassified sequences; environmental samples; prokaryotic environmental samples",
    "uncultured Pseudomonas sp.\t-\t11\t0\t-\t114707\tENV\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Pseudomonadales; Pseudomonadaceae; Pseudomonas; environmental samples",
    "uncultured soil bacterium\t-\t11\t0\t-\t164851\tENV\tcellular organisms; Bacteria; environmental samples",
    "unidentified\t-\t1\t2\t11\t32644\tUNA\tunclassified sequences",
    "unidentified bacterium\t-\t11\t0\t-\t1826778\tBCT\tcellular organisms; Bacteria; unclassified Bacteria; unclassified Bacteria (miscellaneous)",
    "Ursus maritimus\tpolar bear\t1\t2\t-\t29073\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Carnivora; Caniformia; Ursidae; Ursus",
    "Vaccinium macrocarpon\t-\t1\t1\t11\t13750\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; Ericales; Ericaceae; Vaccinioideae; Vaccinieae; Vaccinium",
    "Vibrio cholerae\t-\t11\t0\t-\t666\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Vibrionales; Vibrionaceae; Vibrio",
    "Vibrio parahaemolyticus\t-\t11\t0\t-\t670\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Vibrionales; Vibrionaceae; Vibrio; Vibrio harveyi group",
    "Vicia faba\tfava bean\t1\t1\t11\t3906\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Fabeae; Vicia",
    "Vicugna pacos\talpaca\t1\t2\t-\t30538\tMAM\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Mammalia; Theria; Eutheria; Boreoeutheria; Laurasiatheria; Cetartiodactyla; Tylopoda; Camelidae; Vicugna",
    "Vigna angularis\tadzuki bean\t1\t1\t11\t3914\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Vigna",
    "Vigna radiata\t-\t1\t1\t11\t157791\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Vigna",
    "Vigna radiata var. radiata\tmung bean\t1\t1\t11\t3916\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Fabales; Fabaceae; Papilionoideae; Phaseoleae; Vigna; Vigna radiata",
    "Villosa lienosa\t-\t1\t5\t-\t326719\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Lophotrochozoa; Mollusca; Bivalvia; Palaeoheterodonta; Unionoida; Unionoidea; Unionidae; Unioninae; Villosa",
    "Vitis vinifera\twine grape\t1\t1\t11\t29760\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; rosids incertae sedis; Vitales; Vitaceae; Vitis",
    "Vollenhovia emeryi\t-\t1\t5\t-\t411798\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Stenammini; Vollenhovia",
    "Wasmannia auropunctata\tlittle fire ant\t1\t5\t-\t64793\tINV\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Protostomia; Ecdysozoa; Panarthropoda; Arthropoda; Mandibulata; Pancrustacea; Hexapoda; Insecta; Dicondylia; Pterygota; Neoptera; Endopterygota; Hymenoptera; Apocrita; Aculeata; Vespoidea; Formicidae; Myrmicinae; Blepharidattini; Wasmannia",
    "Withania somnifera\t-\t1\t1\t11\t126910\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; asterids; lamiids; Solanales; Solanaceae; Solanoideae; Physaleae; Withania",
    "Xanthomonas citri pv. citri\t-\t11\t0\t-\t434928\tBCT\tcellular organisms; Bacteria; Proteobacteria; Gammaproteobacteria; Xanthomonadales; Xanthomonadaceae; Xanthomonas; Xanthomonas citri group; Xanthomonas citri",
    "Xenopus laevis\tAfrican clawed frog\t1\t2\t-\t8355\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Pipoidea; Pipidae; Xenopodinae; Xenopus; Xenopus",
    "Xenopus tropicalis\ttropical clawed frog\t1\t2\t-\t8364\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amphibia; Batrachia; Anura; Pipoidea; Pipidae; Xenopodinae; Xenopus; Silurana",
    "Xiphophorus maculatus\tsouthern platyfish\t1\t2\t-\t8083\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Actinopterygii; Actinopteri; Neopterygii; Teleostei; Osteoglossocephalai; Clupeocephala; Euteleosteomorpha; Neoteleostei; Eurypterygia; Ctenosquamata; Acanthomorphata; Euacanthomorphacea; Percomorphaceae; Ovalentaria; Atherinomorphae; Cyprinodontiformes; Cyprinodontoidei; Poeciliidae; Poeciliinae; Xiphophorus",
    "Zantedeschia aethiopica\t-\t1\t1\t11\t69721\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Alismatales; Araceae; Philodendroideae; Zantedeschieae; Zantedeschia",
    "Zea mays\t-\t1\t1\t11\t4577\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Tripsacinae; Zea",
    "Zea mays subsp. mays\tmaize\t1\t1\t11\t381124\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Petrosaviidae; commelinids; Poales; Poaceae; PACMAD clade; Panicoideae; Andropogonodae; Andropogoneae; Tripsacinae; Zea; Zea mays",
    "Ziziphus jujuba\t-\t1\t1\t11\t326968\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; eudicotyledons; Gunneridae; Pentapetalae; rosids; fabids; Rosales; Rhamnaceae; Paliureae; Ziziphus",
    "Zonotrichia albicollis\twhite-throated sparrow\t1\t2\t-\t44394\tVRT\tcellular organisms; Eukaryota; Opisthokonta; Metazoa; Eumetazoa; Bilateria; Deuterostomia; Chordata; Craniata; Vertebrata; Gnathostomata; Teleostomi; Euteleostomi; Sarcopterygii; Dipnotetrapodomorpha; Tetrapoda; Amniota; Sauropsida; Sauria; Archelosauria; Archosauria; Dinosauria; Saurischia; Theropoda; Coelurosauria; Aves; Neognathae; Passeriformes; Passerellidae; Zonotrichia",
    "Zostera noltei\t-\t1\t1\t11\t55326\tPLN\tcellular organisms; Eukaryota; Viridiplantae; Streptophyta; Streptophytina; Embryophyta; Tracheophyta; Euphyllophyta; Spermatophyta; Magnoliophyta; Mesangiospermae; Liliopsida; Alismatales; Zosteraceae; Zostera"
};
