/*
 * Copyright (c) 2005 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma indent

using System
using System.IO
using System.Text

namespace Nemerle.IO
  public class PipeWriter : TextWriter
    output_writer : TextWriter
    filter : string -> string
    line : StringBuilder = StringBuilder ()
    
    /// [filter] is called for each line of the input.
    public this (output_writer : TextWriter, filter : string -> string)
      this.filter = filter
      this.output_writer = output_writer

    public override Encoding : Encoding
      get 
        output_writer.Encoding

    flush_line () : void
      def filtered = filter (line.ToString ())
      line.Length = 0
      output_writer.Write (filtered)

    protected override Dispose (disposing : bool) : void
      base.Dispose (disposing)
      when (line.Length > 0)
        flush_line ()
      (output_writer : IDisposable).Dispose ()

    public override Flush () : void
      output_writer.Flush ()

    public override Write (ch : char) : void
      _ = line.Append (ch)
      when (ch == '\n')
        flush_line ()
    
