/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Extensions;
 
// note that the fact that Tuple`2 and `3 are structs
// is also needed in MType.IsValueType

namespace Nemerle.Builtins {
public abstract class Function ['r] : Function [System.Object, 'r]
{
  public abstract apply () : 'r;
  public override apply (_ : System.Object) : 'r { apply () }
}

public abstract class FunctionVoid : Function [System.Object]
{
  public abstract apply_void () : void;
  public override apply () : System.Object { apply_void (); null }
}

public abstract class Function ['p1, 'r]
{
  public abstract apply (_ : 'p1) : 'r;
}

public abstract class FunctionVoid ['p1] : Function ['p1, System.Object]
{
  public abstract apply_void (_ : 'p1) : void;
  public override apply (p1 : 'p1) : System.Object { apply_void (p1); null }
}

public abstract class Function ['p1, 'p2, 'r] : Function [Tuple ['p1, 'p2], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2) : 'r;
  public override apply (o : Tuple ['p1, 'p2]) : 'r { apply (o.field0, o.field1) }
}

public abstract class FunctionVoid ['p1, 'p2] : FunctionVoid [Tuple ['p1, 'p2]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2) : void;
  public override apply_void (o : Tuple ['p1, 'p2]) : void { apply_void (o.field0, o.field1); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple ['p0, 'p1]
  {
    public field0 : 'p0;
    public field1 : 'p1;
  }

public abstract class Function ['p1, 'p2, 'p3, 'r] : Function [Tuple ['p1, 'p2, 'p3], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3]) : 'r { apply (o.field0, o.field1, o.field2) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3] : FunctionVoid [Tuple ['p1, 'p2, 'p3]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3]) : void { apply_void (o.field0, o.field1, o.field2); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple ['p0, 'p1, 'p2]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4]) : 'r { apply (o.field0, o.field1, o.field2, o.field3) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4]) : void { apply_void (o.field0, o.field1, o.field2, o.field3); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4);}
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
  }

public abstract class Function ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9, 'r] : Function [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9], 'r]
{
  public abstract apply (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9) : 'r;
  public override apply (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]) : 'r { apply (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8) }
}

public abstract class FunctionVoid ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9] : FunctionVoid [Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7,'p8, 'p9]]
{
  public abstract apply_void (_ : 'p1, _ : 'p2, _ : 'p3, _ : 'p4, _ : 'p5, _ : 'p6, _ : 'p7, _ : 'p8, _ : 'p9) : void;
  public override apply_void (o : Tuple ['p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8, 'p9]) : void { apply_void (o.field0, o.field1, o.field2, o.field3, o.field4, o.field5, o.field6, o.field7, o.field8); }
}


  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple ['p0, 'p1, 'p2, 'p3, 'p4, 'p5, 'p6, 'p7, 'p8]
  {
    public field0 : 'p0;
    public field1 : 'p1;
    public field2 : 'p2;
    public field3 : 'p3;
    public field4 : 'p4;
    public field5 : 'p5;
    public field6 : 'p6;
    public field7 : 'p7;
    public field8 : 'p8;
  }
}
