/*
 * Copyright (c) 2005 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Compiler;

namespace Nemerle.DesignPatterns
{
  [Nemerle.MacroUsage (Nemerle.MacroPhase.WithTypedMembers,
                       Nemerle.MacroTargets.Field)]
  macro ProxyPublicMembers (t : TypeBuilder, f : FieldBuilder)
  {
    def classty = match (f.GetMemType()) {
      | Class (typeinfo, _) => typeinfo
      | _ => Message.FatalError ("expected simple class type")
    }
    foreach (mem in classty.GetMembers (BindingFlags.Instance |
                                        BindingFlags.DeclaredOnly | BindingFlags.Public))
    {
      // create Name object for name of created object
      def member_name = t.ParsedName.NewName (mem.Name);
      
      match (mem) {
        | meth is IMethod
          // we must avoid property method here, a little bit hacking solution
          when meth.Attributes & NemerleAttributes.SpecialName == 0 &&
               meth.GetHeader().typarms.Length == 0 =>
      
          // prepare method invocation parameters
          def parms = meth.GetParameters ().Map(fun (p) {
            <[ $(t.ParsedName.NewName (p.name) : name) :
               $(f.GetMemType().ConvertTypeFromTypeInfo (p.ty.Fix(), classty) : typed) ]>
          });
          // prepare created method function parameters
          def fparms = parms.Map (Parsetree.Fun_parm);


          // define the wrapper method
          t.Define (<[ decl:
            public virtual $(member_name : name) (..$fparms)
            : $(f.GetMemType().ConvertTypeFromTypeInfo (meth.ReturnType.Fix(), classty) : typed)
            {
              this.$(f.Name : dyn).$(member_name : name) (..$parms)
            }
          ]>)

        | prop is IProperty when prop.GetGetter() != null && !prop.IsIndexer =>
          t.Define (<[ decl:
            public virtual $(member_name : name) : $(f.GetMemType().TypeOfMember (prop) : typed) {
              get { 
                this.$(f.Name : dyn).$(member_name : name)
              }
            }
          ]>)

        | _ => ()
      }
    }
  }
}
