using Nemerle.IO;

internal class ClassFormatError {
 internal this(_msg : string , params _p : array[object]) {}
}

class UnsupportedClassVersionError : ClassFormatError {
  this(msg : string) { base(msg) }
}

class A {
  public virtual m () : void {
    printf ("A.m\n");
  }
  public virtual Prop : int
  {
    get { 
      printf ("A.Prop\n"); 3
    }
    set {
      printf ("A.Prop set\n");
      ignore (value)
    }
  }
  public this () {}
}

class B : A {
  public override m () : void {
    base.m();
    printf ("B.m\n");
  }
  public this () {}
  public override Prop : int
  {
    get { 
      printf ("B.Prop\n"); base.Prop
    }
    set {
      base.Prop = value;
      printf ("B.Prop set\n");
    }
  }

  public static Main () : void
  {
    def b = B ();
    b.m ();
    b.Prop += 3;
  }
}

/*
BEGIN-OUTPUT
A.m
B.m
B.Prop
A.Prop
A.Prop set
B.Prop set
END-OUTPUT
*/
