
 // Proxy pattern -- Real World example

using System;
using System.Runtime.Remoting;

// "Subject"

public interface IMath
{
  // Methods
   Add( x :  double, y : double ) : double;
   Sub( x :  double, y : double ) : double;
   Mul( x :  double, y : double ) : double;
   Div( x :  double, y : double ) : double;
}

// "RealSubject"

class Math : MarshalByRefObject, IMath
{
  // Methods
  public Add(x : double, y : double ) : double { x + y; }
  public Sub(x : double, y : double ) : double { x - y; }
  public Mul(x : double, y : double ) : double { x * y; }
  public Div(x : double, y : double ) : double { x / y; }
}

// Remote "Proxy Object"

class MathProxy : IMath
{
  // Fields

  // the stubs implementing IMath by calling math.* are automatically generated
  [DesignPatterns.Proxy (IMath)]
  mutable  math : Math;
  
  // Constructors
  public this()
  {
    // Create Math instance in a different AppDomain
    mutable  ad = System.AppDomain.CreateDomain(
                                 "MathDomain",null, null );
    mutable  o =
      ad.CreateInstance("Proxy_RealWorld", "Math", false,
      System.Reflection.BindingFlags.CreateInstance,
      null, null, null,null,null );
    math = ( o.Unwrap() :> Math);
  }
}

variant Bubba ['a] {
  | Foo { x : string; }
  | Goo

  public Length : int {
    get { 1 } 
  }
  public Fire (_x : int) : void {
  }
  public Gene (x : 'a) : 'a { x }
  
  public Gene ['a] (x : 'a) : 'a { x }
}

[Record]
class BubbaExtend ['a] {
  [Nemerle.DesignPatterns.ProxyPublicMembers ()]
  my_bubba : Bubba ['a];
}

/// <summary>
/// ProxyApp test
/// </summary>
public class ProxyApp
{
  public static Main(_args :   array [string] ) :  void
  {
    // Create math proxy
    mutable  p =  MathProxy();

    // Do the math
    Console.WriteLine( "4 + 2 = {0}", p.Add( 4.0, 2.0 ) );
    Console.WriteLine( "4 - 2 = {0}", p.Sub( 4.0, 2.0 ) );
    Console.WriteLine( "4 * 2 = {0}", p.Mul( 4.0, 2.0 ) );
    Console.WriteLine( "4 / 2 = {0}", p.Div( 4.0, 2.0 ) );

    // ProxyPublicMembers macro test
    def x = BubbaExtend (Bubba.Foo("a"));
    _ = x.Length;
    _ = x.Fire (1);
    _ = x.Gene (1);
  }
}

// REFERENCE: proxy-m.dll
