using Nemerle.Collections;
using Nemerle.IO;

#if NUNIT
using NUnit.Framework;

[TestFixture]
public class List_UnitTest : Assertion {

  [Test]
  public Empty () : void
  {
    Assert ([].IsEmpty);
    Assert (![1].IsEmpty);
  }

  [Test]
  public CopyTo () : void
  {
    def l = [1, 2, 3];
    def a = array (3);
    l.CopyTo (a);
    mutable i = 0;
    foreach (item in l) {
      AssertEquals (item, a[i]);
      ++ i;
    }
  }

  [Test]
  public CopyToLen () : void
  {
    def l = [1, 2, 3];
    def a = array (2);
    l.CopyTo (a, 2);
    mutable i = 0;
    foreach (item in l) {
      when (i < a.Length)
        AssertEquals (item, a[i]);
      ++ i;
    }
  }

}
#endif

