using Nemerle;
using Nemerle.Collections;

class SomeObj : IComparable[SomeObj]  {
  id : int;
  
  public override GetHashCode () : int
  {
    id
  }

  public override Equals (other : object) : bool
  {
    other == this
  }

  public CompareTo (oth : SomeObj) : int
  {
    id - oth.id
  }

  static mutable cid : int;

  public this ()
  {
    id = cid;
    cid++;
  }
}

module M {
  mutable cnt : int;
  mutable ar : array [SomeObj];
  mutable ht : NemerleMap [SomeObj, object];
  
  test_ht () : void
  {
    for (mutable i = 0; i < 10; ++i)
      when (ht.Member (ar[i]))
        ++cnt;
  }
  
  public Main () : void
  {
    ar = array(20);
    for (mutable i = 0; i < 10; ++i)
      ar[i] = SomeObj();
    ht = NemerleMap ();
    ht = ht.Add (ar[1], null);
    ht = ht.Add (ar[3], null);
    ht = ht.Add (ar[7], null);
    ht = ht.Add (ar[4], null);
    for (mutable i = 0; i < 1000000; ++i)
      test_ht ();
    System.Console.WriteLine (cnt);
  }
}
