using Nemerle.IO;
using Nemerle.Concurrency;

namespace Test 
{
    class Readerwriter
    {
        public this ()
        {
            Idle ()
        }
        
        [ChordMember]
        Idle () : void;

        [ChordMember]
        S (n : int) : void;

        public Shared () : void
        chord {
            | Idle =>
              S (1)

            | S =>
              S (n + 1)
        }

        public ReleaseShared () : void
        chord {
          | S =>
              if (n == 1) Idle ()
              else S (n - 1)
        }

        public Exclusive () : void
        chord {
          | Idle => ()
        }

        public ReleaseExclusive () : void
        {
            Idle ()
        }
    }

    module Main
    {
        mutable rw : Readerwriter;

        async Reader (i : int) : void
        {
            rw.Shared ();
            print_locked (sprintf ("+R%d\n", i));
            SleepRandom ();
            print_locked (sprintf ("-R%d\n", i));
            rw.ReleaseShared ();
        }

        async Writer (i : int) : void
        {
            rw.Exclusive ();
            print_locked (sprintf ("+W%d\n", i));
            SleepRandom ();
            print_locked (sprintf ("-W%d\n", i));
            rw.ReleaseExclusive ();
        }

        Main () : void
        {
            rw = Readerwriter ();

            async for (mutable i = 1; i <= 10; ++i)
            {
                Reader (i);
                Sleep (100);
            }

            async for (mutable i = 1; i <= 5; ++i)
            {
                Writer (i);
                Sleep (100);
            }
        }

        print_locked (s : string) : void
        {
            lock (rw) printf ("%s", s);           
        }

        Sleep (ms : int) : void
        {
            when (ms > 0) System.Threading.Thread.Sleep (ms)
        }

        mutable random : System.Random;
        SleepRandom () : void
        {
            when (random == null) random = System.Random ();
            Sleep (random.Next (3000))
        }
    }
}

