using System;
using System.Collections;
using System.Net;
using System.Net.Sockets;

using EraSMSSender;

namespace POP3Client
{
  public class POP3Client : POP3Naked
  {
    protected mutable server        : string;
    protected mutable user          : string;
    protected mutable password      : string;

    protected mutable serverString  : string;

    protected mutable messageBuffer : ArrayList;
    protected mutable headerBuffer  : ArrayList;

    protected mutable lastBuffered  : string;

    protected mutable informer      : Informer;

    protected mutable state         : MailInfoArray;
    

    public this (server : string, user : string, password : string)
    {
      messageBuffer = ArrayList ();
      headerBuffer  = ArrayList ();
      lastBuffered  = String.Empty;
    
      this.server   = server;
      this.user     = user;
      this.password = password;
    }


    public Informer : Informer
    {
      get { informer }
      set { informer = value }
    }


    public User : string
    {
      get { user }
      set { user = value }
    }


    public Server : string
    {
      get { server }
      set { server = value }
    }


    public Password : string
    {
      get { password }
      set { password = value }
    }
    
    
    public new Connect () : void
    {
      if (informer != null) informer.Inform ("Connecting...", null) else {};

      if (socket == null || !socket.Connected)
      {
        (this : POP3Naked).Connect ();
        socket.Connect (IPEndPoint (Dns.Resolve (server).AddressList[0], 110));
        serverString = Receive ().Split (array [' '], 2)[1];
      }
      else {};

      if (informer != null) informer.Inform ("Authorizing...", null) else {};

      USER (user);
      PASS (password);
    }


    public GetHeader (number : int) : MailHeader
    {
      GetHeader (number, 5);
    }
    

    public GetHeader (number : int, retrie : int) : MailHeader
    {
      mutable retries  = retrie;
      mutable received = String.Empty;
      mutable retry    = 0;
      mutable result   = (null : MailHeader);

      do
      {
        if (informer != null) informer.Inform ("Receiving header " + number.ToString () + "..." +
                      (if (retry > 0) ("(" + retry.ToString () + ")") else String.Empty), null)
                      else {};

        try
        {
          received = TOP (number, 0);
//          Console.WriteLine ("---------");
//          Console.WriteLine (received);
//          Console.WriteLine ("---------");
          result   = MailHeader (received.Substring (received.IndexOf ('\n') + 1));
        }
        catch
        {
          | e is CommandException =>
            if (retries <= 0 || e.Type == Error.FATALERROR) throw CommandException (e.Type, e.Message)
            else
            {
              retries = retries - 1;
              retry   = retry + 1;
              
              if (informer != null) informer.Inform ("Waiting 5 seconds for server ...", null) else {};

              System.Threading.Thread.Sleep (5000);
              Console.WriteLine ("Err");
            };
          | _e =>
            retries = retries - 1;
            retry   = retry + 1;
        }
      }
      while (retries >= 0 && result == null);
      
//      Console.WriteLine ("Out");

      result;
    }
    
    
    public GetMessage (number : int) : Message
    {
      GetMessage (number, 5);
    }
    
    
    public GetMessage (numbe : int, retrie : int) : Message
    {
      mutable number   = numbe;
      mutable retries  = retrie;
      mutable received = String.Empty;
      mutable retry    = 0;
      mutable result   = (null : Message);

      do
      {
        if (informer != null) informer.Inform ("Receiving message " + number.ToString () + "..." +
                      (if (retry > 0) ("(" + retry.ToString () + ")") else String.Empty), null)
                      else {};

        try
        {
          mutable mailInfo = LIST (number);
          RETR (number);
          received = Receive (mailInfo.Size);

          result = Message (received.Substring (received.IndexOf ('\n') + 1));
        }
        catch
        {
          | e is CommandException =>
            if (retries <= 0 || e.Type == Error.FATALERROR) throw CommandException (e.Type, e.Message)
            else
            {
              retries = retries - 1;
              retry   = retry + 1;
              
              if (informer != null) informer.Inform ("Waiting 5 seconds for server ...", null) else {};
              
              System.Threading.Thread.Sleep (5000);
            };
          | _e =>
            retries = retries - 1;
            retry   = retry + 1;
        };
      }
      while (retries >= 0 && result == null);

      result;
    }


    public GetMessageCount () : int
    {
      STAT ().Number;
    }


    public GetMessages (senderMail : string) : ArrayList 
    {
      GetMessages (senderMail, 5);
    }
    
    
    public GetMessages (senderMail : string, _retries : int) : ArrayList
    {
      mutable messageCount = GetMessageCount ();
      mutable beginHeader  = 1;
      mutable newstate     = LIST ();

      if (state == null || !newstate.StartsWith (state))
      {
        state        = newstate;
        lastBuffered = null;
        
//        Console.WriteLine ("New Messages");
      }
      else {};//Console.WriteLine ("Old Messages");

      if (lastBuffered != null && lastBuffered.Equals (senderMail))
      {
        beginHeader = headerBuffer.Count + 1;
      }
      else
      {
        headerBuffer.Clear ();
        messageBuffer.Clear ();
        lastBuffered = senderMail;
      };
      
      for (mutable i = beginHeader; i <= messageCount; i = i + 1)
      {
        mutable header = GetHeader (i);

        if (header != null)
        {
          if (senderMail.Equals (header.Sender.Email))
          {
            mutable message = GetMessage (i);

            if (message != null) ignore (messageBuffer.Add (message)) else {};
          }
          else {};

          ignore (headerBuffer.Add (header));
        }
        else {};
      };

      lastBuffered = senderMail;
      
      messageBuffer;
    }
    

    public GetHeaders (senderMail : string) : ArrayList
    {
      mutable messageCount = GetMessageCount ();
      mutable begin        = 1;
      mutable result       = ArrayList ();
      mutable newstate     = LIST ();

      if (state == null || !newstate.StartsWith (state))
      {
        lastBuffered = null;
        state        = newstate;
      }
      else {};
      
      if (lastBuffered != null && lastBuffered.Equals (senderMail))
      {
        begin        = headerBuffer.Count + 1;
        
//        Console.WriteLine ("Old Headers.");
      }
      else
      {
        Console.WriteLine ("New Headers.");
        headerBuffer.Clear ();
        messageBuffer.Clear ();
        lastBuffered = senderMail;
      };
      
      for (mutable i = begin; i <= messageCount; i = i + 1)
      {
        mutable header = GetHeader (i);
        
        if (header != null) ignore (headerBuffer.Add (header)) else {};
      };

      foreach (header :> MailHeader in headerBuffer)
      {
        if (senderMail.Equals (header.Sender.Email)) ignore (result.Add (header)) else {};
      };

      result;
    }
    

    public GetMessageCount (senderMail : string) : int
    {
      GetHeaders (senderMail).Count;
    }
  }
}
