using Nemerle.IO;

using System.IO;
using System.Collections;
using System.Byte;
using System.Windows.Forms;

module M {

   pow2(n : int) : int{
      mutable k = 1;
      for(mutable i = 1; i <= n; i = i + 1)
            k = k*2;
      k;
   }
   byteToCode (c : int, n : int) : string {
      mutable s = "";
      mutable d = c/pow2(8 - n);
      
      for (mutable i = 0; i < n; i = i + 1){
         if (d%2 == 0) 
            s = "0" + s
         else 
            s = "1" + s;
         d = d/2;   
      };
      s;
   }
   buildHashTable(f :  Stream) : Hashtable {
      def HT  = Hashtable();
      mutable c = 0;
      mutable kod = "";
      mutable d = 0;

      for (mutable i = 0; i < 256; i = i + 1){
         c = f.ReadByte(); //dlugosc kodu - ilosc bitow
         for (mutable j = 0; j < c/8; j = j + 1)
             kod = kod + byteToCode(f.ReadByte(), 8);
             
         when (c%8 != 0){ d = f.ReadByte();
            when(c > 0) printf("kod %c %d   ", (d :> char), d);
            kod = kod + byteToCode(d, c%8)};

            
         when (c != 0) {
            HT.Add(kod, (i :> System.Byte) );    
            printf("%c-%s\n", (i :> char), kod);
         };
         kod = "";
      };
    HT;
   }
   
   decompress(f : Stream, f2 : Stream) : void {
      def HT = buildHashTable(f);
      mutable c1 = f.ReadByte();
      mutable c2 = f.ReadByte();
      mutable s = "";
      mutable kod = "";

      when( c2 != -1){ //plik nie pusty;
      
      mutable c3 = f.ReadByte();
      while(c3 != -1) {
         s = byteToCode (c1,8);
         c1 = c2;
         c2 = c3;
         c3 = f.ReadByte();
         for (mutable i = 0; i < 8; i = i + 1){
            kod = string.Concat (kod, s[i]);
            when (HT.Contains(kod)){
               f2.WriteByte((HT[kod] :> System.Byte));
               kod = "";
            };
         };
         
      };

      s = byteToCode (c1,c2);

      for (mutable i = 0; i < c2; i = i + 1){
         kod = string.Concat (kod, s[i]);
         when (HT.Contains(kod)){
            f2.WriteByte((HT[kod]:>System.Byte));
            kod = "";
         };
      };
      
      };//when

   }
   
   
   Main () : void {
      mutable openFileDialog = OpenFileDialog();
      openFileDialog.InitialDirectory = Application.StartupPath;
      openFileDialog.Filter = "dwojak|*.dwo";
      when (openFileDialog.ShowDialog() == DialogResult.OK)
      {
          def fileName = openFileDialog.FileName;
          def f = File.Open(fileName, FileMode.Open, FileAccess.Read, FileShare.None);
          def f2 = FileStream(fileName.Remove(fileName.Length - 4, 4), FileMode.Create);
          decompress(f, f2);
          
          f.Close();
          f2.Close();
      }
   }
}
