
using System;
using Nemerle.Collections;
using System.Threading;

// "Singleton"

[DesignPatterns.Singleton (GetLoadBalancer)]
class LoadBalancer
{
  private servers : Vector [string] = Vector (5);
  private random : Random = Random ();

  // Constructors (protected)
  protected this ()
  {
    // List of available servers
    servers.Add( "ServerI" );
    servers.Add( "ServerII" );
    servers.Add( "ServerIII" );
    servers.Add( "ServerIV" );
    servers.Add( "ServerV" );
  }

  // Properties
  public Server : string
  {
    get
    {
      // Simple, but effective random load balancer
      def r = random.Next (servers.Count);
      servers [r];
    }
  }
}

/// <summary>
/// SingletonApp test
/// </summary>
///
public class SingletonApp
{
  public static Main() : void
  {
    def b1 = LoadBalancer.GetLoadBalancer;
    def b2 = LoadBalancer.GetLoadBalancer;
    def b3 = LoadBalancer.GetLoadBalancer;
    def b4 = LoadBalancer.GetLoadBalancer;

    // Same instance?
    when ((b1 : object == b2) && (b2 : object == b3) && (b3 : object == b4))
      Console.WriteLine( "Same instance" );

    // Do the load balancing
    Console.WriteLine( b1.Server[0] );
    Console.WriteLine( b2.Server[1] );
    Console.WriteLine( b3.Server[2] );
    Console.WriteLine( b4.Server[3] );
  }
}

// REFERENCE: singleton-m.dll

/*
BEGIN-OUTPUT
Same instance
S
e
r
v
END-OUTPUT
*/
