/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */ 

namespace Sioux
{
  using Nemerle.Utility;

  using System.Net;
  using System.Net.Sockets;

  /**
   * An HTTP server capable of hosting Nemerle web applications.
   */
  class EntryPoint
  {    
    /* -- PUBLIC METHODS --------------------------------------------------- */

    /**
     * Starts the server.
     */
    public static Main () : void
    {  
      // parse the command line options
      mutable config_file_name = None ();
      mutable log_file_name = None ();

      //System.Console.WriteLine(System.Diagnostics.Process.GetCurrentProcess().Id.ToString());
      
      def opts = [
        Getopt.CliOption.String (name    = "-config",
                       aliases = ["-c"],
                       help    = "Alternative configuration file.",
                       handler = fun (s) { config_file_name = Some (s); }),
        Getopt.CliOption.String (name    = "-logfile",
                       aliases = ["-l"],
                       help    = "Alternative log file.",
                       handler = fun (s) { log_file_name = Some (s); })
      ];

      Getopt.Parse (opts);
      
      // the dynamic content handler
      def dynamic_handler (request : Request, response : Response) : void
      {
        def app = Sioux.AppChooser ();
        app.HandleRequest (request, response)
      };
      
      // initialize the server
      Httpd.Initialize (config_file_name, log_file_name, dynamic_handler);

      // start listening for connections
      Httpd.Run ();
      
      // perform deinitialization and quit
      Httpd.Destroy ();
    }
  }
}
