using System
using Nemerle
using Nemerle.Utility

abstract class Territory : MapObject
  protected DisplayWhenVisible : ColoredChar
  protected DisplayWhenSeen : ColoredChar
  protected DisplayWhenUnseen : ColoredChar = ColoredChar (' ')

  protected mutable ever_seen : bool
  
  public override Draw () : void
    if (Map.PlayerCanSee (this))
      ever_seen = true
      ConsoleBuffer.DrawChar (DisplayWhenVisible)
    else if (ever_seen || Map.ShowAll)
      ConsoleBuffer.DrawChar (DisplayWhenSeen)
    else
      ConsoleBuffer.DrawChar (DisplayWhenUnseen)

class Floor : Territory
  public this ()
    DisplayWhenVisible = ColoredChar ('.', ConsoleColor.Yellow)
    DisplayWhenSeen = ColoredChar ('.', ConsoleColor.Gray)

  public override CanEnter : bool
    get { true }

  public override Name : string
    get { "floor" }

class Wall : Territory
  public this ()
    DisplayWhenVisible = ColoredChar ('#', ConsoleColor.DarkYellow)
    DisplayWhenSeen = DisplayWhenVisible

  Visible : bool
    [Memoize] \
    get
      def check (x, y) { Map [x, y].Exists (_.CanEnter) }

      (check (X - 1, Y - 1)
        || check (X + 1, Y - 1)
        || check (X - 1, Y + 1)
        || check (X + 1, Y + 1)
        || check (X - 1, Y)
        || check (X, Y - 1)
        || check (X, Y + 1) 
        || check (X + 1, Y))
  

  public override Draw () : void
    if (Visible)
      base.Draw ()
    else
      ConsoleBuffer.DrawChar (DisplayWhenUnseen)

  public override Name : string
    get { "wall" }
